"use strict";exports.__esModule=true;exports.verifyAndLint=verifyAndLint;var _chalk=_interopRequireDefault(require("chalk"));var _jestWorker=require("jest-worker");var _fs=require("fs");var _path=require("path");var _constants=require("./constants");var _events=require("../telemetry/events");var _compileError=require("./compile-error");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}async function verifyAndLint(dir,configLintDirs,numWorkers,enableWorkerThreads,telemetry){try{const lintWorkers=new _jestWorker.Worker(require.resolve('./eslint/runLintCheck'),{numWorkers,enableWorkerThreads});lintWorkers.getStdout().pipe(process.stdout);lintWorkers.getStderr().pipe(process.stderr);const lintDirs=(configLintDirs!=null?configLintDirs:_constants.ESLINT_DEFAULT_DIRS).reduce((res,d)=>{const currDir=(0,_path.join)(dir,d);if(!(0,_fs.existsSync)(currDir))return res;res.push(currDir);return res;},[]);const lintResults=await lintWorkers.runLintCheck(dir,lintDirs,true);const lintOutput=typeof lintResults==='string'?lintResults:lintResults==null?void 0:lintResults.output;if(typeof lintResults!=='string'&&lintResults!=null&&lintResults.eventInfo){telemetry.record((0,_events.eventLintCheckCompleted)({...lintResults.eventInfo,buildLint:true}));}if(typeof lintResults!=='string'&&lintResults!=null&&lintResults.isError&&lintOutput){await telemetry.flush();throw new _compileError.CompileError(lintOutput);}if(lintOutput){console.log(lintOutput);}lintWorkers.end();}catch(err){if(err.type==='CompileError'||err instanceof _compileError.CompileError){console.error(_chalk.default.red('\nFailed to compile.'));console.error(err.message);process.exit(1);}else if(err.type==='FatalError'){console.error(err.message);process.exit(1);}throw err;}}
//# sourceMappingURL=verifyAndLint.js.map