"use strict";exports.__esModule=true;exports.loadWebpackHook=loadWebpackHook;var _path=_interopRequireDefault(require("path"));var _jestWorker=require("jest-worker");var Log=_interopRequireWildcard(require("../../build/output/log"));var _configUtilsWorker=require("./config-utils-worker");exports.install=_configUtilsWorker.install;exports.shouldLoadWithWebpack5=_configUtilsWorker.shouldLoadWithWebpack5;var _constants=require("../lib/constants");function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap();_getRequireWildcardCache=function(){return cache;};return cache;}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj;}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj};}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj);}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc);}else{newObj[key]=obj[key];}}}newObj.default=obj;if(cache){cache.set(obj,newObj);}return newObj;}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function reasonMessage(reason){switch(reason){case'default':return'Enabled by default';case'flag-disabled':return'webpack5 flag is set to false in next.config.js';case'test-mode':return'internal test mode';default:return'';}}async function loadWebpackHook(phase,dir){let useWebpack5=true;let usesRemovedFlag=false;const worker=new _jestWorker.Worker(_path.default.resolve(__dirname,'./config-utils-worker.js'),{enableWorkerThreads:false,numWorkers:1,forkOptions:{env:{...process.env,NODE_OPTIONS:''}}});try{const result=await worker.shouldLoadWithWebpack5(phase,dir);if(result.reason==='future-flag'){usesRemovedFlag=true;}else{if(phase!==_constants.PHASE_PRODUCTION_SERVER){Log.info(`Using webpack ${result.enabled?'5':'4'}. Reason: ${reasonMessage(result.reason)} https://nextjs.org/docs/messages/webpack5`);}}useWebpack5=Boolean(result.enabled);}catch(_unused){// If this errors, it likely will do so again upon boot, so we just swallow
// it here.
}finally{worker.end();}if(usesRemovedFlag){throw new Error('`future.webpack5` in `next.config.js` has moved to the top level `webpack5` flag https://nextjs.org/docs/messages/future-webpack5-moved-to-webpack5');}(0,_configUtilsWorker.install)(useWebpack5);}
//# sourceMappingURL=config-utils.js.map