"use strict";exports.__esModule=true;exports.decodeBuffer=decodeBuffer;exports.rotate=rotate;exports.resize=resize;exports.encodeJpeg=encodeJpeg;exports.encodeWebp=encodeWebp;exports.encodePng=encodePng;var _codecs=require("./codecs");var _image_data=_interopRequireDefault(require("./image_data"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}async function decodeBuffer(_buffer){var _Object$entries$find;const buffer=Buffer.from(_buffer);const firstChunk=buffer.slice(0,16);const firstChunkString=Array.from(firstChunk).map(v=>String.fromCodePoint(v)).join('');const key=(_Object$entries$find=Object.entries(_codecs.codecs).find(([,{detectors}])=>detectors.some(detector=>detector.exec(firstChunkString))))==null?void 0:_Object$entries$find[0];if(!key){throw Error(`Buffer has an unsupported format`);}const d=await _codecs.codecs[key].dec();return d.decode(new Uint8Array(buffer));}async function rotate(image,numRotations){image=_image_data.default.from(image);const m=await _codecs.preprocessors['rotate'].instantiate();return await m(image.data,image.width,image.height,{numRotations});}async function resize({image,width,height}){image=_image_data.default.from(image);const p=_codecs.preprocessors['resize'];const m=await p.instantiate();return await m(image.data,image.width,image.height,{...p.defaultOptions,width,height});}async function encodeJpeg(image,{quality}){image=_image_data.default.from(image);const e=_codecs.codecs['mozjpeg'];const m=await e.enc();const r=await m.encode(image.data,image.width,image.height,{...e.defaultEncoderOptions,quality});return Buffer.from(r);}async function encodeWebp(image,{quality}){image=_image_data.default.from(image);const e=_codecs.codecs['webp'];const m=await e.enc();const r=await m.encode(image.data,image.width,image.height,{...e.defaultEncoderOptions,quality});return Buffer.from(r);}async function encodePng(image){image=_image_data.default.from(image);const e=_codecs.codecs['oxipng'];const m=await e.enc();const r=await m.encode(image.data,image.width,image.height,{...e.defaultEncoderOptions});return Buffer.from(r);}
//# sourceMappingURL=impl.js.map