"use strict";exports.__esModule=true;exports.default=exports.NextServer=void 0;require("../next-server/server/node-polyfill-fetch");var _constants=require("../lib/constants");var log=_interopRequireWildcard(require("../build/output/log"));var _config=_interopRequireDefault(require("../next-server/server/config"));var _path=require("path");var _constants2=require("../next-server/lib/constants");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap();_getRequireWildcardCache=function(){return cache;};return cache;}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj;}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj};}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj);}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc);}else{newObj[key]=obj[key];}}}newObj.default=obj;if(cache){cache.set(obj,newObj);}return newObj;}let ServerImpl;const getServerImpl=async()=>{if(ServerImpl===undefined)ServerImpl=(await Promise.resolve().then(()=>_interopRequireWildcard(require('../next-server/server/next-server')))).default;return ServerImpl;};class NextServer{constructor(options){this.serverPromise=void 0;this.server=void 0;this.reqHandlerPromise=void 0;this.preparedAssetPrefix=void 0;this.options=void 0;this.options=options;}getRequestHandler(){return async(req,res,parsedUrl)=>{const requestHandler=await this.getServerRequestHandler();return requestHandler(req,res,parsedUrl);};}setAssetPrefix(assetPrefix){if(this.server){this.server.setAssetPrefix(assetPrefix);}else{this.preparedAssetPrefix=assetPrefix;}}logError(...args){if(this.server){this.server.logError(...args);}}async render(...args){const server=await this.getServer();return server.render(...args);}async renderToHTML(...args){const server=await this.getServer();return server.renderToHTML(...args);}async renderError(...args){const server=await this.getServer();return server.renderError(...args);}async renderErrorToHTML(...args){const server=await this.getServer();return server.renderErrorToHTML(...args);}async render404(...args){const server=await this.getServer();return server.render404(...args);}async serveStatic(...args){const server=await this.getServer();return server.serveStatic(...args);}async prepare(){const server=await this.getServer();return server.prepare();}async close(){const server=await this.getServer();return server.close();}async createServer(options){if(options.dev){const DevServer=require('./next-dev-server').default;return new DevServer(options);}return new(await getServerImpl())(options);}async loadConfig(){const phase=this.options.dev?_constants2.PHASE_DEVELOPMENT_SERVER:_constants2.PHASE_PRODUCTION_SERVER;const dir=(0,_path.resolve)(this.options.dir||'.');const conf=await(0,_config.default)(phase,dir,this.options.conf);return conf;}async getServer(){if(!this.serverPromise){setTimeout(getServerImpl,10);this.serverPromise=this.loadConfig().then(async conf=>{this.server=await this.createServer({...this.options,conf});if(this.preparedAssetPrefix){this.server.setAssetPrefix(this.preparedAssetPrefix);}return this.server;});}return this.serverPromise;}async getServerRequestHandler(){// Memoize request handler creation
if(!this.reqHandlerPromise){this.reqHandlerPromise=this.getServer().then(server=>server.getRequestHandler().bind(server));}return this.reqHandlerPromise;}}// This file is used for when users run `require('next')`
exports.NextServer=NextServer;function createServer(options){const standardEnv=['production','development','test'];if(options==null){throw new Error('The server has not been instantiated properly. https://nextjs.org/docs/messages/invalid-server-options');}if(!options.isNextDevCommand&&process.env.NODE_ENV&&!standardEnv.includes(process.env.NODE_ENV)){log.warn(_constants.NON_STANDARD_NODE_ENV);}if(options.dev){if(typeof options.dev!=='boolean'){console.warn("Warning: 'dev' is not a boolean which could introduce unexpected behavior. https://nextjs.org/docs/messages/invalid-server-options");}}return new NextServer(options);}// Support commonjs `require('next')`
module.exports=createServer;exports=module.exports;// Support `import next from 'next'`
var _default=createServer;exports.default=_default;
//# sourceMappingURL=next.js.map