export declare function processValue(value: any, scalarName: string): number;
/**
 * Check if the value is in decimal format.
 *
 * @param value - Value to check
 * @returns True if is decimal, false otherwise
 */
export declare function isDecimal(value: any): boolean;
/**
 * Check if the value is in sexagesimal format.
 *
 * @param value - Value to check
 * @returns True if sexagesimal, false otherwise
 */
export declare function isSexagesimal(value: any): boolean;
/**
 * Converts a sexagesimal coordinate to decimal format.
 *
 * @param value - Value to convert
 * @returns Decimal coordinate
 * @throws {TypeError} if the value is not in sexagesimal format
 */
export declare function sexagesimalToDecimal(value: any): number;
