"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPureHelper = exports.isHelper = exports.isWithThemeHelper = exports.isKeyframesHelper = exports.isInjectGlobalHelper = exports.isCreateGlobalStyleHelper = exports.isCSSHelper = exports.isStyled = exports.importLocalName = exports.isValidTopLevelImport = void 0;

var _options = require("./options");

const VALID_TOP_LEVEL_IMPORT_PATHS = ['styled-components', 'styled-components/no-tags', 'styled-components/native', 'styled-components/primitives'];

const isValidTopLevelImport = (x, state) => [...VALID_TOP_LEVEL_IMPORT_PATHS, ...(0, _options.useTopLevelImportPaths)(state)].includes(x);

exports.isValidTopLevelImport = isValidTopLevelImport;
const localNameCache = {};

const importLocalName = (name, state, options = {}) => {
  const {
    cacheIdentifier,
    bypassCache = false
  } = options;
  const cacheKeyAffix = cacheIdentifier ? `|${cacheIdentifier}` : '';
  const cacheKey = name + state.file.opts.filename + cacheKeyAffix;

  if (!bypassCache && cacheKey in localNameCache) {
    return localNameCache[cacheKey];
  }

  let localName = state.styledRequired ? name === 'default' ? 'styled' : name : false;
  state.file.path.traverse({
    ImportDeclaration: {
      exit(path) {
        const {
          node
        } = path;

        if (isValidTopLevelImport(node.source.value, state)) {
          for (const specifier of path.get('specifiers')) {
            if (specifier.isImportSpecifier() && specifier.node.imported.name === 'styled') {
              localName = 'styled';
            }

            if (specifier.isImportDefaultSpecifier()) {
              localName = specifier.node.local.name;
            }

            if (specifier.isImportSpecifier() && specifier.node.imported.name === name) {
              localName = specifier.node.local.name;
            }

            if (specifier.isImportNamespaceSpecifier()) {
              localName = specifier.node.local.name;
            }
          }
        }
      }

    }
  });
  localNameCache[cacheKey] = localName;
  return localName;
};

exports.importLocalName = importLocalName;

const isStyled = t => (tag, state) => {
  if (t.isCallExpression(tag) && t.isMemberExpression(tag.callee) && tag.callee.property.name !== 'default'
  /** ignore default for #93 below */
  ) {
      // styled.something()
      return isStyled(t)(tag.callee.object, state);
    } else {
    return t.isMemberExpression(tag) && tag.object.name === importLocalName('default', state, {
      cacheIdentifier: tag.object.name
    }) || t.isCallExpression(tag) && tag.callee.name === importLocalName('default', state, {
      cacheIdentifier: tag.callee.name
    }) ||
    /**
     * #93 Support require()
     * styled-components might be imported using a require()
     * call and assigned to a variable of any name.
     * - styled.default.div``
     * - styled.default.something()
     */
    state.styledRequired && t.isMemberExpression(tag) && t.isMemberExpression(tag.object) && tag.object.property.name === 'default' && tag.object.object.name === state.styledRequired || state.styledRequired && t.isCallExpression(tag) && t.isMemberExpression(tag.callee) && tag.callee.property.name === 'default' && tag.callee.object.name === state.styledRequired;
  }
};

exports.isStyled = isStyled;

const isCSSHelper = t => (tag, state) => t.isIdentifier(tag) && tag.name === importLocalName('css', state);

exports.isCSSHelper = isCSSHelper;

const isCreateGlobalStyleHelper = t => (tag, state) => t.isIdentifier(tag) && tag.name === importLocalName('createGlobalStyle', state);

exports.isCreateGlobalStyleHelper = isCreateGlobalStyleHelper;

const isInjectGlobalHelper = t => (tag, state) => t.isIdentifier(tag) && tag.name === importLocalName('injectGlobal', state);

exports.isInjectGlobalHelper = isInjectGlobalHelper;

const isKeyframesHelper = t => (tag, state) => t.isIdentifier(tag) && tag.name === importLocalName('keyframes', state);

exports.isKeyframesHelper = isKeyframesHelper;

const isWithThemeHelper = t => (tag, state) => t.isIdentifier(tag) && tag.name === importLocalName('withTheme', state);

exports.isWithThemeHelper = isWithThemeHelper;

const isHelper = t => (tag, state) => isCSSHelper(t)(tag, state) || isKeyframesHelper(t)(tag, state) || isWithThemeHelper(t)(tag, state);

exports.isHelper = isHelper;

const isPureHelper = t => (tag, state) => isCSSHelper(t)(tag, state) || isKeyframesHelper(t)(tag, state) || isCreateGlobalStyleHelper(t)(tag, state) || isWithThemeHelper(t)(tag, state);

exports.isPureHelper = isPureHelper;