'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const tslib = require('tslib');
const crossFetch = require('cross-fetch');
const graphql = require('graphql');

var DEFAULT_APOLLO_ENDPOINT = 'https://engine-graphql.apollographql.com/api/graphql';
/**
 * This loader loads a schema from Apollo Engine
 */
var ApolloEngineLoader = /** @class */ (function () {
    function ApolloEngineLoader() {
    }
    ApolloEngineLoader.prototype.loaderId = function () {
        return 'apollo-engine';
    };
    ApolloEngineLoader.prototype.canLoad = function (ptr) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            return tslib.__generator(this, function (_a) {
                return [2 /*return*/, typeof ptr === 'string' && ptr === 'apollo-engine'];
            });
        });
    };
    ApolloEngineLoader.prototype.canLoadSync = function () {
        return false;
    };
    ApolloEngineLoader.prototype.load = function (_, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var response, _a, data, errors;
            return tslib.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, crossFetch.fetch(options.engine.endpoint || DEFAULT_APOLLO_ENDPOINT, {
                            method: 'POST',
                            headers: tslib.__assign({ 'x-api-key': options.engine.apiKey, 'apollo-client-name': 'Apollo Language Server', 'apollo-client-reference-id': '146d29c0-912c-46d3-b686-920e52586be6', 'apollo-client-version': '2.6.8', 'Content-Type': 'application/json', Accept: 'application/json' }, options.headers),
                            body: JSON.stringify({
                                query: SCHEMA_QUERY,
                                variables: {
                                    id: options.graph,
                                    tag: options.variant,
                                },
                            }),
                        })];
                    case 1:
                        response = _b.sent();
                        return [4 /*yield*/, response.json()];
                    case 2:
                        _a = _b.sent(), data = _a.data, errors = _a.errors;
                        if (errors) {
                            throw new Error(errors.map(function (_a) {
                                var message = _a.message;
                                return message;
                            }).join('\n'));
                        }
                        return [2 /*return*/, {
                                location: 'apollo-engine',
                                schema: graphql.buildClientSchema(data.service.schema),
                            }];
                }
            });
        });
    };
    ApolloEngineLoader.prototype.loadSync = function () {
        throw new Error('Loader ApolloEngine has no sync mode');
    };
    return ApolloEngineLoader;
}());
/**
 * @internal
 */
var SCHEMA_QUERY = /* GraphQL */ "\n  query GetSchemaByTag($tag: String!, $id: ID!) {\n    service(id: $id) {\n      ... on Service {\n        __typename\n        schema(tag: $tag) {\n          hash\n          __schema: introspection {\n            queryType {\n              name\n            }\n            mutationType {\n              name\n            }\n            subscriptionType {\n              name\n            }\n            types(filter: { includeBuiltInTypes: true }) {\n              ...IntrospectionFullType\n            }\n            directives {\n              name\n              description\n              locations\n              args {\n                ...IntrospectionInputValue\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n  fragment IntrospectionFullType on IntrospectionType {\n    kind\n    name\n    description\n    fields {\n      name\n      description\n      args {\n        ...IntrospectionInputValue\n      }\n      type {\n        ...IntrospectionTypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...IntrospectionInputValue\n    }\n    interfaces {\n      ...IntrospectionTypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...IntrospectionTypeRef\n    }\n  }\n\n  fragment IntrospectionInputValue on IntrospectionInputValue {\n    name\n    description\n    type {\n      ...IntrospectionTypeRef\n    }\n    defaultValue\n  }\n\n  fragment IntrospectionTypeRef on IntrospectionType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n";

exports.ApolloEngineLoader = ApolloEngineLoader;
exports.SCHEMA_QUERY = SCHEMA_QUERY;
//# sourceMappingURL=index.cjs.js.map
