export declare class InvariantError extends Error {
    framesToPop: number;
    name: string;
    constructor(message?: string | number);
}
export declare function invariant(condition: any, message?: string | number): asserts condition;
declare const verbosityLevels: readonly ["log", "warn", "error", "silent"];
declare type VerbosityLevel = (typeof verbosityLevels)[number];
export declare namespace invariant {
    const log: {
        (...data: any[]): void;
        (message?: any, ...optionalParams: any[]): void;
    };
    const warn: {
        (...data: any[]): void;
        (message?: any, ...optionalParams: any[]): void;
    };
    const error: {
        (...data: any[]): void;
        (message?: any, ...optionalParams: any[]): void;
    };
}
export declare function setVerbosity(level: VerbosityLevel): VerbosityLevel;
export default invariant;
