import { isUsingTypes } from '@graphql-codegen/plugin-helpers';
import addPlugin from '@graphql-codegen/add';

const preset = {
    buildGeneratesSection: options => {
        if (!options.presetConfig.typesPath) {
            throw new Error(`Preset "import-types" requires you to specify "typesPath" configuration and point it to your base types file (generated by "typescript" plugin)!`);
        }
        const importTypesNamespace = options.presetConfig.importTypesNamespace || 'Types';
        const pluginMap = {
            ...options.pluginMap,
            add: addPlugin,
        };
        const plugins = [...options.plugins];
        const config = {
            ...options.config,
            // This is for the operations plugin
            namespacedImportName: importTypesNamespace,
            // This is for the client-side runtime plugins
            importOperationTypesFrom: importTypesNamespace,
            externalFragments: [],
        };
        options.documents.map(documentFile => {
            if (isUsingTypes(documentFile.document, config.externalFragments.map(m => m.name), options.schemaAst)) {
                const importType = options.config.useTypeImports ? 'import type' : 'import';
                plugins.unshift({
                    add: {
                        content: `${importType} * as ${importTypesNamespace} from '${options.presetConfig.typesPath}';\n`,
                    },
                });
            }
        });
        return [
            {
                filename: options.baseOutputDir,
                plugins,
                pluginMap,
                config,
                schema: options.schema,
                schemaAst: options.schemaAst,
                documents: options.documents,
            },
        ];
    },
};

export default preset;
export { preset };
//# sourceMappingURL=index.esm.js.map
