import { PluginFunction, PluginValidateFn } from '@graphql-codegen/plugin-helpers';
import { NamingConvention, RawClientSideBasePluginConfig } from '@graphql-codegen/visitor-plugin-common';
/**
 * @description This plugin generates TypeScript source (`.ts`) file from GraphQL files (`.graphql`).
 */
export interface TypeScriptDocumentNodesRawPluginConfig extends RawClientSideBasePluginConfig {
    /**
     * @default change-case-all#pascalCase
     * @description Allow you to override the naming convention of the output.
     * You can either override all namings, or specify an object with specific custom naming convention per output.
     * The format of the converter must be a valid `module#method`.
     * Allowed values for specific output are: `typeNames`, `enumValues`.
     * You can also use "keep" to keep all GraphQL names as-is.
     * Additionally you can set `transformUnderscore` to `true` if you want to override the default behavior,
     * which is to preserves underscores.
     *
     * Available case functions in `change-case-all` are `camelCase`, `capitalCase`, `constantCase`, `dotCase`, `headerCase`, `noCase`, `paramCase`, `pascalCase`, `pathCase`, `sentenceCase`, `snakeCase`, `lowerCase`, `localeLowerCase`, `lowerCaseFirst`, `spongeCase`, `titleCase`, `upperCase`, `localeUpperCase` and `upperCaseFirst`
     * [See more](https://github.com/btxtiger/change-case-all)
     *
     * @exampleMarkdown
     * ## Override All Names
     * ```yml
     * config:
     *   namingConvention: change-case-all#lowerCase
     * ```
     *
     * ## Upper-case enum values
     * ```yml
     * config:
     *   namingConvention:
     *     typeNames: change-case-all#pascalCase
     *     enumValues: change-case-all#upperCase
     * ```
     *
     * ## Keep name as-is
     * ```yml
     * config:
     *   namingConvention: keep
     * ```
     *
     * ## Remove Underscores
     * ```yml
     * config:
     *   namingConvention:
     *     typeNames: change-case-all#pascalCase
     *     transformUnderscore: true
     * ```
     */
    namingConvention?: NamingConvention;
    /**
     * @default ""
     * @description Adds prefix to the name
     *
     * @exampleMarkdown
     * ```yml
     *  documents: src/api/user-service/queries.graphql
     *  generates:
     *    src/api/user-service/queries.ts:
     *    plugins:
     *      - typescript-document-nodes
     *    config:
     *      namePrefix: 'gql'
     * ```
     */
    namePrefix?: string;
    /**
     * @default ""
     * @description Adds suffix to the name
     *
     * @exampleMarkdown
     * ```yml
     *  documents: src/api/user-service/queries.graphql
     *  generates:
     *    src/api/user-service/queries.ts:
     *    plugins:
     *      - typescript-document-nodes
     *    config:
     *      nameSuffix: 'Query'
     * ```
     */
    nameSuffix?: string;
    /**
     * @default ""
     * @description Adds prefix to the fragment variable
     */
    fragmentPrefix?: string;
    /**
     * @default ""
     * @description Adds suffix to the fragment variable
     */
    fragmentSuffix?: string;
}
export declare const plugin: PluginFunction<TypeScriptDocumentNodesRawPluginConfig>;
export declare const validate: PluginValidateFn<any>;
