'use strict';

var _formatMessage = require('../formatMessage');

var _formatMessage2 = _interopRequireDefault(_formatMessage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('formatMessage', function () {
  it('returns a list of strings suitable for console logging', function () {
    expect((0, _formatMessage2.default)('query', { operationName: 'FormatMessageQuery' }, 1000)).toMatchSnapshot();

    expect((0, _formatMessage2.default)('mutation', { operationName: 'FormatMessageMutation' }, 500)).toMatchSnapshot();
  });

  it('does not include performance information for subscriptions', function () {
    expect((0, _formatMessage2.default)('subscription', { operationName: 'MessagesSubscription' }, 500)).toMatchSnapshot();
  });
});