import { __awaiter, __generator } from 'tslib';
import { isValidPath, parseGraphQLJSON } from '@graphql-tools/utils/es5';
import { isAbsolute, resolve } from 'path';
import { promises, accessSync, readFileSync } from 'fs';
import { cwd } from 'process';

var readFile = promises.readFile, access = promises.access;
var FILE_EXTENSIONS = ['.json'];
/**
 * This loader loads documents and type definitions from JSON files.
 *
 * The JSON file can be the result of an introspection query made against a schema:
 *
 * ```js
 * const schema = await loadSchema('schema-introspection.json', {
 *   loaders: [
 *     new JsonFileLoader()
 *   ]
 * });
 * ```
 *
 * Or it can be a `DocumentNode` object representing a GraphQL document or type definitions:
 *
 * ```js
 * const documents = await loadDocuments('queries/*.json', {
 *   loaders: [
 *     new GraphQLFileLoader()
 *   ]
 * });
 * ```
 */
var JsonFileLoader = /** @class */ (function () {
    function JsonFileLoader() {
    }
    JsonFileLoader.prototype.loaderId = function () {
        return 'json-file';
    };
    JsonFileLoader.prototype.canLoad = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            var normalizedFilePath, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!isValidPath(pointer)) return [3 /*break*/, 4];
                        if (!FILE_EXTENSIONS.find(function (extension) { return pointer.endsWith(extension); })) return [3 /*break*/, 4];
                        normalizedFilePath = isAbsolute(pointer) ? pointer : resolve(options.cwd || cwd(), pointer);
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, access(normalizedFilePath)];
                    case 2:
                        _b.sent();
                        return [2 /*return*/, true];
                    case 3:
                        _a = _b.sent();
                        return [2 /*return*/, false];
                    case 4: return [2 /*return*/, false];
                }
            });
        });
    };
    JsonFileLoader.prototype.canLoadSync = function (pointer, options) {
        if (isValidPath(pointer)) {
            if (FILE_EXTENSIONS.find(function (extension) { return pointer.endsWith(extension); })) {
                var normalizedFilePath = isAbsolute(pointer) ? pointer : resolve(options.cwd || cwd(), pointer);
                try {
                    accessSync(normalizedFilePath);
                    return true;
                }
                catch (_a) {
                    return false;
                }
            }
        }
        return false;
    };
    JsonFileLoader.prototype.load = function (pointer, options) {
        return __awaiter(this, void 0, void 0, function () {
            var normalizedFilePath, jsonContent, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        normalizedFilePath = isAbsolute(pointer) ? pointer : resolve(options.cwd || cwd(), pointer);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, readFile(normalizedFilePath, { encoding: 'utf8' })];
                    case 2:
                        jsonContent = _a.sent();
                        return [2 /*return*/, parseGraphQLJSON(pointer, jsonContent, options)];
                    case 3:
                        e_1 = _a.sent();
                        throw new Error("Unable to read JSON file: " + normalizedFilePath + ": " + (e_1.message || /* istanbul ignore next */ e_1));
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    JsonFileLoader.prototype.loadSync = function (pointer, options) {
        var normalizedFilepath = isAbsolute(pointer) ? pointer : resolve(options.cwd || cwd(), pointer);
        try {
            var jsonContent = readFileSync(normalizedFilepath, 'utf8');
            return parseGraphQLJSON(pointer, jsonContent, options);
        }
        catch (e) {
            throw new Error("Unable to read JSON file: " + normalizedFilepath + ": " + (e.message || /* istanbul ignore next */ e));
        }
    };
    return JsonFileLoader;
}());

export { JsonFileLoader };
//# sourceMappingURL=index.esm.js.map
