---
external help file: PnP.PowerShell.dll-Help.xml
Module Name: PnP.PowerShell
online version: https://pnp.github.io/powershell/cmdlets/Get-PnPAzureADActivityReportDirectoryAudit.html
schema: 2.0.0
applicable: SharePoint Online
title: Get-PnPAzureADActivityReportDirectoryAudit
---

# Get-PnPAzureADActivityReportDirectoryAudit

## SYNOPSIS

**Required Permissions**

* Microsoft Graph API: AuditLog.Read.All and Directory.Read.All

Returns the audit logs generated by Azure AD.

## SYNTAX

```powershell
Get-PnPAzureADActivityReportDirectoryAudit [-Identity <string>] [-Filter <string>] [-Connection <PnPConnection>]
```

## DESCRIPTION

This cmdlet gets the list of audit logs generated by AzureAD. This includes audit logs generated by different services in Azure AD such as user, app, device and group Management, privileged identity management (PIM), access reviews, terms of use, identity protection, password management (self-service and admin password resets) and others.

## EXAMPLES

### Example 1

```powershell
Get-PnPAzureADActivityReportDirectoryAudit
```

Returns all audit logs generated by Azure AD.

### Example 2

```powershell
Get-PnPAzureADActivityReportDirectoryAudit -Identity "Directory_c3b82411-5445-4620-aace-6a684a252673_02R72_362975819"
```

Returns the audit log with specific ID.

### Example 3

```powershell
Get-PnPAzureADActivityReportDirectoryAudit -Filter "activityDateTime le 2018-01-24"
```

Returns the audit logs based on filter condition.

## PARAMETERS

### -Identity

Specify the ID of the audit log.

```yaml
Type: string
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Filter

Specify the Filter condition for the audit log report.

```yaml
Type: string
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Connection

Optional connection to be used by the cmdlet. Retrieve the value for this parameter by either specifying -ReturnConnection on Connect-PnPOnline or by executing Get-PnPConnection.

```yaml
Type: PnPConnection
Parameter Sets: (All)

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

## RELATED LINKS

[Microsoft 365 Patterns and Practices](https://aka.ms/m365pnp)
