---
external help file: PnP.PowerShell.dll-Help.xml
Module Name: PnP.PowerShell
online version: https://pnp.github.io/powershell/cmdlets/Get-PnPAzureADActivityReportSignIn.html
schema: 2.0.0
applicable: SharePoint Online
title: Get-PnPAzureADActivityReportSignIn
---

# Get-PnPAzureADActivityReportSignIn

## SYNOPSIS

**Required Permissions**

* Microsoft Graph API: AuditLog.Read.All and Directory.Read.All

Returns the sign in logs generated by Azure AD.

## SYNTAX

```powershell
Get-PnPAzureADActivityReportSignIn [-Identity <string>] [-Filter <string>] [-Connection <PnPConnection>]
```

## DESCRIPTION

This cmdlet gets the list of sign in logs generated by Azure AD. 

## EXAMPLES

### EXAMPLE 1

```powershell
Get-PnPAzureADActivityReportSignIn
```

Returns all sign logs generated by Azure AD.

### EXAMPLE 2

```powershell
Get-PnPAzureADActivityReportSignIn -Identity "da364266-533d-3186-a8b2-44ee1c21af11"
```

Returns the sign in log with specific ID.

### EXAMPLE 3

```powershell
Get-PnPAzureADActivityReportSignIn -Filter "startsWith(appDisplayName,'Graph')"
```

Returns the sign in logs based on filter condition.

## PARAMETERS

### -Identity

Specify the ID of the sign in log.

```yaml
Type: string
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Filter

Specify the Filter condition for the sign in log report.

```yaml
Type: string
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Connection

Optional connection to be used by the cmdlet. Retrieve the value for this parameter by either specifying -ReturnConnection on Connect-PnPOnline or by executing Get-PnPConnection.

```yaml
Type: PnPConnection
Parameter Sets: (All)

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

## RELATED LINKS

[Microsoft 365 Patterns and Practices](https://aka.ms/m365pnp)
