---
Module Name: PnP.PowerShell
title: Set-PnPSitePolicy
schema: 2.0.0
applicable: SharePoint Online
external help file: PnP.PowerShell.dll-Help.xml
online version: https://pnp.github.io/powershell/cmdlets/Set-PnPSitePolicy.html
---
 
# Set-PnPSitePolicy

## SYNOPSIS
Sets a site policy

## SYNTAX

```powershell
Set-PnPSitePolicy -Name <String> [-Connection <PnPConnection>] 
```

## DESCRIPTION

Allows to modify a site policy.

## EXAMPLES

### EXAMPLE 1
```powershell
Set-PnPSitePolicy -Name "Contoso HBI"
```

This applies a site policy with the name "Contoso HBI" to the current site. The policy needs to be available in the site.

## PARAMETERS

### -Connection
Optional connection to be used by the cmdlet. Retrieve the value for this parameter by either specifying -ReturnConnection on Connect-PnPOnline or by executing Get-PnPConnection.

```yaml
Type: PnPConnection
Parameter Sets: (All)

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Name
The name of the site policy to apply

```yaml
Type: String
Parameter Sets: (All)

Required: True
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```



## RELATED LINKS

[Microsoft 365 Patterns and Practices](https://aka.ms/m365pnp)

