---
title: Contour 1.0.0-rc.2 has been released
excerpt: Contour 1.0 is just around the corner.
author_name: Dave Cheney
author_avatar: /img/contributors/dave-cheney.png
categories: [kubernetes]
# Tag should match author to drive author pages
tags: ['Contour Team', 'release', 'Dave Cheney']
date: 2019-10-25
slug: contour-v100rc2
---

Contour 1.0.0-rc.2 is the second, and hopefully final, release candidate on the path to Contour 1.0.
Assuming that no serious issues are found next week we're on track to release Contour 1.0 on November 1st.

It goes without saying that without the help of the many community contributors this release, nor the 38 that preceded it, would not have been possible.
Thank you all.

You can read the full [1.0.0-rc.2 release notes][1] over on GitHub, but as you're here, here are a few highlights.

## Website improvements

As part of the continued preparations for the 1.0 release Contour's documentation has been relocated to the projectcontour.io website. Specifically;

* The Getting Started documentation has moved to [projectcontour.io/getting-started][2]
* Guides and How-to's have moved to [projectcontour.io/guides][3]
* Versioned release documentation has moved to [projectcontour.io/docs][4]
* Project related and non-versioned documentation has moved to [projectcontour.io/resources][5]

We're working hard to polish the website content ahead of the 1.0 release. Please pardon our dust.

## IngressRoute and HTTPProxy status update improvements

IngressRoute and HTTPProxy status updates are now performed by the lead Contour in the deployment.
We're hopeful that this will put to rest the many issues related to status update loops over the years.

## HTTPProxy and IngressRoute OpenAPIv3 schema validation

Contour 1.0.0-rc.2 includes updated OpenAPIv3 schema validations.
These schemas are automatically generated from the CRDs themselves and should be more complete and consistent than the previous hand rolled versions.

## TCPProxy delegation

Contour 1.0.0-rc.2 now supports TCPProxy delegation. See the [relevant section][6] in the HTTPProxy documentation.

## Envoy keepalive tuning

Contour 1.0.0-rc.2 configures various keep alive mechanisms to detect network connectivity issues between Envoy and Contour. 
This helps Contour and Envoy work better with overlay networks which drop long running idle TCP connections. 

## Contour now waits for a full cache before talking to Envoy.

Contour now delays serving traffic to Envoy until each of the API informers caught up to the API server.
This changes reduces the likelihood that Envoy can connect to a Contour instance in the process of startup and thus observe an incomplete view of the cluster.

## Upgrading

Please consult the [Upgrading][7] document for information on upgrading from Contour 1.0.0-rc.1 to Contour 1.0.0-rc.2.

[1]: {{site.github.repository_url}}/releases/tag/v1.0.0-rc.2
[2]: /getting-started
[3]: /guides
[4]: /docs
[5]: /resources
[6]: {% link docs/v1.0.0/httpproxy.md %}
[7]: {% link _resources/upgrading.md %}