---
title: Announcing Contour v1.9.0
image: /img/posts/contourauth.png
excerpt: This blog post covers External Authorization and Cross-Origin Resource Sharing (CORS) Support in Contour v1.9.0.
author_name: Steve Sloka
author_avatar: /img/contributors/steve-sloka.png
categories: [kubernetes]
# Tag should match author to drive author pages
tags: ['Contour Team']
date: 2020-10-07
slug: contour_v190
---

Contour continues to add new features to help you better manage ingress operations in a cluster. Our latest feature release, Contour 1.9.0, now includes support for external authorization allowing requests to be validated against an authorization server.  Contour now also supports presenting a client certificate for TLS for validation to backend services as well as moves to v1 Custom Resource Definitions (CRDs).

## External Authorization Support
Incoming requests to your ingress resources can now be authorized by utilizing Contour’s new external authorization support. Contour now enables the external authorization network filter in Envoy which calls an external authorization service to check if the incoming request is authorized or not. If the request is deemed unauthorized by the network filter then the connection will be closed.

Support for this new feature relies on a new Custom Resource Definition (CRD) named ExtensionService. This new API describes how Envoy should connect to the external authorization server.

![img][1]

### Sequence of Events for External Auth:
1. Deploy an External Authorization Service to your cluster: This service talks to your Authorization Provider and determines if the request should be authorized or not.
2. Create an `ExtensionService` CRD: This CRD allows the External Authorization Service created in the previous step to be available so that Contour can configure Envoy with that gRPC endpoint.
3. Create HTTPProxy resource: The VirtualHost in the ingress object references the ExternalService CRD linking that virtual host to the authorization service. 
4. On every client request, Envoy sends an authorization check  to the External Auth Service to determine authorization.

## Demo
Here's a quick video demonstration walking through the setup and configuration of External Authorization with Contour.

{% youtube wm_eWO4mZYs %}

If you'd like to follow along with the demo in your own environment, here are the files used:
```
https://projectcontour.io/examples/authdemo/01-prereq.yaml
https://projectcontour.io/examples/authdemo/02-auth-deployment.yaml
https://projectcontour.io/examples/authdemo/02-certsjob.yaml
https://projectcontour.io/examples/authdemo/03-secret.yaml
https://projectcontour.io/examples/authdemo/04-extensionservice.yaml
https://projectcontour.io/examples/authdemo/04-samplapp.yaml
https://projectcontour.io/examples/authdemo/05-proxy.yaml
https://projectcontour.io/examples/authdemo/06-proxy-auth.yaml
``` 

## Cross-Origin Resource Sharing (CORS) Support
Contour’s HTTPProxy API now supports specifying a [CORS policy](https://projectcontour.io/docs/v1.9.0/httpproxy/#cors-policy), which configures Envoy’s [CORS filter](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/cors_filter) to allow web applications to request resources from different origins.

CORS uses additional HTTP headers to tell browsers to give a web application running at one origin access to selected resources from a different origin (domain, protocol, or port) from its own.

In this example, cross-domain requests will be allowed for any domain (note the * value):

```yaml
apiVersion: projectcontour.io/v1
kind: HTTPProxy
spec:
  virtualhost:
    fqdn: local.projectcontour.io
    corsPolicy:
        allowCredentials: true
        allowOrigin: 
          - "*" # allows any origin
        allowMethods:
          - GET
          - POST
          - OPTIONS
        allowHeaders: 
          - authorization
          - cache-control
        exposeHeaders: 
          - Content-Length
          - Content-Range
        maxAge: "10m" # preflight requests can be cached for 10 minutes. 
  routes:
    - conditions:
      - prefix: /
      services:
        - name: s1
          port: 80
```

Thanks to @aberasarte and @glerchundi for driving the design and implementation of this new feature!  

## Backend TLS Client Authentication
Contour now supports optionally specifying a Kubernetes secret that Envoy should present to upstream clusters as a client certificate for TLS, so the upstream services can validate that the connection is coming from Envoy.
 
Thanks to @tsaarni for leading design and implementation of this feature!

## v1 Custom Resource Definitions
Contour now generates v1 custom resource definitions (CRDs) as part of its example YAML.
This enables Contour to take full advantage of the v1 API’s capabilities around validation, defaulting, API documentation via `kubectl explain`, and more.
CRDs became [generally available in Kubernetes 1.16](https://kubernetes.io/blog/2019/09/18/kubernetes-1-16-release-announcement/#custom-resources-reach-general-availability) over a year ago.

This change bumps Contour’s minimum supported Kubernetes version to 1.16.

## Community Thanks!
We’re immensely grateful for all the community contributions that help make Contour even better! For version 1.9, special thanks go out to the following contributors:
- [@aberasarte](https://github.com/aberasarte)
- [@bgagnon](https://github.com/bgagnon)
- [@glerchundi](https://github.com/glerchundi)
- [@mattmoor](https://github.com/mattmoor)
- [@ShaileshSurya](https://github.com/ShaileshSurya)
- [@tong101](https://github.com/tong101)
- [@tsaarni](https://github.com/tsaarni)
- [@zianke](https://github.com/zianke)

[1]: {% link img/posts/contourauth.png %}
