//=============================================================================
//  MuseScore
//  Music Composition & Notation
//
//  Copyright (C) 2002-2011 Werner Schweer
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2
//  as published by the Free Software Foundation and appearing in
//  the file LICENCE.GPL
//=============================================================================

#include "style.h"
#include "sym.h"
#include "utils.h"
#include "score.h"
#include "xml.h"
#include "mscore.h"

#include FT_GLYPH_H
#include FT_IMAGE_H
#include FT_BBOX_H

static FT_Library ftlib;

namespace Ms {


//---------------------------------------------------------
//   scoreFonts
//    this is the list of available score fonts
//---------------------------------------------------------

static const int FALLBACK_FONT = 1;       // Bravura

QVector<ScoreFont> ScoreFont::_scoreFonts {
      ScoreFont("Leland",     "Leland",      ":/fonts/leland/",    "Leland.otf"   ),
      ScoreFont("Bravura",    "Bravura",     ":/fonts/bravura/",   "Bravura.otf"  ),
      ScoreFont("Emmentaler", "MScore",      ":/fonts/mscore/",    "mscore.ttf"   ),
      ScoreFont("Gonville",   "Gootville",   ":/fonts/gootville/", "Gootville.otf"),
      ScoreFont("MuseJazz",   "MuseJazz",    ":/fonts/musejazz/",  "MuseJazz.otf" ),
      ScoreFont("Petaluma",   "Petaluma",    ":/fonts/petaluma/",  "Petaluma.otf" ),
      };

std::array<uint, size_t(SymId::lastSym)+1> ScoreFont::_mainSymCodeTable { {0} };

//---------------------------------------------------------
//   table of symbol names
//    symNames must be in sync with enum class SymId
//---------------------------------------------------------

QHash<QString, SymId> Sym::lnhash;
const std::array<const char*, int(SymId::lastSym)+1> Sym::symNames = { {
      "noSym",

      // DO NOT edit the SMuFL standard symbol names (see below) manually!
      // They are generated from fonttools/smufl2sym.{bat,sh} and then
      // copied into this file!

      // SMuFL standard symbol names {{{
      "4stringTabClef",
      "6stringTabClef",
      "accSagittal11LargeDiesisDown",
      "accSagittal11LargeDiesisUp",
      "accSagittal11MediumDiesisDown",
      "accSagittal11MediumDiesisUp",
      "accSagittal11v19LargeDiesisDown",
      "accSagittal11v19LargeDiesisUp",
      "accSagittal11v19MediumDiesisDown",
      "accSagittal11v19MediumDiesisUp",
      "accSagittal11v49CommaDown",
      "accSagittal11v49CommaUp",
      "accSagittal143CommaDown",
      "accSagittal143CommaUp",
      "accSagittal17CommaDown",
      "accSagittal17CommaUp",
      "accSagittal17KleismaDown",
      "accSagittal17KleismaUp",
      "accSagittal19CommaDown",
      "accSagittal19CommaUp",
      "accSagittal19SchismaDown",
      "accSagittal19SchismaUp",
      "accSagittal23CommaDown",
      "accSagittal23CommaUp",
      "accSagittal23SmallDiesisDown",
      "accSagittal23SmallDiesisUp",
      "accSagittal25SmallDiesisDown",
      "accSagittal25SmallDiesisUp",
      "accSagittal35LargeDiesisDown",
      "accSagittal35LargeDiesisUp",
      "accSagittal35MediumDiesisDown",
      "accSagittal35MediumDiesisUp",
      "accSagittal49LargeDiesisDown",
      "accSagittal49LargeDiesisUp",
      "accSagittal49MediumDiesisDown",
      "accSagittal49MediumDiesisUp",
      "accSagittal49SmallDiesisDown",
      "accSagittal49SmallDiesisUp",
      "accSagittal55CommaDown",
      "accSagittal55CommaUp",
      "accSagittal5CommaDown",
      "accSagittal5CommaUp",
      "accSagittal5v11SmallDiesisDown",
      "accSagittal5v11SmallDiesisUp",
      "accSagittal5v13LargeDiesisDown",
      "accSagittal5v13LargeDiesisUp",
      "accSagittal5v13MediumDiesisDown",
      "accSagittal5v13MediumDiesisUp",
      "accSagittal5v19CommaDown",
      "accSagittal5v19CommaUp",
      "accSagittal5v23SmallDiesisDown",
      "accSagittal5v23SmallDiesisUp",
      "accSagittal5v49MediumDiesisDown",
      "accSagittal5v49MediumDiesisUp",
      "accSagittal5v7KleismaDown",
      "accSagittal5v7KleismaUp",
      "accSagittal7CommaDown",
      "accSagittal7CommaUp",
      "accSagittal7v11CommaDown",
      "accSagittal7v11CommaUp",
      "accSagittal7v11KleismaDown",
      "accSagittal7v11KleismaUp",
      "accSagittal7v19CommaDown",
      "accSagittal7v19CommaUp",
      "accSagittalAcute",
      "accSagittalDoubleFlat",
      "accSagittalDoubleFlat11v49CUp",
      "accSagittalDoubleFlat143CUp",
      "accSagittalDoubleFlat17CUp",
      "accSagittalDoubleFlat17kUp",
      "accSagittalDoubleFlat19CUp",
      "accSagittalDoubleFlat19sUp",
      "accSagittalDoubleFlat23CUp",
      "accSagittalDoubleFlat23SUp",
      "accSagittalDoubleFlat25SUp",
      "accSagittalDoubleFlat49SUp",
      "accSagittalDoubleFlat55CUp",
      "accSagittalDoubleFlat5CUp",
      "accSagittalDoubleFlat5v11SUp",
      "accSagittalDoubleFlat5v19CUp",
      "accSagittalDoubleFlat5v23SUp",
      "accSagittalDoubleFlat5v7kUp",
      "accSagittalDoubleFlat7CUp",
      "accSagittalDoubleFlat7v11CUp",
      "accSagittalDoubleFlat7v11kUp",
      "accSagittalDoubleFlat7v19CUp",
      "accSagittalDoubleSharp",
      "accSagittalDoubleSharp11v49CDown",
      "accSagittalDoubleSharp143CDown",
      "accSagittalDoubleSharp17CDown",
      "accSagittalDoubleSharp17kDown",
      "accSagittalDoubleSharp19CDown",
      "accSagittalDoubleSharp19sDown",
      "accSagittalDoubleSharp23CDown",
      "accSagittalDoubleSharp23SDown",
      "accSagittalDoubleSharp25SDown",
      "accSagittalDoubleSharp49SDown",
      "accSagittalDoubleSharp55CDown",
      "accSagittalDoubleSharp5CDown",
      "accSagittalDoubleSharp5v11SDown",
      "accSagittalDoubleSharp5v19CDown",
      "accSagittalDoubleSharp5v23SDown",
      "accSagittalDoubleSharp5v7kDown",
      "accSagittalDoubleSharp7CDown",
      "accSagittalDoubleSharp7v11CDown",
      "accSagittalDoubleSharp7v11kDown",
      "accSagittalDoubleSharp7v19CDown",
      "accSagittalFlat",
      "accSagittalFlat11LDown",
      "accSagittalFlat11MDown",
      "accSagittalFlat11v19LDown",
      "accSagittalFlat11v19MDown",
      "accSagittalFlat11v49CDown",
      "accSagittalFlat11v49CUp",
      "accSagittalFlat143CDown",
      "accSagittalFlat143CUp",
      "accSagittalFlat17CDown",
      "accSagittalFlat17CUp",
      "accSagittalFlat17kDown",
      "accSagittalFlat17kUp",
      "accSagittalFlat19CDown",
      "accSagittalFlat19CUp",
      "accSagittalFlat19sDown",
      "accSagittalFlat19sUp",
      "accSagittalFlat23CDown",
      "accSagittalFlat23CUp",
      "accSagittalFlat23SDown",
      "accSagittalFlat23SUp",
      "accSagittalFlat25SDown",
      "accSagittalFlat25SUp",
      "accSagittalFlat35LDown",
      "accSagittalFlat35MDown",
      "accSagittalFlat49LDown",
      "accSagittalFlat49MDown",
      "accSagittalFlat49SDown",
      "accSagittalFlat49SUp",
      "accSagittalFlat55CDown",
      "accSagittalFlat55CUp",
      "accSagittalFlat5CDown",
      "accSagittalFlat5CUp",
      "accSagittalFlat5v11SDown",
      "accSagittalFlat5v11SUp",
      "accSagittalFlat5v13LDown",
      "accSagittalFlat5v13MDown",
      "accSagittalFlat5v19CDown",
      "accSagittalFlat5v19CUp",
      "accSagittalFlat5v23SDown",
      "accSagittalFlat5v23SUp",
      "accSagittalFlat5v49MDown",
      "accSagittalFlat5v7kDown",
      "accSagittalFlat5v7kUp",
      "accSagittalFlat7CDown",
      "accSagittalFlat7CUp",
      "accSagittalFlat7v11CDown",
      "accSagittalFlat7v11CUp",
      "accSagittalFlat7v11kDown",
      "accSagittalFlat7v11kUp",
      "accSagittalFlat7v19CDown",
      "accSagittalFlat7v19CUp",
      "accSagittalGrave",
      "accSagittalShaftDown",
      "accSagittalShaftUp",
      "accSagittalSharp",
      "accSagittalSharp11LUp",
      "accSagittalSharp11MUp",
      "accSagittalSharp11v19LUp",
      "accSagittalSharp11v19MUp",
      "accSagittalSharp11v49CDown",
      "accSagittalSharp11v49CUp",
      "accSagittalSharp143CDown",
      "accSagittalSharp143CUp",
      "accSagittalSharp17CDown",
      "accSagittalSharp17CUp",
      "accSagittalSharp17kDown",
      "accSagittalSharp17kUp",
      "accSagittalSharp19CDown",
      "accSagittalSharp19CUp",
      "accSagittalSharp19sDown",
      "accSagittalSharp19sUp",
      "accSagittalSharp23CDown",
      "accSagittalSharp23CUp",
      "accSagittalSharp23SDown",
      "accSagittalSharp23SUp",
      "accSagittalSharp25SDown",
      "accSagittalSharp25SUp",
      "accSagittalSharp35LUp",
      "accSagittalSharp35MUp",
      "accSagittalSharp49LUp",
      "accSagittalSharp49MUp",
      "accSagittalSharp49SDown",
      "accSagittalSharp49SUp",
      "accSagittalSharp55CDown",
      "accSagittalSharp55CUp",
      "accSagittalSharp5CDown",
      "accSagittalSharp5CUp",
      "accSagittalSharp5v11SDown",
      "accSagittalSharp5v11SUp",
      "accSagittalSharp5v13LUp",
      "accSagittalSharp5v13MUp",
      "accSagittalSharp5v19CDown",
      "accSagittalSharp5v19CUp",
      "accSagittalSharp5v23SDown",
      "accSagittalSharp5v23SUp",
      "accSagittalSharp5v49MUp",
      "accSagittalSharp5v7kDown",
      "accSagittalSharp5v7kUp",
      "accSagittalSharp7CDown",
      "accSagittalSharp7CUp",
      "accSagittalSharp7v11CDown",
      "accSagittalSharp7v11CUp",
      "accSagittalSharp7v11kDown",
      "accSagittalSharp7v11kUp",
      "accSagittalSharp7v19CDown",
      "accSagittalSharp7v19CUp",
      "accSagittalUnused1",
      "accSagittalUnused2",
      "accSagittalUnused3",
      "accSagittalUnused4",
      "accdnCombDot",
      "accdnCombLH2RanksEmpty",
      "accdnCombLH3RanksEmptySquare",
      "accdnCombRH3RanksEmpty",
      "accdnCombRH4RanksEmpty",
      "accdnDiatonicClef",
      "accdnLH2Ranks16Round",
      "accdnLH2Ranks8Plus16Round",
      "accdnLH2Ranks8Round",
      "accdnLH2RanksFullMasterRound",
      "accdnLH2RanksMasterPlus16Round",
      "accdnLH2RanksMasterRound",
      "accdnLH3Ranks2Plus8Square",
      "accdnLH3Ranks2Square",
      "accdnLH3Ranks8Square",
      "accdnLH3RanksDouble8Square",
      "accdnLH3RanksTuttiSquare",
      "accdnPull",
      "accdnPush",
      "accdnRH3RanksAccordion",
      "accdnRH3RanksAuthenticMusette",
      "accdnRH3RanksBandoneon",
      "accdnRH3RanksBassoon",
      "accdnRH3RanksClarinet",
      "accdnRH3RanksDoubleTremoloLower8ve",
      "accdnRH3RanksDoubleTremoloUpper8ve",
      "accdnRH3RanksFullFactory",
      "accdnRH3RanksHarmonium",
      "accdnRH3RanksImitationMusette",
      "accdnRH3RanksLowerTremolo8",
      "accdnRH3RanksMaster",
      "accdnRH3RanksOboe",
      "accdnRH3RanksOrgan",
      "accdnRH3RanksPiccolo",
      "accdnRH3RanksTremoloLower8ve",
      "accdnRH3RanksTremoloUpper8ve",
      "accdnRH3RanksTwoChoirs",
      "accdnRH3RanksUpperTremolo8",
      "accdnRH3RanksViolin",
      "accdnRH4RanksAlto",
      "accdnRH4RanksBassAlto",
      "accdnRH4RanksMaster",
      "accdnRH4RanksSoftBass",
      "accdnRH4RanksSoftTenor",
      "accdnRH4RanksSoprano",
      "accdnRH4RanksTenor",
      "accdnRicochet2",
      "accdnRicochet3",
      "accdnRicochet4",
      "accdnRicochet5",
      "accdnRicochet6",
      "accdnRicochetStem2",
      "accdnRicochetStem3",
      "accdnRicochetStem4",
      "accdnRicochetStem5",
      "accdnRicochetStem6",
      "accidental1CommaFlat",
      "accidental1CommaSharp",
      "accidental2CommaFlat",
      "accidental2CommaSharp",
      "accidental3CommaFlat",
      "accidental3CommaSharp",
      "accidental4CommaFlat",
      "accidental5CommaSharp",
      "accidentalArrowDown",
      "accidentalArrowUp",
      "accidentalBakiyeFlat",
      "accidentalBakiyeSharp",
      "accidentalBracketLeft",
      "accidentalBracketRight",
      "accidentalBuyukMucennebFlat",
      "accidentalBuyukMucennebSharp",
      "accidentalCombiningCloseCurlyBrace",
      "accidentalCombiningLower17Schisma",
      "accidentalCombiningLower19Schisma",
      "accidentalCombiningLower23Limit29LimitComma",
      "accidentalCombiningLower31Schisma",
      "accidentalCombiningLower53LimitComma",
      "accidentalCombiningOpenCurlyBrace",
      "accidentalCombiningRaise17Schisma",
      "accidentalCombiningRaise19Schisma",
      "accidentalCombiningRaise23Limit29LimitComma",
      "accidentalCombiningRaise31Schisma",
      "accidentalCombiningRaise53LimitComma",
      "accidentalCommaSlashDown",
      "accidentalCommaSlashUp",
      "accidentalDoubleFlat",
      "accidentalDoubleFlatArabic",
      "accidentalDoubleFlatEqualTempered",
      "accidentalDoubleFlatOneArrowDown",
      "accidentalDoubleFlatOneArrowUp",
      "accidentalDoubleFlatReversed",
      "accidentalDoubleFlatThreeArrowsDown",
      "accidentalDoubleFlatThreeArrowsUp",
      "accidentalDoubleFlatTurned",
      "accidentalDoubleFlatTwoArrowsDown",
      "accidentalDoubleFlatTwoArrowsUp",
      "accidentalDoubleSharp",
      "accidentalDoubleSharpArabic",
      "accidentalDoubleSharpEqualTempered",
      "accidentalDoubleSharpOneArrowDown",
      "accidentalDoubleSharpOneArrowUp",
      "accidentalDoubleSharpThreeArrowsDown",
      "accidentalDoubleSharpThreeArrowsUp",
      "accidentalDoubleSharpTwoArrowsDown",
      "accidentalDoubleSharpTwoArrowsUp",
      "accidentalEnharmonicAlmostEqualTo",
      "accidentalEnharmonicEquals",
      "accidentalEnharmonicTilde",
      "accidentalFilledReversedFlatAndFlat",
      "accidentalFilledReversedFlatAndFlatArrowDown",
      "accidentalFilledReversedFlatAndFlatArrowUp",
      "accidentalFilledReversedFlatArrowDown",
      "accidentalFilledReversedFlatArrowUp",
      "accidentalFiveQuarterTonesFlatArrowDown",
      "accidentalFiveQuarterTonesSharpArrowUp",
      "accidentalFlat",
      "accidentalFlatArabic",
      "accidentalFlatEqualTempered",
      "accidentalFlatLoweredStockhausen",
      "accidentalFlatOneArrowDown",
      "accidentalFlatOneArrowUp",
      "accidentalFlatRaisedStockhausen",
      "accidentalFlatRepeatedLineStockhausen",
      "accidentalFlatRepeatedSpaceStockhausen",
      "accidentalFlatThreeArrowsDown",
      "accidentalFlatThreeArrowsUp",
      "accidentalFlatTurned",
      "accidentalFlatTwoArrowsDown",
      "accidentalFlatTwoArrowsUp",
      "accidentalHalfSharpArrowDown",
      "accidentalHalfSharpArrowUp",
      "accidentalJohnston13",
      "accidentalJohnston31",
      "accidentalJohnstonDown",
      "accidentalJohnstonEl",
      "accidentalJohnstonMinus",
      "accidentalJohnstonPlus",
      "accidentalJohnstonSeven",
      "accidentalJohnstonUp",
      "accidentalKomaFlat",
      "accidentalKomaSharp",
      "accidentalKoron",
      "accidentalKucukMucennebFlat",
      "accidentalKucukMucennebSharp",
      "accidentalLargeDoubleSharp",
      "accidentalLowerOneSeptimalComma",
      "accidentalLowerOneTridecimalQuartertone",
      "accidentalLowerOneUndecimalQuartertone",
      "accidentalLowerTwoSeptimalCommas",
      "accidentalLoweredStockhausen",
      "accidentalNarrowReversedFlat",
      "accidentalNarrowReversedFlatAndFlat",
      "accidentalNatural",
      "accidentalNaturalArabic",
      "accidentalNaturalEqualTempered",
      "accidentalNaturalFlat",
      "accidentalNaturalLoweredStockhausen",
      "accidentalNaturalOneArrowDown",
      "accidentalNaturalOneArrowUp",
      "accidentalNaturalRaisedStockhausen",
      "accidentalNaturalReversed",
      "accidentalNaturalSharp",
      "accidentalNaturalThreeArrowsDown",
      "accidentalNaturalThreeArrowsUp",
      "accidentalNaturalTwoArrowsDown",
      "accidentalNaturalTwoArrowsUp",
      "accidentalOneAndAHalfSharpsArrowDown",
      "accidentalOneAndAHalfSharpsArrowUp",
      "accidentalOneQuarterToneFlatFerneyhough",
      "accidentalOneQuarterToneFlatStockhausen",
      "accidentalOneQuarterToneSharpFerneyhough",
      "accidentalOneQuarterToneSharpStockhausen",
      "accidentalOneThirdToneFlatFerneyhough",
      "accidentalOneThirdToneSharpFerneyhough",
      "accidentalParensLeft",
      "accidentalParensRight",
      "accidentalQuarterFlatEqualTempered",
      "accidentalQuarterSharpEqualTempered",
      "accidentalQuarterToneFlat4",
      "accidentalQuarterToneFlatArabic",
      "accidentalQuarterToneFlatArrowUp",
      "accidentalQuarterToneFlatFilledReversed",
      "accidentalQuarterToneFlatNaturalArrowDown",
      "accidentalQuarterToneFlatPenderecki",
      "accidentalQuarterToneFlatStein",
      "accidentalQuarterToneFlatVanBlankenburg",
      "accidentalQuarterToneSharp4",
      "accidentalQuarterToneSharpArabic",
      "accidentalQuarterToneSharpArrowDown",
      "accidentalQuarterToneSharpBusotti",
      "accidentalQuarterToneSharpNaturalArrowUp",
      "accidentalQuarterToneSharpStein",
      "accidentalQuarterToneSharpWiggle",
      "accidentalRaiseOneSeptimalComma",
      "accidentalRaiseOneTridecimalQuartertone",
      "accidentalRaiseOneUndecimalQuartertone",
      "accidentalRaiseTwoSeptimalCommas",
      "accidentalRaisedStockhausen",
      "accidentalReversedFlatAndFlatArrowDown",
      "accidentalReversedFlatAndFlatArrowUp",
      "accidentalReversedFlatArrowDown",
      "accidentalReversedFlatArrowUp",
      "accidentalSharp",
      "accidentalSharpArabic",
      "accidentalSharpEqualTempered",
      "accidentalSharpLoweredStockhausen",
      "accidentalSharpOneArrowDown",
      "accidentalSharpOneArrowUp",
      "accidentalSharpOneHorizontalStroke",
      "accidentalSharpRaisedStockhausen",
      "accidentalSharpRepeatedLineStockhausen",
      "accidentalSharpRepeatedSpaceStockhausen",
      "accidentalSharpReversed",
      "accidentalSharpSharp",
      "accidentalSharpThreeArrowsDown",
      "accidentalSharpThreeArrowsUp",
      "accidentalSharpTwoArrowsDown",
      "accidentalSharpTwoArrowsUp",
      "accidentalSims12Down",
      "accidentalSims12Up",
      "accidentalSims4Down",
      "accidentalSims4Up",
      "accidentalSims6Down",
      "accidentalSims6Up",
      "accidentalSori",
      "accidentalTavenerFlat",
      "accidentalTavenerSharp",
      "accidentalThreeQuarterTonesFlatArabic",
      "accidentalThreeQuarterTonesFlatArrowDown",
      "accidentalThreeQuarterTonesFlatArrowUp",
      "accidentalThreeQuarterTonesFlatCouper",
      "accidentalThreeQuarterTonesFlatGrisey",
      "accidentalThreeQuarterTonesFlatTartini",
      "accidentalThreeQuarterTonesFlatZimmermann",
      "accidentalThreeQuarterTonesSharpArabic",
      "accidentalThreeQuarterTonesSharpArrowDown",
      "accidentalThreeQuarterTonesSharpArrowUp",
      "accidentalThreeQuarterTonesSharpBusotti",
      "accidentalThreeQuarterTonesSharpStein",
      "accidentalThreeQuarterTonesSharpStockhausen",
      "accidentalTripleFlat",
      "accidentalTripleSharp",
      "accidentalTwoThirdTonesFlatFerneyhough",
      "accidentalTwoThirdTonesSharpFerneyhough",
      "accidentalWilsonMinus",
      "accidentalWilsonPlus",
      "accidentalWyschnegradsky10TwelfthsFlat",
      "accidentalWyschnegradsky10TwelfthsSharp",
      "accidentalWyschnegradsky11TwelfthsFlat",
      "accidentalWyschnegradsky11TwelfthsSharp",
      "accidentalWyschnegradsky1TwelfthsFlat",
      "accidentalWyschnegradsky1TwelfthsSharp",
      "accidentalWyschnegradsky2TwelfthsFlat",
      "accidentalWyschnegradsky2TwelfthsSharp",
      "accidentalWyschnegradsky3TwelfthsFlat",
      "accidentalWyschnegradsky3TwelfthsSharp",
      "accidentalWyschnegradsky4TwelfthsFlat",
      "accidentalWyschnegradsky4TwelfthsSharp",
      "accidentalWyschnegradsky5TwelfthsFlat",
      "accidentalWyschnegradsky5TwelfthsSharp",
      "accidentalWyschnegradsky6TwelfthsFlat",
      "accidentalWyschnegradsky6TwelfthsSharp",
      "accidentalWyschnegradsky7TwelfthsFlat",
      "accidentalWyschnegradsky7TwelfthsSharp",
      "accidentalWyschnegradsky8TwelfthsFlat",
      "accidentalWyschnegradsky8TwelfthsSharp",
      "accidentalWyschnegradsky9TwelfthsFlat",
      "accidentalWyschnegradsky9TwelfthsSharp",
      "accidentalXenakisOneThirdToneSharp",
      "accidentalXenakisTwoThirdTonesSharp",
      "analyticsChoralmelodie",
      "analyticsEndStimme",
      "analyticsHauptrhythmus",
      "analyticsHauptstimme",
      "analyticsInversion1",
      "analyticsNebenstimme",
      "analyticsStartStimme",
      "analyticsTheme",
      "analyticsTheme1",
      "analyticsThemeInversion",
      "analyticsThemeRetrograde",
      "analyticsThemeRetrogradeInversion",
      "arpeggiatoDown",
      "arpeggiatoUp",
      "arrowBlackDown",
      "arrowBlackDownLeft",
      "arrowBlackDownRight",
      "arrowBlackLeft",
      "arrowBlackRight",
      "arrowBlackUp",
      "arrowBlackUpLeft",
      "arrowBlackUpRight",
      "arrowOpenDown",
      "arrowOpenDownLeft",
      "arrowOpenDownRight",
      "arrowOpenLeft",
      "arrowOpenRight",
      "arrowOpenUp",
      "arrowOpenUpLeft",
      "arrowOpenUpRight",
      "arrowWhiteDown",
      "arrowWhiteDownLeft",
      "arrowWhiteDownRight",
      "arrowWhiteLeft",
      "arrowWhiteRight",
      "arrowWhiteUp",
      "arrowWhiteUpLeft",
      "arrowWhiteUpRight",
      "arrowheadBlackDown",
      "arrowheadBlackDownLeft",
      "arrowheadBlackDownRight",
      "arrowheadBlackLeft",
      "arrowheadBlackRight",
      "arrowheadBlackUp",
      "arrowheadBlackUpLeft",
      "arrowheadBlackUpRight",
      "arrowheadOpenDown",
      "arrowheadOpenDownLeft",
      "arrowheadOpenDownRight",
      "arrowheadOpenLeft",
      "arrowheadOpenRight",
      "arrowheadOpenUp",
      "arrowheadOpenUpLeft",
      "arrowheadOpenUpRight",
      "arrowheadWhiteDown",
      "arrowheadWhiteDownLeft",
      "arrowheadWhiteDownRight",
      "arrowheadWhiteLeft",
      "arrowheadWhiteRight",
      "arrowheadWhiteUp",
      "arrowheadWhiteUpLeft",
      "arrowheadWhiteUpRight",
      "articAccentAbove",
      "articAccentBelow",
      "articAccentStaccatoAbove",
      "articAccentStaccatoBelow",
      "articLaissezVibrerAbove",
      "articLaissezVibrerBelow",
      "articMarcatoAbove",
      "articMarcatoBelow",
      "articMarcatoStaccatoAbove",
      "articMarcatoStaccatoBelow",
      "articMarcatoTenutoAbove",
      "articMarcatoTenutoBelow",
      "articSoftAccentAbove",
      "articSoftAccentBelow",
      "articSoftAccentStaccatoAbove",
      "articSoftAccentStaccatoBelow",
      "articSoftAccentTenutoAbove",
      "articSoftAccentTenutoBelow",
      "articSoftAccentTenutoStaccatoAbove",
      "articSoftAccentTenutoStaccatoBelow",
      "articStaccatissimoAbove",
      "articStaccatissimoBelow",
      "articStaccatissimoStrokeAbove",
      "articStaccatissimoStrokeBelow",
      "articStaccatissimoWedgeAbove",
      "articStaccatissimoWedgeBelow",
      "articStaccatoAbove",
      "articStaccatoBelow",
      "articStressAbove",
      "articStressBelow",
      "articTenutoAbove",
      "articTenutoAccentAbove",
      "articTenutoAccentBelow",
      "articTenutoBelow",
      "articTenutoStaccatoAbove",
      "articTenutoStaccatoBelow",
      "articUnstressAbove",
      "articUnstressBelow",
      "augmentationDot",
      "barlineDashed",
      "barlineDotted",
      "barlineDouble",
      "barlineFinal",
      "barlineHeavy",
      "barlineHeavyHeavy",
      "barlineReverseFinal",
      "barlineShort",
      "barlineSingle",
      "barlineTick",
      "beamAccelRit1",
      "beamAccelRit10",
      "beamAccelRit11",
      "beamAccelRit12",
      "beamAccelRit13",
      "beamAccelRit14",
      "beamAccelRit15",
      "beamAccelRit2",
      "beamAccelRit3",
      "beamAccelRit4",
      "beamAccelRit5",
      "beamAccelRit6",
      "beamAccelRit7",
      "beamAccelRit8",
      "beamAccelRit9",
      "beamAccelRitFinal",
      "brace",
      "bracket",
      "bracketBottom",
      "bracketTop",
      "brassBend",
      "brassDoitLong",
      "brassDoitMedium",
      "brassDoitShort",
      "brassFallLipLong",
      "brassFallLipMedium",
      "brassFallLipShort",
      "brassFallRoughLong",
      "brassFallRoughMedium",
      "brassFallRoughShort",
      "brassFallSmoothLong",
      "brassFallSmoothMedium",
      "brassFallSmoothShort",
      "brassFlip",
      "brassHarmonMuteClosed",
      "brassHarmonMuteStemHalfLeft",
      "brassHarmonMuteStemHalfRight",
      "brassHarmonMuteStemOpen",
      "brassJazzTurn",
      "brassLiftLong",
      "brassLiftMedium",
      "brassLiftShort",
      "brassLiftSmoothLong",
      "brassLiftSmoothMedium",
      "brassLiftSmoothShort",
      "brassMuteClosed",
      "brassMuteHalfClosed",
      "brassMuteOpen",
      "brassPlop",
      "brassScoop",
      "brassSmear",
      "brassValveTrill",
      "breathMarkComma",
      "breathMarkSalzedo",
      "breathMarkTick",
      "breathMarkUpbow",
      "bridgeClef",
      "buzzRoll",
      "cClef",
      "cClef8vb",
      "cClefArrowDown",
      "cClefArrowUp",
      "cClefChange",
      "cClefCombining",
      "cClefReversed",
      "cClefSquare",
      "caesura",
      "caesuraCurved",
      "caesuraShort",
      "caesuraThick",
      "chantAccentusAbove",
      "chantAccentusBelow",
      "chantAuctumAsc",
      "chantAuctumDesc",
      "chantAugmentum",
      "chantCaesura",
      "chantCclef",
      "chantCirculusAbove",
      "chantCirculusBelow",
      "chantConnectingLineAsc2nd",
      "chantConnectingLineAsc3rd",
      "chantConnectingLineAsc4th",
      "chantConnectingLineAsc5th",
      "chantConnectingLineAsc6th",
      "chantCustosStemDownPosHigh",
      "chantCustosStemDownPosHighest",
      "chantCustosStemDownPosMiddle",
      "chantCustosStemUpPosLow",
      "chantCustosStemUpPosLowest",
      "chantCustosStemUpPosMiddle",
      "chantDeminutumLower",
      "chantDeminutumUpper",
      "chantDivisioFinalis",
      "chantDivisioMaior",
      "chantDivisioMaxima",
      "chantDivisioMinima",
      "chantEntryLineAsc2nd",
      "chantEntryLineAsc3rd",
      "chantEntryLineAsc4th",
      "chantEntryLineAsc5th",
      "chantEntryLineAsc6th",
      "chantEpisema",
      "chantFclef",
      "chantIctusAbove",
      "chantIctusBelow",
      "chantLigaturaDesc2nd",
      "chantLigaturaDesc3rd",
      "chantLigaturaDesc4th",
      "chantLigaturaDesc5th",
      "chantOriscusAscending",
      "chantOriscusDescending",
      "chantOriscusLiquescens",
      "chantPodatusLower",
      "chantPodatusUpper",
      "chantPunctum",
      "chantPunctumCavum",
      "chantPunctumDeminutum",
      "chantPunctumInclinatum",
      "chantPunctumInclinatumAuctum",
      "chantPunctumInclinatumDeminutum",
      "chantPunctumLinea",
      "chantPunctumLineaCavum",
      "chantPunctumVirga",
      "chantPunctumVirgaReversed",
      "chantQuilisma",
      "chantSemicirculusAbove",
      "chantSemicirculusBelow",
      "chantStaff",
      "chantStaffNarrow",
      "chantStaffWide",
      "chantStrophicus",
      "chantStrophicusAuctus",
      "chantStrophicusLiquescens2nd",
      "chantStrophicusLiquescens3rd",
      "chantStrophicusLiquescens4th",
      "chantStrophicusLiquescens5th",
      "chantVirgula",
      "clef15",
      "clef8",
      "clefChangeCombining",
      "coda",
      "codaSquare",
      "conductorBeat2Compound",
      "conductorBeat2Simple",
      "conductorBeat3Compound",
      "conductorBeat3Simple",
      "conductorBeat4Compound",
      "conductorBeat4Simple",
      "conductorLeftBeat",
      "conductorRightBeat",
      "conductorStrongBeat",
      "conductorUnconducted",
      "conductorWeakBeat",
      "controlBeginBeam",
      "controlBeginPhrase",
      "controlBeginSlur",
      "controlBeginTie",
      "controlEndBeam",
      "controlEndPhrase",
      "controlEndSlur",
      "controlEndTie",
      "csymAccidentalDoubleFlat",
      "csymAccidentalDoubleSharp",
      "csymAccidentalFlat",
      "csymAccidentalNatural",
      "csymAccidentalSharp",
      "csymAccidentalTripleFlat",
      "csymAccidentalTripleSharp",
      "csymAlteredBassSlash",
      "csymAugmented",
      "csymBracketLeftTall",
      "csymBracketRightTall",
      "csymDiagonalArrangementSlash",
      "csymDiminished",
      "csymHalfDiminished",
      "csymMajorSeventh",
      "csymMinor",
      "csymParensLeftTall",
      "csymParensLeftVeryTall",
      "csymParensRightTall",
      "csymParensRightVeryTall",
      "curlewSign",
      "daCapo",
      "dalSegno",
      "daseianExcellentes1",
      "daseianExcellentes2",
      "daseianExcellentes3",
      "daseianExcellentes4",
      "daseianFinales1",
      "daseianFinales2",
      "daseianFinales3",
      "daseianFinales4",
      "daseianGraves1",
      "daseianGraves2",
      "daseianGraves3",
      "daseianGraves4",
      "daseianResidua1",
      "daseianResidua2",
      "daseianSuperiores1",
      "daseianSuperiores2",
      "daseianSuperiores3",
      "daseianSuperiores4",
      "doubleLateralRollStevens",
      "doubleTongueAbove",
      "doubleTongueBelow",
      "dynamicCombinedSeparatorColon",
      "dynamicCombinedSeparatorHyphen",
      "dynamicCombinedSeparatorSlash",
      "dynamicCombinedSeparatorSpace",
      "dynamicCrescendoHairpin",
      "dynamicDiminuendoHairpin",
      "dynamicFF",
      "dynamicFFF",
      "dynamicFFFF",
      "dynamicFFFFF",
      "dynamicFFFFFF",
      "dynamicForte",
      "dynamicFortePiano",
      "dynamicForzando",
      "dynamicHairpinBracketLeft",
      "dynamicHairpinBracketRight",
      "dynamicHairpinParenthesisLeft",
      "dynamicHairpinParenthesisRight",
      "dynamicMF",
      "dynamicMP",
      "dynamicMessaDiVoce",
      "dynamicMezzo",
      "dynamicNiente",
      "dynamicNienteForHairpin",
      "dynamicPF",
      "dynamicPP",
      "dynamicPPP",
      "dynamicPPPP",
      "dynamicPPPPP",
      "dynamicPPPPPP",
      "dynamicPiano",
      "dynamicRinforzando",
      "dynamicRinforzando1",
      "dynamicRinforzando2",
      "dynamicSforzando",
      "dynamicSforzando1",
      "dynamicSforzandoPianissimo",
      "dynamicSforzandoPiano",
      "dynamicSforzato",
      "dynamicSforzatoFF",
      "dynamicSforzatoPiano",
      "dynamicZ",
      "elecAudioChannelsEight",
      "elecAudioChannelsFive",
      "elecAudioChannelsFour",
      "elecAudioChannelsOne",
      "elecAudioChannelsSeven",
      "elecAudioChannelsSix",
      "elecAudioChannelsThreeFrontal",
      "elecAudioChannelsThreeSurround",
      "elecAudioChannelsTwo",
      "elecAudioIn",
      "elecAudioMono",
      "elecAudioOut",
      "elecAudioStereo",
      "elecCamera",
      "elecDataIn",
      "elecDataOut",
      "elecDisc",
      "elecDownload",
      "elecEject",
      "elecFastForward",
      "elecHeadphones",
      "elecHeadset",
      "elecLineIn",
      "elecLineOut",
      "elecLoop",
      "elecLoudspeaker",
      "elecMIDIController0",
      "elecMIDIController100",
      "elecMIDIController20",
      "elecMIDIController40",
      "elecMIDIController60",
      "elecMIDIController80",
      "elecMIDIIn",
      "elecMIDIOut",
      "elecMicrophone",
      "elecMicrophoneMute",
      "elecMicrophoneUnmute",
      "elecMixingConsole",
      "elecMonitor",
      "elecMute",
      "elecPause",
      "elecPlay",
      "elecPowerOnOff",
      "elecProjector",
      "elecReplay",
      "elecRewind",
      "elecShuffle",
      "elecSkipBackwards",
      "elecSkipForwards",
      "elecStop",
      "elecTape",
      "elecUSB",
      "elecUnmute",
      "elecUpload",
      "elecVideoCamera",
      "elecVideoIn",
      "elecVideoOut",
      "elecVolumeFader",
      "elecVolumeFaderThumb",
      "elecVolumeLevel0",
      "elecVolumeLevel100",
      "elecVolumeLevel20",
      "elecVolumeLevel40",
      "elecVolumeLevel60",
      "elecVolumeLevel80",
      "fClef",
      "fClef15ma",
      "fClef15mb",
      "fClef8va",
      "fClef8vb",
      "fClefArrowDown",
      "fClefArrowUp",
      "fClefChange",
      "fClefReversed",
      "fClefTurned",
      "fermataAbove",
      "fermataBelow",
      "fermataLongAbove",
      "fermataLongBelow",
      "fermataLongHenzeAbove",
      "fermataLongHenzeBelow",
      "fermataShortAbove",
      "fermataShortBelow",
      "fermataShortHenzeAbove",
      "fermataShortHenzeBelow",
      "fermataVeryLongAbove",
      "fermataVeryLongBelow",
      "fermataVeryShortAbove",
      "fermataVeryShortBelow",
      "figbass0",
      "figbass1",
      "figbass2",
      "figbass2Raised",
      "figbass3",
      "figbass4",
      "figbass4Raised",
      "figbass5",
      "figbass5Raised1",
      "figbass5Raised2",
      "figbass5Raised3",
      "figbass6",
      "figbass6Raised",
      "figbass6Raised2",
      "figbass7",
      "figbass7Diminished",
      "figbass7Raised1",
      "figbass7Raised2",
      "figbass8",
      "figbass9",
      "figbass9Raised",
      "figbassBracketLeft",
      "figbassBracketRight",
      "figbassCombiningLowering",
      "figbassCombiningRaising",
      "figbassDoubleFlat",
      "figbassDoubleSharp",
      "figbassFlat",
      "figbassNatural",
      "figbassParensLeft",
      "figbassParensRight",
      "figbassPlus",
      "figbassSharp",
      "fingering0",
      "fingering0Italic",
      "fingering1",
      "fingering1Italic",
      "fingering2",
      "fingering2Italic",
      "fingering3",
      "fingering3Italic",
      "fingering4",
      "fingering4Italic",
      "fingering5",
      "fingering5Italic",
      "fingering6",
      "fingering6Italic",
      "fingering7",
      "fingering7Italic",
      "fingering8",
      "fingering8Italic",
      "fingering9",
      "fingering9Italic",
      "fingeringALower",
      "fingeringCLower",
      "fingeringELower",
      "fingeringILower",
      "fingeringLeftBracket",
      "fingeringLeftBracketItalic",
      "fingeringLeftParenthesis",
      "fingeringLeftParenthesisItalic",
      "fingeringMLower",
      "fingeringMultipleNotes",
      "fingeringOLower",
      "fingeringPLower",
      "fingeringRightBracket",
      "fingeringRightBracketItalic",
      "fingeringRightParenthesis",
      "fingeringRightParenthesisItalic",
      "fingeringSeparatorMiddleDot",
      "fingeringSeparatorMiddleDotWhite",
      "fingeringSeparatorSlash",
      "fingeringSubstitutionAbove",
      "fingeringSubstitutionBelow",
      "fingeringSubstitutionDash",
      "fingeringTLower",
      "fingeringTUpper",
      "fingeringXLower",
      "flag1024thDown",
      "flag1024thUp",
      "flag128thDown",
      "flag128thUp",
      "flag16thDown",
      "flag16thUp",
      "flag256thDown",
      "flag256thUp",
      "flag32ndDown",
      "flag32ndUp",
      "flag512thDown",
      "flag512thUp",
      "flag64thDown",
      "flag64thUp",
      "flag8thDown",
      "flag8thUp",
      "flagInternalDown",
      "flagInternalUp",
      "fretboard3String",
      "fretboard3StringNut",
      "fretboard4String",
      "fretboard4StringNut",
      "fretboard5String",
      "fretboard5StringNut",
      "fretboard6String",
      "fretboard6StringNut",
      "fretboardFilledCircle",
      "fretboardO",
      "fretboardX",
      "functionAngleLeft",
      "functionAngleRight",
      "functionBracketLeft",
      "functionBracketRight",
      "functionDD",
      "functionDLower",
      "functionDUpper",
      "functionEight",
      "functionFUpper",
      "functionFive",
      "functionFour",
      "functionGLower",
      "functionGUpper",
      "functionGreaterThan",
      "functionILower",
      "functionIUpper",
      "functionKLower",
      "functionKUpper",
      "functionLLower",
      "functionLUpper",
      "functionLessThan",
      "functionMLower",
      "functionMUpper",
      "functionMinus",
      "functionNLower",
      "functionNUpper",
      "functionNUpperSuperscript",
      "functionNine",
      "functionOne",
      "functionPLower",
      "functionPUpper",
      "functionParensLeft",
      "functionParensRight",
      "functionPlus",
      "functionRLower",
      "functionRepetition1",
      "functionRepetition2",
      "functionRing",
      "functionSLower",
      "functionSSLower",
      "functionSSUpper",
      "functionSUpper",
      "functionSeven",
      "functionSix",
      "functionSlashedDD",
      "functionTLower",
      "functionTUpper",
      "functionThree",
      "functionTwo",
      "functionVLower",
      "functionVUpper",
      "functionZero",
      "gClef",
      "gClef15ma",
      "gClef15mb",
      "gClef8va",
      "gClef8vb",
      "gClef8vbCClef",
      "gClef8vbOld",
      "gClef8vbParens",
      "gClefArrowDown",
      "gClefArrowUp",
      "gClefChange",
      "gClefLigatedNumberAbove",
      "gClefLigatedNumberBelow",
      "gClefReversed",
      "gClefTurned",
      "glissandoDown",
      "glissandoUp",
      "graceNoteAcciaccaturaStemDown",
      "graceNoteAcciaccaturaStemUp",
      "graceNoteAppoggiaturaStemDown",
      "graceNoteAppoggiaturaStemUp",
      "graceNoteSlashStemDown",
      "graceNoteSlashStemUp",
      "guitarBarreFull",
      "guitarBarreHalf",
      "guitarClosePedal",
      "guitarFadeIn",
      "guitarFadeOut",
      "guitarGolpe",
      "guitarHalfOpenPedal",
      "guitarLeftHandTapping",
      "guitarOpenPedal",
      "guitarRightHandTapping",
      "guitarShake",
      "guitarString0",
      "guitarString1",
      "guitarString2",
      "guitarString3",
      "guitarString4",
      "guitarString5",
      "guitarString6",
      "guitarString7",
      "guitarString8",
      "guitarString9",
      "guitarStrumDown",
      "guitarStrumUp",
      "guitarVibratoBarDip",
      "guitarVibratoBarScoop",
      "guitarVibratoStroke",
      "guitarVolumeSwell",
      "guitarWideVibratoStroke",
      "handbellsBelltree",
      "handbellsDamp3",
      "handbellsEcho1",
      "handbellsEcho2",
      "handbellsGyro",
      "handbellsHandMartellato",
      "handbellsMalletBellOnTable",
      "handbellsMalletBellSuspended",
      "handbellsMalletLft",
      "handbellsMartellato",
      "handbellsMartellatoLift",
      "handbellsMutedMartellato",
      "handbellsPluckLift",
      "handbellsSwing",
      "handbellsSwingDown",
      "handbellsSwingUp",
      "handbellsTablePairBells",
      "handbellsTableSingleBell",
      "harpMetalRod",
      "harpPedalCentered",
      "harpPedalDivider",
      "harpPedalLowered",
      "harpPedalRaised",
      "harpSalzedoAeolianAscending",
      "harpSalzedoAeolianDescending",
      "harpSalzedoDampAbove",
      "harpSalzedoDampBelow",
      "harpSalzedoDampBothHands",
      "harpSalzedoDampLowStrings",
      "harpSalzedoFluidicSoundsLeft",
      "harpSalzedoFluidicSoundsRight",
      "harpSalzedoIsolatedSounds",
      "harpSalzedoMetallicSounds",
      "harpSalzedoMetallicSoundsOneString",
      "harpSalzedoMuffleTotally",
      "harpSalzedoOboicFlux",
      "harpSalzedoPlayUpperEnd",
      "harpSalzedoSlideWithSuppleness",
      "harpSalzedoSnareDrum",
      "harpSalzedoTamTamSounds",
      "harpSalzedoThunderEffect",
      "harpSalzedoTimpanicSounds",
      "harpSalzedoWhistlingSounds",
      "harpStringNoiseStem",
      "harpTuningKey",
      "harpTuningKeyGlissando",
      "harpTuningKeyHandle",
      "harpTuningKeyShank",
      "indianDrumClef",
      "kahnBackChug",
      "kahnBackFlap",
      "kahnBackRiff",
      "kahnBackRip",
      "kahnBallChange",
      "kahnBallDig",
      "kahnBrushBackward",
      "kahnBrushForward",
      "kahnChug",
      "kahnClap",
      "kahnDoubleSnap",
      "kahnDoubleWing",
      "kahnDrawStep",
      "kahnDrawTap",
      "kahnFlam",
      "kahnFlap",
      "kahnFlapStep",
      "kahnFlat",
      "kahnFleaHop",
      "kahnFleaTap",
      "kahnGraceTap",
      "kahnGraceTapChange",
      "kahnGraceTapHop",
      "kahnGraceTapStamp",
      "kahnHeel",
      "kahnHeelChange",
      "kahnHeelClick",
      "kahnHeelDrop",
      "kahnHeelStep",
      "kahnHeelTap",
      "kahnHop",
      "kahnJumpApart",
      "kahnJumpTogether",
      "kahnKneeInward",
      "kahnKneeOutward",
      "kahnLeap",
      "kahnLeapFlatFoot",
      "kahnLeapHeelClick",
      "kahnLeftCatch",
      "kahnLeftCross",
      "kahnLeftFoot",
      "kahnLeftToeStrike",
      "kahnLeftTurn",
      "kahnOverTheTop",
      "kahnOverTheTopTap",
      "kahnPull",
      "kahnPush",
      "kahnRiff",
      "kahnRiffle",
      "kahnRightCatch",
      "kahnRightCross",
      "kahnRightFoot",
      "kahnRightToeStrike",
      "kahnRightTurn",
      "kahnRip",
      "kahnRipple",
      "kahnScrape",
      "kahnScuff",
      "kahnScuffle",
      "kahnShuffle",
      "kahnSlam",
      "kahnSlap",
      "kahnSlideStep",
      "kahnSlideTap",
      "kahnSnap",
      "kahnStamp",
      "kahnStampStamp",
      "kahnStep",
      "kahnStepStamp",
      "kahnStomp",
      "kahnStompBrush",
      "kahnTap",
      "kahnToe",
      "kahnToeClick",
      "kahnToeDrop",
      "kahnToeStep",
      "kahnToeTap",
      "kahnTrench",
      "kahnWing",
      "kahnWingChange",
      "kahnZank",
      "kahnZink",
      "keyboardBebung2DotsAbove",
      "keyboardBebung2DotsBelow",
      "keyboardBebung3DotsAbove",
      "keyboardBebung3DotsBelow",
      "keyboardBebung4DotsAbove",
      "keyboardBebung4DotsBelow",
      "keyboardLeftPedalPictogram",
      "keyboardMiddlePedalPictogram",
      "keyboardPedalD",
      "keyboardPedalDot",
      "keyboardPedalE",
      "keyboardPedalHalf",
      "keyboardPedalHalf2",
      "keyboardPedalHalf3",
      "keyboardPedalHeel1",
      "keyboardPedalHeel2",
      "keyboardPedalHeel3",
      "keyboardPedalHeelToToe",
      "keyboardPedalHeelToe",
      "keyboardPedalHookEnd",
      "keyboardPedalHookStart",
      "keyboardPedalHyphen",
      "keyboardPedalP",
      "keyboardPedalParensLeft",
      "keyboardPedalParensRight",
      "keyboardPedalPed",
      "keyboardPedalS",
      "keyboardPedalSost",
      "keyboardPedalToe1",
      "keyboardPedalToe2",
      "keyboardPedalToeToHeel",
      "keyboardPedalUp",
      "keyboardPedalUpNotch",
      "keyboardPedalUpSpecial",
      "keyboardPlayWithLH",
      "keyboardPlayWithLHEnd",
      "keyboardPlayWithRH",
      "keyboardPlayWithRHEnd",
      "keyboardPluckInside",
      "keyboardRightPedalPictogram",
      "kievanAccidentalFlat",
      "kievanAccidentalSharp",
      "kievanAugmentationDot",
      "kievanCClef",
      "kievanEndingSymbol",
      "kievanNote8thStemDown",
      "kievanNote8thStemUp",
      "kievanNoteBeam",
      "kievanNoteHalfStaffLine",
      "kievanNoteHalfStaffSpace",
      "kievanNoteQuarterStemDown",
      "kievanNoteQuarterStemUp",
      "kievanNoteReciting",
      "kievanNoteWhole",
      "kievanNoteWholeFinal",
      "kodalyHandDo",
      "kodalyHandFa",
      "kodalyHandLa",
      "kodalyHandMi",
      "kodalyHandRe",
      "kodalyHandSo",
      "kodalyHandTi",
      "leftRepeatSmall",
      "legerLine",
      "legerLineNarrow",
      "legerLineWide",
      "luteBarlineEndRepeat",
      "luteBarlineFinal",
      "luteBarlineStartRepeat",
      "luteDuration16th",
      "luteDuration32nd",
      "luteDuration8th",
      "luteDurationDoubleWhole",
      "luteDurationHalf",
      "luteDurationQuarter",
      "luteDurationWhole",
      "luteFingeringRHFirst",
      "luteFingeringRHSecond",
      "luteFingeringRHThird",
      "luteFingeringRHThumb",
      "luteFrench10thCourse",
      "luteFrench7thCourse",
      "luteFrench8thCourse",
      "luteFrench9thCourse",
      "luteFrenchAppoggiaturaAbove",
      "luteFrenchAppoggiaturaBelow",
      "luteFrenchFretA",
      "luteFrenchFretB",
      "luteFrenchFretC",
      "luteFrenchFretD",
      "luteFrenchFretE",
      "luteFrenchFretF",
      "luteFrenchFretG",
      "luteFrenchFretH",
      "luteFrenchFretI",
      "luteFrenchFretK",
      "luteFrenchFretL",
      "luteFrenchFretM",
      "luteFrenchFretN",
      "luteFrenchMordentInverted",
      "luteFrenchMordentLower",
      "luteFrenchMordentUpper",
      "luteGermanALower",
      "luteGermanAUpper",
      "luteGermanBLower",
      "luteGermanBUpper",
      "luteGermanCLower",
      "luteGermanCUpper",
      "luteGermanDLower",
      "luteGermanDUpper",
      "luteGermanELower",
      "luteGermanEUpper",
      "luteGermanFLower",
      "luteGermanFUpper",
      "luteGermanGLower",
      "luteGermanGUpper",
      "luteGermanHLower",
      "luteGermanHUpper",
      "luteGermanILower",
      "luteGermanIUpper",
      "luteGermanKLower",
      "luteGermanKUpper",
      "luteGermanLLower",
      "luteGermanLUpper",
      "luteGermanMLower",
      "luteGermanMUpper",
      "luteGermanNLower",
      "luteGermanNUpper",
      "luteGermanOLower",
      "luteGermanPLower",
      "luteGermanQLower",
      "luteGermanRLower",
      "luteGermanSLower",
      "luteGermanTLower",
      "luteGermanVLower",
      "luteGermanXLower",
      "luteGermanYLower",
      "luteGermanZLower",
      "luteItalianClefCSolFaUt",
      "luteItalianClefFFaUt",
      "luteItalianFret0",
      "luteItalianFret1",
      "luteItalianFret2",
      "luteItalianFret3",
      "luteItalianFret4",
      "luteItalianFret5",
      "luteItalianFret6",
      "luteItalianFret7",
      "luteItalianFret8",
      "luteItalianFret9",
      "luteItalianHoldFinger",
      "luteItalianHoldNote",
      "luteItalianReleaseFinger",
      "luteItalianTempoFast",
      "luteItalianTempoNeitherFastNorSlow",
      "luteItalianTempoSlow",
      "luteItalianTempoSomewhatFast",
      "luteItalianTempoVerySlow",
      "luteItalianTimeTriple",
      "luteItalianTremolo",
      "luteItalianVibrato",
      "luteStaff6Lines",
      "luteStaff6LinesNarrow",
      "luteStaff6LinesWide",
      "lyricsElision",
      "lyricsElisionNarrow",
      "lyricsElisionWide",
      "lyricsHyphenBaseline",
      "lyricsHyphenBaselineNonBreaking",
      "lyricsTextRepeat",
      "medRenFlatHardB",
      "medRenFlatSoftB",
      "medRenFlatWithDot",
      "medRenGClefCMN",
      "medRenLiquescenceCMN",
      "medRenLiquescentAscCMN",
      "medRenLiquescentDescCMN",
      "medRenNatural",
      "medRenNaturalWithCross",
      "medRenOriscusCMN",
      "medRenPlicaCMN",
      "medRenPunctumCMN",
      "medRenQuilismaCMN",
      "medRenSharpCroix",
      "medRenStrophicusCMN",
      "mensuralAlterationSign",
      "mensuralBlackBrevis",
      "mensuralBlackBrevisVoid",
      "mensuralBlackDragma",
      "mensuralBlackLonga",
      "mensuralBlackMaxima",
      "mensuralBlackMinima",
      "mensuralBlackMinimaVoid",
      "mensuralBlackSemibrevis",
      "mensuralBlackSemibrevisCaudata",
      "mensuralBlackSemibrevisOblique",
      "mensuralBlackSemibrevisVoid",
      "mensuralBlackSemiminima",
      "mensuralCclef",
      "mensuralCclefPetrucciPosHigh",
      "mensuralCclefPetrucciPosHighest",
      "mensuralCclefPetrucciPosLow",
      "mensuralCclefPetrucciPosLowest",
      "mensuralCclefPetrucciPosMiddle",
      "mensuralColorationEndRound",
      "mensuralColorationEndSquare",
      "mensuralColorationStartRound",
      "mensuralColorationStartSquare",
      "mensuralCombStemDiagonal",
      "mensuralCombStemDown",
      "mensuralCombStemDownFlagExtended",
      "mensuralCombStemDownFlagFlared",
      "mensuralCombStemDownFlagFusa",
      "mensuralCombStemDownFlagLeft",
      "mensuralCombStemDownFlagRight",
      "mensuralCombStemDownFlagSemiminima",
      "mensuralCombStemUp",
      "mensuralCombStemUpFlagExtended",
      "mensuralCombStemUpFlagFlared",
      "mensuralCombStemUpFlagFusa",
      "mensuralCombStemUpFlagLeft",
      "mensuralCombStemUpFlagRight",
      "mensuralCombStemUpFlagSemiminima",
      "mensuralCustosCheckmark",
      "mensuralCustosDown",
      "mensuralCustosTurn",
      "mensuralCustosUp",
      "mensuralFclef",
      "mensuralFclefPetrucci",
      "mensuralGclef",
      "mensuralGclefPetrucci",
      "mensuralModusImperfectumVert",
      "mensuralModusPerfectumVert",
      "mensuralNoteheadLongaBlack",
      "mensuralNoteheadLongaBlackVoid",
      "mensuralNoteheadLongaVoid",
      "mensuralNoteheadLongaWhite",
      "mensuralNoteheadMaximaBlack",
      "mensuralNoteheadMaximaBlackVoid",
      "mensuralNoteheadMaximaVoid",
      "mensuralNoteheadMaximaWhite",
      "mensuralNoteheadMinimaWhite",
      "mensuralNoteheadSemibrevisBlack",
      "mensuralNoteheadSemibrevisBlackVoid",
      "mensuralNoteheadSemibrevisBlackVoidTurned",
      "mensuralNoteheadSemibrevisVoid",
      "mensuralNoteheadSemiminimaWhite",
      "mensuralObliqueAsc2ndBlack",
      "mensuralObliqueAsc2ndBlackVoid",
      "mensuralObliqueAsc2ndVoid",
      "mensuralObliqueAsc2ndWhite",
      "mensuralObliqueAsc3rdBlack",
      "mensuralObliqueAsc3rdBlackVoid",
      "mensuralObliqueAsc3rdVoid",
      "mensuralObliqueAsc3rdWhite",
      "mensuralObliqueAsc4thBlack",
      "mensuralObliqueAsc4thBlackVoid",
      "mensuralObliqueAsc4thVoid",
      "mensuralObliqueAsc4thWhite",
      "mensuralObliqueAsc5thBlack",
      "mensuralObliqueAsc5thBlackVoid",
      "mensuralObliqueAsc5thVoid",
      "mensuralObliqueAsc5thWhite",
      "mensuralObliqueDesc2ndBlack",
      "mensuralObliqueDesc2ndBlackVoid",
      "mensuralObliqueDesc2ndVoid",
      "mensuralObliqueDesc2ndWhite",
      "mensuralObliqueDesc3rdBlack",
      "mensuralObliqueDesc3rdBlackVoid",
      "mensuralObliqueDesc3rdVoid",
      "mensuralObliqueDesc3rdWhite",
      "mensuralObliqueDesc4thBlack",
      "mensuralObliqueDesc4thBlackVoid",
      "mensuralObliqueDesc4thVoid",
      "mensuralObliqueDesc4thWhite",
      "mensuralObliqueDesc5thBlack",
      "mensuralObliqueDesc5thBlackVoid",
      "mensuralObliqueDesc5thVoid",
      "mensuralObliqueDesc5thWhite",
      "mensuralProlation1",
      "mensuralProlation10",
      "mensuralProlation11",
      "mensuralProlation2",
      "mensuralProlation3",
      "mensuralProlation4",
      "mensuralProlation5",
      "mensuralProlation6",
      "mensuralProlation7",
      "mensuralProlation8",
      "mensuralProlation9",
      "mensuralProlationCombiningDot",
      "mensuralProlationCombiningDotVoid",
      "mensuralProlationCombiningStroke",
      "mensuralProlationCombiningThreeDots",
      "mensuralProlationCombiningThreeDotsTri",
      "mensuralProlationCombiningTwoDots",
      "mensuralProportion1",
      "mensuralProportion2",
      "mensuralProportion3",
      "mensuralProportion4",
      "mensuralProportionMajor",
      "mensuralProportionMinor",
      "mensuralProportionProportioDupla1",
      "mensuralProportionProportioDupla2",
      "mensuralProportionProportioQuadrupla",
      "mensuralProportionProportioTripla",
      "mensuralProportionTempusPerfectum",
      "mensuralRestBrevis",
      "mensuralRestFusa",
      "mensuralRestLongaImperfecta",
      "mensuralRestLongaPerfecta",
      "mensuralRestMaxima",
      "mensuralRestMinima",
      "mensuralRestSemibrevis",
      "mensuralRestSemifusa",
      "mensuralRestSemiminima",
      "mensuralSignumDown",
      "mensuralSignumUp",
      "mensuralTempusImperfectumHoriz",
      "mensuralTempusPerfectumHoriz",
      "mensuralWhiteBrevis",
      "mensuralWhiteFusa",
      "mensuralWhiteLonga",
      "mensuralWhiteMaxima",
      "mensuralWhiteMinima",
      "mensuralWhiteSemiminima",
      "metAugmentationDot",
      "metNote1024thDown",
      "metNote1024thUp",
      "metNote128thDown",
      "metNote128thUp",
      "metNote16thDown",
      "metNote16thUp",
      "metNote256thDown",
      "metNote256thUp",
      "metNote32ndDown",
      "metNote32ndUp",
      "metNote512thDown",
      "metNote512thUp",
      "metNote64thDown",
      "metNote64thUp",
      "metNote8thDown",
      "metNote8thUp",
      "metNoteDoubleWhole",
      "metNoteDoubleWholeSquare",
      "metNoteHalfDown",
      "metNoteHalfUp",
      "metNoteQuarterDown",
      "metNoteQuarterUp",
      "metNoteWhole",
      "metricModulationArrowLeft",
      "metricModulationArrowRight",
      "miscDoNotCopy",
      "miscDoNotPhotocopy",
      "miscEyeglasses",
      "note1024thDown",
      "note1024thUp",
      "note128thDown",
      "note128thUp",
      "note16thDown",
      "note16thUp",
      "note256thDown",
      "note256thUp",
      "note32ndDown",
      "note32ndUp",
      "note512thDown",
      "note512thUp",
      "note64thDown",
      "note64thUp",
      "note8thDown",
      "note8thUp",
      "noteABlack",
      "noteAFlatBlack",
      "noteAFlatHalf",
      "noteAFlatWhole",
      "noteAHalf",
      "noteASharpBlack",
      "noteASharpHalf",
      "noteASharpWhole",
      "noteAWhole",
      "noteBBlack",
      "noteBFlatBlack",
      "noteBFlatHalf",
      "noteBFlatWhole",
      "noteBHalf",
      "noteBSharpBlack",
      "noteBSharpHalf",
      "noteBSharpWhole",
      "noteBWhole",
      "noteCBlack",
      "noteCFlatBlack",
      "noteCFlatHalf",
      "noteCFlatWhole",
      "noteCHalf",
      "noteCSharpBlack",
      "noteCSharpHalf",
      "noteCSharpWhole",
      "noteCWhole",
      "noteDBlack",
      "noteDFlatBlack",
      "noteDFlatHalf",
      "noteDFlatWhole",
      "noteDHalf",
      "noteDSharpBlack",
      "noteDSharpHalf",
      "noteDSharpWhole",
      "noteDWhole",
      "noteDoBlack",
      "noteDoHalf",
      "noteDoWhole",
      "noteDoubleWhole",
      "noteDoubleWholeSquare",
      "noteEBlack",
      "noteEFlatBlack",
      "noteEFlatHalf",
      "noteEFlatWhole",
      "noteEHalf",
      "noteESharpBlack",
      "noteESharpHalf",
      "noteESharpWhole",
      "noteEWhole",
      "noteEmptyBlack",
      "noteEmptyHalf",
      "noteEmptyWhole",
      "noteFBlack",
      "noteFFlatBlack",
      "noteFFlatHalf",
      "noteFFlatWhole",
      "noteFHalf",
      "noteFSharpBlack",
      "noteFSharpHalf",
      "noteFSharpWhole",
      "noteFWhole",
      "noteFaBlack",
      "noteFaHalf",
      "noteFaWhole",
      "noteGBlack",
      "noteGFlatBlack",
      "noteGFlatHalf",
      "noteGFlatWhole",
      "noteGHalf",
      "noteGSharpBlack",
      "noteGSharpHalf",
      "noteGSharpWhole",
      "noteGWhole",
      "noteHBlack",
      "noteHHalf",
      "noteHSharpBlack",
      "noteHSharpHalf",
      "noteHSharpWhole",
      "noteHWhole",
      "noteHalfDown",
      "noteHalfUp",
      "noteLaBlack",
      "noteLaHalf",
      "noteLaWhole",
      "noteMiBlack",
      "noteMiHalf",
      "noteMiWhole",
      "noteQuarterDown",
      "noteQuarterUp",
      "noteReBlack",
      "noteReHalf",
      "noteReWhole",
      "noteShapeArrowheadLeftBlack",
      "noteShapeArrowheadLeftDoubleWhole",
      "noteShapeArrowheadLeftWhite",
      "noteShapeDiamondBlack",
      "noteShapeDiamondDoubleWhole",
      "noteShapeDiamondWhite",
      "noteShapeIsoscelesTriangleBlack",
      "noteShapeIsoscelesTriangleDoubleWhole",
      "noteShapeIsoscelesTriangleWhite",
      "noteShapeKeystoneBlack",
      "noteShapeKeystoneDoubleWhole",
      "noteShapeKeystoneWhite",
      "noteShapeMoonBlack",
      "noteShapeMoonDoubleWhole",
      "noteShapeMoonLeftBlack",
      "noteShapeMoonLeftDoubleWhole",
      "noteShapeMoonLeftWhite",
      "noteShapeMoonWhite",
      "noteShapeQuarterMoonBlack",
      "noteShapeQuarterMoonDoubleWhole",
      "noteShapeQuarterMoonWhite",
      "noteShapeRoundBlack",
      "noteShapeRoundDoubleWhole",
      "noteShapeRoundWhite",
      "noteShapeSquareBlack",
      "noteShapeSquareDoubleWhole",
      "noteShapeSquareWhite",
      "noteShapeTriangleLeftBlack",
      "noteShapeTriangleLeftDoubleWhole",
      "noteShapeTriangleLeftWhite",
      "noteShapeTriangleRightBlack",
      "noteShapeTriangleRightDoubleWhole",
      "noteShapeTriangleRightWhite",
      "noteShapeTriangleRoundBlack",
      "noteShapeTriangleRoundDoubleWhole",
      "noteShapeTriangleRoundLeftBlack",
      "noteShapeTriangleRoundLeftDoubleWhole",
      "noteShapeTriangleRoundLeftWhite",
      "noteShapeTriangleRoundWhite",
      "noteShapeTriangleUpBlack",
      "noteShapeTriangleUpDoubleWhole",
      "noteShapeTriangleUpWhite",
      "noteSiBlack",
      "noteSiHalf",
      "noteSiWhole",
      "noteSoBlack",
      "noteSoHalf",
      "noteSoWhole",
      "noteTiBlack",
      "noteTiHalf",
      "noteTiWhole",
      "noteWhole",
      "noteheadBlack",
      "noteheadCircleSlash",
      "noteheadCircleX",
      "noteheadCircleXDoubleWhole",
      "noteheadCircleXHalf",
      "noteheadCircleXWhole",
      "noteheadCircledBlack",
      "noteheadCircledBlackLarge",
      "noteheadCircledDoubleWhole",
      "noteheadCircledDoubleWholeLarge",
      "noteheadCircledHalf",
      "noteheadCircledHalfLarge",
      "noteheadCircledWhole",
      "noteheadCircledWholeLarge",
      "noteheadCircledXLarge",
      "noteheadClusterDoubleWhole2nd",
      "noteheadClusterDoubleWhole3rd",
      "noteheadClusterDoubleWholeBottom",
      "noteheadClusterDoubleWholeMiddle",
      "noteheadClusterDoubleWholeTop",
      "noteheadClusterHalf2nd",
      "noteheadClusterHalf3rd",
      "noteheadClusterHalfBottom",
      "noteheadClusterHalfMiddle",
      "noteheadClusterHalfTop",
      "noteheadClusterQuarter2nd",
      "noteheadClusterQuarter3rd",
      "noteheadClusterQuarterBottom",
      "noteheadClusterQuarterMiddle",
      "noteheadClusterQuarterTop",
      "noteheadClusterRoundBlack",
      "noteheadClusterRoundWhite",
      "noteheadClusterSquareBlack",
      "noteheadClusterSquareWhite",
      "noteheadClusterWhole2nd",
      "noteheadClusterWhole3rd",
      "noteheadClusterWholeBottom",
      "noteheadClusterWholeMiddle",
      "noteheadClusterWholeTop",
      "noteheadDiamondBlack",
      "noteheadDiamondBlackOld",
      "noteheadDiamondBlackWide",
      "noteheadDiamondClusterBlack2nd",
      "noteheadDiamondClusterBlack3rd",
      "noteheadDiamondClusterBlackBottom",
      "noteheadDiamondClusterBlackMiddle",
      "noteheadDiamondClusterBlackTop",
      "noteheadDiamondClusterWhite2nd",
      "noteheadDiamondClusterWhite3rd",
      "noteheadDiamondClusterWhiteBottom",
      "noteheadDiamondClusterWhiteMiddle",
      "noteheadDiamondClusterWhiteTop",
      "noteheadDiamondDoubleWhole",
      "noteheadDiamondDoubleWholeOld",
      "noteheadDiamondHalf",
      "noteheadDiamondHalfFilled",
      "noteheadDiamondHalfOld",
      "noteheadDiamondHalfWide",
      "noteheadDiamondOpen",
      "noteheadDiamondWhite",
      "noteheadDiamondWhiteWide",
      "noteheadDiamondWhole",
      "noteheadDiamondWholeOld",
      "noteheadDoubleWhole",
      "noteheadDoubleWholeSquare",
      "noteheadDoubleWholeWithX",
      "noteheadHalf",
      "noteheadHalfFilled",
      "noteheadHalfWithX",
      "noteheadHeavyX",
      "noteheadHeavyXHat",
      "noteheadLargeArrowDownBlack",
      "noteheadLargeArrowDownDoubleWhole",
      "noteheadLargeArrowDownHalf",
      "noteheadLargeArrowDownWhole",
      "noteheadLargeArrowUpBlack",
      "noteheadLargeArrowUpDoubleWhole",
      "noteheadLargeArrowUpHalf",
      "noteheadLargeArrowUpWhole",
      "noteheadMoonBlack",
      "noteheadMoonWhite",
      "noteheadNull",
      "noteheadParenthesis",
      "noteheadParenthesisLeft",
      "noteheadParenthesisRight",
      "noteheadPlusBlack",
      "noteheadPlusDoubleWhole",
      "noteheadPlusHalf",
      "noteheadPlusWhole",
      "noteheadRectangularClusterBlackBottom",
      "noteheadRectangularClusterBlackMiddle",
      "noteheadRectangularClusterBlackTop",
      "noteheadRectangularClusterWhiteBottom",
      "noteheadRectangularClusterWhiteMiddle",
      "noteheadRectangularClusterWhiteTop",
      "noteheadRoundBlack",
      "noteheadRoundBlackDoubleSlashed",
      "noteheadRoundBlackLarge",
      "noteheadRoundBlackSlashed",
      "noteheadRoundBlackSlashedLarge",
      "noteheadRoundWhite",
      "noteheadRoundWhiteDoubleSlashed",
      "noteheadRoundWhiteLarge",
      "noteheadRoundWhiteSlashed",
      "noteheadRoundWhiteSlashedLarge",
      "noteheadRoundWhiteWithDot",
      "noteheadRoundWhiteWithDotLarge",
      "noteheadSlashDiamondWhite",
      "noteheadSlashHorizontalEnds",
      "noteheadSlashHorizontalEndsMuted",
      "noteheadSlashVerticalEnds",
      "noteheadSlashVerticalEndsMuted",
      "noteheadSlashVerticalEndsSmall",
      "noteheadSlashWhiteDoubleWhole",
      "noteheadSlashWhiteHalf",
      "noteheadSlashWhiteMuted",
      "noteheadSlashWhiteWhole",
      "noteheadSlashX",
      "noteheadSlashedBlack1",
      "noteheadSlashedBlack2",
      "noteheadSlashedDoubleWhole1",
      "noteheadSlashedDoubleWhole2",
      "noteheadSlashedHalf1",
      "noteheadSlashedHalf2",
      "noteheadSlashedWhole1",
      "noteheadSlashedWhole2",
      "noteheadSquareBlack",
      "noteheadSquareBlackLarge",
      "noteheadSquareBlackWhite",
      "noteheadSquareWhite",
      "noteheadTriangleDownBlack",
      "noteheadTriangleDownDoubleWhole",
      "noteheadTriangleDownHalf",
      "noteheadTriangleDownWhite",
      "noteheadTriangleDownWhole",
      "noteheadTriangleLeftBlack",
      "noteheadTriangleLeftWhite",
      "noteheadTriangleRightBlack",
      "noteheadTriangleRightWhite",
      "noteheadTriangleRoundDownBlack",
      "noteheadTriangleRoundDownWhite",
      "noteheadTriangleUpBlack",
      "noteheadTriangleUpDoubleWhole",
      "noteheadTriangleUpHalf",
      "noteheadTriangleUpRightBlack",
      "noteheadTriangleUpRightWhite",
      "noteheadTriangleUpWhite",
      "noteheadTriangleUpWhole",
      "noteheadVoidWithX",
      "noteheadWhole",
      "noteheadWholeFilled",
      "noteheadWholeWithX",
      "noteheadXBlack",
      "noteheadXDoubleWhole",
      "noteheadXHalf",
      "noteheadXOrnate",
      "noteheadXOrnateEllipse",
      "noteheadXWhole",
      "octaveBaselineA",
      "octaveBaselineB",
      "octaveBaselineM",
      "octaveBaselineV",
      "octaveBassa",
      "octaveLoco",
      "octaveParensLeft",
      "octaveParensRight",
      "octaveSuperscriptA",
      "octaveSuperscriptB",
      "octaveSuperscriptM",
      "octaveSuperscriptV",
      "oneHandedRollStevens",
      "organGerman2Fusae",
      "organGerman2Minimae",
      "organGerman2OctaveUp",
      "organGerman2Semifusae",
      "organGerman2Semiminimae",
      "organGerman3Fusae",
      "organGerman3Minimae",
      "organGerman3Semifusae",
      "organGerman3Semiminimae",
      "organGerman4Fusae",
      "organGerman4Minimae",
      "organGerman4Semifusae",
      "organGerman4Semiminimae",
      "organGerman5Fusae",
      "organGerman5Minimae",
      "organGerman5Semifusae",
      "organGerman5Semiminimae",
      "organGerman6Fusae",
      "organGerman6Minimae",
      "organGerman6Semifusae",
      "organGerman6Semiminimae",
      "organGermanALower",
      "organGermanAUpper",
      "organGermanAugmentationDot",
      "organGermanBLower",
      "organGermanBUpper",
      "organGermanBuxheimerBrevis2",
      "organGermanBuxheimerBrevis3",
      "organGermanBuxheimerMinimaRest",
      "organGermanBuxheimerSemibrevis",
      "organGermanBuxheimerSemibrevisRest",
      "organGermanCLower",
      "organGermanCUpper",
      "organGermanCisLower",
      "organGermanCisUpper",
      "organGermanDLower",
      "organGermanDUpper",
      "organGermanDisLower",
      "organGermanDisUpper",
      "organGermanELower",
      "organGermanEUpper",
      "organGermanFLower",
      "organGermanFUpper",
      "organGermanFisLower",
      "organGermanFisUpper",
      "organGermanFusa",
      "organGermanFusaRest",
      "organGermanGLower",
      "organGermanGUpper",
      "organGermanGisLower",
      "organGermanGisUpper",
      "organGermanHLower",
      "organGermanHUpper",
      "organGermanMinima",
      "organGermanMinimaRest",
      "organGermanOctaveDown",
      "organGermanOctaveUp",
      "organGermanSemibrevis",
      "organGermanSemibrevisRest",
      "organGermanSemifusa",
      "organGermanSemifusaRest",
      "organGermanSemiminima",
      "organGermanSemiminimaRest",
      "organGermanTie",
      "ornamentBottomLeftConcaveStroke",
      "ornamentBottomLeftConcaveStrokeLarge",
      "ornamentBottomLeftConvexStroke",
      "ornamentBottomRightConcaveStroke",
      "ornamentBottomRightConvexStroke",
      "ornamentComma",
      "ornamentDoubleObliqueLinesAfterNote",
      "ornamentDoubleObliqueLinesBeforeNote",
      "ornamentDownCurve",
      "ornamentHaydn",
      "ornamentHighLeftConcaveStroke",
      "ornamentHighLeftConvexStroke",
      "ornamentHighRightConcaveStroke",
      "ornamentHighRightConvexStroke",
      "ornamentHookAfterNote",
      "ornamentHookBeforeNote",
      "ornamentLeftFacingHalfCircle",
      "ornamentLeftFacingHook",
      "ornamentLeftPlus",
      "ornamentLeftShakeT",
      "ornamentLeftVerticalStroke",
      "ornamentLeftVerticalStrokeWithCross",
      "ornamentLowLeftConcaveStroke",
      "ornamentLowLeftConvexStroke",
      "ornamentLowRightConcaveStroke",
      "ornamentLowRightConvexStroke",
      "ornamentMiddleVerticalStroke",
      "ornamentMordent",
      "ornamentObliqueLineAfterNote",
      "ornamentObliqueLineBeforeNote",
      "ornamentObliqueLineHorizAfterNote",
      "ornamentObliqueLineHorizBeforeNote",
      "ornamentOriscus",
      "ornamentPinceCouperin",
      "ornamentPortDeVoixV",
      "ornamentPrecompAppoggTrill",
      "ornamentPrecompAppoggTrillSuffix",
      "ornamentPrecompCadence",
      "ornamentPrecompCadenceUpperPrefix",
      "ornamentPrecompCadenceUpperPrefixTurn",
      "ornamentPrecompCadenceWithTurn",
      "ornamentPrecompDescendingSlide",
      "ornamentPrecompDoubleCadenceLowerPrefix",
      "ornamentPrecompDoubleCadenceUpperPrefix",
      "ornamentPrecompDoubleCadenceUpperPrefixTurn",
      "ornamentPrecompInvertedMordentUpperPrefix",
      "ornamentPrecompMordentRelease",
      "ornamentPrecompMordentUpperPrefix",
      "ornamentPrecompPortDeVoixMordent",
      "ornamentPrecompSlide",
      "ornamentPrecompSlideTrillBach",
      "ornamentPrecompSlideTrillDAnglebert",
      "ornamentPrecompSlideTrillMarpurg",
      "ornamentPrecompSlideTrillMuffat",
      "ornamentPrecompSlideTrillSuffixMuffat",
      "ornamentPrecompTrillLowerSuffix",
      "ornamentPrecompTrillSuffixDandrieu",
      "ornamentPrecompTrillWithMordent",
      "ornamentPrecompTurnTrillBach",
      "ornamentPrecompTurnTrillDAnglebert",
      "ornamentQuilisma",
      "ornamentRightFacingHalfCircle",
      "ornamentRightFacingHook",
      "ornamentRightVerticalStroke",
      "ornamentSchleifer",
      "ornamentShake3",
      "ornamentShakeMuffat1",
      "ornamentShortObliqueLineAfterNote",
      "ornamentShortObliqueLineBeforeNote",
      "ornamentShortTrill",
      "ornamentTopLeftConcaveStroke",
      "ornamentTopLeftConvexStroke",
      "ornamentTopRightConcaveStroke",
      "ornamentTopRightConvexStroke",
      "ornamentTremblement",
      "ornamentTremblementCouperin",
      "ornamentTrill",
      "ornamentTurn",
      "ornamentTurnInverted",
      "ornamentTurnSlash",
      "ornamentTurnUp",
      "ornamentTurnUpS",
      "ornamentUpCurve",
      "ornamentVerticalLine",
      "ornamentZigZagLineNoRightEnd",
      "ornamentZigZagLineWithRightEnd",
      "ottava",
      "ottavaAlta",
      "ottavaBassa",
      "ottavaBassaBa",
      "ottavaBassaVb",
      "pendereckiTremolo",
      "pictAgogo",
      "pictAlmglocken",
      "pictAnvil",
      "pictBambooChimes",
      "pictBambooScraper",
      "pictBassDrum",
      "pictBassDrumOnSide",
      "pictBeaterBow",
      "pictBeaterBox",
      "pictBeaterBrassMalletsDown",
      "pictBeaterBrassMalletsLeft",
      "pictBeaterBrassMalletsRight",
      "pictBeaterBrassMalletsUp",
      "pictBeaterCombiningDashedCircle",
      "pictBeaterCombiningParentheses",
      "pictBeaterDoubleBassDrumDown",
      "pictBeaterDoubleBassDrumUp",
      "pictBeaterFinger",
      "pictBeaterFingernails",
      "pictBeaterFist",
      "pictBeaterGuiroScraper",
      "pictBeaterHammer",
      "pictBeaterHammerMetalDown",
      "pictBeaterHammerMetalUp",
      "pictBeaterHammerPlasticDown",
      "pictBeaterHammerPlasticUp",
      "pictBeaterHammerWoodDown",
      "pictBeaterHammerWoodUp",
      "pictBeaterHand",
      "pictBeaterHardBassDrumDown",
      "pictBeaterHardBassDrumUp",
      "pictBeaterHardGlockenspielDown",
      "pictBeaterHardGlockenspielLeft",
      "pictBeaterHardGlockenspielRight",
      "pictBeaterHardGlockenspielUp",
      "pictBeaterHardTimpaniDown",
      "pictBeaterHardTimpaniLeft",
      "pictBeaterHardTimpaniRight",
      "pictBeaterHardTimpaniUp",
      "pictBeaterHardXylophoneDown",
      "pictBeaterHardXylophoneLeft",
      "pictBeaterHardXylophoneRight",
      "pictBeaterHardXylophoneUp",
      "pictBeaterHardYarnDown",
      "pictBeaterHardYarnLeft",
      "pictBeaterHardYarnRight",
      "pictBeaterHardYarnUp",
      "pictBeaterJazzSticksDown",
      "pictBeaterJazzSticksUp",
      "pictBeaterKnittingNeedle",
      "pictBeaterMallet",
      "pictBeaterMalletDown",
      "pictBeaterMediumBassDrumDown",
      "pictBeaterMediumBassDrumUp",
      "pictBeaterMediumTimpaniDown",
      "pictBeaterMediumTimpaniLeft",
      "pictBeaterMediumTimpaniRight",
      "pictBeaterMediumTimpaniUp",
      "pictBeaterMediumXylophoneDown",
      "pictBeaterMediumXylophoneLeft",
      "pictBeaterMediumXylophoneRight",
      "pictBeaterMediumXylophoneUp",
      "pictBeaterMediumYarnDown",
      "pictBeaterMediumYarnLeft",
      "pictBeaterMediumYarnRight",
      "pictBeaterMediumYarnUp",
      "pictBeaterMetalBassDrumDown",
      "pictBeaterMetalBassDrumUp",
      "pictBeaterMetalDown",
      "pictBeaterMetalHammer",
      "pictBeaterMetalLeft",
      "pictBeaterMetalRight",
      "pictBeaterMetalUp",
      "pictBeaterSnareSticksDown",
      "pictBeaterSnareSticksUp",
      "pictBeaterSoftBassDrumDown",
      "pictBeaterSoftBassDrumUp",
      "pictBeaterSoftGlockenspielDown",
      "pictBeaterSoftGlockenspielLeft",
      "pictBeaterSoftGlockenspielRight",
      "pictBeaterSoftGlockenspielUp",
      "pictBeaterSoftTimpaniDown",
      "pictBeaterSoftTimpaniLeft",
      "pictBeaterSoftTimpaniRight",
      "pictBeaterSoftTimpaniUp",
      "pictBeaterSoftXylophone",
      "pictBeaterSoftXylophoneDown",
      "pictBeaterSoftXylophoneLeft",
      "pictBeaterSoftXylophoneRight",
      "pictBeaterSoftXylophoneUp",
      "pictBeaterSoftYarnDown",
      "pictBeaterSoftYarnLeft",
      "pictBeaterSoftYarnRight",
      "pictBeaterSoftYarnUp",
      "pictBeaterSpoonWoodenMallet",
      "pictBeaterSuperballDown",
      "pictBeaterSuperballLeft",
      "pictBeaterSuperballRight",
      "pictBeaterSuperballUp",
      "pictBeaterTriangleDown",
      "pictBeaterTrianglePlain",
      "pictBeaterTriangleUp",
      "pictBeaterWireBrushesDown",
      "pictBeaterWireBrushesUp",
      "pictBeaterWoodTimpaniDown",
      "pictBeaterWoodTimpaniLeft",
      "pictBeaterWoodTimpaniRight",
      "pictBeaterWoodTimpaniUp",
      "pictBeaterWoodXylophoneDown",
      "pictBeaterWoodXylophoneLeft",
      "pictBeaterWoodXylophoneRight",
      "pictBeaterWoodXylophoneUp",
      "pictBell",
      "pictBellOfCymbal",
      "pictBellPlate",
      "pictBellTree",
      "pictBirdWhistle",
      "pictBoardClapper",
      "pictBongos",
      "pictBrakeDrum",
      "pictCabasa",
      "pictCannon",
      "pictCarHorn",
      "pictCastanets",
      "pictCastanetsWithHandle",
      "pictCelesta",
      "pictCencerro",
      "pictCenter1",
      "pictCenter2",
      "pictCenter3",
      "pictChainRattle",
      "pictChimes",
      "pictChineseCymbal",
      "pictChokeCymbal",
      "pictClaves",
      "pictCoins",
      "pictConga",
      "pictCowBell",
      "pictCrashCymbals",
      "pictCrotales",
      "pictCrushStem",
      "pictCuica",
      "pictCymbalTongs",
      "pictDamp1",
      "pictDamp2",
      "pictDamp3",
      "pictDamp4",
      "pictDeadNoteStem",
      "pictDrumStick",
      "pictDuckCall",
      "pictEdgeOfCymbal",
      "pictEmptyTrap",
      "pictFingerCymbals",
      "pictFlexatone",
      "pictFootballRatchet",
      "pictGlassHarmonica",
      "pictGlassHarp",
      "pictGlassPlateChimes",
      "pictGlassTubeChimes",
      "pictGlsp",
      "pictGlspSmithBrindle",
      "pictGobletDrum",
      "pictGong",
      "pictGongWithButton",
      "pictGuiro",
      "pictGumHardDown",
      "pictGumHardLeft",
      "pictGumHardRight",
      "pictGumHardUp",
      "pictGumMediumDown",
      "pictGumMediumLeft",
      "pictGumMediumRight",
      "pictGumMediumUp",
      "pictGumSoftDown",
      "pictGumSoftLeft",
      "pictGumSoftRight",
      "pictGumSoftUp",
      "pictHalfOpen1",
      "pictHalfOpen2",
      "pictHandbell",
      "pictHiHat",
      "pictHiHatOnStand",
      "pictJawHarp",
      "pictJingleBells",
      "pictKlaxonHorn",
      "pictLeftHandCircle",
      "pictLionsRoar",
      "pictLithophone",
      "pictLogDrum",
      "pictLotusFlute",
      "pictMar",
      "pictMarSmithBrindle",
      "pictMaraca",
      "pictMaracas",
      "pictMegaphone",
      "pictMetalPlateChimes",
      "pictMetalTubeChimes",
      "pictMusicalSaw",
      "pictNormalPosition",
      "pictOnRim",
      "pictOpen",
      "pictOpenRimShot",
      "pictPistolShot",
      "pictPoliceWhistle",
      "pictQuijada",
      "pictRainstick",
      "pictRatchet",
      "pictRecoReco",
      "pictRightHandSquare",
      "pictRim1",
      "pictRim2",
      "pictRim3",
      "pictRimShotOnStem",
      "pictSandpaperBlocks",
      "pictScrapeAroundRim",
      "pictScrapeAroundRimClockwise",
      "pictScrapeCenterToEdge",
      "pictScrapeEdgeToCenter",
      "pictShellBells",
      "pictShellChimes",
      "pictSiren",
      "pictSistrum",
      "pictSizzleCymbal",
      "pictSleighBell",
      "pictSlideBrushOnGong",
      "pictSlideWhistle",
      "pictSlitDrum",
      "pictSnareDrum",
      "pictSnareDrumMilitary",
      "pictSnareDrumSnaresOff",
      "pictSteelDrums",
      "pictStickShot",
      "pictSuperball",
      "pictSuspendedCymbal",
      "pictSwishStem",
      "pictTabla",
      "pictTamTam",
      "pictTamTamWithBeater",
      "pictTambourine",
      "pictTempleBlocks",
      "pictTenorDrum",
      "pictThundersheet",
      "pictTimbales",
      "pictTimpani",
      "pictTomTom",
      "pictTomTomChinese",
      "pictTomTomIndoAmerican",
      "pictTomTomJapanese",
      "pictTriangle",
      "pictTubaphone",
      "pictTubularBells",
      "pictTurnLeftStem",
      "pictTurnRightLeftStem",
      "pictTurnRightStem",
      "pictVib",
      "pictVibMotorOff",
      "pictVibSmithBrindle",
      "pictVibraslap",
      "pictVietnameseHat",
      "pictWhip",
      "pictWindChimesGlass",
      "pictWindMachine",
      "pictWindWhistle",
      "pictWoodBlock",
      "pictWoundHardDown",
      "pictWoundHardLeft",
      "pictWoundHardRight",
      "pictWoundHardUp",
      "pictWoundSoftDown",
      "pictWoundSoftLeft",
      "pictWoundSoftRight",
      "pictWoundSoftUp",
      "pictXyl",
      "pictXylBass",
      "pictXylSmithBrindle",
      "pictXylTenor",
      "pictXylTenorTrough",
      "pictXylTrough",
      "pluckedBuzzPizzicato",
      "pluckedDamp",
      "pluckedDampAll",
      "pluckedDampOnStem",
      "pluckedFingernailFlick",
      "pluckedLeftHandPizzicato",
      "pluckedPlectrum",
      "pluckedSnapPizzicatoAbove",
      "pluckedSnapPizzicatoBelow",
      "pluckedWithFingernails",
      "quindicesima",
      "quindicesimaAlta",
      "quindicesimaBassa",
      "quindicesimaBassaMb",
      "repeat1Bar",
      "repeat2Bars",
      "repeat4Bars",
      "repeatBarLowerDot",
      "repeatBarSlash",
      "repeatBarUpperDot",
      "repeatDot",
      "repeatDots",
      "repeatLeft",
      "repeatRight",
      "repeatRightLeft",
      "rest1024th",
      "rest128th",
      "rest16th",
      "rest256th",
      "rest32nd",
      "rest512th",
      "rest64th",
      "rest8th",
      "restDoubleWhole",
      "restDoubleWholeLegerLine",
      "restHBar",
      "restHBarLeft",
      "restHBarMiddle",
      "restHBarRight",
      "restHalf",
      "restHalfLegerLine",
      "restLonga",
      "restMaxima",
      "restQuarter",
      "restQuarterOld",
      "restQuarterZ",
      "restWhole",
      "restWholeLegerLine",
      "reversedBrace",
      "reversedBracketBottom",
      "reversedBracketTop",
      "rightRepeatSmall",
      "schaefferClef",
      "schaefferFClefToGClef",
      "schaefferGClefToFClef",
      "schaefferPreviousClef",
      "segno",
      "segnoSerpent1",
      "segnoSerpent2",
      "semipitchedPercussionClef1",
      "semipitchedPercussionClef2",
      "smnFlat",
      "smnFlatWhite",
      "smnHistoryDoubleFlat",
      "smnHistoryDoubleSharp",
      "smnHistoryFlat",
      "smnHistorySharp",
      "smnNatural",
      "smnSharp",
      "smnSharpDown",
      "smnSharpWhite",
      "smnSharpWhiteDown",
      "splitBarDivider",
      "staff1Line",
      "staff1LineNarrow",
      "staff1LineWide",
      "staff2Lines",
      "staff2LinesNarrow",
      "staff2LinesWide",
      "staff3Lines",
      "staff3LinesNarrow",
      "staff3LinesWide",
      "staff4Lines",
      "staff4LinesNarrow",
      "staff4LinesWide",
      "staff5Lines",
      "staff5LinesNarrow",
      "staff5LinesWide",
      "staff6Lines",
      "staff6LinesNarrow",
      "staff6LinesWide",
      "staffDivideArrowDown",
      "staffDivideArrowUp",
      "staffDivideArrowUpDown",
      "staffPosLower1",
      "staffPosLower2",
      "staffPosLower3",
      "staffPosLower4",
      "staffPosLower5",
      "staffPosLower6",
      "staffPosLower7",
      "staffPosLower8",
      "staffPosRaise1",
      "staffPosRaise2",
      "staffPosRaise3",
      "staffPosRaise4",
      "staffPosRaise5",
      "staffPosRaise6",
      "staffPosRaise7",
      "staffPosRaise8",
      "stem",
      "stemBowOnBridge",
      "stemBowOnTailpiece",
      "stemBuzzRoll",
      "stemDamp",
      "stemHarpStringNoise",
      "stemMultiphonicsBlack",
      "stemMultiphonicsBlackWhite",
      "stemMultiphonicsWhite",
      "stemPendereckiTremolo",
      "stemRimShot",
      "stemSprechgesang",
      "stemSulPonticello",
      "stemSussurando",
      "stemSwished",
      "stemVibratoPulse",
      "stockhausenTremolo",
      "stringsBowBehindBridge",
      "stringsBowBehindBridgeFourStrings",
      "stringsBowBehindBridgeOneString",
      "stringsBowBehindBridgeThreeStrings",
      "stringsBowBehindBridgeTwoStrings",
      "stringsBowOnBridge",
      "stringsBowOnTailpiece",
      "stringsChangeBowDirection",
      "stringsDownBow",
      "stringsDownBowTurned",
      "stringsFouette",
      "stringsHalfHarmonic",
      "stringsHarmonic",
      "stringsJeteAbove",
      "stringsJeteBelow",
      "stringsMuteOff",
      "stringsMuteOn",
      "stringsOverpressureDownBow",
      "stringsOverpressureNoDirection",
      "stringsOverpressurePossibileDownBow",
      "stringsOverpressurePossibileUpBow",
      "stringsOverpressureUpBow",
      "stringsThumbPosition",
      "stringsThumbPositionTurned",
      "stringsUpBow",
      "stringsUpBowTurned",
      "stringsVibratoPulse",
      "systemDivider",
      "systemDividerExtraLong",
      "systemDividerLong",
      "textAugmentationDot",
      "textBlackNoteFrac16thLongStem",
      "textBlackNoteFrac16thShortStem",
      "textBlackNoteFrac32ndLongStem",
      "textBlackNoteFrac8thLongStem",
      "textBlackNoteFrac8thShortStem",
      "textBlackNoteLongStem",
      "textBlackNoteShortStem",
      "textCont16thBeamLongStem",
      "textCont16thBeamShortStem",
      "textCont32ndBeamLongStem",
      "textCont8thBeamLongStem",
      "textCont8thBeamShortStem",
      "textTie",
      "textTuplet3LongStem",
      "textTuplet3ShortStem",
      "textTupletBracketEndLongStem",
      "textTupletBracketEndShortStem",
      "textTupletBracketStartLongStem",
      "textTupletBracketStartShortStem",
      "timeSig0",
      "timeSig0Reversed",
      "timeSig0Turned",
      "timeSig1",
      "timeSig1Reversed",
      "timeSig1Turned",
      "timeSig2",
      "timeSig2Reversed",
      "timeSig2Turned",
      "timeSig3",
      "timeSig3Reversed",
      "timeSig3Turned",
      "timeSig4",
      "timeSig4Reversed",
      "timeSig4Turned",
      "timeSig5",
      "timeSig5Reversed",
      "timeSig5Turned",
      "timeSig6",
      "timeSig6Reversed",
      "timeSig6Turned",
      "timeSig7",
      "timeSig7Reversed",
      "timeSig7Turned",
      "timeSig8",
      "timeSig8Reversed",
      "timeSig8Turned",
      "timeSig9",
      "timeSig9Reversed",
      "timeSig9Turned",
      "timeSigBracketLeft",
      "timeSigBracketLeftSmall",
      "timeSigBracketRight",
      "timeSigBracketRightSmall",
      "timeSigCombDenominator",
      "timeSigCombNumerator",
      "timeSigComma",
      "timeSigCommon",
      "timeSigCommonReversed",
      "timeSigCommonTurned",
      "timeSigCut2",
      "timeSigCut3",
      "timeSigCutCommon",
      "timeSigCutCommonReversed",
      "timeSigCutCommonTurned",
      "timeSigEquals",
      "timeSigFractionHalf",
      "timeSigFractionOneThird",
      "timeSigFractionQuarter",
      "timeSigFractionThreeQuarters",
      "timeSigFractionTwoThirds",
      "timeSigFractionalSlash",
      "timeSigMinus",
      "timeSigMultiply",
      "timeSigOpenPenderecki",
      "timeSigParensLeft",
      "timeSigParensLeftSmall",
      "timeSigParensRight",
      "timeSigParensRightSmall",
      "timeSigPlus",
      "timeSigPlusSmall",
      "timeSigSlash",
      "timeSigX",
      "tremolo1",
      "tremolo2",
      "tremolo3",
      "tremolo4",
      "tremolo5",
      "tremoloDivisiDots2",
      "tremoloDivisiDots3",
      "tremoloDivisiDots4",
      "tremoloDivisiDots6",
      "tremoloFingered1",
      "tremoloFingered2",
      "tremoloFingered3",
      "tremoloFingered4",
      "tremoloFingered5",
      "tripleTongueAbove",
      "tripleTongueBelow",
      "tuplet0",
      "tuplet1",
      "tuplet2",
      "tuplet3",
      "tuplet4",
      "tuplet5",
      "tuplet6",
      "tuplet7",
      "tuplet8",
      "tuplet9",
      "tupletColon",
      "unmeasuredTremolo",
      "unmeasuredTremoloSimple",
      "unpitchedPercussionClef1",
      "unpitchedPercussionClef2",
      "ventiduesima",
      "ventiduesimaAlta",
      "ventiduesimaBassa",
      "ventiduesimaBassaMb",
      "vocalFingerClickStockhausen",
      "vocalHalbGesungen",
      "vocalMouthClosed",
      "vocalMouthOpen",
      "vocalMouthPursed",
      "vocalMouthSlightlyOpen",
      "vocalMouthWideOpen",
      "vocalNasalVoice",
      "vocalSprechgesang",
      "vocalTongueClickStockhausen",
      "vocalTongueFingerClickStockhausen",
      "vocalsSussurando",
      "wiggleArpeggiatoDown",
      "wiggleArpeggiatoDownArrow",
      "wiggleArpeggiatoDownSwash",
      "wiggleArpeggiatoUp",
      "wiggleArpeggiatoUpArrow",
      "wiggleArpeggiatoUpSwash",
      "wiggleCircular",
      "wiggleCircularConstant",
      "wiggleCircularConstantFlipped",
      "wiggleCircularConstantFlippedLarge",
      "wiggleCircularConstantLarge",
      "wiggleCircularEnd",
      "wiggleCircularLarge",
      "wiggleCircularLarger",
      "wiggleCircularLargerStill",
      "wiggleCircularLargest",
      "wiggleCircularSmall",
      "wiggleCircularStart",
      "wiggleGlissando",
      "wiggleGlissandoGroup1",
      "wiggleGlissandoGroup2",
      "wiggleGlissandoGroup3",
      "wiggleRandom1",
      "wiggleRandom2",
      "wiggleRandom3",
      "wiggleRandom4",
      "wiggleSawtooth",
      "wiggleSawtoothNarrow",
      "wiggleSawtoothWide",
      "wiggleSquareWave",
      "wiggleSquareWaveNarrow",
      "wiggleSquareWaveWide",
      "wiggleTrill",
      "wiggleTrillFast",
      "wiggleTrillFaster",
      "wiggleTrillFasterStill",
      "wiggleTrillFastest",
      "wiggleTrillSlow",
      "wiggleTrillSlower",
      "wiggleTrillSlowerStill",
      "wiggleTrillSlowest",
      "wiggleVIbratoLargestSlower",
      "wiggleVIbratoMediumSlower",
      "wiggleVibrato",
      "wiggleVibratoLargeFast",
      "wiggleVibratoLargeFaster",
      "wiggleVibratoLargeFasterStill",
      "wiggleVibratoLargeFastest",
      "wiggleVibratoLargeSlow",
      "wiggleVibratoLargeSlower",
      "wiggleVibratoLargeSlowest",
      "wiggleVibratoLargestFast",
      "wiggleVibratoLargestFaster",
      "wiggleVibratoLargestFasterStill",
      "wiggleVibratoLargestFastest",
      "wiggleVibratoLargestSlow",
      "wiggleVibratoLargestSlowest",
      "wiggleVibratoMediumFast",
      "wiggleVibratoMediumFaster",
      "wiggleVibratoMediumFasterStill",
      "wiggleVibratoMediumFastest",
      "wiggleVibratoMediumSlow",
      "wiggleVibratoMediumSlowest",
      "wiggleVibratoSmallFast",
      "wiggleVibratoSmallFaster",
      "wiggleVibratoSmallFasterStill",
      "wiggleVibratoSmallFastest",
      "wiggleVibratoSmallSlow",
      "wiggleVibratoSmallSlower",
      "wiggleVibratoSmallSlowest",
      "wiggleVibratoSmallestFast",
      "wiggleVibratoSmallestFaster",
      "wiggleVibratoSmallestFasterStill",
      "wiggleVibratoSmallestFastest",
      "wiggleVibratoSmallestSlow",
      "wiggleVibratoSmallestSlower",
      "wiggleVibratoSmallestSlowest",
      "wiggleVibratoStart",
      "wiggleVibratoWide",
      "wiggleWavy",
      "wiggleWavyNarrow",
      "wiggleWavyWide",
      "windClosedHole",
      "windFlatEmbouchure",
      "windHalfClosedHole1",
      "windHalfClosedHole2",
      "windHalfClosedHole3",
      "windLessRelaxedEmbouchure",
      "windLessTightEmbouchure",
      "windMouthpiecePop",
      "windMultiphonicsBlackStem",
      "windMultiphonicsBlackWhiteStem",
      "windMultiphonicsWhiteStem",
      "windOpenHole",
      "windReedPositionIn",
      "windReedPositionNormal",
      "windReedPositionOut",
      "windRelaxedEmbouchure",
      "windRimOnly",
      "windSharpEmbouchure",
      "windStrongAirPressure",
      "windThreeQuartersClosedHole",
      "windTightEmbouchure",
      "windTrillKey",
      "windVeryTightEmbouchure",
      "windWeakAirPressure",
      // SMuFL standard symbol names }}}

//    EXTENSIONS
//    SMuFL stylistic alternates which we need to access directly

      "noteheadDoubleWholeAlt",           // double whole with double side bars
      "4stringTabClefSerif",              // TAB clef in script style
      "6stringTabClefSerif",              // TAB clef in script style
      "cClefFrench",
      "cClefFrench20C",
      "fClefFrench",
      "fClef19thCentury",
      "braceSmall",
      "braceLarge",
      "braceLarger",

//    MuseScore-local symbols, precomposed symbols to mimic some Emmentaler glyphs

      "ornamentPrallMordent",       // ornamentPrecompTrillWithMordent ?
      "ornamentUpPrall",            // ornamentPrecompSlideTrillDAnglebert ?
      "ornamentUpMordent",          // ornamentPrecompSlideTrillBach ?
      "ornamentPrallDown",          // ornamentPrecompTrillLowerSuffix ?
//      "ornamentDownPrall",        // -> SymId::ornamentPrecompMordentUpperPrefix },
      "ornamentDownMordent",        // ornamentPrecompTurnTrillBach ?
      "ornamentPrallUp",            // ornamentPrecompTrillSuffixDandrieu ?
      "ornamentLinePrall",          // ornamentPRecompAppoggTrill ?

//    additional symbols

      "noteLongaUp",
      "noteLongaDown",
      "noteLongaSquareUp",
      "noteLongaSquareDown",
      "space"
      } };

const std::array<const char*, int(SymId::lastSym)+1> Sym::symUserNames = { {
      QT_TRANSLATE_NOOP("symUserNames", "No symbol"),

      // DO NOT edit the SMuFL standard symbol user names (see below) manually!
      // They are generated from fonttools/smufl2sym.{bat,sh} and then
      // copied into this file! Edit fonttools/smufl2sym-in-trans.json
      // to make more strings translatable!

      // SMuFL standard symbol user names {{{
      "4-string tab clef",
      "6-string tab clef",
      QT_TRANSLATE_NOOP("symUserNames", "11 large diesis down, 3° down [46 EDO]"),
      QT_TRANSLATE_NOOP("symUserNames", "11 large diesis up, (11L), (sharp less 11M), 3° up [46 EDO]"),
      QT_TRANSLATE_NOOP("symUserNames", "11 medium diesis down, 1°[17 31] 2°46 down, 1/4-tone down"),
      QT_TRANSLATE_NOOP("symUserNames", "11 medium diesis up, (11M), 1°[17 31] 2°46 up, 1/4-tone up"),
      "11:19 large diesis down",
      "11:19 large diesis up, (11:19L, apotome less 11:19M)",
      "11:19 medium diesis down",
      "11:19 medium diesis up, (11:19M, 11M plus 19s)",
      "11:49 comma down",
      "11:49 comma up, (11:49C, 11M less 49C)",
      "143 comma down",
      "143 comma up, (143C, 13L less 11M)",
      "17 comma down",
      "17 comma up, (17C)",
      "17 kleisma down",
      "17 kleisma up, (17k)",
      "19 comma down",
      "19 comma up, (19C)",
      "19 schisma down",
      "19 schisma up, (19s)",
      "23 comma down, 2° down [96 EDO], 1/8-tone down",
      "23 comma up, (23C), 2° up [96 EDO], 1/8-tone up",
      "23 small diesis down",
      "23 small diesis up, (23S)",
      QT_TRANSLATE_NOOP("symUserNames", "25 small diesis down, 2° down [53 EDO]"),
      QT_TRANSLATE_NOOP("symUserNames", "25 small diesis up, (25S, ~5:13S, ~37S, 5C plus 5C), 2° up [53 EDO]"),
      QT_TRANSLATE_NOOP("symUserNames", "35 large diesis down, 2° down [50 EDO], 5/18-tone down"),
      QT_TRANSLATE_NOOP("symUserNames", "35 large diesis up, (35L, ~13L, ~125L, sharp less 35M), 2°50 up"),
      QT_TRANSLATE_NOOP("symUserNames", "35 medium diesis down, 1°[50] 2°[27] down, 2/9-tone down"),
      QT_TRANSLATE_NOOP("symUserNames", "35 medium diesis up, (35M, ~13M, ~125M, 5C plus 7C), 2/9-tone up"),
      "49 large diesis down",
      "49 large diesis up, (49L, ~31L, apotome less 49M)",
      "49 medium diesis down",
      "49 medium diesis up, (49M, ~31M, 7C plus 7C)",
      "49 small diesis down",
      "49 small diesis up, (49S, ~31S)",
      "55 comma down, 3° down [96 EDO], 3/16-tone down",
      "55 comma up, (55C, 11M less 5C), 3°up [96 EDO], 3/16-tone up",
      QT_TRANSLATE_NOOP("symUserNames", "5 comma down, 1° down [22 27 29 34 41 46 53 96 EDOs], 1/12-tone down"),
      QT_TRANSLATE_NOOP("symUserNames", "5 comma up, (5C), 1° up [22 27 29 34 41 46 53 96 EDOs], 1/12-tone up"),
      "5:11 small diesis down",
      "5:11 small diesis up, (5:11S, ~7:13S, ~11:17S, 5:7k plus 7:11C)",
      "5:13 large diesis down",
      "5:13 large diesis up, (5:13L, ~37L, apotome less 5:13M)",
      "5:13 medium diesis down",
      "5:13 medium diesis up, (5:13M, ~37M, 5C plus 13C)",
      "5:19 comma down, 1/20-tone down",
      "5:19 comma up, (5:19C, 5C plus 19s), 1/20-tone up",
      "5:23 small diesis down, 2° down [60 EDO], 1/5-tone down",
      "5:23 small diesis up, (5:23S, 5C plus 23C), 2° up [60 EDO], 1/5-tone up",
      "5:49 medium diesis down",
      "5:49 medium diesis up, (5:49M, half apotome)",
      QT_TRANSLATE_NOOP("symUserNames", "5:7 kleisma down"),
      QT_TRANSLATE_NOOP("symUserNames", "5:7 kleisma up, (5:7k, ~11:13k, 7C less 5C)"),
      QT_TRANSLATE_NOOP("symUserNames", "7 comma down, 1° down [43 EDO], 2° down [72 EDO], 1/6-tone down"),
      QT_TRANSLATE_NOOP("symUserNames", "7 comma up, (7C), 1° up [43 EDO], 2° up [72 EDO], 1/6-tone up"),
      "7:11 comma down, 1° down [60 EDO], 1/10-tone down",
      "7:11 comma up, (7:11C, ~13:17S, ~29S, 11L less 7C), 1° up [60 EDO]",
      "7:11 kleisma down",
      "7:11 kleisma up, (7:11k, ~29k)",
      "7:19 comma down",
      "7:19 comma up, (7:19C, 7C less 19s)",
      "Acute, 5 schisma up (5s), 2 cents up",
      "Double flat, (2 apotomes down)[almost all EDOs], whole-tone down",
      "Double flat 11:49C-up",
      "Double flat 143C-up",
      "Double flat 17C-up",
      "Double flat 17k-up",
      "Double flat 19C-up",
      "Double flat 19s-up",
      "Double flat 23C-up, 14° down [96 EDO], 7/8-tone down",
      "Double flat 23S-up",
      "Double flat 25S-up, 8°down [53 EDO]",
      "Double flat 49S-up",
      "Double flat 55C-up, 13° down [96 EDO], 13/16-tone down",
      "Double flat 5C-up, 5°[22 29] 7°[34 41] 9°53 down, 11/12 tone down",
      "Double flat 5:11S-up",
      "Double flat 5:19C-up, 19/20-tone down",
      "Double flat 5:23S-up, 8° down [60 EDO], 4/5-tone down",
      "Double flat 5:7k-up",
      "Double flat 7C-up, 5° down [43 EDO], 10° down [72 EDO], 5/6-tone down",
      "Double flat 7:11C-up, 9° down [60 EDO], 9/10-tone down",
      "Double flat 7:11k-up",
      "Double flat 7:19C-up",
      "Double sharp, (2 apotomes up)[almost all EDOs], whole-tone up",
      "Double sharp 11:49C-down",
      "Double sharp 143C-down",
      "Double sharp 17C-down",
      "Double sharp 17k-down",
      "Double sharp 19C-down",
      "Double sharp 19s-down",
      "Double sharp 23C-down, 14°up [96 EDO], 7/8-tone up",
      "Double sharp 23S-down",
      "Double sharp 25S-down, 8°up [53 EDO]",
      "Double sharp 49S-down",
      "Double sharp 55C-down, 13° up [96 EDO], 13/16-tone up",
      "Double sharp 5C-down, 5°[22 29] 7°[34 41] 9°53 up, 11/12 tone up",
      "Double sharp 5:11S-down",
      "Double sharp 5:19C-down, 19/20-tone up",
      "Double sharp 5:23S-down, 8° up [60 EDO], 4/5-tone up",
      "Double sharp 5:7k-down",
      "Double sharp 7C-down, 5°[43] 10°[72] up, 5/6-tone up",
      "Double sharp 7:11C-down, 9° up [60 EDO], 9/10-tone up",
      "Double sharp 7:11k-down",
      "Double sharp 7:19C-down",
      QT_TRANSLATE_NOOP("symUserNames", "Flat, (apotome down)[almost all EDOs], 1/2-tone down"),
      "Flat 11L-down, 8° up [46 EDO]",
      "Flat 11M-down, 3° down [17 31 EDOs], 7° down [46 EDO], 3/4-tone down",
      "Flat 11:19L-down",
      "Flat 11:19M-down",
      "Flat 11:49C-down",
      "Flat 11:49C-up",
      "Flat 143C-down",
      "Flat 143C-up",
      "Flat 17C-down",
      "Flat 17C-up",
      "Flat 17k-down",
      "Flat 17k-up",
      "Flat 19C-down",
      "Flat 19C-up",
      "Flat 19s-down",
      "Flat 19s-up",
      "Flat 23C-down, 10° down [96 EDO], 5/8-tone down",
      "Flat 23C-up, 6° down [96 EDO], 3/8-tone down",
      "Flat 23S-down",
      "Flat 23S-up",
      "Flat 25S-down, 7° down [53 EDO]",
      QT_TRANSLATE_NOOP("symUserNames", "Flat 25S-up, 3° down [53 EDO]"),
      "Flat 35L-down, 5° down [50 EDO]",
      "Flat 35M-down, 4° down [50 EDO], 6° down [27 EDO], 13/18-tone down",
      "Flat 49L-down",
      "Flat 49M-down",
      "Flat 49S-down",
      "Flat 49S-up",
      "Flat 55C-down, 11° down [96 EDO], 11/16-tone down",
      "Flat 55C-up, 5° down [96 EDO], 5/16-tone down",
      "Flat 5C-down, 4°[22 29] 5°[27 34 41] 6°[39 46 53] down, 7/12-tone down",
      QT_TRANSLATE_NOOP("symUserNames", "Flat 5C-up, 2°[22,29] 3°[34 41] 4°[46 53 60] down, 5/12-tone down"),
      "Flat 5:11S-down",
      "Flat 5:11S-up",
      "Flat 5:13L-down",
      "Flat 5:13M-down",
      "Flat 5:19C-down, 11/20-tone down",
      "Flat 5:19C-up, 9/20-tone down",
      "Flat 5:23S-down, 7° down [60 EDO], 7/10-tone down",
      "Flat 5:23S-up, 3° down [60 EDO], 3/10-tone down",
      "Flat 5:49M-down",
      "Flat 5:7k-down",
      QT_TRANSLATE_NOOP("symUserNames", "Flat 5:7k-up"),
      "Flat 7C-down, 4° down [43 EDO], 8° down [72 EDO], 2/3-tone down",
      QT_TRANSLATE_NOOP("symUserNames", "Flat 7C-up, 2° down [43 EDO], 4° down [72 EDO], 1/3-tone down"),
      "Flat 7:11C-down, 6° down [60 EDO], 3/5- tone down",
      "Flat 7:11C-up, 4° down [60 EDO], 2/5-tone down",
      "Flat 7:11k-down",
      "Flat 7:11k-up",
      "Flat 7:19C-down",
      "Flat 7:19C-up",
      "Grave, 5 schisma down, 2 cents down",
      "Shaft down, (natural for use with only diacritics down)",
      "Shaft up, (natural for use with only diacritics up)",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp, (apotome up)[almost all EDOs], 1/2-tone up"),
      "Sharp 11L-up, 8° up [46 EDO]",
      "Sharp 11M-up, 3° up [17 31 EDOs], 7° up [46 EDO], 3/4-tone up",
      "Sharp 11:19L-up",
      "Sharp 11:19M-up",
      "Sharp 11:49C-down",
      "Sharp 11:49C-up",
      "Sharp 143C-down",
      "Sharp 143C-up",
      "Sharp 17C-down",
      "Sharp 17C-up",
      "Sharp 17k-down",
      "Sharp 17k-up",
      "Sharp 19C-down",
      "Sharp 19C-up",
      "Sharp 19s-down",
      "Sharp 19s-up",
      "Sharp 23C-down, 6° up [96 EDO], 3/8-tone up",
      "Sharp 23C-up, 10° up [96 EDO], 5/8-tone up",
      "Sharp 23S-down",
      "Sharp 23S-up",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp 25S-down, 3° up [53 EDO]"),
      "Sharp 25S-up, 7° up [53 EDO]",
      "Sharp 35L-up, 5° up [50 EDO]",
      "Sharp 35M-up, 4° up [50 EDO], 6° up [27 EDO], 13/18-tone up",
      "Sharp 49L-up",
      "Sharp 49M-up",
      "Sharp 49S-down",
      "Sharp 49S-up",
      "Sharp 55C-down, 5° up [96 EDO], 5/16-tone up",
      "Sharp 55C-up, 11° up [96 EDO], 11/16-tone up",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp 5C-down, 2°[22 29] 3°[34 41] 4°[46 53 60] up, 5/12-tone up"),
      "Sharp 5C-up, 4°[22 29] 5°[27 34 41] 6°[39 46 53] up, 7/12-tone up",
      "Sharp 5:11S-down",
      "Sharp 5:11S-up",
      "Sharp 5:13L-up",
      "Sharp 5:13M-up",
      "Sharp 5:19C-down, 9/20-tone up",
      "Sharp 5:19C-up, 11/20-tone up",
      "Sharp 5:23S-down, 3° up [60 EDO], 3/10-tone up",
      "Sharp 5:23S-up, 7° up [60 EDO], 7/10-tone up",
      "Sharp 5:49M-up, (one and a half apotomes)",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp 5:7k-down"),
      "Sharp 5:7k-up",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp 7C-down, 2° up [43 EDO], 4° up [72 EDO], 1/3-tone up"),
      "Sharp 7C-up, 4° up [43 EDO], 8° up [72 EDO], 2/3-tone up",
      "Sharp 7:11C-down, 4° up [60 EDO], 2/5-tone up",
      "Sharp 7:11C-up, 6° up [60 EDO], 3/5- tone up",
      "Sharp 7:11k-down",
      "Sharp 7:11k-up",
      "Sharp 7:19C-down",
      "Sharp 7:19C-up",
      "Unused",
      "Unused",
      "Unused",
      "Unused",
      QT_TRANSLATE_NOOP("symUserNames", "Combining accordion coupler dot"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining left hand, 2 ranks, empty"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining left hand, 3 ranks, empty (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining right hand, 3 ranks, empty"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining right hand, 4 ranks, empty"),
      QT_TRANSLATE_NOOP("symUserNames", "Diatonic accordion clef"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, 16' stop (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, 8' stop + 16' stop (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, 8' stop (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, full master (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, master + 16' stop (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 2 ranks, master (round)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 3 ranks, 2' stop + 8' stop (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 3 ranks, 2' stop (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 3 ranks, 8' stop (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 3 ranks, double 8' stop (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Left hand, 3 ranks, 2' stop + double 8' stop (tutti) (square)"),
      QT_TRANSLATE_NOOP("symUserNames", "Pull"),
      QT_TRANSLATE_NOOP("symUserNames", "Push"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 8' stop + upper tremolo 8' stop + 16' stop (accordion)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, lower tremolo 8' stop + 8' stop + upper tremolo 8' stop (authentic musette)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 8' stop + 16' stop (bandoneón)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 16' stop (bassoon)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 8' stop (clarinet)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, lower tremolo 8' stop + 8' stop + upper tremolo 8' stop + 16' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + lower tremolo 8' stop + 8' stop + upper tremolo 8' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + lower tremolo 8' stop + 8' stop + upper tremolo 8' stop + 16' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + 8' stop + 16' stop (harmonium)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + 8' stop + upper tremolo 8' stop (imitation musette)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, lower tremolo 8' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + lower tremolo 8' stop + upper tremolo 8' stop + 16' stop (master)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + 8' stop (oboe)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + 16' stop (organ)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop (piccolo)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, lower tremolo 8' stop + upper tremolo 8' stop + 16' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 4' stop + lower tremolo 8' stop + upper tremolo 8' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, lower tremolo 8' stop + upper tremolo 8' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, upper tremolo 8' stop"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 3 ranks, 8' stop + upper tremolo 8' stop (violin)"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, alto"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, bass/alto"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, master"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, soft bass"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, soft tenor"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, soprano"),
      QT_TRANSLATE_NOOP("symUserNames", "Right hand, 4 ranks, tenor"),
      QT_TRANSLATE_NOOP("symUserNames", "Ricochet (2 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Ricochet (3 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Ricochet (4 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Ricochet (5 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Ricochet (6 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining ricochet for stem (2 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining ricochet for stem (3 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining ricochet for stem (4 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining ricochet for stem (5 tones)"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining ricochet for stem (6 tones)"),
      "1-comma flat",
      "1-comma sharp",
      "2-comma flat",
      "2-comma sharp",
      "3-comma flat",
      "3-comma sharp",
      "4-comma flat",
      "5-comma sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Arrow down (lower by one quarter-tone)"),
      QT_TRANSLATE_NOOP("symUserNames", "Arrow up (raise by one quarter-tone)"),
      QT_TRANSLATE_NOOP("symUserNames", "Bakiye (flat)"),
      "Bakiye (sharp)",
      "Accidental bracket, left",
      "Accidental bracket, right",
      QT_TRANSLATE_NOOP("symUserNames", "Büyük mücenneb (flat)"),
      QT_TRANSLATE_NOOP("symUserNames", "Büyük mücenneb (sharp)"),
      "Combining close curly brace",
      QT_TRANSLATE_NOOP("symUserNames", "Combining lower by one 17-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining lower by one 19-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining lower by one 23-limit comma or 29-limit comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining lower by one 31-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining lower by one 53-limit comma"),
      "Combining open curly brace",
      QT_TRANSLATE_NOOP("symUserNames", "Combining raise by one 17-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining raise by one 19-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining raise by one 23-limit comma or 29-limit comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining raise by one 31-limit schisma"),
      QT_TRANSLATE_NOOP("symUserNames", "Combining raise by one 53-limit comma"),
      "Syntonic/Didymus comma (80:81) down (Bosanquet)",
      "Syntonic/Didymus comma (80:81) up (Bosanquet)",
      QT_TRANSLATE_NOOP("symUserNames", "Double flat"),
      "Arabic double flat",
      QT_TRANSLATE_NOOP("symUserNames", "Double flat equal tempered semitone"),
      QT_TRANSLATE_NOOP("symUserNames", "Double flat lowered by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Double flat raised by one syntonic comma"),
      "Reversed double flat",
      QT_TRANSLATE_NOOP("symUserNames", "Double flat lowered by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double flat raised by three syntonic commas"),
      "Turned double flat",
      QT_TRANSLATE_NOOP("symUserNames", "Double flat lowered by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double flat raised by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp"),
      "Arabic double sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp equal tempered semitone"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp lowered by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp raised by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp lowered by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp raised by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp lowered by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Double sharp raised by two syntonic commas"),
      "Enharmonically reinterpret accidental almost equal to",
      "Enharmonically reinterpret accidental equals",
      "Enharmonically reinterpret accidental tilde",
      "Filled reversed flat and flat",
      "Filled reversed flat and flat with arrow down",
      "Filled reversed flat and flat with arrow up",
      "Filled reversed flat with arrow down",
      "Filled reversed flat with arrow up",
      QT_TRANSLATE_NOOP("symUserNames", "Five-quarter-tones flat"),
      QT_TRANSLATE_NOOP("symUserNames", "Five-quarter-tones sharp"),
      QT_TRANSLATE_NOOP("symUserNames", "Flat"),
      "Arabic half-tone flat",
      QT_TRANSLATE_NOOP("symUserNames", "Flat equal tempered semitone"),
      "Lowered flat (Stockhausen)",
      QT_TRANSLATE_NOOP("symUserNames", "Flat lowered by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Flat raised by one syntonic comma"),
      "Raised flat (Stockhausen)",
      "Repeated flat, note on line (Stockhausen)",
      "Repeated flat, note in space (Stockhausen)",
      QT_TRANSLATE_NOOP("symUserNames", "Flat lowered by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Flat raised by three syntonic commas"),
      "Turned flat",
      QT_TRANSLATE_NOOP("symUserNames", "Flat lowered by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Flat raised by two syntonic commas"),
      "Half sharp with arrow down",
      "Half sharp with arrow up",
      "Thirteen (raise by 65:64)",
      "Inverted 13 (lower by 65:64)",
      "Down arrow (lower by 33:32)",
      "Inverted seven (raise by 36:35)",
      "Minus (lower by 81:80)",
      "Plus (raise by 81:80)",
      "Seven (lower by 36:35)",
      "Up arrow (raise by 33:32)",
      "Koma (flat)",
      "Koma (sharp)",
      QT_TRANSLATE_NOOP("symUserNames", "Koron (quarter tone flat)"),
      "Küçük mücenneb (flat)",
      QT_TRANSLATE_NOOP("symUserNames", "Küçük mücenneb (sharp)"),
      "Large double sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Lower by one septimal comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Lower by one tridecimal quartertone"),
      QT_TRANSLATE_NOOP("symUserNames", "Lower by one undecimal quartertone"),
      QT_TRANSLATE_NOOP("symUserNames", "Lower by two septimal commas"),
      "Lowered (Stockhausen)",
      "Narrow reversed flat(quarter-tone flat)",
      "Narrow reversed flat and flat(three-quarter-tones flat)",
      QT_TRANSLATE_NOOP("symUserNames", "Natural"),
      "Arabic natural",
      QT_TRANSLATE_NOOP("symUserNames", "Natural equal tempered semitone"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural flat"),
      "Lowered natural (Stockhausen)",
      QT_TRANSLATE_NOOP("symUserNames", "Natural lowered by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural raised by one syntonic comma"),
      "Raised natural (Stockhausen)",
      "Reversed natural",
      QT_TRANSLATE_NOOP("symUserNames", "Natural sharp"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural lowered by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural raised by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural lowered by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Natural raised by two syntonic commas"),
      "One and a half sharps with arrow down",
      "One and a half sharps with arrow up",
      "One-quarter-tone flat (Ferneyhough)",
      "One-quarter-tone flat (Stockhausen)",
      "One-quarter-tone sharp (Ferneyhough)",
      "One-quarter-tone sharp (Stockhausen)",
      "One-third-tone flat (Ferneyhough)",
      "One-third-tone sharp (Ferneyhough)",
      "Accidental parenthesis, left",
      "Accidental parenthesis, right",
      QT_TRANSLATE_NOOP("symUserNames", "Lower by one equal tempered quarter-tone"),
      QT_TRANSLATE_NOOP("symUserNames", "Raise by one equal tempered quarter tone"),
      "Quarter-tone flat",
      "Arabic quarter-tone flat",
      QT_TRANSLATE_NOOP("symUserNames", "Quarter-tone flat"),
      "Filled reversed flat (quarter-tone flat)",
      QT_TRANSLATE_NOOP("symUserNames", "Quarter-tone flat"),
      "Quarter tone flat (Penderecki)",
      QT_TRANSLATE_NOOP("symUserNames", "Reversed flat (quarter-tone flat) (Stein)"),
      "Quarter-tone flat (van Blankenburg)",
      "Quarter-tone sharp",
      "Arabic quarter-tone sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Quarter-tone sharp"),
      "Quarter tone sharp (Bussotti)",
      QT_TRANSLATE_NOOP("symUserNames", "Quarter-tone sharp"),
      QT_TRANSLATE_NOOP("symUserNames", "Half sharp (quarter-tone sharp) (Stein)"),
      "Quarter tone sharp with wiggly tail",
      QT_TRANSLATE_NOOP("symUserNames", "Raise by one septimal comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Raise by one tridecimal quartertone"),
      QT_TRANSLATE_NOOP("symUserNames", "Raise by one undecimal quartertone"),
      QT_TRANSLATE_NOOP("symUserNames", "Raise by two septimal commas"),
      "Raised (Stockhausen)",
      "Reversed flat and flat with arrow down",
      "Reversed flat and flat with arrow up",
      "Reversed flat with arrow down",
      "Reversed flat with arrow up",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp"),
      "Arabic half-tone sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp equal tempered semitone"),
      "Lowered sharp (Stockhausen)",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp lowered by one syntonic comma"),
      QT_TRANSLATE_NOOP("symUserNames", "Sharp raised by one syntonic comma"),
      "One or three quarter tones sharp",
      "Raised sharp (Stockhausen)",
      "Repeated sharp, note on line (Stockhausen)",
      "Repeated sharp, note in space (Stockhausen)",
      "Reversed sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Sharp sharp"),
      QT_TRANSLATE_NOOP("symUserNames", "Sharp lowered by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Sharp raised by three syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Sharp lowered by two syntonic commas"),
      QT_TRANSLATE_NOOP("symUserNames", "Sharp raised by two syntonic commas"),
      "1/12 tone low",
      "1/12 tone high",
      "1/4 tone low",
      "1/4 tone high",
      "1/6 tone low",
      "1/6 tone high",
      QT_TRANSLATE_NOOP("symUserNames", "Sori (quarter tone sharp)"),
      "Byzantine-style Bakiye flat (Tavener)",
      "Byzantine-style Büyük mücenneb sharp (Tavener)",
      "Arabic three-quarter-tones flat",
      QT_TRANSLATE_NOOP("symUserNames", "Three-quarter-tones flat"),
      QT_TRANSLATE_NOOP("symUserNames", "Three-quarter-tones flat"),
      "Three-quarter-tones flat (Couper)",
      "Three-quarter-tones flat (Grisey)",
      "Three-quarter-tones flat (Tartini)",
      QT_TRANSLATE_NOOP("symUserNames", "Reversed flat and flat (three-quarter-tones flat) (Zimmermann)"),
      "Arabic three-quarter-tones sharp",
      QT_TRANSLATE_NOOP("symUserNames", "Three-quarter-tones sharp"),
      QT_TRANSLATE_NOOP("symUserNames", "Three-quarter-tones sharp"),
      "Three quarter tones sharp (Bussotti)",
      QT_TRANSLATE_NOOP("symUserNames", "One and a half sharps (three-quarter-tones sharp) (Stein)"),
      "Three-quarter-tones sharp (Stockhausen)",
      QT_TRANSLATE_NOOP("symUserNames", "Triple flat"),
      QT_TRANSLATE_NOOP("symUserNames", "Triple sharp"),
      "Two-third-tones flat (Ferneyhough)",
      "Two-third-tones sharp (Ferneyhough)",
      "Wilson minus (5 comma down)",
      "Wilson plus (5 comma up)",
      QT_TRANSLATE_NOOP("symUserNames", "5/6 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "5/6 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "11/12 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "11/12 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/12 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/12 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/6 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/6 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/4 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/4 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/3 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/3 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "5/12 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "5/12 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/2 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "1/2 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "7/12 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "7/12 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "2/3 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "2/3 tone sharp (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "3/4 tone flat (Wyschnegradsky)"),
      QT_TRANSLATE_NOOP("symUserNames", "3/4 tone sharp (Wyschnegradsky)"),
      "One-third-tone sharp (Xenakis)",
      "Two-third-tones sharp (Xenakis)",
      "Choralmelodie (Berg)",
      "End of stimme",
      "Hauptrhythmus (Berg)",
      "Hauptstimme",
      "Inversion 1",
      "Nebenstimme",
      "Start of stimme",
      "Theme",
      "Theme 1",
      "Inversion of theme",
      "Retrograde of theme",
      "Retrograde inversion of theme",
      "Arpeggiato down",
      "Arpeggiato up",
      "Black arrow down (S)",
      "Black arrow down-left (SW)",
      "Black arrow down-right (SE)",
      "Black arrow left (W)",
      "Black arrow right (E)",
      "Black arrow up (N)",
      "Black arrow up-left (NW)",
      "Black arrow up-right (NE)",
      "Open arrow down (S)",
      "Open arrow down-left (SW)",
      "Open arrow down-right (SE)",
      "Open arrow left (W)",
      "Open arrow right (E)",
      "Open arrow up (N)",
      "Open arrow up-left (NW)",
      "Open arrow up-right (NE)",
      "White arrow down (S)",
      "White arrow down-left (SW)",
      "White arrow down-right (SE)",
      "White arrow left (W)",
      "White arrow right (E)",
      "White arrow up (N)",
      "White arrow up-left (NW)",
      "White arrow up-right (NE)",
      "Black arrowhead down (S)",
      "Black arrowhead down-left (SW)",
      "Black arrowhead down-right (SE)",
      "Black arrowhead left (W)",
      "Black arrowhead right (E)",
      "Black arrowhead up (N)",
      "Black arrowhead up-left (NW)",
      "Black arrowhead up-right (NE)",
      "Open arrowhead down (S)",
      "Open arrowhead down-left (SW)",
      "Open arrowhead down-right (SE)",
      "Open arrowhead left (W)",
      "Open arrowhead right (E)",
      "Open arrowhead up (N)",
      "Open arrowhead up-left (NW)",
      "Open arrowhead up-right (NE)",
      "White arrowhead down (S)",
      "White arrowhead down-left (SW)",
      "White arrowhead down-right (SE)",
      "White arrowhead left (W)",
      "White arrowhead right (E)",
      "White arrowhead up (N)",
      "White arrowhead up-left (NW)",
      "White arrowhead up-right (NE)",
      QT_TRANSLATE_NOOP("symUserNames", "Accent above"),
      QT_TRANSLATE_NOOP("symUserNames", "Accent below"),
      QT_TRANSLATE_NOOP("symUserNames", "Accent-staccato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Accent-staccato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Laissez vibrer (l.v.) above"),
      QT_TRANSLATE_NOOP("symUserNames", "Laissez vibrer (l.v.) below"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato-staccato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato-staccato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato-tenuto above"),
      QT_TRANSLATE_NOOP("symUserNames", "Marcato-tenuto below"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent above"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent below"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-staccato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-staccato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-tenuto above"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-tenuto below"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-tenuto-staccato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Soft accent-tenuto-staccato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo above"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo below"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo stroke above"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo stroke below"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo wedge above"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccatissimo wedge below"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Staccato below"),
      QT_TRANSLATE_NOOP("symUserNames", "Stress above"),
      QT_TRANSLATE_NOOP("symUserNames", "Stress below"),
      QT_TRANSLATE_NOOP("symUserNames", "Tenuto above"),
      QT_TRANSLATE_NOOP("symUserNames", "Tenuto-accent above"),
      QT_TRANSLATE_NOOP("symUserNames", "Tenuto-accent below"),
      QT_TRANSLATE_NOOP("symUserNames", "Tenuto below"),
      QT_TRANSLATE_NOOP("symUserNames", "Louré (tenuto-staccato) above"),
      QT_TRANSLATE_NOOP("symUserNames", "Louré (tenuto-staccato) below"),
      QT_TRANSLATE_NOOP("symUserNames", "Unstress above"),
      QT_TRANSLATE_NOOP("symUserNames", "Unstress below"),
      "Augmentation dot",
      QT_TRANSLATE_NOOP("symUserNames", "Dashed barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Dotted barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Double barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Final barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Heavy barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Heavy double barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Reverse final barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Short barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Single barline"),
      QT_TRANSLATE_NOOP("symUserNames", "Tick barline"),
      "Accel./rit. beam 1 (widest)",
      "Accel./rit. beam 10",
      "Accel./rit. beam 11",
      "Accel./rit. beam 12",
      "Accel./rit. beam 13",
      "Accel./rit. beam 14",
      "Accel./rit. beam 15 (narrowest)",
      "Accel./rit. beam 2",
      "Accel./rit. beam 3",
      "Accel./rit. beam 4",
      "Accel./rit. beam 5",
      "Accel./rit. beam 6",
      "Accel./rit. beam 7",
      "Accel./rit. beam 8",
      "Accel./rit. beam 9",
      "Accel./rit. beam terminating line",
      "Brace",
      "Bracket",
      "Bracket bottom",
      "Bracket top",
      "Bend",
      "Doit, long",
      "Doit, medium",
      "Doit, short",
      "Lip fall, long",
      "Lip fall, medium",
      "Lip fall, short",
      "Rough fall, long",
      "Rough fall, medium",
      "Rough fall, short",
      "Smooth fall, long",
      "Smooth fall, medium",
      "Smooth fall, short",
      "Flip",
      "Harmon mute, stem in",
      "Harmon mute, stem extended, left",
      "Harmon mute, stem extended, right",
      "Harmon mute, stem out",
      "Jazz turn",
      "Lift, long",
      "Lift, medium",
      "Lift, short",
      "Smooth lift, long",
      "Smooth lift, medium",
      "Smooth lift, short",
      QT_TRANSLATE_NOOP("symUserNames", "Muted (closed)"),
      "Half-muted (half-closed)",
      QT_TRANSLATE_NOOP("symUserNames", "Open"),
      "Plop",
      "Scoop",
      "Smear",
      "Valve trill",
      QT_TRANSLATE_NOOP("symUserNames", "Breath mark (comma)"),
      QT_TRANSLATE_NOOP("symUserNames", "Breath mark (Salzedo)"),
      QT_TRANSLATE_NOOP("symUserNames", "Breath mark (tick-like)"),
      QT_TRANSLATE_NOOP("symUserNames", "Breath mark (upbow-like)"),
      "Bridge clef",
      "Buzz roll",
      QT_TRANSLATE_NOOP("symUserNames", "C clef"),
      "C clef ottava bassa",
      "C clef, arrow down",
      "C clef, arrow up",
      "C clef change",
      "Combining C clef",
      "Reversed C clef",
      "C clef (19th century)",
      QT_TRANSLATE_NOOP("symUserNames", "Caesura"),
      QT_TRANSLATE_NOOP("symUserNames", "Curved caesura"),
      QT_TRANSLATE_NOOP("symUserNames", "Short caesura"),
      QT_TRANSLATE_NOOP("symUserNames", "Thick caesura"),
      "Accentus above",
      "Accentus below",
      "Punctum auctum, ascending",
      "Punctum auctum, descending",
      "Augmentum (mora)",
      QT_TRANSLATE_NOOP("symUserNames", "Caesura"),
      "Plainchant C clef",
      "Circulus above",
      "Circulus below",
      "Connecting line, ascending 2nd",
      "Connecting line, ascending 3rd",
      "Connecting line, ascending 4th",
      "Connecting line, ascending 5th",
      "Connecting line, ascending 6th",
      "Plainchant custos, stem down, high position",
      "Plainchant custos, stem down, highest position",
      "Plainchant custos, stem down, middle position",
      "Plainchant custos, stem up, low position",
      "Plainchant custos, stem up, lowest position",
      "Plainchant custos, stem up, middle position",
      "Punctum deminutum, lower",
      "Punctum deminutum, upper",
      "Divisio finalis",
      "Divisio maior",
      "Divisio maxima",
      "Divisio minima",
      "Entry line, ascending 2nd",
      "Entry line, ascending 3rd",
      "Entry line, ascending 4th",
      "Entry line, ascending 5th",
      "Entry line, ascending 6th",
      "Episema",
      "Plainchant F clef",
      "Ictus above",
      "Ictus below",
      "Ligated stroke, descending 2nd",
      "Ligated stroke, descending 3rd",
      "Ligated stroke, descending 4th",
      "Ligated stroke, descending 5th",
      "Oriscus ascending",
      "Oriscus descending",
      "Oriscus liquescens",
      "Podatus, lower",
      "Podatus, upper",
      "Punctum",
      "Punctum cavum",
      "Punctum deminutum",
      "Punctum inclinatum",
      "Punctum inclinatum auctum",
      "Punctum inclinatum deminutum",
      "Punctum linea",
      "Punctum linea cavum",
      "Punctum virga",
      "Punctum virga, reversed",
      "Quilisma",
      "Semicirculus above",
      "Semicirculus below",
      "Plainchant staff",
      "Plainchant staff (narrow)",
      "Plainchant staff (wide)",
      "Strophicus",
      "Strophicus auctus",
      "Strophicus liquescens, 2nd",
      "Strophicus liquescens, 3rd",
      "Strophicus liquescens, 4th",
      "Strophicus liquescens, 5th",
      "Virgula",
      "15 for clefs",
      "8 for clefs",
      "Combining clef change",
      QT_TRANSLATE_NOOP("symUserNames", "Coda"),
      QT_TRANSLATE_NOOP("symUserNames", "Square coda"),
      "Beat 2, compound time",
      "Beat 2, simple time",
      "Beat 3, compound time",
      "Beat 3, simple time",
      "Beat 4, compound time",
      "Beat 4, simple time",
      "Left-hand beat or cue",
      "Right-hand beat or cue",
      "Strong beat or cue",
      "Unconducted/free passages",
      "Weak beat or cue",
      "Begin beam",
      "Begin phrase",
      "Begin slur",
      "Begin tie",
      "End beam",
      "End phrase",
      "End slur",
      "End tie",
      "Double flat",
      "Double sharp",
      "Flat",
      "Natural",
      "Sharp",
      "Triple flat",
      "Triple sharp",
      "Slash for altered bass note",
      "Augmented",
      "Double-height left bracket",
      "Double-height right bracket",
      "Slash for chord symbols arranged diagonally",
      "Diminished",
      "Half-diminished",
      "Major seventh",
      "Minor",
      "Double-height left parenthesis",
      "Triple-height left parenthesis",
      "Double-height right parenthesis",
      "Triple-height right parenthesis",
      "Curlew (Britten)",
      "Da capo",
      "Dal segno",
      "Daseian excellentes 1",
      "Daseian excellentes 2",
      "Daseian excellentes 3",
      "Daseian excellentes 4",
      "Daseian finales 1",
      "Daseian finales 2",
      "Daseian finales 3",
      "Daseian finales 4",
      "Daseian graves 1",
      "Daseian graves 2",
      "Daseian graves 3",
      "Daseian graves 4",
      "Daseian residua 1",
      "Daseian residua 2",
      "Daseian superiores 1",
      "Daseian superiores 2",
      "Daseian superiores 3",
      "Daseian superiores 4",
      "Double lateral roll (Stevens)",
      "Double-tongue above",
      "Double-tongue below",
      "Colon separator for combined dynamics",
      "Hyphen separator for combined dynamics",
      "Slash separator for combined dynamics",
      "Space separator for combined dynamics",
      "Crescendo",
      "Diminuendo",
      "ff",
      "fff",
      "ffff",
      "fffff",
      "ffffff",
      QT_TRANSLATE_NOOP("symUserNames", "Forte"),
      "Forte-piano",
      "Forzando",
      "Left bracket (for hairpins)",
      "Right bracket (for hairpins)",
      "Left parenthesis (for hairpins)",
      "Right parenthesis (for hairpins)",
      "mf",
      "mp",
      "Messa di voce",
      QT_TRANSLATE_NOOP("symUserNames", "Mezzo"),
      QT_TRANSLATE_NOOP("symUserNames", "Niente"),
      "Niente (for hairpins)",
      "pf",
      "pp",
      "ppp",
      "pppp",
      "ppppp",
      "pppppp",
      QT_TRANSLATE_NOOP("symUserNames", "Piano"),
      QT_TRANSLATE_NOOP("symUserNames", "Rinforzando"),
      "Rinforzando 1",
      "Rinforzando 2",
      QT_TRANSLATE_NOOP("symUserNames", "Sforzando"),
      "Sforzando 1",
      "Sforzando-pianissimo",
      "Sforzando-piano",
      "Sforzato",
      "Sforzatissimo",
      "Sforzato-piano",
      QT_TRANSLATE_NOOP("symUserNames", "Z"),
      "Eight channels (7.1 surround)",
      "Five channels",
      "Four channels",
      "One channel (mono)",
      "Seven channels",
      "Six channels (5.1 surround)",
      "Three channels (frontal)",
      "Three channels (surround)",
      "Two channels (stereo)",
      "Audio in",
      "Mono audio setup",
      "Audio out",
      "Stereo audio setup",
      "Camera",
      "Data in",
      "Data out",
      "Disc",
      "Download",
      "Eject",
      "Fast-forward",
      "Headphones",
      "Headset",
      "Line in",
      "Line out",
      "Loop",
      "Loudspeaker",
      "MIDI controller 0%",
      "MIDI controller 100%",
      "MIDI controller 20%",
      "MIDI controller 40%",
      "MIDI controller 60%",
      "MIDI controller 80%",
      "MIDI in",
      "MIDI out",
      "Microphone",
      "Mute microphone",
      "Unmute microphone",
      "Mixing console",
      "Monitor",
      "Mute",
      "Pause",
      "Play",
      "Power on/off",
      "Projector",
      "Replay",
      "Rewind",
      "Shuffle",
      "Skip backwards",
      "Skip forwards",
      "Stop",
      "Tape",
      "USB connection",
      "Unmute",
      "Upload",
      "Video camera",
      "Video in",
      "Video out",
      "Combining volume fader",
      "Combining volume fader thumb",
      "Volume level 0%",
      "Volume level 100%",
      "Volume level 20%",
      "Volume level 40%",
      "Volume level 60%",
      "Volume level 80%",
      QT_TRANSLATE_NOOP("symUserNames", "F clef"),
      "F clef quindicesima alta",
      "F clef quindicesima bassa",
      "F clef ottava alta",
      "F clef ottava bassa",
      "F clef, arrow down",
      "F clef, arrow up",
      "F clef change",
      "Reversed F clef",
      "Turned F clef",
      QT_TRANSLATE_NOOP("symUserNames", "Fermata above"),
      QT_TRANSLATE_NOOP("symUserNames", "Fermata below"),
      QT_TRANSLATE_NOOP("symUserNames", "Long fermata above"),
      QT_TRANSLATE_NOOP("symUserNames", "Long fermata below"),
      QT_TRANSLATE_NOOP("symUserNames", "Long fermata (Henze) above"),
      QT_TRANSLATE_NOOP("symUserNames", "Long fermata (Henze) below"),
      QT_TRANSLATE_NOOP("symUserNames", "Short fermata above"),
      QT_TRANSLATE_NOOP("symUserNames", "Short fermata below"),
      QT_TRANSLATE_NOOP("symUserNames", "Short fermata (Henze) above"),
      QT_TRANSLATE_NOOP("symUserNames", "Short fermata (Henze) below"),
      QT_TRANSLATE_NOOP("symUserNames", "Very long fermata above"),
      QT_TRANSLATE_NOOP("symUserNames", "Very long fermata below"),
      QT_TRANSLATE_NOOP("symUserNames", "Very short fermata above"),
      QT_TRANSLATE_NOOP("symUserNames", "Very short fermata below"),
      "Figured bass 0",
      "Figured bass 1",
      "Figured bass 2",
      "Figured bass 2 raised by half-step",
      "Figured bass 3",
      "Figured bass 4",
      "Figured bass 4 raised by half-step",
      "Figured bass 5",
      "Figured bass 5 raised by half-step",
      "Figured bass 5 raised by half-step 2",
      "Figured bass diminished 5",
      "Figured bass 6",
      "Figured bass 6 raised by half-step",
      "Figured bass 6 raised by half-step 2",
      "Figured bass 7",
      "Figured bass 7 diminished",
      "Figured bass 7 raised by half-step",
      "Figured bass 7 raised by a half-step 2",
      "Figured bass 8",
      "Figured bass 9",
      "Figured bass 9 raised by half-step",
      "Figured bass [",
      "Figured bass ]",
      "Combining lower",
      "Combining raise",
      "Figured bass double flat",
      "Figured bass double sharp",
      "Figured bass flat",
      "Figured bass natural",
      "Figured bass (",
      "Figured bass )",
      "Figured bass +",
      "Figured bass sharp",
      "Fingering 0 (open string)",
      "Fingering 0 italic (open string)",
      "Fingering 1 (thumb)",
      "Fingering 1 italic (thumb)",
      "Fingering 2 (index finger)",
      "Fingering 2 italic (index finger)",
      "Fingering 3 (middle finger)",
      "Fingering 3 italic (middle finger)",
      "Fingering 4 (ring finger)",
      "Fingering 4 italic (ring finger)",
      "Fingering 5 (little finger)",
      "Fingering 5 italic (little finger)",
      "Fingering 6",
      "Fingering 6 italic",
      "Fingering 7",
      "Fingering 7 italic",
      "Fingering 8",
      "Fingering 8 italic",
      "Fingering 9",
      "Fingering 9 italic",
      "Fingering a (anular; right-hand ring finger for guitar)",
      "Fingering c (right-hand little finger for guitar)",
      "Fingering e (right-hand little finger for guitar)",
      "Fingering i (indicio; right-hand index finger for guitar)",
      "Fingering left bracket",
      "Fingering left bracket italic",
      "Fingering left parenthesis",
      "Fingering left parenthesis italic",
      "Fingering m (medio; right-hand middle finger for guitar)",
      "Multiple notes played by thumb or single finger",
      "Fingering o (right-hand little finger for guitar)",
      "Fingering p (pulgar; right-hand thumb for guitar)",
      "Fingering right bracket",
      "Fingering right bracket italic",
      "Fingering right parenthesis",
      "Fingering right parenthesis italic",
      "Fingering middle dot separator",
      "Fingering white middle dot separator",
      "Fingering forward slash separator",
      "Finger substitution above",
      "Finger substitution below",
      "Finger substitution dash",
      "Fingering t (right-hand thumb for guitar)",
      "Fingering T (left-hand thumb for guitar)",
      "Fingering x (right-hand little finger for guitar)",
      "Combining flag 8 (1024th) below",
      "Combining flag 8 (1024th) above",
      "Combining flag 5 (128th) below",
      "Combining flag 5 (128th) above",
      "Combining flag 2 (16th) below",
      "Combining flag 2 (16th) above",
      "Combining flag 6 (256th) below",
      "Combining flag 6 (256th) above",
      "Combining flag 3 (32nd) below",
      "Combining flag 3 (32nd) above",
      "Combining flag 7 (512th) below",
      "Combining flag 7 (512th) above",
      "Combining flag 4 (64th) below",
      "Combining flag 4 (64th) above",
      "Combining flag 1 (8th) below",
      "Combining flag 1 (8th) above",
      "Internal combining flag below",
      "Internal combining flag above",
      "3-string fretboard",
      "3-string fretboard at nut",
      "4-string fretboard",
      "4-string fretboard at nut",
      "5-string fretboard",
      "5-string fretboard at nut",
      "6-string fretboard",
      "6-string fretboard at nut",
      "Fingered fret (filled circle)",
      "Open string (O)",
      "String not played (X)",
      "Function theory angle bracket left",
      "Function theory angle bracket right",
      "Function theory bracket left",
      "Function theory bracket right",
      "Function theory dominant of dominant",
      "Function theory minor dominant",
      "Function theory major dominant",
      "Function theory 8",
      "Function theory F",
      "Function theory 5",
      "Function theory 4",
      "Function theory g",
      "Function theory G",
      "Function theory greater than",
      "Function theory i",
      "Function theory I",
      "Function theory k",
      "Function theory K",
      "Function theory l",
      "Function theory L",
      "Function theory less than",
      "Function theory m",
      "Function theory M",
      "Function theory minus",
      "Function theory n",
      "Function theory N",
      "Function theory superscript N",
      "Function theory 9",
      "Function theory 1",
      "Function theory p",
      "Function theory P",
      "Function theory parenthesis left",
      "Function theory parenthesis right",
      "Function theory prefix plus",
      "Function theory r",
      "Function theory repetition 1",
      "Function theory repetition 2",
      "Function theory prefix ring",
      "Function theory minor subdominant",
      "Function theory minor subdominant of subdominant",
      "Function theory major subdominant of subdominant",
      "Function theory major subdominant",
      "Function theory 7",
      "Function theory 6",
      "Function theory double dominant seventh",
      "Function theory minor tonic",
      "Function theory tonic",
      "Function theory 3",
      "Function theory 2",
      "Function theory v",
      "Function theory V",
      "Function theory 0",
      QT_TRANSLATE_NOOP("symUserNames", "G clef"),
      "G clef quindicesima alta",
      "G clef quindicesima bassa",
      "G clef ottava alta",
      "G clef ottava bassa",
      "G clef ottava bassa with C clef",
      "G clef ottava bassa (old style)",
      "G clef, optionally ottava bassa",
      "G clef, arrow down",
      "G clef, arrow up",
      "G clef change",
      "Combining G clef, number above",
      "Combining G clef, number below",
      "Reversed G clef",
      "Turned G clef",
      "Glissando down",
      "Glissando up",
      "Slashed grace note stem down",
      "Slashed grace note stem up",
      "Grace note stem down",
      "Grace note stem up",
      "Slash for stem down grace note",
      "Slash for stem up grace note",
      "Full barré",
      "Half barré",
      "Closed wah/volume pedal",
      QT_TRANSLATE_NOOP("symUserNames", "Fade in"),
      QT_TRANSLATE_NOOP("symUserNames", "Fade out"),
      "Golpe (tapping the pick guard)",
      "Half-open wah/volume pedal",
      "Left-hand tapping",
      "Open wah/volume pedal",
      "Right-hand tapping",
      "Guitar shake",
      "String number 0",
      "String number 1",
      "String number 2",
      "String number 3",
      "String number 4",
      "String number 5",
      "String number 6",
      "String number 7",
      "String number 8",
      "String number 9",
      "Strum direction down",
      "Strum direction up",
      "Guitar vibrato bar dip",
      "Guitar vibrato bar scoop",
      "Vibrato wiggle segment",
      QT_TRANSLATE_NOOP("symUserNames", "Volume swell"),
      "Wide vibrato wiggle segment",
      "Belltree",
      "Damp 3",
      "Echo",
      "Echo 2",
      "Gyro",
      "Hand martellato",
      "Mallet, bell on table",
      "Mallet, bell suspended",
      "Mallet lift",
      "Martellato",
      "Martellato lift",
      "Muted martellato",
      "Pluck lift",
      "Swing",
      "Swing down",
      "Swing up",
      "Table pair of handbells",
      "Table single handbell",
      "Metal rod pictogram",
      "Harp pedal centered (natural)",
      "Harp pedal divider",
      "Harp pedal lowered (sharp)",
      "Harp pedal raised (flat)",
      "Ascending aeolian chords (Salzedo)",
      "Descending aeolian chords (Salzedo)",
      "Damp above (Salzedo)",
      "Damp below (Salzedo)",
      "Damp with both hands (Salzedo)",
      "Damp only low strings (Salzedo)",
      "Fluidic sounds, left hand (Salzedo)",
      "Fluidic sounds, right hand (Salzedo)",
      "Isolated sounds (Salzedo)",
      "Metallic sounds (Salzedo)",
      "Metallic sounds, one string (Salzedo)",
      "Muffle totally (Salzedo)",
      "Oboic flux (Salzedo)",
      "Play at upper end of strings (Salzedo)",
      "Slide with suppleness (Salzedo)",
      "Snare drum effect (Salzedo)",
      "Tam-tam sounds (Salzedo)",
      "Thunder effect (Salzedo)",
      "Timpanic sounds (Salzedo)",
      "Whistling sounds (Salzedo)",
      "Combining string noise for stem",
      "Tuning key pictogram",
      "Retune strings for glissando",
      "Use handle of tuning key pictogram",
      "Use shank of tuning key pictogram",
      "Indian drum clef",
      "Back-chug",
      "Back-flap",
      "Back-riff",
      "Back-rip",
      "Ball-change",
      "Ball-dig",
      "Brush-backward",
      "Brush-forward",
      "Chug",
      "Clap",
      "Double-snap",
      "Double-wing",
      "Draw-step",
      "Draw-tap",
      "Flam",
      "Flap",
      "Flap-step",
      "Flat",
      "Flea-hop",
      "Flea-tap",
      "Grace-tap",
      "Grace-tap-change",
      "Grace-tap-hop",
      "Grace-tap-stamp",
      "Heel",
      "Heel-change",
      "Heel-click",
      "Heel-drop",
      "Heel-step",
      "Heel-tap",
      "Hop",
      "Jump-apart",
      "Jump-together",
      "Knee-inward",
      "Knee-outward",
      "Leap",
      "Leap-flat-foot",
      "Leap-heel-click",
      "Left-catch",
      "Left-cross",
      "Left-foot",
      "Left-toe-strike",
      "Left-turn",
      "Over-the-top",
      "Over-the-top-tap",
      "Pull",
      "Push",
      "Riff",
      "Riffle",
      "Right-catch",
      "Right-cross",
      "Right-foot",
      "Right-toe-strike",
      "Right-turn",
      "Rip",
      "Ripple",
      "Scrape",
      "Scuff",
      "Scuffle",
      "Shuffle",
      "Slam",
      "Slap",
      "Slide-step",
      "Slide-tap",
      "Snap",
      "Stamp",
      "Stamp-stamp",
      "Step",
      "Step-stamp",
      "Stomp",
      "Stomp-brush",
      "Tap",
      "Toe",
      "Toe-click",
      "Toe-drop",
      "Toe-step",
      "Toe-tap",
      "Trench",
      "Wing",
      "Wing-change",
      "Zank",
      "Zink",
      "Clavichord bebung, 2 finger movements (above)",
      "Clavichord bebung, 2 finger movements (below)",
      "Clavichord bebung, 3 finger movements (above)",
      "Clavichord bebung, 3 finger movements (below)",
      "Clavichord bebung, 4 finger movements (above)",
      "Clavichord bebung, 4 finger movements (below)",
      "Left pedal pictogram",
      "Middle pedal pictogram",
      "Pedal d",
      "Pedal dot",
      "Pedal e",
      "Half-pedal mark",
      "Half pedal mark 1",
      "Half pedal mark 2",
      "Pedal heel 1",
      "Pedal heel 2",
      "Pedal heel 3 (Davis)",
      "Pedal heel to toe",
      "Pedal heel or toe",
      "Pedal hook end",
      "Pedal hook start",
      "Pedal hyphen",
      "Pedal P",
      "Left parenthesis for pedal marking",
      "Right parenthesis for pedal marking",
      "Pedal mark",
      "Pedal S",
      "Sostenuto pedal mark",
      "Pedal toe 1",
      "Pedal toe 2",
      "Pedal toe to heel",
      "Pedal up mark",
      "Pedal up notch",
      "Pedal up special",
      "Play with left hand",
      "Play with left hand (end)",
      "Play with right hand",
      "Play with right hand (end)",
      "Pluck strings inside piano (Maderna)",
      "Right pedal pictogram",
      "Kievan flat",
      "Kievan sharp",
      "Kievan augmentation dot",
      "Kievan C clef (tse-fa-ut)",
      "Kievan ending symbol",
      "Kievan eighth note, stem down",
      "Kievan eighth note, stem up",
      "Kievan beam",
      "Kievan half note (on staff line)",
      "Kievan half note (in staff space)",
      "Kievan quarter note, stem down",
      "Kievan quarter note, stem up",
      "Kievan reciting note",
      "Kievan whole note",
      "Kievan final whole note",
      "Do hand sign",
      "Fa hand sign",
      "La hand sign",
      "Mi hand sign",
      "Re hand sign",
      "So hand sign",
      "Ti hand sign",
      "Left repeat sign within bar",
      "Leger line",
      "Leger line (narrow)",
      "Leger line (wide)",
      "Lute tablature end repeat barline",
      "Lute tablature final barline",
      "Lute tablature start repeat barline",
      "16th note (semiquaver) duration sign",
      "32nd note (demisemiquaver) duration sign",
      "Eighth note (quaver) duration sign",
      "Double whole note (breve) duration sign",
      "Half note (minim) duration sign",
      "Quarter note (crotchet) duration sign",
      "Whole note (semibreve) duration sign",
      QT_TRANSLATE_NOOP("symUserNames", "Right-hand fingering, first finger"),
      QT_TRANSLATE_NOOP("symUserNames", "Right-hand fingering, second finger"),
      QT_TRANSLATE_NOOP("symUserNames", "Right-hand fingering, third finger"),
      QT_TRANSLATE_NOOP("symUserNames", "Right-hand fingering, thumb"),
      "10th course (diapason)",
      "Seventh course (diapason)",
      "Eighth course (diapason)",
      "Ninth course (diapason)",
      "Appoggiatura from above",
      "Appoggiatura from below",
      "Open string (a)",
      "First fret (b)",
      "Second fret (c)",
      "Third fret (d)",
      "Fourth fret (e)",
      "Fifth fret (f)",
      "Sixth fret (g)",
      "Seventh fret (h)",
      "Eighth fret (i)",
      "Ninth fret (k)",
      "10th fret (l)",
      "11th fret (m)",
      "12th fret (n)",
      "Inverted mordent",
      "Mordent with lower auxiliary",
      "Mordent with upper auxiliary",
      "5th course, 1st fret (a)",
      "6th course, 1st fret (A)",
      "4th course, 1st fret (b)",
      "6th course, 2nd fret (B)",
      "3rd course, 1st fret (c)",
      "6th course, 3rd fret (C)",
      "2nd course, 1st fret (d)",
      "6th course, 4th fret (D)",
      "1st course, 1st fret (e)",
      "6th course, 5th fret (E)",
      "5th course, 2nd fret (f)",
      "6th course, 6th fret (F)",
      "4th course, 2nd fret (g)",
      "6th course, 7th fret (G)",
      "3rd course, 2nd fret (h)",
      "6th course, 8th fret (H)",
      "2nd course, 2nd fret (i)",
      "6th course, 9th fret (I)",
      "1st course, 2nd fret (k)",
      "6th course, 10th fret (K)",
      "5th course, 3rd fret (l)",
      "6th course, 11th fret (L)",
      "4th course, 3rd fret (m)",
      "6th course, 12th fret (M)",
      "3rd course, 3rd fret (n)",
      "6th course, 13th fret (N)",
      "2nd course, 3rd fret (o)",
      "1st course, 3rd fret (p)",
      "5th course, 4th fret (q)",
      "4th course, 4th fret (r)",
      "3rd course, 4th fret (s)",
      "2nd course, 4th fret (t)",
      "1st course, 4th fret (v)",
      "5th course, 5th fret (x)",
      "4th course, 5th fret (y)",
      "3rd course, 5th fret (z)",
      "C sol fa ut clef",
      "F fa ut clef",
      "Open string (0)",
      "First fret (1)",
      "Second fret (2)",
      "Third fret (3)",
      "Fourth fret (4)",
      "Fifth fret (5)",
      "Sixth fret (6)",
      "Seventh fret (7)",
      "Eighth fret (8)",
      "Ninth fret (9)",
      "Hold finger in place",
      "Hold note",
      "Release finger",
      "Fast tempo indication (de Mudarra)",
      "Neither fast nor slow tempo indication (de Mudarra)",
      "Slow tempo indication (de Mudarra)",
      "Somewhat fast tempo indication (de Narvaez)",
      "Very slow indication (de Narvaez)",
      "Triple time indication",
      "Single-finger tremolo or mordent",
      "Vibrato (verre cassé)",
      "Lute tablature staff, 6 courses",
      "Lute tablature staff, 6 courses (narrow)",
      "Lute tablature staff, 6 courses (wide)",
      QT_TRANSLATE_NOOP("symUserNames", "Elision"),
      QT_TRANSLATE_NOOP("symUserNames", "Narrow elision"),
      QT_TRANSLATE_NOOP("symUserNames", "Wide elision"),
      "Baseline hyphen",
      "Non-breaking baseline hyphen",
      "Text repeats",
      "Flat, hard b (mi)",
      "Flat, soft b (fa)",
      "Flat with dot",
      "G clef (Corpus Monodicum)",
      "Liquescence",
      "Liquescent ascending (Corpus Monodicum)",
      "Liquescent descending (Corpus Monodicum)",
      "Natural",
      "Natural with interrupted cross",
      "Oriscus (Corpus Monodicum)",
      "Plica",
      "Punctum (Corpus Monodicum)",
      "Quilisma (Corpus Monodicum)",
      "Croix",
      "Strophicus (Corpus Monodicum)",
      "Alteration sign",
      "Black mensural brevis",
      "Black mensural void brevis",
      "Black mensural dragma",
      "Black mensural longa",
      "Black mensural maxima",
      "Black mensural minima",
      "Black mensural void minima",
      "Black mensural semibrevis",
      "Black mensural semibrevis caudata",
      "Black mensural oblique semibrevis",
      "Black mensural void semibrevis",
      "Black mensural semiminima",
      "Mensural C clef",
      "Petrucci C clef, high position",
      "Petrucci C clef, highest position",
      "Petrucci C clef, low position",
      "Petrucci C clef, lowest position",
      "Petrucci C clef, middle position",
      "Coloration end, round",
      "Coloration end, square",
      "Coloration start, round",
      "Coloration start, square",
      "Combining stem diagonal",
      "Combining stem down",
      "Combining stem with extended flag down",
      "Combining stem with flared flag down",
      "Combining stem with fusa flag down",
      "Combining stem with flag left down",
      "Combining stem with flag right down",
      "Combining stem with semiminima flag down",
      "Combining stem up",
      "Combining stem with extended flag up",
      "Combining stem with flared flag up",
      "Combining stem with fusa flag up",
      "Combining stem with flag left up",
      "Combining stem with flag right up",
      "Combining stem with semiminima flag up",
      "Checkmark custos",
      "Mensural custos down",
      "Turn-like custos",
      "Mensural custos up",
      "Mensural F clef",
      "Petrucci F clef",
      "Mensural G clef",
      "Petrucci G clef",
      "Modus imperfectum, vertical",
      "Modus perfectum, vertical",
      "Longa/brevis notehead, black",
      "Longa/brevis notehead, black and void",
      "Longa/brevis notehead, void",
      "Longa/brevis notehead, white",
      "Maxima notehead, black",
      "Maxima notehead, black and void",
      "Maxima notehead, void",
      "Maxima notehead, white",
      "Minima notehead, white",
      "Semibrevis notehead, black",
      "Semibrevis notehead, black and void",
      "Semibrevis notehead, black and void (turned)",
      "Semibrevis notehead, void",
      "Semiminima/fusa notehead, white",
      "Oblique form, ascending 2nd, black",
      "Oblique form, ascending 2nd, black and void",
      "Oblique form, ascending 2nd, void",
      "Oblique form, ascending 2nd, white",
      "Oblique form, ascending 3rd, black",
      "Oblique form, ascending 3rd, black and void",
      "Oblique form, ascending 3rd, void",
      "Oblique form, ascending 3rd, white",
      "Oblique form, ascending 4th, black",
      "Oblique form, ascending 4th, black and void",
      "Oblique form, ascending 4th, void",
      "Oblique form, ascending 4th, white",
      "Oblique form, ascending 5th, black",
      "Oblique form, ascending 5th, black and void",
      "Oblique form, ascending 5th, void",
      "Oblique form, ascending 5th, white",
      "Oblique form, descending 2nd, black",
      "Oblique form, descending 2nd, black and void",
      "Oblique form, descending 2nd, void",
      "Oblique form, descending 2nd, white",
      "Oblique form, descending 3rd, black",
      "Oblique form, descending 3rd, black and void",
      "Oblique form, descending 3rd, void",
      "Oblique form, descending 3rd, white",
      "Oblique form, descending 4th, black",
      "Oblique form, descending 4th, black and void",
      "Oblique form, descending 4th, void",
      "Oblique form, descending 4th, white",
      "Oblique form, descending 5th, black",
      "Oblique form, descending 5th, black and void",
      "Oblique form, descending 5th, void",
      "Oblique form, descending 5th, white",
      "Tempus perfectum cum prolatione perfecta (9/8)",
      "Tempus imperfectum cum prolatione imperfecta diminution 4",
      "Tempus imperfectum cum prolatione imperfecta diminution 5",
      "Tempus perfectum cum prolatione imperfecta (3/4)",
      "Tempus perfectum cum prolatione imperfecta diminution 1 (3/8)",
      "Tempus perfectum cum prolatione perfecta diminution 2 (9/16)",
      "Tempus imperfectum cum prolatione perfecta (6/8)",
      "Tempus imperfectum cum prolatione imperfecta (2/4)",
      "Tempus imperfectum cum prolatione imperfecta diminution 1 (2/2)",
      "Tempus imperfectum cum prolatione imperfecta diminution 2 (6/16)",
      "Tempus imperfectum cum prolatione imperfecta diminution 3 (2/2)",
      "Combining dot",
      "Combining void dot",
      "Combining vertical stroke",
      "Combining three dots horizontal",
      "Combining three dots triangular",
      "Combining two dots",
      "Mensural proportion 1",
      "Mensural proportion 2",
      "Mensural proportion 3",
      "Mensural proportion 4",
      "Mensural proportion major",
      "Mensural proportion minor",
      "Proportio dupla 1",
      "Proportio dupla 2",
      "Proportio quadrupla",
      "Proportio tripla",
      "Tempus perfectum",
      "Brevis rest",
      "Fusa rest",
      "Longa imperfecta rest",
      "Longa perfecta rest",
      "Maxima rest",
      "Minima rest",
      "Semibrevis rest",
      "Semifusa rest",
      "Semiminima rest",
      "Signum congruentiae down",
      "Signum congruentiae up",
      "Tempus imperfectum, horizontal",
      "Tempus perfectum, horizontal",
      "White mensural brevis",
      "White mensural fusa",
      "White mensural longa",
      "White mensural maxima",
      "White mensural minima",
      "White mensural semiminima",
      QT_TRANSLATE_NOOP("symUserNames", "Augmentation dot"),
      "1024th note (semihemidemisemihemidemisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "1024th note (semihemidemisemihemidemisemiquaver) stem up"),
      "128th note (semihemidemisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "128th note (semihemidemisemiquaver) stem up"),
      "16th note (semiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "16th note (semiquaver) stem up"),
      "256th note (demisemihemidemisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "256th note (demisemihemidemisemiquaver) stem up"),
      "32nd note (demisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "32nd note (demisemiquaver) stem up"),
      "512th note (hemidemisemihemidemisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "512th note (hemidemisemihemidemisemiquaver) stem up"),
      "64th note (hemidemisemiquaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "64th note (hemidemisemiquaver) stem up"),
      "Eighth note (quaver) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "Eighth note (quaver) stem up"),
      "Double whole note (breve)",
      "Double whole note (square)",
      "Half note (minim) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "Half note (minim) stem up"),
      "Quarter note (crotchet) stem down",
      QT_TRANSLATE_NOOP("symUserNames", "Quarter note (crotchet) stem up"),
      QT_TRANSLATE_NOOP("symUserNames", "Whole note (semibreve)"),
      "Left-pointing arrow for metric modulation",
      "Right-pointing arrow for metric modulation",
      "Do not copy",
      "Do not photocopy",
      "Eyeglasses",
      "1024th note (semihemidemisemihemidemisemiquaver) stem down",
      "1024th note (semihemidemisemihemidemisemiquaver) stem up",
      "128th note (semihemidemisemiquaver) stem down",
      "128th note (semihemidemisemiquaver) stem up",
      "16th note (semiquaver) stem down",
      "16th note (semiquaver) stem up",
      "256th note (demisemihemidemisemiquaver) stem down",
      "256th note (demisemihemidemisemiquaver) stem up",
      "32nd note (demisemiquaver) stem down",
      "32nd note (demisemiquaver) stem up",
      "512th note (hemidemisemihemidemisemiquaver) stem down",
      "512th note (hemidemisemihemidemisemiquaver) stem up",
      "64th note (hemidemisemiquaver) stem down",
      "64th note (hemidemisemiquaver) stem up",
      "Eighth note (quaver) stem down",
      "Eighth note (quaver) stem up",
      "A (black note)",
      "A flat (black note)",
      "A flat (half note)",
      "A flat (whole note)",
      "A (half note)",
      "A sharp (black note)",
      "A sharp (half note)",
      "A sharp (whole note)",
      "A (whole note)",
      "B (black note)",
      "B flat (black note)",
      "B flat (half note)",
      "B flat (whole note)",
      "B (half note)",
      "B sharp (black note)",
      "B sharp (half note)",
      "B sharp (whole note)",
      "B (whole note)",
      "C (black note)",
      "C flat (black note)",
      "C flat (half note)",
      "C flat (whole note)",
      "C (half note)",
      "C sharp (black note)",
      "C sharp (half note)",
      "C sharp (whole note)",
      "C (whole note)",
      "D (black note)",
      "D flat (black note)",
      "D flat (half note)",
      "D flat (whole note)",
      "D (half note)",
      "D sharp (black note)",
      "D sharp (half note)",
      "D sharp (whole note)",
      "D (whole note)",
      "Do (black note)",
      "Do (half note)",
      "Do (whole note)",
      "Double whole note (breve)",
      "Double whole note (square)",
      "E (black note)",
      "E flat (black note)",
      "E flat (half note)",
      "E flat (whole note)",
      "E (half note)",
      "E sharp (black note)",
      "E sharp (half note)",
      "E sharp (whole note)",
      "E (whole note)",
      "Empty black note",
      "Empty half note",
      "Empty whole note",
      "F (black note)",
      "F flat (black note)",
      "F flat (half note)",
      "F flat (whole note)",
      "F (half note)",
      "F sharp (black note)",
      "F sharp (half note)",
      "F sharp (whole note)",
      "F (whole note)",
      "Fa (black note)",
      "Fa (half note)",
      "Fa (whole note)",
      "G (black note)",
      "G flat (black note)",
      "G flat (half note)",
      "G flat (whole note)",
      "G (half note)",
      "G sharp (black note)",
      "G sharp (half note)",
      "G sharp (whole note)",
      "G (whole note)",
      "H (black note)",
      "H (half note)",
      "H sharp (black note)",
      "H sharp (half note)",
      "H sharp (whole note)",
      "H (whole note)",
      "Half note (minim) stem down",
      "Half note (minim) stem up",
      "La (black note)",
      "La (half note)",
      "La (whole note)",
      "Mi (black note)",
      "Mi (half note)",
      "Mi (whole note)",
      "Quarter note (crotchet) stem down",
      "Quarter note (crotchet) stem up",
      "Re (black note)",
      "Re (half note)",
      "Re (whole note)",
      "Arrowhead left black (Funk 7-shape re)",
      "Arrowhead left double whole (Funk 7-shape re)",
      "Arrowhead left white (Funk 7-shape re)",
      "Diamond black (4-shape mi; 7-shape mi)",
      "Diamond double whole (4-shape mi; 7-shape mi)",
      "Diamond white (4-shape mi; 7-shape mi)",
      "Isosceles triangle black (Walker 7-shape ti)",
      "Isosceles triangle double whole (Walker 7-shape ti)",
      "Isosceles triangle white (Walker 7-shape ti)",
      "Inverted keystone black (Walker 7-shape do)",
      "Inverted keystone double whole (Walker 7-shape do)",
      "Inverted keystone white (Walker 7-shape do)",
      "Moon black (Aikin 7-shape re)",
      "Moon double whole (Aikin 7-shape re)",
      "Moon left black (Funk 7-shape do)",
      "Moon left double whole (Funk 7-shape do)",
      "Moon left white (Funk 7-shape do)",
      "Moon white (Aikin 7-shape re)",
      "Quarter moon black (Walker 7-shape re)",
      "Quarter moon double whole (Walker 7-shape re)",
      "Quarter moon white (Walker 7-shape re)",
      "Round black (4-shape sol; 7-shape so)",
      "Round double whole (4-shape sol; 7-shape so)",
      "Round white (4-shape sol; 7-shape so)",
      "Square black (4-shape la; Aikin 7-shape la)",
      "Square double whole (4-shape la; Aikin 7-shape la)",
      "Square white (4-shape la; Aikin 7-shape la)",
      "Triangle left black (stem up; 4-shape fa; 7-shape fa)",
      "Triangle left double whole (stem up; 4-shape fa; 7-shape fa)",
      "Triangle left white (stem up; 4-shape fa; 7-shape fa)",
      "Triangle right black (stem down; 4-shape fa; 7-shape fa)",
      "Triangle right double whole (stem down; 4-shape fa; 7-shape fa)",
      "Triangle right white (stem down; 4-shape fa; 7-shape fa)",
      "Triangle-round black (Aikin 7-shape ti)",
      "Triangle-round white (Aikin 7-shape ti)",
      "Triangle-round left black (Funk 7-shape ti)",
      "Triangle-round left double whole (Funk 7-shape ti)",
      "Triangle-round left white (Funk 7-shape ti)",
      "Triangle-round white (Aikin 7-shape ti)",
      "Triangle up black (Aikin 7-shape do)",
      "Triangle up double whole (Aikin 7-shape do)",
      "Triangle up white (Aikin 7-shape do)",
      "Si (black note)",
      "Si (half note)",
      "Si (whole note)",
      "So (black note)",
      "So (half note)",
      "So (whole note)",
      "Ti (black note)",
      "Ti (half note)",
      "Ti (whole note)",
      "Whole note (semibreve)",
      "Black notehead",
      "Circle slash notehead",
      "Circle X notehead",
      "Circle X double whole",
      "Circle X half",
      "Circle X whole",
      "Circled black notehead",
      "Black notehead in large circle",
      "Circled double whole notehead",
      "Double whole notehead in large circle",
      "Circled half notehead",
      "Half notehead in large circle",
      "Circled whole notehead",
      "Whole notehead in large circle",
      "Cross notehead in large circle",
      "Double whole note cluster, 2nd",
      "Double whole note cluster, 3rd",
      "Combining double whole note cluster, bottom",
      "Combining double whole note cluster, middle",
      "Combining double whole note cluster, top",
      "Half note cluster, 2nd",
      "Half note cluster, 3rd",
      "Combining half note cluster, bottom",
      "Combining half note cluster, middle",
      "Combining half note cluster, top",
      "Quarter note cluster, 2nd",
      "Quarter note cluster, 3rd",
      "Combining quarter note cluster, bottom",
      "Combining quarter note cluster, middle",
      "Combining quarter note cluster, top",
      "Cluster notehead black (round)",
      "Cluster notehead white (round)",
      "Cluster notehead black (square)",
      "Cluster notehead white (square)",
      "Whole note cluster, 2nd",
      "Whole note cluster, 3rd",
      "Combining whole note cluster, bottom",
      "Combining whole note cluster, middle",
      "Combining whole note cluster, top",
      "Diamond black notehead",
      "Diamond black notehead (old)",
      "Diamond black notehead (wide)",
      "Black diamond cluster, 2nd",
      "Black diamond cluster, 3rd",
      "Combining black diamond cluster, bottom",
      "Combining black diamond cluster, middle",
      "Combining black diamond cluster, top",
      "White diamond cluster, 2nd",
      "White diamond cluster, 3rd",
      "Combining white diamond cluster, bottom",
      "Combining white diamond cluster, middle",
      "Combining white diamond cluster, top",
      "Diamond double whole notehead",
      "Diamond double whole notehead (old)",
      "Diamond half notehead",
      "Half-filled diamond notehead",
      "Diamond half notehead (old)",
      "Diamond half notehead (wide)",
      "Open diamond notehead",
      "Diamond white notehead",
      "Diamond white notehead (wide)",
      "Diamond whole notehead",
      "Diamond whole notehead (old)",
      "Double whole (breve) notehead",
      "Double whole (breve) notehead (square)",
      "Double whole notehead with X",
      "Half (minim) notehead",
      "Filled half (minim) notehead",
      "Half notehead with X",
      "Heavy X notehead",
      "Heavy X with hat notehead",
      "Large arrow down (lowest pitch) black notehead",
      "Large arrow down (lowest pitch) double whole notehead",
      "Large arrow down (lowest pitch) half notehead",
      "Large arrow down (lowest pitch) whole notehead",
      "Large arrow up (highest pitch) black notehead",
      "Large arrow up (highest pitch) double whole notehead",
      "Large arrow up (highest pitch) half notehead",
      "Large arrow up (highest pitch) whole notehead",
      "Moon notehead black",
      "Moon notehead white",
      "Null notehead",
      "Parenthesis notehead",
      "Opening parenthesis",
      "Closing parenthesis",
      "Plus notehead black",
      "Plus notehead double whole",
      "Plus notehead half",
      "Plus notehead whole",
      "Combining black rectangular cluster, bottom",
      "Combining black rectangular cluster, middle",
      "Combining black rectangular cluster, top",
      "Combining white rectangular cluster, bottom",
      "Combining white rectangular cluster, middle",
      "Combining white rectangular cluster, top",
      "Round black notehead",
      "Round black notehead, double slashed",
      "Large round black notehead",
      "Round black notehead, slashed",
      "Large round black notehead, slashed",
      "Round white notehead",
      "Round white notehead, double slashed",
      "Large round white notehead",
      "Round white notehead, slashed",
      "Large round white notehead, slashed",
      "Round white notehead with dot",
      "Large round white notehead with dot",
      "Large white diamond",
      "Slash with horizontal ends",
      "Muted slash with horizontal ends",
      "Slash with vertical ends",
      "Muted slash with vertical ends",
      "Small slash with vertical ends",
      "White slash double whole",
      "White slash half",
      "Muted white slash",
      "White slash whole",
      "Large X notehead",
      "Slashed black notehead (bottom left to top right)",
      "Slashed black notehead (top left to bottom right)",
      "Slashed double whole notehead (bottom left to top right)",
      "Slashed double whole notehead (top left to bottom right)",
      "Slashed half notehead (bottom left to top right)",
      "Slashed half notehead (top left to bottom right)",
      "Slashed whole notehead (bottom left to top right)",
      "Slashed whole notehead (top left to bottom right)",
      "Square notehead black",
      "Large square black notehead",
      "Large square white notehead",
      "Square notehead white",
      "Triangle notehead down black",
      "Triangle notehead down double whole",
      "Triangle notehead down half",
      "Triangle notehead down white",
      "Triangle notehead down whole",
      "Triangle notehead left black",
      "Triangle notehead left white",
      "Triangle notehead right black",
      "Triangle notehead right white",
      "Triangle-round notehead down black",
      "Triangle-round notehead down white",
      "Triangle notehead up black",
      "Triangle notehead up double whole",
      "Triangle notehead up half",
      "Triangle notehead up right black",
      "Triangle notehead up right white",
      "Triangle notehead up white",
      "Triangle notehead up whole",
      "Void notehead with X",
      "Whole (semibreve) notehead",
      "Filled whole (semibreve) notehead",
      "Whole notehead with X",
      "X notehead black",
      "X notehead double whole",
      "X notehead half",
      "Ornate X notehead",
      "Ornate X notehead in ellipse",
      "X notehead whole",
      "a (baseline)",
      "b (baseline)",
      "m (baseline)",
      "v (baseline)",
      "Bassa",
      "Loco",
      "Left parenthesis for octave signs",
      "Right parenthesis for octave signs",
      "a (superscript)",
      "b (superscript)",
      "m (superscript)",
      "v (superscript)",
      "One-handed roll (Stevens)",
      "Two Fusae",
      "Two Minimae",
      "Combining double octave line above",
      "Two Semifusae",
      "Two Semiminimae",
      "Three Fusae",
      "Three Minimae",
      "Three Semifusae",
      "Three Semiminimae",
      "Four Fusae",
      "Four Minimae",
      "Four Semifusae",
      "Four Semiminimae",
      "Five Fusae",
      "Five Minimae",
      "Five Semifusae",
      "Five Semiminimae",
      "Six Fusae",
      "Six Minimae",
      "Six Semifusae",
      "Six Semiminimae",
      "German organ tablature small A",
      "German organ tablature great A",
      "Rhythm Dot",
      "German organ tablature small B",
      "German organ tablature great B",
      "Brevis (Binary) Buxheimer Orgelbuch",
      "Brevis (Ternary) Buxheimer Orgelbuch",
      "Minima Rest Buxheimer Orgelbuch",
      "Semibrevis Buxheimer Orgelbuch",
      "Semibrevis Rest Buxheimer Orgelbuch",
      "German organ tablature small C",
      "German organ tablature great C",
      "German organ tablature small Cis",
      "German organ tablature great Cis",
      "German organ tablature small D",
      "German organ tablature great D",
      "German organ tablature small Dis",
      "German organ tablature great Dis",
      "German organ tablature small E",
      "German organ tablature great E",
      "German organ tablature small F",
      "German organ tablature great F",
      "German organ tablature small Fis",
      "German organ tablature great Fis",
      "Fusa",
      "Fusa Rest",
      "German organ tablature small G",
      "German organ tablature great G",
      "German organ tablature small Gis",
      "German organ tablature great Gis",
      "German organ tablature small H",
      "German organ tablature great H",
      "Minima",
      "Minima Rest",
      "Combining single octave line below",
      "Combining single octave line above",
      "Semibrevis",
      "Semibrevis Rest",
      "Semifusa",
      "Semifusa Rest",
      "Semiminima",
      "Semiminima Rest",
      "Tie",
      "Ornament bottom left concave stroke",
      "Ornament bottom left concave stroke, large",
      "Ornament bottom left convex stroke",
      "Ornament bottom right concave stroke",
      "Ornament bottom right convex stroke",
      "Comma",
      "Double oblique straight lines NW-SE",
      "Double oblique straight lines SW-NE",
      "Curve below",
      "Haydn ornament",
      "Ornament high left concave stroke",
      "Ornament high left convex stroke",
      "Ornament high right concave stroke",
      "Ornament high right convex stroke",
      "Hook after note",
      "Hook before note",
      "Left-facing half circle",
      "Left-facing hook",
      "Ornament left +",
      "Ornament left shake t",
      "Ornament left vertical stroke",
      "Ornament left vertical stroke with cross (+)",
      "Ornament low left concave stroke",
      "Ornament low left convex stroke",
      "Ornament low right concave stroke",
      "Ornament low right convex stroke",
      "Ornament middle vertical stroke",
      QT_TRANSLATE_NOOP("symUserNames", "Mordent"),
      "Oblique straight line NW-SE",
      "Oblique straight line SW-NE",
      "Oblique straight line tilted NW-SE",
      "Oblique straight line tilted SW-NE",
      "Oriscus",
      "Pincé (Couperin)",
      "Port de voix",
      "Supported appoggiatura trill",
      "Supported appoggiatura trill with two-note suffix",
      "Cadence",
      "Cadence with upper prefix",
      "Cadence with upper prefix and turn",
      "Cadence with turn",
      "Descending slide",
      "Double cadence with lower prefix",
      "Double cadence with upper prefix",
      "Double cadence with upper prefix and turn",
      "Inverted mordent with upper prefix",
      "Mordent with release",
      QT_TRANSLATE_NOOP("symUserNames", "Mordent with upper prefix"),
      "Pre-beat port de voix followed by multiple mordent (Dandrieu)",
      QT_TRANSLATE_NOOP("symUserNames", "Slide"),
      "Slide-trill with two-note suffix (J.S. Bach)",
      "Slide-trill (D'Anglebert)",
      "Slide-trill with one-note suffix (Marpurg)",
      "Slide-trill (Muffat)",
      "Slide-trill with two-note suffix (Muffat)",
      "Trill with lower suffix",
      "Trill with two-note suffix (Dandrieu)",
      "Trill with mordent",
      "Turn-trill with two-note suffix (J.S. Bach)",
      "Turn-trill (D'Anglebert)",
      "Quilisma",
      "Right-facing half circle",
      "Right-facing hook",
      "Ornament right vertical stroke",
      "Schleifer (long mordent)",
      "Shake",
      "Shake (Muffat)",
      "Short oblique straight line NW-SE",
      "Short oblique straight line SW-NE",
      QT_TRANSLATE_NOOP("symUserNames", "Short trill"),
      "Ornament top left concave stroke",
      "Ornament top left convex stroke",
      "Ornament top right concave stroke",
      "Ornament top right convex stroke",
      QT_TRANSLATE_NOOP("symUserNames", "Tremblement"),
      "Tremblement appuyé (Couperin)",
      QT_TRANSLATE_NOOP("symUserNames", "Trill"),
      QT_TRANSLATE_NOOP("symUserNames", "Turn"),
      QT_TRANSLATE_NOOP("symUserNames", "Inverted turn"),
      QT_TRANSLATE_NOOP("symUserNames", "Turn with slash"),
      "Turn up",
      "Inverted turn up",
      "Curve above",
      "Vertical line",
      "Ornament zig-zag line without right-hand end",
      "Ornament zig-zag line with right-hand end",
      "Ottava",
      "Ottava alta",
      "Ottava bassa",
      "Ottava bassa (ba)",
      "Ottava bassa (8vb)",
      "Penderecki unmeasured tremolo",
      "Agogo",
      "Almglocken",
      "Anvil",
      "Bamboo tube chimes",
      "Bamboo scraper",
      "Bass drum",
      "Bass drum on side",
      "Bow",
      "Box for percussion beater",
      "Brass mallets down",
      "Brass mallets left",
      "Brass mallets right",
      "Brass mallets up",
      "Combining dashed circle for round beaters (plated)",
      "Combining parentheses for round beaters (padded)",
      "Double bass drum stick down",
      "Double bass drum stick up",
      "Finger",
      "Fingernails",
      "Fist",
      "Guiro scraper",
      "Hammer",
      "Metal hammer, down",
      "Metal hammer, up",
      "Plastic hammer, down",
      "Plastic hammer, up",
      "Wooden hammer, down",
      "Wooden hammer, up",
      "Hand",
      "Hard bass drum stick down",
      "Hard bass drum stick up",
      "Hard glockenspiel stick down",
      "Hard glockenspiel stick left",
      "Hard glockenspiel stick right",
      "Hard glockenspiel stick up",
      "Hard timpani stick down",
      "Hard timpani stick left",
      "Hard timpani stick right",
      "Hard timpani stick up",
      "Hard xylophone stick down",
      "Hard xylophone stick left",
      "Hard xylophone stick right",
      "Hard xylophone stick up",
      "Hard yarn beater down",
      "Hard yarn beater left",
      "Hard yarn beater right",
      "Hard yarn beater up",
      "Jazz sticks down",
      "Jazz sticks up",
      "Knitting needle",
      "Chime hammer up",
      "Chime hammer down",
      "Medium bass drum stick down",
      "Medium bass drum stick up",
      "Medium timpani stick down",
      "Medium timpani stick left",
      "Medium timpani stick right",
      "Medium timpani stick up",
      "Medium xylophone stick down",
      "Medium xylophone stick left",
      "Medium xylophone stick right",
      "Medium xylophone stick up",
      "Medium yarn beater down",
      "Medium yarn beater left",
      "Medium yarn beater right",
      "Medium yarn beater up",
      "Metal bass drum stick down",
      "Metal bass drum stick up",
      "Metal beater down",
      "Metal hammer",
      "Metal beater, left",
      "Metal beater, right",
      "Metal beater, up",
      "Snare sticks down",
      "Snare sticks up",
      "Soft bass drum stick down",
      "Soft bass drum stick up",
      "Soft glockenspiel stick down",
      "Soft glockenspiel stick left",
      "Soft glockenspiel stick right",
      "Soft glockenspiel stick up",
      "Soft timpani stick down",
      "Soft timpani stick left",
      "Soft timpani stick right",
      "Soft timpani stick up",
      "Soft xylophone beaters",
      "Soft xylophone stick down",
      "Soft xylophone stick left",
      "Soft xylophone stick right",
      "Soft xylophone stick up",
      "Soft yarn beater down",
      "Soft yarn beater left",
      "Soft yarn beater right",
      "Soft yarn beater up",
      "Spoon-shaped wooden mallet",
      "Superball beater down",
      "Superball beater left",
      "Superball beater right",
      "Superball beater up",
      "Triangle beater down",
      "Triangle beater plain",
      "Triangle beater up",
      "Wire brushes down",
      "Wire brushes up",
      "Wood timpani stick down",
      "Wood timpani stick left",
      "Wood timpani stick right",
      "Wood timpani stick up",
      "Wood xylophone stick down",
      "Wood xylophone stick left",
      "Wood xylophone stick right",
      "Wood xylophone stick up",
      "Bell",
      "Bell of cymbal",
      "Bell plate",
      "Bell tree",
      "Bird whistle",
      "Board clapper",
      "Bongos",
      "Brake drum",
      "Cabasa",
      "Cannon",
      "Car horn",
      "Castanets",
      "Castanets with handle",
      "Celesta",
      "Cencerro",
      "Center (Weinberg)",
      "Center (Ghent)",
      "Center (Caltabiano)",
      "Chain rattle",
      "Chimes",
      "Chinese cymbal",
      "Choke (Weinberg)",
      "Claves",
      "Coins",
      "Conga",
      "Cow bell",
      "Crash cymbals",
      "Crotales",
      "Combining crush for stem",
      "Cuica",
      "Cymbal tongs",
      "Damp",
      "Damp 2",
      "Damp 3",
      "Damp 4",
      "Combining X for stem (dead note)",
      "Drum stick",
      "Duck call",
      "Edge of cymbal",
      "Empty trapezoid",
      "Finger cymbals",
      "Flexatone",
      "Football rattle",
      "Glass harmonica",
      "Glass harp",
      "Glass plate chimes",
      "Glass tube chimes",
      "Glockenspiel",
      "Glockenspiel (Smith Brindle)",
      "Goblet drum (djembe, dumbek)",
      "Gong",
      "Gong with button (nipple)",
      "Guiro",
      "Hard gum beater, down",
      "Hard gum beater, left",
      "Hard gum beater, right",
      "Hard gum beater, up",
      "Medium gum beater, down",
      "Medium gum beater, left",
      "Medium gum beater, right",
      "Medium gum beater, up",
      "Soft gum beater, down",
      "Soft gum beater, left",
      "Soft gum beater, right",
      "Soft gum beater, up",
      "Half-open",
      "Half-open 2 (Weinberg)",
      "Handbell",
      "Hi-hat",
      "Hi-hat cymbals on stand",
      "Jaw harp",
      "Jingle bells",
      "Klaxon horn",
      "Right hand (Agostini)",
      "Lion's roar",
      "Lithophone",
      "Log drum",
      "Lotus flute",
      "Marimba",
      "Marimba (Smith Brindle)",
      "Maraca",
      "Maracas",
      "Megaphone",
      "Metal plate chimes",
      "Metal tube chimes",
      "Musical saw",
      "Normal position (Caltabiano)",
      "On rim",
      "Open",
      "Closed / rim shot",
      "Pistol shot",
      "Police whistle",
      "Quijada (jawbone)",
      "Rainstick",
      "Ratchet",
      "Reco-reco",
      "Left hand (Agostini)",
      "Rim or edge (Weinberg)",
      "Rim (Ghent)",
      "Rim (Caltabiano)",
      "Rim shot for stem",
      "Sandpaper blocks",
      "Scrape around rim (counter-clockwise)",
      "Scrape around rim (clockwise)",
      "Scrape from center to edge",
      "Scrape from edge to center",
      "Shell bells",
      "Shell chimes",
      "Siren",
      "Sistrum",
      "Sizzle cymbal",
      "Sleigh bell",
      "Slide brush on gong",
      "Slide whistle",
      "Slit drum",
      "Snare drum",
      "Military snare drum",
      "Snare drum, snares off",
      "Steel drums",
      "Stick shot",
      "Superball",
      "Suspended cymbal",
      "Combining swish for stem",
      "Indian tabla",
      "Tam-tam",
      "Tam-tam with beater (Smith Brindle)",
      "Tambourine",
      "Temple blocks",
      "Tenor drum",
      "Thundersheet",
      "Timbales",
      "Timpani",
      "Tom-tom",
      "Chinese tom-tom",
      "Indo-American tom tom",
      "Japanese tom-tom",
      "Triangle",
      "Tubaphone",
      "Tubular bells",
      "Combining turn left for stem",
      "Combining turn left or right for stem",
      "Combining turn right for stem",
      "Vibraphone",
      "Metallophone (vibraphone motor off)",
      "Vibraphone (Smith Brindle)",
      "Vibraslap",
      "Vietnamese hat cymbal",
      "Whip",
      "Wind chimes (glass)",
      "Wind machine",
      "Wind whistle (or mouth siren)",
      "Wood block",
      "Wound beater, hard core down",
      "Wound beater, hard core left",
      "Wound beater, hard core right",
      "Wound beater, hard core up",
      "Wound beater, soft core down",
      "Wound beater, soft core left",
      "Wound beater, soft core right",
      "Wound beater, soft core up",
      "Xylophone",
      "Bass xylophone",
      "Xylophone (Smith Brindle)",
      "Tenor xylophone",
      "Trough tenor xylophone",
      "Trough xylophone",
      "Buzz pizzicato",
      "Damp",
      "Damp all",
      "Damp for stem",
      "Fingernail flick",
      "Left-hand pizzicato",
      "Plectrum",
      QT_TRANSLATE_NOOP("symUserNames", "Snap pizzicato above"),
      QT_TRANSLATE_NOOP("symUserNames", "Snap pizzicato below"),
      "With fingernails",
      "Quindicesima",
      "Quindicesima alta",
      "Quindicesima bassa",
      "Quindicesima bassa (mb)",
      QT_TRANSLATE_NOOP("symUserNames", "Repeat last bar"),
      QT_TRANSLATE_NOOP("symUserNames", "Repeat last two bars"),
      QT_TRANSLATE_NOOP("symUserNames", "Repeat last four bars"),
      "Repeat bar lower dot",
      "Repeat bar slash",
      "Repeat bar upper dot",
      "Single repeat dot",
      "Repeat dots",
      QT_TRANSLATE_NOOP("symUserNames", "Left (start) repeat sign"),
      QT_TRANSLATE_NOOP("symUserNames", "Right (end) repeat sign"),
      QT_TRANSLATE_NOOP("symUserNames", "Right and left repeat sign"),
      QT_TRANSLATE_NOOP("symUserNames", "1024th rest"),
      QT_TRANSLATE_NOOP("symUserNames", "128th (semihemidemisemiquaver) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "16th (semiquaver) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "256th rest"),
      QT_TRANSLATE_NOOP("symUserNames", "32nd (demisemiquaver) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "512th rest"),
      QT_TRANSLATE_NOOP("symUserNames", "64th (hemidemisemiquaver) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Eighth (quaver) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Double whole (breve) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Double whole rest on leger lines"),
      "Multiple measure rest",
      "H-bar, left half",
      "H-bar, middle",
      "H-bar, right half",
      QT_TRANSLATE_NOOP("symUserNames", "Half (minim) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Half rest on leger line"),
      QT_TRANSLATE_NOOP("symUserNames", "Longa rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Maxima rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Quarter (crotchet) rest"),
      "Old-style quarter (crotchet) rest",
      "Z-style quarter (crotchet) rest",
      QT_TRANSLATE_NOOP("symUserNames", "Whole (semibreve) rest"),
      QT_TRANSLATE_NOOP("symUserNames", "Whole rest on leger line"),
      "Reversed brace",
      "Reversed bracket bottom",
      "Reversed bracket top",
      "Right repeat sign within bar",
      "Schäffer clef",
      "Schäffer F clef to G clef change",
      "Schäffer G clef to F clef change",
      "Schäffer previous clef",
      QT_TRANSLATE_NOOP("symUserNames", "Segno"),
      QT_TRANSLATE_NOOP("symUserNames", "Segno (serpent)"),
      "Segno (serpent with vertical lines)",
      "Semi-pitched percussion clef 1",
      "Semi-pitched percussion clef 2",
      "Flat",
      "Flat (white)",
      "Double flat history sign",
      "Double sharp history sign",
      "Flat history sign",
      "Sharp history sign",
      "Natural (N)",
      "Sharp stem up",
      "Sharp stem down",
      "Sharp (white) stem up",
      "Sharp (white) stem down",
      "Split bar divider (bar spans a system break)",
      "1-line staff",
      "1-line staff (narrow)",
      "1-line staff (wide)",
      "2-line staff",
      "2-line staff (narrow)",
      "2-line staff (wide)",
      "3-line staff",
      "3-line staff (narrow)",
      "3-line staff (wide)",
      "4-line staff",
      "4-line staff (narrow)",
      "4-line staff (wide)",
      "5-line staff",
      "5-line staff (narrow)",
      "5-line staff (wide)",
      "6-line staff",
      "6-line staff (narrow)",
      "6-line staff (wide)",
      "Staff divide arrow down",
      "Staff divide arrow up",
      "Staff divide arrows",
      "Lower 1 staff position",
      "Lower 2 staff positions",
      "Lower 3 staff positions",
      "Lower 4 staff positions",
      "Lower 5 staff positions",
      "Lower 6 staff positions",
      "Lower 7 staff positions",
      "Lower 8 staff positions",
      "Raise 1 staff position",
      "Raise 2 staff positions",
      "Raise 3 staff positions",
      "Raise 4 staff positions",
      "Raise 5 staff positions",
      "Raise 6 staff positions",
      "Raise 7 staff positions",
      "Raise 8 staff positions",
      "Combining stem",
      "Combining bow on bridge stem",
      "Combining bow on tailpiece stem",
      "Combining buzz roll stem",
      "Combining damp stem",
      "Combining harp string noise stem",
      "Combining multiphonics (black) stem",
      "Combining multiphonics (black and white) stem",
      "Combining multiphonics (white) stem",
      "Combining Penderecki unmeasured tremolo stem",
      "Combining rim shot stem",
      "Combining sprechgesang stem",
      "Combining sul ponticello (bow behind bridge) stem",
      "Combining sussurando stem",
      "Combining swished stem",
      "Combining vibrato pulse accent (Saunders) stem",
      "Stockhausen irregular tremolo (\"Morsen\", like Morse code)",
      "Bow behind bridge (sul ponticello)",
      "Bow behind bridge on four strings",
      "Bow behind bridge on one string",
      "Bow behind bridge on three strings",
      "Bow behind bridge on two strings",
      "Bow on top of bridge",
      "Bow on tailpiece",
      "Change bow direction, indeterminate",
      QT_TRANSLATE_NOOP("symUserNames", "Down bow"),
      "Turned down bow",
      "Fouetté",
      "Half-harmonic",
      QT_TRANSLATE_NOOP("symUserNames", "Harmonic"),
      "Jeté (gettato) above",
      "Jeté (gettato) below",
      "Mute off",
      "Mute on",
      "Overpressure, down bow",
      "Overpressure, no bow direction",
      "Overpressure possibile, down bow",
      "Overpressure possibile, up bow",
      "Overpressure, up bow",
      QT_TRANSLATE_NOOP("symUserNames", "Thumb position"),
      "Turned thumb position",
      QT_TRANSLATE_NOOP("symUserNames", "Up bow"),
      "Turned up bow",
      "Vibrato pulse accent (Saunders) for stem",
      QT_TRANSLATE_NOOP("symUserNames", "System divider"),
      QT_TRANSLATE_NOOP("symUserNames", "Extra long system divider"),
      QT_TRANSLATE_NOOP("symUserNames", "Long system divider"),
      "Augmentation dot",
      "Black note, fractional 16th beam, long stem",
      "Black note, fractional 16th beam, short stem",
      "Black note, fractional 32nd beam, long stem",
      "Black note, fractional 8th beam, long stem",
      "Black note, fractional 8th beam, short stem",
      "Black note, long stem",
      "Black note, short stem",
      "Continuing 16th beam for long stem",
      "Continuing 16th beam for short stem",
      "Continuing 32nd beam for long stem",
      "Continuing 8th beam for long stem",
      "Continuing 8th beam for short stem",
      "Tie",
      "Tuplet number 3 for long stem",
      "Tuplet number 3 for short stem",
      "Tuplet bracket end for long stem",
      "Tuplet bracket end for short stem",
      "Tuplet bracket start for long stem",
      "Tuplet bracket start for short stem",
      "Time signature 0",
      "Reversed time signature 0",
      "Turned time signature 0",
      "Time signature 1",
      "Reversed time signature 1",
      "Turned time signature 1",
      "Time signature 2",
      "Reversed time signature 2",
      "Turned time signature 2",
      "Time signature 3",
      "Reversed time signature 3",
      "Turned time signature 3",
      "Time signature 4",
      "Reversed time signature 4",
      "Turned time signature 4",
      "Time signature 5",
      "Reversed time signature 5",
      "Turned time signature 5",
      "Time signature 6",
      "Reversed time signature 6",
      "Turned time signature 6",
      "Time signature 7",
      "Reversed time signature 7",
      "Turned time signature 7",
      "Time signature 8",
      "Reversed time signature 8",
      "Turned time signature 8",
      "Time signature 9",
      "Reversed time signature 9",
      "Turned time signature 9",
      "Left bracket for whole time signature",
      "Left bracket for numerator only",
      "Right bracket for whole time signature",
      "Right bracket for numerator only",
      "Control character for denominator digit",
      "Control character for numerator digit",
      "Time signature comma",
      "Common time",
      "Reversed common time",
      "Turned common time",
      "Cut time (Bach)",
      "Cut triple time (9/8)",
      "Cut time",
      "Reversed cut time",
      "Turned cut time",
      "Time signature equals",
      "Time signature fraction ½",
      "Time signature fraction ⅓",
      "Time signature fraction ¼",
      "Time signature fraction ¾",
      "Time signature fraction ⅔",
      "Time signature fraction slash",
      "Time signature minus",
      "Time signature multiply",
      "Open time signature (Penderecki)",
      "Left parenthesis for whole time signature",
      "Left parenthesis for numerator only",
      "Right parenthesis for whole time signature",
      "Right parenthesis for numerator only",
      "Time signature +",
      "Time signature + (for numerators)",
      "Time signature slash separator",
      "Open time signature",
      "Combining tremolo 1",
      "Combining tremolo 2",
      "Combining tremolo 3",
      "Combining tremolo 4",
      "Combining tremolo 5",
      "Divide measured tremolo by 2",
      "Divide measured tremolo by 3",
      "Divide measured tremolo by 4",
      "Divide measured tremolo by 6",
      "Fingered tremolo 1",
      "Fingered tremolo 2",
      "Fingered tremolo 3",
      "Fingered tremolo 4",
      "Fingered tremolo 5",
      "Triple-tongue above",
      "Triple-tongue below",
      "Tuplet 0",
      "Tuplet 1",
      "Tuplet 2",
      "Tuplet 3",
      "Tuplet 4",
      "Tuplet 5",
      "Tuplet 6",
      "Tuplet 7",
      "Tuplet 8",
      "Tuplet 9",
      "Tuplet colon",
      "Wieniawski unmeasured tremolo",
      "Wieniawski unmeasured tremolo (simpler)",
      "Unpitched percussion clef 1",
      "Unpitched percussion clef 2",
      "Ventiduesima",
      "Ventiduesima alta",
      "Ventiduesima bassa",
      "Ventiduesima bassa (mb)",
      "Finger click (Stockhausen)",
      "Halb gesungen (semi-sprechgesang)",
      "Mouth closed",
      "Mouth open",
      "Mouth pursed",
      "Mouth slightly open",
      "Mouth wide open",
      "Nasal voice",
      "Sprechgesang",
      "Tongue click (Stockhausen)",
      "Tongue and finger click (Stockhausen)",
      "Combining sussurando for stem",
      "Arpeggiato wiggle segment, downwards",
      "Arpeggiato arrowhead down",
      "Arpeggiato downward swash",
      "Arpeggiato wiggle segment, upwards",
      "Arpeggiato arrowhead up",
      "Arpeggiato upward swash",
      "Circular motion segment",
      "Constant circular motion segment",
      "Constant circular motion segment (flipped)",
      "Constant circular motion segment (flipped, large)",
      "Constant circular motion segment (large)",
      "Circular motion end",
      "Circular motion segment, large",
      "Circular motion segment, larger",
      "Circular motion segment, larger still",
      "Circular motion segment, largest",
      "Circular motion segment, small",
      "Circular motion start",
      "Glissando wiggle segment",
      "Group glissando 1",
      "Group glissando 2",
      "Group glissando 3",
      "Quasi-random squiggle 1",
      "Quasi-random squiggle 2",
      "Quasi-random squiggle 3",
      "Quasi-random squiggle 4",
      QT_TRANSLATE_NOOP("symUserNames", "Sawtooth line segment"),
      "Narrow sawtooth line segment",
      QT_TRANSLATE_NOOP("symUserNames", "Wide sawtooth line segment"),
      "Square wave line segment",
      "Narrow square wave line segment",
      "Wide square wave line segment",
      "Trill wiggle segment",
      "Trill wiggle segment, fast",
      "Trill wiggle segment, faster",
      "Trill wiggle segment, faster still",
      "Trill wiggle segment, fastest",
      "Trill wiggle segment, slow",
      "Trill wiggle segment, slower",
      "Trill wiggle segment, slower still",
      "Trill wiggle segment, slowest",
      "Vibrato largest, slower",
      "Vibrato medium, slower",
      "Vibrato / shake wiggle segment",
      "Vibrato large, fast",
      QT_TRANSLATE_NOOP("symUserNames", "Vibrato large, faster"),
      "Vibrato large, faster still",
      "Vibrato large, fastest",
      "Vibrato large, slow",
      "Vibrato large, slower",
      QT_TRANSLATE_NOOP("symUserNames", "Vibrato large, slowest"),
      "Vibrato largest, fast",
      "Vibrato largest, faster",
      "Vibrato largest, faster still",
      "Vibrato largest, fastest",
      "Vibrato largest, slow",
      "Vibrato largest, slowest",
      "Vibrato medium, fast",
      "Vibrato medium, faster",
      "Vibrato medium, faster still",
      "Vibrato medium, fastest",
      "Vibrato medium, slow",
      "Vibrato medium, slowest",
      "Vibrato small, fast",
      "Vibrato small, faster",
      "Vibrato small, faster still",
      "Vibrato small, fastest",
      "Vibrato small, slow",
      "Vibrato small, slower",
      "Vibrato small, slowest",
      "Vibrato smallest, fast",
      "Vibrato smallest, faster",
      "Vibrato smallest, faster still",
      "Vibrato smallest, fastest",
      "Vibrato smallest, slow",
      "Vibrato smallest, slower",
      "Vibrato smallest, slowest",
      "Vibrato start",
      "Wide vibrato / shake wiggle segment",
      "Wavy line segment",
      "Narrow wavy line segment",
      "Wide wavy line segment",
      "Closed hole",
      "Flatter embouchure",
      "Half-closed hole",
      "Half-closed hole 2",
      "Half-open hole",
      "Somewhat relaxed embouchure",
      "Somewhat tight embouchure",
      "Mouthpiece or hand pop",
      "Combining multiphonics (black) for stem",
      "Combining multiphonics (black and white) for stem",
      "Combining multiphonics (white) for stem",
      "Open hole",
      "Much more reed (push inwards)",
      "Normal reed position",
      "Very little reed (pull outwards)",
      "Relaxed embouchure",
      "Rim only",
      "Sharper embouchure",
      "Very tight embouchure / strong air pressure",
      "Three-quarters closed hole",
      "Tight embouchure",
      "Trill key",
      "Very tight embouchure",
      "Very relaxed embouchure / weak air-pressure",
      // SMuFL standard symbol user names }}}

//    EXTENSIONS
//    SMuFL stylistic alternates which we need to access directly

      "Double whole note (breve), single vertical strokes",
      "4-string tab clef (serif)",
      "6-string tab clef (serif)",
      "C clef (French, 18th century)",
      "C clef (French, 20th century)",
      "F clef (French, 18th century)",
      "F clef (19th century)",
      "Small brace",
      "Large brace",
      "Larger brace",

//    MuseScore-local symbols, precomposed symbols to mimic some Emmentaler glyphs

      QT_TRANSLATE_NOOP("symUserNames", "Prall mordent"),
      QT_TRANSLATE_NOOP("symUserNames", "Up prall"),
      QT_TRANSLATE_NOOP("symUserNames", "Up mordent"),
      QT_TRANSLATE_NOOP("symUserNames", "Prall down"),
//      QT_TRANSLATE_NOOP("symUserNames", "Down prall"),
      QT_TRANSLATE_NOOP("symUserNames", "Down mordent"),
      QT_TRANSLATE_NOOP("symUserNames", "Prall up"),
      QT_TRANSLATE_NOOP("symUserNames", "Line prall"),

//    additional symbols

      "noteLongaUp",
      "noteLongaDown",
      "noteLongaSquareUp",
      "noteLongaSquareDown",
      QT_TRANSLATE_NOOP("symUserNames", "Space")
      } };

//---------------------------------------------------------
//   Conversion table of old symbol names (1.3)
//    The mapping corresponds to fonts/mscore/glyphnames.json and must be in sync with it
//    symNames must be in sync with enum class SymId
//---------------------------------------------------------

struct oldName {
      const char* name;
      SymId symId;
      };

QHash<QString, SymId> Sym::lonhash;
QVector<oldName> oldNames = {
//      {"ornamentDownPrall",                     SymId::ornamentPrecompMordentUpperPrefix },
      {"clef eight",                            SymId::clef8},
      //{"clef one"                             SymId::},
      //{"clef five"                            SymId::},
      {"whole rest",                            SymId::restWhole },           // rests.0
      {"half rest",                             SymId::restHalf },            // rests.1
      {"outside whole rest",                    SymId::restWholeLegerLine },  // rests.0o
      {"outside half rest",                     SymId::restHalfLegerLine },   // rests.1o
      {"rest M3",                               SymId::restMaxima },          // rests.M3
      {"breve rest",                            SymId::restDoubleWhole },     // rests.M1
      {"longa rest",                            SymId::restLonga },           // rests.M2
      {"quart rest",                            SymId::restQuarter },         // rests.2
      {"clas quart rest",                       SymId::restQuarterOld },      // rests.2classical
      {"eight rest",                            SymId::rest8th },             // rests.3
      {"16' rest",                              SymId::rest16th },            // rests.4
      {"32' rest",                              SymId::rest32nd },            // rests.5
      {"64' rest",                              SymId::rest64th },            // rests.6
      {"128' rest",                             SymId::rest128th },           // rests.7
//      {"256' rest",                             SymId::rest256th },           // rests.8
//      {"512' rest",                             SymId::rest512th },           // rests.9
//      {"1024' rest",                            SymId::rest1024th },          // rests.10

      {"sharp",                                 SymId::accidentalSharp },                       // accidentals.sharp
      {"sharp arrow up",                        SymId::accidentalThreeQuarterTonesSharpArrowUp },             // accidentals.sharp.arrowup - typo in 1.3
      {"sharp arrow both",                      SymId::accidentalQuarterToneSharpArrowDown },           // accidentals.sharp.arrowdown
//    {"sharp arrow both",                      SymId::noSym },         // accidentals.sharp.arrowboth sharp with both arrows missing in SMuFL
      {"sharp slash",                           SymId::accidentalQuarterToneSharpStein },       // accidentals.sharp.slashslash.stem
      {"sharp slash2",                          SymId::accidentalBuyukMucennebSharp },          // accidentals.sharp.slashslashslash.stemstem
      {"sharp slash3",                          SymId::accidentalKomaSharp },                   // accidentals.sharp.slashslashslash.stem
      {"sharp slash4",                          SymId::accidentalThreeQuarterTonesSharpStein }, // accidentals.sharp.slashslash.stemstemstem
      {"natural",                               SymId::accidentalNatural },                           // accidentals.natural
      {"natural arrow up",                      SymId::accidentalQuarterToneSharpNaturalArrowUp },    // accidentals.natural.arrowup
      {"natural arrow down",                    SymId::accidentalQuarterToneFlatNaturalArrowDown },   // accidentals.natural.arrowdown
//    {"natural arrow both",                    SymId::noSym },         // accidentals.natural.arrowboth natural with both arrows missing in SMuFL
      {"flat",                                  SymId::accidentalFlat },                              // accidentals.flat
      {"flat arrow up",                         SymId::accidentalQuarterToneFlatArrowUp },            // accidentals.flat.arrowup
      {"flat arrow both",                       SymId::accidentalThreeQuarterTonesFlatArrowDown },    // accidentals.flat.arrowdown  - typo in 1.3
//    {"flat arrow both",                       SymId::noSym },         // accidentals.flat.arrowboth flat with both arrows missing in SMuFL
      {"flat slash",                            SymId::accidentalBakiyeFlat },                        // accidentals.flat.slash
      {"flat slash2",                           SymId::accidentalBuyukMucennebFlat },                 // accidentals.flat.slashslash
      {"mirrored flat2",                        SymId::accidentalThreeQuarterTonesFlatZimmermann },   // accidentals.mirroredflat.flat
      {"mirrored flat",                         SymId::accidentalQuarterToneFlatStein },    // accidentals.mirroredflat more than one candidate in SMuFL: first occurring chosen
//    {"mirrored flat slash",                   SymId::noSym },                     // accidentals.mirroredflat.backslash - mirrored-slashed flat missing in SMuFL
      {"flat flat",                             SymId::accidentalDoubleFlat },      // accidentals.flatflat
//    {"flat flat slash",                       SymId::noSym },                     // slashes double flat missing in SMuFL
      {"sharp sharp",                           SymId::accidentalDoubleSharp },     // accidentals.doublesharp
      {"sori",                                  SymId::accidentalSori },            // accidentals.sori
      {"koron",                                 SymId::accidentalKoron },           // accidentals.koron
      {"right parenthesis",                     SymId::noteheadParenthesisRight },  // accidentals.rightparen SMULF parenth. for noteheads used instead
      {"left parenthesis",                      SymId::noteheadParenthesisLeft },   // accidentals.leftparen

      {"arrowheads.open.01",                    SymId::arrowheadWhiteRight }, // arrowheads.open.01 similar, not identical in SMuFL
      {"arrowheads.open.0M1",                   SymId::arrowheadWhiteLeft },  // arrowheads.open.0M1
      {"arrowheads.open.11",                    SymId::arrowheadWhiteUp },    // arrowheads.open.11
      {"arrowheads.open.1M1",                   SymId::arrowheadWhiteDown },  // arrowheads.open.1M1
      {"arrowheads.close.01",                   SymId::arrowheadBlackRight }, // arrowheads.close.01
      {"arrowheads.close.0M1",                  SymId::arrowheadBlackLeft },  // arrowheads.close.0M1
      {"arrowheads.close.11",                   SymId::arrowheadBlackUp },    // arrowheads.close.11
      {"arrowheads.close.1M1",                  SymId::arrowheadBlackDown },  // arrowheads.close.1M1

      {"dot",                                   SymId::augmentationDot },           // dots.dot
      {"longa up",                              SymId::noteLongaUp },               // noteheads.uM2
      {"longa down",                            SymId::noteLongaDown },             // noteheads.dM2
      {"brevis head",                           SymId::noteheadDoubleWhole },       // noteheads.sM1
      {"brevis double head",                    SymId::noSym },                     // noteheads.sM1double, stylistic alternate in SMuFL
      {"whole head",                            SymId::noteheadWhole },             // noteheads.s0
      {"half head",                             SymId::noteheadHalf },              // noteheads.s1
      {"quart head",                            SymId::noteheadBlack },             // noteheads.s2
      {"whole diamond head",                    SymId::noteheadDiamondWhole },      // noteheads.s0diamond
      {"half diamond head",                     SymId::noteheadDiamondHalf },       // noteheads.s1diamond
      {"diamond head",                          SymId::noteheadDiamondBlack },      // noteheads.s2diamond
      {"whole triangle head",                   SymId::noteheadTriangleDownWhole }, // noteheads.s0triangle
      {"down half triangle head",               SymId::noteheadTriangleDownHalf },  // noteheads.d1triangle
      {"up half triangle head",                 SymId::noteheadTriangleDownHalf },  // noteheads.u1triangle
      {"up quart triangle head",                SymId::noteheadTriangleDownBlack }, // noteheads.u2triangle
      {"down quart triangle head",              SymId::noteheadTriangleDownBlack }, // noteheads.d2triangle
      {"whole slash head",                      SymId::noteheadSlashWhiteWhole },   // noteheads.s0slash
      {"half slash head",                       SymId::noteheadSlashWhiteHalf },    // noteheads.s1slash
      {"quart slash head",                      SymId::noteheadSlashHorizontalEnds },     // noteheads.s2slash
      {"whole cross head",                      SymId::noteheadXWhole },            // noteheads.s0cross
      {"half cross head",                       SymId::noteheadXHalf },             // noteheads.s1cross
      {"cross head",                            SymId::noteheadXBlack },            // noteheads.s2cross
      {"x circle head",                         SymId::noteheadCircleX },           // noteheads.s2xcircle
//    {"s0do head",                             SymId::noSym },         // noteheads.s0do Whole DO triangle up missing in SMuFL
      {"d1do head",                             SymId::noteShapeTriangleUpWhite },  // noteheads.d1do
      {"u1do head",                             SymId::noteShapeTriangleUpWhite },  // noteheads.u1do
      {"d2do head",                             SymId::noteShapeTriangleUpBlack },  // noteheads.d2do
      {"u2do head",                             SymId::noteShapeTriangleUpBlack },  // noteheads.u2do
//    {"s0re head",                             SymId::noSym },         // noteheads.s0re Whole moon-shaped RE missing in SMuFL
      {"u1re head",                             SymId::noteShapeMoonWhite },        // noteheads.u1re
      {"d1re head",                             SymId::noteShapeMoonWhite },        // noteheads.d1re
      {"u2re head",                             SymId::noteShapeMoonBlack },        // noteheads.u2re
      {"d2re head",                             SymId::noteShapeMoonBlack },        // noteheads.d2re
//    {"s0mi head",                             SymId::noSym },         // noteheads.s0mi Whole diamond-shaped MI missing in SMuFL
      {"s1mi head",                             SymId::noteShapeDiamondWhite },     // noteheads.s1mi
      {"s2mi head",                             SymId::noteShapeDiamondBlack },     // noteheads.s2mi
//    {"u0fa head",                             SymId::noSym },         // noteheads.u0fa Whole triangle-left shaped (up) FA missing in SMuFL
//    {"d0fa head",                             SymId::noSym },         // noteheads.d0fa Whole triangle-left shaped (dn) FA missing in SMuFL
      {"u1fa head",                             SymId::noteheadTriangleUpRightWhite },    // noteheads.u1fa
      {"d1fa head",                             SymId::noteShapeTriangleRightWhite },     // noteheads.d1fa
      {"u2fa head",                             SymId::noteheadTriangleUpRightBlack },    // noteheads.u2fa
      {"d2fa head",                             SymId::noteheadTriangleLeftBlack },       // noteheads.d2fa
//    {"s0la head",                             SymId::noSym },         // noteheads.s0la Whole rectangle shaped LA missing in SMuFL
      {"s1la head",                             SymId::noteShapeSquareWhite },            // noteheads.s1la
      {"s2la head",                             SymId::noteShapeSquareBlack },            // noteheads.s2la
//    {"s0ti head",                             SymId::noSym },         // Whole rounded-triangle shaped TI missing in SMuFL
      {"u1ti head",                             SymId::noteShapeTriangleRoundWhite },     // noteheads.u1ti
      {"d1ti head",                             SymId::noteShapeTriangleRoundWhite },     // noteheads.d1ti
      {"u2ti head",                             SymId::noteShapeTriangleRoundBlack },     // noteheads.u2ti
      {"d2ti head",                             SymId::noteShapeTriangleRoundBlack },     // noteheads.d2ti
//    {"s0sol head",                            SymId::noSym },         // noteheads.s0sol Whole rounded shaped SOL missing in SMuFL
      {"s1sol head",                            SymId::noteShapeRoundWhite },       // noteheads.s1sol
      {"s2sol head",                            SymId::noteShapeRoundBlack },       // noteheads.s2sol

      {"ufermata",                              SymId::fermataAbove },              // scripts.ufermata
      {"dfermata",                              SymId::fermataBelow },              // scripts.dfermata
      {"snappizzicato",                         SymId::pluckedSnapPizzicatoAbove }, // scripts.snappizzicato
      {"ushortfermata",                         SymId::fermataShortAbove },         // scripts.ushortfermata
      {"dshortfermata",                         SymId::fermataShortBelow },         // scripts.dshortfermata
      {"ulongfermata",                          SymId::fermataLongAbove },          // scripts.ulongfermata
      {"dlongfermata",                          SymId::fermataLongBelow },          // scripts.dlongfermata
      {"uverylongfermata",                      SymId::fermataVeryLongAbove },      // scripts.uverylongfermata
      {"dverylongfermata",                      SymId::fermataVeryLongBelow },      // scripts.dverylongfermata
      {"thumb",                                 SymId::stringsThumbPosition },      // scripts.thumb
      {"sforza to accent",                      SymId::articAccentAbove },          // scripts.sforzato
//    {"espressivo",                            SymId::noSym },         // scripts.espr <> 'espressivo' removed and not present in SMuFL
      {"staccato",                              SymId::articStaccatoAbove },        // scripts.staccato
      {"ustaccatissimo",                        SymId::articStaccatissimoAbove },   // scripts.ustaccatissimo
      {"dstaccatissimo",                        SymId::articStaccatissimoBelow },   // scripts.dstaccatissimo
      {"tenuto",                                SymId::articTenutoAbove },          // scripts.tenuto
      {"uportato",                              SymId::articTenutoStaccatoAbove },  // scripts.uportato
      {"dportato",                              SymId::articTenutoStaccatoBelow },  // scripts.dportato
      {"umarcato",                              SymId::articMarcatoAbove },         // scripts.umarcato
      {"dmarcato",                              SymId::articMarcatoBelow },         // scripts.dmarcato
      {"fadein",                                SymId::guitarFadeIn },              // scripts.fadein
      {"fadeout",                               SymId::guitarFadeOut },             // scripts.fadeout
      {"volumeswell",                           SymId::guitarVolumeSwell },         // scripts.volumeswell
      {"wigglesawtooth",                        SymId::wiggleSawtooth },            // scripts.wiggleSawtooth
      {"wigglesawtoothwide",                    SymId::wiggleSawtoothWide },        // scripts.wiggleSawtoothWide
      {"wigglevibratolargefaster",              SymId::wiggleVibratoLargeFaster },  // scripts.wiggleVibratoLargeFaster
      {"wigglevibratolargeslowest",             SymId::wiggleVibratoLargeSlowest }, // scripts.wiggleVibratoLargeSlowest
      {"ouvert",                                SymId::brassMuteOpen },             // scripts.open
      {"halfopen",                              SymId::brassMuteHalfClosed },       // scripts.halfopen CHECK!!! pre 2.0 only
      {"plus stop",                             SymId::brassMuteClosed },           // scripts.stopped
      {"up bow",                                SymId::stringsUpBow },              // scripts.upbow
      {"down bow",                              SymId::stringsDownBow },            // scripts.downbow
      {"reverse turn",                          SymId::ornamentTurnInverted },      // scripts.reverseturn
      {"turn",                                  SymId::ornamentTurn },              // scripts.turn
      {"trill",                                 SymId::ornamentTrill },             // scripts.trill
      {"upedal heel",                           SymId::keyboardPedalHeel1 },        // scripts.upedalheel
      {"dpedalheel",                            SymId::keyboardPedalHeel2 },        // scripts.dpedalheel
      {"upedal toe",                            SymId::keyboardPedalToe1 },         // scripts.upedaltoe
      {"dpedal toe",                            SymId::keyboardPedalToe2 },         // scripts.dpedaltoe
      {"flageolet",                             SymId::stringsHarmonic },           // scripts.flageolet

      {"segno",                                 SymId::segno },                     // scripts.segno
      {"varsegno",                              SymId::segnoSerpent1 }, // not identical to SMuFL, but very similar
      {"coda",                                  SymId::coda },                      // scripts.coda
      {"varied coda",                           SymId::codaSquare },                // scripts.varcoda
      {"rcomma",                                SymId::breathMarkSalzedo },         // scripts.rcomma
//    {"lcomma",                                SymId::noSym },         // reversed breath missing in SMuFL
//    {"rvarcomma",                             SymId::noSym },         // straight breath missing in SMuFL
//    {"lvarcomma",                             SymId::noSym },         // reversed straight breath missing in SMuFL
      {"arpeggio",                              SymId::wiggleArpeggiatoUp },        // scripts.arpeggio
      {"trillelement",                          SymId::wiggleTrill },               // scripts.trill_element
      {"arpeggio arrow down",                   SymId::wiggleArpeggiatoDownArrow }, // scripts.arpeggio.arrow.M1
      {"arpeggio arrow up",                     SymId::wiggleArpeggiatoUpArrow },   // scripts.arpeggio.arrow.1
      {"trill element",                         SymId::wiggleTrillFastest },        // scripts.trilelement
      {"prall",                                 SymId::ornamentShortTrill },        // scripts.prall
      {"mordent",                               SymId::ornamentMordent },           // scripts.mordent
      {"prall prall",                           SymId::ornamentTremblement },       // scripts.prallprall

      {"prall mordent",                         SymId::ornamentPrallMordent },      // scripts.prallmordent
      {"up prall",                              SymId::ornamentUpPrall },           // scripts.upprall
      {"up mordent",                            SymId::ornamentUpMordent },         // scripts.upmordent
      {"prall down",                            SymId::ornamentPrallDown },         // scripts.pralldown
//      {"down prall",                            SymId::ornamentDownPrall },         // scripts.downprall
      {"down mordent",                          SymId::ornamentDownMordent },       // scripts.downmordent
      {"prall up",                              SymId::ornamentPrallUp },           // scripts.prallup
      {"line prall",                            SymId::ornamentLinePrall },         // scripts.lineprall

      {"schleifer",                             SymId::ornamentPrecompSlide },      // scripts.schleifer
      {"caesura straight",                      SymId::caesura },                   // scripts.caesura.straight
      {"caesura curved",                        SymId::caesuraCurved },             // scripts.caesura.curved

      {"eight flag",                            SymId::flag8thUp },                 // flags.u3
      {"sixteenth flag",                        SymId::flag16thUp },                // flags.u4
      {"thirtysecond flag",                     SymId::flag32ndUp },                // flags.u5
      {"sixtyfour flag",                        SymId::flag64thUp },                // flags.u6
      {"128flag",                               SymId::flag128thUp },               // flags.u7
//      {"256flag",                               SymId::flag256thUp },               // flags.u8
//      {"512flag",                               SymId::flag512thUp },               // flags.u9
//      {"1024flag",                              SymId::flag1024thUp },             // flags.u10
      {"deight flag",                           SymId::flag8thDown },               // flags.d3
      {"grace dash",                            SymId::graceNoteSlashStemUp },      // flags.ugrace
      {"dgrace dash",                           SymId::graceNoteSlashStemDown },    // flags.dgrace
      {"dsixteenth flag",                       SymId::flag16thDown },              // flags.d4
      {"dthirtysecond flag",                    SymId::flag32ndDown },              // flags.d5
      {"dsixtyfourth flag",                     SymId::flag16thDown },              // flags.d6
      {"d128flag",                              SymId::flag128thDown },             // flags.d7
//      {"d256flag",                              SymId::flag256thDown },             // flags.d8
//      {"d512flag",                              SymId::flag512thDown },             // flags.d9
//      {"d1024flag",                             SymId::flag1024thDown },            // flags.d10

      {"alto clef",                       SymId::cClef },                     // clefs.C
      {"calto clef",                      SymId::cClefChange },               // clefs.C_change
      {"bass clef",                       SymId::fClef },                     // clefs.F
      {"cbass clef",                      SymId::fClefChange },               // clefs.F_change
      {"trebleclef",                      SymId::gClef },                     // clefs.G
      {"ctrebleclef",                     SymId::gClefChange },               // clefs.G_change
      {"percussion clef",                 SymId::unpitchedPercussionClef1 },  // clefs.percussion
      {"cpercussion clef",                SymId::unpitchedPercussionClef1 },  // clefs.percussion_change stylistic alternate in SMuFL
      {"tab clef",                        SymId::sixStringTabClef },          // clefs.tab
      {"ctab clef",                       SymId::sixStringTabClef },          // clefs.tab_change  stylistic alternate in SMuFL
      {"four four meter",                 SymId::timeSigCommon },             // timesig.C44
      {"allabreve",                       SymId::timeSigCutCommon },          // timesig.C22
      {"pedalasterisk",                   SymId::keyboardPedalUp },           // pedal.*
      {"pedaldash",                       SymId::keyboardPedalHyphen },       // pedal.M
      {"pedaldot",                        SymId::keyboardPedalDot },          // pedal..
      {"pedalP",                          SymId::keyboardPedalP },            // pedal.P
      {"pedald",                          SymId::keyboardPedalD },            // pedal.d
      {"pedale",                          SymId::keyboardPedalE },            // pedal.e
      {"pedal ped",                       SymId::keyboardPedalPed },          // pedal.Ped
      {"bracket tips up",                 SymId::bracketTop },                // brackettips.uright
      {"bracket tips down",               SymId::bracketBottom },             // brackettips.dright
      {"bracket tips left up",            SymId::reversedBracketTop },        // brackettips.uleft
      {"bracket tips left down",          SymId::reversedBracketBottom },     // brackettips.dleft
      {"acc dot",                         SymId::accdnCombDot },              // accordion.accDot
      {"acc freebase",                    SymId::accdnCombLH2RanksEmpty },    // accordion.accFreebase
      {"acc stdbase",                     SymId::accdnCombRH4RanksEmpty },    // accordion.accStdbase
      {"acc bayanbase",                   SymId::accdnCombLH3RanksEmptySquare }, // accordion.accBayanbase
//    {"acc old ee",                      SymId::noSym },                     // accordion.accOldEE   missing in SMuFL
      {"acc discant",                     SymId::accdnCombRH3RanksEmpty },    // accordion.accDiscant
//    {"push",                            SymId::???? },                      // accordion.push
//    {"pull",                            SymId::???? },                      // accordion.pull
//    {"space",                           SymId::noSym },                     // space                punctuation missing in SMuFL?
//    {"plus",                            SymId::noSym },                     // plus                   "
//    {"comma",                           SymId::noSym },                     // comma                   "
//    {"hyphen",                          SymId::noSym },                     // hyphen                  "
//    {"period",                          SymId::noSym },                     // period                  "
      {"zero",                            SymId::timeSig0 },                  // zero
      {"one",                             SymId::timeSig1 },                  // one
      {"two",                             SymId::timeSig2 },                  // two
      {"three",                           SymId::timeSig3 },                  // three
      {"four",                            SymId::timeSig4 },                  // four
      {"five",                            SymId::timeSig5 },                  // five
      {"six",                             SymId::timeSig6 },                  // six
      {"seven",                           SymId::timeSig7 },                  // seven
      {"eight",                           SymId::timeSig8 },                  // eight
      {"nine",                            SymId::timeSig9 },                  // nine
      {"f",                               SymId::dynamicForte },              // f
      {"m",                               SymId::dynamicMezzo },              // m
      {"p",                               SymId::dynamicPiano },              // p
      {"r",                               SymId::dynamicRinforzando },        // r
      {"s",                               SymId::dynamicSforzando },          // s
      {"z",                               SymId::dynamicZ },                  // z
      {"longa up alt",                    SymId::noteLongaSquareUp },         // noteheads.uM2alt
      {"longa down alt",                  SymId::noteLongaSquareDown },       // noteheads.dM2alt
      {"brevis head alt",                 SymId::noteheadDoubleWholeSquare},  // noteheads.sM1alt
      {"time sig C dot",                  SymId::mensuralProlation5 },        // timesig.Cdot
      {"time sig O",                      SymId::mensuralProlation2 },        // timesig.O
      {"time sig O cut",                  SymId::mensuralProlation3 },        // timesig.Ocut
      {"time sig O dot",                  SymId::mensuralProlation1 },        // timesig.Odot
      {"clefs.tab2",                      SymId::sixStringTabClefSerif },     // clefs.tab2  -- pre 2.0 only
};

//---------------------------------------------------------
//   commonScoreSymbols
//    subset for use in text palette, possible translations, etc
//---------------------------------------------------------

const QVector<SymId> Sym::commonScoreSymbols = {
      SymId::accidentalFlat,
      SymId::accidentalNatural,
      SymId::accidentalSharp,
      SymId::accidentalDoubleFlat,
      SymId::accidentalDoubleSharp,
      SymId::metNoteWhole,
      SymId::metNoteHalfUp,
      SymId::metNoteQuarterUp,
      SymId::metNote8thUp,
      SymId::metNote16thUp,
      SymId::metNote32ndUp,
      SymId::metNote64thUp,
      SymId::metNote128thUp,
      SymId::metAugmentationDot,
      SymId::restWholeLegerLine,
      SymId::restHalfLegerLine,
      SymId::restQuarter,
      SymId::rest8th,
      SymId::rest16th,
      SymId::rest32nd,
      SymId::rest64th,
      SymId::rest128th,
      SymId::segno,
      SymId::coda,
      SymId::segnoSerpent1,
      SymId::codaSquare,
      SymId::repeat1Bar,
      SymId::repeat2Bars,
      SymId::repeat4Bars,
      SymId::gClef,
      SymId::fClef,
      SymId::cClef,
      SymId::lyricsElisionNarrow,
      SymId::lyricsElision,
      SymId::lyricsElisionWide,
      SymId::dynamicPiano,
      SymId::dynamicMezzo,
      SymId::dynamicForte,
      SymId::dynamicNiente,
      SymId::dynamicRinforzando,
      SymId::dynamicSforzando,
      SymId::dynamicZ,
      SymId::space
      };

//---------------------------------------------------------
//   userName2id
//---------------------------------------------------------

SymId Sym::userName2id(const QString& s)
      {
      int idx = 0;
      for (const char* a : symUserNames) {
            if (a && strcmp(a, qPrintable(s)) == 0)
                  return SymId(idx);
            }
      return SymId::noSym;
      }

//---------------------------------------------------------
//   GlyphKey operator==
//---------------------------------------------------------

bool GlyphKey::operator==(const GlyphKey& k) const
      {
      return (face == k.face) && (id == k.id)
         && (magX == k.magX) && (magY == k.magY) && (worldScale == k.worldScale) && (color == k.color);
      }

Sym ScoreFont::sym(SymId id) const
{
    int index = static_cast<int>(id);

    if (index >= 0 && index < _symbols.size()) {
        return _symbols[index];
    }

    return Sym();
}

//---------------------------------------------------------
//   draw
//---------------------------------------------------------

void ScoreFont::draw(SymId id, QPainter* painter, qreal mag, const QPointF& pos) const
      {
      qreal worldScale = painter->worldTransform().m11();
      draw(id, painter, mag, pos, worldScale);
      }

void ScoreFont::draw(SymId id, QPainter* painter, const QSizeF& mag, const QPointF& pos) const
      {
      qreal worldScale = painter->worldTransform().m11();
      draw(id, painter, mag, pos, worldScale);
      }

void ScoreFont::draw(SymId id, QPainter* painter, qreal mag, const QPointF& pos, qreal worldScale) const
      {
      draw(id, painter, QSizeF(mag, mag), pos, worldScale);
      }

void ScoreFont::draw(SymId id, QPainter* painter, const QSizeF& mag, const QPointF& pos, qreal worldScale) const
      {
      if (!sym(id).symList().empty()) {  // is this a compound symbol?
            draw(sym(id).symList(), painter, mag, pos);
            return;
            }
      if (!isValid(id)) {
            if (MScore::useFallbackFont && this != ScoreFont::fallbackFont())
                  fallbackFont()->draw(id, painter, mag, pos, worldScale);
            else
                  qDebug("ScoreFont::draw: invalid sym %d", int(id));
            return;
            }
      int rv = FT_Load_Glyph(face, sym(id).index(), FT_LOAD_DEFAULT);
      if (rv) {
            qDebug("load glyph id %d, failed: 0x%x", int(id), rv);
            return;
            }

      if (MScore::pdfPrinting) {
            if (font == 0) {
                  QString s(_fontPath+_filename);
                  if (-1 == QFontDatabase::addApplicationFont(s)) {
                        qDebug("Mscore: fatal error: cannot load internal font <%s>", qPrintable(s));
                        return;
                        }
                  font = new QFont;
                  font->setWeight(QFont::Normal);
                  font->setItalic(false);
                  font->setFamily(_family);
                  font->setStyleStrategy(QFont::NoFontMerging);
                  font->setHintingPreference(QFont::PreferVerticalHinting);
                  }
            qreal size = 20.0 * MScore::pixelRatio;
            font->setPointSize(size);
            QSizeF imag = QSizeF(1.0 / mag.width(), 1.0 / mag.height());
            painter->scale(mag.width(), mag.height());
            painter->setFont(*font);
            painter->drawText(QPointF(pos.x() * imag.width(), pos.y() * imag.height()), toString(id));
            painter->scale(imag.width(), imag.height());
            return;
            }

      QColor color(painter->pen().color());

      int pr           = painter->device()->devicePixelRatio();
      qreal pixelRatio = qreal(pr > 0 ? pr : 1);
      worldScale      *= pixelRatio;
//      if (worldScale < 1.0)
//            worldScale = 1.0;
      int scale16X      = lrint(worldScale * 6553.6 * mag.width() * DPI_F);
      int scale16Y      = lrint(worldScale * 6553.6 * mag.height() * DPI_F);

      GlyphKey gk(face, id, mag.width(), mag.height(), worldScale, color);
      GlyphPixmap* pm = cache->object(gk);

      if (!pm) {
            FT_Matrix matrix {
                  scale16X, 0,
                  0,       scale16Y
                  };

            FT_Glyph glyph;
            FT_Get_Glyph(face->glyph, &glyph);
            FT_Glyph_Transform(glyph, &matrix, 0);
            rv = FT_Glyph_To_Bitmap(&glyph, FT_RENDER_MODE_NORMAL, 0, 1);
            if (rv) {
                  qDebug("glyph to bitmap failed: 0x%x", rv);
                  return;
                  }

            FT_BitmapGlyph gb = (FT_BitmapGlyph)glyph;
            FT_Bitmap* bm     = &gb->bitmap;

            if (bm->width == 0 || bm->rows == 0) {
                  qDebug("zero glyph, id %d", int(id));
                  return;
                  }
            QImage img(QSize(bm->width, bm->rows), QImage::Format_ARGB32);
            img.fill(Qt::transparent);

            for (unsigned y = 0; y < bm->rows; ++y) {
                  unsigned* dst      = (unsigned*)img.scanLine(y);
                  unsigned char* src = (unsigned char*)(bm->buffer) + bm->pitch * y;
                  for (unsigned x = 0; x < bm->width; ++x) {
                        unsigned val = *src++;
                        color.setAlpha(std::min(int(val), painter->pen().color().alpha()));
                        *dst++ = color.rgba();
                        }
                  }
            pm = new GlyphPixmap;
            pm->pm = QPixmap::fromImage(img, Qt::NoFormatConversion);
            pm->pm.setDevicePixelRatio(worldScale);
            pm->offset = QPointF(qreal(gb->left), -qreal(gb->top)) / worldScale;
            if (!cache->insert(gk, pm))
                  qDebug("cannot cache glyph");
            FT_Done_Glyph(glyph);
            }
      painter->drawPixmap(pos + pm->offset, pm->pm);
      }

void ScoreFont::draw(SymId id, QPainter* painter, qreal mag, const QPointF& pos, int n) const
      {
      std::vector<SymId> d;
      for (int i = 0; i < n; ++i)
            d.push_back(id);
      draw(d, painter, mag, pos);
      }

void ScoreFont::draw(const std::vector<SymId>& ids, QPainter* p, qreal mag, const QPointF& _pos, qreal scale) const
      {
      QPointF pos(_pos);
      for (SymId id : ids) {
            draw(id, p, mag, pos, scale);
            pos.rx() += advance(id, mag);
            }
      }

void ScoreFont::draw(const std::vector<SymId>& ids, QPainter* p, const QSizeF& mag, const QPointF& _pos) const
      {
      qreal scale = p->worldTransform().m11();
      draw(ids, p, mag, _pos, scale);
      }

void ScoreFont::draw(const std::vector<SymId>& ids, QPainter* p, const QSizeF& mag, const QPointF& _pos, qreal scale) const
      {
      QPointF pos(_pos);
      for (SymId id : ids) {
            draw(id, p, mag, pos, scale);
            pos.rx() += (sym(id).advance() * mag.width());
            }
      }

void ScoreFont::draw(const std::vector<SymId>& ids, QPainter* p, qreal mag, const QPointF& _pos) const
      {
      qreal scale = p->worldTransform().m11();
      draw(ids, p, mag, _pos, scale);
      }


//---------------------------------------------------------
//   id2name
//---------------------------------------------------------

const char* Sym::id2name(SymId id)
      {
      return symNames[int(id)];
      }

//---------------------------------------------------------
//   initScoreFonts
//    load default score font
//---------------------------------------------------------

void initScoreFonts()
      {
      QJsonObject glyphNamesJson(ScoreFont::initGlyphNamesJson());
      if (glyphNamesJson.empty())
            qFatal("initGlyphNamesJson failed");
      int error = FT_Init_FreeType(&ftlib);
      if (!ftlib || error)
            qFatal("init freetype library failed");
      for (size_t i = 0; i < Sym::symNames.size(); ++i) {
            const char* name = Sym::symNames[i];
            Sym::lnhash.insert(name, SymId(i));
            bool ok;
            uint code = glyphNamesJson.value(name).toObject().value("codepoint").toString().midRef(2).toUInt(&ok, 16);
            if (ok)
                  ScoreFont::_mainSymCodeTable[i] = code;
            else if (MScore::debugMode)
                  qDebug("codepoint not recognized for glyph %s", qPrintable(name));
            }
      for (oldName i : qAsConst(oldNames))
            Sym::lonhash.insert(i.name, SymId(i.symId));
      QFont::insertSubstitution("Leland Text",    "Bravura Text");
      QFont::insertSubstitution("Bravura Text",   "Leland Text");
      QFont::insertSubstitution("MScore Text",    "Leland Text");
      QFont::insertSubstitution("Gootville Text", "Leland Text");
      QFont::insertSubstitution("MuseJazz Text",  "Leland Text");
      QFont::insertSubstitution("Petaluma Text",  "MuseJazz Text");
      QFont::insertSubstitution("ScoreFont",      "Leland Text"); // alias for current Musical Text Font
      ScoreFont::fallbackFont();   // load fallback font
      }

//---------------------------------------------------------
//   codeToString
//---------------------------------------------------------

static QString codeToString(uint code)
      {
      return QString::fromUcs4(&code, 1);
      }

//---------------------------------------------------------
//   toString
//---------------------------------------------------------

QString ScoreFont::toString(SymId id) const
      {
      const Sym& s = sym(id);
      int code;
      if (s.isValid())
            code = s.code();
      else {
            // fallback: search in the common SMuFL table
            code = _mainSymCodeTable[size_t(id)];
            }
      return codeToString(code);
      }

//---------------------------------------------------------
//   computeMetrics
//---------------------------------------------------------

void ScoreFont::computeMetrics(Sym* sym, int code)
      {
      FT_UInt index = FT_Get_Char_Index(face, code);
      if (index != 0) {
            if (FT_Load_Glyph(face, index, FT_LOAD_DEFAULT) == 0) {
                  FT_BBox bb;
                  if (FT_Outline_Get_BBox(&face->glyph->outline, &bb) == 0) {
                        constexpr double m = 640.0 / DPI_F;
                        QRectF bbox;
                        bbox.setCoords(bb.xMin/m, -bb.yMax/m, bb.xMax/m, -bb.yMin/m);
                        sym->setIndex(index);
                        sym->setCode(code);
                        sym->setBbox(bbox);
                        sym->setAdvance(face->glyph->linearHoriAdvance * DPI_F/ 655360.0);
                        }
                  }
            else
                  qDebug("load glyph failed");
            }
//      else
//            qDebug("no index");
      }

//---------------------------------------------------------
//   load
//---------------------------------------------------------

void ScoreFont::load()
      {
      QString facePath = _fontPath + _filename;
      QFile f(facePath);
      if (!f.open(QIODevice::ReadOnly)) {
            qDebug("ScoreFont::load(): open failed <%s>", qPrintable(facePath));
            return;
            }
      fontImage = f.readAll();
      int rval = FT_New_Memory_Face(ftlib, (FT_Byte*)fontImage.data(), fontImage.size(), 0, &face);
      if (rval) {
            qDebug("freetype: cannot create face <%s>: %d", qPrintable(facePath), rval);
            return;
            }
      cache = new QCache<GlyphKey, GlyphPixmap>(100);

      qreal pixelSize = 200.0;
      FT_Set_Pixel_Sizes(face, 0, int(pixelSize+.5));

      for (size_t id = 0; id < _mainSymCodeTable.size(); ++id) {
            uint code = _mainSymCodeTable[id];
            if (code == 0)
                  continue;
            SymId symId = SymId(id);
            Sym* sym    = &_symbols[int(symId)];
            computeMetrics(sym, code);
            }

      QJsonParseError error;
      QFile fi(_fontPath + "metadata.json");
      if (!fi.open(QIODevice::ReadOnly))
            qDebug("ScoreFont: open glyph metadata file <%s> failed", qPrintable(fi.fileName()));
      QJsonObject metadataJson = QJsonDocument::fromJson(fi.readAll(), &error).object();
      if (error.error != QJsonParseError::NoError)
            qDebug("Json parse error in <%s>(offset: %d): %s", qPrintable(fi.fileName()),
               error.offset, qPrintable(error.errorString()));

      QJsonObject oo = metadataJson.value("glyphsWithAnchors").toObject();
      for (const auto &i : oo.keys()) {
            constexpr qreal scale = SPATIUM20;
            QJsonObject ooo = oo.value(i).toObject();
            SymId symId = Sym::lnhash.value(i, SymId::noSym);
            if (symId == SymId::noSym) {
                  // currently, Bravura contains a bunch of entries in glyphsWithAnchors
                  // for glyph names that will not be found - flag32ndUpStraight, etc.
                  //qDebug("ScoreFont: symId not found <%s> in <%s>", qPrintable(i), qPrintable(fi.fileName()));
                  continue;
                  }
            Sym* sym = &_symbols[int(symId)];
            for (const auto &j : ooo.keys()) {
                  if (j == "stemDownNW") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble();
                        qreal y = ooo.value(j).toArray().at(1).toDouble();
                        sym->setStemDownNW(QPointF(4.0 * DPI_F * x, 4.0 * DPI_F * -y));
                        }
                  else if (j == "stemUpSE") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble();
                        qreal y = ooo.value(j).toArray().at(1).toDouble();
                        sym->setStemUpSE(QPointF(4.0 * DPI_F * x, 4.0 * DPI_F * -y));
                        }
                  else if (j == "cutOutNE") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble() * scale;
                        qreal y = ooo.value(j).toArray().at(1).toDouble() * scale;
                        sym->setCutOutNE(QPointF(x, -y));
                        }
                  else if (j == "cutOutNW") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble() * scale;
                        qreal y = ooo.value(j).toArray().at(1).toDouble() * scale;
                        sym->setCutOutNW(QPointF(x, -y));
                        }
                  else if (j == "cutOutSE") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble() * scale;
                        qreal y = ooo.value(j).toArray().at(1).toDouble() * scale;
                        sym->setCutOutSE(QPointF(x, -y));
                        }
                  else if (j == "cutOutSW") {
                        qreal x = ooo.value(j).toArray().at(0).toDouble() * scale;
                        qreal y = ooo.value(j).toArray().at(1).toDouble() * scale;
                        sym->setCutOutSW(QPointF(x, -y));
                        }
                  }
            }
      oo = metadataJson.value("engravingDefaults").toObject();
      static std::list<std::pair<QString, Sid>> engravingDefaultsMapping = {
            { "staffLineThickness",            Sid::staffLineWidth },
            { "stemThickness",                 Sid::stemWidth },
            { "beamThickness",                 Sid::beamWidth },
            { "beamSpacing",                   Sid::beamDistance },
            { "legerLineThickness",            Sid::ledgerLineWidth },
            { "legerLineExtension",            Sid::ledgerLineLength },
            { "slurEndpointThickness",         Sid::SlurEndWidth },
            { "slurMidpointThickness",         Sid::SlurMidWidth },
            { "thinBarlineThickness",          Sid::barWidth },
            { "thinBarlineThickness",          Sid::doubleBarWidth },
            { "thickBarlineThickness",         Sid::endBarWidth },
            { "dashedBarlineThickness",        Sid::barWidth },
            { "barlineSeparation",             Sid::doubleBarDistance },
            { "barlineSeparation",             Sid::endBarDistance },
            { "repeatBarlineDotSeparation",    Sid::repeatBarlineDotSeparation },
            { "bracketThickness",              Sid::bracketWidth },
            { "hairpinThickness",              Sid::hairpinLineWidth },
            { "octaveLineThickness",           Sid::ottavaLineWidth },
            { "pedalLineThickness",            Sid::pedalLineWidth },
            { "repeatEndingLineThickness",     Sid::voltaLineWidth },
            { "lyricLineThickness",            Sid::lyricsLineThickness },
            { "tupletBracketThickness",        Sid::tupletBracketWidth }
            };
      for (const auto &i : oo.keys()) {
            for (auto mapping : engravingDefaultsMapping) {
                  if (i == mapping.first)
                        _engravingDefaults.push_back(std::make_pair(mapping.second, oo.value(i).toDouble()));
                  else if (i == "textEnclosureThickness")
                        _textEnclosureThickness = oo.value(i).toDouble();
                  }
            }
      _engravingDefaults.push_back(std::make_pair(Sid::MusicalTextFont, QString("%1 Text").arg(_family)));

      // create missing composed glyphs
      struct Composed {
            SymId id;
            std::vector<SymId> rids;
            } composed[] = {

            { SymId::ornamentPrallMordent,
                  {
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentMiddleVerticalStroke,
                  SymId::ornamentZigZagLineWithRightEnd
                  } },
            { SymId::ornamentUpPrall,
                  {
                  SymId::ornamentBottomLeftConcaveStroke,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineWithRightEnd
                  }},
            { SymId::ornamentUpMordent,
                  {
                  SymId::ornamentBottomLeftConcaveStroke,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentMiddleVerticalStroke,
                  SymId::ornamentZigZagLineWithRightEnd
                  }},
            { SymId::ornamentPrallDown,
                  {
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentBottomRightConcaveStroke,
                  }},
#if 0
            { SymId::ornamentDownPrall,
                  {
                  SymId::ornamentTopLeftConvexStroke,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineWithRightEnd
                  }},
#endif
            { SymId::ornamentDownMordent,
                  {
                  SymId::ornamentLeftVerticalStroke,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentMiddleVerticalStroke,
                  SymId::ornamentZigZagLineWithRightEnd
                  }},
            { SymId::ornamentPrallUp,
                  {
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentTopRightConvexStroke,
                  }},
            { SymId::ornamentLinePrall,
                  {
                  SymId::ornamentLeftVerticalStroke,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineNoRightEnd,
                  SymId::ornamentZigZagLineWithRightEnd
                  }}
            };

      for (const Composed& c : composed) {
            if (!_symbols[int(c.id)].isValid()) {
                  Sym* sym = &_symbols[int(c.id)];
                  std::vector<SymId> s;
                  for (SymId id : c.rids)
                        s.push_back(id);
                  sym->setSymList(s);
                  sym->setBbox(bbox(s, 1.0));
                  }
            }

      // access needed stylistic alternates

      struct StylisticAlternate {
            QString     key;
            QString     altKey;
            SymId       id;
            }
      alternate[] = {
                  {     QString("4stringTabClef"),
                        QString("4stringTabClefSerif"),
                        SymId::fourStringTabClefSerif
                  },
                  {     QString("6stringTabClef"),
                        QString("6stringTabClefSerif"),
                        SymId::sixStringTabClefSerif
                  },
                  {     QString("cClef"),
                        QString("cClefFrench"),
                        SymId::cClefFrench
                  },
                  {     QString("cClef"),
                        QString("cClefFrench20C"),
                        SymId::cClefFrench20C
                  },
                  {     QString("fClef"),
                        QString("fClefFrench"),
                        SymId::fClefFrench
                  },
                  {     QString("fClef"),
                        QString("fClef19thCentury"),
                        SymId::fClef19thCentury
                  },
                  {     QString("noteheadBlack"),
                        QString("noteheadBlackOversized"),
                        SymId::noteheadBlack
                  },
                  {     QString("noteheadHalf"),
                        QString("noteheadHalfOversized"),
                        SymId::noteheadHalf
                  },
                  {     QString("noteheadWhole"),
                        QString("noteheadWholeOversized"),
                        SymId::noteheadWhole
                  },
                  {     QString("noteheadDoubleWhole"),
                        QString("noteheadDoubleWholeOversized"),
                        SymId::noteheadDoubleWhole
                  },
                  {     QString("noteheadDoubleWholeSquare"),
                        QString("noteheadDoubleWholeSquareOversized"),
                        SymId::noteheadDoubleWholeSquare
                  },
                  {     QString("noteheadDoubleWhole"),
                        QString("noteheadDoubleWholeAlt"),
                        SymId::noteheadDoubleWholeAlt
                  },
                  {     QString("brace"),
                        QString("braceSmall"),
                        SymId::braceSmall
                  },
                  {     QString("brace"),
                        QString("braceLarge"),
                        SymId::braceLarge
                  },
                  {     QString("brace"),
                        QString("braceLarger"),
                        SymId::braceLarger
                  }
            };

      // find each relevant alternate in "glyphsWithAlternates" value
      QJsonObject oa = metadataJson.value("glyphsWithAlternates").toObject();
      bool ok;
      for (const StylisticAlternate& c : alternate) {
            QJsonObject::const_iterator i = oa.find(c.key);
            if (i != oa.end()) {
                  QJsonArray oaa = i.value().toObject().value("alternates").toArray();
                  // locate the relevant altKey in alternate array
                  for (const auto &j : qAsConst(oaa)) {
                        QJsonObject jo = j.toObject();
                        if (jo.value("name") == c.altKey) {
                              Sym* sym = &_symbols[int(c.id)];
                              int code = jo.value("codepoint").toString().midRef(2).toInt(&ok, 16);
                              if (ok)
                                    computeMetrics(sym, code);
                              break;
                              }
                        }
                  }
            }

      // add space symbol
      Sym* sym = &_symbols[int(SymId::space)];
      computeMetrics(sym, 32);

#if 0
      //
      // check for missing symbols
      //
      ScoreFont* fb = ScoreFont::fallbackFont();
      if (fb && fb != this) {
            for (int i = 1; i < int(SymId::lastSym); ++i) {
                  const Sym& sym = _symbols[i];
                  if (!sym.isValid()) {
                        qDebug("invalid symbol %s", Sym::id2name(SymId(i)));
                        }
                  }
            }
#endif
      }

//---------------------------------------------------------
//   fontFactory
//---------------------------------------------------------

ScoreFont* ScoreFont::fontFactory(QString s)
      {
      ScoreFont* f = 0;
      for (ScoreFont& sf : _scoreFonts) {
            if (sf.name().toLower() == s.toLower()) { // ignore letter case
                  f = &sf;
                  break;
                  }
            }
      if (!f) {
            qDebug("ScoreFont <%s> not found in list", qPrintable(s));
            for (ScoreFont& sf : _scoreFonts)
                  qDebug("   %s", qPrintable(sf.name()));
            qDebug("Using fallback font <%s> instead", qPrintable(_scoreFonts[FALLBACK_FONT].name()));
            return fallbackFont();
            }

      if (!f->face)
            f->load();
      return f;
      }

//---------------------------------------------------------
//   fallbackFont
//---------------------------------------------------------

ScoreFont* ScoreFont::fallbackFont()
      {
      ScoreFont* f = &_scoreFonts[FALLBACK_FONT];
      if (!f->face)
            f->load();
      return f;
      }

//---------------------------------------------------------
//   fallbackTextFont
//---------------------------------------------------------

const char* ScoreFont::fallbackTextFont()
      {
      return "Bravura Text";
      }

//---------------------------------------------------------
//   initGlyphNamesJson
//---------------------------------------------------------

QJsonObject ScoreFont::initGlyphNamesJson()
      {
      QFile fi(":fonts/smufl/glyphnames.json");
      if (!fi.open(QIODevice::ReadOnly)) {
            qDebug("ScoreFont: open glyph names file <%s> failed", qPrintable(fi.fileName()));
            return QJsonObject();
            }
      QJsonParseError error;
      QJsonObject glyphNamesJson = QJsonDocument::fromJson(fi.readAll(), &error).object();
      if (error.error != QJsonParseError::NoError) {
            qDebug("Json parse error in <%s>(offset: %d): %s", qPrintable(fi.fileName()),
               error.offset, qPrintable(error.errorString()));
            return QJsonObject();
            }
      fi.close();
      return glyphNamesJson;
      }

//---------------------------------------------------------
//   useFallbackFont
//---------------------------------------------------------

bool ScoreFont::useFallbackFont(SymId id) const
      {
      return MScore::useFallbackFont && !sym(id).isValid() && this != ScoreFont::fallbackFont();
      }

//---------------------------------------------------------
//   bbox
//---------------------------------------------------------

const QRectF ScoreFont::bbox(SymId id, qreal mag) const
      {
      return bbox(id, QSizeF(mag, mag));
      }

const QRectF ScoreFont::bbox(SymId id, const QSizeF& mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->bbox(id, mag.width());
      QRectF r = sym(id).bbox();
      return QRectF(r.x() * mag.width(), r.y() * mag.height(), r.width() * mag.width(), r.height() * mag.height());
      }

const QRectF ScoreFont::bbox(const std::vector<SymId>& s, qreal mag) const
      {
      return bbox(s, QSizeF(mag, mag));
      }

const QRectF ScoreFont::bbox(const std::vector<SymId>& s, const QSizeF& mag) const
      {
      QRectF r;
      QPointF pos;
      for (SymId id : s) {
            r |= bbox(id, mag).translated(pos);
            pos.rx() += advance(id, mag.width());
            }
      return r;
      }

//---------------------------------------------------------
//   advance
//---------------------------------------------------------

qreal ScoreFont::advance(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->advance(id, mag);
      return sym(id).advance() * mag;
      }

qreal ScoreFont::width(const std::vector<SymId>& s, qreal mag) const
      {
      return bbox(s, mag).width();
      }

QPointF ScoreFont::stemDownNW(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->stemDownNW(id, mag);
      return sym(id).stemDownNW() * mag;
      }

QPointF ScoreFont::stemUpSE(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->stemUpSE(id, mag);
      return sym(id).stemUpSE() * mag;
      }

QPointF ScoreFont::cutOutNE(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->cutOutNE(id, mag);
      return sym(id).cutOutNE() * mag;
      }

QPointF ScoreFont::cutOutNW(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->cutOutNW(id, mag);
      return sym(id).cutOutNW() * mag;
      }

QPointF ScoreFont::cutOutSE(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->cutOutSE(id, mag);
      return sym(id).cutOutSE() * mag;
      }

QPointF ScoreFont::cutOutSW(SymId id, qreal mag) const
      {
      if (useFallbackFont(id))
            return fallbackFont()->cutOutSW(id, mag);
      return sym(id).cutOutSW() * mag;
      }

//---------------------------------------------------------
//   ScoreFont
//---------------------------------------------------------

ScoreFont::ScoreFont(const ScoreFont& f)
      {
      face = 0;
      _symbols  = f._symbols;
      _name     = f._name;
      _family   = f._family;
      _fontPath = f._fontPath;
      _filename = f._filename;

      // fontImage;
      cache = 0;
      }

ScoreFont::~ScoreFont()
      {
      delete cache;
      }

}


