//=============================================================================
//  MuseScore
//  Music Composition & Notation
//
//  Copyright (C) 2002-2011 Werner Schweer
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2
//  as published by the Free Software Foundation and appearing in
//  the file LICENCE.GPL
//=============================================================================

#ifndef __SYM_H__
#define __SYM_H__

#include "config.h"
#include "style.h"

#include "ft2build.h"
#include FT_FREETYPE_H

// Needs to be duplicated here and in style.h since moc doesn't handle macros from #include'd files
#ifdef SCRIPT_INTERFACE
#define BEGIN_QT_REGISTERED_ENUM(Name) \
class MSQE_##Name { \
      Q_GADGET \
   public:
#define END_QT_REGISTERED_ENUM(Name) \
      Q_ENUM(Name); \
      }; \
using Name = MSQE_##Name::Name;
#else
#define BEGIN_QT_REGISTERED_ENUM(Name)
#define END_QT_REGISTERED_ENUM(Name)
#endif

namespace Ms {

//---------------------------------------------------------
//   SymId
//    must be in sync with symNames
//---------------------------------------------------------

BEGIN_QT_REGISTERED_ENUM(SymId)
enum class SymId {
      ///.\{
      noSym,

      // DO NOT edit the SMuFL standard symbol IDs (see below) manually!
      // They are generated from fonttools/smufl2sym.{bat,sh} and then
      // copied into this file!

      // SMuFL standard symbol IDs {{{
      fourStringTabClef,
      sixStringTabClef,
      accSagittal11LargeDiesisDown,
      accSagittal11LargeDiesisUp,
      accSagittal11MediumDiesisDown,
      accSagittal11MediumDiesisUp,
      accSagittal11v19LargeDiesisDown,
      accSagittal11v19LargeDiesisUp,
      accSagittal11v19MediumDiesisDown,
      accSagittal11v19MediumDiesisUp,
      accSagittal11v49CommaDown,
      accSagittal11v49CommaUp,
      accSagittal143CommaDown,
      accSagittal143CommaUp,
      accSagittal17CommaDown,
      accSagittal17CommaUp,
      accSagittal17KleismaDown,
      accSagittal17KleismaUp,
      accSagittal19CommaDown,
      accSagittal19CommaUp,
      accSagittal19SchismaDown,
      accSagittal19SchismaUp,
      accSagittal23CommaDown,
      accSagittal23CommaUp,
      accSagittal23SmallDiesisDown,
      accSagittal23SmallDiesisUp,
      accSagittal25SmallDiesisDown,
      accSagittal25SmallDiesisUp,
      accSagittal35LargeDiesisDown,
      accSagittal35LargeDiesisUp,
      accSagittal35MediumDiesisDown,
      accSagittal35MediumDiesisUp,
      accSagittal49LargeDiesisDown,
      accSagittal49LargeDiesisUp,
      accSagittal49MediumDiesisDown,
      accSagittal49MediumDiesisUp,
      accSagittal49SmallDiesisDown,
      accSagittal49SmallDiesisUp,
      accSagittal55CommaDown,
      accSagittal55CommaUp,
      accSagittal5CommaDown,
      accSagittal5CommaUp,
      accSagittal5v11SmallDiesisDown,
      accSagittal5v11SmallDiesisUp,
      accSagittal5v13LargeDiesisDown,
      accSagittal5v13LargeDiesisUp,
      accSagittal5v13MediumDiesisDown,
      accSagittal5v13MediumDiesisUp,
      accSagittal5v19CommaDown,
      accSagittal5v19CommaUp,
      accSagittal5v23SmallDiesisDown,
      accSagittal5v23SmallDiesisUp,
      accSagittal5v49MediumDiesisDown,
      accSagittal5v49MediumDiesisUp,
      accSagittal5v7KleismaDown,
      accSagittal5v7KleismaUp,
      accSagittal7CommaDown,
      accSagittal7CommaUp,
      accSagittal7v11CommaDown,
      accSagittal7v11CommaUp,
      accSagittal7v11KleismaDown,
      accSagittal7v11KleismaUp,
      accSagittal7v19CommaDown,
      accSagittal7v19CommaUp,
      accSagittalAcute,
      accSagittalDoubleFlat,
      accSagittalDoubleFlat11v49CUp,
      accSagittalDoubleFlat143CUp,
      accSagittalDoubleFlat17CUp,
      accSagittalDoubleFlat17kUp,
      accSagittalDoubleFlat19CUp,
      accSagittalDoubleFlat19sUp,
      accSagittalDoubleFlat23CUp,
      accSagittalDoubleFlat23SUp,
      accSagittalDoubleFlat25SUp,
      accSagittalDoubleFlat49SUp,
      accSagittalDoubleFlat55CUp,
      accSagittalDoubleFlat5CUp,
      accSagittalDoubleFlat5v11SUp,
      accSagittalDoubleFlat5v19CUp,
      accSagittalDoubleFlat5v23SUp,
      accSagittalDoubleFlat5v7kUp,
      accSagittalDoubleFlat7CUp,
      accSagittalDoubleFlat7v11CUp,
      accSagittalDoubleFlat7v11kUp,
      accSagittalDoubleFlat7v19CUp,
      accSagittalDoubleSharp,
      accSagittalDoubleSharp11v49CDown,
      accSagittalDoubleSharp143CDown,
      accSagittalDoubleSharp17CDown,
      accSagittalDoubleSharp17kDown,
      accSagittalDoubleSharp19CDown,
      accSagittalDoubleSharp19sDown,
      accSagittalDoubleSharp23CDown,
      accSagittalDoubleSharp23SDown,
      accSagittalDoubleSharp25SDown,
      accSagittalDoubleSharp49SDown,
      accSagittalDoubleSharp55CDown,
      accSagittalDoubleSharp5CDown,
      accSagittalDoubleSharp5v11SDown,
      accSagittalDoubleSharp5v19CDown,
      accSagittalDoubleSharp5v23SDown,
      accSagittalDoubleSharp5v7kDown,
      accSagittalDoubleSharp7CDown,
      accSagittalDoubleSharp7v11CDown,
      accSagittalDoubleSharp7v11kDown,
      accSagittalDoubleSharp7v19CDown,
      accSagittalFlat,
      accSagittalFlat11LDown,
      accSagittalFlat11MDown,
      accSagittalFlat11v19LDown,
      accSagittalFlat11v19MDown,
      accSagittalFlat11v49CDown,
      accSagittalFlat11v49CUp,
      accSagittalFlat143CDown,
      accSagittalFlat143CUp,
      accSagittalFlat17CDown,
      accSagittalFlat17CUp,
      accSagittalFlat17kDown,
      accSagittalFlat17kUp,
      accSagittalFlat19CDown,
      accSagittalFlat19CUp,
      accSagittalFlat19sDown,
      accSagittalFlat19sUp,
      accSagittalFlat23CDown,
      accSagittalFlat23CUp,
      accSagittalFlat23SDown,
      accSagittalFlat23SUp,
      accSagittalFlat25SDown,
      accSagittalFlat25SUp,
      accSagittalFlat35LDown,
      accSagittalFlat35MDown,
      accSagittalFlat49LDown,
      accSagittalFlat49MDown,
      accSagittalFlat49SDown,
      accSagittalFlat49SUp,
      accSagittalFlat55CDown,
      accSagittalFlat55CUp,
      accSagittalFlat5CDown,
      accSagittalFlat5CUp,
      accSagittalFlat5v11SDown,
      accSagittalFlat5v11SUp,
      accSagittalFlat5v13LDown,
      accSagittalFlat5v13MDown,
      accSagittalFlat5v19CDown,
      accSagittalFlat5v19CUp,
      accSagittalFlat5v23SDown,
      accSagittalFlat5v23SUp,
      accSagittalFlat5v49MDown,
      accSagittalFlat5v7kDown,
      accSagittalFlat5v7kUp,
      accSagittalFlat7CDown,
      accSagittalFlat7CUp,
      accSagittalFlat7v11CDown,
      accSagittalFlat7v11CUp,
      accSagittalFlat7v11kDown,
      accSagittalFlat7v11kUp,
      accSagittalFlat7v19CDown,
      accSagittalFlat7v19CUp,
      accSagittalGrave,
      accSagittalShaftDown,
      accSagittalShaftUp,
      accSagittalSharp,
      accSagittalSharp11LUp,
      accSagittalSharp11MUp,
      accSagittalSharp11v19LUp,
      accSagittalSharp11v19MUp,
      accSagittalSharp11v49CDown,
      accSagittalSharp11v49CUp,
      accSagittalSharp143CDown,
      accSagittalSharp143CUp,
      accSagittalSharp17CDown,
      accSagittalSharp17CUp,
      accSagittalSharp17kDown,
      accSagittalSharp17kUp,
      accSagittalSharp19CDown,
      accSagittalSharp19CUp,
      accSagittalSharp19sDown,
      accSagittalSharp19sUp,
      accSagittalSharp23CDown,
      accSagittalSharp23CUp,
      accSagittalSharp23SDown,
      accSagittalSharp23SUp,
      accSagittalSharp25SDown,
      accSagittalSharp25SUp,
      accSagittalSharp35LUp,
      accSagittalSharp35MUp,
      accSagittalSharp49LUp,
      accSagittalSharp49MUp,
      accSagittalSharp49SDown,
      accSagittalSharp49SUp,
      accSagittalSharp55CDown,
      accSagittalSharp55CUp,
      accSagittalSharp5CDown,
      accSagittalSharp5CUp,
      accSagittalSharp5v11SDown,
      accSagittalSharp5v11SUp,
      accSagittalSharp5v13LUp,
      accSagittalSharp5v13MUp,
      accSagittalSharp5v19CDown,
      accSagittalSharp5v19CUp,
      accSagittalSharp5v23SDown,
      accSagittalSharp5v23SUp,
      accSagittalSharp5v49MUp,
      accSagittalSharp5v7kDown,
      accSagittalSharp5v7kUp,
      accSagittalSharp7CDown,
      accSagittalSharp7CUp,
      accSagittalSharp7v11CDown,
      accSagittalSharp7v11CUp,
      accSagittalSharp7v11kDown,
      accSagittalSharp7v11kUp,
      accSagittalSharp7v19CDown,
      accSagittalSharp7v19CUp,
      accSagittalUnused1,
      accSagittalUnused2,
      accSagittalUnused3,
      accSagittalUnused4,
      accdnCombDot,
      accdnCombLH2RanksEmpty,
      accdnCombLH3RanksEmptySquare,
      accdnCombRH3RanksEmpty,
      accdnCombRH4RanksEmpty,
      accdnDiatonicClef,
      accdnLH2Ranks16Round,
      accdnLH2Ranks8Plus16Round,
      accdnLH2Ranks8Round,
      accdnLH2RanksFullMasterRound,
      accdnLH2RanksMasterPlus16Round,
      accdnLH2RanksMasterRound,
      accdnLH3Ranks2Plus8Square,
      accdnLH3Ranks2Square,
      accdnLH3Ranks8Square,
      accdnLH3RanksDouble8Square,
      accdnLH3RanksTuttiSquare,
      accdnPull,
      accdnPush,
      accdnRH3RanksAccordion,
      accdnRH3RanksAuthenticMusette,
      accdnRH3RanksBandoneon,
      accdnRH3RanksBassoon,
      accdnRH3RanksClarinet,
      accdnRH3RanksDoubleTremoloLower8ve,
      accdnRH3RanksDoubleTremoloUpper8ve,
      accdnRH3RanksFullFactory,
      accdnRH3RanksHarmonium,
      accdnRH3RanksImitationMusette,
      accdnRH3RanksLowerTremolo8,
      accdnRH3RanksMaster,
      accdnRH3RanksOboe,
      accdnRH3RanksOrgan,
      accdnRH3RanksPiccolo,
      accdnRH3RanksTremoloLower8ve,
      accdnRH3RanksTremoloUpper8ve,
      accdnRH3RanksTwoChoirs,
      accdnRH3RanksUpperTremolo8,
      accdnRH3RanksViolin,
      accdnRH4RanksAlto,
      accdnRH4RanksBassAlto,
      accdnRH4RanksMaster,
      accdnRH4RanksSoftBass,
      accdnRH4RanksSoftTenor,
      accdnRH4RanksSoprano,
      accdnRH4RanksTenor,
      accdnRicochet2,
      accdnRicochet3,
      accdnRicochet4,
      accdnRicochet5,
      accdnRicochet6,
      accdnRicochetStem2,
      accdnRicochetStem3,
      accdnRicochetStem4,
      accdnRicochetStem5,
      accdnRicochetStem6,
      accidental1CommaFlat,
      accidental1CommaSharp,
      accidental2CommaFlat,
      accidental2CommaSharp,
      accidental3CommaFlat,
      accidental3CommaSharp,
      accidental4CommaFlat,
      accidental5CommaSharp,
      accidentalArrowDown,
      accidentalArrowUp,
      accidentalBakiyeFlat,
      accidentalBakiyeSharp,
      accidentalBracketLeft,
      accidentalBracketRight,
      accidentalBuyukMucennebFlat,
      accidentalBuyukMucennebSharp,
      accidentalCombiningCloseCurlyBrace,
      accidentalCombiningLower17Schisma,
      accidentalCombiningLower19Schisma,
      accidentalCombiningLower23Limit29LimitComma,
      accidentalCombiningLower31Schisma,
      accidentalCombiningLower53LimitComma,
      accidentalCombiningOpenCurlyBrace,
      accidentalCombiningRaise17Schisma,
      accidentalCombiningRaise19Schisma,
      accidentalCombiningRaise23Limit29LimitComma,
      accidentalCombiningRaise31Schisma,
      accidentalCombiningRaise53LimitComma,
      accidentalCommaSlashDown,
      accidentalCommaSlashUp,
      accidentalDoubleFlat,
      accidentalDoubleFlatArabic,
      accidentalDoubleFlatEqualTempered,
      accidentalDoubleFlatOneArrowDown,
      accidentalDoubleFlatOneArrowUp,
      accidentalDoubleFlatReversed,
      accidentalDoubleFlatThreeArrowsDown,
      accidentalDoubleFlatThreeArrowsUp,
      accidentalDoubleFlatTurned,
      accidentalDoubleFlatTwoArrowsDown,
      accidentalDoubleFlatTwoArrowsUp,
      accidentalDoubleSharp,
      accidentalDoubleSharpArabic,
      accidentalDoubleSharpEqualTempered,
      accidentalDoubleSharpOneArrowDown,
      accidentalDoubleSharpOneArrowUp,
      accidentalDoubleSharpThreeArrowsDown,
      accidentalDoubleSharpThreeArrowsUp,
      accidentalDoubleSharpTwoArrowsDown,
      accidentalDoubleSharpTwoArrowsUp,
      accidentalEnharmonicAlmostEqualTo,
      accidentalEnharmonicEquals,
      accidentalEnharmonicTilde,
      accidentalFilledReversedFlatAndFlat,
      accidentalFilledReversedFlatAndFlatArrowDown,
      accidentalFilledReversedFlatAndFlatArrowUp,
      accidentalFilledReversedFlatArrowDown,
      accidentalFilledReversedFlatArrowUp,
      accidentalFiveQuarterTonesFlatArrowDown,
      accidentalFiveQuarterTonesSharpArrowUp,
      accidentalFlat,
      accidentalFlatArabic,
      accidentalFlatEqualTempered,
      accidentalFlatLoweredStockhausen,
      accidentalFlatOneArrowDown,
      accidentalFlatOneArrowUp,
      accidentalFlatRaisedStockhausen,
      accidentalFlatRepeatedLineStockhausen,
      accidentalFlatRepeatedSpaceStockhausen,
      accidentalFlatThreeArrowsDown,
      accidentalFlatThreeArrowsUp,
      accidentalFlatTurned,
      accidentalFlatTwoArrowsDown,
      accidentalFlatTwoArrowsUp,
      accidentalHalfSharpArrowDown,
      accidentalHalfSharpArrowUp,
      accidentalJohnston13,
      accidentalJohnston31,
      accidentalJohnstonDown,
      accidentalJohnstonEl,
      accidentalJohnstonMinus,
      accidentalJohnstonPlus,
      accidentalJohnstonSeven,
      accidentalJohnstonUp,
      accidentalKomaFlat,
      accidentalKomaSharp,
      accidentalKoron,
      accidentalKucukMucennebFlat,
      accidentalKucukMucennebSharp,
      accidentalLargeDoubleSharp,
      accidentalLowerOneSeptimalComma,
      accidentalLowerOneTridecimalQuartertone,
      accidentalLowerOneUndecimalQuartertone,
      accidentalLowerTwoSeptimalCommas,
      accidentalLoweredStockhausen,
      accidentalNarrowReversedFlat,
      accidentalNarrowReversedFlatAndFlat,
      accidentalNatural,
      accidentalNaturalArabic,
      accidentalNaturalEqualTempered,
      accidentalNaturalFlat,
      accidentalNaturalLoweredStockhausen,
      accidentalNaturalOneArrowDown,
      accidentalNaturalOneArrowUp,
      accidentalNaturalRaisedStockhausen,
      accidentalNaturalReversed,
      accidentalNaturalSharp,
      accidentalNaturalThreeArrowsDown,
      accidentalNaturalThreeArrowsUp,
      accidentalNaturalTwoArrowsDown,
      accidentalNaturalTwoArrowsUp,
      accidentalOneAndAHalfSharpsArrowDown,
      accidentalOneAndAHalfSharpsArrowUp,
      accidentalOneQuarterToneFlatFerneyhough,
      accidentalOneQuarterToneFlatStockhausen,
      accidentalOneQuarterToneSharpFerneyhough,
      accidentalOneQuarterToneSharpStockhausen,
      accidentalOneThirdToneFlatFerneyhough,
      accidentalOneThirdToneSharpFerneyhough,
      accidentalParensLeft,
      accidentalParensRight,
      accidentalQuarterFlatEqualTempered,
      accidentalQuarterSharpEqualTempered,
      accidentalQuarterToneFlat4,
      accidentalQuarterToneFlatArabic,
      accidentalQuarterToneFlatArrowUp,
      accidentalQuarterToneFlatFilledReversed,
      accidentalQuarterToneFlatNaturalArrowDown,
      accidentalQuarterToneFlatPenderecki,
      accidentalQuarterToneFlatStein,
      accidentalQuarterToneFlatVanBlankenburg,
      accidentalQuarterToneSharp4,
      accidentalQuarterToneSharpArabic,
      accidentalQuarterToneSharpArrowDown,
      accidentalQuarterToneSharpBusotti,
      accidentalQuarterToneSharpNaturalArrowUp,
      accidentalQuarterToneSharpStein,
      accidentalQuarterToneSharpWiggle,
      accidentalRaiseOneSeptimalComma,
      accidentalRaiseOneTridecimalQuartertone,
      accidentalRaiseOneUndecimalQuartertone,
      accidentalRaiseTwoSeptimalCommas,
      accidentalRaisedStockhausen,
      accidentalReversedFlatAndFlatArrowDown,
      accidentalReversedFlatAndFlatArrowUp,
      accidentalReversedFlatArrowDown,
      accidentalReversedFlatArrowUp,
      accidentalSharp,
      accidentalSharpArabic,
      accidentalSharpEqualTempered,
      accidentalSharpLoweredStockhausen,
      accidentalSharpOneArrowDown,
      accidentalSharpOneArrowUp,
      accidentalSharpOneHorizontalStroke,
      accidentalSharpRaisedStockhausen,
      accidentalSharpRepeatedLineStockhausen,
      accidentalSharpRepeatedSpaceStockhausen,
      accidentalSharpReversed,
      accidentalSharpSharp,
      accidentalSharpThreeArrowsDown,
      accidentalSharpThreeArrowsUp,
      accidentalSharpTwoArrowsDown,
      accidentalSharpTwoArrowsUp,
      accidentalSims12Down,
      accidentalSims12Up,
      accidentalSims4Down,
      accidentalSims4Up,
      accidentalSims6Down,
      accidentalSims6Up,
      accidentalSori,
      accidentalTavenerFlat,
      accidentalTavenerSharp,
      accidentalThreeQuarterTonesFlatArabic,
      accidentalThreeQuarterTonesFlatArrowDown,
      accidentalThreeQuarterTonesFlatArrowUp,
      accidentalThreeQuarterTonesFlatCouper,
      accidentalThreeQuarterTonesFlatGrisey,
      accidentalThreeQuarterTonesFlatTartini,
      accidentalThreeQuarterTonesFlatZimmermann,
      accidentalThreeQuarterTonesSharpArabic,
      accidentalThreeQuarterTonesSharpArrowDown,
      accidentalThreeQuarterTonesSharpArrowUp,
      accidentalThreeQuarterTonesSharpBusotti,
      accidentalThreeQuarterTonesSharpStein,
      accidentalThreeQuarterTonesSharpStockhausen,
      accidentalTripleFlat,
      accidentalTripleSharp,
      accidentalTwoThirdTonesFlatFerneyhough,
      accidentalTwoThirdTonesSharpFerneyhough,
      accidentalWilsonMinus,
      accidentalWilsonPlus,
      accidentalWyschnegradsky10TwelfthsFlat,
      accidentalWyschnegradsky10TwelfthsSharp,
      accidentalWyschnegradsky11TwelfthsFlat,
      accidentalWyschnegradsky11TwelfthsSharp,
      accidentalWyschnegradsky1TwelfthsFlat,
      accidentalWyschnegradsky1TwelfthsSharp,
      accidentalWyschnegradsky2TwelfthsFlat,
      accidentalWyschnegradsky2TwelfthsSharp,
      accidentalWyschnegradsky3TwelfthsFlat,
      accidentalWyschnegradsky3TwelfthsSharp,
      accidentalWyschnegradsky4TwelfthsFlat,
      accidentalWyschnegradsky4TwelfthsSharp,
      accidentalWyschnegradsky5TwelfthsFlat,
      accidentalWyschnegradsky5TwelfthsSharp,
      accidentalWyschnegradsky6TwelfthsFlat,
      accidentalWyschnegradsky6TwelfthsSharp,
      accidentalWyschnegradsky7TwelfthsFlat,
      accidentalWyschnegradsky7TwelfthsSharp,
      accidentalWyschnegradsky8TwelfthsFlat,
      accidentalWyschnegradsky8TwelfthsSharp,
      accidentalWyschnegradsky9TwelfthsFlat,
      accidentalWyschnegradsky9TwelfthsSharp,
      accidentalXenakisOneThirdToneSharp,
      accidentalXenakisTwoThirdTonesSharp,
      analyticsChoralmelodie,
      analyticsEndStimme,
      analyticsHauptrhythmus,
      analyticsHauptstimme,
      analyticsInversion1,
      analyticsNebenstimme,
      analyticsStartStimme,
      analyticsTheme,
      analyticsTheme1,
      analyticsThemeInversion,
      analyticsThemeRetrograde,
      analyticsThemeRetrogradeInversion,
      arpeggiatoDown,
      arpeggiatoUp,
      arrowBlackDown,
      arrowBlackDownLeft,
      arrowBlackDownRight,
      arrowBlackLeft,
      arrowBlackRight,
      arrowBlackUp,
      arrowBlackUpLeft,
      arrowBlackUpRight,
      arrowOpenDown,
      arrowOpenDownLeft,
      arrowOpenDownRight,
      arrowOpenLeft,
      arrowOpenRight,
      arrowOpenUp,
      arrowOpenUpLeft,
      arrowOpenUpRight,
      arrowWhiteDown,
      arrowWhiteDownLeft,
      arrowWhiteDownRight,
      arrowWhiteLeft,
      arrowWhiteRight,
      arrowWhiteUp,
      arrowWhiteUpLeft,
      arrowWhiteUpRight,
      arrowheadBlackDown,
      arrowheadBlackDownLeft,
      arrowheadBlackDownRight,
      arrowheadBlackLeft,
      arrowheadBlackRight,
      arrowheadBlackUp,
      arrowheadBlackUpLeft,
      arrowheadBlackUpRight,
      arrowheadOpenDown,
      arrowheadOpenDownLeft,
      arrowheadOpenDownRight,
      arrowheadOpenLeft,
      arrowheadOpenRight,
      arrowheadOpenUp,
      arrowheadOpenUpLeft,
      arrowheadOpenUpRight,
      arrowheadWhiteDown,
      arrowheadWhiteDownLeft,
      arrowheadWhiteDownRight,
      arrowheadWhiteLeft,
      arrowheadWhiteRight,
      arrowheadWhiteUp,
      arrowheadWhiteUpLeft,
      arrowheadWhiteUpRight,
      articAccentAbove,
      articAccentBelow,
      articAccentStaccatoAbove,
      articAccentStaccatoBelow,
      articLaissezVibrerAbove,
      articLaissezVibrerBelow,
      articMarcatoAbove,
      articMarcatoBelow,
      articMarcatoStaccatoAbove,
      articMarcatoStaccatoBelow,
      articMarcatoTenutoAbove,
      articMarcatoTenutoBelow,
      articSoftAccentAbove,
      articSoftAccentBelow,
      articSoftAccentStaccatoAbove,
      articSoftAccentStaccatoBelow,
      articSoftAccentTenutoAbove,
      articSoftAccentTenutoBelow,
      articSoftAccentTenutoStaccatoAbove,
      articSoftAccentTenutoStaccatoBelow,
      articStaccatissimoAbove,
      articStaccatissimoBelow,
      articStaccatissimoStrokeAbove,
      articStaccatissimoStrokeBelow,
      articStaccatissimoWedgeAbove,
      articStaccatissimoWedgeBelow,
      articStaccatoAbove,
      articStaccatoBelow,
      articStressAbove,
      articStressBelow,
      articTenutoAbove,
      articTenutoAccentAbove,
      articTenutoAccentBelow,
      articTenutoBelow,
      articTenutoStaccatoAbove,
      articTenutoStaccatoBelow,
      articUnstressAbove,
      articUnstressBelow,
      augmentationDot,
      barlineDashed,
      barlineDotted,
      barlineDouble,
      barlineFinal,
      barlineHeavy,
      barlineHeavyHeavy,
      barlineReverseFinal,
      barlineShort,
      barlineSingle,
      barlineTick,
      beamAccelRit1,
      beamAccelRit10,
      beamAccelRit11,
      beamAccelRit12,
      beamAccelRit13,
      beamAccelRit14,
      beamAccelRit15,
      beamAccelRit2,
      beamAccelRit3,
      beamAccelRit4,
      beamAccelRit5,
      beamAccelRit6,
      beamAccelRit7,
      beamAccelRit8,
      beamAccelRit9,
      beamAccelRitFinal,
      brace,
      bracket,
      bracketBottom,
      bracketTop,
      brassBend,
      brassDoitLong,
      brassDoitMedium,
      brassDoitShort,
      brassFallLipLong,
      brassFallLipMedium,
      brassFallLipShort,
      brassFallRoughLong,
      brassFallRoughMedium,
      brassFallRoughShort,
      brassFallSmoothLong,
      brassFallSmoothMedium,
      brassFallSmoothShort,
      brassFlip,
      brassHarmonMuteClosed,
      brassHarmonMuteStemHalfLeft,
      brassHarmonMuteStemHalfRight,
      brassHarmonMuteStemOpen,
      brassJazzTurn,
      brassLiftLong,
      brassLiftMedium,
      brassLiftShort,
      brassLiftSmoothLong,
      brassLiftSmoothMedium,
      brassLiftSmoothShort,
      brassMuteClosed,
      brassMuteHalfClosed,
      brassMuteOpen,
      brassPlop,
      brassScoop,
      brassSmear,
      brassValveTrill,
      breathMarkComma,
      breathMarkSalzedo,
      breathMarkTick,
      breathMarkUpbow,
      bridgeClef,
      buzzRoll,
      cClef,
      cClef8vb,
      cClefArrowDown,
      cClefArrowUp,
      cClefChange,
      cClefCombining,
      cClefReversed,
      cClefSquare,
      caesura,
      caesuraCurved,
      caesuraShort,
      caesuraThick,
      chantAccentusAbove,
      chantAccentusBelow,
      chantAuctumAsc,
      chantAuctumDesc,
      chantAugmentum,
      chantCaesura,
      chantCclef,
      chantCirculusAbove,
      chantCirculusBelow,
      chantConnectingLineAsc2nd,
      chantConnectingLineAsc3rd,
      chantConnectingLineAsc4th,
      chantConnectingLineAsc5th,
      chantConnectingLineAsc6th,
      chantCustosStemDownPosHigh,
      chantCustosStemDownPosHighest,
      chantCustosStemDownPosMiddle,
      chantCustosStemUpPosLow,
      chantCustosStemUpPosLowest,
      chantCustosStemUpPosMiddle,
      chantDeminutumLower,
      chantDeminutumUpper,
      chantDivisioFinalis,
      chantDivisioMaior,
      chantDivisioMaxima,
      chantDivisioMinima,
      chantEntryLineAsc2nd,
      chantEntryLineAsc3rd,
      chantEntryLineAsc4th,
      chantEntryLineAsc5th,
      chantEntryLineAsc6th,
      chantEpisema,
      chantFclef,
      chantIctusAbove,
      chantIctusBelow,
      chantLigaturaDesc2nd,
      chantLigaturaDesc3rd,
      chantLigaturaDesc4th,
      chantLigaturaDesc5th,
      chantOriscusAscending,
      chantOriscusDescending,
      chantOriscusLiquescens,
      chantPodatusLower,
      chantPodatusUpper,
      chantPunctum,
      chantPunctumCavum,
      chantPunctumDeminutum,
      chantPunctumInclinatum,
      chantPunctumInclinatumAuctum,
      chantPunctumInclinatumDeminutum,
      chantPunctumLinea,
      chantPunctumLineaCavum,
      chantPunctumVirga,
      chantPunctumVirgaReversed,
      chantQuilisma,
      chantSemicirculusAbove,
      chantSemicirculusBelow,
      chantStaff,
      chantStaffNarrow,
      chantStaffWide,
      chantStrophicus,
      chantStrophicusAuctus,
      chantStrophicusLiquescens2nd,
      chantStrophicusLiquescens3rd,
      chantStrophicusLiquescens4th,
      chantStrophicusLiquescens5th,
      chantVirgula,
      clef15,
      clef8,
      clefChangeCombining,
      coda,
      codaSquare,
      conductorBeat2Compound,
      conductorBeat2Simple,
      conductorBeat3Compound,
      conductorBeat3Simple,
      conductorBeat4Compound,
      conductorBeat4Simple,
      conductorLeftBeat,
      conductorRightBeat,
      conductorStrongBeat,
      conductorUnconducted,
      conductorWeakBeat,
      controlBeginBeam,
      controlBeginPhrase,
      controlBeginSlur,
      controlBeginTie,
      controlEndBeam,
      controlEndPhrase,
      controlEndSlur,
      controlEndTie,
      csymAccidentalDoubleFlat,
      csymAccidentalDoubleSharp,
      csymAccidentalFlat,
      csymAccidentalNatural,
      csymAccidentalSharp,
      csymAccidentalTripleFlat,
      csymAccidentalTripleSharp,
      csymAlteredBassSlash,
      csymAugmented,
      csymBracketLeftTall,
      csymBracketRightTall,
      csymDiagonalArrangementSlash,
      csymDiminished,
      csymHalfDiminished,
      csymMajorSeventh,
      csymMinor,
      csymParensLeftTall,
      csymParensLeftVeryTall,
      csymParensRightTall,
      csymParensRightVeryTall,
      curlewSign,
      daCapo,
      dalSegno,
      daseianExcellentes1,
      daseianExcellentes2,
      daseianExcellentes3,
      daseianExcellentes4,
      daseianFinales1,
      daseianFinales2,
      daseianFinales3,
      daseianFinales4,
      daseianGraves1,
      daseianGraves2,
      daseianGraves3,
      daseianGraves4,
      daseianResidua1,
      daseianResidua2,
      daseianSuperiores1,
      daseianSuperiores2,
      daseianSuperiores3,
      daseianSuperiores4,
      doubleLateralRollStevens,
      doubleTongueAbove,
      doubleTongueBelow,
      dynamicCombinedSeparatorColon,
      dynamicCombinedSeparatorHyphen,
      dynamicCombinedSeparatorSlash,
      dynamicCombinedSeparatorSpace,
      dynamicCrescendoHairpin,
      dynamicDiminuendoHairpin,
      dynamicFF,
      dynamicFFF,
      dynamicFFFF,
      dynamicFFFFF,
      dynamicFFFFFF,
      dynamicForte,
      dynamicFortePiano,
      dynamicForzando,
      dynamicHairpinBracketLeft,
      dynamicHairpinBracketRight,
      dynamicHairpinParenthesisLeft,
      dynamicHairpinParenthesisRight,
      dynamicMF,
      dynamicMP,
      dynamicMessaDiVoce,
      dynamicMezzo,
      dynamicNiente,
      dynamicNienteForHairpin,
      dynamicPF,
      dynamicPP,
      dynamicPPP,
      dynamicPPPP,
      dynamicPPPPP,
      dynamicPPPPPP,
      dynamicPiano,
      dynamicRinforzando,
      dynamicRinforzando1,
      dynamicRinforzando2,
      dynamicSforzando,
      dynamicSforzando1,
      dynamicSforzandoPianissimo,
      dynamicSforzandoPiano,
      dynamicSforzato,
      dynamicSforzatoFF,
      dynamicSforzatoPiano,
      dynamicZ,
      elecAudioChannelsEight,
      elecAudioChannelsFive,
      elecAudioChannelsFour,
      elecAudioChannelsOne,
      elecAudioChannelsSeven,
      elecAudioChannelsSix,
      elecAudioChannelsThreeFrontal,
      elecAudioChannelsThreeSurround,
      elecAudioChannelsTwo,
      elecAudioIn,
      elecAudioMono,
      elecAudioOut,
      elecAudioStereo,
      elecCamera,
      elecDataIn,
      elecDataOut,
      elecDisc,
      elecDownload,
      elecEject,
      elecFastForward,
      elecHeadphones,
      elecHeadset,
      elecLineIn,
      elecLineOut,
      elecLoop,
      elecLoudspeaker,
      elecMIDIController0,
      elecMIDIController100,
      elecMIDIController20,
      elecMIDIController40,
      elecMIDIController60,
      elecMIDIController80,
      elecMIDIIn,
      elecMIDIOut,
      elecMicrophone,
      elecMicrophoneMute,
      elecMicrophoneUnmute,
      elecMixingConsole,
      elecMonitor,
      elecMute,
      elecPause,
      elecPlay,
      elecPowerOnOff,
      elecProjector,
      elecReplay,
      elecRewind,
      elecShuffle,
      elecSkipBackwards,
      elecSkipForwards,
      elecStop,
      elecTape,
      elecUSB,
      elecUnmute,
      elecUpload,
      elecVideoCamera,
      elecVideoIn,
      elecVideoOut,
      elecVolumeFader,
      elecVolumeFaderThumb,
      elecVolumeLevel0,
      elecVolumeLevel100,
      elecVolumeLevel20,
      elecVolumeLevel40,
      elecVolumeLevel60,
      elecVolumeLevel80,
      fClef,
      fClef15ma,
      fClef15mb,
      fClef8va,
      fClef8vb,
      fClefArrowDown,
      fClefArrowUp,
      fClefChange,
      fClefReversed,
      fClefTurned,
      fermataAbove,
      fermataBelow,
      fermataLongAbove,
      fermataLongBelow,
      fermataLongHenzeAbove,
      fermataLongHenzeBelow,
      fermataShortAbove,
      fermataShortBelow,
      fermataShortHenzeAbove,
      fermataShortHenzeBelow,
      fermataVeryLongAbove,
      fermataVeryLongBelow,
      fermataVeryShortAbove,
      fermataVeryShortBelow,
      figbass0,
      figbass1,
      figbass2,
      figbass2Raised,
      figbass3,
      figbass4,
      figbass4Raised,
      figbass5,
      figbass5Raised1,
      figbass5Raised2,
      figbass5Raised3,
      figbass6,
      figbass6Raised,
      figbass6Raised2,
      figbass7,
      figbass7Diminished,
      figbass7Raised1,
      figbass7Raised2,
      figbass8,
      figbass9,
      figbass9Raised,
      figbassBracketLeft,
      figbassBracketRight,
      figbassCombiningLowering,
      figbassCombiningRaising,
      figbassDoubleFlat,
      figbassDoubleSharp,
      figbassFlat,
      figbassNatural,
      figbassParensLeft,
      figbassParensRight,
      figbassPlus,
      figbassSharp,
      fingering0,
      fingering0Italic,
      fingering1,
      fingering1Italic,
      fingering2,
      fingering2Italic,
      fingering3,
      fingering3Italic,
      fingering4,
      fingering4Italic,
      fingering5,
      fingering5Italic,
      fingering6,
      fingering6Italic,
      fingering7,
      fingering7Italic,
      fingering8,
      fingering8Italic,
      fingering9,
      fingering9Italic,
      fingeringALower,
      fingeringCLower,
      fingeringELower,
      fingeringILower,
      fingeringLeftBracket,
      fingeringLeftBracketItalic,
      fingeringLeftParenthesis,
      fingeringLeftParenthesisItalic,
      fingeringMLower,
      fingeringMultipleNotes,
      fingeringOLower,
      fingeringPLower,
      fingeringRightBracket,
      fingeringRightBracketItalic,
      fingeringRightParenthesis,
      fingeringRightParenthesisItalic,
      fingeringSeparatorMiddleDot,
      fingeringSeparatorMiddleDotWhite,
      fingeringSeparatorSlash,
      fingeringSubstitutionAbove,
      fingeringSubstitutionBelow,
      fingeringSubstitutionDash,
      fingeringTLower,
      fingeringTUpper,
      fingeringXLower,
      flag1024thDown,
      flag1024thUp,
      flag128thDown,
      flag128thUp,
      flag16thDown,
      flag16thUp,
      flag256thDown,
      flag256thUp,
      flag32ndDown,
      flag32ndUp,
      flag512thDown,
      flag512thUp,
      flag64thDown,
      flag64thUp,
      flag8thDown,
      flag8thUp,
      flagInternalDown,
      flagInternalUp,
      fretboard3String,
      fretboard3StringNut,
      fretboard4String,
      fretboard4StringNut,
      fretboard5String,
      fretboard5StringNut,
      fretboard6String,
      fretboard6StringNut,
      fretboardFilledCircle,
      fretboardO,
      fretboardX,
      functionAngleLeft,
      functionAngleRight,
      functionBracketLeft,
      functionBracketRight,
      functionDD,
      functionDLower,
      functionDUpper,
      functionEight,
      functionFUpper,
      functionFive,
      functionFour,
      functionGLower,
      functionGUpper,
      functionGreaterThan,
      functionILower,
      functionIUpper,
      functionKLower,
      functionKUpper,
      functionLLower,
      functionLUpper,
      functionLessThan,
      functionMLower,
      functionMUpper,
      functionMinus,
      functionNLower,
      functionNUpper,
      functionNUpperSuperscript,
      functionNine,
      functionOne,
      functionPLower,
      functionPUpper,
      functionParensLeft,
      functionParensRight,
      functionPlus,
      functionRLower,
      functionRepetition1,
      functionRepetition2,
      functionRing,
      functionSLower,
      functionSSLower,
      functionSSUpper,
      functionSUpper,
      functionSeven,
      functionSix,
      functionSlashedDD,
      functionTLower,
      functionTUpper,
      functionThree,
      functionTwo,
      functionVLower,
      functionVUpper,
      functionZero,
      gClef,
      gClef15ma,
      gClef15mb,
      gClef8va,
      gClef8vb,
      gClef8vbCClef,
      gClef8vbOld,
      gClef8vbParens,
      gClefArrowDown,
      gClefArrowUp,
      gClefChange,
      gClefLigatedNumberAbove,
      gClefLigatedNumberBelow,
      gClefReversed,
      gClefTurned,
      glissandoDown,
      glissandoUp,
      graceNoteAcciaccaturaStemDown,
      graceNoteAcciaccaturaStemUp,
      graceNoteAppoggiaturaStemDown,
      graceNoteAppoggiaturaStemUp,
      graceNoteSlashStemDown,
      graceNoteSlashStemUp,
      guitarBarreFull,
      guitarBarreHalf,
      guitarClosePedal,
      guitarFadeIn,
      guitarFadeOut,
      guitarGolpe,
      guitarHalfOpenPedal,
      guitarLeftHandTapping,
      guitarOpenPedal,
      guitarRightHandTapping,
      guitarShake,
      guitarString0,
      guitarString1,
      guitarString2,
      guitarString3,
      guitarString4,
      guitarString5,
      guitarString6,
      guitarString7,
      guitarString8,
      guitarString9,
      guitarStrumDown,
      guitarStrumUp,
      guitarVibratoBarDip,
      guitarVibratoBarScoop,
      guitarVibratoStroke,
      guitarVolumeSwell,
      guitarWideVibratoStroke,
      handbellsBelltree,
      handbellsDamp3,
      handbellsEcho1,
      handbellsEcho2,
      handbellsGyro,
      handbellsHandMartellato,
      handbellsMalletBellOnTable,
      handbellsMalletBellSuspended,
      handbellsMalletLft,
      handbellsMartellato,
      handbellsMartellatoLift,
      handbellsMutedMartellato,
      handbellsPluckLift,
      handbellsSwing,
      handbellsSwingDown,
      handbellsSwingUp,
      handbellsTablePairBells,
      handbellsTableSingleBell,
      harpMetalRod,
      harpPedalCentered,
      harpPedalDivider,
      harpPedalLowered,
      harpPedalRaised,
      harpSalzedoAeolianAscending,
      harpSalzedoAeolianDescending,
      harpSalzedoDampAbove,
      harpSalzedoDampBelow,
      harpSalzedoDampBothHands,
      harpSalzedoDampLowStrings,
      harpSalzedoFluidicSoundsLeft,
      harpSalzedoFluidicSoundsRight,
      harpSalzedoIsolatedSounds,
      harpSalzedoMetallicSounds,
      harpSalzedoMetallicSoundsOneString,
      harpSalzedoMuffleTotally,
      harpSalzedoOboicFlux,
      harpSalzedoPlayUpperEnd,
      harpSalzedoSlideWithSuppleness,
      harpSalzedoSnareDrum,
      harpSalzedoTamTamSounds,
      harpSalzedoThunderEffect,
      harpSalzedoTimpanicSounds,
      harpSalzedoWhistlingSounds,
      harpStringNoiseStem,
      harpTuningKey,
      harpTuningKeyGlissando,
      harpTuningKeyHandle,
      harpTuningKeyShank,
      indianDrumClef,
      kahnBackChug,
      kahnBackFlap,
      kahnBackRiff,
      kahnBackRip,
      kahnBallChange,
      kahnBallDig,
      kahnBrushBackward,
      kahnBrushForward,
      kahnChug,
      kahnClap,
      kahnDoubleSnap,
      kahnDoubleWing,
      kahnDrawStep,
      kahnDrawTap,
      kahnFlam,
      kahnFlap,
      kahnFlapStep,
      kahnFlat,
      kahnFleaHop,
      kahnFleaTap,
      kahnGraceTap,
      kahnGraceTapChange,
      kahnGraceTapHop,
      kahnGraceTapStamp,
      kahnHeel,
      kahnHeelChange,
      kahnHeelClick,
      kahnHeelDrop,
      kahnHeelStep,
      kahnHeelTap,
      kahnHop,
      kahnJumpApart,
      kahnJumpTogether,
      kahnKneeInward,
      kahnKneeOutward,
      kahnLeap,
      kahnLeapFlatFoot,
      kahnLeapHeelClick,
      kahnLeftCatch,
      kahnLeftCross,
      kahnLeftFoot,
      kahnLeftToeStrike,
      kahnLeftTurn,
      kahnOverTheTop,
      kahnOverTheTopTap,
      kahnPull,
      kahnPush,
      kahnRiff,
      kahnRiffle,
      kahnRightCatch,
      kahnRightCross,
      kahnRightFoot,
      kahnRightToeStrike,
      kahnRightTurn,
      kahnRip,
      kahnRipple,
      kahnScrape,
      kahnScuff,
      kahnScuffle,
      kahnShuffle,
      kahnSlam,
      kahnSlap,
      kahnSlideStep,
      kahnSlideTap,
      kahnSnap,
      kahnStamp,
      kahnStampStamp,
      kahnStep,
      kahnStepStamp,
      kahnStomp,
      kahnStompBrush,
      kahnTap,
      kahnToe,
      kahnToeClick,
      kahnToeDrop,
      kahnToeStep,
      kahnToeTap,
      kahnTrench,
      kahnWing,
      kahnWingChange,
      kahnZank,
      kahnZink,
      keyboardBebung2DotsAbove,
      keyboardBebung2DotsBelow,
      keyboardBebung3DotsAbove,
      keyboardBebung3DotsBelow,
      keyboardBebung4DotsAbove,
      keyboardBebung4DotsBelow,
      keyboardLeftPedalPictogram,
      keyboardMiddlePedalPictogram,
      keyboardPedalD,
      keyboardPedalDot,
      keyboardPedalE,
      keyboardPedalHalf,
      keyboardPedalHalf2,
      keyboardPedalHalf3,
      keyboardPedalHeel1,
      keyboardPedalHeel2,
      keyboardPedalHeel3,
      keyboardPedalHeelToToe,
      keyboardPedalHeelToe,
      keyboardPedalHookEnd,
      keyboardPedalHookStart,
      keyboardPedalHyphen,
      keyboardPedalP,
      keyboardPedalParensLeft,
      keyboardPedalParensRight,
      keyboardPedalPed,
      keyboardPedalS,
      keyboardPedalSost,
      keyboardPedalToe1,
      keyboardPedalToe2,
      keyboardPedalToeToHeel,
      keyboardPedalUp,
      keyboardPedalUpNotch,
      keyboardPedalUpSpecial,
      keyboardPlayWithLH,
      keyboardPlayWithLHEnd,
      keyboardPlayWithRH,
      keyboardPlayWithRHEnd,
      keyboardPluckInside,
      keyboardRightPedalPictogram,
      kievanAccidentalFlat,
      kievanAccidentalSharp,
      kievanAugmentationDot,
      kievanCClef,
      kievanEndingSymbol,
      kievanNote8thStemDown,
      kievanNote8thStemUp,
      kievanNoteBeam,
      kievanNoteHalfStaffLine,
      kievanNoteHalfStaffSpace,
      kievanNoteQuarterStemDown,
      kievanNoteQuarterStemUp,
      kievanNoteReciting,
      kievanNoteWhole,
      kievanNoteWholeFinal,
      kodalyHandDo,
      kodalyHandFa,
      kodalyHandLa,
      kodalyHandMi,
      kodalyHandRe,
      kodalyHandSo,
      kodalyHandTi,
      leftRepeatSmall,
      legerLine,
      legerLineNarrow,
      legerLineWide,
      luteBarlineEndRepeat,
      luteBarlineFinal,
      luteBarlineStartRepeat,
      luteDuration16th,
      luteDuration32nd,
      luteDuration8th,
      luteDurationDoubleWhole,
      luteDurationHalf,
      luteDurationQuarter,
      luteDurationWhole,
      luteFingeringRHFirst,
      luteFingeringRHSecond,
      luteFingeringRHThird,
      luteFingeringRHThumb,
      luteFrench10thCourse,
      luteFrench7thCourse,
      luteFrench8thCourse,
      luteFrench9thCourse,
      luteFrenchAppoggiaturaAbove,
      luteFrenchAppoggiaturaBelow,
      luteFrenchFretA,
      luteFrenchFretB,
      luteFrenchFretC,
      luteFrenchFretD,
      luteFrenchFretE,
      luteFrenchFretF,
      luteFrenchFretG,
      luteFrenchFretH,
      luteFrenchFretI,
      luteFrenchFretK,
      luteFrenchFretL,
      luteFrenchFretM,
      luteFrenchFretN,
      luteFrenchMordentInverted,
      luteFrenchMordentLower,
      luteFrenchMordentUpper,
      luteGermanALower,
      luteGermanAUpper,
      luteGermanBLower,
      luteGermanBUpper,
      luteGermanCLower,
      luteGermanCUpper,
      luteGermanDLower,
      luteGermanDUpper,
      luteGermanELower,
      luteGermanEUpper,
      luteGermanFLower,
      luteGermanFUpper,
      luteGermanGLower,
      luteGermanGUpper,
      luteGermanHLower,
      luteGermanHUpper,
      luteGermanILower,
      luteGermanIUpper,
      luteGermanKLower,
      luteGermanKUpper,
      luteGermanLLower,
      luteGermanLUpper,
      luteGermanMLower,
      luteGermanMUpper,
      luteGermanNLower,
      luteGermanNUpper,
      luteGermanOLower,
      luteGermanPLower,
      luteGermanQLower,
      luteGermanRLower,
      luteGermanSLower,
      luteGermanTLower,
      luteGermanVLower,
      luteGermanXLower,
      luteGermanYLower,
      luteGermanZLower,
      luteItalianClefCSolFaUt,
      luteItalianClefFFaUt,
      luteItalianFret0,
      luteItalianFret1,
      luteItalianFret2,
      luteItalianFret3,
      luteItalianFret4,
      luteItalianFret5,
      luteItalianFret6,
      luteItalianFret7,
      luteItalianFret8,
      luteItalianFret9,
      luteItalianHoldFinger,
      luteItalianHoldNote,
      luteItalianReleaseFinger,
      luteItalianTempoFast,
      luteItalianTempoNeitherFastNorSlow,
      luteItalianTempoSlow,
      luteItalianTempoSomewhatFast,
      luteItalianTempoVerySlow,
      luteItalianTimeTriple,
      luteItalianTremolo,
      luteItalianVibrato,
      luteStaff6Lines,
      luteStaff6LinesNarrow,
      luteStaff6LinesWide,
      lyricsElision,
      lyricsElisionNarrow,
      lyricsElisionWide,
      lyricsHyphenBaseline,
      lyricsHyphenBaselineNonBreaking,
      lyricsTextRepeat,
      medRenFlatHardB,
      medRenFlatSoftB,
      medRenFlatWithDot,
      medRenGClefCMN,
      medRenLiquescenceCMN,
      medRenLiquescentAscCMN,
      medRenLiquescentDescCMN,
      medRenNatural,
      medRenNaturalWithCross,
      medRenOriscusCMN,
      medRenPlicaCMN,
      medRenPunctumCMN,
      medRenQuilismaCMN,
      medRenSharpCroix,
      medRenStrophicusCMN,
      mensuralAlterationSign,
      mensuralBlackBrevis,
      mensuralBlackBrevisVoid,
      mensuralBlackDragma,
      mensuralBlackLonga,
      mensuralBlackMaxima,
      mensuralBlackMinima,
      mensuralBlackMinimaVoid,
      mensuralBlackSemibrevis,
      mensuralBlackSemibrevisCaudata,
      mensuralBlackSemibrevisOblique,
      mensuralBlackSemibrevisVoid,
      mensuralBlackSemiminima,
      mensuralCclef,
      mensuralCclefPetrucciPosHigh,
      mensuralCclefPetrucciPosHighest,
      mensuralCclefPetrucciPosLow,
      mensuralCclefPetrucciPosLowest,
      mensuralCclefPetrucciPosMiddle,
      mensuralColorationEndRound,
      mensuralColorationEndSquare,
      mensuralColorationStartRound,
      mensuralColorationStartSquare,
      mensuralCombStemDiagonal,
      mensuralCombStemDown,
      mensuralCombStemDownFlagExtended,
      mensuralCombStemDownFlagFlared,
      mensuralCombStemDownFlagFusa,
      mensuralCombStemDownFlagLeft,
      mensuralCombStemDownFlagRight,
      mensuralCombStemDownFlagSemiminima,
      mensuralCombStemUp,
      mensuralCombStemUpFlagExtended,
      mensuralCombStemUpFlagFlared,
      mensuralCombStemUpFlagFusa,
      mensuralCombStemUpFlagLeft,
      mensuralCombStemUpFlagRight,
      mensuralCombStemUpFlagSemiminima,
      mensuralCustosCheckmark,
      mensuralCustosDown,
      mensuralCustosTurn,
      mensuralCustosUp,
      mensuralFclef,
      mensuralFclefPetrucci,
      mensuralGclef,
      mensuralGclefPetrucci,
      mensuralModusImperfectumVert,
      mensuralModusPerfectumVert,
      mensuralNoteheadLongaBlack,
      mensuralNoteheadLongaBlackVoid,
      mensuralNoteheadLongaVoid,
      mensuralNoteheadLongaWhite,
      mensuralNoteheadMaximaBlack,
      mensuralNoteheadMaximaBlackVoid,
      mensuralNoteheadMaximaVoid,
      mensuralNoteheadMaximaWhite,
      mensuralNoteheadMinimaWhite,
      mensuralNoteheadSemibrevisBlack,
      mensuralNoteheadSemibrevisBlackVoid,
      mensuralNoteheadSemibrevisBlackVoidTurned,
      mensuralNoteheadSemibrevisVoid,
      mensuralNoteheadSemiminimaWhite,
      mensuralObliqueAsc2ndBlack,
      mensuralObliqueAsc2ndBlackVoid,
      mensuralObliqueAsc2ndVoid,
      mensuralObliqueAsc2ndWhite,
      mensuralObliqueAsc3rdBlack,
      mensuralObliqueAsc3rdBlackVoid,
      mensuralObliqueAsc3rdVoid,
      mensuralObliqueAsc3rdWhite,
      mensuralObliqueAsc4thBlack,
      mensuralObliqueAsc4thBlackVoid,
      mensuralObliqueAsc4thVoid,
      mensuralObliqueAsc4thWhite,
      mensuralObliqueAsc5thBlack,
      mensuralObliqueAsc5thBlackVoid,
      mensuralObliqueAsc5thVoid,
      mensuralObliqueAsc5thWhite,
      mensuralObliqueDesc2ndBlack,
      mensuralObliqueDesc2ndBlackVoid,
      mensuralObliqueDesc2ndVoid,
      mensuralObliqueDesc2ndWhite,
      mensuralObliqueDesc3rdBlack,
      mensuralObliqueDesc3rdBlackVoid,
      mensuralObliqueDesc3rdVoid,
      mensuralObliqueDesc3rdWhite,
      mensuralObliqueDesc4thBlack,
      mensuralObliqueDesc4thBlackVoid,
      mensuralObliqueDesc4thVoid,
      mensuralObliqueDesc4thWhite,
      mensuralObliqueDesc5thBlack,
      mensuralObliqueDesc5thBlackVoid,
      mensuralObliqueDesc5thVoid,
      mensuralObliqueDesc5thWhite,
      mensuralProlation1,
      mensuralProlation10,
      mensuralProlation11,
      mensuralProlation2,
      mensuralProlation3,
      mensuralProlation4,
      mensuralProlation5,
      mensuralProlation6,
      mensuralProlation7,
      mensuralProlation8,
      mensuralProlation9,
      mensuralProlationCombiningDot,
      mensuralProlationCombiningDotVoid,
      mensuralProlationCombiningStroke,
      mensuralProlationCombiningThreeDots,
      mensuralProlationCombiningThreeDotsTri,
      mensuralProlationCombiningTwoDots,
      mensuralProportion1,
      mensuralProportion2,
      mensuralProportion3,
      mensuralProportion4,
      mensuralProportionMajor,
      mensuralProportionMinor,
      mensuralProportionProportioDupla1,
      mensuralProportionProportioDupla2,
      mensuralProportionProportioQuadrupla,
      mensuralProportionProportioTripla,
      mensuralProportionTempusPerfectum,
      mensuralRestBrevis,
      mensuralRestFusa,
      mensuralRestLongaImperfecta,
      mensuralRestLongaPerfecta,
      mensuralRestMaxima,
      mensuralRestMinima,
      mensuralRestSemibrevis,
      mensuralRestSemifusa,
      mensuralRestSemiminima,
      mensuralSignumDown,
      mensuralSignumUp,
      mensuralTempusImperfectumHoriz,
      mensuralTempusPerfectumHoriz,
      mensuralWhiteBrevis,
      mensuralWhiteFusa,
      mensuralWhiteLonga,
      mensuralWhiteMaxima,
      mensuralWhiteMinima,
      mensuralWhiteSemiminima,
      metAugmentationDot,
      metNote1024thDown,
      metNote1024thUp,
      metNote128thDown,
      metNote128thUp,
      metNote16thDown,
      metNote16thUp,
      metNote256thDown,
      metNote256thUp,
      metNote32ndDown,
      metNote32ndUp,
      metNote512thDown,
      metNote512thUp,
      metNote64thDown,
      metNote64thUp,
      metNote8thDown,
      metNote8thUp,
      metNoteDoubleWhole,
      metNoteDoubleWholeSquare,
      metNoteHalfDown,
      metNoteHalfUp,
      metNoteQuarterDown,
      metNoteQuarterUp,
      metNoteWhole,
      metricModulationArrowLeft,
      metricModulationArrowRight,
      miscDoNotCopy,
      miscDoNotPhotocopy,
      miscEyeglasses,
      note1024thDown,
      note1024thUp,
      note128thDown,
      note128thUp,
      note16thDown,
      note16thUp,
      note256thDown,
      note256thUp,
      note32ndDown,
      note32ndUp,
      note512thDown,
      note512thUp,
      note64thDown,
      note64thUp,
      note8thDown,
      note8thUp,
      noteABlack,
      noteAFlatBlack,
      noteAFlatHalf,
      noteAFlatWhole,
      noteAHalf,
      noteASharpBlack,
      noteASharpHalf,
      noteASharpWhole,
      noteAWhole,
      noteBBlack,
      noteBFlatBlack,
      noteBFlatHalf,
      noteBFlatWhole,
      noteBHalf,
      noteBSharpBlack,
      noteBSharpHalf,
      noteBSharpWhole,
      noteBWhole,
      noteCBlack,
      noteCFlatBlack,
      noteCFlatHalf,
      noteCFlatWhole,
      noteCHalf,
      noteCSharpBlack,
      noteCSharpHalf,
      noteCSharpWhole,
      noteCWhole,
      noteDBlack,
      noteDFlatBlack,
      noteDFlatHalf,
      noteDFlatWhole,
      noteDHalf,
      noteDSharpBlack,
      noteDSharpHalf,
      noteDSharpWhole,
      noteDWhole,
      noteDoBlack,
      noteDoHalf,
      noteDoWhole,
      noteDoubleWhole,
      noteDoubleWholeSquare,
      noteEBlack,
      noteEFlatBlack,
      noteEFlatHalf,
      noteEFlatWhole,
      noteEHalf,
      noteESharpBlack,
      noteESharpHalf,
      noteESharpWhole,
      noteEWhole,
      noteEmptyBlack,
      noteEmptyHalf,
      noteEmptyWhole,
      noteFBlack,
      noteFFlatBlack,
      noteFFlatHalf,
      noteFFlatWhole,
      noteFHalf,
      noteFSharpBlack,
      noteFSharpHalf,
      noteFSharpWhole,
      noteFWhole,
      noteFaBlack,
      noteFaHalf,
      noteFaWhole,
      noteGBlack,
      noteGFlatBlack,
      noteGFlatHalf,
      noteGFlatWhole,
      noteGHalf,
      noteGSharpBlack,
      noteGSharpHalf,
      noteGSharpWhole,
      noteGWhole,
      noteHBlack,
      noteHHalf,
      noteHSharpBlack,
      noteHSharpHalf,
      noteHSharpWhole,
      noteHWhole,
      noteHalfDown,
      noteHalfUp,
      noteLaBlack,
      noteLaHalf,
      noteLaWhole,
      noteMiBlack,
      noteMiHalf,
      noteMiWhole,
      noteQuarterDown,
      noteQuarterUp,
      noteReBlack,
      noteReHalf,
      noteReWhole,
      noteShapeArrowheadLeftBlack,
      noteShapeArrowheadLeftDoubleWhole,
      noteShapeArrowheadLeftWhite,
      noteShapeDiamondBlack,
      noteShapeDiamondDoubleWhole,
      noteShapeDiamondWhite,
      noteShapeIsoscelesTriangleBlack,
      noteShapeIsoscelesTriangleDoubleWhole,
      noteShapeIsoscelesTriangleWhite,
      noteShapeKeystoneBlack,
      noteShapeKeystoneDoubleWhole,
      noteShapeKeystoneWhite,
      noteShapeMoonBlack,
      noteShapeMoonDoubleWhole,
      noteShapeMoonLeftBlack,
      noteShapeMoonLeftDoubleWhole,
      noteShapeMoonLeftWhite,
      noteShapeMoonWhite,
      noteShapeQuarterMoonBlack,
      noteShapeQuarterMoonDoubleWhole,
      noteShapeQuarterMoonWhite,
      noteShapeRoundBlack,
      noteShapeRoundDoubleWhole,
      noteShapeRoundWhite,
      noteShapeSquareBlack,
      noteShapeSquareDoubleWhole,
      noteShapeSquareWhite,
      noteShapeTriangleLeftBlack,
      noteShapeTriangleLeftDoubleWhole,
      noteShapeTriangleLeftWhite,
      noteShapeTriangleRightBlack,
      noteShapeTriangleRightDoubleWhole,
      noteShapeTriangleRightWhite,
      noteShapeTriangleRoundBlack,
      noteShapeTriangleRoundDoubleWhole,
      noteShapeTriangleRoundLeftBlack,
      noteShapeTriangleRoundLeftDoubleWhole,
      noteShapeTriangleRoundLeftWhite,
      noteShapeTriangleRoundWhite,
      noteShapeTriangleUpBlack,
      noteShapeTriangleUpDoubleWhole,
      noteShapeTriangleUpWhite,
      noteSiBlack,
      noteSiHalf,
      noteSiWhole,
      noteSoBlack,
      noteSoHalf,
      noteSoWhole,
      noteTiBlack,
      noteTiHalf,
      noteTiWhole,
      noteWhole,
      noteheadBlack,
      noteheadCircleSlash,
      noteheadCircleX,
      noteheadCircleXDoubleWhole,
      noteheadCircleXHalf,
      noteheadCircleXWhole,
      noteheadCircledBlack,
      noteheadCircledBlackLarge,
      noteheadCircledDoubleWhole,
      noteheadCircledDoubleWholeLarge,
      noteheadCircledHalf,
      noteheadCircledHalfLarge,
      noteheadCircledWhole,
      noteheadCircledWholeLarge,
      noteheadCircledXLarge,
      noteheadClusterDoubleWhole2nd,
      noteheadClusterDoubleWhole3rd,
      noteheadClusterDoubleWholeBottom,
      noteheadClusterDoubleWholeMiddle,
      noteheadClusterDoubleWholeTop,
      noteheadClusterHalf2nd,
      noteheadClusterHalf3rd,
      noteheadClusterHalfBottom,
      noteheadClusterHalfMiddle,
      noteheadClusterHalfTop,
      noteheadClusterQuarter2nd,
      noteheadClusterQuarter3rd,
      noteheadClusterQuarterBottom,
      noteheadClusterQuarterMiddle,
      noteheadClusterQuarterTop,
      noteheadClusterRoundBlack,
      noteheadClusterRoundWhite,
      noteheadClusterSquareBlack,
      noteheadClusterSquareWhite,
      noteheadClusterWhole2nd,
      noteheadClusterWhole3rd,
      noteheadClusterWholeBottom,
      noteheadClusterWholeMiddle,
      noteheadClusterWholeTop,
      noteheadDiamondBlack,
      noteheadDiamondBlackOld,
      noteheadDiamondBlackWide,
      noteheadDiamondClusterBlack2nd,
      noteheadDiamondClusterBlack3rd,
      noteheadDiamondClusterBlackBottom,
      noteheadDiamondClusterBlackMiddle,
      noteheadDiamondClusterBlackTop,
      noteheadDiamondClusterWhite2nd,
      noteheadDiamondClusterWhite3rd,
      noteheadDiamondClusterWhiteBottom,
      noteheadDiamondClusterWhiteMiddle,
      noteheadDiamondClusterWhiteTop,
      noteheadDiamondDoubleWhole,
      noteheadDiamondDoubleWholeOld,
      noteheadDiamondHalf,
      noteheadDiamondHalfFilled,
      noteheadDiamondHalfOld,
      noteheadDiamondHalfWide,
      noteheadDiamondOpen,
      noteheadDiamondWhite,
      noteheadDiamondWhiteWide,
      noteheadDiamondWhole,
      noteheadDiamondWholeOld,
      noteheadDoubleWhole,
      noteheadDoubleWholeSquare,
      noteheadDoubleWholeWithX,
      noteheadHalf,
      noteheadHalfFilled,
      noteheadHalfWithX,
      noteheadHeavyX,
      noteheadHeavyXHat,
      noteheadLargeArrowDownBlack,
      noteheadLargeArrowDownDoubleWhole,
      noteheadLargeArrowDownHalf,
      noteheadLargeArrowDownWhole,
      noteheadLargeArrowUpBlack,
      noteheadLargeArrowUpDoubleWhole,
      noteheadLargeArrowUpHalf,
      noteheadLargeArrowUpWhole,
      noteheadMoonBlack,
      noteheadMoonWhite,
      noteheadNull,
      noteheadParenthesis,
      noteheadParenthesisLeft,
      noteheadParenthesisRight,
      noteheadPlusBlack,
      noteheadPlusDoubleWhole,
      noteheadPlusHalf,
      noteheadPlusWhole,
      noteheadRectangularClusterBlackBottom,
      noteheadRectangularClusterBlackMiddle,
      noteheadRectangularClusterBlackTop,
      noteheadRectangularClusterWhiteBottom,
      noteheadRectangularClusterWhiteMiddle,
      noteheadRectangularClusterWhiteTop,
      noteheadRoundBlack,
      noteheadRoundBlackDoubleSlashed,
      noteheadRoundBlackLarge,
      noteheadRoundBlackSlashed,
      noteheadRoundBlackSlashedLarge,
      noteheadRoundWhite,
      noteheadRoundWhiteDoubleSlashed,
      noteheadRoundWhiteLarge,
      noteheadRoundWhiteSlashed,
      noteheadRoundWhiteSlashedLarge,
      noteheadRoundWhiteWithDot,
      noteheadRoundWhiteWithDotLarge,
      noteheadSlashDiamondWhite,
      noteheadSlashHorizontalEnds,
      noteheadSlashHorizontalEndsMuted,
      noteheadSlashVerticalEnds,
      noteheadSlashVerticalEndsMuted,
      noteheadSlashVerticalEndsSmall,
      noteheadSlashWhiteDoubleWhole,
      noteheadSlashWhiteHalf,
      noteheadSlashWhiteMuted,
      noteheadSlashWhiteWhole,
      noteheadSlashX,
      noteheadSlashedBlack1,
      noteheadSlashedBlack2,
      noteheadSlashedDoubleWhole1,
      noteheadSlashedDoubleWhole2,
      noteheadSlashedHalf1,
      noteheadSlashedHalf2,
      noteheadSlashedWhole1,
      noteheadSlashedWhole2,
      noteheadSquareBlack,
      noteheadSquareBlackLarge,
      noteheadSquareBlackWhite,
      noteheadSquareWhite,
      noteheadTriangleDownBlack,
      noteheadTriangleDownDoubleWhole,
      noteheadTriangleDownHalf,
      noteheadTriangleDownWhite,
      noteheadTriangleDownWhole,
      noteheadTriangleLeftBlack,
      noteheadTriangleLeftWhite,
      noteheadTriangleRightBlack,
      noteheadTriangleRightWhite,
      noteheadTriangleRoundDownBlack,
      noteheadTriangleRoundDownWhite,
      noteheadTriangleUpBlack,
      noteheadTriangleUpDoubleWhole,
      noteheadTriangleUpHalf,
      noteheadTriangleUpRightBlack,
      noteheadTriangleUpRightWhite,
      noteheadTriangleUpWhite,
      noteheadTriangleUpWhole,
      noteheadVoidWithX,
      noteheadWhole,
      noteheadWholeFilled,
      noteheadWholeWithX,
      noteheadXBlack,
      noteheadXDoubleWhole,
      noteheadXHalf,
      noteheadXOrnate,
      noteheadXOrnateEllipse,
      noteheadXWhole,
      octaveBaselineA,
      octaveBaselineB,
      octaveBaselineM,
      octaveBaselineV,
      octaveBassa,
      octaveLoco,
      octaveParensLeft,
      octaveParensRight,
      octaveSuperscriptA,
      octaveSuperscriptB,
      octaveSuperscriptM,
      octaveSuperscriptV,
      oneHandedRollStevens,
      organGerman2Fusae,
      organGerman2Minimae,
      organGerman2OctaveUp,
      organGerman2Semifusae,
      organGerman2Semiminimae,
      organGerman3Fusae,
      organGerman3Minimae,
      organGerman3Semifusae,
      organGerman3Semiminimae,
      organGerman4Fusae,
      organGerman4Minimae,
      organGerman4Semifusae,
      organGerman4Semiminimae,
      organGerman5Fusae,
      organGerman5Minimae,
      organGerman5Semifusae,
      organGerman5Semiminimae,
      organGerman6Fusae,
      organGerman6Minimae,
      organGerman6Semifusae,
      organGerman6Semiminimae,
      organGermanALower,
      organGermanAUpper,
      organGermanAugmentationDot,
      organGermanBLower,
      organGermanBUpper,
      organGermanBuxheimerBrevis2,
      organGermanBuxheimerBrevis3,
      organGermanBuxheimerMinimaRest,
      organGermanBuxheimerSemibrevis,
      organGermanBuxheimerSemibrevisRest,
      organGermanCLower,
      organGermanCUpper,
      organGermanCisLower,
      organGermanCisUpper,
      organGermanDLower,
      organGermanDUpper,
      organGermanDisLower,
      organGermanDisUpper,
      organGermanELower,
      organGermanEUpper,
      organGermanFLower,
      organGermanFUpper,
      organGermanFisLower,
      organGermanFisUpper,
      organGermanFusa,
      organGermanFusaRest,
      organGermanGLower,
      organGermanGUpper,
      organGermanGisLower,
      organGermanGisUpper,
      organGermanHLower,
      organGermanHUpper,
      organGermanMinima,
      organGermanMinimaRest,
      organGermanOctaveDown,
      organGermanOctaveUp,
      organGermanSemibrevis,
      organGermanSemibrevisRest,
      organGermanSemifusa,
      organGermanSemifusaRest,
      organGermanSemiminima,
      organGermanSemiminimaRest,
      organGermanTie,
      ornamentBottomLeftConcaveStroke,
      ornamentBottomLeftConcaveStrokeLarge,
      ornamentBottomLeftConvexStroke,
      ornamentBottomRightConcaveStroke,
      ornamentBottomRightConvexStroke,
      ornamentComma,
      ornamentDoubleObliqueLinesAfterNote,
      ornamentDoubleObliqueLinesBeforeNote,
      ornamentDownCurve,
      ornamentHaydn,
      ornamentHighLeftConcaveStroke,
      ornamentHighLeftConvexStroke,
      ornamentHighRightConcaveStroke,
      ornamentHighRightConvexStroke,
      ornamentHookAfterNote,
      ornamentHookBeforeNote,
      ornamentLeftFacingHalfCircle,
      ornamentLeftFacingHook,
      ornamentLeftPlus,
      ornamentLeftShakeT,
      ornamentLeftVerticalStroke,
      ornamentLeftVerticalStrokeWithCross,
      ornamentLowLeftConcaveStroke,
      ornamentLowLeftConvexStroke,
      ornamentLowRightConcaveStroke,
      ornamentLowRightConvexStroke,
      ornamentMiddleVerticalStroke,
      ornamentMordent,
      ornamentObliqueLineAfterNote,
      ornamentObliqueLineBeforeNote,
      ornamentObliqueLineHorizAfterNote,
      ornamentObliqueLineHorizBeforeNote,
      ornamentOriscus,
      ornamentPinceCouperin,
      ornamentPortDeVoixV,
      ornamentPrecompAppoggTrill,
      ornamentPrecompAppoggTrillSuffix,
      ornamentPrecompCadence,
      ornamentPrecompCadenceUpperPrefix,
      ornamentPrecompCadenceUpperPrefixTurn,
      ornamentPrecompCadenceWithTurn,
      ornamentPrecompDescendingSlide,
      ornamentPrecompDoubleCadenceLowerPrefix,
      ornamentPrecompDoubleCadenceUpperPrefix,
      ornamentPrecompDoubleCadenceUpperPrefixTurn,
      ornamentPrecompInvertedMordentUpperPrefix,
      ornamentPrecompMordentRelease,
      ornamentPrecompMordentUpperPrefix,
      ornamentPrecompPortDeVoixMordent,
      ornamentPrecompSlide,
      ornamentPrecompSlideTrillBach,
      ornamentPrecompSlideTrillDAnglebert,
      ornamentPrecompSlideTrillMarpurg,
      ornamentPrecompSlideTrillMuffat,
      ornamentPrecompSlideTrillSuffixMuffat,
      ornamentPrecompTrillLowerSuffix,
      ornamentPrecompTrillSuffixDandrieu,
      ornamentPrecompTrillWithMordent,
      ornamentPrecompTurnTrillBach,
      ornamentPrecompTurnTrillDAnglebert,
      ornamentQuilisma,
      ornamentRightFacingHalfCircle,
      ornamentRightFacingHook,
      ornamentRightVerticalStroke,
      ornamentSchleifer,
      ornamentShake3,
      ornamentShakeMuffat1,
      ornamentShortObliqueLineAfterNote,
      ornamentShortObliqueLineBeforeNote,
      ornamentShortTrill,
      ornamentTopLeftConcaveStroke,
      ornamentTopLeftConvexStroke,
      ornamentTopRightConcaveStroke,
      ornamentTopRightConvexStroke,
      ornamentTremblement,
      ornamentTremblementCouperin,
      ornamentTrill,
      ornamentTurn,
      ornamentTurnInverted,
      ornamentTurnSlash,
      ornamentTurnUp,
      ornamentTurnUpS,
      ornamentUpCurve,
      ornamentVerticalLine,
      ornamentZigZagLineNoRightEnd,
      ornamentZigZagLineWithRightEnd,
      ottava,
      ottavaAlta,
      ottavaBassa,
      ottavaBassaBa,
      ottavaBassaVb,
      pendereckiTremolo,
      pictAgogo,
      pictAlmglocken,
      pictAnvil,
      pictBambooChimes,
      pictBambooScraper,
      pictBassDrum,
      pictBassDrumOnSide,
      pictBeaterBow,
      pictBeaterBox,
      pictBeaterBrassMalletsDown,
      pictBeaterBrassMalletsLeft,
      pictBeaterBrassMalletsRight,
      pictBeaterBrassMalletsUp,
      pictBeaterCombiningDashedCircle,
      pictBeaterCombiningParentheses,
      pictBeaterDoubleBassDrumDown,
      pictBeaterDoubleBassDrumUp,
      pictBeaterFinger,
      pictBeaterFingernails,
      pictBeaterFist,
      pictBeaterGuiroScraper,
      pictBeaterHammer,
      pictBeaterHammerMetalDown,
      pictBeaterHammerMetalUp,
      pictBeaterHammerPlasticDown,
      pictBeaterHammerPlasticUp,
      pictBeaterHammerWoodDown,
      pictBeaterHammerWoodUp,
      pictBeaterHand,
      pictBeaterHardBassDrumDown,
      pictBeaterHardBassDrumUp,
      pictBeaterHardGlockenspielDown,
      pictBeaterHardGlockenspielLeft,
      pictBeaterHardGlockenspielRight,
      pictBeaterHardGlockenspielUp,
      pictBeaterHardTimpaniDown,
      pictBeaterHardTimpaniLeft,
      pictBeaterHardTimpaniRight,
      pictBeaterHardTimpaniUp,
      pictBeaterHardXylophoneDown,
      pictBeaterHardXylophoneLeft,
      pictBeaterHardXylophoneRight,
      pictBeaterHardXylophoneUp,
      pictBeaterHardYarnDown,
      pictBeaterHardYarnLeft,
      pictBeaterHardYarnRight,
      pictBeaterHardYarnUp,
      pictBeaterJazzSticksDown,
      pictBeaterJazzSticksUp,
      pictBeaterKnittingNeedle,
      pictBeaterMallet,
      pictBeaterMalletDown,
      pictBeaterMediumBassDrumDown,
      pictBeaterMediumBassDrumUp,
      pictBeaterMediumTimpaniDown,
      pictBeaterMediumTimpaniLeft,
      pictBeaterMediumTimpaniRight,
      pictBeaterMediumTimpaniUp,
      pictBeaterMediumXylophoneDown,
      pictBeaterMediumXylophoneLeft,
      pictBeaterMediumXylophoneRight,
      pictBeaterMediumXylophoneUp,
      pictBeaterMediumYarnDown,
      pictBeaterMediumYarnLeft,
      pictBeaterMediumYarnRight,
      pictBeaterMediumYarnUp,
      pictBeaterMetalBassDrumDown,
      pictBeaterMetalBassDrumUp,
      pictBeaterMetalDown,
      pictBeaterMetalHammer,
      pictBeaterMetalLeft,
      pictBeaterMetalRight,
      pictBeaterMetalUp,
      pictBeaterSnareSticksDown,
      pictBeaterSnareSticksUp,
      pictBeaterSoftBassDrumDown,
      pictBeaterSoftBassDrumUp,
      pictBeaterSoftGlockenspielDown,
      pictBeaterSoftGlockenspielLeft,
      pictBeaterSoftGlockenspielRight,
      pictBeaterSoftGlockenspielUp,
      pictBeaterSoftTimpaniDown,
      pictBeaterSoftTimpaniLeft,
      pictBeaterSoftTimpaniRight,
      pictBeaterSoftTimpaniUp,
      pictBeaterSoftXylophone,
      pictBeaterSoftXylophoneDown,
      pictBeaterSoftXylophoneLeft,
      pictBeaterSoftXylophoneRight,
      pictBeaterSoftXylophoneUp,
      pictBeaterSoftYarnDown,
      pictBeaterSoftYarnLeft,
      pictBeaterSoftYarnRight,
      pictBeaterSoftYarnUp,
      pictBeaterSpoonWoodenMallet,
      pictBeaterSuperballDown,
      pictBeaterSuperballLeft,
      pictBeaterSuperballRight,
      pictBeaterSuperballUp,
      pictBeaterTriangleDown,
      pictBeaterTrianglePlain,
      pictBeaterTriangleUp,
      pictBeaterWireBrushesDown,
      pictBeaterWireBrushesUp,
      pictBeaterWoodTimpaniDown,
      pictBeaterWoodTimpaniLeft,
      pictBeaterWoodTimpaniRight,
      pictBeaterWoodTimpaniUp,
      pictBeaterWoodXylophoneDown,
      pictBeaterWoodXylophoneLeft,
      pictBeaterWoodXylophoneRight,
      pictBeaterWoodXylophoneUp,
      pictBell,
      pictBellOfCymbal,
      pictBellPlate,
      pictBellTree,
      pictBirdWhistle,
      pictBoardClapper,
      pictBongos,
      pictBrakeDrum,
      pictCabasa,
      pictCannon,
      pictCarHorn,
      pictCastanets,
      pictCastanetsWithHandle,
      pictCelesta,
      pictCencerro,
      pictCenter1,
      pictCenter2,
      pictCenter3,
      pictChainRattle,
      pictChimes,
      pictChineseCymbal,
      pictChokeCymbal,
      pictClaves,
      pictCoins,
      pictConga,
      pictCowBell,
      pictCrashCymbals,
      pictCrotales,
      pictCrushStem,
      pictCuica,
      pictCymbalTongs,
      pictDamp1,
      pictDamp2,
      pictDamp3,
      pictDamp4,
      pictDeadNoteStem,
      pictDrumStick,
      pictDuckCall,
      pictEdgeOfCymbal,
      pictEmptyTrap,
      pictFingerCymbals,
      pictFlexatone,
      pictFootballRatchet,
      pictGlassHarmonica,
      pictGlassHarp,
      pictGlassPlateChimes,
      pictGlassTubeChimes,
      pictGlsp,
      pictGlspSmithBrindle,
      pictGobletDrum,
      pictGong,
      pictGongWithButton,
      pictGuiro,
      pictGumHardDown,
      pictGumHardLeft,
      pictGumHardRight,
      pictGumHardUp,
      pictGumMediumDown,
      pictGumMediumLeft,
      pictGumMediumRight,
      pictGumMediumUp,
      pictGumSoftDown,
      pictGumSoftLeft,
      pictGumSoftRight,
      pictGumSoftUp,
      pictHalfOpen1,
      pictHalfOpen2,
      pictHandbell,
      pictHiHat,
      pictHiHatOnStand,
      pictJawHarp,
      pictJingleBells,
      pictKlaxonHorn,
      pictLeftHandCircle,
      pictLionsRoar,
      pictLithophone,
      pictLogDrum,
      pictLotusFlute,
      pictMar,
      pictMarSmithBrindle,
      pictMaraca,
      pictMaracas,
      pictMegaphone,
      pictMetalPlateChimes,
      pictMetalTubeChimes,
      pictMusicalSaw,
      pictNormalPosition,
      pictOnRim,
      pictOpen,
      pictOpenRimShot,
      pictPistolShot,
      pictPoliceWhistle,
      pictQuijada,
      pictRainstick,
      pictRatchet,
      pictRecoReco,
      pictRightHandSquare,
      pictRim1,
      pictRim2,
      pictRim3,
      pictRimShotOnStem,
      pictSandpaperBlocks,
      pictScrapeAroundRim,
      pictScrapeAroundRimClockwise,
      pictScrapeCenterToEdge,
      pictScrapeEdgeToCenter,
      pictShellBells,
      pictShellChimes,
      pictSiren,
      pictSistrum,
      pictSizzleCymbal,
      pictSleighBell,
      pictSlideBrushOnGong,
      pictSlideWhistle,
      pictSlitDrum,
      pictSnareDrum,
      pictSnareDrumMilitary,
      pictSnareDrumSnaresOff,
      pictSteelDrums,
      pictStickShot,
      pictSuperball,
      pictSuspendedCymbal,
      pictSwishStem,
      pictTabla,
      pictTamTam,
      pictTamTamWithBeater,
      pictTambourine,
      pictTempleBlocks,
      pictTenorDrum,
      pictThundersheet,
      pictTimbales,
      pictTimpani,
      pictTomTom,
      pictTomTomChinese,
      pictTomTomIndoAmerican,
      pictTomTomJapanese,
      pictTriangle,
      pictTubaphone,
      pictTubularBells,
      pictTurnLeftStem,
      pictTurnRightLeftStem,
      pictTurnRightStem,
      pictVib,
      pictVibMotorOff,
      pictVibSmithBrindle,
      pictVibraslap,
      pictVietnameseHat,
      pictWhip,
      pictWindChimesGlass,
      pictWindMachine,
      pictWindWhistle,
      pictWoodBlock,
      pictWoundHardDown,
      pictWoundHardLeft,
      pictWoundHardRight,
      pictWoundHardUp,
      pictWoundSoftDown,
      pictWoundSoftLeft,
      pictWoundSoftRight,
      pictWoundSoftUp,
      pictXyl,
      pictXylBass,
      pictXylSmithBrindle,
      pictXylTenor,
      pictXylTenorTrough,
      pictXylTrough,
      pluckedBuzzPizzicato,
      pluckedDamp,
      pluckedDampAll,
      pluckedDampOnStem,
      pluckedFingernailFlick,
      pluckedLeftHandPizzicato,
      pluckedPlectrum,
      pluckedSnapPizzicatoAbove,
      pluckedSnapPizzicatoBelow,
      pluckedWithFingernails,
      quindicesima,
      quindicesimaAlta,
      quindicesimaBassa,
      quindicesimaBassaMb,
      repeat1Bar,
      repeat2Bars,
      repeat4Bars,
      repeatBarLowerDot,
      repeatBarSlash,
      repeatBarUpperDot,
      repeatDot,
      repeatDots,
      repeatLeft,
      repeatRight,
      repeatRightLeft,
      rest1024th,
      rest128th,
      rest16th,
      rest256th,
      rest32nd,
      rest512th,
      rest64th,
      rest8th,
      restDoubleWhole,
      restDoubleWholeLegerLine,
      restHBar,
      restHBarLeft,
      restHBarMiddle,
      restHBarRight,
      restHalf,
      restHalfLegerLine,
      restLonga,
      restMaxima,
      restQuarter,
      restQuarterOld,
      restQuarterZ,
      restWhole,
      restWholeLegerLine,
      reversedBrace,
      reversedBracketBottom,
      reversedBracketTop,
      rightRepeatSmall,
      schaefferClef,
      schaefferFClefToGClef,
      schaefferGClefToFClef,
      schaefferPreviousClef,
      segno,
      segnoSerpent1,
      segnoSerpent2,
      semipitchedPercussionClef1,
      semipitchedPercussionClef2,
      smnFlat,
      smnFlatWhite,
      smnHistoryDoubleFlat,
      smnHistoryDoubleSharp,
      smnHistoryFlat,
      smnHistorySharp,
      smnNatural,
      smnSharp,
      smnSharpDown,
      smnSharpWhite,
      smnSharpWhiteDown,
      splitBarDivider,
      staff1Line,
      staff1LineNarrow,
      staff1LineWide,
      staff2Lines,
      staff2LinesNarrow,
      staff2LinesWide,
      staff3Lines,
      staff3LinesNarrow,
      staff3LinesWide,
      staff4Lines,
      staff4LinesNarrow,
      staff4LinesWide,
      staff5Lines,
      staff5LinesNarrow,
      staff5LinesWide,
      staff6Lines,
      staff6LinesNarrow,
      staff6LinesWide,
      staffDivideArrowDown,
      staffDivideArrowUp,
      staffDivideArrowUpDown,
      staffPosLower1,
      staffPosLower2,
      staffPosLower3,
      staffPosLower4,
      staffPosLower5,
      staffPosLower6,
      staffPosLower7,
      staffPosLower8,
      staffPosRaise1,
      staffPosRaise2,
      staffPosRaise3,
      staffPosRaise4,
      staffPosRaise5,
      staffPosRaise6,
      staffPosRaise7,
      staffPosRaise8,
      stem,
      stemBowOnBridge,
      stemBowOnTailpiece,
      stemBuzzRoll,
      stemDamp,
      stemHarpStringNoise,
      stemMultiphonicsBlack,
      stemMultiphonicsBlackWhite,
      stemMultiphonicsWhite,
      stemPendereckiTremolo,
      stemRimShot,
      stemSprechgesang,
      stemSulPonticello,
      stemSussurando,
      stemSwished,
      stemVibratoPulse,
      stockhausenTremolo,
      stringsBowBehindBridge,
      stringsBowBehindBridgeFourStrings,
      stringsBowBehindBridgeOneString,
      stringsBowBehindBridgeThreeStrings,
      stringsBowBehindBridgeTwoStrings,
      stringsBowOnBridge,
      stringsBowOnTailpiece,
      stringsChangeBowDirection,
      stringsDownBow,
      stringsDownBowTurned,
      stringsFouette,
      stringsHalfHarmonic,
      stringsHarmonic,
      stringsJeteAbove,
      stringsJeteBelow,
      stringsMuteOff,
      stringsMuteOn,
      stringsOverpressureDownBow,
      stringsOverpressureNoDirection,
      stringsOverpressurePossibileDownBow,
      stringsOverpressurePossibileUpBow,
      stringsOverpressureUpBow,
      stringsThumbPosition,
      stringsThumbPositionTurned,
      stringsUpBow,
      stringsUpBowTurned,
      stringsVibratoPulse,
      systemDivider,
      systemDividerExtraLong,
      systemDividerLong,
      textAugmentationDot,
      textBlackNoteFrac16thLongStem,
      textBlackNoteFrac16thShortStem,
      textBlackNoteFrac32ndLongStem,
      textBlackNoteFrac8thLongStem,
      textBlackNoteFrac8thShortStem,
      textBlackNoteLongStem,
      textBlackNoteShortStem,
      textCont16thBeamLongStem,
      textCont16thBeamShortStem,
      textCont32ndBeamLongStem,
      textCont8thBeamLongStem,
      textCont8thBeamShortStem,
      textTie,
      textTuplet3LongStem,
      textTuplet3ShortStem,
      textTupletBracketEndLongStem,
      textTupletBracketEndShortStem,
      textTupletBracketStartLongStem,
      textTupletBracketStartShortStem,
      timeSig0,
      timeSig0Reversed,
      timeSig0Turned,
      timeSig1,
      timeSig1Reversed,
      timeSig1Turned,
      timeSig2,
      timeSig2Reversed,
      timeSig2Turned,
      timeSig3,
      timeSig3Reversed,
      timeSig3Turned,
      timeSig4,
      timeSig4Reversed,
      timeSig4Turned,
      timeSig5,
      timeSig5Reversed,
      timeSig5Turned,
      timeSig6,
      timeSig6Reversed,
      timeSig6Turned,
      timeSig7,
      timeSig7Reversed,
      timeSig7Turned,
      timeSig8,
      timeSig8Reversed,
      timeSig8Turned,
      timeSig9,
      timeSig9Reversed,
      timeSig9Turned,
      timeSigBracketLeft,
      timeSigBracketLeftSmall,
      timeSigBracketRight,
      timeSigBracketRightSmall,
      timeSigCombDenominator,
      timeSigCombNumerator,
      timeSigComma,
      timeSigCommon,
      timeSigCommonReversed,
      timeSigCommonTurned,
      timeSigCut2,
      timeSigCut3,
      timeSigCutCommon,
      timeSigCutCommonReversed,
      timeSigCutCommonTurned,
      timeSigEquals,
      timeSigFractionHalf,
      timeSigFractionOneThird,
      timeSigFractionQuarter,
      timeSigFractionThreeQuarters,
      timeSigFractionTwoThirds,
      timeSigFractionalSlash,
      timeSigMinus,
      timeSigMultiply,
      timeSigOpenPenderecki,
      timeSigParensLeft,
      timeSigParensLeftSmall,
      timeSigParensRight,
      timeSigParensRightSmall,
      timeSigPlus,
      timeSigPlusSmall,
      timeSigSlash,
      timeSigX,
      tremolo1,
      tremolo2,
      tremolo3,
      tremolo4,
      tremolo5,
      tremoloDivisiDots2,
      tremoloDivisiDots3,
      tremoloDivisiDots4,
      tremoloDivisiDots6,
      tremoloFingered1,
      tremoloFingered2,
      tremoloFingered3,
      tremoloFingered4,
      tremoloFingered5,
      tripleTongueAbove,
      tripleTongueBelow,
      tuplet0,
      tuplet1,
      tuplet2,
      tuplet3,
      tuplet4,
      tuplet5,
      tuplet6,
      tuplet7,
      tuplet8,
      tuplet9,
      tupletColon,
      unmeasuredTremolo,
      unmeasuredTremoloSimple,
      unpitchedPercussionClef1,
      unpitchedPercussionClef2,
      ventiduesima,
      ventiduesimaAlta,
      ventiduesimaBassa,
      ventiduesimaBassaMb,
      vocalFingerClickStockhausen,
      vocalHalbGesungen,
      vocalMouthClosed,
      vocalMouthOpen,
      vocalMouthPursed,
      vocalMouthSlightlyOpen,
      vocalMouthWideOpen,
      vocalNasalVoice,
      vocalSprechgesang,
      vocalTongueClickStockhausen,
      vocalTongueFingerClickStockhausen,
      vocalsSussurando,
      wiggleArpeggiatoDown,
      wiggleArpeggiatoDownArrow,
      wiggleArpeggiatoDownSwash,
      wiggleArpeggiatoUp,
      wiggleArpeggiatoUpArrow,
      wiggleArpeggiatoUpSwash,
      wiggleCircular,
      wiggleCircularConstant,
      wiggleCircularConstantFlipped,
      wiggleCircularConstantFlippedLarge,
      wiggleCircularConstantLarge,
      wiggleCircularEnd,
      wiggleCircularLarge,
      wiggleCircularLarger,
      wiggleCircularLargerStill,
      wiggleCircularLargest,
      wiggleCircularSmall,
      wiggleCircularStart,
      wiggleGlissando,
      wiggleGlissandoGroup1,
      wiggleGlissandoGroup2,
      wiggleGlissandoGroup3,
      wiggleRandom1,
      wiggleRandom2,
      wiggleRandom3,
      wiggleRandom4,
      wiggleSawtooth,
      wiggleSawtoothNarrow,
      wiggleSawtoothWide,
      wiggleSquareWave,
      wiggleSquareWaveNarrow,
      wiggleSquareWaveWide,
      wiggleTrill,
      wiggleTrillFast,
      wiggleTrillFaster,
      wiggleTrillFasterStill,
      wiggleTrillFastest,
      wiggleTrillSlow,
      wiggleTrillSlower,
      wiggleTrillSlowerStill,
      wiggleTrillSlowest,
      wiggleVIbratoLargestSlower,
      wiggleVIbratoMediumSlower,
      wiggleVibrato,
      wiggleVibratoLargeFast,
      wiggleVibratoLargeFaster,
      wiggleVibratoLargeFasterStill,
      wiggleVibratoLargeFastest,
      wiggleVibratoLargeSlow,
      wiggleVibratoLargeSlower,
      wiggleVibratoLargeSlowest,
      wiggleVibratoLargestFast,
      wiggleVibratoLargestFaster,
      wiggleVibratoLargestFasterStill,
      wiggleVibratoLargestFastest,
      wiggleVibratoLargestSlow,
      wiggleVibratoLargestSlowest,
      wiggleVibratoMediumFast,
      wiggleVibratoMediumFaster,
      wiggleVibratoMediumFasterStill,
      wiggleVibratoMediumFastest,
      wiggleVibratoMediumSlow,
      wiggleVibratoMediumSlowest,
      wiggleVibratoSmallFast,
      wiggleVibratoSmallFaster,
      wiggleVibratoSmallFasterStill,
      wiggleVibratoSmallFastest,
      wiggleVibratoSmallSlow,
      wiggleVibratoSmallSlower,
      wiggleVibratoSmallSlowest,
      wiggleVibratoSmallestFast,
      wiggleVibratoSmallestFaster,
      wiggleVibratoSmallestFasterStill,
      wiggleVibratoSmallestFastest,
      wiggleVibratoSmallestSlow,
      wiggleVibratoSmallestSlower,
      wiggleVibratoSmallestSlowest,
      wiggleVibratoStart,
      wiggleVibratoWide,
      wiggleWavy,
      wiggleWavyNarrow,
      wiggleWavyWide,
      windClosedHole,
      windFlatEmbouchure,
      windHalfClosedHole1,
      windHalfClosedHole2,
      windHalfClosedHole3,
      windLessRelaxedEmbouchure,
      windLessTightEmbouchure,
      windMouthpiecePop,
      windMultiphonicsBlackStem,
      windMultiphonicsBlackWhiteStem,
      windMultiphonicsWhiteStem,
      windOpenHole,
      windReedPositionIn,
      windReedPositionNormal,
      windReedPositionOut,
      windRelaxedEmbouchure,
      windRimOnly,
      windSharpEmbouchure,
      windStrongAirPressure,
      windThreeQuartersClosedHole,
      windTightEmbouchure,
      windTrillKey,
      windVeryTightEmbouchure,
      windWeakAirPressure,
      // SMuFL standard symbol IDs }}}

//    EXTENSIONS
//    SMuFL stylistic alternates which we need to access directly

      noteheadDoubleWholeAlt,             // double whole with double side bars
      fourStringTabClefSerif,             // TAB clef in script style
      sixStringTabClefSerif,              // TAB clef in script style
      cClefFrench,
      cClefFrench20C,
      fClefFrench,
      fClef19thCentury,
      braceSmall,
      braceLarge,
      braceLarger,

//    MuseScore-local symbols, precomposed symbols to mimic some Emmentaler glyphs

      ornamentPrallMordent,
      ornamentUpPrall,
      ornamentUpMordent,
      ornamentPrallDown,
//      ornamentDownPrall,
      ornamentDownMordent,
      ornamentPrallUp,
      ornamentLinePrall,

//    additional symbols

      noteLongaUp,
      noteLongaDown,
      noteLongaSquareUp,
      noteLongaSquareDown,
      space,

//    END OF TABLE

      lastSym
      ///\}
      };
END_QT_REGISTERED_ENUM(SymId)

//---------------------------------------------------------
//   Sym
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------

class Sym {
   protected:
      int _code = -1;
      FT_UInt _index;
      QRectF _bbox;
      qreal _advance;

      QPointF _stemDownNW;
      QPointF _stemUpSE;
      QPointF _cutOutNE;
      QPointF _cutOutNW;
      QPointF _cutOutSE;
      QPointF _cutOutSW;
      std::vector<SymId> _ids;            // not empty if this is a compound symbol

   public:
      Sym() { }

      bool isValid() const                       { return _code != -1; }

      void setSymList(const std::vector<SymId>& sl)    { _ids = sl;        }
      const std::vector<SymId>& symList() const        { return _ids;      }

      FT_UInt index() const                      { return _index;    }
      void setIndex(FT_UInt i)                   { _index = i; }

      int code() const                           { return _code;     }
      void setCode(int val)                      { _code = val;      }

      QRectF bbox() const                        { return _bbox;     }
      void setBbox(QRectF val)                   { _bbox = val;      }

      qreal advance() const                      { return _advance;  }
      void setAdvance(qreal val)                 { _advance = val;   }

      QPointF stemDownNW() const                 { return _stemDownNW;   }
      void setStemDownNW(const QPointF& r)       { _stemDownNW = r;      }
      QPointF stemUpSE() const                   { return _stemUpSE;   }
      void setStemUpSE(const QPointF& r)         { _stemUpSE = r;      }
      QPointF cutOutNE() const                   { return _cutOutNE; }
      void setCutOutNE(const QPointF& r)         { _cutOutNE = r;    }
      QPointF cutOutNW() const                   { return _cutOutNW; }
      void setCutOutNW(const QPointF& r)         { _cutOutNW = r;    }
      QPointF cutOutSE() const                   { return _cutOutSE; }
      void setCutOutSE(const QPointF& r)         { _cutOutSE = r;    }
      QPointF cutOutSW() const                   { return _cutOutSW; }
      void setCutOutSW(const QPointF& r)         { _cutOutSW = r;    }

      static SymId name2id(const QString& s)     { return lnhash.value(s, SymId::noSym); }     // return noSym if not found
      static SymId oldName2id(const QString s)   { return lonhash.value(s, SymId::noSym);}
      static const char* id2name(SymId id);

      static QString id2userName(SymId id)       { return qApp->translate("symUserNames", symUserNames[int(id)]); }
      static SymId userName2id(const QString& s);

      static const std::array<const char*, int (SymId::lastSym)+1> symNames;
      static const std::array<const char*, int(SymId::lastSym)+1> symUserNames;
      static const QVector<SymId> commonScoreSymbols;

      static QHash<QString, SymId> lnhash;
      static QHash<QString, SymId> lonhash;
      friend class ScoreFont;
      };

//---------------------------------------------------------
//   GlyphKey
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------

struct GlyphKey {
      FT_Face face;
      SymId id;
      qreal magX;
      qreal magY;
      qreal worldScale;
      QColor color;

   public:
      GlyphKey(FT_Face _f, SymId _id, float mx, float my, float s, QColor c)
         : face(_f), id(_id), magX(mx), magY(my), worldScale(s), color(c) {}
      bool operator==(const GlyphKey&) const;
      };

//---------------------------------------------------------
//   GlyphPixmap
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------

struct GlyphPixmap {
      QPixmap pm;
      QPointF offset;
      };

inline uint qHash(const GlyphKey& k)
      {
      return (int(k.id) << 16) + (int(k.magX * 100) << 8) + k.magY * 100;
      }

//---------------------------------------------------------
//   ScoreFont
///   \cond PLUGIN_API \private \endcond
//---------------------------------------------------------

class ScoreFont {
      FT_Face face = 0;
      QVector<Sym> _symbols;
      QString _name;
      QString _family;
      QString _fontPath;
      QString _filename;
      QByteArray fontImage;
      QCache<GlyphKey, GlyphPixmap>* cache { 0 };
      std::list<std::pair<Sid, QVariant>> _engravingDefaults;
      double _textEnclosureThickness = 0;
      mutable QFont* font { 0 };

      static QVector<ScoreFont> _scoreFonts;
      static std::array<uint, size_t(SymId::lastSym)+1> _mainSymCodeTable;
      void load();
      void computeMetrics(Sym* sym, int code);

   public:
      ScoreFont() {}
      ScoreFont(const ScoreFont&);
      ScoreFont(const char* n, const char* f, const char* p, const char* fn)
         : _name(n), _family(f), _fontPath(p), _filename(fn) {
            _symbols = QVector<Sym>(int(SymId::lastSym) + 1);
            }
      ~ScoreFont();

      const QString& name() const           { return _name;   }
      const QString& family() const         { return _family; }
      std::list<std::pair<Sid, QVariant>> engravingDefaults()  { return _engravingDefaults; }
      double textEnclosureThickness() { return _textEnclosureThickness; }

      QString fontPath() const { return _fontPath; }

      static ScoreFont* fontFactory(QString);
      static ScoreFont* fallbackFont();
      static const char* fallbackTextFont();
      static const QVector<ScoreFont>& scoreFonts() { return _scoreFonts; }
      static QJsonObject initGlyphNamesJson();

      QString toString(SymId) const;
      QPixmap sym2pixmap(SymId, qreal) { return QPixmap(); }      // TODOxxxx

      void draw(SymId id,                  QPainter*, const QSizeF& mag, const QPointF& pos, qreal scale) const;
      void draw(SymId id,                  QPainter*, qreal mag,         const QPointF& pos, qreal scale) const;
      void draw(SymId id,                  QPainter*, qreal mag,         const QPointF& pos) const;
      void draw(SymId id,                  QPainter*, const QSizeF& mag, const QPointF& pos) const;
      void draw(SymId id,                  QPainter*, qreal mag,         const QPointF& pos, int n) const;
      void draw(const std::vector<SymId>&, QPainter*, qreal mag,         const QPointF& pos) const;
      void draw(const std::vector<SymId>&, QPainter*, const QSizeF& mag, const QPointF& pos) const;
      void draw(const std::vector<SymId>&, QPainter*, qreal mag,         const QPointF& pos, qreal scale) const;
      void draw(const std::vector<SymId>&, QPainter*, const QSizeF& mag, const QPointF& pos, qreal scale) const;

      qreal height(SymId id, qreal mag) const         { return bbox(id, mag).height(); }
      qreal width(SymId id, qreal mag) const          { return bbox(id, mag).width();  }
      qreal advance(SymId id, qreal mag) const;
      qreal width(const std::vector<SymId>&, qreal mag) const;

      const QRectF bbox(SymId id, const QSizeF&) const;
      const QRectF bbox(SymId id, qreal mag) const;
      const QRectF bbox(const std::vector<SymId>& s, const QSizeF& mag) const;
      const QRectF bbox(const std::vector<SymId>& s, qreal mag) const;
      QPointF stemDownNW(SymId id, qreal mag) const;
      QPointF stemUpSE(SymId id, qreal mag) const;
      QPointF cutOutNE(SymId id, qreal mag) const;
      QPointF cutOutNW(SymId id, qreal mag) const;
      QPointF cutOutSE(SymId id, qreal mag) const;
      QPointF cutOutSW(SymId id, qreal mag) const;

      bool isValid(SymId id) const                    { return sym(id).isValid(); }
      bool useFallbackFont(SymId id) const;

      Sym sym(SymId id) const;

      friend void initScoreFonts();
      };

extern void initScoreFonts();

}     // namespace Ms

Q_DECLARE_METATYPE(Ms::SymId);
#endif
