# HAproxy Input Plugin

[HAproxy](http://www.haproxy.org/) input plugin gathers metrics directly from any running HAproxy instance. It can do so by using CSV generated by HAproxy status page or from admin socket(s).

### Configuration:

```toml
# SampleConfig
[[inputs.haproxy]]
  servers = ["http://1.2.3.4/haproxy?stats", "/var/run/haproxy*.sock"]
```

Server addresses need to explicitly start with 'http' if you wish to use HAproxy status page. Otherwise, address will be assumed to be an UNIX socket and protocol (if present) will be discarded.

For basic authentication you need to add username and password in the URL: `http://user:password@1.2.3.4/haproxy?stats`.

Following examples will all resolve to the same socket:
```
socket:/var/run/haproxy.sock
unix:/var/run/haproxy.sock
foo:/var/run/haproxy.sock
/var/run/haproxy.sock
```

When using socket names, wildcard expansion is supported so plugin can gather stats from multiple sockets at once.

If no servers are specified, then the default address of `http://127.0.0.1:1936/haproxy?stats` will be used.

### Measurements & Fields:

Plugin will gather measurements outlined in [HAproxy CSV format documentation](https://cbonte.github.io/haproxy-dconv/1.5/configuration.html#9.1).

### Tags:

- All measurements have the following tags:
    - server - address of server data is gathered from
    - proxy - proxy name as reported in `pxname`
	- sv - service name as reported in `svname`

