# System.Reflection.PortableExecutable

``` diff
+namespace System.Reflection.PortableExecutable {
+    public enum Characteristics : ushort {
+        AggressiveWSTrim = (ushort)16,
+        Bit32Machine = (ushort)256,
+        BytesReversedHi = (ushort)32768,
+        BytesReversedLo = (ushort)128,
+        DebugStripped = (ushort)512,
+        Dll = (ushort)8192,
+        ExecutableImage = (ushort)2,
+        LargeAddressAware = (ushort)32,
+        LineNumsStripped = (ushort)4,
+        LocalSymsStripped = (ushort)8,
+        NetRunFromSwap = (ushort)2048,
+        RelocsStripped = (ushort)1,
+        RemovableRunFromSwap = (ushort)1024,
+        System = (ushort)4096,
+        UpSystemOnly = (ushort)16384,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CodeViewDebugDirectoryData {
+        public int Age { get; }
+        public Guid Guid { get; }
+        public string Path { get; }
+    }
+    public sealed class CoffHeader {
+        public Characteristics Characteristics { get; }
+        public Machine Machine { get; }
+        public short NumberOfSections { get; }
+        public int NumberOfSymbols { get; }
+        public int PointerToSymbolTable { get; }
+        public short SizeOfOptionalHeader { get; }
+        public int TimeDateStamp { get; }
+    }
+    public enum CorFlags {
+        ILLibrary = 4,
+        ILOnly = 1,
+        NativeEntryPoint = 16,
+        Prefers32Bit = 131072,
+        Requires32Bit = 2,
+        StrongNameSigned = 8,
+        TrackDebugData = 65536,
+    }
+    public sealed class CorHeader {
+        public DirectoryEntry CodeManagerTableDirectory { get; }
+        public int EntryPointTokenOrRelativeVirtualAddress { get; }
+        public DirectoryEntry ExportAddressTableJumpsDirectory { get; }
+        public CorFlags Flags { get; }
+        public ushort MajorRuntimeVersion { get; }
+        public DirectoryEntry ManagedNativeHeaderDirectory { get; }
+        public DirectoryEntry MetadataDirectory { get; }
+        public ushort MinorRuntimeVersion { get; }
+        public DirectoryEntry ResourcesDirectory { get; }
+        public DirectoryEntry StrongNameSignatureDirectory { get; }
+        public DirectoryEntry VtableFixupsDirectory { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DebugDirectoryEntry {
+        public DebugDirectoryEntry(uint stamp, ushort majorVersion, ushort minorVersion, DebugDirectoryEntryType type, int dataSize, int dataRelativeVirtualAddress, int dataPointer);
+        public int DataPointer { get; }
+        public int DataRelativeVirtualAddress { get; }
+        public int DataSize { get; }
+        public ushort MajorVersion { get; }
+        public ushort MinorVersion { get; }
+        public uint Stamp { get; }
+        public DebugDirectoryEntryType Type { get; }
+    }
+    public enum DebugDirectoryEntryType {
+        CodeView = 2,
+        Coff = 1,
+        Reproducible = 16,
+        Unknown = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DirectoryEntry {
+        public readonly int RelativeVirtualAddress;
+        public readonly int Size;
+        public DirectoryEntry(int relativeVirtualAddress, int size);
+    }
+    public enum DllCharacteristics : ushort {
+        AppContainer = (ushort)4096,
+        DynamicBase = (ushort)64,
+        HighEntropyVirtualAddressSpace = (ushort)32,
+        NoBind = (ushort)2048,
+        NoIsolation = (ushort)512,
+        NoSeh = (ushort)1024,
+        NxCompatible = (ushort)256,
+        ProcessInit = (ushort)1,
+        ProcessTerm = (ushort)2,
+        TerminalServerAware = (ushort)32768,
+        ThreadInit = (ushort)4,
+        ThreadTerm = (ushort)8,
+        WdmDriver = (ushort)8192,
+    }
+    public enum Machine : ushort {
+        Alpha = (ushort)388,
+        Alpha64 = (ushort)644,
+        AM33 = (ushort)467,
+        Amd64 = (ushort)34404,
+        Arm = (ushort)448,
+        ArmThumb2 = (ushort)452,
+        Ebc = (ushort)3772,
+        I386 = (ushort)332,
+        IA64 = (ushort)512,
+        M32R = (ushort)36929,
+        MIPS16 = (ushort)614,
+        MipsFpu = (ushort)870,
+        MipsFpu16 = (ushort)1126,
+        PowerPC = (ushort)496,
+        PowerPCFP = (ushort)497,
+        SH3 = (ushort)418,
+        SH3Dsp = (ushort)419,
+        SH3E = (ushort)420,
+        SH4 = (ushort)422,
+        SH5 = (ushort)424,
+        Thumb = (ushort)450,
+        Tricore = (ushort)1312,
+        Unknown = (ushort)0,
+        WceMipsV2 = (ushort)361,
+    }
+    public sealed class PEHeader {
+        public int AddressOfEntryPoint { get; }
+        public int BaseOfCode { get; }
+        public int BaseOfData { get; }
+        public DirectoryEntry BaseRelocationTableDirectory { get; }
+        public DirectoryEntry BoundImportTableDirectory { get; }
+        public DirectoryEntry CertificateTableDirectory { get; }
+        public uint CheckSum { get; }
+        public DirectoryEntry CopyrightTableDirectory { get; }
+        public DirectoryEntry CorHeaderTableDirectory { get; }
+        public DirectoryEntry DebugTableDirectory { get; }
+        public DirectoryEntry DelayImportTableDirectory { get; }
+        public DllCharacteristics DllCharacteristics { get; }
+        public DirectoryEntry ExceptionTableDirectory { get; }
+        public DirectoryEntry ExportTableDirectory { get; }
+        public int FileAlignment { get; }
+        public DirectoryEntry GlobalPointerTableDirectory { get; }
+        public ulong ImageBase { get; }
+        public DirectoryEntry ImportAddressTableDirectory { get; }
+        public DirectoryEntry ImportTableDirectory { get; }
+        public DirectoryEntry LoadConfigTableDirectory { get; }
+        public PEMagic Magic { get; }
+        public ushort MajorImageVersion { get; }
+        public byte MajorLinkerVersion { get; }
+        public ushort MajorOperatingSystemVersion { get; }
+        public ushort MajorSubsystemVersion { get; }
+        public ushort MinorImageVersion { get; }
+        public byte MinorLinkerVersion { get; }
+        public ushort MinorOperatingSystemVersion { get; }
+        public ushort MinorSubsystemVersion { get; }
+        public int NumberOfRvaAndSizes { get; }
+        public DirectoryEntry ResourceTableDirectory { get; }
+        public int SectionAlignment { get; }
+        public int SizeOfCode { get; }
+        public int SizeOfHeaders { get; }
+        public ulong SizeOfHeapCommit { get; }
+        public ulong SizeOfHeapReserve { get; }
+        public int SizeOfImage { get; }
+        public int SizeOfInitializedData { get; }
+        public ulong SizeOfStackCommit { get; }
+        public ulong SizeOfStackReserve { get; }
+        public int SizeOfUninitializedData { get; }
+        public Subsystem Subsystem { get; }
+        public DirectoryEntry ThreadLocalStorageTableDirectory { get; }
+    }
+    public sealed class PEHeaders {
+        public PEHeaders(Stream peStream);
+        public PEHeaders(Stream peStream, int size);
+        public CoffHeader CoffHeader { get; }
+        public int CoffHeaderStartOffset { get; }
+        public CorHeader CorHeader { get; }
+        public int CorHeaderStartOffset { get; }
+        public bool IsCoffOnly { get; }
+        public bool IsConsoleApplication { get; }
+        public bool IsDll { get; }
+        public bool IsExe { get; }
+        public int MetadataSize { get; }
+        public int MetadataStartOffset { get; }
+        public PEHeader PEHeader { get; }
+        public int PEHeaderStartOffset { get; }
+        public ImmutableArray<SectionHeader> SectionHeaders { get; }
+        public int GetContainingSectionIndex(int relativeVirtualAddress);
+        public bool TryGetDirectoryOffset(DirectoryEntry directory, out int offset);
+    }
+    public enum PEMagic : ushort {
+        PE32 = (ushort)267,
+        PE32Plus = (ushort)523,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PEMemoryBlock {
+        public int Length { get; }
+        public unsafe byte* Pointer { get; }
+        public ImmutableArray<byte> GetContent();
+    }
+    public sealed class PEReader : IDisposable {
+        public unsafe PEReader(byte* peImage, int size);
+        public PEReader(ImmutableArray<byte> peImage);
+        public PEReader(Stream peStream);
+        public PEReader(Stream peStream, PEStreamOptions options);
+        public PEReader(Stream peStream, PEStreamOptions options, int size);
+        public bool HasMetadata { get; }
+        public bool IsEntireImageAvailable { get; }
+        public PEHeaders PEHeaders { get; }
+        public void Dispose();
+        public PEMemoryBlock GetEntireImage();
+        public PEMemoryBlock GetMetadata();
+        public PEMemoryBlock GetSectionData(int relativeVirtualAddress);
+        public CodeViewDebugDirectoryData ReadCodeViewDebugDirectoryData(DebugDirectoryEntry entry);
+        public ImmutableArray<DebugDirectoryEntry> ReadDebugDirectory();
+    }
+    public enum PEStreamOptions {
+        Default = 0,
+        LeaveOpen = 1,
+        PrefetchEntireImage = 4,
+        PrefetchMetadata = 2,
+    }
+    public enum SectionCharacteristics : uint {
+        Align1024Bytes = (uint)11534336,
+        Align128Bytes = (uint)8388608,
+        Align16Bytes = (uint)5242880,
+        Align1Bytes = (uint)1048576,
+        Align2048Bytes = (uint)12582912,
+        Align256Bytes = (uint)9437184,
+        Align2Bytes = (uint)2097152,
+        Align32Bytes = (uint)6291456,
+        Align4096Bytes = (uint)13631488,
+        Align4Bytes = (uint)3145728,
+        Align512Bytes = (uint)10485760,
+        Align64Bytes = (uint)7340032,
+        Align8192Bytes = (uint)14680064,
+        Align8Bytes = (uint)4194304,
+        AlignMask = (uint)15728640,
+        ContainsCode = (uint)32,
+        ContainsInitializedData = (uint)64,
+        ContainsUninitializedData = (uint)128,
+        GPRel = (uint)32768,
+        LinkerComdat = (uint)4096,
+        LinkerInfo = (uint)512,
+        LinkerNRelocOvfl = (uint)16777216,
+        LinkerOther = (uint)256,
+        LinkerRemove = (uint)2048,
+        Mem16Bit = (uint)131072,
+        MemDiscardable = (uint)33554432,
+        MemExecute = (uint)536870912,
+        MemFardata = (uint)32768,
+        MemLocked = (uint)262144,
+        MemNotCached = (uint)67108864,
+        MemNotPaged = (uint)134217728,
+        MemPreload = (uint)524288,
+        MemProtected = (uint)16384,
+        MemPurgeable = (uint)131072,
+        MemRead = (uint)1073741824,
+        MemShared = (uint)268435456,
+        MemSysheap = (uint)65536,
+        MemWrite = (uint)2147483648,
+        NoDeferSpecExc = (uint)16384,
+        TypeCopy = (uint)16,
+        TypeDSect = (uint)1,
+        TypeGroup = (uint)4,
+        TypeNoLoad = (uint)2,
+        TypeNoPad = (uint)8,
+        TypeOver = (uint)1024,
+        TypeReg = (uint)0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SectionHeader {
+        public string Name { get; }
+        public ushort NumberOfLineNumbers { get; }
+        public ushort NumberOfRelocations { get; }
+        public int PointerToLineNumbers { get; }
+        public int PointerToRawData { get; }
+        public int PointerToRelocations { get; }
+        public SectionCharacteristics SectionCharacteristics { get; }
+        public int SizeOfRawData { get; }
+        public int VirtualAddress { get; }
+        public int VirtualSize { get; }
+    }
+    public enum Subsystem : ushort {
+        EfiApplication = (ushort)10,
+        EfiBootServiceDriver = (ushort)11,
+        EfiRom = (ushort)13,
+        EfiRuntimeDriver = (ushort)12,
+        Native = (ushort)1,
+        NativeWindows = (ushort)8,
+        OS2Cui = (ushort)5,
+        PosixCui = (ushort)7,
+        Unknown = (ushort)0,
+        WindowsCEGui = (ushort)9,
+        WindowsCui = (ushort)3,
+        WindowsGui = (ushort)2,
+        Xbox = (ushort)14,
+    }
+}
```

