# System.Resources

``` diff
+namespace System.Resources {
+    public interface IResourceReader : IDisposable, IEnumerable {
+        new IDictionaryEnumerator GetEnumerator();
+    }
+    public class MissingManifestResourceException : Exception {
+        public MissingManifestResourceException();
+        public MissingManifestResourceException(string message);
+        public MissingManifestResourceException(string message, Exception inner);
+    }
+    public sealed class NeutralResourcesLanguageAttribute : Attribute {
+        public NeutralResourcesLanguageAttribute(string cultureName);
+        public NeutralResourcesLanguageAttribute(string cultureName, UltimateResourceFallbackLocation location);
+        public string CultureName { get; }
+        public UltimateResourceFallbackLocation Location { get; }
+    }
+    public class ResourceManager {
+        public static readonly int HeaderVersionNumber;
+        public static readonly int MagicNumber;
+        protected Assembly MainAssembly;
+        protected string BaseNameField;
+        protected ResourceManager();
+        public ResourceManager(string baseName, Assembly assembly);
+        [MethodImpl(NoInlining)]public ResourceManager(string baseName, Assembly assembly, Type usingResourceSet);
+        public ResourceManager(Type resourceSource);
+        public virtual string BaseName { get; }
+        public virtual bool IgnoreCase { get; set; }
+        public virtual Type ResourceSetType { get; }
+        protected static CultureInfo GetNeutralResourcesLanguage(Assembly a);
+        public virtual object GetObject(string name);
+        public virtual object GetObject(string name, CultureInfo culture);
+        protected virtual string GetResourceFileName(CultureInfo culture);
+        [MethodImpl(NoInlining)]public virtual ResourceSet GetResourceSet(CultureInfo culture, bool createIfNotExists, bool tryParents);
+        protected static Version GetSatelliteContractVersion(Assembly a);
+        public UnmanagedMemoryStream GetStream(string name);
+        public UnmanagedMemoryStream GetStream(string name, CultureInfo culture);
+        public string GetString(string name);
+        public virtual string GetString(string name, CultureInfo culture);
+        [MethodImpl(NoInlining)]protected virtual ResourceSet InternalGetResourceSet(CultureInfo culture, bool createIfNotExists, bool tryParents);
+        public virtual void ReleaseAllResources();
+    }
+    public sealed class ResourceReader : IDisposable {
+        public ResourceReader(Stream stream);
+        public void Dispose();
+        public IDictionaryEnumerator GetEnumerator();
+    }
+    public class ResourceSet : IDisposable, IEnumerable {
+        protected IResourceReader Reader;
+        protected ResourceSet();
+        public ResourceSet(Stream stream);
+        public ResourceSet(string fileName);
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual Type GetDefaultReader();
+        public virtual IDictionaryEnumerator GetEnumerator();
+        public virtual object GetObject(string name);
+        public virtual object GetObject(string name, bool ignoreCase);
+        public virtual string GetString(string name);
+        public virtual string GetString(string name, bool ignoreCase);
+        protected virtual void ReadResources();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class ResourceWriter : IDisposable {
+        public ResourceWriter(Stream stream);
+        public void AddResource(string name, string value);
+        public void Dispose();
+        public void Generate();
+    }
+    public sealed class SatelliteContractVersionAttribute : Attribute {
+        public SatelliteContractVersionAttribute(string version);
+        public string Version { get; }
+    }
+    public enum UltimateResourceFallbackLocation {
+        MainAssembly = 0,
+        Satellite = 1,
+    }
+}
```

