# .NET Core 2.0 December Update - December 14, 2017

.NET Core 2.0.4 and SDK 2.1.3 are available for download and usage in your environment.

* [Getting Started](https://www.microsoft.com/net/core/)
* [Downloads](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.4-download.md)

The .NET Core SDK 2.1.3 includes .NET Core 2.0.4 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1.3, the following command will show that you're running version `2.0.4` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created [dotnet/core #1172](https://github.com/dotnet/core/issues/1172) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.4 images.

## Known Issues

If you have previously installed .NET Core on Linux using the package manager (eg, apt, yum, dnf, zypper), running the package manager `update` command will show an update is available for 

## Fixes in the December 2017 Update

## CLI

* [`[129b064]`](https://github.com/dotnet/cli/commit/129b064) Update F# and Roslyn translations
* [`[b7cc4a5]`](https://github.com/dotnet/cli/commit/b7cc4a5) Update feed tasks version
* [`[d5c799b]`](https://github.com/dotnet/cli/commit/d5c799b) Update template engine version for 15.5
* [`[0cd0567]`](https://github.com/dotnet/cli/commit/0cd0567) Insert NuGet Build 4.5.0-rtm-4651 into cli
* [`[fe69088]`](https://github.com/dotnet/cli/commit/fe69088) Updating Roslyn version.
* [`[dad6eb2]`](https://github.com/dotnet/cli/commit/dad6eb2) Adding the ASP.NET feed where the ASP.NET templates are being published to.
* [`[6fef644]`](https://github.com/dotnet/cli/commit/6fef644) Update F# compiler
* [`[14be2fc]`](https://github.com/dotnet/cli/commit/14be2fc) Fixed an incorrect conditional.
* [`[31fd231]`](https://github.com/dotnet/cli/commit/31fd231) Make the "ExpectedFeedUrl" fully configurable.
* [`[95f30e3]`](https://github.com/dotnet/cli/commit/95f30e3) Moving conditional to load 'Microsoft.DotNet.Build.Tasks.Feed.targets' out of 'build.proj'
* [`[7b593a8]`](https://github.com/dotnet/cli/commit/7b593a8) Defining: "BuildTasksFeedToolVersion"
* [`[04ac042]`](https://github.com/dotnet/cli/commit/04ac042) Changes in the Transport feed DLL requires our response; update Transport feed DLL version and base URL.
* [`[d19b3f4]`](https://github.com/dotnet/cli/commit/d19b3f4) Correcting 'PUBLISH_TO_AZURE_BLOB' and 'PUBLISH_NUPKG_TO_AZURE_BLOB' Booleans - 'false' should not be conveyed by the empty string.
* [`[ed916bb]`](https://github.com/dotnet/cli/commit/ed916bb) MSBuild 15.5.178

## CoreCLR

* [`[174c1e4]`](https://github.com/dotnet/coreclr/commit/174c1e4) Add retry logic for setup of dotnet cli (#15047)
* [`[9546256]`](https://github.com/dotnet/coreclr/commit/9546256) Import dependencies.prop in the PerfHarness.csproj
* [`[764f750]`](https://github.com/dotnet/coreclr/commit/764f750) Fix wildcard expansion to correctly exclude TestWrapper projects from build
* [`[5c2aef1]`](https://github.com/dotnet/coreclr/commit/5c2aef1) Detailed logs on sync -ab (temp)
* [`[6c47879]`](https://github.com/dotnet/coreclr/commit/6c47879) Updates the explicit location for armasm
* [`[88e33df]`](https://github.com/dotnet/coreclr/commit/88e33df) Update scripts to support VS2017
* [`[a9334a2]`](https://github.com/dotnet/coreclr/commit/a9334a2) Update BuildTools version
* [`[9a1e0a8]`](https://github.com/dotnet/coreclr/commit/9a1e0a8) Fix test dependency package versions
* [`[fb95b29]`](https://github.com/dotnet/coreclr/commit/fb95b29) Release/2.0.0 - Make coreclr exceptions serializable and add typeforwards (#14847)
* [`[3118e7f]`](https://github.com/dotnet/coreclr/commit/3118e7f) Align init-tools scripts with the versions from master
* [`[7abf70d]`](https://github.com/dotnet/coreclr/commit/7abf70d) Update dependency properties used in PerfHarness project
* [`[ecddf52]`](https://github.com/dotnet/coreclr/commit/ecddf52) Add blob feed to the restore sources
* [`[0f66266]`](https://github.com/dotnet/coreclr/commit/0f66266) Switch to sourcing in init-tools to enable the return statements to work
* [`[2f4794f]`](https://github.com/dotnet/coreclr/commit/2f4794f) Move CoreCLRPackageVersion property useage
* [`[855f7da]`](https://github.com/dotnet/coreclr/commit/855f7da) Add RoslynIncompatibleMsbuildVersion condition on Roslyn import
* [`[69304bc]`](https://github.com/dotnet/coreclr/commit/69304bc) Removing the mandelbrot-4 implementation.
* [`[967859f]`](https://github.com/dotnet/coreclr/commit/967859f) Adding the new fastest mandelbrot implementation to benchmarks-game.
* [`[93d3fc0]`](https://github.com/dotnet/coreclr/commit/93d3fc0) Update dependency versions with new property names
* [`[4e3e4ea]`](https://github.com/dotnet/coreclr/commit/4e3e4ea) Mark packages as non-stable for 2.0.4 (#14575)
* [`[ecc3d1e]`](https://github.com/dotnet/coreclr/commit/ecc3d1e) Use restore with no --source for optdata proj feed
* [`[6b68ad6]`](https://github.com/dotnet/coreclr/commit/6b68ad6) Fix deadlock caused by R2R method info lookups during code heap deletion.
* [`[63d773d]`](https://github.com/dotnet/coreclr/commit/63d773d) Implement auto dependency flow Repo API (#14518)
* [`[64eeb17]`](https://github.com/dotnet/coreclr/commit/64eeb17) Fixing the usage of truncated options. (#14470)

## CoreFX

* [`[77efda5]`](https://github.com/dotnet/corefx/commit/77efda5) Add retry logic for setup of dotnet cli (#25276)
* [`[17c4273]`](https://github.com/dotnet/corefx/commit/17c4273) Release/2.0.0 - Make corefx exceptions serializable and add typeforwards (#25047)
* [`[ef40c9c]`](https://github.com/dotnet/corefx/commit/ef40c9c) Updating corefx to use new roslyn compiler (#24076)
* [`[744540a]`](https://github.com/dotnet/corefx/commit/744540a) Add mscorlib facade for refs consuming Windows.winmd
* [`[fbbe678]`](https://github.com/dotnet/corefx/commit/fbbe678) Fix errors with new CSC due to missing comma between attributes
* [`[ff9d455]`](https://github.com/dotnet/corefx/commit/ff9d455) Suppress unused field warnings introduced with new CSC
* [`[ccaa397]`](https://github.com/dotnet/corefx/commit/ccaa397) Adding required libraries to the net471 support package. (#24957)
* [`[623dfb8]`](https://github.com/dotnet/corefx/commit/623dfb8) CultureInfoConverter added (#24984)
* [`[f997049]`](https://github.com/dotnet/corefx/commit/f997049) [release/2.0.0] Port SmtpClient fixes to 2.0 (#24727)
* [`[6ae66ab]`](https://github.com/dotnet/corefx/commit/6ae66ab) Add locking to SecureTransport P/Invokes (#24868)
* [`[418c9c6]`](https://github.com/dotnet/corefx/commit/418c9c6) [release/2.0.0] Port missing System.Net.Http NETFX fixes (#24469)