# vlayer
vlayer enables developers to extract, verify and integrate real-world data into Ethereum smart contracts. Our technology is powered by Zero Knowledge Proofs (ZKP) and Multi-Party Computation (MPC), allowing you to securely verify private data without exposing sensitive information. 

Our four core features include: 
- [Web Proofs](https://book.vlayer.xyz/features/web.html): Access verified web data, including APIs and websites, in your smart contracts 
- [Email Proofs](https://book.vlayer.xyz/features/email.html): Tap into email content from your smart contracts and use it on-chain
- [Time Travel](https://book.vlayer.xyz/features/time-travel.html): Leverage historical on-chain data in your smart contracts
- [Teleport](https://book.vlayer.xyz/features/teleport.html): Execute a smart contract across different EVM-comptable blockchain networks

## Getting started

Read the 📖 [vlayer book](https://book.vlayer.xyz/introduction.html) to get started.

## Contributing

We're excited you're interested in contributing to vlayer. This [contributing](https://book.vlayer.xyz/appendix/contributing/overview.html) section in vlayer book outlines the process to get involved.

## License
vlayer v1.0 uses a dual licensing model, in which vlayer Labs Ltd. (core contributor of vlayer) is designated for commercialization, while the code is licensed to the general public under Business Source License (BSL) 1.1, which shall convert to the permissive MIT license after three years. 

This approach ensures that our technology remains accessible for broad community innovation, initially protecting project integrity while ultimately supporting widespread collaboration and adoption by developers across the globe.

By contributing, you agree that your contributions will be licensed under the Business Source License (BSL) 1.1. 

## Acknowledgements

We would like to acknowledge the following open-source projects that inspired and provided a foundation for this work:

* [Steel](https://crates.io/crates/risc0-steel) - Hardened off-chain Execution for EVM dapps

## Security Audits
- ✅ [Veridise Audit Report (Q2 2025)](./audits/audit-2025-q2-veridise.pdf)
