# Summary

[Introduction](./introduction.md)

- [Getting Started]()

  - [Installation](./getting-started/installation.md)
  - [First Steps](./getting-started/first-steps.md)
  - [How it works](./getting-started/how-it-works.md)
  - [Devnet, Testnet & Mainnet](./getting-started/dev-and-production.md)

- [Features]()
  - [Web proof](./features/web.md)
    - [Custom data source](./web-proof/quickstart-guide.md)
    - [Server-side](./web-proof/server-side.md)
    - [Redaction](./web-proof/redaction.md)
  - [Email proof](./features/email.md)
  - [Time travel](./features/time-travel.md)
  - [Teleport](./features/teleport.md)
  - [JSON and Regex](./features/json-and-regex.md)

- [From JavaScript]()
  - [Vanilla JS/TS](./javascript/javascript.md)
  - [React](./javascript/react-hooks.md)
  - [Web proofs](./javascript/web-proofs.md)
  - [Email proofs](./javascript/email-proofs.md)

- [Advanced]()

  - [Prover](./advanced/prover.md)
  - [Verifier](./advanced/verifier.md)
  - [Global variables](./advanced/prover-global-variables.md)
  - [Tests](./advanced/tests.md)

---

- [Appendix]()
  - [Audits](./appendix/security-audits.md)
  - [Contributing](./appendix/contributing/overview.md)
    - [Rust](./appendix/contributing/rust.md)
    - [JavaScript](./appendix/contributing/javascript.md)
    - [Book](./appendix/contributing/book.md)
    - [Upgrading Risc0](./appendix/contributing/upgrading_risc0.md)
    - [JWT](./appendix/contributing/jwt.md)
  - [Architecture](./appendix/architecture/overview.md)
    - [Prover](./appendix/architecture/prover.md)
    - [Time Travel & Teleport](./appendix/architecture/time_travel_teleport.md)
    - [Chain Proofs](./appendix/architecture/chain_proof.md)
      - [Coherence](./appendix/architecture/chain_proof/coherence.md)
      - [Canonicity](./appendix/architecture/chain_proof/canonicity.md)
    - [Solidity](./appendix/architecture/solidity.md)
    - [Releasing](./appendix/architecture/releasing.md)
    - [Web Proofs](./appendix/architecture/web_proof.md)
    - [Email Proofs](./appendix/architecture/email_proof.md)
  - [JSON-RPC API](./appendix/api.md)
  - [Proof composition](./appendix/proof_composition.md)
  - [E2E Tests](./appendix/e2e-tests/e2e-test-setup.md)
