# Contributing

Welcome! 

We're excited you're interested in contributing to [vlayer repository](https://github.com/vlayer-xyz/vlayer). Whether you're here to fix bugs, improve the documentation, or suggest a new feature, your contributions make vlayer better for everyone. 

This document outlines the process to get involved.

## Code of Conduct
To ensure a welcoming and respectful environment, all contributors are expected to follow these guidelines:
- Be respectful and considerate in all interactions.
- Provide constructive feedback and avoid personal attacks.
- Assume good intent and work collaboratively.
- Avoid discriminatory language or behavior.
- Follow the GitHub Community Guidelines.

By participating in this project, you agree to abide by this code of conduct. 
Let's build something great together!

## Getting Started
- Fork the repository on GitHub.

## Making a Contribution
We welcome:
- Bug fixes
- Feature implementations
- Performance improvements
- Tests and refactoring
- Documentation updates

**Pro tip**: Before starting major changes, open an issue or draft PR to discuss with maintainers.

## Code Style and Linting
- Keep PRs focused and well-documented. 
- Ensure your code passes the lint checks and tests.
- Keep conversations focused, useful, inclusive, and respectful.  

## Pull Request Process
1. Before starting work on an issue, please check for existing work to ensure that it is not already being addressed by someone else. 
2. If you find an issue you would like to work on, add a comment to it expressing your interest, and a member of the vlayer team will reach out to you for a brief discussion.
3. Following the discussion, the vlayer team will formally assign the issue to you, indicating that you are the main contributor working on that particular issue.
4. Upon resolving the issue, please submit a Pull Request (PR) with your solution, ensuring that: 
   - Your PR targets the main branch.
   - Your branch is named clearly: `fix/bug-description`, `feature/feature-name`, etc.
   - Your PR includes a clear description i.e. What changes were made? Why are they necessary? Any open questions or assumptions. 
   - Link related issues using issue labels. 
5. Next, submit your PR and wait for a member of the vlayer team to review. The review process includes checking that the solution passes all necessary tests and effectively resolves the issue. If your contribution meets this criteria, we will merge it into the project.
6. Throughout the process, be responsive to feedback and open to suggestions

## Contributing to the Documentation
We welcome and encourage contributions to the vlayer documentation! You can help improve it in several impactful ways:
- Enhancing clarity and readability by rephrasing confusing sections or updating outdated content.
- Fixing typos, grammar, or formatting errors to ensure a smooth reading experience.
- Creating new guides or tutorials that you wish you had when getting started—chances are others will find them helpful too.
- Translating documentation into other languages to make vlayer more accessible to a global audience.

For detailed instructions on how to contribute to the vlayer docs, please refer to our [documentation contribution guide](/appendix/contributing/book.html).

## Get in Touch 
- Join our [Discord](https://support.vlayer.xyz/) for real-time chat.
- Follow us on [X/Twitter](https://x.com/vlayer_xyz) for updates.
- Email: [dev@vlayer.xyz](mailto:dev@vlayer.xyz)

## License 
vlayer v1.0 uses a dual licensing model, in which vlayer Labs Ltd. (core contributor of vlayer) is designated for commercialization, while the code is licensed to the general public under Business Source License (BSL) 1.1, which shall convert to the permissive MIT license after three years. 

This approach ensures that our technology remains accessible for broad community innovation, initially protecting project integrity while ultimately supporting widespread collaboration and adoption by developers across the globe.

By contributing, you agree that your contributions will be licensed under the Business Source License (BSL) 1.1. 

## Next steps

Looking to make your first contribution? Here are some key areas where you can get involved with vlayer:
- [Rust](/appendix/contributing/rust.html): contribute to vlayer Rust codebase
- [JavaScript](/appendix/contributing/javascript.html): contribute to vlayer JS/TS codebase
- [Book](/appendix/contributing/book.html): update content, or provide feedback to this book
- [Upgrading Risc0](/appendix/contributing/upgrading_risc0.html): step-by-step guide to upgrading Risc0 dependency
- [JWT](/appendix/contributing/jwt.html): learn how to generate valid tokens 
