///////////////////////////////////////////////////////////////////////////////////
/// OpenGL Image (gli.g-truc.net)
///
/// Copyright (c) 2008 - 2015 G-Truc Creation (www.g-truc.net)
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in
/// all copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
/// THE SOFTWARE.
///
/// @ref core
/// @file gli/core/gl.hpp
/// @date 2013-11-09 / 2013-11-09
/// @author Christophe Riccio
///////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "storage.hpp"
#include <array>

namespace gli
{
	class gl
	{
		enum internalFormat
		{
			// unorm formats
			INTERNAL_R8_UNORM = 0x8229,			//GL_R8
			INTERNAL_RG8_UNORM = 0x822B,		//GL_RG8
			INTERNAL_RGB8_UNORM = 0x8051,		//GL_RGB8
			INTERNAL_RGBA8_UNORM = 0x8058,		//GL_RGBA8

			INTERNAL_R16_UNORM = 0x822A,		//GL_R16
			INTERNAL_RG16_UNORM = 0x822C,		//GL_RG16
			INTERNAL_RGB16_UNORM = 0x8054,		//GL_RGB16
			INTERNAL_RGBA16_UNORM = 0x805B,		//GL_RGBA16

			INTERNAL_RGB10A2_UNORM = 0x8059,	//GL_RGB10_A2

			// snorm formats
			INTERNAL_R8_SNORM = 0x8F94,			//GL_R8_SNORM
			INTERNAL_RG8_SNORM = 0x8F95,		//GL_RG8_SNORM
			INTERNAL_RGB8_SNORM = 0x8F96,		//GL_RGB8_SNORM
			INTERNAL_RGBA8_SNORM = 0x8F97,		//GL_RGBA8_SNORM

			INTERNAL_R16_SNORM = 0x8F98,		//GL_R16_SNORM
			INTERNAL_RG16_SNORM= 0x8F99,		//GL_RG16_SNORM
			INTERNAL_RGB16_SNORM= 0x8F9A,		//GL_RGB16_SNORM
			INTERNAL_RGBA16_SNORM = 0x8F9B,		//GL_RGBA16_SNORM

			// unsigned integer formats
			INTERNAL_R8U = 0x8232,				//GL_R8UI
			INTERNAL_RG8U = 0x8238,				//GL_RG8UI
			INTERNAL_RGB8U = 0x8D7D,			//GL_RGB8UI
			INTERNAL_RGBA8U = 0x8D7C,			//GL_RGBA8UI

			INTERNAL_R16U = 0x8234,				//GL_R16UI
			INTERNAL_RG16U = 0x823A,			//GL_RG16UI
			INTERNAL_RGB16U = 0x8D77,			//GL_RGB16UI
			INTERNAL_RGBA16U = 0x8D76,			//GL_RGBA16UI

			INTERNAL_R32U = 0x8236,				//GL_R32UI
			INTERNAL_RG32U = 0x823C,			//GL_RG32UI
			INTERNAL_RGB32U = 0x8D71,			//GL_RGB32UI
			INTERNAL_RGBA32U = 0x8D70,			//GL_RGBA32UI

			INTERNAL_RGB10A2U = 0x906F,			//GL_RGB10_A2UI

			// signed integer formats
			INTERNAL_R8I = 0x8231,				//GL_R8I
			INTERNAL_RG8I = 0x8237,				//GL_RG8I
			INTERNAL_RGB8I = 0x8D8F,			//GL_RGB8I
			INTERNAL_RGBA8I = 0x8D8E,			//GL_RGBA8I

			INTERNAL_R16I = 0x8233,				//GL_R16I
			INTERNAL_RG16I = 0x8239,			//GL_RG16I
			INTERNAL_RGB16I = 0x8D89,			//GL_RGB16I
			INTERNAL_RGBA16I = 0x8D88,			//GL_RGBA16I

			INTERNAL_R32I = 0x8235,				//GL_R32I
			INTERNAL_RG32I = 0x823B,			//GL_RG32I
			INTERNAL_RGB32I = 0x8D83,			//GL_RGB32I
			INTERNAL_RGBA32I = 0x8D82,			//GL_RGBA32I

			// Floating formats
			INTERNAL_R16F = 0x822D,				//GL_R16F
			INTERNAL_RG16F = 0x822F,			//GL_RG16F
			INTERNAL_RGB16F = 0x881B,			//GL_RGB16F
			INTERNAL_RGBA16F = 0x881A,			//GL_RGBA16F

			INTERNAL_R32F = 0x822E,				//GL_R32F
			INTERNAL_RG32F = 0x8230,			//GL_RG32F
			INTERNAL_RGB32F = 0x8815,			//GL_RGB32F
			INTERNAL_RGBA32F = 0x8814,			//GL_RGBA32F

			// sRGB formats
			INTERNAL_SR8 = 0x8FBD,				//GL_SR8_EXT
			INTERNAL_SRG8 = 0x8FBE,				//GL_SRG8_EXT
			INTERNAL_SRGB8 = 0x8C41,			//GL_SRGB8
			INTERNAL_SRGB8_ALPHA8 = 0x8C43,		//GL_SRGB8_ALPHA8

			// Packed formats
			INTERNAL_RGB9E5 = 0x8C3D,			//GL_RGB9_E5
			INTERNAL_RG11B10F = 0x8C3A,			//GL_R11F_G11F_B10F
			INTERNAL_RG3B2 = 0x2A10,			//GL_R3_G3_B2
			INTERNAL_R5G6B5 = 0x8D62,			//GL_RGB565
			INTERNAL_RGB5A1 = 0x8057,			//GL_RGB5_A1
			INTERNAL_RGBA4 = 0x8056,			//GL_RGBA4

			// Luminance Alpha formats
			INTERNAL_LA4 = 0x8043,				//GL_LUMINANCE4_ALPHA4
			INTERNAL_L8 = 0x8040,				//GL_LUMINANCE8
			INTERNAL_A8 = 0x803C,				//GL_ALPHA8
			INTERNAL_LA8 = 0x8045,				//GL_LUMINANCE8_ALPHA8
			INTERNAL_L16 = 0x8042,				//GL_LUMINANCE16
			INTERNAL_A16 = 0x803E,				//GL_ALPHA16
			INTERNAL_LA16 = 0x8048,				//GL_LUMINANCE16_ALPHA16

			// Depth formats
			INTERNAL_D16 = 0x81A5,				//GL_DEPTH_COMPONENT16
			INTERNAL_D24 = 0x81A6,				//GL_DEPTH_COMPONENT24
			INTERNAL_D24S8 = 0x88F0,			//GL_DEPTH24_STENCIL8
			INTERNAL_D32 = 0x81A7,				//GL_DEPTH_COMPONENT32
			INTERNAL_D32F = 0x8CAC,				//GL_DEPTH_COMPONENT32F
			INTERNAL_D32FS8X24 = 0x8CAD,		//GL_DEPTH32F_STENCIL8

			// Compressed formats
			INTERNAL_RGB_DXT1 = 0x83F0,						//GL_COMPRESSED_RGB_S3TC_DXT1_EXT
			INTERNAL_RGBA_DXT1 = 0x83F1,					//GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
			INTERNAL_RGBA_DXT3 = 0x83F2,					//GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
			INTERNAL_RGBA_DXT5 = 0x83F3,					//GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
			INTERNAL_R_ATI1N_UNORM = 0x8DBB,				//GL_COMPRESSED_RED_RGTC1
			INTERNAL_R_ATI1N_SNORM = 0x8DBC,				//GL_COMPRESSED_SIGNED_RED_RGTC1
			INTERNAL_RG_ATI2N_UNORM = 0x8DBD,				//GL_COMPRESSED_RG_RGTC2
			INTERNAL_RG_ATI2N_SNORM = 0x8DBE,				//GL_COMPRESSED_SIGNED_RG_RGTC2
			INTERNAL_RGB_BP_UNSIGNED_FLOAT = 0x8E8F,		//GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT
			INTERNAL_RGB_BP_SIGNED_FLOAT = 0x8E8E,			//GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT
			INTERNAL_RGB_BP_UNORM = 0x8E8C,					//GL_COMPRESSED_RGBA_BPTC_UNORM
			INTERNAL_RGB_PVRTC_4BPPV1 = 0x8C00,				//GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG
			INTERNAL_RGB_PVRTC_2BPPV1 = 0x8C01,				//GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG
			INTERNAL_RGBA_PVRTC_4BPPV1 = 0x8C02,			//GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG
			INTERNAL_RGBA_PVRTC_2BPPV1 = 0x8C03,			//GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG
			INTERNAL_RGBA_PVRTC_4BPPV2 = 0x9137,			//GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG
			INTERNAL_RGBA_PVRTC_2BPPV2 = 0x9138,			//GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG
			INTERNAL_ATC_RGB = 0x8C92,						//GL_ATC_RGB_AMD
			INTERNAL_ATC_RGBA_EXPLICIT_ALPHA = 0x8C93,		//GL_ATC_RGBA_EXPLICIT_ALPHA_AMD
			INTERNAL_ATC_RGBA_INTERPOLATED_ALPHA = 0x87EE,	//GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD

			INTERNAL_RGB_ETC = 0x8D64,						//GL_COMPRESSED_RGB8_ETC1
			INTERNAL_RGB_ETC2 = 0x9274,						//GL_COMPRESSED_RGB8_ETC2
			INTERNAL_RGBA_PUNCHTHROUGH_ETC2 = 0x9276,		//GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2
			INTERNAL_RGBA_ETC2_EAC = 0x9278,				//GL_COMPRESSED_RGBA8_ETC2_EAC
			INTERNAL_R11_EAC = 0x9270,						//GL_COMPRESSED_R11_EAC
			INTERNAL_SIGNED_R11_EAC = 0x9271,				//GL_COMPRESSED_SIGNED_R11_EAC
			INTERNAL_RG11_EAC = 0x9272,						//GL_COMPRESSED_RG11_EAC
			INTERNAL_SIGNED_RG11_EAC = 0x9273,				//GL_COMPRESSED_SIGNED_RG11_EAC

			INTERNAL_RGBA_ASTC_4x4 = 0x93B0,				//GL_COMPRESSED_RGBA_ASTC_4x4_KHR
			INTERNAL_RGBA_ASTC_5x4 = 0x93B1,				//GL_COMPRESSED_RGBA_ASTC_5x4_KHR
			INTERNAL_RGBA_ASTC_5x5 = 0x93B2,				//GL_COMPRESSED_RGBA_ASTC_5x5_KHR
			INTERNAL_RGBA_ASTC_6x5 = 0x93B3,				//GL_COMPRESSED_RGBA_ASTC_6x5_KHR
			INTERNAL_RGBA_ASTC_6x6 = 0x93B4,				//GL_COMPRESSED_RGBA_ASTC_6x6_KHR
			INTERNAL_RGBA_ASTC_8x5 = 0x93B5,				//GL_COMPRESSED_RGBA_ASTC_8x5_KHR
			INTERNAL_RGBA_ASTC_8x6 = 0x93B6,				//GL_COMPRESSED_RGBA_ASTC_8x6_KHR
			INTERNAL_RGBA_ASTC_8x8 = 0x93B7,				//GL_COMPRESSED_RGBA_ASTC_8x8_KHR
			INTERNAL_RGBA_ASTC_10x5 = 0x93B8,				//GL_COMPRESSED_RGBA_ASTC_10x5_KHR
			INTERNAL_RGBA_ASTC_10x6 = 0x93B9,				//GL_COMPRESSED_RGBA_ASTC_10x6_KHR
			INTERNAL_RGBA_ASTC_10x8 = 0x93BA,				//GL_COMPRESSED_RGBA_ASTC_10x8_KHR
			INTERNAL_RGBA_ASTC_10x10 = 0x93BB,				//GL_COMPRESSED_RGBA_ASTC_10x10_KHR
			INTERNAL_RGBA_ASTC_12x10 = 0x93BC,				//GL_COMPRESSED_RGBA_ASTC_12x10_KHR
			INTERNAL_RGBA_ASTC_12x12 = 0x93BD,				//GL_COMPRESSED_RGBA_ASTC_12x12_KHR

			// sRGB formats
			INTERNAL_SRGB_DXT1 = 0x8C4C,					//GL_COMPRESSED_SRGB_S3TC_DXT1_EXT
			INTERNAL_SRGB_ALPHA_DXT1 = 0x8C4C,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT
			INTERNAL_SRGB_ALPHA_DXT3 = 0x8C4E,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT
			INTERNAL_SRGB_ALPHA_DXT5 = 0x8C4F,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT
			INTERNAL_SRGB_BP_UNORM = 0x8E8D,				//GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM
			INTERNAL_SRGB_PVRTC_2BPPV1 = 0x8A54,			//GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT
			INTERNAL_SRGB_PVRTC_4BPPV1 = 0x8A55,			//GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT
			INTERNAL_SRGB_ALPHA_PVRTC_2BPPV1 = 0x8A56,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT
			INTERNAL_SRGB_ALPHA_PVRTC_4BPPV1 = 0x8A57,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT
			INTERNAL_SRGB_ALPHA_PVRTC_2BPPV2 = 0x93F0,		//COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG
			INTERNAL_SRGB_ALPHA_PVRTC_4BPPV2 = 0x93F1,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG
			INTERNAL_SRGB8_ETC2 = 0x9275,						//GL_COMPRESSED_SRGB8_ETC2
			INTERNAL_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277,	//GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2
			INTERNAL_SRGB8_ALPHA8_ETC2_EAC = 0x9279,			//GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC
			INTERNAL_SRGB8_ALPHA8_ASTC_4x4 = 0x93D0,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_5x4 = 0x93D1,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_5x5 = 0x93D2,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_6x5 = 0x93D3,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_6x6 = 0x93D4,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_8x5 = 0x93D5,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_8x6 = 0x93D6,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_8x8 = 0x93D7,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_10x5 = 0x93D8,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_10x6 = 0x93D9,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_10x8 = 0x93DA,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_10x10 = 0x93DB,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_12x10 = 0x93DC,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR
			INTERNAL_SRGB8_ALPHA8_ASTC_12x12 = 0x93DD		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR
		};

		enum externalFormat
		{
			EXTERNAL_NONE = 0,					//GL_NONE
			EXTERNAL_RED = 0x1903,				//GL_RED
			EXTERNAL_RG = 0x8227,				//GL_RG
			EXTERNAL_RGB= 0x1907,				//GL_RGB
			EXTERNAL_BGR = 0x80E0,				//GL_BGR
			EXTERNAL_RGBA = 0x1908,				//GL_RGBA
			EXTERNAL_BGRA = 0x80E1,				//GL_BGRA
			EXTERNAL_RED_INTEGER = 0x8D94,		//GL_RED_INTEGER
			EXTERNAL_RG_INTEGER = 0x8228,		//GL_RG_INTEGER
			EXTERNAL_RGB_INTEGER = 0x8D98,		//GL_RGB_INTEGER
			EXTERNAL_BGR_INTEGER = 0x8D9A,		//GL_BGR_INTEGER
			EXTERNAL_RGBA_INTEGER = 0x8D99,		//GL_RGBA_INTEGER
			EXTERNAL_BGRA_INTEGER = 0x8D9B,		//GL_BGRA_INTEGER
			EXTERNAL_DEPTH = 0x1902,			//GL_DEPTH_COMPONENT
			EXTERNAL_DEPTH_STENCIL = 0x84F9,	//GL_DEPTH_STENCIL

			EXTERNAL_LUMINANCE = 0x1909,				//GL_LUMINANCE
			EXTERNAL_ALPHA = 0x1906,					//GL_ALPHA
			EXTERNAL_LUMINANCE_ALPHA = 0x190A,			//GL_LUMINANCE_ALPHA

			EXTERNAL_RGB_DXT1 = 0x83F0,					//GL_COMPRESSED_RGB_S3TC_DXT1_EXT
			EXTERNAL_RGBA_DXT1 = 0x83F1,				//GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
			EXTERNAL_RGBA_DXT3 = 0x83F2,				//GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
			EXTERNAL_RGBA_DXT5 = 0x83F3,				//GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
			EXTERNAL_R_ATI1N_UNORM = 0x8DBB,			//GL_COMPRESSED_RED_RGTC1
			EXTERNAL_R_ATI1N_SNORM = 0x8DBC,			//GL_COMPRESSED_SIGNED_RED_RGTC1
			EXTERNAL_RG_ATI2N_UNORM = 0x8DBD,			//GL_COMPRESSED_RG_RGTC2
			EXTERNAL_RG_ATI2N_SNORM = 0x8DBE,			//GL_COMPRESSED_SIGNED_RG_RGTC2
			EXTERNAL_RGB_BP_UNSIGNED_FLOAT = 0x8E8F,	//GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT
			EXTERNAL_RGB_BP_SIGNED_FLOAT = 0x8E8E,		//GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT
			EXTERNAL_RGB_BP_UNORM = 0x8E8C,				//GL_COMPRESSED_RGBA_BPTC_UNORM
			EXTERNAL_RGB_PVRTC_4BPPV1 = 0x8C00,				//GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG
			EXTERNAL_RGB_PVRTC_2BPPV1 = 0x8C01,				//GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG
			EXTERNAL_RGBA_PVRTC_4BPPV1 = 0x8C02,			//GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG
			EXTERNAL_RGBA_PVRTC_2BPPV1 = 0x8C03,			//GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG
			EXTERNAL_RGBA_PVRTC_4BPPV2 = 0x9137,			//GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG
			EXTERNAL_RGBA_PVRTC_2BPPV2 = 0x9138,			//GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG
			EXTERNAL_ATC_RGB = 0x8C92,						//GL_ATC_RGB_AMD
			EXTERNAL_ATC_RGBA_EXPLICIT_ALPHA = 0x8C93,		//GL_ATC_RGBA_EXPLICIT_ALPHA_AMD
			EXTERNAL_ATC_RGBA_INTERPOLATED_ALPHA = 0x87EE,	//GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD

			EXTERNAL_RGB_ETC = 0x8D64,							//GL_COMPRESSED_RGB8_ETC1
			EXTERNAL_RGB8_ETC2 = 0x9274,						//GL_COMPRESSED_RGB8_ETC2
			EXTERNAL_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276,	//GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2
			EXTERNAL_RGBA8_ETC2_EAC = 0x9278,					//GL_COMPRESSED_RGBA8_ETC2_EAC
			EXTERNAL_R11_EAC = 0x9270,							//GL_COMPRESSED_R11_EAC
			EXTERNAL_SIGNED_R11_EAC = 0x9271,					//GL_COMPRESSED_SIGNED_R11_EAC
			EXTERNAL_RG11_EAC = 0x9272,							//GL_COMPRESSED_RG11_EAC
			EXTERNAL_SIGNED_RG11_EAC = 0x9273,					//GL_COMPRESSED_SIGNED_RG11_EAC
			EXTERNAL_RGBA_ASTC_4x4 = 0x93B0,				//GL_COMPRESSED_RGBA_ASTC_4x4_KHR
			EXTERNAL_RGBA_ASTC_5x4 = 0x93B1,				//GL_COMPRESSED_RGBA_ASTC_5x4_KHR
			EXTERNAL_RGBA_ASTC_5x5 = 0x93B2,				//GL_COMPRESSED_RGBA_ASTC_5x5_KHR
			EXTERNAL_RGBA_ASTC_6x5 = 0x93B3,				//GL_COMPRESSED_RGBA_ASTC_6x5_KHR
			EXTERNAL_RGBA_ASTC_6x6 = 0x93B4,				//GL_COMPRESSED_RGBA_ASTC_6x6_KHR
			EXTERNAL_RGBA_ASTC_8x5 = 0x93B5,				//GL_COMPRESSED_RGBA_ASTC_8x5_KHR
			EXTERNAL_RGBA_ASTC_8x6 = 0x93B6,				//GL_COMPRESSED_RGBA_ASTC_8x6_KHR
			EXTERNAL_RGBA_ASTC_8x8 = 0x93B7,				//GL_COMPRESSED_RGBA_ASTC_8x8_KHR
			EXTERNAL_RGBA_ASTC_10x5 = 0x93B8,				//GL_COMPRESSED_RGBA_ASTC_10x5_KHR
			EXTERNAL_RGBA_ASTC_10x6 = 0x93B9,				//GL_COMPRESSED_RGBA_ASTC_10x6_KHR
			EXTERNAL_RGBA_ASTC_10x8 = 0x93BA,				//GL_COMPRESSED_RGBA_ASTC_10x8_KHR
			EXTERNAL_RGBA_ASTC_10x10 = 0x93BB,				//GL_COMPRESSED_RGBA_ASTC_10x10_KHR
			EXTERNAL_RGBA_ASTC_12x10 = 0x93BC,				//GL_COMPRESSED_RGBA_ASTC_12x10_KHR
			EXTERNAL_RGBA_ASTC_12x12 = 0x93BD,				//GL_COMPRESSED_RGBA_ASTC_12x12_KHR

			// sRGB formats
			EXTERNAL_SRGB_DXT1 = 0x8C4C,					//GL_COMPRESSED_SRGB_S3TC_DXT1_EXT
			EXTERNAL_SRGB_ALPHA_DXT1 = 0x8C4C,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT
			EXTERNAL_SRGB_ALPHA_DXT3 = 0x8C4E,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT
			EXTERNAL_SRGB_ALPHA_DXT5 = 0x8C4F,				//GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT
			EXTERNAL_SRGB_BP_UNORM = 0x8E8D,				//GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM
			EXTERNAL_SRGB_PVRTC_2BPPV1 = 0x8A54,			//GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT
			EXTERNAL_SRGB_PVRTC_4BPPV1 = 0x8A55,			//GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT
			EXTERNAL_SRGB_ALPHA_PVRTC_2BPPV1 = 0x8A56,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT
			EXTERNAL_SRGB_ALPHA_PVRTC_4BPPV1 = 0x8A57,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT
			EXTERNAL_SRGB_ALPHA_PVRTC_2BPPV2 = 0x93F0,		//COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG
			EXTERNAL_SRGB_ALPHA_PVRTC_4BPPV2 = 0x93F1,		//GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG
			EXTERNAL_SRGB8_ETC2 = 0x9275,					//GL_COMPRESSED_SRGB8_ETC2
			EXTERNAL_RGBA_PUNCHTHROUGH_ETC2_SRGB = 0x9277,	//GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2
			EXTERNAL_SRGB8_ALPHA8_ETC2_EAC = 0x9279,		//GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC
			EXTERNAL_SRGB8_ALPHA8_ASTC_4x4 = 0x93D0,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_5x4 = 0x93D1,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_5x5 = 0x93D2,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_6x5 = 0x93D3,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_6x6 = 0x93D4,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_8x5 = 0x93D5,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_8x6 = 0x93D6,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_8x8 = 0x93D7,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_10x5 = 0x93D8,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_10x6 = 0x93D9,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_10x8 = 0x93DA,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_10x10 = 0x93DB,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_12x10 = 0x93DC,		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR
			EXTERNAL_SRGB8_ALPHA8_ASTC_12x12 = 0x93DD		//GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR
		};

		enum typeFormat
		{
			TYPE_NONE = 0,						//GL_NONE
			TYPE_I8 = 0x1400,					//GL_BYTE
			TYPE_U8 = 0x1401,					//GL_UNSIGNED_BYTE
			TYPE_I16 = 0x1402,					//GL_SHORT
			TYPE_U16 = 0x1403,					//GL_UNSIGNED_SHORT
			TYPE_I32 = 0x1404,					//GL_INT
			TYPE_U32 = 0x1405,					//GL_UNSIGNED_INT
			TYPE_F16 = 0x140B,					//GL_HALF_FLOAT
			TYPE_F32 = 0x1406,					//GL_FLOAT
			TYPE_UINT32_RGB9_E5 = 0x8C3E,		//GL_UNSIGNED_INT_5_9_9_9_REV
			TYPE_UINT32_RG11B10F = 0x8C3B,		//GL_UNSIGNED_INT_10F_11F_11F_REV
			TYPE_UINT8_RG3B2 = 0x8032,			//GL_UNSIGNED_BYTE_3_3_2
			TYPE_UINT8_RG3B2_REV = 0x8362,		//GL_UNSIGNED_BYTE_2_3_3_REV
			TYPE_UINT16_RGB5A1 = 0x8034,		//GL_UNSIGNED_SHORT_5_5_5_1
			TYPE_UINT16_RGB5A1_REV = 0x8366,	//GL_UNSIGNED_SHORT_1_5_5_5_REV
			TYPE_UINT16_R5G6B5 = 0x8363,		//GL_UNSIGNED_SHORT_5_6_5
			TYPE_UINT16_R5G6B5_REV = 0x8364,	//GL_UNSIGNED_SHORT_5_6_5_REV
			TYPE_UINT16_RGBA4 = 0x8033,			//GL_UNSIGNED_SHORT_4_4_4_4
			TYPE_UINT16_RGBA4_REV = 0x8365,		//GL_UNSIGNED_SHORT_4_4_4_4_REV
			TYPE_UINT32_RGB10A2 = 0x8036,		//GL_UNSIGNED_INT_10_10_10_2
			TYPE_UINT32_RGB10A2_REV = 0x8368	//GL_UNSIGNED_INT_2_10_10_10_REV
		};

		enum swizzle
		{
			SWIZZLE_RED = 0x1903,		//GL_RED
			SWIZZLE_GREEN = 0x1904,		//GL_GREEN
			SWIZZLE_BLUE = 0x1905,		//GL_BLUE
			SWIZZLE_ALPHA = 0x1906,		//GL_ALPHA
			SWIZZLE_ZERO = 0x0000,		//GL_ZERO
			SWIZZLE_ONE = 0x0001,		//GL_ONE
		};

	public:
		struct format
		{
			internalFormat Internal;
			externalFormat External;
			typeFormat Type;
			swizzle Swizzle[4];
		};

	public:
		gl();

		format const & translate(gli::format const & Format) const;

	private:
		std::array<format, FORMAT_COUNT> Translation;
	};
}//namespace gli

#include "gl.inl"
