# 管理平台使用指南

## 账号信息

### 开发者信息
为了更好的服务开发者，建议您完善开发者信息，填写真实姓名、电话号码。比如：
* 在关键时刻（服务宕机等意外情况），我们可以及时与您取得联系，获得更好的服务
* 「技术支持 Ticket」里会用到这些信息
* 发票相关的信息也来自这里

### 邮箱
* 登录时需要邮箱
* 数据导入，数据导出等一些服务会发送邮件通知
* 在「偏好设置」里，可以选择退订邮件（财务和告警类邮件无法退订）。

### 团队管理
为了方便多人协作，可以创建团队。在单个应用「设置」「协作者」菜单里，可以添加该团队做为当前项目的协作者，这样整个团队的成员都会拥有相关的权限。

## 财务

### 财务概况

- **充值余额**：通过过支付宝或者银行汇款的账户余额。
- **剩余短信**：短信需要单独购买，以购买条数计价。
- **赠送金额**：通过优惠码，代金券等非购买方式得到的，不能用来购买短信。

### 账单
每个月会产生一份账单，包括当前账户下所有应用。会详细展示每个应用每个服务的费用明细。

### 申请发票

请参考 [如何申请发票](faq.html#如何申请开具发票)。

### 充值
账户充值：支持支付宝，和银行转账汇款，请参考 [如何付费](faq.html#如何付费)。账户里面的余额可以用来支付每月账单（每个月结束后自动扣费）。也可以用来购买短信，这个需要主动购买，指定短信条数。
购买短信：短信需要单独购买，这个是实时扣除的，当短信剩余条数偏低时，会通过邮件和短信方式告知开发者。

### 代金券
代金券是一串代码，输入代码后当前帐号会获得相应的金额，您可以通过以下渠道获得代金券：

* 参加我们的黑客马拉松（Hackathon）
* 帮助我们抓 bug
* 各种其他活动

## 应用列表
包含当前账户创建的所有应用，以及通过设置「协作者」拥有特定权限的应用。

## 存储
包括数据存储、云引擎、API 统计、离线数据分析。

### 数据
可以浏览和管理数据，包括 Class 的创建，删除，数据的增删改查，支持数据导入，[Class 绑定](app_data_share.html)，[应用内搜索](app_search_guide.html)。

选择某个 Class 后即展示当前 Class 相关数据，以及相关功能的操作菜单。

#### 数据浏览

可以通过下面的方法更方便的浏览数据

* 可以通过「列设置」隐藏不需要看到的列
* 点击 ObjectId 快速查看某一行数据
* 可以隐藏 Class 列表，只显示数据部分

#### 数据浏览快捷键

* 方向键(上下左右)/Tab 支持单元格快速切换选中
* Enter 键
 * 当前单元格名称为 ObjectId 时，打开视图窗口
 * 当前单元格类型为 File 时，打开文件窗口

#### 数据编辑
支持所有数据类型的编辑
* 当输入的数据类型没有验证通过，输入完成后不会失去焦点
* Pointer 类型：
 * 新增：输入关联的 ObjectId 即可。保存成功后，生成一个可点击到关联对象的链接
 * 删除：清空后保存即删除 Pointer 列数据
* Relation 类型：
 * 点击某一行数据 Relation 列，跳转到 Relation 相关的 Class。这时候只显示与之相关联的数据
 * 新增：通过 Relation 点击过来，新增的数据即关联到该 Relation
 * 关联已有数据：「关联」菜单下点击 「关联已有对象」，然后选择数据，在选择关联
 * 解除关联关系： 先选中数据，再选择数据关联

#### 数据编辑快捷键

* 双击 Enter，激活当前单元格编辑模式。
* 在单元格编辑模式下，Tab 保存更改，并切换到下一个单元格，Enter 保存修改。

#### 列属性
包括对列的一些操作，包括排序，重命名，编辑属性等。点击每个列右侧向下箭头触发相关菜单。

#### 数据导入
在页面左侧「数据」链接右侧旁边，点击小齿轮图标即可看到「数据导入」菜单，请参考文档 [导入数据](data_security.html#导入数据)。

### 云引擎

这里主要可以进行云引擎的编辑，部署，制定定时任务，查看日志以及云引擎统计相关信息。

这里的「定义函数」和「Git 部署」是实现云引擎部署相关的两种方式。两种方式不能同时使用。如果要混合使用，会直接部署失败，错误信息：「定义函数」和「Git 部署」功能互斥。如果要继续，需要先清除部署。
#### 定义函数
可以在这个页面编辑云引擎相关函数，请参考 [云引擎指南 - 在线定义函数 Node.js](leanengine_guide-node.html#在线定义函数) / [Python](leanengine_guide-python.html#在线定义函数)。

#### Git 部署
* 点击 **部署**，会发布相应的 **分支** 或 **版本号** 到测试或生产环境中。
* 可以根据 **分支** 或 **版本号** 发布特定版本到测试或生产环境中。

#### 定时任务
对通过前面两种方式定义的云引擎函数，制定定时任务。请参考 [云引擎指南 - 定时任务 Node.js](leanengine_guide-node.html#定时任务) / [Python](leanengine_guide-python.html#定时任务)。

#### 日志
可以查看云引擎的输出日志，区分生产和测试环境。

#### 统计
云引擎相关统计项，可以查看函数，页面相关的调用情况，也可以查看云引擎环境相关运行参数。

### API 统计

API 统计：提供线形图和饼状图两种统计方式
* 线形图帮助查看指定日期范围内，每天的 API 调用量，可以根据平台和 Class 进行筛选。
* 饼状图方便查看指定日内范围内累计 API 调用量。可以按平台，Class 等对比展示。

文件相关 API：
由于存储提供商的限制，文件相关统计可能会一至三天的延迟。

### 离线数据分析
通过 SQL 对数据进行分析。需要先开启「离线数据分析」 选项。分析完成后可以将分析结果保存为 Class 或导出，导出结果限制在 1000 条。

请参考 [离线数据分析使用指南](leaninsight_guide.html)。

## 消息

### 实时消息

#### 统计
* 实时消息使用情况的实时统计
* 实时消息使用情况的历史统计，以天为最小单位

#### 帮助
可以调用实时消息相关 API，查看用户的在线情况，离线消息数量，帮助调试。

#### 设置
包括实时消息相关权限以及其他设置。

### 推送

* 在线发送：通过 web 控制界面发送推送，可以配送各种条件和推送内容。
* 帮助：可以通过界面查看某个 Android 推送设备是否在线，是否有离线消息。
* 推送历史：_Notification 表的快捷方式
* 设置：上传 iOS 证书，以及其他推送相关的权限设置

## 分析
* 支持各种常见统计指标
* 支持按照系统类型，系统版本，发布渠道，应用版本，自定义用户群，时间段进行统计，支持按时间段对比分析（仅限对有对比意义的统计项）
* 支持实时统计一些关键数据
* 支持全部系统的汇总统计（仅限对于全部系统都有意义的统计项）
* 支持自定义事件统计
* 支持自定义用户群，可以作为其他统计项的筛选条件，也可以结合「推送」使用，在「用户群」里，通过筛选用户，然后对筛选后的用户进行推送
* 每个统计展示页都有详细的统计项说明。对于需要进行编码设置才起作用的统计项，在没收到统计数据的时候，会给出具体的相关文档链接

## 组件

### 用户反馈
通过结合使用客户端 sdk，和 Web 管理页面，实现用户反馈管理功能。主要是在客户端通过 SDK 提交反馈，获取反馈，在 Web 页面里进行回复以及用户反馈的管理。

### 自定义参数
通过 Web 管理页面设置参数名，参数值，然后在客户端通过 SDK 读取配置的参数值。

### 应用内搜索
类似全文搜索，在这里需要设置一些基本信息，[相关文档](app_search_guide.html)。

### 社交
这里需要设置第三方平台的认证信息，以完成社交「登录」功能。

## 设置


### 基本信息
应用名称：不对外公开，在系统内部使用。

应用墙发布设置：审核通过后，审核结果将以邮件的形式通知到用户，并发布到 [我们的用户页面](/customers.html)。

### 应用 Key
用于标识 App 身份信息。
* App ID：全局唯一的应用 ID
* App Key：用于 App 基本安全认证
* Master Key：用于 App 超级权限认证

不要泄露 App Key ，特别是 Master Key。Master Key 会绕过所有 ACL 和 Class 权限等授权校验。

### 应用选项
集成了各种服务权限相关选项设置。
### 邮件模板
包括用于邮箱验证，重置密码的邮件模板设置。
### 短信模板
* 模板审核通过后立即生效
* 可以创建同名模板，在审核通过后将覆盖老的模板，审核期间，已经审核通过的老模板继续可用，审核通过即刻替换

### 协作者
用于项目协作，可以给相关个人账户和团队设置授予特定权限，访问当前项目。

### 数据导出
导出成功后，数据将发送到当前用户的邮箱。当数据量较大时，较为耗时，所以建议加上开始结束日期限制（按 updatedAt 计算），也可以限定特定 Class 导出。
