# 云引擎项目示例

伴随着 LeanEngine 的发展，以及针对一些用户呼声较高的几种类型的需求，我们特地开发了几个项目示例，给开发者提供了几个「拿来就用」的项目。

## 微信自动问答机器人

微信开发是时下大热的开发趋势，很多团队在进行市场推广以及用户渗透的时候，要借助微信的用户群做一些符合自己需求的定向开发，例如航空公司可以通过微信公众号给乘客推送行程信息，银行可以及时告知消费信息等等，因此借助 LeanEngine 提供的代码托管的功能，通过设置，让微信的后台将用户所发送信息转发到 LeanEngine 的服务器上，然后我们部署在 LeanEngine 上的代码进行相应，并且调用微信的接口进行回复。

为了友好的介绍这个示例项目，大家可以关注下面这个微信公众号：

![sample](http://ac-lhzo7z96.clouddn.com/1457597962129)

然后给这个公众号发送：说个笑话

然后就可以查看收到的消息。

如何开发这个微信公众号请查看[微信公众平台开发指南](webhosting_weixin.html)

## OAuth 授权验证回调服务器

开发过微博应用或者是接入过 QQ 登录的应用都需要在后台设置一个回调服务器地址，用来接收回调信息，关于为什么需要回调服务器这个请阅读 [OAuth 2 官方文档](http://oauth.net/2/)。

许多用户在 LeanEngine 上托管了自己的网站，因为他们在制作登录页面的时候，需要实现微博登录等等第三方登录的功能，因此如果在 LeanEngine 部署回调服务器可以节省成本，快速实现需求。

如何开发 OAuth 授权验证回调服务器，请查看[微博 OAuth 授权验证回调服务器开发指南](webhosting_oauth.html)

