# 云引擎运行方案

为了优化资源配置，我们为应用准备了「免费版」和「专业版」。

## 专业版

专业版针对商业用户和产品，可以提供系统水平扩展能力和一系列服务端运维支持，其特性为：

* 可以启用多个实例，可以自定义实例规格。
* 实例可以分组，部署不同代码，实现灰度发布。
* 部署平滑迁移，服务零中断。
* 不启用 [休眠策略](#休眠策略)，实例 24 小时待命。
* 拥有预备环境，让生产环境变得更可靠。预备环境启用休眠策略。

## 免费版

完全免费使用，适合测试和学习。其特性为：

* 每个应用最多一个 [基本资源实例](#实例资源)。
* 实例只有生产环境，没有预备环境。
* 部署期间实例暂停服务。
* 实例启用休眠策略。

### 休眠策略

<div class="callout callout-info">专业版下的实例不会启动休眠策略。</div>

为了兼顾资源配置和免费使用，免费版的实例会启用休眠策略。

* 如果应用最近 30 分钟没有任何外部请求，则休眠。
* 休眠后如果有新的外部请求实例则马上启动。访问者的体验是第一个请求响应时间是 1 ~ 5 秒（视实例启动时间而定），后续访问响应速度恢复正常。
* <a id="强制休眠" name="强制休眠">强制休眠</a>：如果最近 24 小时内休眠累计不足 6 小时，则强制休眠。此时新的请求会收到 503 的错误响应码，该错误可在 [云引擎 > 统计 > Status 页面](/cloud.html?appid={{appid}}#/stat) 中查看。

## 方案切换

应用默认为免费版，如需升级为专业版，可以在 [云引擎实例](/cloud.html?appid={{appid}}#/leannode) 页面进行「升级专业版」操作。升级后应用将多出一个预备环境实例，随后开发者可以根据需要变更实例规格和创建更多的实例。

应用如需切换为免费版，则需要删除专业版下的所有生产环境实例。回到免费版后，预备环境实例随之消失，只存在一个默认的生产环境实例。

<div class="callout callout-info">删除实例不会造成应用数据丢失，但应用对并发访问的处理能力会降低。</div>

## 实例资源

一个包含 **0.5 CPU、256 MB 内存** 的实例被定义为「基本资源」。

应用可以将基本资源组合使用：

* 启动 4 个基本资源的实例，即 4 个 0.5 CPU、256 MB 内存的实例。
* 启动 2 个 2 倍基本资源的实例，即 2 个 1 CPU、512 MB 内存的实例。

<a id="max" name="max"></a>**注意**：每个应用最多允许 4 个实例，每个实例最高规格为 4 CPU、2 GB 内存。**如果需要更多资源，请联系 <support@leancloud.cn>**。

## 价格

免费版完全免费。

专业版采取按天扣费，使用时间不足一天按一天收费，次日凌晨系统从账户余额中扣费。

每个基本资源 1 元／天，即：

* 如果启动 4 个基本资源的实例，4 元／天。
* 如果启动 2 个 2 倍基本资源的实例，4 元／天。

资源使用数量按当天**最大**资源占用计算。假设某天从 0 点至 23:59 分之间：

* 创建了 4 个基本资源实例；
* 发现资源数量不足，将 4 个实例都扩容 2 倍，即占用 8 个基本资源容量；
* 发现资源过多，删除 1 个实例，当前占用 6 个基本资源。

则当天费用按照 8 个基本资源计算。
