# LeanCloud 文档阅读指南

## 你是 iOS 程序员？

* [快速入门](/start.html)
<li><a href="leanstorage_guide-ios.html">iOS / OS X 数据存储指南</a></li>
<li><a href="realtime_guide-ios.html">iOS 实时通信指南</a></li>
<li><a href="ios_statistics.html">iOS 统计 SDK 开发指南</a></li>
<li><a href="ios_push_cert.html">iOS 推送证书设置指南</a></li>
<li><a href="ios_crashreporting_guide.html">iOS 崩溃报告使用指南</a></li>
<li><a href="/api-docs/iOS/index.html" target="_blank">iOS SDK API</a></li>

## 你是 Android 程序员？

* [快速入门](/start.html)
<li><a href="android_guide.html">Android 数据存储指南</a></li>
<li><a href="realtime_guide-android.html">Android 实时通信指南</a></li>
<li><a href="android_statistics.html">Android 统计 SDK 开发指南</a></li>
<li><a href="/api-docs/android/index.html" target="_blank">Android SDK API</a></li>

## 你是 Unity3D 或者 WindowsPhone 开发者？

* [快速入门](/start.html)
<li><a href="unity_guide.html">Unity3D 数据存储指南</a></li>
<li><a href="unity_statistics.html">Unity3D 统计 SDK 指南</a></li>
<li><a href="dotnet_guide.html">.NET 数据存储指南</a></li>
<li><a href="realtime_guide-dotnet.html">Windows Phone 8.0 实时通信指南</a></li>
<li><a href="/api-docs/wp/Help/index.html">.NET SDK API</a>

## 你是 JavaScript 前端开发者？

* [快速入门](/start.html)
<li><a href="js_guide.html">JavaScript 数据存储指南</a></li>
<li><a href="https://github.com/leancloud/realtime-messaging-jssdk">JavaScript 实时通信 SDK</a></li>
<li><a href="/api-docs/javascript/index.html" target="_blank">JavaScript SDK API</a></li>

## 你是后端逻辑开发者？

* [开放 REST API 文档](./rest_api.html)
<li><a href="js_guide.html">JavaScript 数据存储指南</a></li>
<li><a href="leanengine_guide-node.html">云引擎指南（Node.js）</a></li>
<li><a href="leanengine_guide-python.html">云引擎指南（Python）</a></li>
<li><a href="cloud_code_commandline.html">云引擎命令行工具</a></li>

## 你是 PHP 开发者？

* [快速入门](/start.html)
* [官方 PHP SDK @Github](https://github.com/leancloud/php-sdk)
* [PHP SDK API](/api-docs/php/)

## 你是 C++ 开发者？

* [leancloud/cpp-sdk](https://github.com/leancloud/cpp-sdk)

## 你要实现数据存储？

<ul>
<li><a href="leanstorage_guide-ios.html">iOS / OS X 数据存储指南</a></li>
<li><a href="android_guide.html">Android 数据存储指南</a></li>
<li><a href="unity_guide.html">Unity3D 数据存储指南</a></li>
<li><a href="dotnet_guide.html">.NET 数据存储指南</a></li>
<li><a href="js_guide.html">JavaScript 数据存储指南</a></li>
</ul>

## 你要实现聊天功能？

<ul>
<li><a href="realtime_guide-ios.html">iOS 实时通信指南</a></li>
<li><a href="realtime_guide-android.html">Android 实时通信指南</a></li>
<li><a href="https://github.com/leancloud/realtime-messaging-jssdk">JavaScript 实时通信 SDK</a></li>
<li><a href="realtime_guide-dotnet.html">Windows Phone 8.0 实时通信指南</a></li>
</ul>

## 你要实现统计功能？

<ul>
<li><a href="ios_statistics.html">iOS 统计 SDK 开发指南</a></li>
<li><a href="android_statistics.html">Android 统计 SDK 开发指南</a></li>
<li><a href="unity_statistics.html">Unity3D 统计 SDK 指南</a></li>
</ul>

## 你要实现推送功能？

<ul>
<li><a href="ios_push_cert.html">iOS 推送推送证书配置</a></li>
 <li><a href="push_guide.html">消息推送开发指南</a></li>
 </ul>


## 你要做网站托管服务？

<ul>
<li><a href="leanengine_guide-cloudcode.html#网站托管">云引擎指南</a></li>
 </ul>
 
## 你要导入导出数据？

<ul>
<li><a href="./data_security.html#导入数据">导入数据</a></li>
<li><a href="./data_security.html#导出数据">导出数据</a></li>
 </ul>

## 常见问题

* [FAQ](./faq.html)
* [常用功能提示](./tool_tips.html)
