# Introduction

You are highly advised to use your ``Cakebox.yaml`` file to provision your box.
This way you will always be able to (re)create exact copies of your box
without losing your:

+ virtual machine settings (hostname, IP address, CPUs, memory)
+ databases
+ virtual hosts (Nginx or HHVM)
+ Git credentials
+ Git installed applications (public and private)
+ Composer installed applications
+ hardened SSH Authentication
+ Vagrant Synced Folders
+ additionally installed Ubuntu software

**Notes:**

+ use spaced indentation or your box will fail to start
+ apply (and test) configuration changes by running
``vagrant reload --provision``

## TL;DR

For those who don't like reading... here's an example of a rich-filled
Cakebox.yaml with a lot of different provisioning variations.

```yaml
# cakebox.yaml configuration examples

vm:
  hostname: cakebox
  ip: 10.33.10.10
  network: private
  memory: 2048
  cpus: 1

cakebox:
  version: dev-dev
  debug: true
  https: false

git:
  username: your-username@github.com
  email: your-username@users.noreply.github.com

security:
  ssh_public_key: ~/.ssh/cakebox_rsa.pub
  ssh_private_key: ~/.ssh/cakebox_rsa

  # Windows
  #ssh_public_key: /Users/your-username/.ssh/cakebox_rsa.pub
  #ssh_private_key: /Users/your-username/.ssh/cakebox_rsa

synced_folders:
  - local:  Apps
    remote: /home/vagrant/Apps

  - local: /tmp/fast/non-windows/nfs-mounted/folder
    remote: /tmp/fast
    mount_options: 'type: "nfs"'

  - local:  some.app
    remote: /home/vagrant/Apps/some.app

  - local:  D:\git\clones\other.app
    remote: /var/www/awesome.app

apps:
  - url: mycake3.app

  - url: mycake3-hhvm.app
    options: --hhvm

  - url: mycake2.app
    options: --majorversion 2 --path /var/www/mycake2.app

  - url: mylaravel.app
    options: --framework laravel

  - url: git-ssh-repository.app
    options: --source git@github.com:owner/repository.git --webroot /var/www/ssh-app/webroot

  - url: git-https-repository.app
    options: --source http://github.com/your-name/repository --webroot /var/www/ssh-app/public

  - url: mycomposer.app
    options: --source yiisoft/yii2-app-basic --webroot /var/www/yii/public_html

vhosts:
    - url: app1.dev
      webroot: /home/vagrant/Apps/app1.dev

    - url: app2.dev
      webroot: /var/www/somedir

    - url: app3.dev
      webroot: /var/www/app3.dev
      options: --force

databases:
  - name: test1.db

  - name: test2.db
    options: --force

  - name: test3.db
    options: --username user123 --password pass123

extra:
  - apt_packages:
    - whois
    - phpmyadmin
    - dos2unix

  -scripts:
    - ~/scripts/box-customizer.sh
    - /path/to/another.sh
```


## VM

Use the ``vm`` section to customize your Virtual Machine settings.

Option    | Description
:---------|:------------
hostname  | hostname used by your box
ip        | ip-address used to connect to your box
network   | "private" for localhost access only (default) or "public"
memory    | amount of memory available to your box (in MB)
cpus      | number of virtual CPUs available to your box

```yaml
vm:
  hostname: cakebox
  ip: 10.33.10.10
  network: private
  memory: 2048
  cpus: 1
```

## Cakebox

The ``cakebox`` section contains settings related to your Cakebox Dashboard
and Cakebox Commands.

Option   | Description
:--------|:------------
version  | Composer version of the cakebox-console project
debug    | true to enable CakePHP debug mode
https    | true to enable HTTPS for the Cakebox Dashboard

```yaml
cakebox:
  version: dev-dev
  debug: true
  https: false
```

## Git

Automatically configures the Git globals user.name and user.email inside your
box. Required for provisioning ssh and private Git repositories.

Key         | Option    | Description
:-----------|:----------|:------------
git         | username  | your git config --global user.name
git         | email     | your git config --global user.email

```yaml
git:
  username: your-username@github.com
  email: your-username@users.noreply.github.com
```

## Security

The "security" section is used to specify the SSH key pair you want your box
to use for authenticating SSH logins. See
[Hardening Box Authentication](tutorials/hardening-box-authentication/)
for more information.

> **Note:** Windows users will probably find their keys in /Users/your-username/.ssh/

Option          | Description
:---------------|:-----------
ssh_public_key  | full path to your personal public key file
ssh_private_key | full path to your personal private key file

```yaml
security:
  ssh_public_key: ~/.ssh/cakebox_rsa.pub
  ssh_private_key: ~/.ssh/cakebox_rsa
```

## Synced Folders

Define "synced_folders" to create [Vagrant Synced Folders](https://docs.vagrantup.com/v2/synced-folders/index.html)
that will auto-sync data between a folder on your local machine and a folder on
your box.

**Please note:**

+ all applications generated by the ``cakebox application`` command will be placed
in subdirectories directly below /home/vagrant/Apps (unless specified otherwise)
+ local paths starting with a(ny) character will be created as subfolders in
the local Cakebox root folder
+ local paths starting with a / are treated as absolute paths

**Windows users:**

+ should avoid using a driveletter C: (Vagrant will conveniently translate / to C:\)
+ should avoid sharing the Cakebox root folder (.) as a whole as this could
seriously impact performance

Option          | Description
:---------------|:-----------
local  | path of the local folder
remote | path of the remote folder
mount_options | Vagrant Synced Folder supported mount options (ignored on Windows).

```yaml
synced_folders:
  - local:  Apps
    remote: /home/vagrant/Apps

  - local: /tmp/fast/non-windows/nfs-mounted/folder
    remote: /tmp/fast
    mount_options: 'type: "nfs"'

  - local:  some.app
    remote: /home/vagrant/Apps/some.app

  - local:  D:\git\clones\another.app
    remote: /var/www/awesome.app
```

## Apps

Define "apps" to provision fully configured instant-up applications.

Option  | Description
:-------|:-----------
url     | fully qualified domain name used to expose the site
options | any combination of options displayed running ``cakebox application add --help``

```yaml
apps:
  - url: mycake3.app

  - url: mycake3.app
    options: --hhvm

  - url: mycake2.app
    options: --majorversion 2 --path /var/www/mycake2.app

  - url: ssh-cloned.cake3.app
    options: --ssh

  - url: mypublic.app
    options: --source http://github.com/your-name/repository --webroot /var/www/mypublic.app/webroot

  - url: myprivate.app
    options: --source git@github.com:your-name/private-repository.git  --webroot /var/www/myprivate.app/public

  - url: mylaravel.app
    options: --framework laravel

  - url: mycomposer.app
    options: --source yiisoft/yii2-app-basic
```

## Vhosts
Use the "vhosts" section to provision Nginx virtual hosts.


Option  | Description
:-------|:------------
url     | fully qualified domain name used to expose the site
webroot | full path to site's webroot folder serving pages
options | any combination of options displayed running ``cakebox vhost add --help``

```yaml
vhosts:
  - url: app1.dev
    webroot: /home/vagrant/Apps/app1.dev

  - url: app2.dev
    webroot: /var/www/somedir

  - url: app3.dev
    webroot: /var/www/app3.dev
    options: --force
```

## Databases

Define "databases" to provision a MySQL database accompanied by a
'test_' prefixed database for test purposes.

**Please note:**

+ database names are normalized (e.g. test1.db will be named test1_db)
+ default username/password used to grant localhost access is cakebox/secret
+ use options to override default username/password
+ use --force with caution: it will DROP your existing database

Option  | Description
:-------|:-----------
name    | name of the database
options | any combination of options displayed running ``cakebox database add --help``


```yaml
databases:
  - name: test1.db

  - name: test2.db
    options: --force

  - name: test3.db
    options: --username user123 --password pass123
```

## Extra

The ``extra`` section was made to provide you with fully reprovisionable
box customizations.

### Apt Packages

All Ubuntu Pacakge Archive (apt) packages defined in the ``apt_pacakges``
section will be installed on your box.

**Please note:**

+ all installations are executed using "DEBIAN_FRONTEND=noninteractive"

Option  | Description
:-------|:-----------
package | name of the software package as used by ``apt-get install``


```yaml
extra:
  - apt_packages:
      - whois
      - phpmyadmin
      - dos2unix
```

### Scripts

All user created bash scripts in the ``scripts`` section will run inside your box
allowing you to fully customize anything you like while still maintaining
reprovisionability (solve once, enjoy many).

> **Note:** Make sure your scripts exit
with 0 on success or vagrant provisioning will fail.

```yaml
extra:
  - scripts:
      - ~/scripts/my-cakebox-tuner.sh
      - /path/to/another/bash.sh
```
