// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System.Linq;
using FluentAssertions;
using Microsoft.DotNet.Tools.Run;
using Xunit;
using Xunit.Abstractions;
using System;

namespace Microsoft.DotNet.Tests.ParserTests
{
    public class RunParserTests
    {
        public RunParserTests(ITestOutputHelper output)
        {
            this.output = output;
        }

        private readonly ITestOutputHelper output;

        [Fact]
        public void RunParserCanGetArguementFromDoubleDash()
        {
            var runCommand = RunCommand.FromArgs(new[]{ "--", "foo" });
            runCommand.Args.Single().Should().Be("foo");
        }
    }
}
