---
toc_title: SSO on Mobile Apps
description:
---


# Lock iOS: SSO on Mobile Apps

In order to do SSO on Mobile Apps, we need to use a shared keychain. We'll learn how to do this throughout this post.

To enable keychain sharing you'll have to define a keychain access group with the following format:
`<Bundle Seed Id>.<Group Name>`

e.g.: ABC1234DEF.mysharedgroup

The Bundle Seed Id is a unique (within the App Store) ten character string that is generated by Apple after you create your appId (using Apple's dev site). Each application identifier has the following format:

`<Bundle Seed Id>.<Bundle Indentifier>`

So each app that has the same Bundle Seed can access to values stored in groups with the same prefix so the apps:
* **ABC1234DEF.com.auth0.awesomeapp1**
* **ABC1234DEF.com.auth0.awesomeapp2**

Can read/write values stored in the group **ABC1234DEF.mysharedgroup**

In your project you'll need to add an entitlements file for each app declaring the access group. You can do it in capabilities tab of the project's target (under the label Keychain Sharing), just turn it on and add only the group name (without the Bundle Seed Id).

To obtain a value form the Keychain:
```objc
SimpleKeychain *keychain = [SimpleKeychain keychainWithService:@"Auth0" accessGroup:@"ABC1234DEF.mysharedgroup"];
NSString *refreshToken = [keychain stringForKey:@"refresh_token"];
```
```swift
let keychain = SimpleKeychain.keychainWithService("Auth0", accessGroup:"ABC1234DEF.mysharedgroup")
let refreshToken = keychain.stringForKey("refresh_token")
```

To store a value in the Keychain:
```objc
SimpleKeychain *keychain = [SimpleKeychain keychainWithService:@"Auth0" accessGroup:@"ABC1234DEF.mysharedgroup"];
[keychain setString:auth0User.refreshToken forKey:@"refresh_token"];
```
```swift
let keychain = SimpleKeychain.keychainWithService("Auth0", accessGroup:"ABC1234DEF.mysharedgroup")
keychain.setString(auth0User.refreshToken, forKey:"refresh_token")
```

> This examples our a Keychain wrapper `SimpleKeychain`. For more information on how to use it please go to it's [Github repo](https://github.com/auth0/SimpleKeychain)

You can now learn how to use the stored `refresh_token` with your app to be able to call an API securely in [this other guide](https://github.com/auth0/Auth0.iOS/wiki/How-to-save-and-refresh-JWT-token)
