///////////////////////////////////////////////////////////////////////////////////
/// OpenGL Mathematics (glm.g-truc.net)
///
/// Copyright (c) 2005 - 2012 G-Truc Creation (www.g-truc.net)
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
/// 
/// The above copyright notice and this permission notice shall be included in
/// all copies or substantial portions of the Software.
/// 
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
/// THE SOFTWARE.
///
/// @ref gtc_constants
/// @file glm/gtc/constants.hpp
/// @date 2011-09-30 / 2012-01-25
/// @author Christophe Riccio
///
/// @see core (dependence)
/// @see gtc_half_float (dependence)
///
/// @defgroup gtc_constants GLM_GTC_constants
/// @ingroup gtc
/// 
/// @brief Allow to perform bit operations on integer values
/// 
/// <glm/gtc/constants.hpp> need to be included to use these features.
///////////////////////////////////////////////////////////////////////////////////

#ifndef GLM_GTC_constants
#define GLM_GTC_constants GLM_VERSION

// Dependency:
#include "../glm.hpp"
#include "../gtc/half_float.hpp"

#if(defined(GLM_MESSAGES) && !defined(glm_ext))
#	pragma message("GLM: GLM_GTC_constants extension included")
#endif

namespace glm
{
	/// @addtogroup gtc_constants
	/// @{

	/// Return the epsilon constant for floating point types.
	/// @todo Implement epsilon for half-precision floating point type.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T epsilon();

	/// Return 0.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T zero();

	/// Return 1.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T one();

	/// Return the pi constant.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T pi();

	/// Return square root of pi.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_pi();

	/// Return pi / 2.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T half_pi();

	/// Return pi / 4.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T quarter_pi();

	/// Return 1 / pi.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T one_over_pi();

	/// Return 2 / pi.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T two_over_pi();

	/// Return 2 / sqrt(pi).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T two_over_root_pi();

	/// Return 1 / sqrt(2).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T one_over_root_two();

	/// Return sqrt(pi / 2).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_half_pi();

	/// Return sqrt(2 * pi).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_two_pi();

	/// Return sqrt(ln(4)).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_ln_four();

	/// Return e constant.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T e();

	/// Return Euler's constant.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T euler();

	/// Return sqrt(2).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_two();

	/// Return sqrt(3).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_three();

	/// Return sqrt(5).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T root_five();

	/// Return ln(2).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T ln_two();

	/// Return ln(10).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T ln_ten();

	/// Return ln(ln(2)).
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T ln_ln_two();

	/// Return 1 / 3.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T third();

	/// Return 2 / 3.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T two_thirds();

	/// Return the golden ratio constant.
	/// @see gtc_constants
	template <typename T>
	GLM_CONSTEXPR T golden_ratio();

	/// @}
} //namespace glm

#include "constants.inl"

#endif//GLM_GTC_constants
