/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephObjectStoreUserLister helps list CephObjectStoreUsers.
type CephObjectStoreUserLister interface {
	// List lists all CephObjectStoreUsers in the indexer.
	List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error)
	// CephObjectStoreUsers returns an object that can list and get CephObjectStoreUsers.
	CephObjectStoreUsers(namespace string) CephObjectStoreUserNamespaceLister
	CephObjectStoreUserListerExpansion
}

// cephObjectStoreUserLister implements the CephObjectStoreUserLister interface.
type cephObjectStoreUserLister struct {
	indexer cache.Indexer
}

// NewCephObjectStoreUserLister returns a new CephObjectStoreUserLister.
func NewCephObjectStoreUserLister(indexer cache.Indexer) CephObjectStoreUserLister {
	return &cephObjectStoreUserLister{indexer: indexer}
}

// List lists all CephObjectStoreUsers in the indexer.
func (s *cephObjectStoreUserLister) List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectStoreUser))
	})
	return ret, err
}

// CephObjectStoreUsers returns an object that can list and get CephObjectStoreUsers.
func (s *cephObjectStoreUserLister) CephObjectStoreUsers(namespace string) CephObjectStoreUserNamespaceLister {
	return cephObjectStoreUserNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephObjectStoreUserNamespaceLister helps list and get CephObjectStoreUsers.
type CephObjectStoreUserNamespaceLister interface {
	// List lists all CephObjectStoreUsers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error)
	// Get retrieves the CephObjectStoreUser from the indexer for a given namespace and name.
	Get(name string) (*v1.CephObjectStoreUser, error)
	CephObjectStoreUserNamespaceListerExpansion
}

// cephObjectStoreUserNamespaceLister implements the CephObjectStoreUserNamespaceLister
// interface.
type cephObjectStoreUserNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephObjectStoreUsers in the indexer for a given namespace.
func (s cephObjectStoreUserNamespaceLister) List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectStoreUser))
	})
	return ret, err
}

// Get retrieves the CephObjectStoreUser from the indexer for a given namespace and name.
func (s cephObjectStoreUserNamespaceLister) Get(name string) (*v1.CephObjectStoreUser, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephobjectstoreuser"), name)
	}
	return obj.(*v1.CephObjectStoreUser), nil
}
