# Contributing to Pro Git (2nd Edition)

## Licensing

By opening a pull request to this repository, you agree to provide your work under the [project license](LICENSE.asc).
Also, you agree to grant such license of your work as is required for the purposes of future print editions to @ben and @schacon.
Should your changes appear in a printed edition, you'll be included in the [contributors list](book/contributors.asc).

## Signaling an Issue

Before signaling an issue, please check that there isn't already a similar one in the bug tracking system.

Also, if this issue has been spotted on the git-scm.com site, please cross-check that it is still present in the pdf version.
The issue may have already been corrected, but the changes have not been deployed yet.

## Small Corrections

Errata and basic clarifications will be accepted if we agree that they improve the content.
You can also open an issue so we can figure out how or if it needs to be addressed.

If you've never done this before, the [flow guide](https://guides.github.com/introduction/flow/) might be useful.

## Large Rewrites

Open an issue for discussion before you start.
These changes tend to be very subjective, often only clarifying things for some small percentage of people and it's rarely worth the time to accept them.
Professional copy editors have already reviewed this content multiple times so while you may have somewhat better taste and grammar than we do it's unlikely that your prose is going to be *so* much better that it's worth changing vast swaths of text.

## Figures

The images in this book were generated using [Sketch 3](https://www.sketchapp.com/), with the [included sketchbook file](diagram-source/progit.sketch).

To add a figure:

1. Add a page to the sketchbook.
Try to use the included symbols wherever possible.
2. Add a "slice" to your page.
Give it a name that matches the destination PNG filename, relative from the root of the source directory.
3. Make sure your slice is set to export at "800w".


## Translations

If you would like to contribute to translating Pro Git into your language, take a look at [TRANSLATING.md](TRANSLATING.md).
