#ifndef CAPSTONE_XTENSA_H
#define CAPSTONE_XTENSA_H

#ifdef __cplusplus
extern "C" {
#endif

#include "cs_operand.h"
#include "platform.h"

/// Xtensa registers
typedef enum xtensa_reg {
	// generated content <XtensaGenCSRegEnum.inc> begin
	// clang-format off

	XTENSA_REG_INVALID = 0,
	XTENSA_REG_ACCHI = 1,
	XTENSA_REG_ACCLO = 2,
	XTENSA_REG_ACCX = 3,
	XTENSA_REG_ATOMCTL = 4,
	XTENSA_REG_BREG = 5,
	XTENSA_REG_CCOUNT = 6,
	XTENSA_REG_CPENABLE = 7,
	XTENSA_REG_DDR = 8,
	XTENSA_REG_DEBUGCAUSE = 9,
	XTENSA_REG_DEPC = 10,
	XTENSA_REG_EXCCAUSE = 11,
	XTENSA_REG_EXCVADDR = 12,
	XTENSA_REG_EXPSTATE = 13,
	XTENSA_REG_FCR = 14,
	XTENSA_REG_FFT_BIT_WIDTH = 15,
	XTENSA_REG_FSR = 16,
	XTENSA_REG_GPIO_OUT = 17,
	XTENSA_REG_IBREAKENABLE = 18,
	XTENSA_REG_ICOUNT = 19,
	XTENSA_REG_ICOUNTLEVEL = 20,
	XTENSA_REG_INTCLEAR = 21,
	XTENSA_REG_INTENABLE = 22,
	XTENSA_REG_INTERRUPT = 23,
	XTENSA_REG_LBEG = 24,
	XTENSA_REG_LCOUNT = 25,
	XTENSA_REG_LEND = 26,
	XTENSA_REG_LITBASE = 27,
	XTENSA_REG_MEMCTL = 28,
	XTENSA_REG_PRID = 29,
	XTENSA_REG_PS = 30,
	XTENSA_REG_QACC = 31,
	XTENSA_REG_SAR = 32,
	XTENSA_REG_SAR_BYTE = 33,
	XTENSA_REG_SP = 34,
	XTENSA_REG_THREADPTR = 35,
	XTENSA_REG_UA_STATE = 36,
	XTENSA_REG_VECBASE = 37,
	XTENSA_REG_WINDOWBASE = 38,
	XTENSA_REG_WINDOWSTART = 39,
	XTENSA_REG_A0 = 40,
	XTENSA_REG_A2 = 41,
	XTENSA_REG_A3 = 42,
	XTENSA_REG_A4 = 43,
	XTENSA_REG_A5 = 44,
	XTENSA_REG_A6 = 45,
	XTENSA_REG_A7 = 46,
	XTENSA_REG_A8 = 47,
	XTENSA_REG_A9 = 48,
	XTENSA_REG_A10 = 49,
	XTENSA_REG_A11 = 50,
	XTENSA_REG_A12 = 51,
	XTENSA_REG_A13 = 52,
	XTENSA_REG_A14 = 53,
	XTENSA_REG_A15 = 54,
	XTENSA_REG_AED0 = 55,
	XTENSA_REG_AED1 = 56,
	XTENSA_REG_AED2 = 57,
	XTENSA_REG_AED3 = 58,
	XTENSA_REG_AED4 = 59,
	XTENSA_REG_AED5 = 60,
	XTENSA_REG_AED6 = 61,
	XTENSA_REG_AED7 = 62,
	XTENSA_REG_AED8 = 63,
	XTENSA_REG_AED9 = 64,
	XTENSA_REG_AED10 = 65,
	XTENSA_REG_AED11 = 66,
	XTENSA_REG_AED12 = 67,
	XTENSA_REG_AED13 = 68,
	XTENSA_REG_AED14 = 69,
	XTENSA_REG_AED15 = 70,
	XTENSA_REG_B0 = 71,
	XTENSA_REG_B1 = 72,
	XTENSA_REG_B2 = 73,
	XTENSA_REG_B3 = 74,
	XTENSA_REG_B4 = 75,
	XTENSA_REG_B5 = 76,
	XTENSA_REG_B6 = 77,
	XTENSA_REG_B7 = 78,
	XTENSA_REG_B8 = 79,
	XTENSA_REG_B9 = 80,
	XTENSA_REG_B10 = 81,
	XTENSA_REG_B11 = 82,
	XTENSA_REG_B12 = 83,
	XTENSA_REG_B13 = 84,
	XTENSA_REG_B14 = 85,
	XTENSA_REG_B15 = 86,
	XTENSA_REG_CCOMPARE0 = 87,
	XTENSA_REG_CCOMPARE1 = 88,
	XTENSA_REG_CCOMPARE2 = 89,
	XTENSA_REG_CONFIGID0 = 90,
	XTENSA_REG_CONFIGID1 = 91,
	XTENSA_REG_DBREAKA0 = 92,
	XTENSA_REG_DBREAKA1 = 93,
	XTENSA_REG_DBREAKC0 = 94,
	XTENSA_REG_DBREAKC1 = 95,
	XTENSA_REG_EPC1 = 96,
	XTENSA_REG_EPC2 = 97,
	XTENSA_REG_EPC3 = 98,
	XTENSA_REG_EPC4 = 99,
	XTENSA_REG_EPC5 = 100,
	XTENSA_REG_EPC6 = 101,
	XTENSA_REG_EPC7 = 102,
	XTENSA_REG_EPS2 = 103,
	XTENSA_REG_EPS3 = 104,
	XTENSA_REG_EPS4 = 105,
	XTENSA_REG_EPS5 = 106,
	XTENSA_REG_EPS6 = 107,
	XTENSA_REG_EPS7 = 108,
	XTENSA_REG_EXCSAVE1 = 109,
	XTENSA_REG_EXCSAVE2 = 110,
	XTENSA_REG_EXCSAVE3 = 111,
	XTENSA_REG_EXCSAVE4 = 112,
	XTENSA_REG_EXCSAVE5 = 113,
	XTENSA_REG_EXCSAVE6 = 114,
	XTENSA_REG_EXCSAVE7 = 115,
	XTENSA_REG_F0 = 116,
	XTENSA_REG_F1 = 117,
	XTENSA_REG_F2 = 118,
	XTENSA_REG_F3 = 119,
	XTENSA_REG_F4 = 120,
	XTENSA_REG_F5 = 121,
	XTENSA_REG_F6 = 122,
	XTENSA_REG_F7 = 123,
	XTENSA_REG_F8 = 124,
	XTENSA_REG_F9 = 125,
	XTENSA_REG_F10 = 126,
	XTENSA_REG_F11 = 127,
	XTENSA_REG_F12 = 128,
	XTENSA_REG_F13 = 129,
	XTENSA_REG_F14 = 130,
	XTENSA_REG_F15 = 131,
	XTENSA_REG_IBREAKA0 = 132,
	XTENSA_REG_IBREAKA1 = 133,
	XTENSA_REG_M0 = 134,
	XTENSA_REG_M1 = 135,
	XTENSA_REG_M2 = 136,
	XTENSA_REG_M3 = 137,
	XTENSA_REG_MISC0 = 138,
	XTENSA_REG_MISC1 = 139,
	XTENSA_REG_MISC2 = 140,
	XTENSA_REG_MISC3 = 141,
	XTENSA_REG_Q0 = 142,
	XTENSA_REG_Q1 = 143,
	XTENSA_REG_Q2 = 144,
	XTENSA_REG_Q3 = 145,
	XTENSA_REG_Q4 = 146,
	XTENSA_REG_Q5 = 147,
	XTENSA_REG_Q6 = 148,
	XTENSA_REG_Q7 = 149,
	XTENSA_REG_SCOMPARE1 = 150,
	XTENSA_REG_U0 = 151,
	XTENSA_REG_U1 = 152,
	XTENSA_REG_U2 = 153,
	XTENSA_REG_U3 = 154,
	XTENSA_REG_F64R_HI = 155,
	XTENSA_REG_F64R_LO = 156,
	XTENSA_REG_F64S = 157,
	XTENSA_REG_B0_B1 = 158,
	XTENSA_REG_B2_B3 = 159,
	XTENSA_REG_B4_B5 = 160,
	XTENSA_REG_B6_B7 = 161,
	XTENSA_REG_B8_B9 = 162,
	XTENSA_REG_B10_B11 = 163,
	XTENSA_REG_B12_B13 = 164,
	XTENSA_REG_B14_B15 = 165,
	XTENSA_REG_B0_B1_B2_B3 = 166,
	XTENSA_REG_B4_B5_B6_B7 = 167,
	XTENSA_REG_B8_B9_B10_B11 = 168,
	XTENSA_REG_B12_B13_B14_B15 = 169,
	XTENSA_REG_ENDING, // 170

	// clang-format on
	// generated content <XtensaGenCSRegEnum.inc> end
} xtensa_reg;

/// Xtensa registers
typedef enum xtensa_insn {
	// generated content <XtensaGenCSInsnEnum.inc> begin
	// clang-format off

	XTENSA_INS_INVALID,
	XTENSA_INS_ABS,
	XTENSA_INS_ABS_S,
	XTENSA_INS_ADD,
	XTENSA_INS_ADDEXPM_S,
	XTENSA_INS_ADDEXP_S,
	XTENSA_INS_ADDI,
	XTENSA_INS_ADDI_N,
	XTENSA_INS_ADDMI,
	XTENSA_INS_ADDX2,
	XTENSA_INS_ADDX4,
	XTENSA_INS_ADDX8,
	XTENSA_INS_ADD_N,
	XTENSA_INS_ADD_S,
	XTENSA_INS_AE_ABS16S,
	XTENSA_INS_AE_ABS24S,
	XTENSA_INS_AE_ABS32,
	XTENSA_INS_AE_ABS32S,
	XTENSA_INS_AE_ABS64,
	XTENSA_INS_AE_ABS64S,
	XTENSA_INS_AE_ADD16,
	XTENSA_INS_AE_ADD16S,
	XTENSA_INS_AE_ADD24S,
	XTENSA_INS_AE_ADD32,
	XTENSA_INS_AE_ADD32S,
	XTENSA_INS_AE_ADD32_HL_LH,
	XTENSA_INS_AE_ADD64,
	XTENSA_INS_AE_ADD64S,
	XTENSA_INS_AE_ADDBRBA32,
	XTENSA_INS_AE_ADDSUB32,
	XTENSA_INS_AE_ADDSUB32S,
	XTENSA_INS_AE_AND,
	XTENSA_INS_AE_CVT32X2F16_10,
	XTENSA_INS_AE_CVT32X2F16_32,
	XTENSA_INS_AE_CVT48A32,
	XTENSA_INS_AE_CVT64A32,
	XTENSA_INS_AE_CVT64F32_H,
	XTENSA_INS_AE_CVTA32F24S_H,
	XTENSA_INS_AE_CVTA32F24S_L,
	XTENSA_INS_AE_CVTQ56A32S,
	XTENSA_INS_AE_CVTQ56P32S_H,
	XTENSA_INS_AE_CVTQ56P32S_L,
	XTENSA_INS_AE_DB,
	XTENSA_INS_AE_DBI,
	XTENSA_INS_AE_DBI_IC,
	XTENSA_INS_AE_DBI_IP,
	XTENSA_INS_AE_DB_IC,
	XTENSA_INS_AE_DB_IP,
	XTENSA_INS_AE_DIV64D32_H,
	XTENSA_INS_AE_DIV64D32_L,
	XTENSA_INS_AE_EQ16,
	XTENSA_INS_AE_EQ32,
	XTENSA_INS_AE_EQ64,
	XTENSA_INS_AE_L16M_I,
	XTENSA_INS_AE_L16M_IU,
	XTENSA_INS_AE_L16M_X,
	XTENSA_INS_AE_L16M_XC,
	XTENSA_INS_AE_L16M_XU,
	XTENSA_INS_AE_L16X2M_I,
	XTENSA_INS_AE_L16X2M_IU,
	XTENSA_INS_AE_L16X2M_X,
	XTENSA_INS_AE_L16X2M_XC,
	XTENSA_INS_AE_L16X2M_XU,
	XTENSA_INS_AE_L16X4_I,
	XTENSA_INS_AE_L16X4_IP,
	XTENSA_INS_AE_L16X4_RIC,
	XTENSA_INS_AE_L16X4_RIP,
	XTENSA_INS_AE_L16X4_X,
	XTENSA_INS_AE_L16X4_XC,
	XTENSA_INS_AE_L16X4_XP,
	XTENSA_INS_AE_L16_I,
	XTENSA_INS_AE_L16_IP,
	XTENSA_INS_AE_L16_X,
	XTENSA_INS_AE_L16_XC,
	XTENSA_INS_AE_L16_XP,
	XTENSA_INS_AE_L32F24_I,
	XTENSA_INS_AE_L32F24_IP,
	XTENSA_INS_AE_L32F24_X,
	XTENSA_INS_AE_L32F24_XC,
	XTENSA_INS_AE_L32F24_XP,
	XTENSA_INS_AE_L32M_I,
	XTENSA_INS_AE_L32M_IU,
	XTENSA_INS_AE_L32M_X,
	XTENSA_INS_AE_L32M_XC,
	XTENSA_INS_AE_L32M_XU,
	XTENSA_INS_AE_L32X2F24_I,
	XTENSA_INS_AE_L32X2F24_IP,
	XTENSA_INS_AE_L32X2F24_RIC,
	XTENSA_INS_AE_L32X2F24_RIP,
	XTENSA_INS_AE_L32X2F24_X,
	XTENSA_INS_AE_L32X2F24_XC,
	XTENSA_INS_AE_L32X2F24_XP,
	XTENSA_INS_AE_L32X2_I,
	XTENSA_INS_AE_L32X2_IP,
	XTENSA_INS_AE_L32X2_RIC,
	XTENSA_INS_AE_L32X2_RIP,
	XTENSA_INS_AE_L32X2_X,
	XTENSA_INS_AE_L32X2_XC,
	XTENSA_INS_AE_L32X2_XP,
	XTENSA_INS_AE_L32_I,
	XTENSA_INS_AE_L32_IP,
	XTENSA_INS_AE_L32_X,
	XTENSA_INS_AE_L32_XC,
	XTENSA_INS_AE_L32_XP,
	XTENSA_INS_AE_L64_I,
	XTENSA_INS_AE_L64_IP,
	XTENSA_INS_AE_L64_X,
	XTENSA_INS_AE_L64_XC,
	XTENSA_INS_AE_L64_XP,
	XTENSA_INS_AE_LA16X4NEG_PC,
	XTENSA_INS_AE_LA16X4POS_PC,
	XTENSA_INS_AE_LA16X4_IC,
	XTENSA_INS_AE_LA16X4_IP,
	XTENSA_INS_AE_LA16X4_RIC,
	XTENSA_INS_AE_LA16X4_RIP,
	XTENSA_INS_AE_LA24NEG_PC,
	XTENSA_INS_AE_LA24POS_PC,
	XTENSA_INS_AE_LA24X2NEG_PC,
	XTENSA_INS_AE_LA24X2POS_PC,
	XTENSA_INS_AE_LA24X2_IC,
	XTENSA_INS_AE_LA24X2_IP,
	XTENSA_INS_AE_LA24X2_RIC,
	XTENSA_INS_AE_LA24X2_RIP,
	XTENSA_INS_AE_LA24_IC,
	XTENSA_INS_AE_LA24_IP,
	XTENSA_INS_AE_LA24_RIC,
	XTENSA_INS_AE_LA24_RIP,
	XTENSA_INS_AE_LA32X2F24_IC,
	XTENSA_INS_AE_LA32X2F24_IP,
	XTENSA_INS_AE_LA32X2F24_RIC,
	XTENSA_INS_AE_LA32X2F24_RIP,
	XTENSA_INS_AE_LA32X2NEG_PC,
	XTENSA_INS_AE_LA32X2POS_PC,
	XTENSA_INS_AE_LA32X2_IC,
	XTENSA_INS_AE_LA32X2_IP,
	XTENSA_INS_AE_LA32X2_RIC,
	XTENSA_INS_AE_LA32X2_RIP,
	XTENSA_INS_AE_LA64_PP,
	XTENSA_INS_AE_LALIGN64_I,
	XTENSA_INS_AE_LB,
	XTENSA_INS_AE_LBI,
	XTENSA_INS_AE_LBK,
	XTENSA_INS_AE_LBKI,
	XTENSA_INS_AE_LBS,
	XTENSA_INS_AE_LBSI,
	XTENSA_INS_AE_LE16,
	XTENSA_INS_AE_LE32,
	XTENSA_INS_AE_LE64,
	XTENSA_INS_AE_LT16,
	XTENSA_INS_AE_LT32,
	XTENSA_INS_AE_LT64,
	XTENSA_INS_AE_MAX32,
	XTENSA_INS_AE_MAX64,
	XTENSA_INS_AE_MAXABS32S,
	XTENSA_INS_AE_MAXABS64S,
	XTENSA_INS_AE_MIN32,
	XTENSA_INS_AE_MIN64,
	XTENSA_INS_AE_MINABS32S,
	XTENSA_INS_AE_MINABS64S,
	XTENSA_INS_AE_MOV,
	XTENSA_INS_AE_MOVAD16_0,
	XTENSA_INS_AE_MOVAD16_1,
	XTENSA_INS_AE_MOVAD16_2,
	XTENSA_INS_AE_MOVAD16_3,
	XTENSA_INS_AE_MOVAD32_H,
	XTENSA_INS_AE_MOVAD32_L,
	XTENSA_INS_AE_MOVALIGN,
	XTENSA_INS_AE_MOVDA16,
	XTENSA_INS_AE_MOVDA16X2,
	XTENSA_INS_AE_MOVDA32,
	XTENSA_INS_AE_MOVDA32X2,
	XTENSA_INS_AE_MOVF16X4,
	XTENSA_INS_AE_MOVF32X2,
	XTENSA_INS_AE_MOVF64,
	XTENSA_INS_AE_MOVI,
	XTENSA_INS_AE_MOVT16X4,
	XTENSA_INS_AE_MOVT32X2,
	XTENSA_INS_AE_MOVT64,
	XTENSA_INS_AE_MUL16X4,
	XTENSA_INS_AE_MUL32U_LL,
	XTENSA_INS_AE_MUL32X16_H0,
	XTENSA_INS_AE_MUL32X16_H0_S2,
	XTENSA_INS_AE_MUL32X16_H1,
	XTENSA_INS_AE_MUL32X16_H1_S2,
	XTENSA_INS_AE_MUL32X16_H2,
	XTENSA_INS_AE_MUL32X16_H2_S2,
	XTENSA_INS_AE_MUL32X16_H3,
	XTENSA_INS_AE_MUL32X16_H3_S2,
	XTENSA_INS_AE_MUL32X16_L0,
	XTENSA_INS_AE_MUL32X16_L0_S2,
	XTENSA_INS_AE_MUL32X16_L1,
	XTENSA_INS_AE_MUL32X16_L1_S2,
	XTENSA_INS_AE_MUL32X16_L2,
	XTENSA_INS_AE_MUL32X16_L2_S2,
	XTENSA_INS_AE_MUL32X16_L3,
	XTENSA_INS_AE_MUL32X16_L3_S2,
	XTENSA_INS_AE_MUL32_HH,
	XTENSA_INS_AE_MUL32_LH,
	XTENSA_INS_AE_MUL32_LL,
	XTENSA_INS_AE_MUL32_LL_S2,
	XTENSA_INS_AE_MULA16X4,
	XTENSA_INS_AE_MULA32U_LL,
	XTENSA_INS_AE_MULA32X16_H0,
	XTENSA_INS_AE_MULA32X16_H0_S2,
	XTENSA_INS_AE_MULA32X16_H1,
	XTENSA_INS_AE_MULA32X16_H1_S2,
	XTENSA_INS_AE_MULA32X16_H2,
	XTENSA_INS_AE_MULA32X16_H2_S2,
	XTENSA_INS_AE_MULA32X16_H3,
	XTENSA_INS_AE_MULA32X16_H3_S2,
	XTENSA_INS_AE_MULA32X16_L0,
	XTENSA_INS_AE_MULA32X16_L0_S2,
	XTENSA_INS_AE_MULA32X16_L1,
	XTENSA_INS_AE_MULA32X16_L1_S2,
	XTENSA_INS_AE_MULA32X16_L2,
	XTENSA_INS_AE_MULA32X16_L2_S2,
	XTENSA_INS_AE_MULA32X16_L3,
	XTENSA_INS_AE_MULA32X16_L3_S2,
	XTENSA_INS_AE_MULA32_HH,
	XTENSA_INS_AE_MULA32_LH,
	XTENSA_INS_AE_MULA32_LL,
	XTENSA_INS_AE_MULA32_LL_S2,
	XTENSA_INS_AE_MULAAD24_HH_LL,
	XTENSA_INS_AE_MULAAD24_HH_LL_S2,
	XTENSA_INS_AE_MULAAD24_HL_LH,
	XTENSA_INS_AE_MULAAD24_HL_LH_S2,
	XTENSA_INS_AE_MULAAD32X16_H0_L1,
	XTENSA_INS_AE_MULAAD32X16_H0_L1_S2,
	XTENSA_INS_AE_MULAAD32X16_H1_L0,
	XTENSA_INS_AE_MULAAD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULAAD32X16_H2_L3,
	XTENSA_INS_AE_MULAAD32X16_H2_L3_S2,
	XTENSA_INS_AE_MULAAD32X16_H3_L2,
	XTENSA_INS_AE_MULAAD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULAAFD16SS_11_00,
	XTENSA_INS_AE_MULAAFD16SS_11_00_S2,
	XTENSA_INS_AE_MULAAFD16SS_13_02,
	XTENSA_INS_AE_MULAAFD16SS_13_02_S2,
	XTENSA_INS_AE_MULAAFD16SS_33_22,
	XTENSA_INS_AE_MULAAFD16SS_33_22_S2,
	XTENSA_INS_AE_MULAAFD24_HH_LL,
	XTENSA_INS_AE_MULAAFD24_HH_LL_S2,
	XTENSA_INS_AE_MULAAFD24_HL_LH,
	XTENSA_INS_AE_MULAAFD24_HL_LH_S2,
	XTENSA_INS_AE_MULAAFD32X16_H0_L1,
	XTENSA_INS_AE_MULAAFD32X16_H0_L1_S2,
	XTENSA_INS_AE_MULAAFD32X16_H1_L0,
	XTENSA_INS_AE_MULAAFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULAAFD32X16_H2_L3,
	XTENSA_INS_AE_MULAAFD32X16_H2_L3_S2,
	XTENSA_INS_AE_MULAAFD32X16_H3_L2,
	XTENSA_INS_AE_MULAAFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULAC24,
	XTENSA_INS_AE_MULAC32X16_H,
	XTENSA_INS_AE_MULAC32X16_L,
	XTENSA_INS_AE_MULAF16SS_00,
	XTENSA_INS_AE_MULAF16SS_00_S2,
	XTENSA_INS_AE_MULAF16SS_10,
	XTENSA_INS_AE_MULAF16SS_11,
	XTENSA_INS_AE_MULAF16SS_20,
	XTENSA_INS_AE_MULAF16SS_21,
	XTENSA_INS_AE_MULAF16SS_22,
	XTENSA_INS_AE_MULAF16SS_30,
	XTENSA_INS_AE_MULAF16SS_31,
	XTENSA_INS_AE_MULAF16SS_32,
	XTENSA_INS_AE_MULAF16SS_33,
	XTENSA_INS_AE_MULAF16X4SS,
	XTENSA_INS_AE_MULAF32R_HH,
	XTENSA_INS_AE_MULAF32R_LH,
	XTENSA_INS_AE_MULAF32R_LL,
	XTENSA_INS_AE_MULAF32R_LL_S2,
	XTENSA_INS_AE_MULAF32S_HH,
	XTENSA_INS_AE_MULAF32S_LH,
	XTENSA_INS_AE_MULAF32S_LL,
	XTENSA_INS_AE_MULAF32S_LL_S2,
	XTENSA_INS_AE_MULAF32X16_H0,
	XTENSA_INS_AE_MULAF32X16_H0_S2,
	XTENSA_INS_AE_MULAF32X16_H1,
	XTENSA_INS_AE_MULAF32X16_H1_S2,
	XTENSA_INS_AE_MULAF32X16_H2,
	XTENSA_INS_AE_MULAF32X16_H2_S2,
	XTENSA_INS_AE_MULAF32X16_H3,
	XTENSA_INS_AE_MULAF32X16_H3_S2,
	XTENSA_INS_AE_MULAF32X16_L0,
	XTENSA_INS_AE_MULAF32X16_L0_S2,
	XTENSA_INS_AE_MULAF32X16_L1,
	XTENSA_INS_AE_MULAF32X16_L1_S2,
	XTENSA_INS_AE_MULAF32X16_L2,
	XTENSA_INS_AE_MULAF32X16_L2_S2,
	XTENSA_INS_AE_MULAF32X16_L3,
	XTENSA_INS_AE_MULAF32X16_L3_S2,
	XTENSA_INS_AE_MULAF48Q32SP16S_L,
	XTENSA_INS_AE_MULAF48Q32SP16S_L_S2,
	XTENSA_INS_AE_MULAF48Q32SP16U_L,
	XTENSA_INS_AE_MULAF48Q32SP16U_L_S2,
	XTENSA_INS_AE_MULAFC24RA,
	XTENSA_INS_AE_MULAFC32X16RAS_H,
	XTENSA_INS_AE_MULAFC32X16RAS_L,
	XTENSA_INS_AE_MULAFD24X2_FIR_H,
	XTENSA_INS_AE_MULAFD24X2_FIR_L,
	XTENSA_INS_AE_MULAFD32X16X2_FIR_HH,
	XTENSA_INS_AE_MULAFD32X16X2_FIR_HL,
	XTENSA_INS_AE_MULAFD32X16X2_FIR_LH,
	XTENSA_INS_AE_MULAFD32X16X2_FIR_LL,
	XTENSA_INS_AE_MULAFP24X2R,
	XTENSA_INS_AE_MULAFP24X2RA,
	XTENSA_INS_AE_MULAFP24X2RA_S2,
	XTENSA_INS_AE_MULAFP24X2R_S2,
	XTENSA_INS_AE_MULAFP32X16X2RAS_H,
	XTENSA_INS_AE_MULAFP32X16X2RAS_H_S2,
	XTENSA_INS_AE_MULAFP32X16X2RAS_L,
	XTENSA_INS_AE_MULAFP32X16X2RAS_L_S2,
	XTENSA_INS_AE_MULAFP32X16X2RS_H,
	XTENSA_INS_AE_MULAFP32X16X2RS_H_S2,
	XTENSA_INS_AE_MULAFP32X16X2RS_L,
	XTENSA_INS_AE_MULAFP32X16X2RS_L_S2,
	XTENSA_INS_AE_MULAFP32X2RAS,
	XTENSA_INS_AE_MULAFP32X2RS,
	XTENSA_INS_AE_MULAFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULAFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULAP24X2,
	XTENSA_INS_AE_MULAP24X2_S2,
	XTENSA_INS_AE_MULAP32X16X2_H,
	XTENSA_INS_AE_MULAP32X16X2_L,
	XTENSA_INS_AE_MULAP32X2,
	XTENSA_INS_AE_MULAQ32SP16S_L_S2,
	XTENSA_INS_AE_MULAQ32SP16U_L_S2,
	XTENSA_INS_AE_MULARFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULARFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULAS32F48P16S_HH,
	XTENSA_INS_AE_MULAS32F48P16S_HH_S2,
	XTENSA_INS_AE_MULAS32F48P16S_LH,
	XTENSA_INS_AE_MULAS32F48P16S_LH_S2,
	XTENSA_INS_AE_MULAS32F48P16S_LL,
	XTENSA_INS_AE_MULAS32F48P16S_LL_S2,
	XTENSA_INS_AE_MULASD24_HH_LL,
	XTENSA_INS_AE_MULASD24_HH_LL_S2,
	XTENSA_INS_AE_MULASD24_HL_LH,
	XTENSA_INS_AE_MULASD24_HL_LH_S2,
	XTENSA_INS_AE_MULASD32X16_H1_L0,
	XTENSA_INS_AE_MULASD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULASD32X16_H3_L2,
	XTENSA_INS_AE_MULASD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULASFD24_HH_LL,
	XTENSA_INS_AE_MULASFD24_HH_LL_S2,
	XTENSA_INS_AE_MULASFD24_HL_LH,
	XTENSA_INS_AE_MULASFD24_HL_LH_S2,
	XTENSA_INS_AE_MULASFD32X16_H1_L0,
	XTENSA_INS_AE_MULASFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULASFD32X16_H3_L2,
	XTENSA_INS_AE_MULASFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULC24,
	XTENSA_INS_AE_MULC32X16_H,
	XTENSA_INS_AE_MULC32X16_L,
	XTENSA_INS_AE_MULF16SS_00,
	XTENSA_INS_AE_MULF16SS_00_S2,
	XTENSA_INS_AE_MULF16SS_10,
	XTENSA_INS_AE_MULF16SS_11,
	XTENSA_INS_AE_MULF16SS_20,
	XTENSA_INS_AE_MULF16SS_21,
	XTENSA_INS_AE_MULF16SS_22,
	XTENSA_INS_AE_MULF16SS_30,
	XTENSA_INS_AE_MULF16SS_31,
	XTENSA_INS_AE_MULF16SS_32,
	XTENSA_INS_AE_MULF16SS_33,
	XTENSA_INS_AE_MULF16X4SS,
	XTENSA_INS_AE_MULF32R_HH,
	XTENSA_INS_AE_MULF32R_LH,
	XTENSA_INS_AE_MULF32R_LL,
	XTENSA_INS_AE_MULF32R_LL_S2,
	XTENSA_INS_AE_MULF32S_HH,
	XTENSA_INS_AE_MULF32S_LH,
	XTENSA_INS_AE_MULF32S_LL,
	XTENSA_INS_AE_MULF32S_LL_S2,
	XTENSA_INS_AE_MULF32X16_H0,
	XTENSA_INS_AE_MULF32X16_H0_S2,
	XTENSA_INS_AE_MULF32X16_H1,
	XTENSA_INS_AE_MULF32X16_H1_S2,
	XTENSA_INS_AE_MULF32X16_H2,
	XTENSA_INS_AE_MULF32X16_H2_S2,
	XTENSA_INS_AE_MULF32X16_H3,
	XTENSA_INS_AE_MULF32X16_H3_S2,
	XTENSA_INS_AE_MULF32X16_L0,
	XTENSA_INS_AE_MULF32X16_L0_S2,
	XTENSA_INS_AE_MULF32X16_L1,
	XTENSA_INS_AE_MULF32X16_L1_S2,
	XTENSA_INS_AE_MULF32X16_L2,
	XTENSA_INS_AE_MULF32X16_L2_S2,
	XTENSA_INS_AE_MULF32X16_L3,
	XTENSA_INS_AE_MULF32X16_L3_S2,
	XTENSA_INS_AE_MULF48Q32SP16S_L,
	XTENSA_INS_AE_MULF48Q32SP16S_L_S2,
	XTENSA_INS_AE_MULF48Q32SP16U_L,
	XTENSA_INS_AE_MULF48Q32SP16U_L_S2,
	XTENSA_INS_AE_MULFC24RA,
	XTENSA_INS_AE_MULFC32X16RAS_H,
	XTENSA_INS_AE_MULFC32X16RAS_L,
	XTENSA_INS_AE_MULFD24X2_FIR_H,
	XTENSA_INS_AE_MULFD24X2_FIR_L,
	XTENSA_INS_AE_MULFD32X16X2_FIR_HH,
	XTENSA_INS_AE_MULFD32X16X2_FIR_HL,
	XTENSA_INS_AE_MULFD32X16X2_FIR_LH,
	XTENSA_INS_AE_MULFD32X16X2_FIR_LL,
	XTENSA_INS_AE_MULFP16X4RAS,
	XTENSA_INS_AE_MULFP16X4S,
	XTENSA_INS_AE_MULFP24X2R,
	XTENSA_INS_AE_MULFP24X2RA,
	XTENSA_INS_AE_MULFP24X2RA_S2,
	XTENSA_INS_AE_MULFP24X2R_S2,
	XTENSA_INS_AE_MULFP32X16X2RAS_H,
	XTENSA_INS_AE_MULFP32X16X2RAS_H_S2,
	XTENSA_INS_AE_MULFP32X16X2RAS_L,
	XTENSA_INS_AE_MULFP32X16X2RAS_L_S2,
	XTENSA_INS_AE_MULFP32X16X2RS_H,
	XTENSA_INS_AE_MULFP32X16X2RS_H_S2,
	XTENSA_INS_AE_MULFP32X16X2RS_L,
	XTENSA_INS_AE_MULFP32X16X2RS_L_S2,
	XTENSA_INS_AE_MULFP32X2RAS,
	XTENSA_INS_AE_MULFP32X2RS,
	XTENSA_INS_AE_MULFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULP24X2,
	XTENSA_INS_AE_MULP24X2_S2,
	XTENSA_INS_AE_MULP32X16X2_H,
	XTENSA_INS_AE_MULP32X16X2_L,
	XTENSA_INS_AE_MULP32X2,
	XTENSA_INS_AE_MULQ32SP16S_L_S2,
	XTENSA_INS_AE_MULQ32SP16U_L_S2,
	XTENSA_INS_AE_MULRFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULRFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULS16X4,
	XTENSA_INS_AE_MULS32F48P16S_HH,
	XTENSA_INS_AE_MULS32F48P16S_HH_S2,
	XTENSA_INS_AE_MULS32F48P16S_LH,
	XTENSA_INS_AE_MULS32F48P16S_LH_S2,
	XTENSA_INS_AE_MULS32F48P16S_LL,
	XTENSA_INS_AE_MULS32F48P16S_LL_S2,
	XTENSA_INS_AE_MULS32U_LL,
	XTENSA_INS_AE_MULS32X16_H0,
	XTENSA_INS_AE_MULS32X16_H0_S2,
	XTENSA_INS_AE_MULS32X16_H1,
	XTENSA_INS_AE_MULS32X16_H1_S2,
	XTENSA_INS_AE_MULS32X16_H2,
	XTENSA_INS_AE_MULS32X16_H2_S2,
	XTENSA_INS_AE_MULS32X16_H3,
	XTENSA_INS_AE_MULS32X16_H3_S2,
	XTENSA_INS_AE_MULS32X16_L0,
	XTENSA_INS_AE_MULS32X16_L0_S2,
	XTENSA_INS_AE_MULS32X16_L1,
	XTENSA_INS_AE_MULS32X16_L1_S2,
	XTENSA_INS_AE_MULS32X16_L2,
	XTENSA_INS_AE_MULS32X16_L2_S2,
	XTENSA_INS_AE_MULS32X16_L3,
	XTENSA_INS_AE_MULS32X16_L3_S2,
	XTENSA_INS_AE_MULS32_HH,
	XTENSA_INS_AE_MULS32_LH,
	XTENSA_INS_AE_MULS32_LL,
	XTENSA_INS_AE_MULSAD24_HH_LL,
	XTENSA_INS_AE_MULSAD24_HH_LL_S2,
	XTENSA_INS_AE_MULSAD32X16_H1_L0,
	XTENSA_INS_AE_MULSAD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULSAD32X16_H3_L2,
	XTENSA_INS_AE_MULSAD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULSAFD24_HH_LL,
	XTENSA_INS_AE_MULSAFD24_HH_LL_S2,
	XTENSA_INS_AE_MULSAFD32X16_H1_L0,
	XTENSA_INS_AE_MULSAFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULSAFD32X16_H3_L2,
	XTENSA_INS_AE_MULSAFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULSF16SS_00,
	XTENSA_INS_AE_MULSF16SS_00_S2,
	XTENSA_INS_AE_MULSF16SS_10,
	XTENSA_INS_AE_MULSF16SS_11,
	XTENSA_INS_AE_MULSF16SS_20,
	XTENSA_INS_AE_MULSF16SS_21,
	XTENSA_INS_AE_MULSF16SS_22,
	XTENSA_INS_AE_MULSF16SS_30,
	XTENSA_INS_AE_MULSF16SS_31,
	XTENSA_INS_AE_MULSF16SS_32,
	XTENSA_INS_AE_MULSF16SS_33,
	XTENSA_INS_AE_MULSF16X4SS,
	XTENSA_INS_AE_MULSF32R_HH,
	XTENSA_INS_AE_MULSF32R_LH,
	XTENSA_INS_AE_MULSF32R_LL,
	XTENSA_INS_AE_MULSF32R_LL_S2,
	XTENSA_INS_AE_MULSF32S_HH,
	XTENSA_INS_AE_MULSF32S_LH,
	XTENSA_INS_AE_MULSF32S_LL,
	XTENSA_INS_AE_MULSF32X16_H0,
	XTENSA_INS_AE_MULSF32X16_H0_S2,
	XTENSA_INS_AE_MULSF32X16_H1,
	XTENSA_INS_AE_MULSF32X16_H1_S2,
	XTENSA_INS_AE_MULSF32X16_H2,
	XTENSA_INS_AE_MULSF32X16_H2_S2,
	XTENSA_INS_AE_MULSF32X16_H3,
	XTENSA_INS_AE_MULSF32X16_H3_S2,
	XTENSA_INS_AE_MULSF32X16_L0,
	XTENSA_INS_AE_MULSF32X16_L0_S2,
	XTENSA_INS_AE_MULSF32X16_L1,
	XTENSA_INS_AE_MULSF32X16_L1_S2,
	XTENSA_INS_AE_MULSF32X16_L2,
	XTENSA_INS_AE_MULSF32X16_L2_S2,
	XTENSA_INS_AE_MULSF32X16_L3,
	XTENSA_INS_AE_MULSF32X16_L3_S2,
	XTENSA_INS_AE_MULSF48Q32SP16S_L,
	XTENSA_INS_AE_MULSF48Q32SP16S_L_S2,
	XTENSA_INS_AE_MULSF48Q32SP16U_L,
	XTENSA_INS_AE_MULSF48Q32SP16U_L_S2,
	XTENSA_INS_AE_MULSFP24X2R,
	XTENSA_INS_AE_MULSFP24X2RA,
	XTENSA_INS_AE_MULSFP24X2RA_S2,
	XTENSA_INS_AE_MULSFP24X2R_S2,
	XTENSA_INS_AE_MULSFP32X16X2RAS_H,
	XTENSA_INS_AE_MULSFP32X16X2RAS_H_S2,
	XTENSA_INS_AE_MULSFP32X16X2RAS_L,
	XTENSA_INS_AE_MULSFP32X16X2RAS_L_S2,
	XTENSA_INS_AE_MULSFP32X16X2RS_H,
	XTENSA_INS_AE_MULSFP32X16X2RS_H_S2,
	XTENSA_INS_AE_MULSFP32X16X2RS_L,
	XTENSA_INS_AE_MULSFP32X16X2RS_L_S2,
	XTENSA_INS_AE_MULSFP32X2RAS,
	XTENSA_INS_AE_MULSFP32X2RS,
	XTENSA_INS_AE_MULSFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULSFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULSP24X2,
	XTENSA_INS_AE_MULSP24X2_S2,
	XTENSA_INS_AE_MULSP32X16X2_H,
	XTENSA_INS_AE_MULSP32X16X2_L,
	XTENSA_INS_AE_MULSP32X2,
	XTENSA_INS_AE_MULSQ32SP16S_L_S2,
	XTENSA_INS_AE_MULSQ32SP16U_L_S2,
	XTENSA_INS_AE_MULSRFQ32SP24S_H_S2,
	XTENSA_INS_AE_MULSRFQ32SP24S_L_S2,
	XTENSA_INS_AE_MULSS32F48P16S_HH,
	XTENSA_INS_AE_MULSS32F48P16S_HH_S2,
	XTENSA_INS_AE_MULSS32F48P16S_LH,
	XTENSA_INS_AE_MULSS32F48P16S_LH_S2,
	XTENSA_INS_AE_MULSS32F48P16S_LL,
	XTENSA_INS_AE_MULSS32F48P16S_LL_S2,
	XTENSA_INS_AE_MULSSD24_HH_LL,
	XTENSA_INS_AE_MULSSD24_HH_LL_S2,
	XTENSA_INS_AE_MULSSD24_HL_LH,
	XTENSA_INS_AE_MULSSD24_HL_LH_S2,
	XTENSA_INS_AE_MULSSD32X16_H1_L0,
	XTENSA_INS_AE_MULSSD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULSSD32X16_H3_L2,
	XTENSA_INS_AE_MULSSD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULSSFD16SS_11_00,
	XTENSA_INS_AE_MULSSFD16SS_11_00_S2,
	XTENSA_INS_AE_MULSSFD16SS_13_02,
	XTENSA_INS_AE_MULSSFD16SS_13_02_S2,
	XTENSA_INS_AE_MULSSFD16SS_33_22,
	XTENSA_INS_AE_MULSSFD16SS_33_22_S2,
	XTENSA_INS_AE_MULSSFD24_HH_LL,
	XTENSA_INS_AE_MULSSFD24_HH_LL_S2,
	XTENSA_INS_AE_MULSSFD24_HL_LH,
	XTENSA_INS_AE_MULSSFD24_HL_LH_S2,
	XTENSA_INS_AE_MULSSFD32X16_H1_L0,
	XTENSA_INS_AE_MULSSFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULSSFD32X16_H3_L2,
	XTENSA_INS_AE_MULSSFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZAAD24_HH_LL,
	XTENSA_INS_AE_MULZAAD24_HH_LL_S2,
	XTENSA_INS_AE_MULZAAD24_HL_LH,
	XTENSA_INS_AE_MULZAAD24_HL_LH_S2,
	XTENSA_INS_AE_MULZAAD32X16_H0_L1,
	XTENSA_INS_AE_MULZAAD32X16_H0_L1_S2,
	XTENSA_INS_AE_MULZAAD32X16_H1_L0,
	XTENSA_INS_AE_MULZAAD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZAAD32X16_H2_L3,
	XTENSA_INS_AE_MULZAAD32X16_H2_L3_S2,
	XTENSA_INS_AE_MULZAAD32X16_H3_L2,
	XTENSA_INS_AE_MULZAAD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZAAFD16SS_11_00,
	XTENSA_INS_AE_MULZAAFD16SS_11_00_S2,
	XTENSA_INS_AE_MULZAAFD16SS_13_02,
	XTENSA_INS_AE_MULZAAFD16SS_13_02_S2,
	XTENSA_INS_AE_MULZAAFD16SS_33_22,
	XTENSA_INS_AE_MULZAAFD16SS_33_22_S2,
	XTENSA_INS_AE_MULZAAFD24_HH_LL,
	XTENSA_INS_AE_MULZAAFD24_HH_LL_S2,
	XTENSA_INS_AE_MULZAAFD24_HL_LH,
	XTENSA_INS_AE_MULZAAFD24_HL_LH_S2,
	XTENSA_INS_AE_MULZAAFD32X16_H0_L1,
	XTENSA_INS_AE_MULZAAFD32X16_H0_L1_S2,
	XTENSA_INS_AE_MULZAAFD32X16_H1_L0,
	XTENSA_INS_AE_MULZAAFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZAAFD32X16_H2_L3,
	XTENSA_INS_AE_MULZAAFD32X16_H2_L3_S2,
	XTENSA_INS_AE_MULZAAFD32X16_H3_L2,
	XTENSA_INS_AE_MULZAAFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZASD24_HH_LL,
	XTENSA_INS_AE_MULZASD24_HH_LL_S2,
	XTENSA_INS_AE_MULZASD24_HL_LH,
	XTENSA_INS_AE_MULZASD24_HL_LH_S2,
	XTENSA_INS_AE_MULZASD32X16_H1_L0,
	XTENSA_INS_AE_MULZASD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZASD32X16_H3_L2,
	XTENSA_INS_AE_MULZASD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZASFD24_HH_LL,
	XTENSA_INS_AE_MULZASFD24_HH_LL_S2,
	XTENSA_INS_AE_MULZASFD24_HL_LH,
	XTENSA_INS_AE_MULZASFD24_HL_LH_S2,
	XTENSA_INS_AE_MULZASFD32X16_H1_L0,
	XTENSA_INS_AE_MULZASFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZASFD32X16_H3_L2,
	XTENSA_INS_AE_MULZASFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZSAD24_HH_LL,
	XTENSA_INS_AE_MULZSAD24_HH_LL_S2,
	XTENSA_INS_AE_MULZSAD32X16_H1_L0,
	XTENSA_INS_AE_MULZSAD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZSAD32X16_H3_L2,
	XTENSA_INS_AE_MULZSAD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZSAFD24_HH_LL,
	XTENSA_INS_AE_MULZSAFD24_HH_LL_S2,
	XTENSA_INS_AE_MULZSAFD32X16_H1_L0,
	XTENSA_INS_AE_MULZSAFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZSAFD32X16_H3_L2,
	XTENSA_INS_AE_MULZSAFD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZSSD24_HH_LL,
	XTENSA_INS_AE_MULZSSD24_HH_LL_S2,
	XTENSA_INS_AE_MULZSSD24_HL_LH,
	XTENSA_INS_AE_MULZSSD24_HL_LH_S2,
	XTENSA_INS_AE_MULZSSD32X16_H1_L0,
	XTENSA_INS_AE_MULZSSD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZSSD32X16_H3_L2,
	XTENSA_INS_AE_MULZSSD32X16_H3_L2_S2,
	XTENSA_INS_AE_MULZSSFD16SS_11_00,
	XTENSA_INS_AE_MULZSSFD16SS_11_00_S2,
	XTENSA_INS_AE_MULZSSFD16SS_13_02,
	XTENSA_INS_AE_MULZSSFD16SS_13_02_S2,
	XTENSA_INS_AE_MULZSSFD16SS_33_22,
	XTENSA_INS_AE_MULZSSFD16SS_33_22_S2,
	XTENSA_INS_AE_MULZSSFD24_HH_LL,
	XTENSA_INS_AE_MULZSSFD24_HH_LL_S2,
	XTENSA_INS_AE_MULZSSFD24_HL_LH,
	XTENSA_INS_AE_MULZSSFD24_HL_LH_S2,
	XTENSA_INS_AE_MULZSSFD32X16_H1_L0,
	XTENSA_INS_AE_MULZSSFD32X16_H1_L0_S2,
	XTENSA_INS_AE_MULZSSFD32X16_H3_L2,
	XTENSA_INS_AE_MULZSSFD32X16_H3_L2_S2,
	XTENSA_INS_AE_NAND,
	XTENSA_INS_AE_NEG16S,
	XTENSA_INS_AE_NEG24S,
	XTENSA_INS_AE_NEG32,
	XTENSA_INS_AE_NEG32S,
	XTENSA_INS_AE_NEG64,
	XTENSA_INS_AE_NEG64S,
	XTENSA_INS_AE_NSA64,
	XTENSA_INS_AE_NSAZ16_0,
	XTENSA_INS_AE_NSAZ32_L,
	XTENSA_INS_AE_OR,
	XTENSA_INS_AE_PKSR24,
	XTENSA_INS_AE_PKSR32,
	XTENSA_INS_AE_ROUND16X4F32SASYM,
	XTENSA_INS_AE_ROUND16X4F32SSYM,
	XTENSA_INS_AE_ROUND24X2F48SASYM,
	XTENSA_INS_AE_ROUND24X2F48SSYM,
	XTENSA_INS_AE_ROUND32X2F48SASYM,
	XTENSA_INS_AE_ROUND32X2F48SSYM,
	XTENSA_INS_AE_ROUND32X2F64SASYM,
	XTENSA_INS_AE_ROUND32X2F64SSYM,
	XTENSA_INS_AE_ROUNDSP16F24ASYM,
	XTENSA_INS_AE_ROUNDSP16F24SYM,
	XTENSA_INS_AE_ROUNDSP16Q48X2ASYM,
	XTENSA_INS_AE_ROUNDSP16Q48X2SYM,
	XTENSA_INS_AE_ROUNDSQ32F48ASYM,
	XTENSA_INS_AE_ROUNDSQ32F48SYM,
	XTENSA_INS_AE_S16M_L_I,
	XTENSA_INS_AE_S16M_L_IU,
	XTENSA_INS_AE_S16M_L_X,
	XTENSA_INS_AE_S16M_L_XC,
	XTENSA_INS_AE_S16M_L_XU,
	XTENSA_INS_AE_S16X2M_I,
	XTENSA_INS_AE_S16X2M_IU,
	XTENSA_INS_AE_S16X2M_X,
	XTENSA_INS_AE_S16X2M_XC,
	XTENSA_INS_AE_S16X2M_XU,
	XTENSA_INS_AE_S16X4_I,
	XTENSA_INS_AE_S16X4_IP,
	XTENSA_INS_AE_S16X4_RIC,
	XTENSA_INS_AE_S16X4_RIP,
	XTENSA_INS_AE_S16X4_X,
	XTENSA_INS_AE_S16X4_XC,
	XTENSA_INS_AE_S16X4_XP,
	XTENSA_INS_AE_S16_0_I,
	XTENSA_INS_AE_S16_0_IP,
	XTENSA_INS_AE_S16_0_X,
	XTENSA_INS_AE_S16_0_XC,
	XTENSA_INS_AE_S16_0_XP,
	XTENSA_INS_AE_S24RA64S_I,
	XTENSA_INS_AE_S24RA64S_IP,
	XTENSA_INS_AE_S24RA64S_X,
	XTENSA_INS_AE_S24RA64S_XC,
	XTENSA_INS_AE_S24RA64S_XP,
	XTENSA_INS_AE_S24X2RA64S_IP,
	XTENSA_INS_AE_S32F24_L_I,
	XTENSA_INS_AE_S32F24_L_IP,
	XTENSA_INS_AE_S32F24_L_X,
	XTENSA_INS_AE_S32F24_L_XC,
	XTENSA_INS_AE_S32F24_L_XP,
	XTENSA_INS_AE_S32M_I,
	XTENSA_INS_AE_S32M_IU,
	XTENSA_INS_AE_S32M_X,
	XTENSA_INS_AE_S32M_XC,
	XTENSA_INS_AE_S32M_XU,
	XTENSA_INS_AE_S32RA64S_I,
	XTENSA_INS_AE_S32RA64S_IP,
	XTENSA_INS_AE_S32RA64S_X,
	XTENSA_INS_AE_S32RA64S_XC,
	XTENSA_INS_AE_S32RA64S_XP,
	XTENSA_INS_AE_S32X2F24_I,
	XTENSA_INS_AE_S32X2F24_IP,
	XTENSA_INS_AE_S32X2F24_RIC,
	XTENSA_INS_AE_S32X2F24_RIP,
	XTENSA_INS_AE_S32X2F24_X,
	XTENSA_INS_AE_S32X2F24_XC,
	XTENSA_INS_AE_S32X2F24_XP,
	XTENSA_INS_AE_S32X2RA64S_IP,
	XTENSA_INS_AE_S32X2_I,
	XTENSA_INS_AE_S32X2_IP,
	XTENSA_INS_AE_S32X2_RIC,
	XTENSA_INS_AE_S32X2_RIP,
	XTENSA_INS_AE_S32X2_X,
	XTENSA_INS_AE_S32X2_XC,
	XTENSA_INS_AE_S32X2_XP,
	XTENSA_INS_AE_S32_L_I,
	XTENSA_INS_AE_S32_L_IP,
	XTENSA_INS_AE_S32_L_X,
	XTENSA_INS_AE_S32_L_XC,
	XTENSA_INS_AE_S32_L_XP,
	XTENSA_INS_AE_S64_I,
	XTENSA_INS_AE_S64_IP,
	XTENSA_INS_AE_S64_X,
	XTENSA_INS_AE_S64_XC,
	XTENSA_INS_AE_S64_XP,
	XTENSA_INS_AE_SA16X4_IC,
	XTENSA_INS_AE_SA16X4_IP,
	XTENSA_INS_AE_SA16X4_RIC,
	XTENSA_INS_AE_SA16X4_RIP,
	XTENSA_INS_AE_SA24X2_IC,
	XTENSA_INS_AE_SA24X2_IP,
	XTENSA_INS_AE_SA24X2_RIC,
	XTENSA_INS_AE_SA24X2_RIP,
	XTENSA_INS_AE_SA24_L_IC,
	XTENSA_INS_AE_SA24_L_IP,
	XTENSA_INS_AE_SA24_L_RIC,
	XTENSA_INS_AE_SA24_L_RIP,
	XTENSA_INS_AE_SA32X2F24_IC,
	XTENSA_INS_AE_SA32X2F24_IP,
	XTENSA_INS_AE_SA32X2F24_RIC,
	XTENSA_INS_AE_SA32X2F24_RIP,
	XTENSA_INS_AE_SA32X2_IC,
	XTENSA_INS_AE_SA32X2_IP,
	XTENSA_INS_AE_SA32X2_RIC,
	XTENSA_INS_AE_SA32X2_RIP,
	XTENSA_INS_AE_SA64NEG_FP,
	XTENSA_INS_AE_SA64POS_FP,
	XTENSA_INS_AE_SALIGN64_I,
	XTENSA_INS_AE_SAT16X4,
	XTENSA_INS_AE_SAT24S,
	XTENSA_INS_AE_SAT48S,
	XTENSA_INS_AE_SATQ56S,
	XTENSA_INS_AE_SB,
	XTENSA_INS_AE_SBF,
	XTENSA_INS_AE_SBF_IC,
	XTENSA_INS_AE_SBF_IP,
	XTENSA_INS_AE_SBI,
	XTENSA_INS_AE_SBI_IC,
	XTENSA_INS_AE_SBI_IP,
	XTENSA_INS_AE_SB_IC,
	XTENSA_INS_AE_SB_IP,
	XTENSA_INS_AE_SEL16I,
	XTENSA_INS_AE_SEL16I_N,
	XTENSA_INS_AE_SEXT32,
	XTENSA_INS_AE_SEXT32X2D16_10,
	XTENSA_INS_AE_SEXT32X2D16_32,
	XTENSA_INS_AE_SHA32,
	XTENSA_INS_AE_SHORTSWAP,
	XTENSA_INS_AE_SLAA16S,
	XTENSA_INS_AE_SLAA32,
	XTENSA_INS_AE_SLAA32S,
	XTENSA_INS_AE_SLAA64,
	XTENSA_INS_AE_SLAA64S,
	XTENSA_INS_AE_SLAAQ56,
	XTENSA_INS_AE_SLAI16S,
	XTENSA_INS_AE_SLAI24,
	XTENSA_INS_AE_SLAI24S,
	XTENSA_INS_AE_SLAI32,
	XTENSA_INS_AE_SLAI32S,
	XTENSA_INS_AE_SLAI64,
	XTENSA_INS_AE_SLAI64S,
	XTENSA_INS_AE_SLAISQ56S,
	XTENSA_INS_AE_SLAS24,
	XTENSA_INS_AE_SLAS24S,
	XTENSA_INS_AE_SLAS32,
	XTENSA_INS_AE_SLAS32S,
	XTENSA_INS_AE_SLAS64,
	XTENSA_INS_AE_SLAS64S,
	XTENSA_INS_AE_SLASQ56,
	XTENSA_INS_AE_SLASSQ56S,
	XTENSA_INS_AE_SRA64_32,
	XTENSA_INS_AE_SRAA16RS,
	XTENSA_INS_AE_SRAA16S,
	XTENSA_INS_AE_SRAA32,
	XTENSA_INS_AE_SRAA32RS,
	XTENSA_INS_AE_SRAA32S,
	XTENSA_INS_AE_SRAA64,
	XTENSA_INS_AE_SRAI16,
	XTENSA_INS_AE_SRAI16R,
	XTENSA_INS_AE_SRAI24,
	XTENSA_INS_AE_SRAI32,
	XTENSA_INS_AE_SRAI32R,
	XTENSA_INS_AE_SRAI64,
	XTENSA_INS_AE_SRAS24,
	XTENSA_INS_AE_SRAS32,
	XTENSA_INS_AE_SRAS64,
	XTENSA_INS_AE_SRLA32,
	XTENSA_INS_AE_SRLA64,
	XTENSA_INS_AE_SRLI24,
	XTENSA_INS_AE_SRLI32,
	XTENSA_INS_AE_SRLI64,
	XTENSA_INS_AE_SRLS24,
	XTENSA_INS_AE_SRLS32,
	XTENSA_INS_AE_SRLS64,
	XTENSA_INS_AE_SUB16,
	XTENSA_INS_AE_SUB16S,
	XTENSA_INS_AE_SUB24S,
	XTENSA_INS_AE_SUB32,
	XTENSA_INS_AE_SUB32S,
	XTENSA_INS_AE_SUB64,
	XTENSA_INS_AE_SUB64S,
	XTENSA_INS_AE_SUBADD32,
	XTENSA_INS_AE_SUBADD32S,
	XTENSA_INS_AE_TRUNCA32F64S_L,
	XTENSA_INS_AE_TRUNCA32X2F64S,
	XTENSA_INS_AE_TRUNCI32F64S_L,
	XTENSA_INS_AE_TRUNCI32X2F64S,
	XTENSA_INS_AE_VLDL16C,
	XTENSA_INS_AE_VLDL16C_IC,
	XTENSA_INS_AE_VLDL16C_IP,
	XTENSA_INS_AE_VLDL16T,
	XTENSA_INS_AE_VLDL32T,
	XTENSA_INS_AE_VLDSHT,
	XTENSA_INS_AE_VLEL16T,
	XTENSA_INS_AE_VLEL32T,
	XTENSA_INS_AE_VLES16C,
	XTENSA_INS_AE_VLES16C_IC,
	XTENSA_INS_AE_VLES16C_IP,
	XTENSA_INS_AE_XOR,
	XTENSA_INS_AE_ZALIGN64,
	XTENSA_INS_ALL4,
	XTENSA_INS_ALL8,
	XTENSA_INS_AND,
	XTENSA_INS_ANDB,
	XTENSA_INS_ANDBC,
	XTENSA_INS_ANY4,
	XTENSA_INS_ANY8,
	XTENSA_INS_BALL,
	XTENSA_INS_BANY,
	XTENSA_INS_BBC,
	XTENSA_INS_BBCI,
	XTENSA_INS_BBS,
	XTENSA_INS_BBSI,
	XTENSA_INS_BEQ,
	XTENSA_INS_BEQI,
	XTENSA_INS_BEQZ,
	XTENSA_INS_BF,
	XTENSA_INS_BGE,
	XTENSA_INS_BGEI,
	XTENSA_INS_BGEU,
	XTENSA_INS_BGEUI,
	XTENSA_INS_BGEZ,
	XTENSA_INS_BLT,
	XTENSA_INS_BLTI,
	XTENSA_INS_BLTU,
	XTENSA_INS_BLTUI,
	XTENSA_INS_BLTZ,
	XTENSA_INS_BNALL,
	XTENSA_INS_BNE,
	XTENSA_INS_BNEI,
	XTENSA_INS_BNEZ,
	XTENSA_INS_BNONE,
	XTENSA_INS_BREAK,
	XTENSA_INS_BREAK_N,
	XTENSA_INS_BT,
	XTENSA_INS_CALL0,
	XTENSA_INS_CALL12,
	XTENSA_INS_CALL4,
	XTENSA_INS_CALL8,
	XTENSA_INS_CALLX0,
	XTENSA_INS_CALLX12,
	XTENSA_INS_CALLX4,
	XTENSA_INS_CALLX8,
	XTENSA_INS_CEIL_S,
	XTENSA_INS_CLAMPS,
	XTENSA_INS_CLR_BIT_GPIO_OUT,
	XTENSA_INS_CONST_S,
	XTENSA_INS_DIV0_S,
	XTENSA_INS_DIVN_S,
	XTENSA_INS_DSYNC,
	XTENSA_INS_EE_ANDQ,
	XTENSA_INS_EE_BITREV,
	XTENSA_INS_EE_CLR_BIT_GPIO_OUT,
	XTENSA_INS_EE_CMUL_S16,
	XTENSA_INS_EE_CMUL_S16_LD_INCP,
	XTENSA_INS_EE_CMUL_S16_ST_INCP,
	XTENSA_INS_EE_FFT_AMS_S16_LD_INCP,
	XTENSA_INS_EE_FFT_AMS_S16_LD_INCP_UAUP,
	XTENSA_INS_EE_FFT_AMS_S16_LD_R32_DECP,
	XTENSA_INS_EE_FFT_AMS_S16_ST_INCP,
	XTENSA_INS_EE_FFT_CMUL_S16_LD_XP,
	XTENSA_INS_EE_FFT_CMUL_S16_ST_XP,
	XTENSA_INS_EE_FFT_R2BF_S16,
	XTENSA_INS_EE_FFT_R2BF_S16_ST_INCP,
	XTENSA_INS_EE_FFT_VST_R32_DECP,
	XTENSA_INS_EE_GET_GPIO_IN,
	XTENSA_INS_EE_LDF_128_IP,
	XTENSA_INS_EE_LDF_128_XP,
	XTENSA_INS_EE_LDF_64_IP,
	XTENSA_INS_EE_LDF_64_XP,
	XTENSA_INS_EE_LDQA_S16_128_IP,
	XTENSA_INS_EE_LDQA_S16_128_XP,
	XTENSA_INS_EE_LDQA_S8_128_IP,
	XTENSA_INS_EE_LDQA_S8_128_XP,
	XTENSA_INS_EE_LDQA_U16_128_IP,
	XTENSA_INS_EE_LDQA_U16_128_XP,
	XTENSA_INS_EE_LDQA_U8_128_IP,
	XTENSA_INS_EE_LDQA_U8_128_XP,
	XTENSA_INS_EE_LDXQ_32,
	XTENSA_INS_EE_LD_128_USAR_IP,
	XTENSA_INS_EE_LD_128_USAR_XP,
	XTENSA_INS_EE_LD_ACCX_IP,
	XTENSA_INS_EE_LD_QACC_H_H_32_IP,
	XTENSA_INS_EE_LD_QACC_H_L_128_IP,
	XTENSA_INS_EE_LD_QACC_L_H_32_IP,
	XTENSA_INS_EE_LD_QACC_L_L_128_IP,
	XTENSA_INS_EE_LD_UA_STATE_IP,
	XTENSA_INS_EE_MOVI_32_A,
	XTENSA_INS_EE_MOVI_32_Q,
	XTENSA_INS_EE_MOV_S16_QACC,
	XTENSA_INS_EE_MOV_S8_QACC,
	XTENSA_INS_EE_MOV_U16_QACC,
	XTENSA_INS_EE_MOV_U8_QACC,
	XTENSA_INS_EE_NOTQ,
	XTENSA_INS_EE_ORQ,
	XTENSA_INS_EE_SET_BIT_GPIO_OUT,
	XTENSA_INS_EE_SLCI_2Q,
	XTENSA_INS_EE_SLCXXP_2Q,
	XTENSA_INS_EE_SRCI_2Q,
	XTENSA_INS_EE_SRCMB_S16_QACC,
	XTENSA_INS_EE_SRCMB_S8_QACC,
	XTENSA_INS_EE_SRCQ_128_ST_INCP,
	XTENSA_INS_EE_SRCXXP_2Q,
	XTENSA_INS_EE_SRC_Q,
	XTENSA_INS_EE_SRC_Q_LD_IP,
	XTENSA_INS_EE_SRC_Q_LD_XP,
	XTENSA_INS_EE_SRC_Q_QUP,
	XTENSA_INS_EE_SRS_ACCX,
	XTENSA_INS_EE_STF_128_IP,
	XTENSA_INS_EE_STF_128_XP,
	XTENSA_INS_EE_STF_64_IP,
	XTENSA_INS_EE_STF_64_XP,
	XTENSA_INS_EE_STXQ_32,
	XTENSA_INS_EE_ST_ACCX_IP,
	XTENSA_INS_EE_ST_QACC_H_H_32_IP,
	XTENSA_INS_EE_ST_QACC_H_L_128_IP,
	XTENSA_INS_EE_ST_QACC_L_H_32_IP,
	XTENSA_INS_EE_ST_QACC_L_L_128_IP,
	XTENSA_INS_EE_ST_UA_STATE_IP,
	XTENSA_INS_EE_VADDS_S16,
	XTENSA_INS_EE_VADDS_S16_LD_INCP,
	XTENSA_INS_EE_VADDS_S16_ST_INCP,
	XTENSA_INS_EE_VADDS_S32,
	XTENSA_INS_EE_VADDS_S32_LD_INCP,
	XTENSA_INS_EE_VADDS_S32_ST_INCP,
	XTENSA_INS_EE_VADDS_S8,
	XTENSA_INS_EE_VADDS_S8_LD_INCP,
	XTENSA_INS_EE_VADDS_S8_ST_INCP,
	XTENSA_INS_EE_VCMP_EQ_S16,
	XTENSA_INS_EE_VCMP_EQ_S32,
	XTENSA_INS_EE_VCMP_EQ_S8,
	XTENSA_INS_EE_VCMP_GT_S16,
	XTENSA_INS_EE_VCMP_GT_S32,
	XTENSA_INS_EE_VCMP_GT_S8,
	XTENSA_INS_EE_VCMP_LT_S16,
	XTENSA_INS_EE_VCMP_LT_S32,
	XTENSA_INS_EE_VCMP_LT_S8,
	XTENSA_INS_EE_VLDBC_16,
	XTENSA_INS_EE_VLDBC_16_IP,
	XTENSA_INS_EE_VLDBC_16_XP,
	XTENSA_INS_EE_VLDBC_32,
	XTENSA_INS_EE_VLDBC_32_IP,
	XTENSA_INS_EE_VLDBC_32_XP,
	XTENSA_INS_EE_VLDBC_8,
	XTENSA_INS_EE_VLDBC_8_IP,
	XTENSA_INS_EE_VLDBC_8_XP,
	XTENSA_INS_EE_VLDHBC_16_INCP,
	XTENSA_INS_EE_VLD_128_IP,
	XTENSA_INS_EE_VLD_128_XP,
	XTENSA_INS_EE_VLD_H_64_IP,
	XTENSA_INS_EE_VLD_H_64_XP,
	XTENSA_INS_EE_VLD_L_64_IP,
	XTENSA_INS_EE_VLD_L_64_XP,
	XTENSA_INS_EE_VMAX_S16,
	XTENSA_INS_EE_VMAX_S16_LD_INCP,
	XTENSA_INS_EE_VMAX_S16_ST_INCP,
	XTENSA_INS_EE_VMAX_S32,
	XTENSA_INS_EE_VMAX_S32_LD_INCP,
	XTENSA_INS_EE_VMAX_S32_ST_INCP,
	XTENSA_INS_EE_VMAX_S8,
	XTENSA_INS_EE_VMAX_S8_LD_INCP,
	XTENSA_INS_EE_VMAX_S8_ST_INCP,
	XTENSA_INS_EE_VMIN_S16,
	XTENSA_INS_EE_VMIN_S16_LD_INCP,
	XTENSA_INS_EE_VMIN_S16_ST_INCP,
	XTENSA_INS_EE_VMIN_S32,
	XTENSA_INS_EE_VMIN_S32_LD_INCP,
	XTENSA_INS_EE_VMIN_S32_ST_INCP,
	XTENSA_INS_EE_VMIN_S8,
	XTENSA_INS_EE_VMIN_S8_LD_INCP,
	XTENSA_INS_EE_VMIN_S8_ST_INCP,
	XTENSA_INS_EE_VMULAS_S16_ACCX,
	XTENSA_INS_EE_VMULAS_S16_ACCX_LD_IP,
	XTENSA_INS_EE_VMULAS_S16_ACCX_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_S16_ACCX_LD_XP,
	XTENSA_INS_EE_VMULAS_S16_ACCX_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_S16_QACC,
	XTENSA_INS_EE_VMULAS_S16_QACC_LDBC_INCP,
	XTENSA_INS_EE_VMULAS_S16_QACC_LDBC_INCP_QUP,
	XTENSA_INS_EE_VMULAS_S16_QACC_LD_IP,
	XTENSA_INS_EE_VMULAS_S16_QACC_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_S16_QACC_LD_XP,
	XTENSA_INS_EE_VMULAS_S16_QACC_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_S8_ACCX,
	XTENSA_INS_EE_VMULAS_S8_ACCX_LD_IP,
	XTENSA_INS_EE_VMULAS_S8_ACCX_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_S8_ACCX_LD_XP,
	XTENSA_INS_EE_VMULAS_S8_ACCX_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_S8_QACC,
	XTENSA_INS_EE_VMULAS_S8_QACC_LDBC_INCP,
	XTENSA_INS_EE_VMULAS_S8_QACC_LDBC_INCP_QUP,
	XTENSA_INS_EE_VMULAS_S8_QACC_LD_IP,
	XTENSA_INS_EE_VMULAS_S8_QACC_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_S8_QACC_LD_XP,
	XTENSA_INS_EE_VMULAS_S8_QACC_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_U16_ACCX,
	XTENSA_INS_EE_VMULAS_U16_ACCX_LD_IP,
	XTENSA_INS_EE_VMULAS_U16_ACCX_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_U16_ACCX_LD_XP,
	XTENSA_INS_EE_VMULAS_U16_ACCX_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_U16_QACC,
	XTENSA_INS_EE_VMULAS_U16_QACC_LDBC_INCP,
	XTENSA_INS_EE_VMULAS_U16_QACC_LDBC_INCP_QUP,
	XTENSA_INS_EE_VMULAS_U16_QACC_LD_IP,
	XTENSA_INS_EE_VMULAS_U16_QACC_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_U16_QACC_LD_XP,
	XTENSA_INS_EE_VMULAS_U16_QACC_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_U8_ACCX,
	XTENSA_INS_EE_VMULAS_U8_ACCX_LD_IP,
	XTENSA_INS_EE_VMULAS_U8_ACCX_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_U8_ACCX_LD_XP,
	XTENSA_INS_EE_VMULAS_U8_ACCX_LD_XP_QUP,
	XTENSA_INS_EE_VMULAS_U8_QACC,
	XTENSA_INS_EE_VMULAS_U8_QACC_LDBC_INCP,
	XTENSA_INS_EE_VMULAS_U8_QACC_LDBC_INCP_QUP,
	XTENSA_INS_EE_VMULAS_U8_QACC_LD_IP,
	XTENSA_INS_EE_VMULAS_U8_QACC_LD_IP_QUP,
	XTENSA_INS_EE_VMULAS_U8_QACC_LD_XP,
	XTENSA_INS_EE_VMULAS_U8_QACC_LD_XP_QUP,
	XTENSA_INS_EE_VMUL_S16,
	XTENSA_INS_EE_VMUL_S16_LD_INCP,
	XTENSA_INS_EE_VMUL_S16_ST_INCP,
	XTENSA_INS_EE_VMUL_S8,
	XTENSA_INS_EE_VMUL_S8_LD_INCP,
	XTENSA_INS_EE_VMUL_S8_ST_INCP,
	XTENSA_INS_EE_VMUL_U16,
	XTENSA_INS_EE_VMUL_U16_LD_INCP,
	XTENSA_INS_EE_VMUL_U16_ST_INCP,
	XTENSA_INS_EE_VMUL_U8,
	XTENSA_INS_EE_VMUL_U8_LD_INCP,
	XTENSA_INS_EE_VMUL_U8_ST_INCP,
	XTENSA_INS_EE_VPRELU_S16,
	XTENSA_INS_EE_VPRELU_S8,
	XTENSA_INS_EE_VRELU_S16,
	XTENSA_INS_EE_VRELU_S8,
	XTENSA_INS_EE_VSL_32,
	XTENSA_INS_EE_VSMULAS_S16_QACC,
	XTENSA_INS_EE_VSMULAS_S16_QACC_LD_INCP,
	XTENSA_INS_EE_VSMULAS_S8_QACC,
	XTENSA_INS_EE_VSMULAS_S8_QACC_LD_INCP,
	XTENSA_INS_EE_VSR_32,
	XTENSA_INS_EE_VST_128_IP,
	XTENSA_INS_EE_VST_128_XP,
	XTENSA_INS_EE_VST_H_64_IP,
	XTENSA_INS_EE_VST_H_64_XP,
	XTENSA_INS_EE_VST_L_64_IP,
	XTENSA_INS_EE_VST_L_64_XP,
	XTENSA_INS_EE_VSUBS_S16,
	XTENSA_INS_EE_VSUBS_S16_LD_INCP,
	XTENSA_INS_EE_VSUBS_S16_ST_INCP,
	XTENSA_INS_EE_VSUBS_S32,
	XTENSA_INS_EE_VSUBS_S32_LD_INCP,
	XTENSA_INS_EE_VSUBS_S32_ST_INCP,
	XTENSA_INS_EE_VSUBS_S8,
	XTENSA_INS_EE_VSUBS_S8_LD_INCP,
	XTENSA_INS_EE_VSUBS_S8_ST_INCP,
	XTENSA_INS_EE_VUNZIP_16,
	XTENSA_INS_EE_VUNZIP_32,
	XTENSA_INS_EE_VUNZIP_8,
	XTENSA_INS_EE_VZIP_16,
	XTENSA_INS_EE_VZIP_32,
	XTENSA_INS_EE_VZIP_8,
	XTENSA_INS_EE_WR_MASK_GPIO_OUT,
	XTENSA_INS_EE_XORQ,
	XTENSA_INS_EE_ZERO_ACCX,
	XTENSA_INS_EE_ZERO_Q,
	XTENSA_INS_EE_ZERO_QACC,
	XTENSA_INS_ENTRY,
	XTENSA_INS_ESYNC,
	XTENSA_INS_EXCW,
	XTENSA_INS_EXTUI,
	XTENSA_INS_EXTW,
	XTENSA_INS_FLOAT_S,
	XTENSA_INS_FLOOR_S,
	XTENSA_INS_GET_GPIO_IN,
	XTENSA_INS_ILL,
	XTENSA_INS_ILL_N,
	XTENSA_INS_ISYNC,
	XTENSA_INS_J,
	XTENSA_INS_JX,
	XTENSA_INS_L16SI,
	XTENSA_INS_L16UI,
	XTENSA_INS_L32E,
	XTENSA_INS_L32I,
	XTENSA_INS_L32I_N,
	XTENSA_INS_L32R,
	XTENSA_INS_L8UI,
	XTENSA_INS_LDDEC,
	XTENSA_INS_LDINC,
	XTENSA_INS_LOOP,
	XTENSA_INS_LOOPGTZ,
	XTENSA_INS_LOOPNEZ,
	XTENSA_INS_LSI,
	XTENSA_INS_LSIP,
	XTENSA_INS_LSX,
	XTENSA_INS_LSXP,
	XTENSA_INS_MADDN_S,
	XTENSA_INS_MADD_S,
	XTENSA_INS_MAX,
	XTENSA_INS_MAXU,
	XTENSA_INS_MEMW,
	XTENSA_INS_MIN,
	XTENSA_INS_MINU,
	XTENSA_INS_MKDADJ_S,
	XTENSA_INS_MKSADJ_S,
	XTENSA_INS_MOVEQZ,
	XTENSA_INS_MOVEQZ_S,
	XTENSA_INS_MOVF,
	XTENSA_INS_MOVF_S,
	XTENSA_INS_MOVGEZ,
	XTENSA_INS_MOVGEZ_S,
	XTENSA_INS_MOVI,
	XTENSA_INS_MOVI_N,
	XTENSA_INS_MOVLTZ,
	XTENSA_INS_MOVLTZ_S,
	XTENSA_INS_MOVNEZ,
	XTENSA_INS_MOVNEZ_S,
	XTENSA_INS_MOVSP,
	XTENSA_INS_MOVT,
	XTENSA_INS_MOVT_S,
	XTENSA_INS_MOV_N,
	XTENSA_INS_MOV_S,
	XTENSA_INS_MSUB_S,
	XTENSA_INS_MUL16S,
	XTENSA_INS_MUL16U,
	XTENSA_INS_MULA_AA_HH,
	XTENSA_INS_MULA_AA_HL,
	XTENSA_INS_MULA_AA_LH,
	XTENSA_INS_MULA_AA_LL,
	XTENSA_INS_MULA_AD_HH,
	XTENSA_INS_MULA_AD_HL,
	XTENSA_INS_MULA_AD_LH,
	XTENSA_INS_MULA_AD_LL,
	XTENSA_INS_MULA_DA_HH,
	XTENSA_INS_MULA_DA_HH_LDDEC,
	XTENSA_INS_MULA_DA_HH_LDINC,
	XTENSA_INS_MULA_DA_HL,
	XTENSA_INS_MULA_DA_HL_LDDEC,
	XTENSA_INS_MULA_DA_HL_LDINC,
	XTENSA_INS_MULA_DA_LH,
	XTENSA_INS_MULA_DA_LH_LDDEC,
	XTENSA_INS_MULA_DA_LH_LDINC,
	XTENSA_INS_MULA_DA_LL,
	XTENSA_INS_MULA_DA_LL_LDDEC,
	XTENSA_INS_MULA_DA_LL_LDINC,
	XTENSA_INS_MULA_DD_HH,
	XTENSA_INS_MULA_DD_HH_LDDEC,
	XTENSA_INS_MULA_DD_HH_LDINC,
	XTENSA_INS_MULA_DD_HL,
	XTENSA_INS_MULA_DD_HL_LDDEC,
	XTENSA_INS_MULA_DD_HL_LDINC,
	XTENSA_INS_MULA_DD_LH,
	XTENSA_INS_MULA_DD_LH_LDDEC,
	XTENSA_INS_MULA_DD_LH_LDINC,
	XTENSA_INS_MULA_DD_LL,
	XTENSA_INS_MULA_DD_LL_LDDEC,
	XTENSA_INS_MULA_DD_LL_LDINC,
	XTENSA_INS_MULL,
	XTENSA_INS_MULSH,
	XTENSA_INS_MULS_AA_HH,
	XTENSA_INS_MULS_AA_HL,
	XTENSA_INS_MULS_AA_LH,
	XTENSA_INS_MULS_AA_LL,
	XTENSA_INS_MULS_AD_HH,
	XTENSA_INS_MULS_AD_HL,
	XTENSA_INS_MULS_AD_LH,
	XTENSA_INS_MULS_AD_LL,
	XTENSA_INS_MULS_DA_HH,
	XTENSA_INS_MULS_DA_HL,
	XTENSA_INS_MULS_DA_LH,
	XTENSA_INS_MULS_DA_LL,
	XTENSA_INS_MULS_DD_HH,
	XTENSA_INS_MULS_DD_HL,
	XTENSA_INS_MULS_DD_LH,
	XTENSA_INS_MULS_DD_LL,
	XTENSA_INS_MULUH,
	XTENSA_INS_MUL_AA_HH,
	XTENSA_INS_MUL_AA_HL,
	XTENSA_INS_MUL_AA_LH,
	XTENSA_INS_MUL_AA_LL,
	XTENSA_INS_MUL_AD_HH,
	XTENSA_INS_MUL_AD_HL,
	XTENSA_INS_MUL_AD_LH,
	XTENSA_INS_MUL_AD_LL,
	XTENSA_INS_MUL_DA_HH,
	XTENSA_INS_MUL_DA_HL,
	XTENSA_INS_MUL_DA_LH,
	XTENSA_INS_MUL_DA_LL,
	XTENSA_INS_MUL_DD_HH,
	XTENSA_INS_MUL_DD_HL,
	XTENSA_INS_MUL_DD_LH,
	XTENSA_INS_MUL_DD_LL,
	XTENSA_INS_MUL_S,
	XTENSA_INS_NEG,
	XTENSA_INS_NEG_S,
	XTENSA_INS_NEXP01_S,
	XTENSA_INS_NOP,
	XTENSA_INS_NSA,
	XTENSA_INS_NSAU,
	XTENSA_INS_OEQ_S,
	XTENSA_INS_OLE_S,
	XTENSA_INS_OLT_S,
	XTENSA_INS_OR,
	XTENSA_INS_ORB,
	XTENSA_INS_ORBC,
	XTENSA_INS_QUOS,
	XTENSA_INS_QUOU,
	XTENSA_INS_RECIP0_S,
	XTENSA_INS_REMS,
	XTENSA_INS_REMU,
	XTENSA_INS_RER,
	XTENSA_INS_RET,
	XTENSA_INS_RETW,
	XTENSA_INS_RETW_N,
	XTENSA_INS_RET_N,
	XTENSA_INS_RFDE,
	XTENSA_INS_RFE,
	XTENSA_INS_RFI,
	XTENSA_INS_RFR,
	XTENSA_INS_RFWO,
	XTENSA_INS_RFWU,
	XTENSA_INS_ROTW,
	XTENSA_INS_ROUND_S,
	XTENSA_INS_RSIL,
	XTENSA_INS_RSQRT0_S,
	XTENSA_INS_RSR,
	XTENSA_INS_RSYNC,
	XTENSA_INS_RUR,
	XTENSA_INS_RUR_ACCX_0,
	XTENSA_INS_RUR_ACCX_1,
	XTENSA_INS_RUR_AE_BITHEAD,
	XTENSA_INS_RUR_AE_BITPTR,
	XTENSA_INS_RUR_AE_BITSUSED,
	XTENSA_INS_RUR_AE_CBEGIN0,
	XTENSA_INS_RUR_AE_CEND0,
	XTENSA_INS_RUR_AE_CWRAP,
	XTENSA_INS_RUR_AE_CW_SD_NO,
	XTENSA_INS_RUR_AE_FIRST_TS,
	XTENSA_INS_RUR_AE_NEXTOFFSET,
	XTENSA_INS_RUR_AE_OVERFLOW,
	XTENSA_INS_RUR_AE_OVF_SAR,
	XTENSA_INS_RUR_AE_SAR,
	XTENSA_INS_RUR_AE_SEARCHDONE,
	XTENSA_INS_RUR_AE_TABLESIZE,
	XTENSA_INS_RUR_AE_TS_FTS_BU_BP,
	XTENSA_INS_RUR_FFT_BIT_WIDTH,
	XTENSA_INS_RUR_GPIO_OUT,
	XTENSA_INS_RUR_QACC_H_0,
	XTENSA_INS_RUR_QACC_H_1,
	XTENSA_INS_RUR_QACC_H_2,
	XTENSA_INS_RUR_QACC_H_3,
	XTENSA_INS_RUR_QACC_H_4,
	XTENSA_INS_RUR_QACC_L_0,
	XTENSA_INS_RUR_QACC_L_1,
	XTENSA_INS_RUR_QACC_L_2,
	XTENSA_INS_RUR_QACC_L_3,
	XTENSA_INS_RUR_QACC_L_4,
	XTENSA_INS_RUR_SAR_BYTE,
	XTENSA_INS_RUR_UA_STATE_0,
	XTENSA_INS_RUR_UA_STATE_1,
	XTENSA_INS_RUR_UA_STATE_2,
	XTENSA_INS_RUR_UA_STATE_3,
	XTENSA_INS_S16I,
	XTENSA_INS_S32C1I,
	XTENSA_INS_S32E,
	XTENSA_INS_S32I,
	XTENSA_INS_S32I_N,
	XTENSA_INS_S8I,
	XTENSA_INS_SET_BIT_GPIO_OUT,
	XTENSA_INS_SEXT,
	XTENSA_INS_SIMCALL,
	XTENSA_INS_SLL,
	XTENSA_INS_SLLI,
	XTENSA_INS_SQRT0_S,
	XTENSA_INS_SRA,
	XTENSA_INS_SRAI,
	XTENSA_INS_SRC,
	XTENSA_INS_SRL,
	XTENSA_INS_SRLI,
	XTENSA_INS_SSA8L,
	XTENSA_INS_SSAI,
	XTENSA_INS_SSI,
	XTENSA_INS_SSIP,
	XTENSA_INS_SSL,
	XTENSA_INS_SSR,
	XTENSA_INS_SSX,
	XTENSA_INS_SSXP,
	XTENSA_INS_SUB,
	XTENSA_INS_SUBX2,
	XTENSA_INS_SUBX4,
	XTENSA_INS_SUBX8,
	XTENSA_INS_SUB_S,
	XTENSA_INS_SYSCALL,
	XTENSA_INS_TRUNC_S,
	XTENSA_INS_UEQ_S,
	XTENSA_INS_UFLOAT_S,
	XTENSA_INS_ULE_S,
	XTENSA_INS_ULT_S,
	XTENSA_INS_UMUL_AA_HH,
	XTENSA_INS_UMUL_AA_HL,
	XTENSA_INS_UMUL_AA_LH,
	XTENSA_INS_UMUL_AA_LL,
	XTENSA_INS_UN_S,
	XTENSA_INS_UTRUNC_S,
	XTENSA_INS_WAITI,
	XTENSA_INS_WDTLB,
	XTENSA_INS_WER,
	XTENSA_INS_WFR,
	XTENSA_INS_WITLB,
	XTENSA_INS_WR_MASK_GPIO_OUT,
	XTENSA_INS_WSR,
	XTENSA_INS_WUR,
	XTENSA_INS_WUR_ACCX_0,
	XTENSA_INS_WUR_ACCX_1,
	XTENSA_INS_WUR_AE_BITHEAD,
	XTENSA_INS_WUR_AE_BITPTR,
	XTENSA_INS_WUR_AE_BITSUSED,
	XTENSA_INS_WUR_AE_CBEGIN0,
	XTENSA_INS_WUR_AE_CEND0,
	XTENSA_INS_WUR_AE_CWRAP,
	XTENSA_INS_WUR_AE_CW_SD_NO,
	XTENSA_INS_WUR_AE_FIRST_TS,
	XTENSA_INS_WUR_AE_NEXTOFFSET,
	XTENSA_INS_WUR_AE_OVERFLOW,
	XTENSA_INS_WUR_AE_OVF_SAR,
	XTENSA_INS_WUR_AE_SAR,
	XTENSA_INS_WUR_AE_SEARCHDONE,
	XTENSA_INS_WUR_AE_TABLESIZE,
	XTENSA_INS_WUR_AE_TS_FTS_BU_BP,
	XTENSA_INS_WUR_FCR,
	XTENSA_INS_WUR_FFT_BIT_WIDTH,
	XTENSA_INS_WUR_FSR,
	XTENSA_INS_WUR_GPIO_OUT,
	XTENSA_INS_WUR_QACC_H_0,
	XTENSA_INS_WUR_QACC_H_1,
	XTENSA_INS_WUR_QACC_H_2,
	XTENSA_INS_WUR_QACC_H_3,
	XTENSA_INS_WUR_QACC_H_4,
	XTENSA_INS_WUR_QACC_L_0,
	XTENSA_INS_WUR_QACC_L_1,
	XTENSA_INS_WUR_QACC_L_2,
	XTENSA_INS_WUR_QACC_L_3,
	XTENSA_INS_WUR_QACC_L_4,
	XTENSA_INS_WUR_SAR_BYTE,
	XTENSA_INS_WUR_UA_STATE_0,
	XTENSA_INS_WUR_UA_STATE_1,
	XTENSA_INS_WUR_UA_STATE_2,
	XTENSA_INS_WUR_UA_STATE_3,
	XTENSA_INS_XOR,
	XTENSA_INS_XORB,
	XTENSA_INS_XSR,
	XTENSA_INS__L32I,
	XTENSA_INS__L32I_N,
	XTENSA_INS__MOVI,
	XTENSA_INS__S32I,
	XTENSA_INS__S32I_N,
	XTENSA_INS__SLLI,
	XTENSA_INS__SRLI,
	XTENSA_INS_MV_QR,

	// clang-format on
	// generated content <XtensaGenCSInsnEnum.inc> end
} xtensa_insn;

typedef enum xtensa_feature {
	XTENSA_GRP_INVALID = 0,
	XTENSA_GRP_CALL,
	XTENSA_GRP_JUMP,
	XTENSA_GRP_RET,
	// generated content <XtensaGenCSFeatureEnum.inc> begin
	// clang-format off

	XTENSA_FEATURE_HASDENSITY = 128,
	XTENSA_FEATURE_HASSINGLEFLOAT,
	XTENSA_FEATURE_HASWINDOWED,
	XTENSA_FEATURE_HASBOOLEAN,
	XTENSA_FEATURE_HASLOOP,
	XTENSA_FEATURE_HASSEXT,
	XTENSA_FEATURE_HASCLAMPS,
	XTENSA_FEATURE_HASNSA,
	XTENSA_FEATURE_HASMINMAX,
	XTENSA_FEATURE_HASMUL16,
	XTENSA_FEATURE_HASMUL32,
	XTENSA_FEATURE_HASMUL32HIGH,
	XTENSA_FEATURE_HASDIV32,
	XTENSA_FEATURE_HASMAC16,
	XTENSA_FEATURE_HASDFPACCEL,
	XTENSA_FEATURE_HASS32C1I,
	XTENSA_FEATURE_HASTHREADPTR,
	XTENSA_FEATURE_HASEXTENDEDL32R,
	XTENSA_FEATURE_HASATOMCTL,
	XTENSA_FEATURE_HASMEMCTL,
	XTENSA_FEATURE_HASDEBUG,
	XTENSA_FEATURE_HASEXCEPTION,
	XTENSA_FEATURE_HASHIGHPRIINTERRUPTS,
	XTENSA_FEATURE_HASCOPROCESSOR,
	XTENSA_FEATURE_HASINTERRUPT,
	XTENSA_FEATURE_HASRELOCATABLEVECTOR,
	XTENSA_FEATURE_HASTIMERINT,
	XTENSA_FEATURE_HASPRID,
	XTENSA_FEATURE_HASREGIONPROTECTION,
	XTENSA_FEATURE_HASMISCSR,
	XTENSA_FEATURE_HASESP32S2OPS,
	XTENSA_FEATURE_HASESP32S3OPS,
	XTENSA_FEATURE_HASHIFI3,
	XTENSA_FEATURE_HASFORCEDATOMICS,

	// clang-format on
	// generated content <XtensaGenCSFeatureEnum.inc> end
	XTENSA_GRP_ENDING, ///< mark the end of the list of features
} xtensa_feature;

/// Xtensa instruction formats. To get details about them please
/// refer to `XtensaInstrFormats.td` in LLVM.
typedef enum {
	XTENSA_INSN_FORM_INVALID = 0,
	// generated content <XtensaGenCSInsnFormatsEnum.inc> begin
	// clang-format off

	XTENSA_INSN_FORM_RRR,
	XTENSA_INSN_FORM_RRI8,
	XTENSA_INSN_FORM_RRRN,
	XTENSA_INSN_FORM_AEINST24,
	XTENSA_INSN_FORM_BRI12,
	XTENSA_INSN_FORM_CALL,
	XTENSA_INSN_FORM_CALLX,
	XTENSA_INSN_FORM_EE_INST24,
	XTENSA_INSN_FORM_RRI4,
	XTENSA_INSN_FORM_RI16,
	XTENSA_INSN_FORM_RI7,
	XTENSA_INSN_FORM_RSR,

	// clang-format on
	// generated content <XtensaGenCSInsnFormatsEnum.inc> end
	XTENSA_INSN_FORM_MAX,
} xtensa_insn_form;

typedef struct {
	xtensa_insn_form form;
} xtensa_suppl_info;

typedef enum cs_xtensa_op_type {
	XTENSA_OP_INVALID = CS_OP_INVALID, ///< = (Uninitialized).
	XTENSA_OP_REG = CS_OP_REG,	   ///< = (Register operand).
	XTENSA_OP_IMM = CS_OP_IMM,	   ///< = (Immediate operand).
	XTENSA_OP_MEM = CS_OP_MEM,	   ///< = (Memory operand).
	XTENSA_OP_MEM_REG = CS_OP_MEM_REG, ///< = (Memory Register operand).
	XTENSA_OP_MEM_IMM = CS_OP_MEM_IMM, ///< = (Memory Immediate operand).
	XTENSA_OP_L32R,			   ///< = (L32R Target)
} cs_xtensa_op_type;

typedef struct cs_xtensa_op_mem {
	uint8_t base;
	int32_t disp;
} cs_xtensa_op_mem;

typedef struct cs_xtensa_operand {
	uint8_t type;
	uint8_t access;

	union {
		uint8_t reg;
		int32_t imm;
		cs_xtensa_op_mem mem;
	};
} cs_xtensa_op;

#define MAX_XTENSA_OPS 8

typedef struct cs_xtensa {
	uint8_t op_count;
	cs_xtensa_op operands[MAX_XTENSA_OPS];
	xtensa_insn_form format;
} cs_xtensa;

#ifdef __cplusplus
}
#endif

#endif
