// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

namespace System.Diagnostics
{
    /// <devdoc>
    ///     A set of values indicating how the window should appear when starting
    ///     a process.
    /// </devdoc>
    public enum ProcessWindowStyle
    {
        /// <devdoc>
        ///     Show the window in a default location.
        /// </devdoc>
        Normal,

        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Hidden,

        /// <devdoc>
        ///     Show the window minimized.
        /// </devdoc>
        Minimized,

        /// <devdoc>
        ///     Show the window maximized.
        /// </devdoc>
        Maximized
    }
}
