// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using Xunit;

namespace Tests.ExpressionCompiler.Convert
{
    public static unsafe class ConvertCheckedTests
    {
        #region Test methods

        [Fact]
        public static void ConvertCheckedByteToByteTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableByteTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToCharTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableCharTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToDecimalTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableDecimalTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToDoubleTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableDoubleTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToEnumTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableEnumTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToEnumLongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableEnumLongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToFloatTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableFloatTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToIntTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableIntTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToLongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableLongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToSByteTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableSByteTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToShortTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableShortTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToUIntTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableUIntTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToULongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableULongTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToUShortTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedByteToNullableUShortTest()
        {
            foreach (byte value in new byte[] { 0, 1, byte.MaxValue })
            {
                VerifyCheckedByteToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToByteTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableByteTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToCharTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableCharTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToDecimalTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableDecimalTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToDoubleTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableDoubleTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToEnumTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableEnumTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToEnumLongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableEnumLongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToFloatTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableFloatTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToIntTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableIntTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToLongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableLongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToSByteTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableSByteTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToShortTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableShortTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToUIntTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableUIntTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToULongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableULongTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToUShortTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableByteToNullableUShortTest()
        {
            foreach (byte? value in new byte?[] { null, 0, 1, byte.MaxValue })
            {
                VerifyCheckedNullableByteToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToByteTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableByteTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToCharTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableCharTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToDecimalTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableDecimalTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToDoubleTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableDoubleTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToEnumTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableEnumTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToEnumLongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableEnumLongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToFloatTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableFloatTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToIntTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableIntTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToLongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableLongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToSByteTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableSByteTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToShortTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableShortTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToUIntTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableUIntTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToULongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableULongTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToUShortTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedCharToNullableUShortTest()
        {
            foreach (char value in new char[] { '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedCharToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToByteTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableByteTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToCharTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableCharTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToDecimalTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableDecimalTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToDoubleTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableDoubleTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToEnumTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableEnumTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToEnumLongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableEnumLongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToFloatTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableFloatTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToIntTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableIntTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToLongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableLongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToSByteTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableSByteTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToShortTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableShortTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToUIntTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableUIntTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToULongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableULongTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToUShortTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableCharToNullableUShortTest()
        {
            foreach (char? value in new char?[] { null, '\0', '\b', 'A', '\uffff' })
            {
                VerifyCheckedNullableCharToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToByteTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableByteTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToCharTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableCharTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToDecimalTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableDecimalTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToDoubleTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableDoubleTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToFloatTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableFloatTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToIntTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableIntTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToLongTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableLongTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToSByteTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableSByteTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToShortTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableShortTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToUIntTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableUIntTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToULongTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableULongTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToUShortTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDecimalToNullableUShortTest()
        {
            foreach (decimal value in new decimal[] { decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedDecimalToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToByteTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableByteTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToCharTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableCharTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToDecimalTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableDecimalTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToDoubleTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableDoubleTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToFloatTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableFloatTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToIntTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableIntTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToLongTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableLongTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToSByteTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableSByteTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToShortTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableShortTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToUIntTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableUIntTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToULongTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableULongTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToUShortTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDecimalToNullableUShortTest()
        {
            foreach (decimal? value in new decimal?[] { null, decimal.Zero, decimal.One, decimal.MinusOne, decimal.MinValue, decimal.MaxValue })
            {
                VerifyCheckedNullableDecimalToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToByteTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableByteTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToCharTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableCharTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToDecimalTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableDecimalTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToDoubleTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableDoubleTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToEnumTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableEnumTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToEnumLongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableEnumLongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToFloatTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableFloatTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToIntTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableIntTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToLongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableLongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToSByteTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableSByteTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToShortTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableShortTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToUIntTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableUIntTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToULongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableULongTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToUShortTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedDoubleToNullableUShortTest()
        {
            foreach (double value in new double[] { 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedDoubleToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToByteTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableByteTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToCharTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableCharTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToDecimalTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableDecimalTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToDoubleTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableDoubleTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToEnumTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableEnumTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToEnumLongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableEnumLongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToFloatTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableFloatTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToIntTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableIntTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToLongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableLongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToSByteTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableSByteTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToShortTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableShortTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToUIntTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableUIntTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToULongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableULongTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToUShortTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableDoubleToNullableUShortTest()
        {
            foreach (double? value in new double?[] { null, 0, 1, -1, double.MinValue, double.MaxValue, double.Epsilon, double.NegativeInfinity, double.PositiveInfinity, double.NaN })
            {
                VerifyCheckedNullableDoubleToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToByteTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableByteTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToCharTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableCharTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToDoubleTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableDoubleTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToEnumTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableEnumTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToEnumLongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableEnumLongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToFloatTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableFloatTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToIntTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableIntTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToLongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableLongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToSByteTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableSByteTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToShortTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableShortTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToUIntTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableUIntTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToULongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableULongTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToUShortTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumToNullableUShortTest()
        {
            foreach (E value in new E[] { (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedEnumToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToByteTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableByteTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToCharTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableCharTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToDoubleTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableDoubleTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToEnumTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableEnumTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToEnumLongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableEnumLongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToFloatTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableFloatTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToIntTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableIntTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToLongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableLongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToSByteTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableSByteTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToShortTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableShortTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToUIntTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableUIntTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToULongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableULongTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToUShortTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumToNullableUShortTest()
        {
            foreach (E? value in new E?[] { null, (E)0, E.A, E.B, (E)int.MaxValue, (E)int.MinValue })
            {
                VerifyCheckedNullableEnumToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToByteTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableByteTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToCharTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableCharTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToDoubleTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableDoubleTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToEnumTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableEnumTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToEnumLongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableEnumLongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToFloatTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableFloatTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToIntTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableIntTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToLongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableLongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToSByteTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableSByteTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToShortTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableShortTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToUIntTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableUIntTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToULongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableULongTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToUShortTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedEnumLongToNullableUShortTest()
        {
            foreach (El value in new El[] { (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedEnumLongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToByteTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableByteTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToCharTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableCharTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToDoubleTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableDoubleTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToEnumTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableEnumTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToEnumLongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableEnumLongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToFloatTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableFloatTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToIntTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableIntTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToLongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableLongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToSByteTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableSByteTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToShortTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableShortTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToUIntTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableUIntTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToULongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableULongTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToUShortTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableEnumLongToNullableUShortTest()
        {
            foreach (El? value in new El?[] { null, (El)0, El.A, El.B, (El)long.MaxValue, (El)long.MinValue })
            {
                VerifyCheckedNullableEnumLongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToByteTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableByteTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToCharTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableCharTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToDecimalTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableDecimalTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToDoubleTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableDoubleTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToEnumTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableEnumTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToEnumLongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableEnumLongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToFloatTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableFloatTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToIntTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableIntTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToLongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableLongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToSByteTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableSByteTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToShortTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableShortTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToUIntTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableUIntTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToULongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableULongTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToUShortTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedFloatToNullableUShortTest()
        {
            foreach (float value in new float[] { 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedFloatToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToByteTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableByteTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToCharTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableCharTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToDecimalTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableDecimalTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToDoubleTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableDoubleTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToEnumTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableEnumTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToEnumLongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableEnumLongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToFloatTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableFloatTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToIntTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableIntTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToLongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableLongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToSByteTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableSByteTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToShortTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableShortTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToUIntTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableUIntTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToULongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableULongTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToUShortTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableFloatToNullableUShortTest()
        {
            foreach (float? value in new float?[] { null, 0, 1, -1, float.MinValue, float.MaxValue, float.Epsilon, float.NegativeInfinity, float.PositiveInfinity, float.NaN })
            {
                VerifyCheckedNullableFloatToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToByteTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableByteTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToCharTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableCharTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToDecimalTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableDecimalTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToDoubleTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableDoubleTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToEnumTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableEnumTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToEnumLongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableEnumLongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToFloatTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableFloatTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToIntTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableIntTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToLongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableLongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToSByteTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableSByteTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToShortTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableShortTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToUIntTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableUIntTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToULongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableULongTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToUShortTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedIntToNullableUShortTest()
        {
            foreach (int value in new int[] { 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedIntToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToByteTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableByteTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToCharTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableCharTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToDecimalTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableDecimalTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToDoubleTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableDoubleTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToEnumTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableEnumTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToEnumLongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableEnumLongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToFloatTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableFloatTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToIntTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableIntTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToLongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableLongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToSByteTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableSByteTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToShortTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableShortTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToUIntTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableUIntTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToULongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableULongTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToUShortTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableIntToNullableUShortTest()
        {
            foreach (int? value in new int?[] { null, 0, 1, -1, int.MinValue, int.MaxValue })
            {
                VerifyCheckedNullableIntToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToByteTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableByteTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToCharTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableCharTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToDecimalTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableDecimalTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToDoubleTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableDoubleTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToEnumTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableEnumTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToEnumLongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableEnumLongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToFloatTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableFloatTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToIntTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableIntTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToLongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableLongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToSByteTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableSByteTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToShortTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableShortTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToUIntTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableUIntTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToULongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableULongTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToUShortTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedLongToNullableUShortTest()
        {
            foreach (long value in new long[] { 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedLongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToByteTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableByteTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToCharTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableCharTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToDecimalTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableDecimalTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToDoubleTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableDoubleTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToEnumTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableEnumTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToEnumLongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableEnumLongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToFloatTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableFloatTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToIntTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableIntTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToLongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableLongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToSByteTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableSByteTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToShortTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableShortTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToUIntTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableUIntTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToULongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableULongTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToUShortTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableLongToNullableUShortTest()
        {
            foreach (long? value in new long?[] { null, 0, 1, -1, long.MinValue, long.MaxValue })
            {
                VerifyCheckedNullableLongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToByteTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableByteTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToCharTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableCharTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToDecimalTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableDecimalTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToDoubleTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableDoubleTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToEnumTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableEnumTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToEnumLongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableEnumLongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToFloatTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableFloatTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToIntTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableIntTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToLongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableLongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToSByteTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableSByteTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToShortTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableShortTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToUIntTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableUIntTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToULongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableULongTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToUShortTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedSByteToNullableUShortTest()
        {
            foreach (sbyte value in new sbyte[] { 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedSByteToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToByteTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableByteTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToCharTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableCharTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToDecimalTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableDecimalTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToDoubleTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableDoubleTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToEnumTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableEnumTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToEnumLongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableEnumLongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToFloatTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableFloatTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToIntTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableIntTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToLongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableLongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToSByteTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableSByteTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToShortTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableShortTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToUIntTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableUIntTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToULongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableULongTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToUShortTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableSByteToNullableUShortTest()
        {
            foreach (sbyte? value in new sbyte?[] { null, 0, 1, -1, sbyte.MinValue, sbyte.MaxValue })
            {
                VerifyCheckedNullableSByteToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToByteTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableByteTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToCharTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableCharTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToDecimalTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableDecimalTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToDoubleTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableDoubleTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToEnumTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableEnumTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToEnumLongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableEnumLongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToFloatTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableFloatTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToIntTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableIntTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToLongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableLongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToSByteTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableSByteTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToShortTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableShortTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToUIntTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableUIntTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToULongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableULongTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToUShortTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedShortToNullableUShortTest()
        {
            foreach (short value in new short[] { 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedShortToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToByteTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableByteTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToCharTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableCharTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToDecimalTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableDecimalTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToDoubleTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableDoubleTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToEnumTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableEnumTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToEnumLongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableEnumLongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToFloatTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableFloatTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToIntTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableIntTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToLongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableLongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToSByteTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableSByteTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToShortTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableShortTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToUIntTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableUIntTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToULongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableULongTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToUShortTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableShortToNullableUShortTest()
        {
            foreach (short? value in new short?[] { null, 0, 1, -1, short.MinValue, short.MaxValue })
            {
                VerifyCheckedNullableShortToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToByteTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableByteTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToCharTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableCharTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToDecimalTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableDecimalTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToDoubleTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableDoubleTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToEnumTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableEnumTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToEnumLongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableEnumLongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToFloatTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableFloatTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToIntTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableIntTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToLongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableLongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToSByteTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableSByteTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToShortTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableShortTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToUIntTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableUIntTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToULongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableULongTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToUShortTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUIntToNullableUShortTest()
        {
            foreach (uint value in new uint[] { 0, 1, uint.MaxValue })
            {
                VerifyCheckedUIntToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToByteTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableByteTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToCharTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableCharTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToDecimalTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableDecimalTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToDoubleTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableDoubleTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToEnumTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableEnumTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToEnumLongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableEnumLongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToFloatTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableFloatTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToIntTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableIntTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToLongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableLongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToSByteTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableSByteTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToShortTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableShortTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToUIntTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableUIntTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToULongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableULongTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToUShortTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUIntToNullableUShortTest()
        {
            foreach (uint? value in new uint?[] { null, 0, 1, uint.MaxValue })
            {
                VerifyCheckedNullableUIntToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToByteTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableByteTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToCharTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableCharTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToDecimalTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableDecimalTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToDoubleTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableDoubleTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToEnumTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableEnumTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToEnumLongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableEnumLongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToFloatTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableFloatTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToIntTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableIntTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToLongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableLongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToSByteTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableSByteTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToShortTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableShortTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToUIntTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableUIntTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToULongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableULongTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToUShortTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedULongToNullableUShortTest()
        {
            foreach (ulong value in new ulong[] { 0, 1, ulong.MaxValue })
            {
                VerifyCheckedULongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToByteTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableByteTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToCharTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableCharTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToDecimalTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableDecimalTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToDoubleTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableDoubleTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToEnumTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableEnumTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToEnumLongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableEnumLongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToFloatTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableFloatTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToIntTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableIntTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToLongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableLongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToSByteTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableSByteTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToShortTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableShortTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToUIntTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableUIntTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToULongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableULongTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToUShortTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableULongToNullableUShortTest()
        {
            foreach (ulong? value in new ulong?[] { null, 0, 1, ulong.MaxValue })
            {
                VerifyCheckedNullableULongToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToByteTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableByteTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToCharTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableCharTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToDecimalTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableDecimalTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToDoubleTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableDoubleTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToEnumTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableEnumTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToEnumLongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableEnumLongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToFloatTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableFloatTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToIntTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableIntTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToLongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableLongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToSByteTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableSByteTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToShortTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableShortTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToUIntTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableUIntTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToULongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableULongTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToUShortTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedUShortToNullableUShortTest()
        {
            foreach (ushort value in new ushort[] { 0, 1, ushort.MaxValue })
            {
                VerifyCheckedUShortToNullableUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToByteTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableByteTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToCharTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableCharTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableChar(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToDecimalTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableDecimalTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableDecimal(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToDoubleTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableDoubleTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableDouble(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToEnumTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableEnumTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableEnum(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToEnumLongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableEnumLongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableEnumLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToFloatTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableFloatTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableFloat(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToIntTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableIntTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToLongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableLongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableLong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToSByteTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableSByteTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableSByte(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToShortTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableShortTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToUIntTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableUIntTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableUInt(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToULongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableULongTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableULong(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToUShortTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToUShort(value);
            }
        }

        [Fact]
        public static void ConvertCheckedNullableUShortToNullableUShortTest()
        {
            foreach (ushort? value in new ushort?[] { null, 0, 1, ushort.MaxValue })
            {
                VerifyCheckedNullableUShortToNullableUShort(value);
            }
        }

        #endregion

        #region Test verifiers

        private static void VerifyCheckedByteToByte(byte value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableByte(byte value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToChar(byte value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableChar(byte value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToDecimal(byte value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableDecimal(byte value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToDouble(byte value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableDouble(byte value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToEnum(byte value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableEnum(byte value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToEnumLong(byte value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableEnumLong(byte value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToFloat(byte value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableFloat(byte value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToInt(byte value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableInt(byte value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToLong(byte value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableLong(byte value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToSByte(byte value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableSByte(byte value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToShort(byte value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableShort(byte value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToUInt(byte value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableUInt(byte value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToULong(byte value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableULong(byte value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToUShort(byte value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedByteToNullableUShort(byte value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToByte(byte? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableByte(byte? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToChar(byte? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableChar(byte? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToDecimal(byte? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableDecimal(byte? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToDouble(byte? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableDouble(byte? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToEnum(byte? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableEnum(byte? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToEnumLong(byte? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableEnumLong(byte? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToFloat(byte? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableFloat(byte? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToInt(byte? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableInt(byte? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToLong(byte? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableLong(byte? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToSByte(byte? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableSByte(byte? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToShort(byte? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableShort(byte? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToUInt(byte? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableUInt(byte? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToULong(byte? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableULong(byte? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToUShort(byte? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableByteToNullableUShort(byte? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(byte?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(byte?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToByte(char value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableByte(char value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToChar(char value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableChar(char value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToDecimal(char value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableDecimal(char value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToDouble(char value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableDouble(char value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToEnum(char value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableEnum(char value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToEnumLong(char value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableEnumLong(char value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToFloat(char value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableFloat(char value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToInt(char value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableInt(char value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToLong(char value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableLong(char value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToSByte(char value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableSByte(char value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToShort(char value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableShort(char value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToUInt(char value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableUInt(char value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToULong(char value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableULong(char value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToUShort(char value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedCharToNullableUShort(char value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToByte(char? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableByte(char? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToChar(char? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableChar(char? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToDecimal(char? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableDecimal(char? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToDouble(char? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableDouble(char? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToEnum(char? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableEnum(char? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToEnumLong(char? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableEnumLong(char? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToFloat(char? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableFloat(char? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToInt(char? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableInt(char? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToLong(char? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableLong(char? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToSByte(char? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableSByte(char? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToShort(char? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableShort(char? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToUInt(char? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableUInt(char? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToULong(char? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableULong(char? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToUShort(char? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableCharToNullableUShort(char? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(char?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(char?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToByte(decimal value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableByte(decimal value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToChar(decimal value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableChar(decimal value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToDecimal(decimal value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableDecimal(decimal value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToDouble(decimal value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableDouble(decimal value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToFloat(decimal value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableFloat(decimal value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToInt(decimal value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableInt(decimal value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToLong(decimal value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableLong(decimal value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToSByte(decimal value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableSByte(decimal value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToShort(decimal value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableShort(decimal value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToUInt(decimal value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableUInt(decimal value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToULong(decimal value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableULong(decimal value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToUShort(decimal value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDecimalToNullableUShort(decimal value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToByte(decimal? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableByte(decimal? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToChar(decimal? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableChar(decimal? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToDecimal(decimal? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableDecimal(decimal? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToDouble(decimal? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableDouble(decimal? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToFloat(decimal? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableFloat(decimal? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToInt(decimal? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableInt(decimal? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToLong(decimal? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableLong(decimal? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToSByte(decimal? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableSByte(decimal? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToShort(decimal? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableShort(decimal? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToUInt(decimal? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableUInt(decimal? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToULong(decimal? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableULong(decimal? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToUShort(decimal? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDecimalToNullableUShort(decimal? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(decimal?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(decimal?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToByte(double value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableByte(double value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToChar(double value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableChar(double value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToDecimal(double value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableDecimal(double value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToDouble(double value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableDouble(double value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToEnum(double value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableEnum(double value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToEnumLong(double value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableEnumLong(double value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToFloat(double value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableFloat(double value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToInt(double value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableInt(double value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToLong(double value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableLong(double value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToSByte(double value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableSByte(double value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToShort(double value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableShort(double value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToUInt(double value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableUInt(double value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToULong(double value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableULong(double value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToUShort(double value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedDoubleToNullableUShort(double value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToByte(double? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableByte(double? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToChar(double? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableChar(double? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToDecimal(double? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableDecimal(double? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToDouble(double? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableDouble(double? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToEnum(double? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableEnum(double? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToEnumLong(double? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableEnumLong(double? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToFloat(double? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableFloat(double? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToInt(double? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableInt(double? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToLong(double? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableLong(double? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToSByte(double? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableSByte(double? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToShort(double? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableShort(double? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToUInt(double? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableUInt(double? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToULong(double? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableULong(double? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToUShort(double? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableDoubleToNullableUShort(double? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(double?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(double?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToByte(E value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableByte(E value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToChar(E value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableChar(E value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToDouble(E value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableDouble(E value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToEnum(E value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableEnum(E value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToEnumLong(E value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableEnumLong(E value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToFloat(E value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableFloat(E value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToInt(E value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableInt(E value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToLong(E value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableLong(E value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToSByte(E value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableSByte(E value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToShort(E value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableShort(E value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToUInt(E value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableUInt(E value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToULong(E value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableULong(E value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToUShort(E value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumToNullableUShort(E value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToByte(E? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableByte(E? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToChar(E? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableChar(E? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToDouble(E? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableDouble(E? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToEnum(E? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableEnum(E? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToEnumLong(E? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableEnumLong(E? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToFloat(E? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableFloat(E? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToInt(E? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableInt(E? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToLong(E? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableLong(E? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToSByte(E? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableSByte(E? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToShort(E? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableShort(E? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToUInt(E? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableUInt(E? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToULong(E? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableULong(E? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToUShort(E? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumToNullableUShort(E? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(E?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(E?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToByte(El value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableByte(El value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToChar(El value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableChar(El value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToDouble(El value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableDouble(El value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToEnum(El value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableEnum(El value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToEnumLong(El value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableEnumLong(El value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToFloat(El value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableFloat(El value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToInt(El value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableInt(El value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToLong(El value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableLong(El value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToSByte(El value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableSByte(El value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToShort(El value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableShort(El value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToUInt(El value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableUInt(El value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToULong(El value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableULong(El value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToUShort(El value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedEnumLongToNullableUShort(El value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToByte(El? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableByte(El? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToChar(El? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableChar(El? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToDouble(El? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableDouble(El? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToEnum(El? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableEnum(El? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToEnumLong(El? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableEnumLong(El? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToFloat(El? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableFloat(El? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToInt(El? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableInt(El? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToLong(El? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableLong(El? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToSByte(El? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableSByte(El? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToShort(El? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableShort(El? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToUInt(El? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableUInt(El? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToULong(El? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableULong(El? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToUShort(El? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableEnumLongToNullableUShort(El? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(El?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(El?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToByte(float value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableByte(float value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToChar(float value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableChar(float value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToDecimal(float value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableDecimal(float value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToDouble(float value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableDouble(float value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToEnum(float value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableEnum(float value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToEnumLong(float value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableEnumLong(float value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToFloat(float value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableFloat(float value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToInt(float value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableInt(float value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToLong(float value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableLong(float value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToSByte(float value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableSByte(float value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToShort(float value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableShort(float value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToUInt(float value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableUInt(float value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToULong(float value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableULong(float value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToUShort(float value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedFloatToNullableUShort(float value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToByte(float? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableByte(float? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToChar(float? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableChar(float? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToDecimal(float? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableDecimal(float? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToDouble(float? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableDouble(float? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToEnum(float? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableEnum(float? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToEnumLong(float? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableEnumLong(float? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToFloat(float? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableFloat(float? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToInt(float? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableInt(float? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToLong(float? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableLong(float? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToSByte(float? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableSByte(float? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToShort(float? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableShort(float? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToUInt(float? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableUInt(float? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToULong(float? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableULong(float? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToUShort(float? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableFloatToNullableUShort(float? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(float?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(float?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToByte(int value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableByte(int value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToChar(int value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableChar(int value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToDecimal(int value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableDecimal(int value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToDouble(int value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableDouble(int value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToEnum(int value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableEnum(int value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToEnumLong(int value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableEnumLong(int value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToFloat(int value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableFloat(int value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToInt(int value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableInt(int value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToLong(int value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableLong(int value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToSByte(int value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableSByte(int value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToShort(int value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableShort(int value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToUInt(int value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableUInt(int value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToULong(int value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableULong(int value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToUShort(int value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedIntToNullableUShort(int value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToByte(int? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableByte(int? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToChar(int? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableChar(int? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToDecimal(int? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableDecimal(int? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToDouble(int? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableDouble(int? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToEnum(int? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableEnum(int? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToEnumLong(int? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableEnumLong(int? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToFloat(int? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableFloat(int? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToInt(int? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableInt(int? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToLong(int? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableLong(int? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToSByte(int? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableSByte(int? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToShort(int? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableShort(int? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToUInt(int? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableUInt(int? value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToULong(int? value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableULong(int? value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToUShort(int? value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableIntToNullableUShort(int? value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(int?)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(int?)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToByte(long value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableByte(long value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToChar(long value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableChar(long value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToDecimal(long value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableDecimal(long value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToDouble(long value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableDouble(long value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToEnum(long value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableEnum(long value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToEnumLong(long value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableEnumLong(long value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToFloat(long value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableFloat(long value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToInt(long value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableInt(long value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToLong(long value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableLong(long value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToSByte(long value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableSByte(long value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToShort(long value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableShort(long value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToUInt(long value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(uint)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableUInt(long value)
        {
            Expression<Func<uint?>> e =
                Expression.Lambda<Func<uint?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(uint?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint?> f = e.Compile();

            // compute the value with the expression tree
            uint? etResult = default(uint?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint? csResult = default(uint?);
            Exception csException = null;
            try
            {
                csResult = checked((uint?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(uint?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToULong(long value)
        {
            Expression<Func<ulong>> e =
                Expression.Lambda<Func<ulong>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(ulong)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong> f = e.Compile();

            // compute the value with the expression tree
            ulong etResult = default(ulong);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong csResult = default(ulong);
            Exception csException = null;
            try
            {
                csResult = checked((ulong)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(ulong)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableULong(long value)
        {
            Expression<Func<ulong?>> e =
                Expression.Lambda<Func<ulong?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(ulong?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ulong?> f = e.Compile();

            // compute the value with the expression tree
            ulong? etResult = default(ulong?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ulong? csResult = default(ulong?);
            Exception csException = null;
            try
            {
                csResult = checked((ulong?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(ulong?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToUShort(long value)
        {
            Expression<Func<ushort>> e =
                Expression.Lambda<Func<ushort>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(ushort)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort> f = e.Compile();

            // compute the value with the expression tree
            ushort etResult = default(ushort);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort csResult = default(ushort);
            Exception csException = null;
            try
            {
                csResult = checked((ushort)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(ushort)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedLongToNullableUShort(long value)
        {
            Expression<Func<ushort?>> e =
                Expression.Lambda<Func<ushort?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long)), typeof(ushort?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<ushort?> f = e.Compile();

            // compute the value with the expression tree
            ushort? etResult = default(ushort?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            ushort? csResult = default(ushort?);
            Exception csException = null;
            try
            {
                csResult = checked((ushort?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long)) || !IsIntegral(typeof(ushort?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToByte(long? value)
        {
            Expression<Func<byte>> e =
                Expression.Lambda<Func<byte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(byte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte> f = e.Compile();

            // compute the value with the expression tree
            byte etResult = default(byte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte csResult = default(byte);
            Exception csException = null;
            try
            {
                csResult = checked((byte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(byte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableByte(long? value)
        {
            Expression<Func<byte?>> e =
                Expression.Lambda<Func<byte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(byte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<byte?> f = e.Compile();

            // compute the value with the expression tree
            byte? etResult = default(byte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            byte? csResult = default(byte?);
            Exception csException = null;
            try
            {
                csResult = checked((byte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(byte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToChar(long? value)
        {
            Expression<Func<char>> e =
                Expression.Lambda<Func<char>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(char)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char> f = e.Compile();

            // compute the value with the expression tree
            char etResult = default(char);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char csResult = default(char);
            Exception csException = null;
            try
            {
                csResult = checked((char)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(char)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableChar(long? value)
        {
            Expression<Func<char?>> e =
                Expression.Lambda<Func<char?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(char?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<char?> f = e.Compile();

            // compute the value with the expression tree
            char? etResult = default(char?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            char? csResult = default(char?);
            Exception csException = null;
            try
            {
                csResult = checked((char?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(char?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToDecimal(long? value)
        {
            Expression<Func<decimal>> e =
                Expression.Lambda<Func<decimal>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(decimal)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal> f = e.Compile();

            // compute the value with the expression tree
            decimal etResult = default(decimal);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal csResult = default(decimal);
            Exception csException = null;
            try
            {
                csResult = checked((decimal)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(decimal)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableDecimal(long? value)
        {
            Expression<Func<decimal?>> e =
                Expression.Lambda<Func<decimal?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(decimal?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<decimal?> f = e.Compile();

            // compute the value with the expression tree
            decimal? etResult = default(decimal?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            decimal? csResult = default(decimal?);
            Exception csException = null;
            try
            {
                csResult = checked((decimal?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(decimal?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToDouble(long? value)
        {
            Expression<Func<double>> e =
                Expression.Lambda<Func<double>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(double)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double> f = e.Compile();

            // compute the value with the expression tree
            double etResult = default(double);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double csResult = default(double);
            Exception csException = null;
            try
            {
                csResult = checked((double)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(double)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableDouble(long? value)
        {
            Expression<Func<double?>> e =
                Expression.Lambda<Func<double?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(double?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<double?> f = e.Compile();

            // compute the value with the expression tree
            double? etResult = default(double?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            double? csResult = default(double?);
            Exception csException = null;
            try
            {
                csResult = checked((double?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(double?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToEnum(long? value)
        {
            Expression<Func<E>> e =
                Expression.Lambda<Func<E>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(E)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E> f = e.Compile();

            // compute the value with the expression tree
            E etResult = default(E);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E csResult = default(E);
            Exception csException = null;
            try
            {
                csResult = checked((E)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(E)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableEnum(long? value)
        {
            Expression<Func<E?>> e =
                Expression.Lambda<Func<E?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(E?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<E?> f = e.Compile();

            // compute the value with the expression tree
            E? etResult = default(E?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            E? csResult = default(E?);
            Exception csException = null;
            try
            {
                csResult = checked((E?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(E?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToEnumLong(long? value)
        {
            Expression<Func<El>> e =
                Expression.Lambda<Func<El>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(El)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El> f = e.Compile();

            // compute the value with the expression tree
            El etResult = default(El);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El csResult = default(El);
            Exception csException = null;
            try
            {
                csResult = checked((El)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(El)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableEnumLong(long? value)
        {
            Expression<Func<El?>> e =
                Expression.Lambda<Func<El?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(El?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<El?> f = e.Compile();

            // compute the value with the expression tree
            El? etResult = default(El?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            El? csResult = default(El?);
            Exception csException = null;
            try
            {
                csResult = checked((El?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(El?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToFloat(long? value)
        {
            Expression<Func<float>> e =
                Expression.Lambda<Func<float>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(float)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float> f = e.Compile();

            // compute the value with the expression tree
            float etResult = default(float);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float csResult = default(float);
            Exception csException = null;
            try
            {
                csResult = checked((float)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(float)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableFloat(long? value)
        {
            Expression<Func<float?>> e =
                Expression.Lambda<Func<float?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(float?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<float?> f = e.Compile();

            // compute the value with the expression tree
            float? etResult = default(float?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            float? csResult = default(float?);
            Exception csException = null;
            try
            {
                csResult = checked((float?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(float?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToInt(long? value)
        {
            Expression<Func<int>> e =
                Expression.Lambda<Func<int>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(int)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int> f = e.Compile();

            // compute the value with the expression tree
            int etResult = default(int);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int csResult = default(int);
            Exception csException = null;
            try
            {
                csResult = checked((int)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(int)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableInt(long? value)
        {
            Expression<Func<int?>> e =
                Expression.Lambda<Func<int?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(int?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<int?> f = e.Compile();

            // compute the value with the expression tree
            int? etResult = default(int?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            int? csResult = default(int?);
            Exception csException = null;
            try
            {
                csResult = checked((int?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(int?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToLong(long? value)
        {
            Expression<Func<long>> e =
                Expression.Lambda<Func<long>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(long)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long> f = e.Compile();

            // compute the value with the expression tree
            long etResult = default(long);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long csResult = default(long);
            Exception csException = null;
            try
            {
                csResult = checked((long)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(long)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableLong(long? value)
        {
            Expression<Func<long?>> e =
                Expression.Lambda<Func<long?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(long?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<long?> f = e.Compile();

            // compute the value with the expression tree
            long? etResult = default(long?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            long? csResult = default(long?);
            Exception csException = null;
            try
            {
                csResult = checked((long?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(long?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToSByte(long? value)
        {
            Expression<Func<sbyte>> e =
                Expression.Lambda<Func<sbyte>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(sbyte)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte> f = e.Compile();

            // compute the value with the expression tree
            sbyte etResult = default(sbyte);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte csResult = default(sbyte);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(sbyte)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableSByte(long? value)
        {
            Expression<Func<sbyte?>> e =
                Expression.Lambda<Func<sbyte?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(sbyte?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<sbyte?> f = e.Compile();

            // compute the value with the expression tree
            sbyte? etResult = default(sbyte?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            sbyte? csResult = default(sbyte?);
            Exception csException = null;
            try
            {
                csResult = checked((sbyte?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(sbyte?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToShort(long? value)
        {
            Expression<Func<short>> e =
                Expression.Lambda<Func<short>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(short)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short> f = e.Compile();

            // compute the value with the expression tree
            short etResult = default(short);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short csResult = default(short);
            Exception csException = null;
            try
            {
                csResult = checked((short)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(short)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToNullableShort(long? value)
        {
            Expression<Func<short?>> e =
                Expression.Lambda<Func<short?>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(short?)),
                    Enumerable.Empty<ParameterExpression>());
            Func<short?> f = e.Compile();

            // compute the value with the expression tree
            short? etResult = default(short?);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            short? csResult = default(short?);
            Exception csException = null;
            try
            {
                csResult = checked((short?)value);
            }
            catch (Exception ex)
            {
                csException = ex;
            }

            // either both should have failed the same way or they should both produce the same result
            if (etException != null || csException != null)
            {
                Assert.NotNull(etException);
                Assert.NotNull(csException);
                Assert.Equal(csException.GetType(), etException.GetType());
            }
            else
            {
                if (!IsFloating(typeof(long?)) || !IsIntegral(typeof(short?)))
                {
                    Assert.Equal(csResult, etResult);
                }
            }
        }

        private static void VerifyCheckedNullableLongToUInt(long? value)
        {
            Expression<Func<uint>> e =
                Expression.Lambda<Func<uint>>(
                    Expression.ConvertChecked(Expression.Constant(value, typeof(long?)), typeof(uint)),
                    Enumerable.Empty<ParameterExpression>());
            Func<uint> f = e.Compile();

            // compute the value with the expression tree
            uint etResult = default(uint);
            Exception etException = null;
            try
            {
                etResult = f();
            }
            catch (Exception ex)
            {
                etException = ex;
            }

            // compute the value with regular IL
            uint csResult = default(uint);
            Exception csException = null;
            try
            {
                csResult = checked((uint)value);
 