# Architecture

<!-- Generated by https://docs.google.com/drawings/d/18ueycwaon8G5knrdt6W-R9oxmWjCd7OiFw6xixJfUNM/edit -->

![image](https://user-images.githubusercontent.com/2301202/81859509-f502fc00-952a-11ea-97fc-0592621cc405.png)

## Overview

Lighthouse CI is split into two core packages `@lhci/cli` and `@lhci/server`. The CLI is the primary way users interact with Lighthouse CI. The server module is used to setup the [Lighthouse CI server](./server.md).

The CLI is broken down into commands that are run in a variety of environments. See the below lists for where we expect different commands to be run.

**Locally, on a user's device**

- `wizard` (create new projects on the LHCI server)
- `collect` (run Lighthouse many times)
- `open` (open the median run)

**Remotely, on CI servers**

- `autorun`
- `healthcheck`
- `collect`
- `assert`
- `upload`

**Remotely, on a LHCI server**

- `server`
- `wizard` (reset tokens)

## CI Flow

The typical CI flow for command execution is `healthcheck` -> `collect` -> `assert` -> `upload`. Each command reads/writes data from the `.lighthouseci/` folder on the local filesystem. This is where `collect` will store reports, `assert` will _read_ reports and _write_ assertion results, and `upload` will _read_ both reports and assertion results to upload to another location such as the temporary public storage service, GitHub (for status checks), or a LHCI server.

## Related Documents

- [Lighthouse Architecture](https://github.com/GoogleChrome/lighthouse/blob/master/docs/architecture.md)
