/**
 * @license Copyright 2019 Google Inc. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */

import {h, Fragment} from 'preact';
import clsx from 'clsx';
import './pill.css';

/** @param {{children: string|JSX.Element|JSX.Element[], className?: string, variant?: 'base'|'compare'|'master-branch'|'dev-branch', onClick?: () => void, solid?: boolean, avatar?: Pick<LHCI.ServerCommand.Build, 'avatarUrl'|'author'>}} props */
export const Pill = props => {
  const {children, avatar, variant = 'base'} = props;
  return (
    <div
      className={clsx('pill', props.className, `pill--${variant}`, {
        'pill--clickable': !!props.onClick,
        'pill--solid': props.solid,
      })}
      onClick={props.onClick}
    >
      {avatar ? (
        <img
          className="pill__avatar"
          title={avatar.author}
          alt={avatar.author}
          src={avatar.avatarUrl}
        />
      ) : (
        <Fragment />
      )}
      <span>{children}</span>
    </div>
  );
};
