//go:build go1.22

// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.5.0 DO NOT EDIT.
package api

import (
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"time"

	"github.com/oapi-codegen/runtime"
	strictnethttp "github.com/oapi-codegen/runtime/strictmiddleware/nethttp"
	externalRef0 "github.com/terwey/3commas-sdk-go/threecommas"
)

const (
	SessionCookieScopes = "SessionCookie.Scopes"
)

// Defines values for HyperliquidCancelActionKind.
const (
	Cancel HyperliquidCancelActionKind = "cancel"
)

// Defines values for HyperliquidCreateActionKind.
const (
	Create HyperliquidCreateActionKind = "create"
)

// Defines values for HyperliquidModifyActionKind.
const (
	Modify HyperliquidModifyActionKind = "modify"
)

// Defines values for HyperliquidNoopActionKind.
const (
	None HyperliquidNoopActionKind = "none"
)

// Defines values for HyperliquidOrderStatus.
const (
	BadAloPxRejected                          HyperliquidOrderStatus = "badAloPxRejected"
	BadTriggerPxRejected                      HyperliquidOrderStatus = "badTriggerPxRejected"
	Canceled                                  HyperliquidOrderStatus = "canceled"
	DelistedCanceled                          HyperliquidOrderStatus = "delistedCanceled"
	Filled                                    HyperliquidOrderStatus = "filled"
	IocCancelRejected                         HyperliquidOrderStatus = "iocCancelRejected"
	LiquidatedCanceled                        HyperliquidOrderStatus = "liquidatedCanceled"
	MarginCanceled                            HyperliquidOrderStatus = "marginCanceled"
	MarketOrderNoLiquidityRejected            HyperliquidOrderStatus = "marketOrderNoLiquidityRejected"
	MinTradeNtlRejected                       HyperliquidOrderStatus = "minTradeNtlRejected"
	Open                                      HyperliquidOrderStatus = "open"
	OpenInterestCapCanceled                   HyperliquidOrderStatus = "openInterestCapCanceled"
	OpenInterestIncreaseRejected              HyperliquidOrderStatus = "openInterestIncreaseRejected"
	PerpMarginRejected                        HyperliquidOrderStatus = "perpMarginRejected"
	PositionFlipAtOpenInterestCapRejected     HyperliquidOrderStatus = "positionFlipAtOpenInterestCapRejected"
	PositionIncreaseAtOpenInterestCapRejected HyperliquidOrderStatus = "positionIncreaseAtOpenInterestCapRejected"
	ReduceOnlyCanceled                        HyperliquidOrderStatus = "reduceOnlyCanceled"
	ReduceOnlyRejected                        HyperliquidOrderStatus = "reduceOnlyRejected"
	Rejected                                  HyperliquidOrderStatus = "rejected"
	ScheduledCancel                           HyperliquidOrderStatus = "scheduledCancel"
	SelfTradeCanceled                         HyperliquidOrderStatus = "selfTradeCanceled"
	SiblingFilledCanceled                     HyperliquidOrderStatus = "siblingFilledCanceled"
	TickRejected                              HyperliquidOrderStatus = "tickRejected"
	TooAggressiveAtOpenInterestCapRejected    HyperliquidOrderStatus = "tooAggressiveAtOpenInterestCapRejected"
	Triggered                                 HyperliquidOrderStatus = "triggered"
	VaultWithdrawalCanceled                   HyperliquidOrderStatus = "vaultWithdrawalCanceled"
)

// Defines values for HyperliquidStatusLogEntryType.
const (
	HyperliquidStatusLogEntryTypeHyperliquidStatus     HyperliquidStatusLogEntryType = "hyperliquid_status"
	HyperliquidStatusLogEntryTypeHyperliquidSubmission HyperliquidStatusLogEntryType = "hyperliquid_submission"
	HyperliquidStatusLogEntryTypeThreeCommasEvent      HyperliquidStatusLogEntryType = "three_commas_event"
)

// Defines values for HyperliquidSubmissionLogEntryType.
const (
	HyperliquidSubmissionLogEntryTypeHyperliquidStatus     HyperliquidSubmissionLogEntryType = "hyperliquid_status"
	HyperliquidSubmissionLogEntryTypeHyperliquidSubmission HyperliquidSubmissionLogEntryType = "hyperliquid_submission"
	HyperliquidSubmissionLogEntryTypeThreeCommasEvent      HyperliquidSubmissionLogEntryType = "three_commas_event"
)

// Defines values for OrderLogEntryBaseType.
const (
	OrderLogEntryBaseTypeHyperliquidStatus     OrderLogEntryBaseType = "hyperliquid_status"
	OrderLogEntryBaseTypeHyperliquidSubmission OrderLogEntryBaseType = "hyperliquid_submission"
	OrderLogEntryBaseTypeThreeCommasEvent      OrderLogEntryBaseType = "three_commas_event"
)

// Defines values for ThreeCommasLogEntryType.
const (
	ThreeCommasLogEntryTypeHyperliquidStatus     ThreeCommasLogEntryType = "hyperliquid_status"
	ThreeCommasLogEntryTypeHyperliquidSubmission ThreeCommasLogEntryType = "hyperliquid_submission"
	ThreeCommasLogEntryTypeThreeCommasEvent      ThreeCommasLogEntryType = "three_commas_event"
)

// Defines values for VaultState.
const (
	Sealed        VaultState = "sealed"
	SetupRequired VaultState = "setup_required"
	Unsealed      VaultState = "unsealed"
)

// BotRecord defines model for BotRecord.
type BotRecord struct {
	BotId        int64            `json:"bot_id"`
	LastSyncedAt time.Time        `json:"last_synced_at"`
	Payload      externalRef0.Bot `json:"payload"`
}

// CancelOrderByMetadataRequest defines model for CancelOrderByMetadataRequest.
type CancelOrderByMetadataRequest struct {
	// DryRun When true, validate the cancel preconditions without dispatching the Hyperliquid request.
	DryRun *bool `json:"dry_run,omitempty"`

	// Reason Optional operator note recorded alongside the cancel request.
	Reason *string `json:"reason"`
}

// CancelOrderByMetadataResponse defines model for CancelOrderByMetadataResponse.
type CancelOrderByMetadataResponse struct {
	Cancel *HyperliquidCancelOrder `json:"cancel,omitempty"`

	// Message Additional context explaining the status when relevant.
	Message *string `json:"message"`

	// Metadata Metadata hex identifying the targeted order.
	Metadata string `json:"metadata"`

	// Status Outcome of the cancel attempt (for example `queued`, `skipped`, or `noop`).
	Status string `json:"status"`
}

// DealRecord defines model for DealRecord.
type DealRecord struct {
	BotId     int64     `json:"bot_id"`
	CreatedAt time.Time `json:"created_at"`
	DealId    int64     `json:"deal_id"`

	// Payload A single DCA‐bot deal, with all its execution and P/L details.
	Payload   externalRef0.Deal `json:"payload"`
	UpdatedAt time.Time         `json:"updated_at"`
}

// HyperliquidAction defines model for HyperliquidAction.
type HyperliquidAction struct {
	union json.RawMessage
}

// HyperliquidActionBase defines model for HyperliquidActionBase.
type HyperliquidActionBase struct {
	Kind string `json:"kind"`
}

// HyperliquidCancelAction defines model for HyperliquidCancelAction.
type HyperliquidCancelAction struct {
	Cancel HyperliquidCancelOrder      `json:"cancel"`
	Kind   HyperliquidCancelActionKind `json:"kind"`
}

// HyperliquidCancelActionKind defines model for HyperliquidCancelAction.Kind.
type HyperliquidCancelActionKind string

// HyperliquidCancelOrder defines model for HyperliquidCancelOrder.
type HyperliquidCancelOrder struct {
	ClientOrderId string `json:"client_order_id"`
	Coin          string `json:"coin"`
}

// HyperliquidCreateAction defines model for HyperliquidCreateAction.
type HyperliquidCreateAction struct {
	Kind  HyperliquidCreateActionKind `json:"kind"`
	Order HyperliquidCreateOrder      `json:"order"`
}

// HyperliquidCreateActionKind defines model for HyperliquidCreateAction.Kind.
type HyperliquidCreateActionKind string

// HyperliquidCreateOrder defines model for HyperliquidCreateOrder.
type HyperliquidCreateOrder struct {
	ClientOrderId *string              `json:"client_order_id"`
	Coin          string               `json:"coin"`
	IsBuy         bool                 `json:"is_buy"`
	OrderType     HyperliquidOrderType `json:"order_type"`
	Price         float64              `json:"price"`
	ReduceOnly    bool                 `json:"reduce_only"`
	Size          float64              `json:"size"`
}

// HyperliquidLimitOrder defines model for HyperliquidLimitOrder.
type HyperliquidLimitOrder struct {
	// Tif Time in force. Examples include `Gtc`, `Ioc`, and `Alo`.
	Tif string `json:"tif"`
}

// HyperliquidModifyAction defines model for HyperliquidModifyAction.
type HyperliquidModifyAction struct {
	// ClientOrderId Client order identifier (CLOID) to target when `oid` is not available.
	ClientOrderId *string                     `json:"client_order_id"`
	Kind          HyperliquidModifyActionKind `json:"kind"`

	// Oid Target order identifier when available.
	Oid   *int64                 `json:"oid"`
	Order HyperliquidCreateOrder `json:"order"`
}

// HyperliquidModifyActionKind defines model for HyperliquidModifyAction.Kind.
type HyperliquidModifyActionKind string

// HyperliquidNoopAction defines model for HyperliquidNoopAction.
type HyperliquidNoopAction struct {
	Kind HyperliquidNoopActionKind `json:"kind"`

	// Reason Optional explanation when no actionable payload is available.
	Reason *string `json:"reason"`
}

// HyperliquidNoopActionKind defines model for HyperliquidNoopAction.Kind.
type HyperliquidNoopActionKind string

// HyperliquidOrderState defines model for HyperliquidOrderState.
type HyperliquidOrderState struct {
	LatestStatus     *HyperliquidWsOrder `json:"latest_status,omitempty"`
	LatestSubmission *HyperliquidAction  `json:"latest_submission,omitempty"`
}

// HyperliquidOrderStatus defines model for HyperliquidOrderStatus.
type HyperliquidOrderStatus string

// HyperliquidOrderType defines model for HyperliquidOrderType.
type HyperliquidOrderType struct {
	Limit   *HyperliquidLimitOrder   `json:"limit,omitempty"`
	Trigger *HyperliquidTriggerOrder `json:"trigger,omitempty"`
}

// HyperliquidStatusLogEntry defines model for HyperliquidStatusLogEntry.
type HyperliquidStatusLogEntry struct {
	BotEventId  *int64            `json:"bot_event_id"`
	Identifiers *OrderIdentifiers `json:"identifiers,omitempty"`

	// Metadata Metadata hash (hex) identifying the order context.
	Metadata   string    `json:"metadata"`
	ObservedAt time.Time `json:"observed_at"`

	// Sequence Monotonic sequence counter assigned at publish time, useful for de-duplicating streamed events.
	Sequence *int64                        `json:"sequence"`
	Status   HyperliquidWsOrder            `json:"status"`
	Type     HyperliquidStatusLogEntryType `json:"type"`
}

// HyperliquidStatusLogEntryType defines model for HyperliquidStatusLogEntry.Type.
type HyperliquidStatusLogEntryType string

// HyperliquidSubmissionLogEntry defines model for HyperliquidSubmissionLogEntry.
type HyperliquidSubmissionLogEntry struct {
	Action      HyperliquidAction `json:"action"`
	BotEventId  *int64            `json:"bot_event_id"`
	Identifiers *OrderIdentifiers `json:"identifiers,omitempty"`

	// Metadata Metadata hash (hex) identifying the order context.
	Metadata   string    `json:"metadata"`
	ObservedAt time.Time `json:"observed_at"`

	// Sequence Monotonic sequence counter assigned at publish time, useful for de-duplicating streamed events.
	Sequence *int64                            `json:"sequence"`
	Type     HyperliquidSubmissionLogEntryType `json:"type"`
}

// HyperliquidSubmissionLogEntryType defines model for HyperliquidSubmissionLogEntry.Type.
type HyperliquidSubmissionLogEntryType string

// HyperliquidTriggerOrder defines model for HyperliquidTriggerOrder.
type HyperliquidTriggerOrder struct {
	IsMarket bool `json:"is_market"`

	// Tpsl Describes whether this trigger is take-profit (`tp`) or stop-loss (`sl`).
	Tpsl      string  `json:"tpsl"`
	TriggerPx float64 `json:"trigger_px"`
}

// HyperliquidWsBasicOrder defines model for HyperliquidWsBasicOrder.
type HyperliquidWsBasicOrder struct {
	ClientOrderId *string `json:"client_order_id"`
	Coin          string  `json:"coin"`
	LimitPx       string  `json:"limit_px"`
	Oid           int64   `json:"oid"`
	OrigSize      string  `json:"orig_size"`

	// Side Either `A` (ask) or `B` (bid) in Hyperliquid terminology.
	Side      string `json:"side"`
	Size      string `json:"size"`
	Timestamp int64  `json:"timestamp"`
}

// HyperliquidWsOrder defines model for HyperliquidWsOrder.
type HyperliquidWsOrder struct {
	Order           HyperliquidWsBasicOrder `json:"order"`
	Status          HyperliquidOrderStatus  `json:"status"`
	StatusTimestamp int64                   `json:"status_timestamp"`
}

// OrderIdentifiers defines model for OrderIdentifiers.
type OrderIdentifiers struct {
	BotEventId int64 `json:"bot_event_id"`
	BotId      int64 `json:"bot_id"`

	// CreatedAt When the originating 3Commas event was created.
	CreatedAt time.Time `json:"created_at"`
	DealId    int64     `json:"deal_id"`

	// Hex Case-insensitive hash deriving from the 3Commas metadata payload.
	Hex string `json:"hex"`
}

// OrderLogEntry defines model for OrderLogEntry.
type OrderLogEntry struct {
	union json.RawMessage
}

// OrderLogEntryBase defines model for OrderLogEntryBase.
type OrderLogEntryBase struct {
	BotEventId  *int64            `json:"bot_event_id"`
	Identifiers *OrderIdentifiers `json:"identifiers,omitempty"`

	// Metadata Metadata hash (hex) identifying the order context.
	Metadata   string    `json:"metadata"`
	ObservedAt time.Time `json:"observed_at"`

	// Sequence Monotonic sequence counter assigned at publish time, useful for de-duplicating streamed events.
	Sequence *int64                `json:"sequence"`
	Type     OrderLogEntryBaseType `json:"type"`
}

// OrderLogEntryBaseType defines model for OrderLogEntryBase.Type.
type OrderLogEntryBaseType string

// OrderRecord defines model for OrderRecord.
type OrderRecord struct {
	Hyperliquid *HyperliquidOrderState `json:"hyperliquid,omitempty"`
	Identifiers OrderIdentifiers       `json:"identifiers"`

	// LogEntries Present only when `include_log=true`. Entries follow the same structured shape as the SSE stream.
	LogEntries *[]OrderLogEntry `json:"log_entries"`

	// Metadata Metadata hash (hex) as stored in `threecommas_botevents`.
	Metadata string `json:"metadata"`

	// ObservedAt Timestamp when Recomma observed the order update.
	ObservedAt  time.Time             `json:"observed_at"`
	ThreeCommas ThreeCommasOrderState `json:"three_commas"`
}

// ThreeCommasBotEvent defines model for ThreeCommasBotEvent.
type ThreeCommasBotEvent struct {
	// Action High-level classification provided by the bot event parser (for example `Placing` or `Execute`).
	Action    string    `json:"action"`
	Coin      string    `json:"coin"`
	CreatedAt time.Time `json:"created_at"`
	IsMarket  bool      `json:"is_market"`

	// OrderPosition Position of this event inside the group (1-indexed).
	OrderPosition int `json:"order_position"`

	// OrderSize Total number of orders in the group this event belongs to.
	OrderSize int `json:"order_size"`

	// OrderType Event order type from 3Commas (base, safety, take_profit, etc).
	OrderType        string   `json:"order_type"`
	Price            float64  `json:"price"`
	Profit           *float64 `json:"profit"`
	ProfitCurrency   *string  `json:"profit_currency"`
	ProfitPercentage *float64 `json:"profit_percentage"`
	ProfitUsd        *float64 `json:"profit_usd"`
	QuoteCurrency    string   `json:"quote_currency"`
	QuoteVolume      float64  `json:"quote_volume"`
	Size             float64  `json:"size"`
	Status           string   `json:"status"`

	// Text Raw message parsed from 3Commas describing the event.
	Text string `json:"text"`

	// Type BUY/SELL side reported by 3Commas.
	Type string `json:"type"`
}

// ThreeCommasLogEntry defines model for ThreeCommasLogEntry.
type ThreeCommasLogEntry struct {
	BotEventId  *int64              `json:"bot_event_id"`
	Event       ThreeCommasBotEvent `json:"event"`
	Identifiers *OrderIdentifiers   `json:"identifiers,omitempty"`

	// Metadata Metadata hash (hex) identifying the order context.
	Metadata   string    `json:"metadata"`
	ObservedAt time.Time `json:"observed_at"`

	// Sequence Monotonic sequence counter assigned at publish time, useful for de-duplicating streamed events.
	Sequence *int64                  `json:"sequence"`
	Type     ThreeCommasLogEntryType `json:"type"`
}

// ThreeCommasLogEntryType defines model for ThreeCommasLogEntry.Type.
type ThreeCommasLogEntryType string

// ThreeCommasOrderState defines model for ThreeCommasOrderState.
type ThreeCommasOrderState struct {
	Event ThreeCommasBotEvent `json:"event"`
}

// VaultEncryptedPayload defines model for VaultEncryptedPayload.
type VaultEncryptedPayload struct {
	// AssociatedData Optional associated data supplied during encryption.
	AssociatedData *[]byte `json:"associated_data"`

	// Ciphertext Base64-encoded ciphertext produced by the browser. When decrypted it yields a `VaultSecretsBundle`.
	Ciphertext []byte `json:"ciphertext"`

	// Nonce Base64-encoded nonce/IV used during encryption.
	Nonce []byte `json:"nonce"`

	// PrfParams WebAuthn PRF parameters needed for future decryptions.
	PrfParams *map[string]interface{} `json:"prf_params"`

	// Version Payload version label used to interpret the ciphertext.
	Version string `json:"version"`
}

// VaultSecretsBundle JSON structure encrypted during setup and supplied in plaintext when unsealing the vault.
type VaultSecretsBundle struct {
	NotSecret struct {
		// Username Logical username mirrored inside the plaintext payload.
		Username string `json:"username"`
	} `json:"not_secret"`
	Secrets struct {
		// HYPERLIQUIDPRIVATEKEY Hyperliquid private key corresponding to the wallet.
		HYPERLIQUIDPRIVATEKEY string `json:"HYPERLIQUID_PRIVATE_KEY"`

		// HYPERLIQUIDURL Hyperliquid URL, mainnet https://api.hyperliquid.xyz testnet https://api.hyperliquid-testnet.xyz or custom
		HYPERLIQUIDURL string `json:"HYPERLIQUID_URL"`

		// HYPERLIQUIDWALLET Hyperliquid wallet address.
		HYPERLIQUIDWALLET string `json:"HYPERLIQUID_WALLET"`

		// THREECOMMASAPIKEY Public API key for the 3Commas integration.
		THREECOMMASAPIKEY string `json:"THREECOMMAS_API_KEY"`

		// THREECOMMASPRIVATEKEY Private API key for the 3Commas integration.
		THREECOMMASPRIVATEKEY string `json:"THREECOMMAS_PRIVATE_KEY"`
	} `json:"secrets"`
}

// VaultSetupRequest defines model for VaultSetupRequest.
type VaultSetupRequest struct {
	Payload VaultEncryptedPayload `json:"payload"`

	// Username Logical username for the vault owner.
	Username string `json:"username"`
}

// VaultState defines model for VaultState.
type VaultState string

// VaultStatus defines model for VaultStatus.
type VaultStatus struct {
	// SealedAt Last time the vault entered the sealed state.
	SealedAt *time.Time `json:"sealed_at"`

	// SessionExpiresAt Session expiry for the current user when unsealed.
	SessionExpiresAt *time.Time `json:"session_expires_at"`
	State            VaultState `json:"state"`

	// UnsealedAt Last time the vault was unsealed.
	UnsealedAt *time.Time `json:"unsealed_at"`
	User       *VaultUser `json:"user,omitempty"`
}

// VaultUnsealRequest defines model for VaultUnsealRequest.
type VaultUnsealRequest struct {
	// Payload JSON structure encrypted during setup and supplied in plaintext when unsealing the vault.
	Payload VaultSecretsBundle `json:"payload"`

	// RememberSessionSeconds Optional session TTL hint; server may clamp or ignore.
	RememberSessionSeconds *int64 `json:"remember_session_seconds,omitempty"`
}

// VaultUser defines model for VaultUser.
type VaultUser struct {
	// CreatedAt Timestamp the user record was created, when available.
	CreatedAt *time.Time `json:"created_at"`
	Username  string     `json:"username"`
}

// WebAuthnLoginBeginRequest defines model for WebAuthnLoginBeginRequest.
type WebAuthnLoginBeginRequest struct {
	// Username Logical username initiating the login ceremony.
	Username string `json:"username"`
}

// WebAuthnLoginBeginResponse defines model for WebAuthnLoginBeginResponse.
type WebAuthnLoginBeginResponse struct {
	// AssertionOptions PublicKeyCredentialRequestOptions for `navigator.credentials.get`.
	AssertionOptions map[string]interface{} `json:"assertion_options"`

	// SessionToken Opaque token that must be supplied when completing login.
	SessionToken string `json:"session_token"`
}

// WebAuthnLoginFinishRequest defines model for WebAuthnLoginFinishRequest.
type WebAuthnLoginFinishRequest struct {
	// ClientResponse Parsed response from `navigator.credentials.get`.
	ClientResponse map[string]interface{} `json:"client_response"`

	// SessionToken Token issued by `/webauthn/login/begin`.
	SessionToken string `json:"session_token"`
}

// WebAuthnLoginFinishResponse defines model for WebAuthnLoginFinishResponse.
type WebAuthnLoginFinishResponse struct {
	// Status Textual status of the login ceremony (for example `authenticated`).
	Status string `json:"status"`
}

// WebAuthnRegistrationBeginRequest defines model for WebAuthnRegistrationBeginRequest.
type WebAuthnRegistrationBeginRequest struct {
	// Username Logical username initiating registration.
	Username string `json:"username"`
}

// WebAuthnRegistrationBeginResponse defines model for WebAuthnRegistrationBeginResponse.
type WebAuthnRegistrationBeginResponse struct {
	// CreationOptions PublicKeyCredentialCreationOptions for `navigator.credentials.create`.
	CreationOptions map[string]interface{} `json:"creation_options"`

	// SessionToken Opaque token that must be supplied when completing registration.
	SessionToken string `json:"session_token"`
}

// WebAuthnRegistrationFinishRequest defines model for WebAuthnRegistrationFinishRequest.
type WebAuthnRegistrationFinishRequest struct {
	// ClientResponse Parsed response from `navigator.credentials.create`.
	ClientResponse map[string]interface{} `json:"client_response"`

	// SessionToken Token issued by `/webauthn/registration/begin`.
	SessionToken string `json:"session_token"`
}

// WebAuthnRegistrationFinishResponse defines model for WebAuthnRegistrationFinishResponse.
type WebAuthnRegistrationFinishResponse struct {
	// Status Textual status of the registration ceremony (for example `registered`).
	Status string `json:"status"`
}

// ListBotsParams defines parameters for ListBots.
type ListBotsParams struct {
	// BotId Return only the bot with this ID (exact match).
	BotId *int64 `form:"bot_id,omitempty" json:"bot_id,omitempty"`

	// UpdatedFrom ISO-8601 timestamp; include bots touched at or after this time.
	UpdatedFrom *time.Time `form:"updated_from,omitempty" json:"updated_from,omitempty"`

	// UpdatedTo ISO-8601 timestamp; include bots touched at or before this time.
	UpdatedTo *time.Time `form:"updated_to,omitempty" json:"updated_to,omitempty"`

	// Limit Maximum number of rows (default 100, max 500).
	Limit *int32 `form:"limit,omitempty" json:"limit,omitempty"`

	// PageToken Opaque cursor returned by a previous call (empty for first page).
	PageToken *string `form:"page_token,omitempty" json:"page_token,omitempty"`
}

// ListDealsParams defines parameters for ListDeals.
type ListDealsParams struct {
	// DealId Return only the deal with this ID (exact match).
	DealId *int64 `form:"deal_id,omitempty" json:"deal_id,omitempty"`

	// BotId Restrict to deals belonging to this bot.
	BotId *int64 `form:"bot_id,omitempty" json:"bot_id,omitempty"`

	// UpdatedFrom ISO-8601 timestamp; include deals updated at or after this time.
	UpdatedFrom *time.Time `form:"updated_from,omitempty" json:"updated_from,omitempty"`

	// UpdatedTo ISO-8601 timestamp; include deals updated at or before this time.
	UpdatedTo *time.Time `form:"updated_to,omitempty" json:"updated_to,omitempty"`

	// Limit Maximum number of rows (default 100, max 500).
	Limit *int32 `form:"limit,omitempty" json:"limit,omitempty"`

	// PageToken Opaque cursor returned by a previous call.
	PageToken *string `form:"page_token,omitempty" json:"page_token,omitempty"`
}

// ListOrdersParams defines parameters for ListOrders.
type ListOrdersParams struct {
	// Metadata Case-insensitive prefix match on metadata hex; exact match recommended for drill-down.
	Metadata *string `form:"metadata,omitempty" json:"metadata,omitempty"`

	// BotId Restrict to events emitted by this bot ID.
	BotId *int64 `form:"bot_id,omitempty" json:"bot_id,omitempty"`

	// DealId Restrict to events emitted by this deal ID.
	DealId *int64 `form:"deal_id,omitempty" json:"deal_id,omitempty"`

	// BotEventId Restrict to a specific 3Commas bot-event ID (exact match).
	BotEventId *int64 `form:"bot_event_id,omitempty" json:"bot_event_id,omitempty"`

	// ObservedFrom ISO-8601 timestamp; include events observed at or after this time.
	ObservedFrom *time.Time `form:"observed_from,omitempty" json:"observed_from,omitempty"`

	// ObservedTo ISO-8601 timestamp; include events observed at or before this time.
	ObservedTo *time.Time `form:"observed_to,omitempty" json:"observed_to,omitempty"`

	// IncludeLog When true, embed `log_entries` for each order, limited to the same metadata and time range (default false).
	IncludeLog *bool `form:"include_log,omitempty" json:"include_log,omitempty"`

	// Limit Maximum number of rows (default 100, max 500).
	Limit *int32 `form:"limit,omitempty" json:"limit,omitempty"`

	// PageToken Opaque cursor returned by a previous call.
	PageToken *string `form:"page_token,omitempty" json:"page_token,omitempty"`
}

// StreamHyperliquidPricesParams defines parameters for StreamHyperliquidPrices.
type StreamHyperliquidPricesParams struct {
	// Coin One or more Hyperliquid coin tickers to subscribe to. Repeat the parameter to request multiple coins.
	Coin []string `form:"coin" json:"coin"`
}

// StreamOrdersParams defines parameters for StreamOrders.
type StreamOrdersParams struct {
	// Metadata Case-insensitive prefix match; only events for matching metadata are emitted.
	Metadata *string `form:"metadata,omitempty" json:"metadata,omitempty"`

	// BotId Restrict to this bot ID.
	BotId *int64 `form:"bot_id,omitempty" json:"bot_id,omitempty"`

	// DealId Restrict to this deal ID.
	DealId *int64 `form:"deal_id,omitempty" json:"deal_id,omitempty"`

	// BotEventId Restrict to this bot-event ID.
	BotEventId *int64 `form:"bot_event_id,omitempty" json:"bot_event_id,omitempty"`

	// ObservedFrom If supplied, drop events older than this timestamp (useful for resume).
	ObservedFrom *time.Time `form:"observed_from,omitempty" json:"observed_from,omitempty"`
}

// CancelOrderByMetadataJSONRequestBody defines body for CancelOrderByMetadata for application/json ContentType.
type CancelOrderByMetadataJSONRequestBody = CancelOrderByMetadataRequest

// SetupVaultJSONRequestBody defines body for SetupVault for application/json ContentType.
type SetupVaultJSONRequestBody = VaultSetupRequest

// UnsealVaultJSONRequestBody defines body for UnsealVault for application/json ContentType.
type UnsealVaultJSONRequestBody = VaultUnsealRequest

// BeginWebauthnLoginJSONRequestBody defines body for BeginWebauthnLogin for application/json ContentType.
type BeginWebauthnLoginJSONRequestBody = WebAuthnLoginBeginRequest

// FinishWebauthnLoginJSONRequestBody defines body for FinishWebauthnLogin for application/json ContentType.
type FinishWebauthnLoginJSONRequestBody = WebAuthnLoginFinishRequest

// BeginWebauthnRegistrationJSONRequestBody defines body for BeginWebauthnRegistration for application/json ContentType.
type BeginWebauthnRegistrationJSONRequestBody = WebAuthnRegistrationBeginRequest

// FinishWebauthnRegistrationJSONRequestBody defines body for FinishWebauthnRegistration for application/json ContentType.
type FinishWebauthnRegistrationJSONRequestBody = WebAuthnRegistrationFinishRequest

// AsHyperliquidNoopAction returns the union data inside the HyperliquidAction as a HyperliquidNoopAction
func (t HyperliquidAction) AsHyperliquidNoopAction() (HyperliquidNoopAction, error) {
	var body HyperliquidNoopAction
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidNoopAction overwrites any union data inside the HyperliquidAction as the provided HyperliquidNoopAction
func (t *HyperliquidAction) FromHyperliquidNoopAction(v HyperliquidNoopAction) error {
	v.Kind = "none"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidNoopAction performs a merge with any union data inside the HyperliquidAction, using the provided HyperliquidNoopAction
func (t *HyperliquidAction) MergeHyperliquidNoopAction(v HyperliquidNoopAction) error {
	v.Kind = "none"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsHyperliquidCreateAction returns the union data inside the HyperliquidAction as a HyperliquidCreateAction
func (t HyperliquidAction) AsHyperliquidCreateAction() (HyperliquidCreateAction, error) {
	var body HyperliquidCreateAction
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidCreateAction overwrites any union data inside the HyperliquidAction as the provided HyperliquidCreateAction
func (t *HyperliquidAction) FromHyperliquidCreateAction(v HyperliquidCreateAction) error {
	v.Kind = "create"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidCreateAction performs a merge with any union data inside the HyperliquidAction, using the provided HyperliquidCreateAction
func (t *HyperliquidAction) MergeHyperliquidCreateAction(v HyperliquidCreateAction) error {
	v.Kind = "create"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsHyperliquidModifyAction returns the union data inside the HyperliquidAction as a HyperliquidModifyAction
func (t HyperliquidAction) AsHyperliquidModifyAction() (HyperliquidModifyAction, error) {
	var body HyperliquidModifyAction
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidModifyAction overwrites any union data inside the HyperliquidAction as the provided HyperliquidModifyAction
func (t *HyperliquidAction) FromHyperliquidModifyAction(v HyperliquidModifyAction) error {
	v.Kind = "modify"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidModifyAction performs a merge with any union data inside the HyperliquidAction, using the provided HyperliquidModifyAction
func (t *HyperliquidAction) MergeHyperliquidModifyAction(v HyperliquidModifyAction) error {
	v.Kind = "modify"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsHyperliquidCancelAction returns the union data inside the HyperliquidAction as a HyperliquidCancelAction
func (t HyperliquidAction) AsHyperliquidCancelAction() (HyperliquidCancelAction, error) {
	var body HyperliquidCancelAction
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidCancelAction overwrites any union data inside the HyperliquidAction as the provided HyperliquidCancelAction
func (t *HyperliquidAction) FromHyperliquidCancelAction(v HyperliquidCancelAction) error {
	v.Kind = "cancel"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidCancelAction performs a merge with any union data inside the HyperliquidAction, using the provided HyperliquidCancelAction
func (t *HyperliquidAction) MergeHyperliquidCancelAction(v HyperliquidCancelAction) error {
	v.Kind = "cancel"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

func (t HyperliquidAction) Discriminator() (string, error) {
	var discriminator struct {
		Discriminator string `json:"kind"`
	}
	err := json.Unmarshal(t.union, &discriminator)
	return discriminator.Discriminator, err
}

func (t HyperliquidAction) ValueByDiscriminator() (interface{}, error) {
	discriminator, err := t.Discriminator()
	if err != nil {
		return nil, err
	}
	switch discriminator {
	case "cancel":
		return t.AsHyperliquidCancelAction()
	case "create":
		return t.AsHyperliquidCreateAction()
	case "modify":
		return t.AsHyperliquidModifyAction()
	case "none":
		return t.AsHyperliquidNoopAction()
	default:
		return nil, errors.New("unknown discriminator value: " + discriminator)
	}
}

func (t HyperliquidAction) MarshalJSON() ([]byte, error) {
	b, err := t.union.MarshalJSON()
	return b, err
}

func (t *HyperliquidAction) UnmarshalJSON(b []byte) error {
	err := t.union.UnmarshalJSON(b)
	return err
}

// AsThreeCommasLogEntry returns the union data inside the OrderLogEntry as a ThreeCommasLogEntry
func (t OrderLogEntry) AsThreeCommasLogEntry() (ThreeCommasLogEntry, error) {
	var body ThreeCommasLogEntry
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromThreeCommasLogEntry overwrites any union data inside the OrderLogEntry as the provided ThreeCommasLogEntry
func (t *OrderLogEntry) FromThreeCommasLogEntry(v ThreeCommasLogEntry) error {
	v.Type = "three_commas_event"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeThreeCommasLogEntry performs a merge with any union data inside the OrderLogEntry, using the provided ThreeCommasLogEntry
func (t *OrderLogEntry) MergeThreeCommasLogEntry(v ThreeCommasLogEntry) error {
	v.Type = "three_commas_event"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsHyperliquidSubmissionLogEntry returns the union data inside the OrderLogEntry as a HyperliquidSubmissionLogEntry
func (t OrderLogEntry) AsHyperliquidSubmissionLogEntry() (HyperliquidSubmissionLogEntry, error) {
	var body HyperliquidSubmissionLogEntry
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidSubmissionLogEntry overwrites any union data inside the OrderLogEntry as the provided HyperliquidSubmissionLogEntry
func (t *OrderLogEntry) FromHyperliquidSubmissionLogEntry(v HyperliquidSubmissionLogEntry) error {
	v.Type = "hyperliquid_submission"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidSubmissionLogEntry performs a merge with any union data inside the OrderLogEntry, using the provided HyperliquidSubmissionLogEntry
func (t *OrderLogEntry) MergeHyperliquidSubmissionLogEntry(v HyperliquidSubmissionLogEntry) error {
	v.Type = "hyperliquid_submission"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsHyperliquidStatusLogEntry returns the union data inside the OrderLogEntry as a HyperliquidStatusLogEntry
func (t OrderLogEntry) AsHyperliquidStatusLogEntry() (HyperliquidStatusLogEntry, error) {
	var body HyperliquidStatusLogEntry
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromHyperliquidStatusLogEntry overwrites any union data inside the OrderLogEntry as the provided HyperliquidStatusLogEntry
func (t *OrderLogEntry) FromHyperliquidStatusLogEntry(v HyperliquidStatusLogEntry) error {
	v.Type = "hyperliquid_status"
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeHyperliquidStatusLogEntry performs a merge with any union data inside the OrderLogEntry, using the provided HyperliquidStatusLogEntry
func (t *OrderLogEntry) MergeHyperliquidStatusLogEntry(v HyperliquidStatusLogEntry) error {
	v.Type = "hyperliquid_status"
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

func (t OrderLogEntry) Discriminator() (string, error) {
	var discriminator struct {
		Discriminator string `json:"type"`
	}
	err := json.Unmarshal(t.union, &discriminator)
	return discriminator.Discriminator, err
}

func (t OrderLogEntry) ValueByDiscriminator() (interface{}, error) {
	discriminator, err := t.Discriminator()
	if err != nil {
		return nil, err
	}
	switch discriminator {
	case "hyperliquid_status":
		return t.AsHyperliquidStatusLogEntry()
	case "hyperliquid_submission":
		return t.AsHyperliquidSubmissionLogEntry()
	case "three_commas_event":
		return t.AsThreeCommasLogEntry()
	default:
		return nil, errors.New("unknown discriminator value: " + discriminator)
	}
}

func (t OrderLogEntry) MarshalJSON() ([]byte, error) {
	b, err := t.union.MarshalJSON()
	return b, err
}

func (t *OrderLogEntry) UnmarshalJSON(b []byte) error {
	err := t.union.UnmarshalJSON(b)
	return err
}

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// List cached 3Commas bots
	// (GET /api/bots)
	ListBots(w http.ResponseWriter, r *http.Request, params ListBotsParams)
	// List cached 3Commas deals
	// (GET /api/deals)
	ListDeals(w http.ResponseWriter, r *http.Request, params ListDealsParams)
	// List acted-on bot events with Hyperliquid context
	// (GET /api/orders)
	ListOrders(w http.ResponseWriter, r *http.Request, params ListOrdersParams)
	// Cancel Hyperliquid order by metadata
	// (POST /api/orders/{metadata}/cancel)
	CancelOrderByMetadata(w http.ResponseWriter, r *http.Request, metadata string)
	// Stream Hyperliquid best bid/offer quotes
	// (GET /sse/hyperliquid/prices)
	StreamHyperliquidPrices(w http.ResponseWriter, r *http.Request, params StreamHyperliquidPricesParams)
	// Stream live changes to acted-on orders
	// (GET /sse/orders)
	StreamOrders(w http.ResponseWriter, r *http.Request, params StreamOrdersParams)
	// Retrieve encrypted vault payload
	// (GET /vault/payload)
	GetVaultPayload(w http.ResponseWriter, r *http.Request)
	// Reseal the vault and clear in-memory secrets
	// (POST /vault/seal)
	SealVault(w http.ResponseWriter, r *http.Request)
	// Store the encrypted vault payload
	// (POST /vault/setup)
	SetupVault(w http.ResponseWriter, r *http.Request)
	// Inspect vault state
	// (GET /vault/status)
	GetVaultStatus(w http.ResponseWriter, r *http.Request)
	// Provide decrypted secrets to unlock the vault
	// (POST /vault/unseal)
	UnsealVault(w http.ResponseWriter, r *http.Request)
	// Begin WebAuthn assertion
	// (POST /webauthn/login/begin)
	BeginWebauthnLogin(w http.ResponseWriter, r *http.Request)
	// Complete WebAuthn assertion
	// (POST /webauthn/login/finish)
	FinishWebauthnLogin(w http.ResponseWriter, r *http.Request)
	// Begin WebAuthn registration
	// (POST /webauthn/registration/begin)
	BeginWebauthnRegistration(w http.ResponseWriter, r *http.Request)
	// Complete WebAuthn registration
	// (POST /webauthn/registration/finish)
	FinishWebauthnRegistration(w http.ResponseWriter, r *http.Request)
}

// ServerInterfaceWrapper converts contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler            ServerInterface
	HandlerMiddlewares []MiddlewareFunc
	ErrorHandlerFunc   func(w http.ResponseWriter, r *http.Request, err error)
}

type MiddlewareFunc func(http.Handler) http.Handler

// ListBots operation middleware
func (siw *ServerInterfaceWrapper) ListBots(w http.ResponseWriter, r *http.Request) {

	var err error

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	// Parameter object where we will unmarshal all parameters from the context
	var params ListBotsParams

	// ------------- Optional query parameter "bot_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_id", r.URL.Query(), &params.BotId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_id", Err: err})
		return
	}

	// ------------- Optional query parameter "updated_from" -------------

	err = runtime.BindQueryParameter("form", true, false, "updated_from", r.URL.Query(), &params.UpdatedFrom)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "updated_from", Err: err})
		return
	}

	// ------------- Optional query parameter "updated_to" -------------

	err = runtime.BindQueryParameter("form", true, false, "updated_to", r.URL.Query(), &params.UpdatedTo)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "updated_to", Err: err})
		return
	}

	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", r.URL.Query(), &params.Limit)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "limit", Err: err})
		return
	}

	// ------------- Optional query parameter "page_token" -------------

	err = runtime.BindQueryParameter("form", true, false, "page_token", r.URL.Query(), &params.PageToken)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page_token", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ListBots(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// ListDeals operation middleware
func (siw *ServerInterfaceWrapper) ListDeals(w http.ResponseWriter, r *http.Request) {

	var err error

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	// Parameter object where we will unmarshal all parameters from the context
	var params ListDealsParams

	// ------------- Optional query parameter "deal_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "deal_id", r.URL.Query(), &params.DealId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deal_id", Err: err})
		return
	}

	// ------------- Optional query parameter "bot_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_id", r.URL.Query(), &params.BotId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_id", Err: err})
		return
	}

	// ------------- Optional query parameter "updated_from" -------------

	err = runtime.BindQueryParameter("form", true, false, "updated_from", r.URL.Query(), &params.UpdatedFrom)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "updated_from", Err: err})
		return
	}

	// ------------- Optional query parameter "updated_to" -------------

	err = runtime.BindQueryParameter("form", true, false, "updated_to", r.URL.Query(), &params.UpdatedTo)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "updated_to", Err: err})
		return
	}

	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", r.URL.Query(), &params.Limit)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "limit", Err: err})
		return
	}

	// ------------- Optional query parameter "page_token" -------------

	err = runtime.BindQueryParameter("form", true, false, "page_token", r.URL.Query(), &params.PageToken)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page_token", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ListDeals(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// ListOrders operation middleware
func (siw *ServerInterfaceWrapper) ListOrders(w http.ResponseWriter, r *http.Request) {

	var err error

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	// Parameter object where we will unmarshal all parameters from the context
	var params ListOrdersParams

	// ------------- Optional query parameter "metadata" -------------

	err = runtime.BindQueryParameter("form", true, false, "metadata", r.URL.Query(), &params.Metadata)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "metadata", Err: err})
		return
	}

	// ------------- Optional query parameter "bot_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_id", r.URL.Query(), &params.BotId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_id", Err: err})
		return
	}

	// ------------- Optional query parameter "deal_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "deal_id", r.URL.Query(), &params.DealId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deal_id", Err: err})
		return
	}

	// ------------- Optional query parameter "bot_event_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_event_id", r.URL.Query(), &params.BotEventId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_event_id", Err: err})
		return
	}

	// ------------- Optional query parameter "observed_from" -------------

	err = runtime.BindQueryParameter("form", true, false, "observed_from", r.URL.Query(), &params.ObservedFrom)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "observed_from", Err: err})
		return
	}

	// ------------- Optional query parameter "observed_to" -------------

	err = runtime.BindQueryParameter("form", true, false, "observed_to", r.URL.Query(), &params.ObservedTo)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "observed_to", Err: err})
		return
	}

	// ------------- Optional query parameter "include_log" -------------

	err = runtime.BindQueryParameter("form", true, false, "include_log", r.URL.Query(), &params.IncludeLog)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "include_log", Err: err})
		return
	}

	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", r.URL.Query(), &params.Limit)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "limit", Err: err})
		return
	}

	// ------------- Optional query parameter "page_token" -------------

	err = runtime.BindQueryParameter("form", true, false, "page_token", r.URL.Query(), &params.PageToken)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page_token", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ListOrders(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// CancelOrderByMetadata operation middleware
func (siw *ServerInterfaceWrapper) CancelOrderByMetadata(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "metadata" -------------
	var metadata string

	err = runtime.BindStyledParameterWithOptions("simple", "metadata", r.PathValue("metadata"), &metadata, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "metadata", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CancelOrderByMetadata(w, r, metadata)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// StreamHyperliquidPrices operation middleware
func (siw *ServerInterfaceWrapper) StreamHyperliquidPrices(w http.ResponseWriter, r *http.Request) {

	var err error

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	// Parameter object where we will unmarshal all parameters from the context
	var params StreamHyperliquidPricesParams

	// ------------- Required query parameter "coin" -------------

	if paramValue := r.URL.Query().Get("coin"); paramValue != "" {

	} else {
		siw.ErrorHandlerFunc(w, r, &RequiredParamError{ParamName: "coin"})
		return
	}

	err = runtime.BindQueryParameter("form", true, true, "coin", r.URL.Query(), &params.Coin)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "coin", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.StreamHyperliquidPrices(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// StreamOrders operation middleware
func (siw *ServerInterfaceWrapper) StreamOrders(w http.ResponseWriter, r *http.Request) {

	var err error

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	// Parameter object where we will unmarshal all parameters from the context
	var params StreamOrdersParams

	// ------------- Optional query parameter "metadata" -------------

	err = runtime.BindQueryParameter("form", true, false, "metadata", r.URL.Query(), &params.Metadata)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "metadata", Err: err})
		return
	}

	// ------------- Optional query parameter "bot_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_id", r.URL.Query(), &params.BotId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_id", Err: err})
		return
	}

	// ------------- Optional query parameter "deal_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "deal_id", r.URL.Query(), &params.DealId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deal_id", Err: err})
		return
	}

	// ------------- Optional query parameter "bot_event_id" -------------

	err = runtime.BindQueryParameter("form", true, false, "bot_event_id", r.URL.Query(), &params.BotEventId)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bot_event_id", Err: err})
		return
	}

	// ------------- Optional query parameter "observed_from" -------------

	err = runtime.BindQueryParameter("form", true, false, "observed_from", r.URL.Query(), &params.ObservedFrom)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "observed_from", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.StreamOrders(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetVaultPayload operation middleware
func (siw *ServerInterfaceWrapper) GetVaultPayload(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetVaultPayload(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// SealVault operation middleware
func (siw *ServerInterfaceWrapper) SealVault(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, SessionCookieScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.SealVault(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// SetupVault operation middleware
func (siw *ServerInterfaceWrapper) SetupVault(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.SetupVault(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetVaultStatus operation middleware
func (siw *ServerInterfaceWrapper) GetVaultStatus(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetVaultStatus(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UnsealVault operation middleware
func (siw *ServerInterfaceWrapper) UnsealVault(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UnsealVault(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// BeginWebauthnLogin operation middleware
func (siw *ServerInterfaceWrapper) BeginWebauthnLogin(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.BeginWebauthnLogin(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// FinishWebauthnLogin operation middleware
func (siw *ServerInterfaceWrapper) FinishWebauthnLogin(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.FinishWebauthnLogin(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// BeginWebauthnRegistration operation middleware
func (siw *ServerInterfaceWrapper) BeginWebauthnRegistration(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.BeginWebauthnRegistration(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// FinishWebauthnRegistration operation middleware
func (siw *ServerInterfaceWrapper) FinishWebauthnRegistration(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.FinishWebauthnRegistration(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

type UnescapedCookieParamError struct {
	ParamName string
	Err       error
}

func (e *UnescapedCookieParamError) Error() string {
	return fmt.Sprintf("error unescaping cookie parameter '%s'", e.ParamName)
}

func (e *UnescapedCookieParamError) Unwrap() error {
	return e.Err
}

type UnmarshalingParamError struct {
	ParamName string
	Err       error
}

func (e *UnmarshalingParamError) Error() string {
	return fmt.Sprintf("Error unmarshaling parameter %s as JSON: %s", e.ParamName, e.Err.Error())
}

func (e *UnmarshalingParamError) Unwrap() error {
	return e.Err
}

type RequiredParamError struct {
	ParamName string
}

func (e *RequiredParamError) Error() string {
	return fmt.Sprintf("Query argument %s is required, but not found", e.ParamName)
}

type RequiredHeaderError struct {
	ParamName string
	Err       error
}

func (e *RequiredHeaderError) Error() string {
	return fmt.Sprintf("Header parameter %s is required, but not found", e.ParamName)
}

func (e *RequiredHeaderError) Unwrap() error {
	return e.Err
}

type InvalidParamFormatError struct {
	ParamName string
	Err       error
}

func (e *InvalidParamFormatError) Error() string {
	return fmt.Sprintf("Invalid format for parameter %s: %s", e.ParamName, e.Err.Error())
}

func (e *InvalidParamFormatError) Unwrap() error {
	return e.Err
}

type TooManyValuesForParamError struct {
	ParamName string
	Count     int
}

func (e *TooManyValuesForParamError) Error() string {
	return fmt.Sprintf("Expected one value for %s, got %d", e.ParamName, e.Count)
}

// Handler creates http.Handler with routing matching OpenAPI spec.
func Handler(si ServerInterface) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{})
}

// ServeMux is an abstraction of http.ServeMux.
type ServeMux interface {
	HandleFunc(pattern string, handler func(http.ResponseWriter, *http.Request))
	ServeHTTP(w http.ResponseWriter, r *http.Request)
}

type StdHTTPServerOptions struct {
	BaseURL          string
	BaseRouter       ServeMux
	Middlewares      []MiddlewareFunc
	ErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

// HandlerFromMux creates http.Handler with routing matching OpenAPI spec based on the provided mux.
func HandlerFromMux(si ServerInterface, m ServeMux) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{
		BaseRouter: m,
	})
}

func HandlerFromMuxWithBaseURL(si ServerInterface, m ServeMux, baseURL string) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{
		BaseURL:    baseURL,
		BaseRouter: m,
	})
}

// HandlerWithOptions creates http.Handler with additional options
func HandlerWithOptions(si ServerInterface, options StdHTTPServerOptions) http.Handler {
	m := options.BaseRouter

	if m == nil {
		m = http.NewServeMux()
	}
	if options.ErrorHandlerFunc == nil {
		options.ErrorHandlerFunc = func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}
	}

	wrapper := ServerInterfaceWrapper{
		Handler:            si,
		HandlerMiddlewares: options.Middlewares,
		ErrorHandlerFunc:   options.ErrorHandlerFunc,
	}

	m.HandleFunc("GET "+options.BaseURL+"/api/bots", wrapper.ListBots)
	m.HandleFunc("GET "+options.BaseURL+"/api/deals", wrapper.ListDeals)
	m.HandleFunc("GET "+options.BaseURL+"/api/orders", wrapper.ListOrders)
	m.HandleFunc("POST "+options.BaseURL+"/api/orders/{metadata}/cancel", wrapper.CancelOrderByMetadata)
	m.HandleFunc("GET "+options.BaseURL+"/sse/hyperliquid/prices", wrapper.StreamHyperliquidPrices)
	m.HandleFunc("GET "+options.BaseURL+"/sse/orders", wrapper.StreamOrders)
	m.HandleFunc("GET "+options.BaseURL+"/vault/payload", wrapper.GetVaultPayload)
	m.HandleFunc("POST "+options.BaseURL+"/vault/seal", wrapper.SealVault)
	m.HandleFunc("POST "+options.BaseURL+"/vault/setup", wrapper.SetupVault)
	m.HandleFunc("GET "+options.BaseURL+"/vault/status", wrapper.GetVaultStatus)
	m.HandleFunc("POST "+options.BaseURL+"/vault/unseal", wrapper.UnsealVault)
	m.HandleFunc("POST "+options.BaseURL+"/webauthn/login/begin", wrapper.BeginWebauthnLogin)
	m.HandleFunc("POST "+options.BaseURL+"/webauthn/login/finish", wrapper.FinishWebauthnLogin)
	m.HandleFunc("POST "+options.BaseURL+"/webauthn/registration/begin", wrapper.BeginWebauthnRegistration)
	m.HandleFunc("POST "+options.BaseURL+"/webauthn/registration/finish", wrapper.FinishWebauthnRegistration)

	return m
}

type ListBotsRequestObject struct {
	Params ListBotsParams
}

type ListBotsResponseObject interface {
	VisitListBotsResponse(w http.ResponseWriter) error
}

type ListBots200JSONResponse struct {
	Items         []BotRecord `json:"items"`
	NextPageToken *string     `json:"next_page_token"`
}

func (response ListBots200JSONResponse) VisitListBotsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListBots400Response struct {
}

func (response ListBots400Response) VisitListBotsResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type ListBots500Response struct {
}

func (response ListBots500Response) VisitListBotsResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type ListDealsRequestObject struct {
	Params ListDealsParams
}

type ListDealsResponseObject interface {
	VisitListDealsResponse(w http.ResponseWriter) error
}

type ListDeals200JSONResponse struct {
	Items         []DealRecord `json:"items"`
	NextPageToken *string      `json:"next_page_token"`
}

func (response ListDeals200JSONResponse) VisitListDealsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListDeals400Response struct {
}

func (response ListDeals400Response) VisitListDealsResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type ListDeals500Response struct {
}

func (response ListDeals500Response) VisitListDealsResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type ListOrdersRequestObject struct {
	Params ListOrdersParams
}

type ListOrdersResponseObject interface {
	VisitListOrdersResponse(w http.ResponseWriter) error
}

type ListOrders200JSONResponse struct {
	Items         []OrderRecord `json:"items"`
	NextPageToken *string       `json:"next_page_token"`
}

func (response ListOrders200JSONResponse) VisitListOrdersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListOrders400Response struct {
}

func (response ListOrders400Response) VisitListOrdersResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type ListOrders500Response struct {
}

func (response ListOrders500Response) VisitListOrdersResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type CancelOrderByMetadataRequestObject struct {
	Metadata string `json:"metadata"`
	Body     *CancelOrderByMetadataJSONRequestBody
}

type CancelOrderByMetadataResponseObject interface {
	VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error
}

type CancelOrderByMetadata202JSONResponse CancelOrderByMetadataResponse

func (response CancelOrderByMetadata202JSONResponse) VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(202)

	return json.NewEncoder(w).Encode(response)
}

type CancelOrderByMetadata400Response struct {
}

func (response CancelOrderByMetadata400Response) VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type CancelOrderByMetadata404Response struct {
}

func (response CancelOrderByMetadata404Response) VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error {
	w.WriteHeader(404)
	return nil
}

type CancelOrderByMetadata409Response struct {
}

func (response CancelOrderByMetadata409Response) VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type CancelOrderByMetadata500Response struct {
}

func (response CancelOrderByMetadata500Response) VisitCancelOrderByMetadataResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type StreamHyperliquidPricesRequestObject struct {
	Params StreamHyperliquidPricesParams
}

type StreamHyperliquidPricesResponseObject interface {
	VisitStreamHyperliquidPricesResponse(w http.ResponseWriter) error
}

type StreamHyperliquidPrices200TexteventStreamResponse struct {
	Body          io.Reader
	ContentLength int64
}

func (response StreamHyperliquidPrices200TexteventStreamResponse) VisitStreamHyperliquidPricesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "text/event-stream")
	if response.ContentLength != 0 {
		w.Header().Set("Content-Length", fmt.Sprint(response.ContentLength))
	}
	w.WriteHeader(200)

	if closer, ok := response.Body.(io.ReadCloser); ok {
		defer closer.Close()
	}
	_, err := io.Copy(w, response.Body)
	return err
}

type StreamHyperliquidPrices400Response struct {
}

func (response StreamHyperliquidPrices400Response) VisitStreamHyperliquidPricesResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type StreamHyperliquidPrices500Response struct {
}

func (response StreamHyperliquidPrices500Response) VisitStreamHyperliquidPricesResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type StreamOrdersRequestObject struct {
	Params StreamOrdersParams
}

type StreamOrdersResponseObject interface {
	VisitStreamOrdersResponse(w http.ResponseWriter) error
}

type StreamOrders200TexteventStreamResponse struct {
	Body          io.Reader
	ContentLength int64
}

func (response StreamOrders200TexteventStreamResponse) VisitStreamOrdersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "text/event-stream")
	if response.ContentLength != 0 {
		w.Header().Set("Content-Length", fmt.Sprint(response.ContentLength))
	}
	w.WriteHeader(200)

	if closer, ok := response.Body.(io.ReadCloser); ok {
		defer closer.Close()
	}
	_, err := io.Copy(w, response.Body)
	return err
}

type StreamOrders400Response struct {
}

func (response StreamOrders400Response) VisitStreamOrdersResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type StreamOrders500Response struct {
}

func (response StreamOrders500Response) VisitStreamOrdersResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type GetVaultPayloadRequestObject struct {
}

type GetVaultPayloadResponseObject interface {
	VisitGetVaultPayloadResponse(w http.ResponseWriter) error
}

type GetVaultPayload200JSONResponse VaultEncryptedPayload

func (response GetVaultPayload200JSONResponse) VisitGetVaultPayloadResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetVaultPayload401Response struct {
}

func (response GetVaultPayload401Response) VisitGetVaultPayloadResponse(w http.ResponseWriter) error {
	w.WriteHeader(401)
	return nil
}

type GetVaultPayload404Response struct {
}

func (response GetVaultPayload404Response) VisitGetVaultPayloadResponse(w http.ResponseWriter) error {
	w.WriteHeader(404)
	return nil
}

type GetVaultPayload423Response struct {
}

func (response GetVaultPayload423Response) VisitGetVaultPayloadResponse(w http.ResponseWriter) error {
	w.WriteHeader(423)
	return nil
}

type GetVaultPayload500Response struct {
}

func (response GetVaultPayload500Response) VisitGetVaultPayloadResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type SealVaultRequestObject struct {
}

type SealVaultResponseObject interface {
	VisitSealVaultResponse(w http.ResponseWriter) error
}

type SealVault200JSONResponse VaultStatus

func (response SealVault200JSONResponse) VisitSealVaultResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type SealVault401Response struct {
}

func (response SealVault401Response) VisitSealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(401)
	return nil
}

type SealVault500Response struct {
}

func (response SealVault500Response) VisitSealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type SetupVaultRequestObject struct {
	Body *SetupVaultJSONRequestBody
}

type SetupVaultResponseObject interface {
	VisitSetupVaultResponse(w http.ResponseWriter) error
}

type SetupVault201JSONResponse VaultStatus

func (response SetupVault201JSONResponse) VisitSetupVaultResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(201)

	return json.NewEncoder(w).Encode(response)
}

type SetupVault400Response struct {
}

func (response SetupVault400Response) VisitSetupVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type SetupVault409Response struct {
}

func (response SetupVault409Response) VisitSetupVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type SetupVault500Response struct {
}

func (response SetupVault500Response) VisitSetupVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type GetVaultStatusRequestObject struct {
}

type GetVaultStatusResponseObject interface {
	VisitGetVaultStatusResponse(w http.ResponseWriter) error
}

type GetVaultStatus200JSONResponse VaultStatus

func (response GetVaultStatus200JSONResponse) VisitGetVaultStatusResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetVaultStatus500Response struct {
}

func (response GetVaultStatus500Response) VisitGetVaultStatusResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type UnsealVaultRequestObject struct {
	Body *UnsealVaultJSONRequestBody
}

type UnsealVaultResponseObject interface {
	VisitUnsealVaultResponse(w http.ResponseWriter) error
}

type UnsealVault200ResponseHeaders struct {
	SetCookie string
}

type UnsealVault200JSONResponse struct {
	Body    VaultStatus
	Headers UnsealVault200ResponseHeaders
}

func (response UnsealVault200JSONResponse) VisitUnsealVaultResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.Header().Set("Set-Cookie", fmt.Sprint(response.Headers.SetCookie))
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response.Body)
}

type UnsealVault400Response struct {
}

func (response UnsealVault400Response) VisitUnsealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type UnsealVault409Response struct {
}

func (response UnsealVault409Response) VisitUnsealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type UnsealVault423Response struct {
}

func (response UnsealVault423Response) VisitUnsealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(423)
	return nil
}

type UnsealVault500Response struct {
}

func (response UnsealVault500Response) VisitUnsealVaultResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type BeginWebauthnLoginRequestObject struct {
	Body *BeginWebauthnLoginJSONRequestBody
}

type BeginWebauthnLoginResponseObject interface {
	VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error
}

type BeginWebauthnLogin200JSONResponse WebAuthnLoginBeginResponse

func (response BeginWebauthnLogin200JSONResponse) VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type BeginWebauthnLogin400Response struct {
}

func (response BeginWebauthnLogin400Response) VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type BeginWebauthnLogin404Response struct {
}

func (response BeginWebauthnLogin404Response) VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(404)
	return nil
}

type BeginWebauthnLogin409Response struct {
}

func (response BeginWebauthnLogin409Response) VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type BeginWebauthnLogin500Response struct {
}

func (response BeginWebauthnLogin500Response) VisitBeginWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type FinishWebauthnLoginRequestObject struct {
	Body *FinishWebauthnLoginJSONRequestBody
}

type FinishWebauthnLoginResponseObject interface {
	VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error
}

type FinishWebauthnLogin200ResponseHeaders struct {
	SetCookie string
}

type FinishWebauthnLogin200JSONResponse struct {
	Body    WebAuthnLoginFinishResponse
	Headers FinishWebauthnLogin200ResponseHeaders
}

func (response FinishWebauthnLogin200JSONResponse) VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.Header().Set("Set-Cookie", fmt.Sprint(response.Headers.SetCookie))
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response.Body)
}

type FinishWebauthnLogin400Response struct {
}

func (response FinishWebauthnLogin400Response) VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type FinishWebauthnLogin404Response struct {
}

func (response FinishWebauthnLogin404Response) VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(404)
	return nil
}

type FinishWebauthnLogin409Response struct {
}

func (response FinishWebauthnLogin409Response) VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type FinishWebauthnLogin500Response struct {
}

func (response FinishWebauthnLogin500Response) VisitFinishWebauthnLoginResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type BeginWebauthnRegistrationRequestObject struct {
	Body *BeginWebauthnRegistrationJSONRequestBody
}

type BeginWebauthnRegistrationResponseObject interface {
	VisitBeginWebauthnRegistrationResponse(w http.ResponseWriter) error
}

type BeginWebauthnRegistration200JSONResponse WebAuthnRegistrationBeginResponse

func (response BeginWebauthnRegistration200JSONResponse) VisitBeginWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type BeginWebauthnRegistration400Response struct {
}

func (response BeginWebauthnRegistration400Response) VisitBeginWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type BeginWebauthnRegistration409Response struct {
}

func (response BeginWebauthnRegistration409Response) VisitBeginWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type BeginWebauthnRegistration500Response struct {
}

func (response BeginWebauthnRegistration500Response) VisitBeginWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

type FinishWebauthnRegistrationRequestObject struct {
	Body *FinishWebauthnRegistrationJSONRequestBody
}

type FinishWebauthnRegistrationResponseObject interface {
	VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error
}

type FinishWebauthnRegistration200JSONResponse WebAuthnRegistrationFinishResponse

func (response FinishWebauthnRegistration200JSONResponse) VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type FinishWebauthnRegistration400Response struct {
}

func (response FinishWebauthnRegistration400Response) VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(400)
	return nil
}

type FinishWebauthnRegistration404Response struct {
}

func (response FinishWebauthnRegistration404Response) VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(404)
	return nil
}

type FinishWebauthnRegistration409Response struct {
}

func (response FinishWebauthnRegistration409Response) VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(409)
	return nil
}

type FinishWebauthnRegistration500Response struct {
}

func (response FinishWebauthnRegistration500Response) VisitFinishWebauthnRegistrationResponse(w http.ResponseWriter) error {
	w.WriteHeader(500)
	return nil
}

// StrictServerInterface represents all server handlers.
type StrictServerInterface interface {
	// List cached 3Commas bots
	// (GET /api/bots)
	ListBots(ctx context.Context, request ListBotsRequestObject) (ListBotsResponseObject, error)
	// List cached 3Commas deals
	// (GET /api/deals)
	ListDeals(ctx context.Context, request ListDealsRequestObject) (ListDealsResponseObject, error)
	// List acted-on bot events with Hyperliquid context
	// (GET /api/orders)
	ListOrders(ctx context.Context, request ListOrdersRequestObject) (ListOrdersResponseObject, error)
	// Cancel Hyperliquid order by metadata
	// (POST /api/orders/{metadata}/cancel)
	CancelOrderByMetadata(ctx context.Context, request CancelOrderByMetadataRequestObject) (CancelOrderByMetadataResponseObject, error)
	// Stream Hyperliquid best bid/offer quotes
	// (GET /sse/hyperliquid/prices)
	StreamHyperliquidPrices(ctx context.Context, request StreamHyperliquidPricesRequestObject) (StreamHyperliquidPricesResponseObject, error)
	// Stream live changes to acted-on orders
	// (GET /sse/orders)
	StreamOrders(ctx context.Context, request StreamOrdersRequestObject) (StreamOrdersResponseObject, error)
	// Retrieve encrypted vault payload
	// (GET /vault/payload)
	GetVaultPayload(ctx context.Context, request GetVaultPayloadRequestObject) (GetVaultPayloadResponseObject, error)
	// Reseal the vault and clear in-memory secrets
	// (POST /vault/seal)
	SealVault(ctx context.Context, request SealVaultRequestObject) (SealVaultResponseObject, error)
	// Store the encrypted vault payload
	// (POST /vault/setup)
	SetupVault(ctx context.Context, request SetupVaultRequestObject) (SetupVaultResponseObject, error)
	// Inspect vault state
	// (GET /vault/status)
	GetVaultStatus(ctx context.Context, request GetVaultStatusRequestObject) (GetVaultStatusResponseObject, error)
	// Provide decrypted secrets to unlock the vault
	// (POST /vault/unseal)
	UnsealVault(ctx context.Context, request UnsealVaultRequestObject) (UnsealVaultResponseObject, error)
	// Begin WebAuthn assertion
	// (POST /webauthn/login/begin)
	BeginWebauthnLogin(ctx context.Context, request BeginWebauthnLoginRequestObject) (BeginWebauthnLoginResponseObject, error)
	// Complete WebAuthn assertion
	// (POST /webauthn/login/finish)
	FinishWebauthnLogin(ctx context.Context, request FinishWebauthnLoginRequestObject) (FinishWebauthnLoginResponseObject, error)
	// Begin WebAuthn registration
	// (POST /webauthn/registration/begin)
	BeginWebauthnRegistration(ctx context.Context, request BeginWebauthnRegistrationRequestObject) (BeginWebauthnRegistrationResponseObject, error)
	// Complete WebAuthn registration
	// (POST /webauthn/registration/finish)
	FinishWebauthnRegistration(ctx context.Context, request FinishWebauthnRegistrationRequestObject) (FinishWebauthnRegistrationResponseObject, error)
}

type StrictHandlerFunc = strictnethttp.StrictHTTPHandlerFunc
type StrictMiddlewareFunc = strictnethttp.StrictHTTPMiddlewareFunc

type StrictHTTPServerOptions struct {
	RequestErrorHandlerFunc  func(w http.ResponseWriter, r *http.Request, err error)
	ResponseErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

func NewStrictHandler(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: StrictHTTPServerOptions{
		RequestErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		},
		ResponseErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusInternalServerError)
		},
	}}
}

func NewStrictHandlerWithOptions(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc, options StrictHTTPServerOptions) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: options}
}

type strictHandler struct {
	ssi         StrictServerInterface
	middlewares []StrictMiddlewareFunc
	options     StrictHTTPServerOptions
}

// ListBots operation middleware
func (sh *strictHandler) ListBots(w http.ResponseWriter, r *http.Request, params ListBotsParams) {
	var request ListBotsRequestObject

	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.ListBots(ctx, request.(ListBotsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListBots")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(ListBotsResponseObject); ok {
		if err := validResponse.VisitListBotsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// ListDeals operation middleware
func (sh *strictHandler) ListDeals(w http.ResponseWriter, r *http.Request, params ListDealsParams) {
	var request ListDealsRequestObject

	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.ListDeals(ctx, request.(ListDealsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListDeals")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(ListDealsResponseObject); ok {
		if err := validResponse.VisitListDealsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// ListOrders operation middleware
func (sh *strictHandler) ListOrders(w http.ResponseWriter, r *http.Request, params ListOrdersParams) {
	var request ListOrdersRequestObject

	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.ListOrders(ctx, request.(ListOrdersRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListOrders")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(ListOrdersResponseObject); ok {
		if err := validResponse.VisitListOrdersResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// CancelOrderByMetadata operation middleware
func (sh *strictHandler) CancelOrderByMetadata(w http.ResponseWriter, r *http.Request, metadata string) {
	var request CancelOrderByMetadataRequestObject

	request.Metadata = metadata

	var body CancelOrderByMetadataJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CancelOrderByMetadata(ctx, request.(CancelOrderByMetadataRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CancelOrderByMetadata")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CancelOrderByMetadataResponseObject); ok {
		if err := validResponse.VisitCancelOrderByMetadataResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// StreamHyperliquidPrices operation middleware
func (sh *strictHandler) StreamHyperliquidPrices(w http.ResponseWriter, r *http.Request, params StreamHyperliquidPricesParams) {
	var request StreamHyperliquidPricesRequestObject

	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.StreamHyperliquidPrices(ctx, request.(StreamHyperliquidPricesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "StreamHyperliquidPrices")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(StreamHyperliquidPricesResponseObject); ok {
		if err := validResponse.VisitStreamHyperliquidPricesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// StreamOrders operation middleware
func (sh *strictHandler) StreamOrders(w http.ResponseWriter, r *http.Request, params StreamOrdersParams) {
	var request StreamOrdersRequestObject

	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.StreamOrders(ctx, request.(StreamOrdersRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "StreamOrders")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(StreamOrdersResponseObject); ok {
		if err := validResponse.VisitStreamOrdersResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetVaultPayload operation middleware
func (sh *strictHandler) GetVaultPayload(w http.ResponseWriter, r *http.Request) {
	var request GetVaultPayloadRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetVaultPayload(ctx, request.(GetVaultPayloadRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetVaultPayload")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetVaultPayloadResponseObject); ok {
		if err := validResponse.VisitGetVaultPayloadResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// SealVault operation middleware
func (sh *strictHandler) SealVault(w http.ResponseWriter, r *http.Request) {
	var request SealVaultRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.SealVault(ctx, request.(SealVaultRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "SealVault")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(SealVaultResponseObject); ok {
		if err := validResponse.VisitSealVaultResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// SetupVault operation middleware
func (sh *strictHandler) SetupVault(w http.ResponseWriter, r *http.Request) {
	var request SetupVaultRequestObject

	var body SetupVaultJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.SetupVault(ctx, request.(SetupVaultRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "SetupVault")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(SetupVaultResponseObject); ok {
		if err := validResponse.VisitSetupVaultResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetVaultStatus operation middleware
func (sh *strictHandler) GetVaultStatus(w http.ResponseWriter, r *http.Request) {
	var request GetVaultStatusRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetVaultStatus(ctx, request.(GetVaultStatusRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetVaultStatus")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetVaultStatusResponseObject); ok {
		if err := validResponse.VisitGetVaultStatusResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UnsealVault operation middleware
func (sh *strictHandler) UnsealVault(w http.ResponseWriter, r *http.Request) {
	var request UnsealVaultRequestObject

	var body UnsealVaultJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UnsealVault(ctx, request.(UnsealVaultRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UnsealVault")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UnsealVaultResponseObject); ok {
		if err := validResponse.VisitUnsealVaultResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// BeginWebauthnLogin operation middleware
func (sh *strictHandler) BeginWebauthnLogin(w http.ResponseWriter, r *http.Request) {
	var request BeginWebauthnLoginRequestObject

	var body BeginWebauthnLoginJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.BeginWebauthnLogin(ctx, request.(BeginWebauthnLoginRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "BeginWebauthnLogin")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(BeginWebauthnLoginResponseObject); ok {
		if err := validResponse.VisitBeginWebauthnLoginResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// FinishWebauthnLogin operation middleware
func (sh *strictHandler) FinishWebauthnLogin(w http.ResponseWriter, r *http.Request) {
	var request FinishWebauthnLoginRequestObject

	var body FinishWebauthnLoginJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.FinishWebauthnLogin(ctx, request.(FinishWebauthnLoginRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "FinishWebauthnLogin")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(FinishWebauthnLoginResponseObject); ok {
		if err := validResponse.VisitFinishWebauthnLoginResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// BeginWebauthnRegistration operation middleware
func (sh *strictHandler) BeginWebauthnRegistration(w http.ResponseWriter, r *http.Request) {
	var request BeginWebauthnRegistrationRequestObject

	var body BeginWebauthnRegistrationJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.BeginWebauthnRegistration(ctx, request.(BeginWebauthnRegistrationRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "BeginWebauthnRegistration")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(BeginWebauthnRegistrationResponseObject); ok {
		if err := validResponse.VisitBeginWebauthnRegistrationResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// FinishWebauthnRegistration operation middleware
func (sh *strictHandler) FinishWebauthnRegistration(w http.ResponseWriter, r *http.Request) {
	var request FinishWebauthnRegistrationRequestObject

	var body FinishWebauthnRegistrationJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.FinishWebauthnRegistration(ctx, request.(FinishWebauthnRegistrationRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "FinishWebauthnRegistration")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(FinishWebauthnRegistrationResponseObject); ok {
		if err := validResponse.VisitFinishWebauthnRegistrationResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}
