// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: queries.sql

package sqlcgen

import (
	"context"
)

const appendHyperliquidModify = `-- name: AppendHyperliquidModify :exec
INSERT INTO hyperliquid_submissions (
    md,
    action_kind,
    create_payload,
    modify_payloads,
    cancel_payload,
    updated_at_utc,
    botevent_row_id
) VALUES (
    ?1,
    'modify',
    NULL,
    json_array(json(?2)),
    NULL,
    CAST(unixepoch('now','subsec') * 1000 AS INTEGER),
    ?3
)
ON CONFLICT(md) DO UPDATE SET
    modify_payloads = json_insert(
        COALESCE(hyperliquid_submissions.modify_payloads, CAST('[]' AS BLOB)),
        '$[#]',
        json(json_extract(excluded.modify_payloads, '$[0]'))
    ),
    action_kind    = 'modify',
    updated_at_utc = CAST(unixepoch('now','subsec') * 1000 AS INTEGER)
`

type AppendHyperliquidModifyParams struct {
	Md            string      `json:"md"`
	ModifyPayload interface{} `json:"modify_payload"`
	BoteventRowID int64       `json:"botevent_row_id"`
}

func (q *Queries) AppendHyperliquidModify(ctx context.Context, arg AppendHyperliquidModifyParams) error {
	_, err := q.db.ExecContext(ctx, appendHyperliquidModify, arg.Md, arg.ModifyPayload, arg.BoteventRowID)
	return err
}

const deleteVaultPayloadForUser = `-- name: DeleteVaultPayloadForUser :exec
DELETE FROM vault_payloads
WHERE user_id = ?1
`

func (q *Queries) DeleteVaultPayloadForUser(ctx context.Context, userID int64) error {
	_, err := q.db.ExecContext(ctx, deleteVaultPayloadForUser, userID)
	return err
}

const deleteVaultUserByID = `-- name: DeleteVaultUserByID :exec
DELETE FROM vault_users
WHERE id = ?1
`

func (q *Queries) DeleteVaultUserByID(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteVaultUserByID, id)
	return err
}

const deleteWebauthnCredentialByID = `-- name: DeleteWebauthnCredentialByID :exec
DELETE FROM webauthn_credentials
WHERE credential_id = ?1
`

func (q *Queries) DeleteWebauthnCredentialByID(ctx context.Context, credentialID []byte) error {
	_, err := q.db.ExecContext(ctx, deleteWebauthnCredentialByID, credentialID)
	return err
}

const ensureVaultUser = `-- name: EnsureVaultUser :one

INSERT INTO vault_users (
    username
) VALUES (
    ?1
)
ON CONFLICT(username) DO UPDATE SET
    username = excluded.username
RETURNING id, username, created_at_utc
`

// Vault management
func (q *Queries) EnsureVaultUser(ctx context.Context, username string) (VaultUser, error) {
	row := q.db.QueryRowContext(ctx, ensureVaultUser, username)
	var i VaultUser
	err := row.Scan(&i.ID, &i.Username, &i.CreatedAtUtc)
	return i, err
}

const fetchBot = `-- name: FetchBot :one
SELECT payload, last_synced_utc
FROM threecommas_bots
WHERE bot_id = ?1
`

type FetchBotRow struct {
	Payload       []byte `json:"payload"`
	LastSyncedUtc int64  `json:"last_synced_utc"`
}

func (q *Queries) FetchBot(ctx context.Context, botID int64) (FetchBotRow, error) {
	row := q.db.QueryRowContext(ctx, fetchBot, botID)
	var i FetchBotRow
	err := row.Scan(&i.Payload, &i.LastSyncedUtc)
	return i, err
}

const fetchDeal = `-- name: FetchDeal :one
SELECT payload
FROM threecommas_deals
WHERE deal_id = ?1
`

func (q *Queries) FetchDeal(ctx context.Context, dealID int64) ([]byte, error) {
	row := q.db.QueryRowContext(ctx, fetchDeal, dealID)
	var payload []byte
	err := row.Scan(&payload)
	return payload, err
}

const fetchHyperliquidSubmission = `-- name: FetchHyperliquidSubmission :one
SELECT
    action_kind,
    CAST(create_payload AS BLOB)  AS create_payload,
    CAST(modify_payloads AS BLOB) AS modify_payloads,
    CAST(cancel_payload AS BLOB)  AS cancel_payload
FROM hyperliquid_submissions
WHERE md = ?1
`

type FetchHyperliquidSubmissionRow struct {
	ActionKind     string `json:"action_kind"`
	CreatePayload  []byte `json:"create_payload"`
	ModifyPayloads []byte `json:"modify_payloads"`
	CancelPayload  []byte `json:"cancel_payload"`
}

func (q *Queries) FetchHyperliquidSubmission(ctx context.Context, md string) (FetchHyperliquidSubmissionRow, error) {
	row := q.db.QueryRowContext(ctx, fetchHyperliquidSubmission, md)
	var i FetchHyperliquidSubmissionRow
	err := row.Scan(
		&i.ActionKind,
		&i.CreatePayload,
		&i.ModifyPayloads,
		&i.CancelPayload,
	)
	return i, err
}

const fetchLatestHyperliquidStatus = `-- name: FetchLatestHyperliquidStatus :one
SELECT status
FROM hyperliquid_status_history
WHERE md = ?1
ORDER BY recorded_at_utc DESC, id DESC
LIMIT 1
`

func (q *Queries) FetchLatestHyperliquidStatus(ctx context.Context, md string) ([]byte, error) {
	row := q.db.QueryRowContext(ctx, fetchLatestHyperliquidStatus, md)
	var status []byte
	err := row.Scan(&status)
	return status, err
}

const fetchThreeCommasBotEvent = `-- name: FetchThreeCommasBotEvent :one
SELECT payload
FROM threecommas_botevents
WHERE md = ?1
ORDER BY observed_at_utc DESC, id DESC
LIMIT 1
`

func (q *Queries) FetchThreeCommasBotEvent(ctx context.Context, md string) ([]byte, error) {
	row := q.db.QueryRowContext(ctx, fetchThreeCommasBotEvent, md)
	var payload []byte
	err := row.Scan(&payload)
	return payload, err
}

const getMetadataForDeal = `-- name: GetMetadataForDeal :many
SELECT DISTINCT md
    FROM threecommas_botevents
    WHERE deal_id = ?
`

func (q *Queries) GetMetadataForDeal(ctx context.Context, dealID int64) ([]string, error) {
	rows, err := q.db.QueryContext(ctx, getMetadataForDeal, dealID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []string
	for rows.Next() {
		var md string
		if err := rows.Scan(&md); err != nil {
			return nil, err
		}
		items = append(items, md)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getTPForDeal = `-- name: GetTPForDeal :one
SELECT md,
       botevent_id,
       created_at_utc,
       payload
FROM threecommas_botevents
WHERE deal_id = ?1
  AND json_extract(payload, '$.OrderType') = 'Take Profit'
ORDER BY created_at_utc DESC
LIMIT 1
`

type GetTPForDealRow struct {
	Md           string `json:"md"`
	BoteventID   int64  `json:"botevent_id"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	Payload      []byte `json:"payload"`
}

func (q *Queries) GetTPForDeal(ctx context.Context, dealID int64) (GetTPForDealRow, error) {
	row := q.db.QueryRowContext(ctx, getTPForDeal, dealID)
	var i GetTPForDealRow
	err := row.Scan(
		&i.Md,
		&i.BoteventID,
		&i.CreatedAtUtc,
		&i.Payload,
	)
	return i, err
}

const getVaultPayloadForUser = `-- name: GetVaultPayloadForUser :one
SELECT
    id,
    user_id,
    version,
    ciphertext,
    nonce,
    associated_data,
    CAST(prf_params AS BLOB) AS prf_params,
    updated_at_utc
FROM vault_payloads
WHERE user_id = ?1
`

type GetVaultPayloadForUserRow struct {
	ID             int64  `json:"id"`
	UserID         int64  `json:"user_id"`
	Version        string `json:"version"`
	Ciphertext     []byte `json:"ciphertext"`
	Nonce          []byte `json:"nonce"`
	AssociatedData []byte `json:"associated_data"`
	PrfParams      []byte `json:"prf_params"`
	UpdatedAtUtc   int64  `json:"updated_at_utc"`
}

func (q *Queries) GetVaultPayloadForUser(ctx context.Context, userID int64) (GetVaultPayloadForUserRow, error) {
	row := q.db.QueryRowContext(ctx, getVaultPayloadForUser, userID)
	var i GetVaultPayloadForUserRow
	err := row.Scan(
		&i.ID,
		&i.UserID,
		&i.Version,
		&i.Ciphertext,
		&i.Nonce,
		&i.AssociatedData,
		&i.PrfParams,
		&i.UpdatedAtUtc,
	)
	return i, err
}

const getVaultUser = `-- name: GetVaultUser :one
SELECT id, username, created_at_utc
FROM vault_users
ORDER BY id ASC
LIMIT 1
`

func (q *Queries) GetVaultUser(ctx context.Context) (VaultUser, error) {
	row := q.db.QueryRowContext(ctx, getVaultUser)
	var i VaultUser
	err := row.Scan(&i.ID, &i.Username, &i.CreatedAtUtc)
	return i, err
}

const getVaultUserByID = `-- name: GetVaultUserByID :one
SELECT id, username, created_at_utc
FROM vault_users
WHERE id = ?1
LIMIT 1
`

func (q *Queries) GetVaultUserByID(ctx context.Context, id int64) (VaultUser, error) {
	row := q.db.QueryRowContext(ctx, getVaultUserByID, id)
	var i VaultUser
	err := row.Scan(&i.ID, &i.Username, &i.CreatedAtUtc)
	return i, err
}

const getVaultUserByUsername = `-- name: GetVaultUserByUsername :one
SELECT id, username, created_at_utc
FROM vault_users
WHERE username = ?1
LIMIT 1
`

func (q *Queries) GetVaultUserByUsername(ctx context.Context, username string) (VaultUser, error) {
	row := q.db.QueryRowContext(ctx, getVaultUserByUsername, username)
	var i VaultUser
	err := row.Scan(&i.ID, &i.Username, &i.CreatedAtUtc)
	return i, err
}

const getWebauthnCredentialByID = `-- name: GetWebauthnCredentialByID :one
SELECT
    id,
    user_id,
    credential_id,
    CAST(credential AS BLOB) AS credential,
    created_at_utc,
    updated_at_utc
FROM webauthn_credentials
WHERE credential_id = ?1
`

type GetWebauthnCredentialByIDRow struct {
	ID           int64  `json:"id"`
	UserID       int64  `json:"user_id"`
	CredentialID []byte `json:"credential_id"`
	Credential   []byte `json:"credential"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	UpdatedAtUtc int64  `json:"updated_at_utc"`
}

func (q *Queries) GetWebauthnCredentialByID(ctx context.Context, credentialID []byte) (GetWebauthnCredentialByIDRow, error) {
	row := q.db.QueryRowContext(ctx, getWebauthnCredentialByID, credentialID)
	var i GetWebauthnCredentialByIDRow
	err := row.Scan(
		&i.ID,
		&i.UserID,
		&i.CredentialID,
		&i.Credential,
		&i.CreatedAtUtc,
		&i.UpdatedAtUtc,
	)
	return i, err
}

const hasThreeCommasMetadata = `-- name: HasThreeCommasMetadata :one
SELECT EXISTS(
    SELECT 1 FROM threecommas_botevents WHERE md = ?1
)
`

func (q *Queries) HasThreeCommasMetadata(ctx context.Context, md string) (int64, error) {
	row := q.db.QueryRowContext(ctx, hasThreeCommasMetadata, md)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const insertHyperliquidStatus = `-- name: InsertHyperliquidStatus :exec
INSERT INTO hyperliquid_status_history (
    md,
    status,
    recorded_at_utc
) VALUES (
    ?1,
    ?2,
    ?3
)
`

type InsertHyperliquidStatusParams struct {
	Md            string `json:"md"`
	Status        []byte `json:"status"`
	RecordedAtUtc int64  `json:"recorded_at_utc"`
}

func (q *Queries) InsertHyperliquidStatus(ctx context.Context, arg InsertHyperliquidStatusParams) error {
	_, err := q.db.ExecContext(ctx, insertHyperliquidStatus, arg.Md, arg.Status, arg.RecordedAtUtc)
	return err
}

const insertThreeCommasBotEvent = `-- name: InsertThreeCommasBotEvent :one
INSERT INTO threecommas_botevents (
    md,
    bot_id,
    deal_id,
    botevent_id,
    created_at_utc,
    payload
) VALUES (
    ?1,
    ?2,
    ?3,
    ?4,
    ?5,
    ?6
)
ON CONFLICT(md, botevent_id, created_at_utc) DO NOTHING
RETURNING id
`

type InsertThreeCommasBotEventParams struct {
	Md           string `json:"md"`
	BotID        int64  `json:"bot_id"`
	DealID       int64  `json:"deal_id"`
	BoteventID   int64  `json:"botevent_id"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	Payload      []byte `json:"payload"`
}

func (q *Queries) InsertThreeCommasBotEvent(ctx context.Context, arg InsertThreeCommasBotEventParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, insertThreeCommasBotEvent,
		arg.Md,
		arg.BotID,
		arg.DealID,
		arg.BoteventID,
		arg.CreatedAtUtc,
		arg.Payload,
	)
	var id int64
	err := row.Scan(&id)
	return id, err
}

const insertThreeCommasBotEventLog = `-- name: InsertThreeCommasBotEventLog :one
INSERT INTO threecommas_botevents_log (
    md,
    bot_id,
    deal_id,
    botevent_id,
    created_at_utc,
    payload
) VALUES (
    ?1,
    ?2,
    ?3,
    ?4,
    ?5,
    ?6
)
ON CONFLICT(md, botevent_id, created_at_utc) DO NOTHING
RETURNING id
`

type InsertThreeCommasBotEventLogParams struct {
	Md           string `json:"md"`
	BotID        int64  `json:"bot_id"`
	DealID       int64  `json:"deal_id"`
	BoteventID   int64  `json:"botevent_id"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	Payload      []byte `json:"payload"`
}

func (q *Queries) InsertThreeCommasBotEventLog(ctx context.Context, arg InsertThreeCommasBotEventLogParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, insertThreeCommasBotEventLog,
		arg.Md,
		arg.BotID,
		arg.DealID,
		arg.BoteventID,
		arg.CreatedAtUtc,
		arg.Payload,
	)
	var id int64
	err := row.Scan(&id)
	return id, err
}

const listDealIDs = `-- name: ListDealIDs :many
select deal_id from threecommas_deals
`

func (q *Queries) ListDealIDs(ctx context.Context) ([]int64, error) {
	rows, err := q.db.QueryContext(ctx, listDealIDs)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []int64
	for rows.Next() {
		var deal_id int64
		if err := rows.Scan(&deal_id); err != nil {
			return nil, err
		}
		items = append(items, deal_id)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listHyperliquidStatuses = `-- name: ListHyperliquidStatuses :many
SELECT status, recorded_at_utc
FROM hyperliquid_status_history
WHERE md = ?1
ORDER BY recorded_at_utc ASC, id ASC
`

type ListHyperliquidStatusesRow struct {
	Status        []byte `json:"status"`
	RecordedAtUtc int64  `json:"recorded_at_utc"`
}

func (q *Queries) ListHyperliquidStatuses(ctx context.Context, md string) ([]ListHyperliquidStatusesRow, error) {
	rows, err := q.db.QueryContext(ctx, listHyperliquidStatuses, md)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListHyperliquidStatusesRow
	for rows.Next() {
		var i ListHyperliquidStatusesRow
		if err := rows.Scan(&i.Status, &i.RecordedAtUtc); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listHyperliquidStatusesForMetadata = `-- name: ListHyperliquidStatusesForMetadata :many
SELECT
    id,
    status,
    recorded_at_utc
FROM hyperliquid_status_history
WHERE md = ?1
  AND recorded_at_utc >= COALESCE(?2, recorded_at_utc)
  AND recorded_at_utc <= COALESCE(?3, recorded_at_utc)
ORDER BY recorded_at_utc ASC, id ASC
`

type ListHyperliquidStatusesForMetadataParams struct {
	Metadata     string `json:"metadata"`
	ObservedFrom int64  `json:"observed_from"`
	ObservedTo   int64  `json:"observed_to"`
}

type ListHyperliquidStatusesForMetadataRow struct {
	ID            int64  `json:"id"`
	Status        []byte `json:"status"`
	RecordedAtUtc int64  `json:"recorded_at_utc"`
}

func (q *Queries) ListHyperliquidStatusesForMetadata(ctx context.Context, arg ListHyperliquidStatusesForMetadataParams) ([]ListHyperliquidStatusesForMetadataRow, error) {
	rows, err := q.db.QueryContext(ctx, listHyperliquidStatusesForMetadata, arg.Metadata, arg.ObservedFrom, arg.ObservedTo)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListHyperliquidStatusesForMetadataRow
	for rows.Next() {
		var i ListHyperliquidStatusesForMetadataRow
		if err := rows.Scan(&i.ID, &i.Status, &i.RecordedAtUtc); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listHyperliquidSubmissionsByMetadata = `-- name: ListHyperliquidSubmissionsByMetadata :many
SELECT
    md,
    action_kind,
    CAST(create_payload AS BLOB)  AS create_payload,
    CAST(modify_payloads AS BLOB) AS modify_payloads,
    CAST(cancel_payload AS BLOB)  AS cancel_payload,
    updated_at_utc,
    botevent_row_id
FROM hyperliquid_submissions
WHERE md IN (
    SELECT value FROM json_each(sqlc.arg(metadata_list))
)
`

type ListHyperliquidSubmissionsByMetadataRow struct {
	Md             string `json:"md"`
	ActionKind     string `json:"action_kind"`
	CreatePayload  []byte `json:"create_payload"`
	ModifyPayloads []byte `json:"modify_payloads"`
	CancelPayload  []byte `json:"cancel_payload"`
	UpdatedAtUtc   int64  `json:"updated_at_utc"`
	BoteventRowID  int64  `json:"botevent_row_id"`
}

func (q *Queries) ListHyperliquidSubmissionsByMetadata(ctx context.Context) ([]ListHyperliquidSubmissionsByMetadataRow, error) {
	rows, err := q.db.QueryContext(ctx, listHyperliquidSubmissionsByMetadata)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListHyperliquidSubmissionsByMetadataRow
	for rows.Next() {
		var i ListHyperliquidSubmissionsByMetadataRow
		if err := rows.Scan(
			&i.Md,
			&i.ActionKind,
			&i.CreatePayload,
			&i.ModifyPayloads,
			&i.CancelPayload,
			&i.UpdatedAtUtc,
			&i.BoteventRowID,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listLatestHyperliquidSafetyStatuses = `-- name: ListLatestHyperliquidSafetyStatuses :many
WITH latest_status AS (
    SELECT md, id
    FROM (
        SELECT
            md,
            id,
            ROW_NUMBER() OVER (
                PARTITION BY md
                ORDER BY recorded_at_utc DESC, id DESC
            ) AS rn
        FROM hyperliquid_status_history
    )
    WHERE rn = 1
)
SELECT
    b.md AS md,
    b.bot_id AS bot_id,
    b.deal_id AS deal_id,
    CAST(json_extract(b.payload, '$.OrderType') AS TEXT)        AS order_type,
    CAST(json_extract(b.payload, '$.OrderPosition') AS INTEGER) AS order_position,
    CAST(json_extract(b.payload, '$.OrderSize') AS INTEGER)        AS order_size,
    CAST(json_extract(h.status, '$.status') AS TEXT)            AS hl_status,
    CAST(json_extract(h.status, '$.statusTimestamp') AS INTEGER) AS hl_status_timestamp,
    h.recorded_at_utc AS recorded_at_utc
FROM latest_status AS latest
JOIN hyperliquid_status_history AS h
  ON h.id = latest.id
JOIN threecommas_botevents AS b
  ON b.md = latest.md
WHERE b.deal_id = ?1
  AND CAST(json_extract(b.payload, '$.OrderType') AS TEXT) = 'Safety'
ORDER BY order_position ASC
`

type ListLatestHyperliquidSafetyStatusesRow struct {
	Md                string `json:"md"`
	BotID             int64  `json:"bot_id"`
	DealID            int64  `json:"deal_id"`
	OrderType         string `json:"order_type"`
	OrderPosition     int64  `json:"order_position"`
	OrderSize         int64  `json:"order_size"`
	HlStatus          string `json:"hl_status"`
	HlStatusTimestamp int64  `json:"hl_status_timestamp"`
	RecordedAtUtc     int64  `json:"recorded_at_utc"`
}

func (q *Queries) ListLatestHyperliquidSafetyStatuses(ctx context.Context, dealID int64) ([]ListLatestHyperliquidSafetyStatusesRow, error) {
	rows, err := q.db.QueryContext(ctx, listLatestHyperliquidSafetyStatuses, dealID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListLatestHyperliquidSafetyStatusesRow
	for rows.Next() {
		var i ListLatestHyperliquidSafetyStatusesRow
		if err := rows.Scan(
			&i.Md,
			&i.BotID,
			&i.DealID,
			&i.OrderType,
			&i.OrderPosition,
			&i.OrderSize,
			&i.HlStatus,
			&i.HlStatusTimestamp,
			&i.RecordedAtUtc,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasBotEventLogs = `-- name: ListThreeCommasBotEventLogs :many
SELECT
    id,
    md,
    bot_id,
    deal_id,
    botevent_id,
    created_at_utc,
    observed_at_utc,
    payload
FROM threecommas_botevents_log
ORDER BY created_at_utc ASC, id ASC
`

func (q *Queries) ListThreeCommasBotEventLogs(ctx context.Context) ([]ThreecommasBoteventsLog, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasBotEventLogs)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ThreecommasBoteventsLog
	for rows.Next() {
		var i ThreecommasBoteventsLog
		if err := rows.Scan(
			&i.ID,
			&i.Md,
			&i.BotID,
			&i.DealID,
			&i.BoteventID,
			&i.CreatedAtUtc,
			&i.ObservedAtUtc,
			&i.Payload,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasBotEventLogsForMetadata = `-- name: ListThreeCommasBotEventLogsForMetadata :many
SELECT
    id,
    md,
    bot_id,
    deal_id,
    botevent_id,
    created_at_utc,
    observed_at_utc,
    payload
FROM threecommas_botevents_log
WHERE md = ?1
  AND observed_at_utc >= COALESCE(?2, observed_at_utc)
  AND observed_at_utc <= COALESCE(?3, observed_at_utc)
ORDER BY observed_at_utc ASC, id ASC
`

type ListThreeCommasBotEventLogsForMetadataParams struct {
	Metadata     string `json:"metadata"`
	ObservedFrom int64  `json:"observed_from"`
	ObservedTo   int64  `json:"observed_to"`
}

func (q *Queries) ListThreeCommasBotEventLogsForMetadata(ctx context.Context, arg ListThreeCommasBotEventLogsForMetadataParams) ([]ThreecommasBoteventsLog, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasBotEventLogsForMetadata, arg.Metadata, arg.ObservedFrom, arg.ObservedTo)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ThreecommasBoteventsLog
	for rows.Next() {
		var i ThreecommasBoteventsLog
		if err := rows.Scan(
			&i.ID,
			&i.Md,
			&i.BotID,
			&i.DealID,
			&i.BoteventID,
			&i.CreatedAtUtc,
			&i.ObservedAtUtc,
			&i.Payload,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasBotEvents = `-- name: ListThreeCommasBotEvents :many
SELECT
    id,
    md,
    bot_id,
    deal_id,
    botevent_id,
    created_at_utc,
    observed_at_utc,
    payload
FROM threecommas_botevents
WHERE bot_id = COALESCE(?1, bot_id)
  AND deal_id = COALESCE(?2, deal_id)
  AND botevent_id = COALESCE(?3, botevent_id)
  AND observed_at_utc >= COALESCE(?4, observed_at_utc)
  AND observed_at_utc <= COALESCE(?5, observed_at_utc)
  AND (
        ?6 IS NULL
        OR LOWER(md) LIKE LOWER(?6) || '%'
      )
  AND (
        ?7 IS NULL
        OR observed_at_utc < ?7
        OR (
            observed_at_utc = ?7
            AND id < ?8
        )
      )
ORDER BY observed_at_utc DESC, id DESC
LIMIT ?9
`

type ListThreeCommasBotEventsParams struct {
	BotID            int64       `json:"bot_id"`
	DealID           int64       `json:"deal_id"`
	BotEventID       int64       `json:"bot_event_id"`
	ObservedFrom     int64       `json:"observed_from"`
	ObservedTo       int64       `json:"observed_to"`
	MetadataPrefix   interface{} `json:"metadata_prefix"`
	CursorObservedAt interface{} `json:"cursor_observed_at"`
	CursorID         int64       `json:"cursor_id"`
	Limit            int64       `json:"limit"`
}

func (q *Queries) ListThreeCommasBotEvents(ctx context.Context, arg ListThreeCommasBotEventsParams) ([]ThreecommasBotevent, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasBotEvents,
		arg.BotID,
		arg.DealID,
		arg.BotEventID,
		arg.ObservedFrom,
		arg.ObservedTo,
		arg.MetadataPrefix,
		arg.CursorObservedAt,
		arg.CursorID,
		arg.Limit,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ThreecommasBotevent
	for rows.Next() {
		var i ThreecommasBotevent
		if err := rows.Scan(
			&i.ID,
			&i.Md,
			&i.BotID,
			&i.DealID,
			&i.BoteventID,
			&i.CreatedAtUtc,
			&i.ObservedAtUtc,
			&i.Payload,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasBotEventsForOrder = `-- name: ListThreeCommasBotEventsForOrder :many
SELECT id, payload
FROM threecommas_botevents
WHERE bot_id = ?1
  AND deal_id = ?2
  AND botevent_id = ?3
ORDER BY created_at_utc ASC, observed_at_utc ASC, id ASC
`

type ListThreeCommasBotEventsForOrderParams struct {
	BotID      int64 `json:"bot_id"`
	DealID     int64 `json:"deal_id"`
	BoteventID int64 `json:"botevent_id"`
}

type ListThreeCommasBotEventsForOrderRow struct {
	ID      int64  `json:"id"`
	Payload []byte `json:"payload"`
}

func (q *Queries) ListThreeCommasBotEventsForOrder(ctx context.Context, arg ListThreeCommasBotEventsForOrderParams) ([]ListThreeCommasBotEventsForOrderRow, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasBotEventsForOrder, arg.BotID, arg.DealID, arg.BoteventID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListThreeCommasBotEventsForOrderRow
	for rows.Next() {
		var i ListThreeCommasBotEventsForOrderRow
		if err := rows.Scan(&i.ID, &i.Payload); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasBots = `-- name: ListThreeCommasBots :many

SELECT
    bot_id,
    payload,
    last_synced_utc
FROM threecommas_bots
WHERE bot_id = COALESCE(?1, bot_id)
  AND last_synced_utc >= COALESCE(?2, last_synced_utc)
  AND last_synced_utc <= COALESCE(?3, last_synced_utc)
  AND (
        ?4 IS NULL
        OR last_synced_utc < ?4
        OR (
            last_synced_utc = ?4
            AND bot_id < ?5
        )
      )
ORDER BY last_synced_utc DESC, bot_id DESC
LIMIT ?6
`

type ListThreeCommasBotsParams struct {
	BotID            int64       `json:"bot_id"`
	UpdatedFrom      int64       `json:"updated_from"`
	UpdatedTo        int64       `json:"updated_to"`
	CursorLastSynced interface{} `json:"cursor_last_synced"`
	CursorBotID      int64       `json:"cursor_bot_id"`
	Limit            int64       `json:"limit"`
}

// API specific
func (q *Queries) ListThreeCommasBots(ctx context.Context, arg ListThreeCommasBotsParams) ([]ThreecommasBot, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasBots,
		arg.BotID,
		arg.UpdatedFrom,
		arg.UpdatedTo,
		arg.CursorLastSynced,
		arg.CursorBotID,
		arg.Limit,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ThreecommasBot
	for rows.Next() {
		var i ThreecommasBot
		if err := rows.Scan(&i.BotID, &i.Payload, &i.LastSyncedUtc); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThreeCommasDeals = `-- name: ListThreeCommasDeals :many
SELECT
    deal_id,
    bot_id,
    created_at_utc,
    updated_at_utc,
    payload
FROM threecommas_deals
WHERE deal_id = COALESCE(?1, deal_id)
  AND bot_id = COALESCE(?2, bot_id)
  AND updated_at_utc >= COALESCE(?3, updated_at_utc)
  AND updated_at_utc <= COALESCE(?4, updated_at_utc)
  AND (
        ?5 IS NULL
        OR updated_at_utc < ?5
        OR (
            updated_at_utc = ?5
            AND deal_id < ?6
        )
      )
ORDER BY updated_at_utc DESC, deal_id DESC
LIMIT ?7
`

type ListThreeCommasDealsParams struct {
	DealID          int64       `json:"deal_id"`
	BotID           int64       `json:"bot_id"`
	UpdatedFrom     int64       `json:"updated_from"`
	UpdatedTo       int64       `json:"updated_to"`
	CursorUpdatedAt interface{} `json:"cursor_updated_at"`
	CursorDealID    int64       `json:"cursor_deal_id"`
	Limit           int64       `json:"limit"`
}

type ListThreeCommasDealsRow struct {
	DealID       int64  `json:"deal_id"`
	BotID        int64  `json:"bot_id"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	UpdatedAtUtc int64  `json:"updated_at_utc"`
	Payload      []byte `json:"payload"`
}

func (q *Queries) ListThreeCommasDeals(ctx context.Context, arg ListThreeCommasDealsParams) ([]ListThreeCommasDealsRow, error) {
	rows, err := q.db.QueryContext(ctx, listThreeCommasDeals,
		arg.DealID,
		arg.BotID,
		arg.UpdatedFrom,
		arg.UpdatedTo,
		arg.CursorUpdatedAt,
		arg.CursorDealID,
		arg.Limit,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListThreeCommasDealsRow
	for rows.Next() {
		var i ListThreeCommasDealsRow
		if err := rows.Scan(
			&i.DealID,
			&i.BotID,
			&i.CreatedAtUtc,
			&i.UpdatedAtUtc,
			&i.Payload,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listWebauthnCredentialsByUser = `-- name: ListWebauthnCredentialsByUser :many
SELECT
    id,
    user_id,
    credential_id,
    CAST(credential AS BLOB) AS credential,
    created_at_utc,
    updated_at_utc
FROM webauthn_credentials
WHERE user_id = ?1
ORDER BY id ASC
`

type ListWebauthnCredentialsByUserRow struct {
	ID           int64  `json:"id"`
	UserID       int64  `json:"user_id"`
	CredentialID []byte `json:"credential_id"`
	Credential   []byte `json:"credential"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	UpdatedAtUtc int64  `json:"updated_at_utc"`
}

func (q *Queries) ListWebauthnCredentialsByUser(ctx context.Context, userID int64) ([]ListWebauthnCredentialsByUserRow, error) {
	rows, err := q.db.QueryContext(ctx, listWebauthnCredentialsByUser, userID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListWebauthnCredentialsByUserRow
	for rows.Next() {
		var i ListWebauthnCredentialsByUserRow
		if err := rows.Scan(
			&i.ID,
			&i.UserID,
			&i.CredentialID,
			&i.Credential,
			&i.CreatedAtUtc,
			&i.UpdatedAtUtc,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateBotSync = `-- name: UpdateBotSync :exec
UPDATE threecommas_bots
SET last_synced_utc = ?1
WHERE bot_id = ?2
`

type UpdateBotSyncParams struct {
	LastSyncedUtc int64 `json:"last_synced_utc"`
	BotID         int64 `json:"bot_id"`
}

func (q *Queries) UpdateBotSync(ctx context.Context, arg UpdateBotSyncParams) error {
	_, err := q.db.ExecContext(ctx, updateBotSync, arg.LastSyncedUtc, arg.BotID)
	return err
}

const upsertBot = `-- name: UpsertBot :exec
INSERT INTO threecommas_bots (
    bot_id,
    payload,
    last_synced_utc
) VALUES (
    ?1,
    ?2,
    ?3
)
ON CONFLICT(bot_id) DO UPDATE SET
    payload = excluded.payload,
    last_synced_utc = excluded.last_synced_utc
`

type UpsertBotParams struct {
	BotID         int64  `json:"bot_id"`
	Payload       []byte `json:"payload"`
	LastSyncedUtc int64  `json:"last_synced_utc"`
}

func (q *Queries) UpsertBot(ctx context.Context, arg UpsertBotParams) error {
	_, err := q.db.ExecContext(ctx, upsertBot, arg.BotID, arg.Payload, arg.LastSyncedUtc)
	return err
}

const upsertDeal = `-- name: UpsertDeal :exec
INSERT INTO threecommas_deals (
    deal_id,
    bot_id,
    created_at_utc,
    updated_at_utc,
    payload
) VALUES (
    ?1,
    ?2,
    ?3,
    ?4,
    ?5
)
ON CONFLICT(deal_id) DO UPDATE SET
    bot_id         = excluded.bot_id,
    created_at_utc = excluded.created_at_utc,
    updated_at_utc = excluded.updated_at_utc,
    payload        = excluded.payload
`

type UpsertDealParams struct {
	DealID       int64  `json:"deal_id"`
	BotID        int64  `json:"bot_id"`
	CreatedAtUtc int64  `json:"created_at_utc"`
	UpdatedAtUtc int64  `json:"updated_at_utc"`
	Payload      []byte `json:"payload"`
}

func (q *Queries) UpsertDeal(ctx context.Context, arg UpsertDealParams) error {
	_, err := q.db.ExecContext(ctx, upsertDeal,
		arg.DealID,
		arg.BotID,
		arg.CreatedAtUtc,
		arg.UpdatedAtUtc,
		arg.Payload,
	)
	return err
}

const upsertHyperliquidCancel = `-- name: UpsertHyperliquidCancel :exec
INSERT INTO hyperliquid_submissions (
    md,
    action_kind,
    create_payload,
    modify_payloads,
    cancel_payload,
    updated_at_utc,
    botevent_row_id
) VALUES (
    ?1,
    'cancel',
    NULL,
    '[]',
    json(?2),
    CAST(unixepoch('now','subsec') * 1000 AS INTEGER),
    ?3
)
ON CONFLICT(md) DO UPDATE SET
    cancel_payload = excluded.cancel_payload,
    action_kind    = 'cancel',
    updated_at_utc = CAST(unixepoch('now','subsec') * 1000 AS INTEGER)
`

type UpsertHyperliquidCancelParams struct {
	Md            string      `json:"md"`
	CancelPayload interface{} `json:"cancel_payload"`
	BoteventRowID int64       `json:"botevent_row_id"`
}

func (q *Queries) UpsertHyperliquidCancel(ctx context.Context, arg UpsertHyperliquidCancelParams) error {
	_, err := q.db.ExecContext(ctx, upsertHyperliquidCancel, arg.Md, arg.CancelPayload, arg.BoteventRowID)
	return err
}

const upsertHyperliquidCreate = `-- name: UpsertHyperliquidCreate :exec
INSERT INTO hyperliquid_submissions (
    md,
    action_kind,
    create_payload,
    modify_payloads,
    cancel_payload,
    updated_at_utc,
    botevent_row_id
) VALUES (
    ?1,
    'create',
    json(?2),
    CAST('[]' AS BLOB),
    NULL,
    CAST(unixepoch('now','subsec') * 1000 AS INTEGER),
    ?3
)
ON CONFLICT(md) DO UPDATE SET
    create_payload = excluded.create_payload,
    action_kind    = 'create',
    updated_at_utc = CAST(unixepoch('now','subsec') * 1000 AS INTEGER)
`

type UpsertHyperliquidCreateParams struct {
	Md            string      `json:"md"`
	CreatePayload interface{} `json:"create_payload"`
	BoteventRowID int64       `json:"botevent_row_id"`
}

func (q *Queries) UpsertHyperliquidCreate(ctx context.Context, arg UpsertHyperliquidCreateParams) error {
	_, err := q.db.ExecContext(ctx, upsertHyperliquidCreate, arg.Md, arg.CreatePayload, arg.BoteventRowID)
	return err
}

const upsertVaultPayload = `-- name: UpsertVaultPayload :exec
INSERT INTO vault_payloads (
    user_id,
    version,
    ciphertext,
    nonce,
    associated_data,
    prf_params,
    updated_at_utc
) VALUES (
    ?1,
    ?2,
    ?3,
    ?4,
    ?5,
    json(?6),
    ?7
)
ON CONFLICT(user_id) DO UPDATE SET
    version = excluded.version,
    ciphertext = excluded.ciphertext,
    nonce = excluded.nonce,
    associated_data = excluded.associated_data,
    prf_params = excluded.prf_params,
    updated_at_utc = excluded.updated_at_utc
`

type UpsertVaultPayloadParams struct {
	UserID         int64       `json:"user_id"`
	Version        string      `json:"version"`
	Ciphertext     []byte      `json:"ciphertext"`
	Nonce          []byte      `json:"nonce"`
	AssociatedData []byte      `json:"associated_data"`
	PrfParams      interface{} `json:"prf_params"`
	UpdatedAtUtc   int64       `json:"updated_at_utc"`
}

func (q *Queries) UpsertVaultPayload(ctx context.Context, arg UpsertVaultPayloadParams) error {
	_, err := q.db.ExecContext(ctx, upsertVaultPayload,
		arg.UserID,
		arg.Version,
		arg.Ciphertext,
		arg.Nonce,
		arg.AssociatedData,
		arg.PrfParams,
		arg.UpdatedAtUtc,
	)
	return err
}

const upsertWebauthnCredential = `-- name: UpsertWebauthnCredential :exec

INSERT INTO webauthn_credentials (
    user_id,
    credential_id,
    credential
) VALUES (
    ?1,
    ?2,
    json(?3)
)
ON CONFLICT(credential_id) DO UPDATE SET
    user_id = excluded.user_id,
    credential = excluded.credential,
    updated_at_utc = CAST(unixepoch('now','subsec') * 1000 AS INTEGER)
`

type UpsertWebauthnCredentialParams struct {
	UserID       int64       `json:"user_id"`
	CredentialID []byte      `json:"credential_id"`
	Credential   interface{} `json:"credential"`
}

// WebAuthn credential management
func (q *Queries) UpsertWebauthnCredential(ctx context.Context, arg UpsertWebauthnCredentialParams) error {
	_, err := q.db.ExecContext(ctx, upsertWebauthnCredential, arg.UserID, arg.CredentialID, arg.Credential)
	return err
}
