/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
    "/webauthn/registration/begin": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Begin WebAuthn registration
         * @description Issues a WebAuthn credential creation challenge for the supplied username. Clients must pass the returned options to `navigator.credentials.create` and later submit the authenticator response to `/webauthn/registration/finish`.
         */
        post: operations["beginWebauthnRegistration"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/webauthn/registration/finish": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Complete WebAuthn registration
         * @description Validates the WebAuthn attestation returned by the authenticator and stores the credential for the vault user. The supplied session token must match a previous registration begin call.
         */
        post: operations["finishWebauthnRegistration"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/webauthn/login/begin": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Begin WebAuthn assertion
         * @description Issues a WebAuthn assertion challenge for the supplied username. Clients must forward the returned options to `navigator.credentials.get` and later submit the authenticator response to `/webauthn/login/finish`.
         */
        post: operations["beginWebauthnLogin"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/webauthn/login/finish": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Complete WebAuthn assertion
         * @description Validates the WebAuthn assertion and issues an authenticated session cookie for the vault endpoints. The supplied session token must match a previous login begin call.
         */
        post: operations["finishWebauthnLogin"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/vault/status": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Inspect vault state
         * @description Returns the current vault lifecycle state plus metadata about the active user and session. This endpoint is unauthenticated so the frontend can poll during setup.
         */
        get: operations["getVaultStatus"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/vault/setup": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Store the encrypted vault payload
         * @description Accepts the username and WebAuthn PRF-encrypted secret bundle produced by the browser. After storing the payload the vault transitions to the sealed state and awaits unseal.
         */
        post: operations["setupVault"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/vault/unseal": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Provide decrypted secrets to unlock the vault
         * @description Accepts the plaintext bundle derived in the browser after WebAuthn verification. On success the server hydrates upstream clients, issues a session cookie, and marks the vault as unsealed until the session expires or `/vault/seal` is called.
         */
        post: operations["unsealVault"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/vault/seal": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Reseal the vault and clear in-memory secrets
         * @description Marks the vault as sealed, drops in-memory credentials, and invalidates the current session.
         */
        post: operations["sealVault"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/vault/payload": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Retrieve encrypted vault payload
         * @description Returns the stored ciphertext bundle for the authenticated user. Requires a valid session cookie obtained via WebAuthn and is typically called immediately before `/vault/unseal`.
         */
        get: operations["getVaultPayload"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/bots": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * List cached 3Commas bots
         * @description Returns bot records stored in `threecommas_bots`. Use filters to drill down to a single bot if needed.
         */
        get: operations["listBots"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/deals": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * List cached 3Commas deals
         * @description Returns deal rows from `threecommas_deals`. Filters allow narrowing by bot, deal ID, and update timestamps; a single endpoint covers both list and detail use-cases.
         */
        get: operations["listDeals"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/orders": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * List acted-on bot events with Hyperliquid context
         * @description Returns rows from `threecommas_botevents` (the actionable subset). Each row includes the raw 3Commas payload, plus the latest matching submission and status from Hyperliquid if present. Use the filters to drill down to a single metadata hex, bot, deal, or bot-event ID. The `from`/`to` window operates on the bot-event `observed_at` timestamp so you can page through history. Setting `include_log=true` embeds matching entries from `threecommas_botevents_log` and `hyperliquid_status_history` within each result, filtered by the same time window.
         */
        get: operations["listOrders"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/orders/{metadata}/cancel": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Cancel Hyperliquid order by metadata
         * @description Enqueues a Hyperliquid cancel action for the order identified by the supplied metadata hex. The service resolves the most recent submission for the metadata to determine the CLOID and venue coin.
         */
        post: operations["cancelOrderByMetadata"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sse/orders": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Stream live changes to acted-on orders
         * @description Server Sent Events channel fed by writes to `threecommas_botevents`, `hyperliquid_submissions`, and `hyperliquid_status_history`. Each `data:` frame is a JSON object containing the raw payload we stored for that update, plus the metadata hex and timestamps. Filters match the query semantics of `/api/orders`.
         */
        get: operations["streamOrders"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sse/hyperliquid/prices": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Stream Hyperliquid best bid/offer quotes
         * @description Server Sent Events channel that publishes best bid and offer updates for the requested Hyperliquid coins. Each subscription ensures the backend is listening to the venue's BBO feed (via `EnsureBBO`) and forwards normalized price levels whenever new quotes arrive. Each `data:` payload is a JSON-encoded `HyperliquidBestBidOffer`.
         */
        get: operations["streamHyperliquidPrices"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
}
export type webhooks = Record<string, never>;
export interface components {
    schemas: {
        WebAuthnRegistrationBeginRequest: {
            /** @description Logical username initiating registration. */
            username: string;
        };
        WebAuthnRegistrationBeginResponse: {
            /** @description Opaque token that must be supplied when completing registration. */
            session_token: string;
            /** @description PublicKeyCredentialCreationOptions for `navigator.credentials.create`. */
            creation_options: {
                [key: string]: unknown;
            };
        };
        WebAuthnRegistrationFinishRequest: {
            /** @description Token issued by `/webauthn/registration/begin`. */
            session_token: string;
            /** @description Parsed response from `navigator.credentials.create`. */
            client_response: {
                [key: string]: unknown;
            };
        };
        WebAuthnRegistrationFinishResponse: {
            /** @description Textual status of the registration ceremony (for example `registered`). */
            status: string;
        };
        WebAuthnLoginBeginRequest: {
            /** @description Logical username initiating the login ceremony. */
            username: string;
        };
        WebAuthnLoginBeginResponse: {
            /** @description Opaque token that must be supplied when completing login. */
            session_token: string;
            /** @description PublicKeyCredentialRequestOptions for `navigator.credentials.get`. */
            assertion_options: {
                [key: string]: unknown;
            };
        };
        WebAuthnLoginFinishRequest: {
            /** @description Token issued by `/webauthn/login/begin`. */
            session_token: string;
            /** @description Parsed response from `navigator.credentials.get`. */
            client_response: {
                [key: string]: unknown;
            };
        };
        WebAuthnLoginFinishResponse: {
            /** @description Textual status of the login ceremony (for example `authenticated`). */
            status: string;
        };
        /** @enum {string} */
        VaultState: "setup_required" | "sealed" | "unsealed";
        VaultUser: {
            username: string;
            /**
             * Format: date-time
             * @description Timestamp the user record was created, when available.
             */
            created_at?: string | null;
        };
        VaultStatus: {
            state: components["schemas"]["VaultState"];
            /** @description Present once setup is complete. */
            user?: components["schemas"]["VaultUser"];
            /**
             * Format: date-time
             * @description Last time the vault entered the sealed state.
             */
            sealed_at?: string | null;
            /**
             * Format: date-time
             * @description Last time the vault was unsealed.
             */
            unsealed_at?: string | null;
            /**
             * Format: date-time
             * @description Session expiry for the current user when unsealed.
             */
            session_expires_at?: string | null;
        };
        VaultEncryptedPayload: {
            /** @description Payload version label used to interpret the ciphertext. */
            version: string;
            /**
             * Format: byte
             * @description Base64-encoded ciphertext produced by the browser. When decrypted it yields a `VaultSecretsBundle`.
             */
            ciphertext: string;
            /**
             * Format: byte
             * @description Base64-encoded nonce/IV used during encryption.
             */
            nonce: string;
            /**
             * Format: byte
             * @description Optional associated data supplied during encryption.
             */
            associated_data?: string | null;
            /** @description WebAuthn PRF parameters needed for future decryptions. */
            prf_params?: {
                [key: string]: unknown;
            } | null;
        };
        /** @description JSON structure encrypted during setup and supplied in plaintext when unsealing the vault. */
        VaultSecretsBundle: {
            not_secret: {
                /** @description Logical username mirrored inside the plaintext payload. */
                username: string;
            };
            secrets: {
                /** @description Public API key for the 3Commas integration. */
                THREECOMMAS_API_KEY: string;
                /** @description Private API key for the 3Commas integration. */
                THREECOMMAS_PRIVATE_KEY: string;
                /** @description Hyperliquid wallet address. */
                HYPERLIQUID_WALLET: string;
                /** @description Hyperliquid private key corresponding to the wallet. */
                HYPERLIQUID_PRIVATE_KEY: string;
                /** @description Hyperliquid URL, mainnet https://api.hyperliquid.xyz testnet https://api.hyperliquid-testnet.xyz or custom */
                HYPERLIQUID_URL: string;
            };
        };
        VaultSetupRequest: {
            /** @description Logical username for the vault owner. */
            username: string;
            payload: components["schemas"]["VaultEncryptedPayload"];
        };
        VaultUnsealRequest: {
            payload: components["schemas"]["VaultSecretsBundle"];
            /**
             * Format: int64
             * @description Optional session TTL hint; server may clamp or ignore.
             */
            remember_session_seconds?: number;
        };
        BotRecord: {
            /** Format: int64 */
            bot_id: number;
            /** Format: date-time */
            last_synced_at: string;
            /** @description Raw 3Commas bot payload exactly as stored. */
            payload: components["schemas"]["Bot"];
        };
        DealRecord: {
            /** Format: int64 */
            deal_id: number;
            /** Format: int64 */
            bot_id: number;
            /** Format: date-time */
            created_at: string;
            /** Format: date-time */
            updated_at: string;
            /** @description Raw 3Commas deal payload exactly as stored. */
            payload: components["schemas"]["Deal"];
        };
        OrderRecord: {
            /** @description Metadata hash (hex) as stored in `threecommas_botevents`. */
            metadata: string;
            /** @description Parsed bot/deal information derived from the metadata. `hex` repeats the `metadata` value. */
            identifiers: components["schemas"]["OrderIdentifiers"];
            /**
             * Format: date-time
             * @description Timestamp when Recomma observed the order update.
             */
            observed_at: string;
            /** @description Latest parsed 3Commas bot-event associated with this metadata. */
            three_commas: components["schemas"]["ThreeCommasOrderState"];
            /** @description Latest Hyperliquid submission/status captured for this metadata. */
            hyperliquid?: components["schemas"]["HyperliquidOrderState"];
            /** @description Present only when `include_log=true`. Entries follow the same structured shape as the SSE stream. */
            log_entries?: components["schemas"]["OrderLogEntry"][] | null;
        };
        CancelOrderByMetadataRequest: {
            /** @description Optional operator note recorded alongside the cancel request. */
            reason?: string | null;
            /**
             * @description When true, validate the cancel preconditions without dispatching the Hyperliquid request.
             * @default false
             */
            dry_run: boolean;
        };
        CancelOrderByMetadataResponse: {
            /** @description Metadata hex identifying the targeted order. */
            metadata: string;
            /** @description Outcome of the cancel attempt (for example `queued`, `skipped`, or `noop`). */
            status: string;
            /** @description Hyperliquid cancel payload that will be submitted when applicable. */
            cancel?: components["schemas"]["HyperliquidCancelOrder"];
            /** @description Additional context explaining the status when relevant. */
            message?: string | null;
        };
        OrderIdentifiers: {
            /** @description Case-insensitive hash deriving from the 3Commas metadata payload. */
            hex: string;
            /** Format: int64 */
            bot_id: number;
            /** Format: int64 */
            deal_id: number;
            /** Format: int64 */
            bot_event_id: number;
            /**
             * Format: date-time
             * @description When the originating 3Commas event was created.
             */
            created_at: string;
        };
        ThreeCommasOrderState: {
            /** @description Parsed 3Commas bot event emitted for this metadata. */
            event: components["schemas"]["ThreeCommasBotEvent"];
        };
        ThreeCommasBotEvent: {
            /** Format: date-time */
            created_at: string;
            /** @description High-level classification provided by the bot event parser (for example `Placing` or `Execute`). */
            action: string;
            coin: string;
            /** @description BUY/SELL side reported by 3Commas. */
            type: string;
            status: string;
            /** Format: double */
            price: number;
            /** Format: double */
            size: number;
            /** @description Event order type from 3Commas (base, safety, take_profit, etc). */
            order_type: string;
            /** @description Total number of orders in the group this event belongs to. */
            order_size: number;
            /** @description Position of this event inside the group (1-indexed). */
            order_position: number;
            /** Format: double */
            quote_volume: number;
            quote_currency: string;
            is_market: boolean;
            /** Format: double */
            profit?: number | null;
            profit_currency?: string | null;
            /** Format: double */
            profit_usd?: number | null;
            /** Format: double */
            profit_percentage?: number | null;
            /** @description Raw message parsed from 3Commas describing the event. */
            text: string;
        };
        HyperliquidOrderState: {
            /** @description Most recent action we submitted to Hyperliquid for this metadata (last write wins). */
            latest_submission?: components["schemas"]["HyperliquidAction"];
            /** @description Most recent order status update received from Hyperliquid for this metadata. */
            latest_status?: components["schemas"]["HyperliquidWsOrder"];
        };
        HyperliquidAction: components["schemas"]["HyperliquidNoopAction"] | components["schemas"]["HyperliquidCreateAction"] | components["schemas"]["HyperliquidModifyAction"] | components["schemas"]["HyperliquidCancelAction"];
        HyperliquidActionBase: {
            kind: string;
        };
        HyperliquidNoopAction: components["schemas"]["HyperliquidActionBase"] & {
            /** @enum {string} */
            kind?: "none";
            /** @description Optional explanation when no actionable payload is available. */
            reason?: string | null;
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            kind: "none";
        };
        HyperliquidCreateAction: components["schemas"]["HyperliquidActionBase"] & {
            /** @enum {string} */
            kind?: "create";
            order: components["schemas"]["HyperliquidCreateOrder"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            kind: "create";
        };
        HyperliquidModifyAction: components["schemas"]["HyperliquidActionBase"] & {
            /** @enum {string} */
            kind?: "modify";
            /**
             * Format: int64
             * @description Target order identifier when available.
             */
            oid?: number | null;
            /** @description Client order identifier (CLOID) to target when `oid` is not available. */
            client_order_id?: string | null;
            order: components["schemas"]["HyperliquidCreateOrder"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            kind: "modify";
        };
        HyperliquidCancelAction: components["schemas"]["HyperliquidActionBase"] & {
            /** @enum {string} */
            kind?: "cancel";
            cancel: components["schemas"]["HyperliquidCancelOrder"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            kind: "cancel";
        };
        HyperliquidCreateOrder: {
            coin: string;
            is_buy: boolean;
            /** Format: double */
            price: number;
            /** Format: double */
            size: number;
            reduce_only: boolean;
            order_type: components["schemas"]["HyperliquidOrderType"];
            client_order_id?: string | null;
        };
        HyperliquidOrderType: {
            limit?: components["schemas"]["HyperliquidLimitOrder"];
            trigger?: components["schemas"]["HyperliquidTriggerOrder"];
        };
        HyperliquidLimitOrder: {
            /** @description Time in force. Examples include `Gtc`, `Ioc`, and `Alo`. */
            tif: string;
        };
        HyperliquidTriggerOrder: {
            /** Format: double */
            trigger_px: number;
            is_market: boolean;
            /** @description Describes whether this trigger is take-profit (`tp`) or stop-loss (`sl`). */
            tpsl: string;
        };
        HyperliquidCancelOrder: {
            coin: string;
            client_order_id: string;
        };
        HyperliquidBestBidOffer: {
            /** @description Hyperliquid coin ticker (for example `ETH`). */
            coin: string;
            /**
             * Format: date-time
             * @description Timestamp (ISO-8601) when the quote snapshot was observed.
             */
            time: string;
            /** @description Best bid level reported by Hyperliquid at `time`. */
            bid: components["schemas"]["HyperliquidPriceLevel"];
            /** @description Best ask level reported by Hyperliquid at `time`. */
            ask: components["schemas"]["HyperliquidPriceLevel"];
        };
        HyperliquidPriceLevel: {
            /**
             * Format: double
             * @description Price level denominated in USD.
             */
            price: number;
            /**
             * Format: double
             * @description Available size at this price level.
             */
            size: number;
        };
        HyperliquidWsOrder: {
            order: components["schemas"]["HyperliquidWsBasicOrder"];
            status: components["schemas"]["HyperliquidOrderStatus"];
            /** Format: int64 */
            status_timestamp: number;
        };
        HyperliquidWsBasicOrder: {
            coin: string;
            /** @description Either `A` (ask) or `B` (bid) in Hyperliquid terminology. */
            side: string;
            limit_px: string;
            size: string;
            /** Format: int64 */
            oid: number;
            /** Format: int64 */
            timestamp: number;
            orig_size: string;
            client_order_id?: string | null;
        };
        /** @enum {string} */
        HyperliquidOrderStatus: "open" | "filled" | "canceled" | "triggered" | "rejected" | "marginCanceled" | "vaultWithdrawalCanceled" | "openInterestCapCanceled" | "selfTradeCanceled" | "reduceOnlyCanceled" | "siblingFilledCanceled" | "delistedCanceled" | "liquidatedCanceled" | "scheduledCancel" | "tickRejected" | "minTradeNtlRejected" | "perpMarginRejected" | "reduceOnlyRejected" | "badAloPxRejected" | "iocCancelRejected" | "badTriggerPxRejected" | "marketOrderNoLiquidityRejected" | "positionIncreaseAtOpenInterestCapRejected" | "positionFlipAtOpenInterestCapRejected" | "tooAggressiveAtOpenInterestCapRejected" | "openInterestIncreaseRejected";
        OrderLogEntry: components["schemas"]["ThreeCommasLogEntry"] | components["schemas"]["HyperliquidSubmissionLogEntry"] | components["schemas"]["HyperliquidStatusLogEntry"];
        OrderLogEntryBase: {
            /** @enum {string} */
            type: "three_commas_event" | "hyperliquid_submission" | "hyperliquid_status";
            /** @description Metadata hash (hex) identifying the order context. */
            metadata: string;
            /** @description Bot/deal identifiers derived from the metadata when available. */
            identifiers?: components["schemas"]["OrderIdentifiers"];
            /** Format: date-time */
            observed_at: string;
            /**
             * Format: int64
             * @description Monotonic sequence counter assigned at publish time, useful for de-duplicating streamed events.
             */
            sequence?: number | null;
            /** Format: int64 */
            bot_event_id?: number | null;
        };
        ThreeCommasLogEntry: components["schemas"]["OrderLogEntryBase"] & {
            event: components["schemas"]["ThreeCommasBotEvent"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            type: "three_commas_event";
        };
        HyperliquidSubmissionLogEntry: components["schemas"]["OrderLogEntryBase"] & {
            action: components["schemas"]["HyperliquidAction"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            type: "hyperliquid_submission";
        };
        HyperliquidStatusLogEntry: components["schemas"]["OrderLogEntryBase"] & {
            status: components["schemas"]["HyperliquidWsOrder"];
        } & {
            /**
             * @description discriminator enum property added by openapi-typescript
             * @enum {string}
             */
            type: "hyperliquid_status";
        };
        /**
         * @description Trading pair(s) in 3Commas format.
         * @example [
         *       "BNFCR_1INCHUSDT"
         *     ]
         */
        Pairs: string[];
        /**
         * @description Configuration object for an individual strategy in strategy_list, close_strategy_list, or safety_strategy_list.
         * @example [
         *       {
         *         "strategy": "manual",
         *         "options": {}
         *       },
         *       {
         *         "strategy": "nonstop",
         *         "options": {}
         *       },
         *       {
         *         "strategy": "trading_view",
         *         "options": {
         *           "time": "5m",
         *           "type": "buy_or_strong_buy"
         *         }
         *       },
         *       {
         *         "strategy": "rsi",
         *         "options": {
         *           "time": "5m",
         *           "points": 30,
         *           "trigger_condition": "less",
         *           "time_period": 7
         *         }
         *       }
         *     ]
         */
        StrategyConfig: {
            /**
             * @description Identifier of the strategy
             * @enum {string}
             */
            strategy?: "manual" | "nonstop" | "trading_view" | "rsi";
            /** @description Strategy-specific parameters (keys depend on the chosen strategy; see examples below). */
            options?: {
                [key: string]: unknown;
            };
        };
        TakeProfitStep: {
            /** @description Step number of Take Profit. */
            id?: number;
            /** @description The percentage of the base order volume to be allocated for this Take Profit step. */
            amount_percentage?: number;
            /** @description The specific profit percentage applied to the volume of units for this Take Profit step. */
            profit_percentage?: number;
        };
        BotEntity: {
            /** @description User-defined name of the DCA Bot. If not specified, the system will generate a default name automatically. */
            name?: string;
            /** @description ID of the exchange account entity where you want to create the DCA Bot. */
            account_id: number;
            /**
             * @description Trading pair(s) in 3Commas format. If a single pair is passed, a SingleBot is created.
             *     If two or more pairs are passed, a MultiBot is created.
             */
            pairs: components["schemas"]["Pairs"];
            /**
             * @description The maximum number of active deals available for this DCA Bot.
             * @default 1
             */
            max_active_deals: number;
            /**
             * @description The type of trading strategy used by this DCA Bot.
             * @enum {string}
             */
            strategy?: "short" | "long";
            /**
             * @description Currency used for profit calculation: base_currency or quote_currency.
             * @enum {string}
             */
            profit_currency?: "base_currency" | "quote_currency";
            /**
             * @description The volume type of the base order.
             * @enum {string}
             */
            base_order_volume_type?: "quote_currency" | "base_currency" | "percent";
            /** @description The volume of the base order for this DCA Bot. */
            base_order_volume?: string;
            /**
             * @description The start order type for this DCA Bot.
             * @enum {string}
             */
            start_order_type?: "limit" | "market";
            /** @description Array of strategies specifically for opening deals. */
            strategy_list?: components["schemas"]["StrategyConfig"][];
            /**
             * @description Sets leverage settings for a futures account.
             * @enum {string}
             */
            leverage_type?: "cross" | "isolated";
            /** @description Leverage value (exchange- and pair-dependent). */
            leverage_custom_value?: number;
            /** @description Enables trailing for Take Profit. */
            trailing_enabled?: boolean;
            /** @description Percentage value of the trailing deviation. */
            trailing_deviation?: string;
            /**
             * @description Basis for Take Profit calculation.
             * @enum {string}
             */
            take_profit_type?: "base" | "total";
            /** @description Percentage value for the bot’s Take Profit. Set to 0 if using steps. */
            take_profit?: string;
            /**
             * @description Take Profit steps (up to 4), each with:
             *     - amount_percentage
             *     - profit_percentage
             */
            take_profit_steps?: components["schemas"]["TakeProfitStep"][];
            /** @description Array of strategies used for closing deals. */
            close_strategy_list?: components["schemas"]["StrategyConfig"][];
            /**
             * @description Basis for minimum profit calculation.
             * @enum {string}
             */
            min_profit_type?: "base_order_volume" | "total_bought_volume";
            /** @description Minimum profit percentage required to complete a deal. */
            min_profit_percentage?: string;
            /** @description Percentage of realized profit to reinvest in each new deal. */
            reinvesting_percentage?: string;
            /** @description Percentage drop to trigger Stop Loss. */
            stop_loss_percentage?: string;
            /**
             * @description Action after Stop Loss closes a deal.
             * @enum {string}
             */
            stop_loss_type?: "stop_loss" | "stop_loss_and_disable_bot";
            /** @description Enables trailing for Stop Loss. */
            tsl_enabled?: boolean;
            /**
             * @description Enables the Move-to-Breakeven feature.
             * @default false
             */
            sl_to_breakeven_enabled: boolean;
            /** @description Configuration for breakeven trigger levels (0 = entry price, 1 = first TP step, etc.). */
            sl_to_breakeven_data?: Record<string, never>;
            /**
             * @description Enables Stop Loss timeout.
             * @default false
             */
            stop_loss_timeout_enabled: boolean;
            /** @description Timeout duration in seconds for Stop Loss. */
            stop_loss_timeout_in_seconds?: number;
            /** @description Percentage of losses to reduce base and safety orders proportionally. */
            risk_reduction_percentage?: string;
            /** @description Price deviation (%) to open each safety order. */
            safety_order_step_percentage?: string;
            /**
             * @description Volume type for safety orders.
             * @enum {string}
             */
            safety_order_volume_type?: "quote_currency" | "base_currency" | "percent";
            /** @description Volume of each safety order. */
            safety_order_volume?: string;
            /** @description Array of strategies for executing safety orders. */
            safety_strategy_list?: components["schemas"]["StrategyConfig"][];
            /** @description Maximum total number of safety orders per deal. */
            max_safety_orders?: number;
            /** @description Number of safety orders the bot may place concurrently. */
            active_safety_orders_count?: number;
            /** @description Multiplier for increasing safety order volume (Martingale). */
            martingale_volume_coefficient?: string;
            /** @description Multiplier for increasing safety order step (Martingale). */
            martingale_step_coefficient?: string;
            /** @description Minimum 24h BTC volume required to open a deal. */
            min_volume_btc_24h?: string;
            /** @description Minimum price to open a new deal. */
            min_price?: number;
            /** @description Maximum price to open a new deal. */
            max_price?: number;
            /** @description Delay before a new deal starts (seconds). */
            deal_start_delay_seconds?: number;
            /** @description Time after closing a deal before a new one can start (seconds). */
            cooldown?: string;
            /** @description Number of deals after which the bot disables itself. */
            disable_after_deals_count?: number;
            /** @description Max concurrent deals on the same pair (MultiBot only). */
            allowed_deals_on_same_pair?: number;
            /** @description Minimum entry price percentage (−95 to 1000). */
            min_price_percentage?: number;
            /** @description Maximum entry price percentage (−95 to 1000). */
            max_price_percentage?: number;
            /** @description Auto-close deals after this many seconds. */
            close_deals_timeout?: string;
        };
        /** @description A single DCA‐bot deal, with all its execution and P/L details. */
        Deal: {
            /** @description Unique 3Commas ID for this Deal entity. */
            id: number;
            /** @description The type of entity. */
            type: string;
            /** @description Unique 3Commas ID for the DCA Bot that opened this deal. */
            bot_id: number;
            /** @description DCA Bot name specified by the user. */
            bot_name: string;
            /** @description Indicates whether this Deal has encountered any errors. */
            deal_has_error: boolean;
            /** @description Unique 3Commas ID for the exchange account used. */
            account_id: number;
            /** @description The name of the exchange account, as set by the user. */
            account_name: string;
            /**
             * Format: date-time
             * @description When the Deal was created (ISO 8601).
             */
            created_at: string;
            /**
             * Format: date-time
             * @description When the Deal was last updated (ISO 8601).
             */
            updated_at: string;
            /**
             * Format: date-time
             * @description When the Deal was closed, or `null` if still open.
             */
            closed_at: string | null;
            /** @description Whether this Deal has finished (`true`) or is still in progress (`false`). */
            "finished?": boolean;
            /** @description Maximum number of safety orders allowed for this deal. */
            max_safety_orders: number;
            /** @description Number of safety orders the bot may place concurrently. */
            active_safety_orders_count: number;
            /** @description Currently active safety orders (including manual). */
            current_active_safety_orders_count: number;
            /** @description Currently active safety orders. */
            current_active_safety_orders: number;
            /** @description How many safety orders have already been filled. */
            completed_safety_orders_count: number;
            /** @description Number of active manually‐triggered safety orders. */
            active_manual_safety_orders: number;
            /** @description Number of manually‐triggered safety orders that have completed. */
            completed_manual_safety_orders_count: number;
            /** @description Size of each safety order. */
            safety_order_volume: string;
            /** @description Price deviation (%) between safety orders. */
            safety_order_step_percentage: string;
            /** @description Volume type for safety orders (e.g. `quote_currency`, `base_currency`, `percent`). */
            safety_order_volume_type: string;
            /** @description Custom strategies for safety orders. */
            safety_strategy_list: {
                [key: string]: unknown;
            }[];
            /** @description Whether this deal can still be canceled. */
            "cancellable?": boolean;
            /** @description Whether this deal can still be closed at market price. */
            "panic_sellable?": boolean;
            /** @description Trailing Take Profit enabled. */
            trailing_enabled: boolean;
            /** @description Trailing Stop Loss enabled. */
            tsl_enabled: boolean;
            /** @description Whether Stop-Loss timeout is enabled. */
            stop_loss_timeout_enabled: boolean;
            /** @description Duration (s) of Stop-Loss timeout. */
            stop_loss_timeout_in_seconds: number;
            /** @description Trading pair in 3Commas format. */
            pair: string;
            /**
             * @description Deal status
             * @enum {string}
             */
            status: "bought" | "completed" | "failed";
            /** @description Human‐readable status. */
            localized_status: string;
            /**
             * @description Basis for TP calculation
             * @enum {string}
             */
            take_profit_type: "base" | "total";
            /** @description Take Profit percentage, or `null` if using steps. */
            take_profit: string | null;
            /** @description If using TP steps, the details of each step. */
            take_profit_steps: {
                /** @description Step index. */
                id?: number;
                /** @description % of base order volume for this TP step. */
                amount_percentage?: number;
                /** @description % profit target for this TP step. */
                profit_percentage?: number;
                /** @description Whether this step can still be edited. */
                editable?: boolean;
                /** @description Whether this TP step can be closed at market. */
                panic_sellable?: boolean;
                /** @description 3Commas Trade entity ID. */
                trade_id?: number;
                /**
                 * Format: date-time
                 * @description When this TP step executed, or `null`.
                 */
                execution_timestamp?: string | null;
                /** @description Volume allocated for this TP step. */
                initial_amount?: string;
                /** @description Trigger price for this TP step. */
                price?: string;
                /** @description Current status of this TP step. */
                status?: string;
            }[];
            /** @description Volume of the base order. */
            base_order_volume: string;
            /** @description Volume type of the base order. */
            base_order_volume_type: string;
            /** @description Leverage mode (`cross`, `isolated`, or `not_specified`). */
            leverage_type: string;
            /** @description User‐set leverage value. */
            leverage_custom_value: string | null;
            /** @description Amount of asset bought. */
            bought_amount: string;
            /** @description Quote‐currency volume spent. */
            bought_volume: string;
            /** @description Average price of the buy. */
            bought_average_price: string;
            /** @description Average price of the base order. */
            base_order_average_price: string;
            /** @description Amount of asset sold. */
            sold_amount: string;
            /** @description Quote‐currency volume received from sells. */
            sold_volume: string;
            /** @description Average sell price. */
            sold_average_price: string;
            /** @description Net P/L (in profit currency). */
            final_profit: string;
            /** @description Net P/L percentage. */
            final_profit_percentage: string;
            /** @description Net P/L expressed in USD. */
            usd_final_profit: string;
            /** @description Realized P/L after execution. */
            actual_profit: string | null;
            /** @description Realized P/L in USD. */
            actual_usd_profit: string | null;
            /** @description Martingale volume multiplier. */
            martingale_volume_coefficient: string;
            /** @description Martingale step multiplier. */
            martingale_step_coefficient: string;
            /** @description Stop-Loss trigger percentage. */
            stop_loss_percentage: string;
            /** @description Move-to-Breakeven feature enabled. */
            sl_to_breakeven_enabled: boolean;
            /** @description Breakeven config (e.g. `{ "upper_breakeven_limit": 1 }`). */
            sl_to_breakeven_data: {
                [key: string]: unknown;
            } | null;
            /** @description Error message if the deal failed. */
            error_message: string | null;
            /** @description Currency for profit calculation. */
            profit_currency: string;
            /** @description What action occurs on Stop-Loss. */
            stop_loss_type: string;
            /** @description Quote currency code. */
            from_currency: string;
            /** @description Base currency code. */
            to_currency: string;
            /** @description Minimum profit % for TP close strategy. */
            min_profit_percentage: string;
            /** @description Basis for minimum profit calculation. */
            min_profit_type: string | null;
            /** @description Custom close strategies applied. */
            close_strategy_list: {
                [key: string]: unknown;
            }[];
            /** @description Optional user note. */
            note: string | null;
            /** @description Whether adding funds is allowed. */
            add_fundable: boolean;
            /** @description Whether this deal can be converted to a SmartTrade. */
            smart_trade_convertable: boolean;
            /** @description Exchange market type (`spot` or `futures`). */
            market_type: string;
            /** @description Latest market price. */
            current_price: string;
            /** @description TP trigger price (single‐condition bots). */
            take_profit_price: string;
            /** @description SL trigger price. */
            stop_loss_price: string;
            /** @description Realized profit percentage. */
            actual_profit_percentage: string;
            /** @description Currency used for orderbook quotes. */
            orderbook_price_currency: string;
            /** @description Log of bot events for this deal. */
            bot_events: {
                /** @description Event description. */
                message?: string;
                /**
                 * Format: date-time
                 * @description When the event occurred.
                 */
                created_at?: string;
            }[];
            from_currency_id?: number;
            to_currency_id?: number;
        };
        Bot: WithRequired<components["schemas"]["BotEntity"], "account_id" | "active_safety_orders_count" | "allowed_deals_on_same_pair" | "base_order_volume" | "base_order_volume_type" | "close_deals_timeout" | "close_strategy_list" | "cooldown" | "deal_start_delay_seconds" | "disable_after_deals_count" | "leverage_custom_value" | "leverage_type" | "martingale_step_coefficient" | "martingale_volume_coefficient" | "max_active_deals" | "max_price" | "max_price_percentage" | "max_safety_orders" | "min_price" | "min_price_percentage" | "min_profit_percentage" | "min_profit_type" | "min_volume_btc_24h" | "name" | "pairs" | "profit_currency" | "reinvesting_percentage" | "risk_reduction_percentage" | "safety_order_step_percentage" | "safety_order_volume" | "safety_order_volume_type" | "safety_strategy_list" | "sl_to_breakeven_data" | "sl_to_breakeven_enabled" | "start_order_type" | "stop_loss_percentage" | "stop_loss_timeout_enabled" | "stop_loss_timeout_in_seconds" | "stop_loss_type" | "strategy" | "strategy_list" | "take_profit" | "take_profit_steps" | "take_profit_type" | "trailing_deviation" | "trailing_enabled" | "tsl_enabled"> & {
            /** @description Unique 3Commas ID for this DCA Bot. */
            id: number;
            /** @description Whether the bot is currently enabled. */
            is_enabled: boolean;
            /** @description List of active deals managed by this DCA Bot. */
            active_deals: components["schemas"]["Deal"][];
            /** @description Number of active deals. */
            active_deals_count: number;
            /** @description Indicates whether this bot can be deleted. */
            "deletable?": boolean;
            /**
             * Format: date-time
             * @description ISO-8601 timestamp when the bot was created.
             */
            created_at: string;
            /**
             * Format: date-time
             * @description ISO-8601 timestamp of last update.
             */
            updated_at: string;
            /** @description Exchange-account name shown to the user. */
            account_name: string;
            /** @description Cumulative USD profit from finished deals. */
            finished_deals_profit_usd: string;
            /** @description Total number of finished deals. */
            finished_deals_count: string;
            /** @description USD currently locked in active deals. */
            funds_locked_in_active_deals: string;
            /** @description BTC currently locked in active deals. */
            btc_funds_locked_in_active_deals: string;
            /** @description Unrealised P/L of active deals (USD). */
            active_deals_usd_profit: string;
            /** @description Unrealised P/L of active deals (BTC). */
            active_deals_btc_profit: string;
            /** @description USD volume reinvested from profit. */
            reinvested_volume_usd: number | null;
        };
    };
    responses: never;
    parameters: never;
    requestBodies: never;
    headers: never;
    pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
    beginWebauthnRegistration: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WebAuthnRegistrationBeginRequest"];
            };
        };
        responses: {
            /** @description Registration ceremony started; includes session token and creation options. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WebAuthnRegistrationBeginResponse"];
                };
            };
            /** @description Invalid payload */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Registration not allowed in current vault state */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    finishWebauthnRegistration: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WebAuthnRegistrationFinishRequest"];
            };
        };
        responses: {
            /** @description Registration completed successfully. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WebAuthnRegistrationFinishResponse"];
                };
            };
            /** @description Invalid attestation payload */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Registration session not found or expired */
            404: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Registration not allowed in current vault state */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    beginWebauthnLogin: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WebAuthnLoginBeginRequest"];
            };
        };
        responses: {
            /** @description Login ceremony started; includes session token and assertion options. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WebAuthnLoginBeginResponse"];
                };
            };
            /** @description Invalid payload */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description No WebAuthn credentials available for the user */
            404: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Login not allowed in current vault state */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    finishWebauthnLogin: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WebAuthnLoginFinishRequest"];
            };
        };
        responses: {
            /** @description Login completed successfully; session cookie returned. */
            200: {
                headers: {
                    /** @description Session cookie (`recomma_session`) representing the authenticated user. */
                    "Set-Cookie"?: string;
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WebAuthnLoginFinishResponse"];
                };
            };
            /** @description Invalid assertion payload */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Login session not found or expired */
            404: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Login not allowed in current vault state */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    getVaultStatus: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Current vault status. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["VaultStatus"];
                };
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    setupVault: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["VaultSetupRequest"];
            };
        };
        responses: {
            /** @description Vault payload stored; service is sealed and ready for unseal. */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["VaultStatus"];
                };
            };
            /** @description Invalid payload; rejected. */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Vault is already initialized; switch to recovery flow. */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    unsealVault: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["VaultUnsealRequest"];
            };
        };
        responses: {
            /** @description Vault unsealed; session cookie returned. */
            200: {
                headers: {
                    /** @description Session cookie (`recomma_session`) representing the authenticated user. */
                    "Set-Cookie"?: string;
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["VaultStatus"];
                };
            };
            /** @description Payload rejected. */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Vault must be sealed before unsealing. */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Initial setup is still required. */
            423: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    sealVault: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Vault sealed; upstream activity should pause until unsealed again. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["VaultStatus"];
                };
            };
            /** @description Authentication required. */
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    getVaultPayload: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Ciphertext payload available for decryption in the browser. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["VaultEncryptedPayload"];
                };
            };
            /** @description Authentication required. */
            401: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description No vault payload stored yet (setup required or recovery mode). */
            404: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Vault is not yet initialized; run `/vault/setup` first. */
            423: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    listBots: {
        parameters: {
            query?: {
                /** @description Return only the bot with this ID (exact match). */
                bot_id?: number;
                /** @description ISO-8601 timestamp; include bots touched at or after this time. */
                updated_from?: string;
                /** @description ISO-8601 timestamp; include bots touched at or before this time. */
                updated_to?: string;
                /** @description Maximum number of rows (default 100, max 500). */
                limit?: number;
                /** @description Opaque cursor returned by a previous call (empty for first page). */
                page_token?: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Bot records ordered newest-first unless a chronological range was requested. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        items: components["schemas"]["BotRecord"][];
                        next_page_token?: string | null;
                    };
                };
            };
            /** @description Invalid parameters */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    listDeals: {
        parameters: {
            query?: {
                /** @description Return only the deal with this ID (exact match). */
                deal_id?: number;
                /** @description Restrict to deals belonging to this bot. */
                bot_id?: number;
                /** @description ISO-8601 timestamp; include deals updated at or after this time. */
                updated_from?: string;
                /** @description ISO-8601 timestamp; include deals updated at or before this time. */
                updated_to?: string;
                /** @description Maximum number of rows (default 100, max 500). */
                limit?: number;
                /** @description Opaque cursor returned by a previous call. */
                page_token?: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Deal records ordered newest-first unless a chronological range was requested. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        items: components["schemas"]["DealRecord"][];
                        next_page_token?: string | null;
                    };
                };
            };
            /** @description Invalid parameters */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    listOrders: {
        parameters: {
            query?: {
                /** @description Case-insensitive prefix match on metadata hex; exact match recommended for drill-down. */
                metadata?: string;
                /** @description Restrict to events emitted by this bot ID. */
                bot_id?: number;
                /** @description Restrict to events emitted by this deal ID. */
                deal_id?: number;
                /** @description Restrict to a specific 3Commas bot-event ID (exact match). */
                bot_event_id?: number;
                /** @description ISO-8601 timestamp; include events observed at or after this time. */
                observed_from?: string;
                /** @description ISO-8601 timestamp; include events observed at or before this time. */
                observed_to?: string;
                /** @description When true, embed `log_entries` for each order, limited to the same metadata and time range (default false). */
                include_log?: boolean;
                /** @description Maximum number of rows (default 100, max 500). */
                limit?: number;
                /** @description Opaque cursor returned by a previous call. */
                page_token?: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Order records matching the requested filters. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        items: components["schemas"]["OrderRecord"][];
                        next_page_token?: string | null;
                    };
                };
            };
            /** @description Invalid parameters */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    cancelOrderByMetadata: {
        parameters: {
            query?: never;
            header?: never;
            path: {
                /** @description Order metadata identifier (case-insensitive hex string with optional `0x` prefix). */
                metadata: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["CancelOrderByMetadataRequest"];
            };
        };
        responses: {
            /** @description Cancel action accepted for processing. */
            202: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["CancelOrderByMetadataResponse"];
                };
            };
            /** @description Invalid metadata or payload */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Metadata not found or no cancellable order present */
            404: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Order already completed or cancel currently in progress */
            409: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    streamOrders: {
        parameters: {
            query?: {
                /** @description Case-insensitive prefix match; only events for matching metadata are emitted. */
                metadata?: string;
                /** @description Restrict to this bot ID. */
                bot_id?: number;
                /** @description Restrict to this deal ID. */
                deal_id?: number;
                /** @description Restrict to this bot-event ID. */
                bot_event_id?: number;
                /** @description If supplied, drop events older than this timestamp (useful for resume). */
                observed_from?: string;
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description text/event-stream; each frame carries a JSON object with order-change details. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "text/event-stream": string;
                };
            };
            /** @description Invalid parameters */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
    streamHyperliquidPrices: {
        parameters: {
            query: {
                /** @description One or more Hyperliquid coin tickers to subscribe to. Repeat the parameter to request multiple coins. */
                coin: string[];
            };
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description text/event-stream; each frame encodes the latest best bid/offer snapshot for the subscribed coins. */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "text/event-stream": string;
                };
            };
            /** @description Invalid parameters */
            400: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Internal server error */
            500: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
        };
    };
}
type WithRequired<T, K extends keyof T> = T & {
    [P in K]-?: T[P];
};
