Resolves #issueNumber
Impact: **breaking|critical|major|minor**
Type: **feature|bugfix|performance|test|style|refactor|docs|chore**

## Issue

Description of the issue this PR is solving, why it's happening, and how to reproduce it. This may differ from the original ticket as you now have more information at your disposal.

## Solution

Summarize your solution to the problem. Please include short descriptions of any solutions you tested before arriving at your final solution. This will help reviewers know why you decided to solve this problem in this particular way and will speed up the review process.

If you're solving a UIX related issue, please attach screen-caps or gifs showing how your solution differs from the issue.

## Breaking changes

If you have a breaking changes, list them here, otherwise list none.

Examples of breaking changes include changing file names, moving files, deleting files, renaming functions or exports, or changes to code which might cause previous versions of Reaction or third-party code not to work as expected.

Note any work that you did to mitigate the effect of any breaking changes such as creating migrations, deprecation warnings, etc.

## Testing

1. List the steps needed for testing your change in this section.
2. Assume that testers already know how to start the app, and do the basic setup tasks.
3. Be detailed enough that someone can work through it without being too granular

More detail for what each of these sections should include are available in our [Contributing Docs](CONTRIBUTING.md).
