﻿// Copyright (c) 2025 .NET Foundation and Contributors. All rights reserved.
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for full license information.

#nullable enable

//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using System.Linq;
using System.Linq.Expressions;
using System.Diagnostics.CodeAnalysis;


namespace ReactiveUI
{
    /// <summary>Extension methods associated with the WhenAny/WhenAnyValue classes.</summary>
    public static class WhenAnyMixin
    {
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of a
        /// property on an object has changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The first property chain to reference. This will be a expression pointing to a end property or field.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet>(
            this TSender? sender,
            Expression<Func<TSender, TRet>> property1)
        {
            return sender!.WhenAny(property1, (IObservedChange<TSender, TRet> c1) => c1.Value);
        }

        /// <summary>
        /// AOT-friendly overload that avoids expression trees by using a property name.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="propertyName">The property name to observe.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet>(
            this TSender? sender,
            string propertyName)
        {
            return sender!.ObservableForProperty<TSender, TRet>(propertyName, beforeChange: false, skipInitial: false, isDistinct: true)
                          .Select(x => x.Value);
        }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of a
        /// property on an object has changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The first property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet>(
            this TSender? sender,
            Expression<Func<TSender, TRet>> property1,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, (IObservedChange<TSender, TRet> c1) => c1.Value, isDistinct);
        }

        /// <summary>
        /// AOT-friendly overload that avoids expression trees by using a property name and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet>(
            this TSender? sender,
            string propertyName,
            bool isDistinct)
        {
            return sender!.ObservableForProperty<TSender, TRet>(propertyName, beforeChange: false, skipInitial: false, isDistinct: isDistinct)
                          .Select(x => x.Value);
        }

                                                                        
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Func<T1, TRet> selector)
        {
            return sender!.WhenAny(property1,
                                (c1) =>
                                    selector(c1.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1>(
            this TSender? sender,
                        string property1Name,
                        Func<T1, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return o1.Select(selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Func<T1, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1,
                                (c1) =>
                                    selector(c1.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1>(
            this TSender? sender,
                        string property1Name,
                        Func<T1, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return o1.Select(selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Func<IObservedChange<TSender, T1>, TRet> selector)
        {
                            return sender!.ObservableForProperty(property1, false, false).Select(selector);
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1>(
                this TSender? sender,
                            string property1Name,
                            Func<IObservedChange<TSender, T1>, TRet> selector)
        {
                            return sender!.ObservableForProperty<TSender, T1>(property1Name, false, false)
                              .Select(c1 => selector(c1));
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Func<IObservedChange<TSender, T1>, TRet> selector,
                            bool isDistinct)
        {
                            return sender!.ObservableForProperty(property1, false, false, isDistinct).Select(selector);
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1>(
                this TSender? sender,
                            string property1Name,
                            Func<IObservedChange<TSender, T1>, TRet> selector,
                            bool isDistinct)
        {
                            return sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct)
                              .Select(c1 => selector(c1));
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Func<IObservedChange<TSender?, object?>, TRet> selector)
        {
                            return ReactiveNotifyPropertyChangedMixin
                    .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false).Select(selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Func<IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                            return ReactiveNotifyPropertyChangedMixin
                    .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct).Select(selector);
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2)> WhenAnyValue<TSender, T1,T2>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2
            )
        {
            return sender!.WhenAny(property1, property2,
                                (c1, c2) =>
                                    (c1.Value, c2.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2)> WhenAnyValue<TSender, T1,T2>(
            this TSender? sender,
                        string property1Name,                        string property2Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value)
                            , (v1,v2) =>
                (v1,v2)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2)> WhenAnyValue<TSender, T1,T2>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2,
                                (c1, c2) =>
                                    (c1.Value, c2.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2)> WhenAnyValue<TSender, T1,T2>(
            this TSender? sender,
                        string property1Name,                        string property2Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value)
                            , (v1,v2) =>
                (v1,v2)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Func<T1,T2, TRet> selector)
        {
            return sender!.WhenAny(property1, property2,
                                (c1, c2) =>
                                    selector(c1.Value, c2.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        Func<T1,T2, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Func<T1,T2, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2,
                                (c1, c2) =>
                                    selector(c1.Value, c2.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        Func<T1,T2, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3)> WhenAnyValue<TSender, T1,T2,T3>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3
            )
        {
            return sender!.WhenAny(property1, property2, property3,
                                (c1, c2, c3) =>
                                    (c1.Value, c2.Value, c3.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3)> WhenAnyValue<TSender, T1,T2,T3>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value)
                            , (v1,v2,v3) =>
                (v1,v2,v3)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3)> WhenAnyValue<TSender, T1,T2,T3>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3,
                                (c1, c2, c3) =>
                                    (c1.Value, c2.Value, c3.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3)> WhenAnyValue<TSender, T1,T2,T3>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value)
                            , (v1,v2,v3) =>
                (v1,v2,v3)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Func<T1,T2,T3, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3,
                                (c1, c2, c3) =>
                                    selector(c1.Value, c2.Value, c3.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        Func<T1,T2,T3, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Func<T1,T2,T3, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3,
                                (c1, c2, c3) =>
                                    selector(c1.Value, c2.Value, c3.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        Func<T1,T2,T3, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4)> WhenAnyValue<TSender, T1,T2,T3,T4>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4
            )
        {
            return sender!.WhenAny(property1, property2, property3, property4,
                                (c1, c2, c3, c4) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4)> WhenAnyValue<TSender, T1,T2,T3,T4>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value)
                            , (v1,v2,v3,v4) =>
                (v1,v2,v3,v4)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4)> WhenAnyValue<TSender, T1,T2,T3,T4>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4,
                                (c1, c2, c3, c4) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4)> WhenAnyValue<TSender, T1,T2,T3,T4>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value)
                            , (v1,v2,v3,v4) =>
                (v1,v2,v3,v4)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Func<T1,T2,T3,T4, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4,
                                (c1, c2, c3, c4) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        Func<T1,T2,T3,T4, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Func<T1,T2,T3,T4, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4,
                                (c1, c2, c3, c4) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        Func<T1,T2,T3,T4, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5)> WhenAnyValue<TSender, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5
            )
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5,
                                (c1, c2, c3, c4, c5) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5)> WhenAnyValue<TSender, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5) =>
                (v1,v2,v3,v4,v5)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5)> WhenAnyValue<TSender, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5,
                                (c1, c2, c3, c4, c5) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5)> WhenAnyValue<TSender, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5) =>
                (v1,v2,v3,v4,v5)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Func<T1,T2,T3,T4,T5, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5,
                                (c1, c2, c3, c4, c5) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        Func<T1,T2,T3,T4,T5, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Func<T1,T2,T3,T4,T5, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5,
                                (c1, c2, c3, c4, c5) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        Func<T1,T2,T3,T4,T5, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6
            )
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6,
                                (c1, c2, c3, c4, c5, c6) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name,                        string property6Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value),
                                o6.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5,v6) =>
                (v1,v2,v3,v4,v5,v6)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6,
                                (c1, c2, c3, c4, c5, c6) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name,                        string property6Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value),
                                o6.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5,v6) =>
                (v1,v2,v3,v4,v5,v6)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Func<T1,T2,T3,T4,T5,T6, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6,
                                (c1, c2, c3, c4, c5, c6) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        Func<T1,T2,T3,T4,T5,T6, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Func<T1,T2,T3,T4,T5,T6, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6,
                                (c1, c2, c3, c4, c5, c6) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        Func<T1,T2,T3,T4,T5,T6, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6,T7)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7
            )
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7,
                                (c1, c2, c3, c4, c5, c6, c7) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value));
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names instead of expressions.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6,T7)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name,                        string property6Name,                        string property7Name            )
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value),
                                o6.Select(x => x.Value),
                                o7.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5,v6,v7) =>
                (v1,v2,v3,v4,v5,v6,v7)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6,T7)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7
            ,
            bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7,
                                (c1, c2, c3, c4, c5, c6, c7) =>
                                    (c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value),
                                    isDistinct);
        }
        
        /// <summary>
        /// AOT-friendly tuple overloads using property names with distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<(T1,T2,T3,T4,T5,T6,T7)> WhenAnyValue<TSender, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        string property1Name,                        string property2Name,                        string property3Name,                        string property4Name,                        string property5Name,                        string property6Name,                        string property7Name            ,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct);
                        return Observable.CombineLatest(
                                o1.Select(x => x.Value),
                                o2.Select(x => x.Value),
                                o3.Select(x => x.Value),
                                o4.Select(x => x.Value),
                                o5.Select(x => x.Value),
                                o6.Select(x => x.Value),
                                o7.Select(x => x.Value)
                            , (v1,v2,v3,v4,v5,v6,v7) =>
                (v1,v2,v3,v4,v5,v6,v7)
            );
        }
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Func<T1,T2,T3,T4,T5,T6,T7, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7,
                                (c1, c2, c3, c4, c5, c6, c7) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        Func<T1,T2,T3,T4,T5,T6,T7, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Func<T1,T2,T3,T4,T5,T6,T7, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7,
                                (c1, c2, c3, c4, c5, c6, c7) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        Func<T1,T2,T3,T4,T5,T6,T7, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8,
                                (c1, c2, c3, c4, c5, c6, c7, c8) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8,
                                (c1, c2, c3, c4, c5, c6, c7, c8) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                    sender!.ObservableForProperty(property8, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                    sender!.ObservableForProperty(property8, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                    sender!.ObservableForProperty(property8, false, false),
                                    sender!.ObservableForProperty(property9, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                    sender!.ObservableForProperty(property8, false, false, isDistinct),
                                    sender!.ObservableForProperty(property9, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                    sender!.ObservableForProperty(property8, false, false),
                                    sender!.ObservableForProperty(property9, false, false),
                                    sender!.ObservableForProperty(property10, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                    sender!.ObservableForProperty(property8, false, false, isDistinct),
                                    sender!.ObservableForProperty(property9, false, false, isDistinct),
                                    sender!.ObservableForProperty(property10, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Expression<Func<TSender, T11>> property11,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10, property11,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        string property11Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o11 = sender!.ObservableForProperty<TSender, T11>(property11Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10,
                                o11
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Expression<Func<TSender, T11>> property11,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10, property11,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        string property11Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o11 = sender!.ObservableForProperty<TSender, T11>(property11Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10,
                                o11
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Expression<Func<TSender, T11>> property11,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                    sender!.ObservableForProperty(property8, false, false),
                                    sender!.ObservableForProperty(property9, false, false),
                                    sender!.ObservableForProperty(property10, false, false),
                                    sender!.ObservableForProperty(property11, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            string property11Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false),
                                    sender!.ObservableForProperty<TSender, T11>(property11Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Expression<Func<TSender, T11>> property11,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                    sender!.ObservableForProperty(property8, false, false, isDistinct),
                                    sender!.ObservableForProperty(property9, false, false, isDistinct),
                                    sender!.ObservableForProperty(property10, false, false, isDistinct),
                                    sender!.ObservableForProperty(property11, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            string property11Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T11>(property11Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Expression? property11,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property11, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Expression? property11,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property11, false, false, isDistinct),
                                selector
            );
                    }
                                                                    
        
        
        
        
        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Expression<Func<TSender, T11>> property11,
                        Expression<Func<TSender, T12>> property12,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12, TRet> selector)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10, property11, property12,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value, c12.Value));
        }

        /// <summary>
        /// AOT-friendly selector overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        string property11Name,
                        string property12Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12, TRet> selector)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o11 = sender!.ObservableForProperty<TSender, T11>(property11Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                        var o12 = sender!.ObservableForProperty<TSender, T12>(property12Name, beforeChange: false, skipInitial: false, isDistinct: true).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10,
                                o11,
                                o12
                            , selector);
                    }

        /// <summary>
        /// WhenAnyValue allows you to observe whenever the value of one or more
        /// properties on an object have changed, providing an initial value when
        /// the Observable is set up, unlike ObservableForProperty(). Use this
        /// method in constructors to set up bindings between properties that also
        /// need an initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
            this TSender? sender,
                        Expression<Func<TSender, T1>> property1,
                        Expression<Func<TSender, T2>> property2,
                        Expression<Func<TSender, T3>> property3,
                        Expression<Func<TSender, T4>> property4,
                        Expression<Func<TSender, T5>> property5,
                        Expression<Func<TSender, T6>> property6,
                        Expression<Func<TSender, T7>> property7,
                        Expression<Func<TSender, T8>> property8,
                        Expression<Func<TSender, T9>> property9,
                        Expression<Func<TSender, T10>> property10,
                        Expression<Func<TSender, T11>> property11,
                        Expression<Func<TSender, T12>> property12,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12, TRet> selector,
                        bool isDistinct)
        {
            return sender!.WhenAny(property1, property2, property3, property4, property5, property6, property7, property8, property9, property10, property11, property12,
                                (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) =>
                                    selector(c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value, c12.Value),
                                    isDistinct);
        }

        /// <summary>
        /// AOT-friendly selector overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyValue uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyValue may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyValue<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
            this TSender? sender,
                        string property1Name,
                        string property2Name,
                        string property3Name,
                        string property4Name,
                        string property5Name,
                        string property6Name,
                        string property7Name,
                        string property8Name,
                        string property9Name,
                        string property10Name,
                        string property11Name,
                        string property12Name,
                        Func<T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12, TRet> selector,
            bool isDistinct)
        {
                        var o1 = sender!.ObservableForProperty<TSender, T1>(property1Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o2 = sender!.ObservableForProperty<TSender, T2>(property2Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o3 = sender!.ObservableForProperty<TSender, T3>(property3Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o4 = sender!.ObservableForProperty<TSender, T4>(property4Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o5 = sender!.ObservableForProperty<TSender, T5>(property5Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o6 = sender!.ObservableForProperty<TSender, T6>(property6Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o7 = sender!.ObservableForProperty<TSender, T7>(property7Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o8 = sender!.ObservableForProperty<TSender, T8>(property8Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o9 = sender!.ObservableForProperty<TSender, T9>(property9Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o10 = sender!.ObservableForProperty<TSender, T10>(property10Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o11 = sender!.ObservableForProperty<TSender, T11>(property11Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                        var o12 = sender!.ObservableForProperty<TSender, T12>(property12Name, beforeChange: false, skipInitial: false, isDistinct: isDistinct).Select(x => x.Value);
                                    return Observable.CombineLatest(
                                o1,
                                o2,
                                o3,
                                o4,
                                o5,
                                o6,
                                o7,
                                o8,
                                o9,
                                o10,
                                o11,
                                o12
                            , selector);
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Expression<Func<TSender, T11>> property11,
                            Expression<Func<TSender, T12>> property12,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, IObservedChange<TSender, T12>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false),
                                    sender!.ObservableForProperty(property2, false, false),
                                    sender!.ObservableForProperty(property3, false, false),
                                    sender!.ObservableForProperty(property4, false, false),
                                    sender!.ObservableForProperty(property5, false, false),
                                    sender!.ObservableForProperty(property6, false, false),
                                    sender!.ObservableForProperty(property7, false, false),
                                    sender!.ObservableForProperty(property8, false, false),
                                    sender!.ObservableForProperty(property9, false, false),
                                    sender!.ObservableForProperty(property10, false, false),
                                    sender!.ObservableForProperty(property11, false, false),
                                    sender!.ObservableForProperty(property12, false, false),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            string property11Name,
                            string property12Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, IObservedChange<TSender, T12>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false),
                                    sender!.ObservableForProperty<TSender, T11>(property11Name, false, false),
                                    sender!.ObservableForProperty<TSender, T12>(property12Name, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
                this TSender? sender,
                            Expression<Func<TSender, T1>> property1,
                            Expression<Func<TSender, T2>> property2,
                            Expression<Func<TSender, T3>> property3,
                            Expression<Func<TSender, T4>> property4,
                            Expression<Func<TSender, T5>> property5,
                            Expression<Func<TSender, T6>> property6,
                            Expression<Func<TSender, T7>> property7,
                            Expression<Func<TSender, T8>> property8,
                            Expression<Func<TSender, T9>> property9,
                            Expression<Func<TSender, T10>> property10,
                            Expression<Func<TSender, T11>> property11,
                            Expression<Func<TSender, T12>> property12,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, IObservedChange<TSender, T12>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty(property1, false, false, isDistinct),
                                    sender!.ObservableForProperty(property2, false, false, isDistinct),
                                    sender!.ObservableForProperty(property3, false, false, isDistinct),
                                    sender!.ObservableForProperty(property4, false, false, isDistinct),
                                    sender!.ObservableForProperty(property5, false, false, isDistinct),
                                    sender!.ObservableForProperty(property6, false, false, isDistinct),
                                    sender!.ObservableForProperty(property7, false, false, isDistinct),
                                    sender!.ObservableForProperty(property8, false, false, isDistinct),
                                    sender!.ObservableForProperty(property9, false, false, isDistinct),
                                    sender!.ObservableForProperty(property10, false, false, isDistinct),
                                    sender!.ObservableForProperty(property11, false, false, isDistinct),
                                    sender!.ObservableForProperty(property12, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// AOT-friendly WhenAny overload using property names and distinct option.
        /// </summary>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAny uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAny may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAny<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(
                this TSender? sender,
                            string property1Name,
                            string property2Name,
                            string property3Name,
                            string property4Name,
                            string property5Name,
                            string property6Name,
                            string property7Name,
                            string property8Name,
                            string property9Name,
                            string property10Name,
                            string property11Name,
                            string property12Name,
                            Func<IObservedChange<TSender, T1>, IObservedChange<TSender, T2>, IObservedChange<TSender, T3>, IObservedChange<TSender, T4>, IObservedChange<TSender, T5>, IObservedChange<TSender, T6>, IObservedChange<TSender, T7>, IObservedChange<TSender, T8>, IObservedChange<TSender, T9>, IObservedChange<TSender, T10>, IObservedChange<TSender, T11>, IObservedChange<TSender, T12>, TRet> selector,
                            bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    sender!.ObservableForProperty<TSender, T1>(property1Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T2>(property2Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T3>(property3Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T4>(property4Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T5>(property5Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T6>(property6Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T7>(property7Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T8>(property8Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T9>(property9Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T10>(property10Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T11>(property11Name, false, false, isDistinct),
                                    sender!.ObservableForProperty<TSender, T12>(property12Name, false, false, isDistinct),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Expression? property11,
                            Expression? property12,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property11, false, false),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property12, false, false),
                                selector
            );
                    }

        /// <summary>
        /// WhenAny allows you to observe whenever one or more properties on an
        /// object have changed, providing an initial value when the Observable
        /// is set up, unlike ObservableForProperty(). Use this method in
        /// constructors to set up bindings between properties that also need an
        /// initial setup.
        /// </summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="property1">The 1 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property2">The 2 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property3">The 3 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property4">The 4 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property5">The 5 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property6">The 6 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property7">The 7 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property8">The 8 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property9">The 9 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property10">The 10 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property11">The 11 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="property12">The 12 property chain to reference. This will be a expression pointing to a end property or field.</param>
        /// <param name="selector">The selector which will determine the final value from the properties.</param>
        /// <param name="isDistinct">if set to <c>true</c> [is distinct].</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyDynamic uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyDynamic may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyDynamic<TSender, TRet>(
                this TSender? sender,
                            Expression? property1,
                            Expression? property2,
                            Expression? property3,
                            Expression? property4,
                            Expression? property5,
                            Expression? property6,
                            Expression? property7,
                            Expression? property8,
                            Expression? property9,
                            Expression? property10,
                            Expression? property11,
                            Expression? property12,
                            Func<IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, IObservedChange<TSender?, object?>, TRet> selector,
                bool isDistinct)
        {
                        return Observable.CombineLatest(
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property1, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property2, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property3, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property4, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property5, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property6, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property7, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property8, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property9, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property10, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property11, false, false, isDistinct),
                                    ReactiveNotifyPropertyChangedMixin
                        .SubscribeToExpressionChain<TSender,object?>(sender, property12, false, false, isDistinct),
                                selector
            );
                    }
        }

    /// <summary>A mixin which provides support for subscribing to observable properties.</summary>
    public static class WhenAnyObservableMixin
    {
        /// <summary>Observe a observable which is set to a property, and automatically subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The first observable to observe.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1)
            where TSender : class
        {
            return sender.WhenAny(obs1, x => x.Value!.EmptyIfNull()).Switch();
        }

        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, (o1, o2) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, (o1, o2, o3) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, (o1, o2, o3, o4) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, (o1, o2, o3, o4, o5) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, (o1, o2, o3, o4, o5, o6) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, (o1, o2, o3, o4, o5, o6, o7) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs8">The 8 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7, Expression<Func<TSender, IObservable<TRet>?>> obs8)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, (o1, o2, o3, o4, o5, o6, o7, o8) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs8">The 8 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs9">The 9 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7, Expression<Func<TSender, IObservable<TRet>?>> obs8, Expression<Func<TSender, IObservable<TRet>?>> obs9)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, (o1, o2, o3, o4, o5, o6, o7, o8, o9) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs8">The 8 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs9">The 9 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs10">The 10 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7, Expression<Func<TSender, IObservable<TRet>?>> obs8, Expression<Func<TSender, IObservable<TRet>?>> obs9, Expression<Func<TSender, IObservable<TRet>?>> obs10)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs8">The 8 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs9">The 9 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs10">The 10 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs11">The 11 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7, Expression<Func<TSender, IObservable<TRet>?>> obs8, Expression<Func<TSender, IObservable<TRet>?>> obs9, Expression<Func<TSender, IObservable<TRet>?>> obs10, Expression<Func<TSender, IObservable<TRet>?>> obs11)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, obs11, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull(), o11.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs2">The 2 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs3">The 3 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs4">The 4 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs5">The 5 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs6">The 6 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs7">The 7 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs8">The 8 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs9">The 9 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs10">The 10 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs11">The 11 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        /// <param name="obs12">The 12 property chain to reference which ends with an observable. This will be a expression pointing to a end property or field which must be an observable.</param>
        #if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet>(this TSender? sender, Expression<Func<TSender, IObservable<TRet>?>> obs1, Expression<Func<TSender, IObservable<TRet>?>> obs2, Expression<Func<TSender, IObservable<TRet>?>> obs3, Expression<Func<TSender, IObservable<TRet>?>> obs4, Expression<Func<TSender, IObservable<TRet>?>> obs5, Expression<Func<TSender, IObservable<TRet>?>> obs6, Expression<Func<TSender, IObservable<TRet>?>> obs7, Expression<Func<TSender, IObservable<TRet>?>> obs8, Expression<Func<TSender, IObservable<TRet>?>> obs9, Expression<Func<TSender, IObservable<TRet>?>> obs10, Expression<Func<TSender, IObservable<TRet>?>> obs11, Expression<Func<TSender, IObservable<TRet>?>> obs12)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, obs11, obs12, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11, o12) => new[] {o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull(), o11.Value!.EmptyIfNull(), o12.Value!.EmptyIfNull()})
                .Select(x => x.Merge()).Switch();
        }

        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Func<T1?, T2?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, (o1, o2) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Func<T1?, T2?, T3?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, (o1, o2, o3) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Func<T1?, T2?, T3?, T4?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, (o1, o2, o3, o4) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Func<T1?, T2?, T3?, T4?, T5?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, (o1, o2, o3, o4, o5) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, (o1, o2, o3, o4, o5, o6) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, (o1, o2, o3, o4, o5, o6, o7) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="obs8">The 8 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Expression<Func<TSender, IObservable<T8>?>> obs8,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, T8?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, (o1, o2, o3, o4, o5, o6, o7, o8) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="obs8">The 8 property chain to reference.</param>
        /// <param name="obs9">The 9 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Expression<Func<TSender, IObservable<T8>?>> obs8,
                            Expression<Func<TSender, IObservable<T9>?>> obs9,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, T8?, T9?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, (o1, o2, o3, o4, o5, o6, o7, o8, o9) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="obs8">The 8 property chain to reference.</param>
        /// <param name="obs9">The 9 property chain to reference.</param>
        /// <param name="obs10">The 10 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Expression<Func<TSender, IObservable<T8>?>> obs8,
                            Expression<Func<TSender, IObservable<T9>?>> obs9,
                            Expression<Func<TSender, IObservable<T10>?>> obs10,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, T8?, T9?, T10?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="obs8">The 8 property chain to reference.</param>
        /// <param name="obs9">The 9 property chain to reference.</param>
        /// <param name="obs10">The 10 property chain to reference.</param>
        /// <param name="obs11">The 11 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Expression<Func<TSender, IObservable<T8>?>> obs8,
                            Expression<Func<TSender, IObservable<T9>?>> obs9,
                            Expression<Func<TSender, IObservable<T10>?>> obs10,
                            Expression<Func<TSender, IObservable<T11>?>> obs11,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, T8?, T9?, T10?, T11?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, obs11, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull(), o11.Value!.EmptyIfNull(), selector))
                .Switch();
        }
        /// <summary>Monitor a property that is an observable, and subscribe to the most recent emitted value.</summary>
        /// <param name="sender">The object where the property chain starts.</param>
        /// <param name="obs1">The 1 property chain to reference.</param>
        /// <param name="obs2">The 2 property chain to reference.</param>
        /// <param name="obs3">The 3 property chain to reference.</param>
        /// <param name="obs4">The 4 property chain to reference.</param>
        /// <param name="obs5">The 5 property chain to reference.</param>
        /// <param name="obs6">The 6 property chain to reference.</param>
        /// <param name="obs7">The 7 property chain to reference.</param>
        /// <param name="obs8">The 8 property chain to reference.</param>
        /// <param name="obs9">The 9 property chain to reference.</param>
        /// <param name="obs10">The 10 property chain to reference.</param>
        /// <param name="obs11">The 11 property chain to reference.</param>
        /// <param name="obs12">The 12 property chain to reference.</param>
        /// <param name="selector">The selector which will determine the final value from the properties. This must be an observable.</param>
#if NET6_0_OR_GREATER
        [RequiresDynamicCode("WhenAnyObservable uses expression trees which require dynamic code generation in AOT scenarios.")]
        [RequiresUnreferencedCode("WhenAnyObservable may reference members that could be trimmed in AOT scenarios.")]
#endif
        public static IObservable<TRet> WhenAnyObservable<TSender, TRet, T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12>(this TSender? sender,
                            Expression<Func<TSender, IObservable<T1>?>> obs1,
                            Expression<Func<TSender, IObservable<T2>?>> obs2,
                            Expression<Func<TSender, IObservable<T3>?>> obs3,
                            Expression<Func<TSender, IObservable<T4>?>> obs4,
                            Expression<Func<TSender, IObservable<T5>?>> obs5,
                            Expression<Func<TSender, IObservable<T6>?>> obs6,
                            Expression<Func<TSender, IObservable<T7>?>> obs7,
                            Expression<Func<TSender, IObservable<T8>?>> obs8,
                            Expression<Func<TSender, IObservable<T9>?>> obs9,
                            Expression<Func<TSender, IObservable<T10>?>> obs10,
                            Expression<Func<TSender, IObservable<T11>?>> obs11,
                            Expression<Func<TSender, IObservable<T12>?>> obs12,
                            Func<T1?, T2?, T3?, T4?, T5?, T6?, T7?, T8?, T9?, T10?, T11?, T12?, TRet> selector)
            where TSender : class
        {
            return sender.WhenAny(obs1, obs2, obs3, obs4, obs5, obs6, obs7, obs8, obs9, obs10, obs11, obs12, (o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11, o12) => Observable.CombineLatest(o1.Value!.EmptyIfNull(), o2.Value!.EmptyIfNull(), o3.Value!.EmptyIfNull(), o4.Value!.EmptyIfNull(), o5.Value!.EmptyIfNull(), o6.Value!.EmptyIfNull(), o7.Value!.EmptyIfNull(), o8.Value!.EmptyIfNull(), o9.Value!.EmptyIfNull(), o10.Value!.EmptyIfNull(), o11.Value!.EmptyIfNull(), o12.Value!.EmptyIfNull(), selector))
                .Switch();
        }
}

    internal static class ObservableExtensions
    {
        public static IObservable<T> EmptyIfNull<T>(this IObservable<T> @this)
        {
            return @this ?? Observable.Empty<T>();
        }
    }
}
