// Copyright (c) 2025 .NET Foundation and Contributors. All rights reserved.
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for full license information.

namespace ReactiveUI;

/// <summary>
/// A suspension driver that does not do anything.
/// Useful potentially for unit testing or for platforms
/// where you don't want to use a Suspension Driver.
/// </summary>
public class DummySuspensionDriver : ISuspensionDriver
{
    /// <inheritdoc/>
#if NET6_0_OR_GREATER
    [RequiresDynamicCode("LoadState uses methods that require dynamic code generation")]
    [RequiresUnreferencedCode("LoadState uses methods that may require unreferenced code")]
#endif
    public IObservable<object> LoadState() => // TODO: Create Test
        Observable<object>.Default;

    /// <inheritdoc/>
#if NET6_0_OR_GREATER
    [RequiresDynamicCode("SaveState uses methods that require dynamic code generation")]
    [RequiresUnreferencedCode("SaveState uses methods that may require unreferenced code")]
#endif
    public IObservable<Unit> SaveState(object state) => // TODO: Create Test
        Observables.Unit;

    /// <inheritdoc/>
#if NET6_0_OR_GREATER
    [RequiresDynamicCode("InvalidateState uses methods that require dynamic code generation")]
    [RequiresUnreferencedCode("InvalidateState uses methods that may require unreferenced code")]
#endif
    public IObservable<Unit> InvalidateState() => // TODO: Create Test
        Observables.Unit;
}
