/*
 * PROJECT:     ReactOS Setup Library
 * LICENSE:     GPL-2.0+ (https://spdx.org/licenses/GPL-2.0+)
 * PURPOSE:     Setup error codes
 * COPYRIGHT:   Copyright 2007-2018 Johannes Anderwald <johannes.anderwald@reactos.org>
 */

#pragma once

/* setupapi.h defines ERROR_NOT_INSTALLED with another meaning */
#ifdef ERROR_NOT_INSTALLED
#undef ERROR_NOT_INSTALLED
#endif

typedef enum _ERROR_NUMBER
{
    NOT_AN_ERROR = 0,   // ERROR_SUCCESS,
    ERROR_NOT_INSTALLED,
    ERROR_NO_BUILD_PATH,
    ERROR_SOURCE_PATH,
    ERROR_SOURCE_DIR,
    ERROR_NO_HDD,
    ERROR_NO_SOURCE_DRIVE,
    ERROR_LOAD_TXTSETUPSIF,
    ERROR_CORRUPT_TXTSETUPSIF,
    ERROR_SIGNATURE_TXTSETUPSIF,
    ERROR_DRIVE_INFORMATION,
    ERROR_WRITE_BOOT,
    ERROR_LOAD_COMPUTER,
    ERROR_LOAD_DISPLAY,
    ERROR_LOAD_KEYBOARD,
    ERROR_LOAD_KBLAYOUT,
    ERROR_WARN_PARTITION,
    ERROR_NEW_PARTITION,
    ERROR_DELETE_SPACE,
    ERROR_INSTALL_BOOTCODE,
    ERROR_NO_FLOPPY,
    ERROR_UPDATE_KBSETTINGS,
    ERROR_UPDATE_DISPLAY_SETTINGS,
    ERROR_IMPORT_HIVE,
    ERROR_FIND_REGISTRY,
    ERROR_CREATE_HIVE,
    ERROR_INITIALIZE_REGISTRY,
    ERROR_INVALID_CABINET_INF,
    ERROR_CABINET_MISSING,
    ERROR_CABINET_SCRIPT,
    ERROR_COPY_QUEUE,
    ERROR_CREATE_DIR,
    ERROR_TXTSETUP_SECTION,
    ERROR_CABINET_SECTION,
    ERROR_CREATE_INSTALL_DIR,
    ERROR_WRITE_PTABLE,
    ERROR_ADDING_CODEPAGE,
    ERROR_UPDATE_LOCALESETTINGS,
    ERROR_ADDING_KBLAYOUTS,
    ERROR_UPDATE_GEOID,
    ERROR_DIRECTORY_NAME,
    ERROR_INSUFFICIENT_PARTITION_SIZE,
    ERROR_PARTITION_TABLE_FULL,
    ERROR_ONLY_ONE_EXTENDED,
    ERROR_FORMATTING_PARTITION,

    ERROR_LAST_ERROR_CODE
} ERROR_NUMBER;

/* EOF */
