/*
 *  ReactOS kernel
 *  Copyright (C) 2002 ReactOS Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
/*
 * COPYRIGHT:       See COPYING in the top level directory
 * PROJECT:         ReactOS text-mode setup
 * FILE:            base/setup/usetup/inffile.h
 * PURPOSE:         Interfacing with Setup* API .INF Files support functions
 * PROGRAMMERS:     Hervé Poussineau
 *                  Hermes Belusca-Maito (hermes.belusca@sfr.fr)
 */

#pragma once

#ifdef __REACTOS__

// HACK around the fact INFLIB unconditionally defines MAX_INF_STRING_LENGTH.
#undef MAX_INF_STRING_LENGTH

/* Functions from the INFLIB library */
// #include <infcommon.h>
#include <infros.h>

#undef MAX_INF_STRING_LENGTH
#define MAX_INF_STRING_LENGTH   1024

extern VOID InfSetHeap(PVOID Heap);

#endif /* __REACTOS__ */

// #include "../lib/utils/infsupp.h"


/* HELPER FUNCTIONS **********************************************************/

HINF WINAPI
INF_OpenBufferedFileA(
    IN  PSTR FileBuffer,
    IN  ULONG FileSize,
    IN  PCSTR InfClass,
    IN  DWORD InfStyle,
    IN  LCID LocaleId,
    OUT PUINT ErrorLine);

/* EOF */
